<?php // phpcs:ignore
/**
 * Accordion with instructions on how to get Google Cloud credentials.
 *
 * @package snapshot
 */

?>
<div class="sui-accordion sui-accordion-flushed snapshot-googlecloud-credentials-howto" style="display: none;">

	<div class="sui-accordion-item">

		<div class="sui-accordion-item-header">
			<div class="sui-accordion-item-title" style="flex: auto;"><i aria-hidden="true" class="sui-icon-warning-alert" style=" font-size: 12px; "></i>
			<?php esc_html_e( 'How to get Google Cloud credentials?', 'snapshot' ); ?>
			</div>

			<div>
				<button class="sui-button-icon sui-accordion-open-indicator" aria-label="Open item"><i class="sui-icon-chevron-down" aria-hidden="true"></i></button>
			</div>
		</div>

		<div class="sui-accordion-item-body">
			<div class="sui-box">
				<div class="sui-box-body">
					<?php /* translators: %s - PHP version */ ?>
					<p class="sui-description"><strong><?php esc_html_e( 'Follow these instructions to retrieve the Client ID and Client Secret.', 'snapshot' ); ?></strong></p>

						<ol style=" margin-left: 0px; list-style-position: inside; ">
							<?php /* translators: %s - Link for Google Cloud login docs */ ?>
							<li><?php echo wp_kses_post( sprintf( __( 'Go to the <a href="%s" target="_blank">Google API Console</a>.', 'snapshot' ), 'https://cloud.google.com/' ) ); ?></li>
							<li><?php echo wp_kses_post( __( 'Select an existing project or create a new one. If you are creating a new project, you will need to enter a name, but the ID is not important and can be ignored.', 'snapshot' ) ); ?></li>
							<li><?php echo wp_kses_post( __( 'Once the Project creation is completed, go to the API’s & Services section. Here you need to enable the <strong>Google Cloud Data Catalog API</strong>.', 'snapshot' ) ); ?></li>
							<li><?php echo wp_kses_post( __( 'Once the API has been enabled, go to the <strong>API’s & Services> Credentials</strong> section.', 'snapshot' ) ); ?>
								<ol style=" list-style-position: inside; ">
									<li><?php echo wp_kses_post( __( 'Click <strong>Create Credentials > OAuth 2.0 client ID</strong>.', 'snapshot' ) ); ?></li>
									<li><?php echo wp_kses_post( __( 'In the dropdown, select the Application Type as <strong>Web application</strong>.', 'snapshot' ) ); ?></li>
									<li><?php echo wp_kses_post( __( 'Then click the <strong>Create</strong> button at the bottom of the screen.', 'snapshot' ) ); ?></li>
									<li><?php echo wp_kses_post( __( 'You will see <strong>Client ID and Client Secret</strong> in the popup. Copy those and paste into the form fields above.', 'snapshot' ) ); ?></li>
								</ol>
							</li>
							<li><?php echo wp_kses_post( __( 'If you have already created a project, the Client information is available in <strong>APIs & Services/Credentials/OAuth 2.0 Client IDs/Project</strong>. After clicking on the project, you will see the Client Secret and ID.', 'snapshot' ) ); ?></li>
						</ol>
				</div>

			</div>
		</div>

	</div>
</div>