<?php // phpcs:ignore
/**
 * Accordion with instructions on how to get Backblaze credentials.
 *
 * @package snapshot
 */

?>
<div class="sui-accordion sui-accordion-flushed snapshot-backblaze-credentials-howto" style="display: none;">

	<div class="sui-accordion-item">

		<div class="sui-accordion-item-header">
			<div class="sui-accordion-item-title" style="flex: auto;"><i aria-hidden="true" class="sui-icon-warning-alert" style=" font-size: 12px; "></i>
			<?php esc_html_e( 'How to get Backblaze credentials?', 'snapshot' ); ?>
			</div>

			<div>
				<button class="sui-button-icon sui-accordion-open-indicator" aria-label="Open item"><i class="sui-icon-chevron-down" aria-hidden="true"></i></button>
			</div>
		</div>

		<div class="sui-accordion-item-body">
			<div class="sui-box">
				<div class="sui-box-body">
					<?php /* translators: %s - PHP version */ ?>
					<p class="sui-description"><strong><?php esc_html_e( 'Follow these instructions to retrieve the Backblaze credentials.', 'snapshot' ); ?></strong></p>

						<ol style=" margin-left: 0px; list-style-position: inside; ">
							<?php /* translators: %s - Link for Backblaze login */ ?>
							<li><?php echo wp_kses_post( sprintf( __( '<a href="%s" target="_blank">Sign in</a> to your Blackbaze account.', 'snapshot' ), 'https://secure.backblaze.com/user_signin.htm' ) ); ?></li>
							<li><?php echo wp_kses_post( __( 'Go to <strong>My account/Buckets</strong> section.', 'snapshot' ) ); ?></li>
							<li><?php echo wp_kses_post( __( 'Go to <strong>App Keys</strong> and click <strong>Generate New Master Application Key</strong>.', 'snapshot' ) ); ?></li>
							<li><?php echo wp_kses_post( __( 'You will then be asked if you are sure you want to generate a new key. Click <strong>Yes! Generate Master Key</strong>.', 'snapshot' ) ); ?></li>
							<li><?php echo wp_kses_post( __( 'This will generate your credentials. Use the <strong>keyID</strong> and <strong>applicationKey</strong> to connect your Backblaze destination.', 'snapshot' ) ); ?></li>
						</ol>

				</div>

			</div>
		</div>

	</div>
</div>