<?php // phpcs:ignore
/**
 * Third screen of Add Destination modal - S3.
 *
 * @package snapshot
 */

?>
<div class="sui-modal-slide sui-loaded" id="snapshot-add-destination-dialog-slide-4" data-modal-size="md">
	<div class="sui-box">

		<div class="sui-box-header sui-flatten sui-content-center sui-spacing-top--60">

			<figure class="sui-box-logo" aria-hidden="true">
				<img
					src="<?php echo esc_attr( $assets->get_asset( 'img/header-logo-aws.png' ) ); ?>"
					srcset="<?php echo esc_attr( $assets->get_asset( 'img/header-logo-aws.png' ) ); ?> 1x, <?php echo esc_attr( $assets->get_asset( 'img/header-logo-aws@2x.png' ) ); ?> 2x"
				/>
			</figure>

			<button class="sui-button-icon sui-button-float--right" data-modal-close>
				<i class="sui-icon-close sui-md" aria-hidden="true"></i>
			</button>

			<h3 class="sui-box-title sui-lg"><?php echo esc_html( __( 'Connect S3', 'snapshot' ) ); ?></h3>
			<?php /* translators: %s - span class */ ?>
			<span class="sui-description"><?php echo wp_kses_post( __( 'Lastly, give the destination a name so you can easily identify it.', 'snapshot' ) ); ?></span>

			<button class="sui-button-icon sui-button-float--left" data-modal-slide="snapshot-add-destination-dialog-slide-3">
				<i class="sui-icon-chevron-left sui-md" aria-hidden="true"></i>
				<span class="sui-screen-reader-text"><?php esc_html_e( 'Back' ); ?></span>
			</button>

		</div>

		<div class="sui-box-body">

			<div role="alert" id="snapshot-save-failure" class="sui-notice sui-notice-error" aria-live="assertive" style="display:none;">

				<div class="sui-notice-content">

					<div class="sui-notice-message">

						<span class="sui-notice-icon sui-icon-info sui-md" aria-hidden="true"></span>

						<?php /* translators: %s - Link for support */ ?>
						<p><?php echo esc_html( __( 'We couldn\'t save the destination, as error occurred while setting up your account. Please re-check your account configurations again to complete the set up.', 'snapshot' ) ); ?></p>

						<button role="button" class="sui-button" data-modal-slide="snapshot-add-destination-dialog-slide-2" style=" padding: 5px 14px; margin-left: 26px; ">
							<?php echo esc_html( __( 'Re-check set up', 'snapshot' ) ); ?>
						</button>

					</div>

				</div>

			</div>

			<form method="post" id="snapshot-save-s3">
				<input type="hidden" name="tpd_action" value="test_connection_bucket">
				<input type="hidden" name="tpd_accesskey" value="">
				<input type="hidden" name="tpd_secretkey" value="">
				<input type="hidden" name="tpd_region" value="">
				<input type="hidden" name="tpd_path" value="">
				<input type="hidden" name="tpd_limit" value="">
				<input type="hidden" name="tpd_name" value="">
				<input type="hidden" name="tpd_save" value="1">
				<input type="hidden" name="tpd_type" value="">

				<div class="sui-form-field">
					<label for="s3-save-name" id="label-s3-save-name" class="sui-label">
						<?php echo esc_html( __( 'Destination Name', 'snapshot' ) ); ?><span style="margin-left: 3px; "><?php echo esc_html( '*' ); ?></span>
					</label>

					<input
						value="S3/Amazon"
						id="s3-save-name"
						name="tpd_name"
						class="sui-form-control"
						aria-labelledby="label-s3-save-name"
					/>

					<span id="error-s3-save-name" class="sui-error-message" style="display: none;" role="alert"></span>
				</div>
			</form>
		</div>

		<div class="sui-box-footer sui-lg sui-content-separated">

			<button class="sui-button sui-button-ghost" data-modal-slide="snapshot-add-destination-dialog-slide-3" >
				<i class="sui-icon-arrow-left" aria-hidden="true"></i>
				<?php esc_html_e( 'Back' ); ?>
			</button>

			<button class="sui-button sui-button-blue" id="snapshot-submit-save-s3" >
				<span class="sui-button-text-default">
					<i class="sui-icon-check" aria-hidden="true"></i>
					<?php esc_html_e( 'Save Destination' ); ?>
				</span>
				<span class="sui-button-text-onload">
					<i class="sui-icon-loader sui-loading" aria-hidden="true"></i>
					<?php esc_html_e( 'Loading...' ); ?>
				</span>
			</button>

		</div>

	</div>
</div>