<?php // phpcs:ignore
/**
 * Modal for destination edit.
 *
 * @package snapshot
 */

use WPMUDEV\Snapshot4\Helper;
use WPMUDEV\Snapshot4\Task;

$assets = new Helper\Assets();

wp_nonce_field( 'snapshot_update_destination', '_wpnonce-snapshot-update-destination' );

?>
<div class="sui-modal sui-modal-md">
	<div
		role="dialog"
		id="modal-destination-edit"
		class="sui-modal-content"
		aria-modal="true"
		aria-labelledby="modal-destination-edit-title"
		aria-describedby="modal-destination-edit-description"
	>
		<div class="sui-box">

			<div class="sui-box-header sui-flatten sui-content-center sui-spacing-top--60">

				<figure class="sui-box-logo" aria-hidden="true">
					<img
						src="<?php echo esc_attr( $assets->get_asset( 'img/header-logo-aws.png' ) ); ?>"
						srcset="<?php echo esc_attr( $assets->get_asset( 'img/header-logo-aws.png' ) ); ?> 1x, <?php echo esc_attr( $assets->get_asset( 'img/header-logo-aws@2x.png' ) ); ?> 2x"
					/>
				</figure>

				<button class="sui-button-icon sui-button-float--right" data-modal-close>
					<i class="sui-icon-close sui-md" aria-hidden="true"></i>
				</button>

				<h3 class="sui-box-title sui-lg"><?php echo wp_kses_post( __( 'Configure Amazon S3', 'snapshot' ) ); ?></h3>

			</div>

			<div class="sui-box-body">

					<div role="alert" class="sui-notice sui-notice-success" aria-live="assertive" id="notice-edit-destination-success">
						<div class="sui-notice-content">
							<div class="sui-notice-message">
								<span class="sui-notice-icon sui-icon-info sui-md" aria-hidden="true"></span>
								<p><?php esc_html_e( 'Destination has been updated successfully.', 'snapshot' ); ?></p>
							</div>
							<div class="sui-notice-actions">
								<button class="sui-button-icon hide-notice">
									<i class="sui-icon-check" aria-hidden="true"></i>
									<span class="sui-screen-reader-text"><?php esc_html_e( 'Close this notice', 'snapshot' ); ?></span>
								</button>
							</div>
						</div>
					</div>

					<div role="alert" class="sui-notice sui-notice-error" aria-live="assertive" id="notice-edit-destination-error">
						<div class="sui-notice-content">
							<div class="sui-notice-message">
								<span class="sui-notice-icon sui-icon-info sui-md" aria-hidden="true"></span>
								<p><?php esc_html_e( 'Error occurred while updated the Destination. Please double-check all credentials are correct and try again.', 'snapshot' ); ?></p>
							</div>
							<div class="sui-notice-actions">
								<button class="sui-button-icon hide-notice">
									<i class="sui-icon-check" aria-hidden="true"></i>
									<span class="sui-screen-reader-text"><?php esc_html_e( 'Close this notice', 'snapshot' ); ?></span>
								</button>
							</div>
						</div>
					</div>

					<form method="post" id="snapshot-edit-s3-connection">
						<input type="hidden" name="tpd_action" value="update_destination">
						<input type="hidden" name="tpd_id">
						<input type="hidden" name="tpd_region">
						<input type="hidden" name="tpd_type">

						<div class="sui-form-field">
							<label for="edit-s3-connection-name" id="label-edit-s3-connection-name" class="sui-label">
								<?php echo esc_html( __( 'Destination Name', 'snapshot' ) ); ?><span style="margin-left: 3px;"><?php echo esc_html( '*' ); ?>
							</label>

							<input
								placeholder="<?php esc_attr_e( 'Place Destination Name here', 'snapshot' ); ?>"
								id="edit-s3-connection-name"
								class="sui-form-control"
								name="tpd_name"
								aria-labelledby="label-edit-s3-connection-name"
							/>
							<span id="error-edit-s3-connection-name" class="sui-error-message" style="display: none; text-align: right;" role="alert"></span>
						</div>

						<div class="sui-form-field">
							<label for="edit-s3-connection-bucket" id="label-edit-s3-connection-bucket" class="sui-label">
								<?php echo esc_html( __( 'Choose Bucket', 'snapshot' ) ); ?><span style="margin-left: 3px;"><?php echo esc_html( '*' ); ?>
							</label>

							<select id="edit-s3-connection-bucket" class="sui-select" aria-labelledby="label-edit-s3-connection-bucket" name="tpd_bucket">
								<option></option>
							</select>

							<span id="error-edit-s3-connection-bucket" class="sui-error-message" style="display: none; text-align:right;" role="alert"></span>
						</div>

						<div class="sui-form-field">
							<label for="edit-s3-connection-path" id="label-edit-s3-connection-path" class="sui-label">
								<?php echo esc_html( __( 'Directory Path', 'snapshot' ) ); ?><span style="margin-left: 3px; "><?php echo esc_html( '*' ); ?></span>
							</label>

							<input
								placeholder="<?php esc_attr_e( 'Place Directory Path here', 'snapshot' ); ?>"
								id="edit-s3-connection-path"
								class="sui-form-control"
								name="tpd_path"
								aria-labelledby="label-edit-s3-connection-path"
							/>
							<span id="error-edit-s3-connection-path" class="sui-error-message" style="display: none; text-align: right;" role="alert"></span>
						</div>

						<div class="sui-form-field">
							<label for="edit-s3-connection-access-key-id" id="label-edit-s3-connection-access-key-id" class="sui-label">
								<?php echo esc_html( __( 'AWS Access Key ID', 'snapshot' ) ); ?><span style="margin-left: 3px; "><?php echo esc_html( '*' ); ?></span>
							</label>

							<input
								placeholder="<?php esc_attr_e( 'Place Access Key ID here', 'snapshot' ); ?>"
								id="edit-s3-connection-access-key-id"
								class="sui-form-control"
								name="tpd_accesskey"
								aria-labelledby="label-edit-s3-connection-access-key-id"
							/>
							<span id="error-edit-s3-connection-access-key-id" class="sui-error-message" style="display: none; text-align: right;" role="alert"></span>

						</div>

						<div class="sui-form-field">
							<label for="edit-s3-connection-secret-access-key" id="label-edit-s3-connection-secret-access-key" class="sui-label">
								<?php echo esc_html( __( 'AWS Secret Access Key', 'snapshot' ) ); ?><span style=" margin-left: 3px; "><?php echo esc_html( '*' ); ?></span>
							</label>

							<input
								placeholder="<?php esc_attr_e( 'Place Secret Access Key here', 'snapshot' ); ?>"
								id="edit-s3-connection-secret-access-key"
								class="sui-form-control"
								name="tpd_secretkey"
								aria-labelledby="label-edit-s3-connection-secret-access-key"
							/>
							<span id="error-edit-s3-connection-secret-access-key" class="sui-error-message" style="display: none; text-align: right;" role="alert"></span>
						</div>

						<div class="sui-form-field">
							<label for="edit-s3-connection-limit" id="label-edit-s3-connection-limit" class="sui-label">
								<?php echo esc_html( __( 'Backup Storage Limit', 'snapshot' ) ); ?><span style="margin-left: 3px;"><?php echo esc_html( '*' ); ?>
							</label>

							<input
								type="number"
								min="1"
								id="edit-s3-connection-limit"
								class="sui-form-control sui-input-sm"
								name="tpd_limit"
								aria-labelledby="label-edit-s3-connection-limit"
								aria-describedby="error-edit-s3-connection-limit description-edit-s3-connection-limit"
								value=""
							/>

							<span id="error-edit-s3-connection-limit" class="sui-error-message" style="display: none;" role="alert"></span>
							<span id="description-edit-s3-connection-limit" class="sui-description"><?php echo esc_html_e( 'Set the number of exported backups you want to store in the third-party destination before removing the older ones. It must be greater than 0.', 'snapshot' ); ?></span>
						</div>

					</form>

			</div>

			<div class="sui-box-footer sui-lg sui-content-separated">
				<button class="sui-button sui-button-ghost sui-button-red delete-button">
					<i class="sui-icon-trash" aria-hidden="true"></i>
					<?php esc_html_e( 'Delete', 'snapshot' ); ?>
				</button>

				<button class="sui-button sui-button-blue save-button">
					<span class="sui-button-text-default">
						<i class="sui-icon-save" aria-hidden="true"></i>
						<?php esc_html_e( 'Save changes', 'snapshot' ); ?>
					</span>

					<span class="sui-button-text-onload">
						<i class="sui-icon-loader sui-loading" aria-hidden="true"></i>
						<?php esc_html_e( 'Saving...', 'snapshot' ); ?>
					</span>
				</button>
			</div>

		</div>
	</div>
</div>