<?php // phpcs:ignore
/**
 * API helper class
 *
 * @package snapshot
 */

namespace WPMUDEV\Snapshot4\Helper;

/**
 * Helper class
 */
class Api {

	/**
	 * Gets the API key using Dashboard's method.
	 *
	 * @return string
	 */
	public static function get_api_key() {
		global $wpmudev_un;

		if ( ! is_object( $wpmudev_un ) && class_exists( 'WPMUDEV_Dashboard' ) && method_exists( 'WPMUDEV_Dashboard', 'instance' ) ) {
			$wpmudev_un = \WPMUDEV_Dashboard::instance();
		}

		if ( is_object( $wpmudev_un ) && method_exists( $wpmudev_un, 'get_apikey' ) ) {
			$api_key = $wpmudev_un->get_apikey();
		} elseif ( class_exists( 'WPMUDEV_Dashboard' ) && is_object( \WPMUDEV_Dashboard::$api ) && method_exists( \WPMUDEV_Dashboard::$api, 'get_key' ) ) {
			$api_key = \WPMUDEV_Dashboard::$api->get_key();
		} else {
			$api_key = '';
		}

		return $api_key;
	}

	/**
	 * Gets site's id.
	 *
	 * @return int
	 */
	public static function get_site_id() {
		$site_id = get_site_option( 'wpmudev_site_id' );

		if ( empty( $site_id ) ) {
			global $wpmudev_un;

			if ( ! is_object( $wpmudev_un ) && class_exists( 'WPMUDEV_Dashboard' ) && method_exists( 'WPMUDEV_Dashboard', 'instance' ) ) {
				$wpmudev_un = \WPMUDEV_Dashboard::instance();
			}

			if ( is_object( $wpmudev_un ) && method_exists( $wpmudev_un, 'get_site_id' ) ) {
				$site_id = $wpmudev_un->get_site_id();
			} elseif ( class_exists( 'WPMUDEV_Dashboard' ) && is_object( \WPMUDEV_Dashboard::$api ) && method_exists( \WPMUDEV_Dashboard::$api, 'get_site_id' ) ) {
				$site_id = \WPMUDEV_Dashboard::$api->get_site_id();
			} else {
				$site_id = '';
			}
		}

		if ( empty( $site_id ) ) {
			Log::error( __( 'The site doesn\'t seem to have an ID assigned. Try login into the WPMU DEV Dashboard again.', 'snapshot' ) );
		}

		return apply_filters( 'wp_snapshot_site_id', $site_id );
	}
}