/**
 * Page: Destinations.
 */
;(function($) {
	var snapshot_final_form = $('#snapshot-save-s3'),
		snapshot_middle_form = $('#snapshot-add-s3-info');

	var destination_backup_count = {};

	function load_backup_count() {
		$.ajax({
			url: ajaxurl,
			type: 'POST',
			data: {
				action: 'snapshot-list_backups',
				_wpnonce: $( '#_wpnonce-list-backups' ).val(),
			},
			cache: false,
            dataType: 'json',
			beforeSend: function () {
				$('.snapshot-loading').show();
			},
			complete: function () {
				$('.snapshot-loading').hide();
			},
			success: function (data) {
				if (!data.success) {
					return;
				}
				$('.snapshot-page-destinations .wpmudev-backup-count').text(data.data.backup_count);
				destination_backup_count = data.data.destination_backup_count || {};
				update_destination_backup_counts();
			}
		});
	}

	function get_current_storage() {
		var data = {};

		data._wpnonce = $( '#_wpnonce-snapshot_get_storage' ).val();

		var url = ajaxurl + '?action=snapshot-get_storage';

		$.ajax({
			type: 'POST',
			url: url,
			data: data,
			cache: false,
			dataType: 'json',
			success: function (response) {
				if (response.success) {
					$('.snapshot-storage-loading').hide();
					$('.wpmudev-snapshot-storage span').css({"width": response.data.width});
					$('.wpmudev-snapshot-storage').show();
					$('.snapshot-current-stats .used-space').html(response.data.current_stats);
					$('.snapshot-current-stats .used-space').show();
				}
			}
		});

		return false;
	}

	/**
	 * Handles AJAX for testing connection.
	 */
	function destination_test_connection() {
		// Hide any older error notices about data validation.
		hide_errors_test_connection();

		// Prepare the data to be sent for testing the connection.
		var data = {};
		var abort_test_connection = false;
		$(this).serializeArray().forEach(function (item) {
			data[item.name] = item.value;
		});
		data._wpnonce = $( '#_wpnonce-snapshot_s3_connection' ).val();

		// Check if we're testing AWS or S3 compatible, so we can show the appropriate errors.
		var destination_type;
		if (check_if_on_aws()) {
			destination_type = 's3';
		} else {
			destination_type = 's3-compatible';
			// Check if provider has been selected, if not show error notice.
			if( ! $('#s3-compatible-connection-provider').find(':selected').val() ) {
				$('#error-s3-compatible-connection-provider').show();
				$('#error-s3-compatible-connection-provider').html(snapshot_messages.required_provider);
				$('#error-s3-compatible-connection-provider').closest('.sui-form-field').find('.select2-selection.select2-selection--single').addClass('snapshot-error-select');
				abort_test_connection = true;
			}
		}

		if(!data['tpd_secretkey'].trim()) {
			$('#error-'+destination_type+'-connection-secret-access-key').show();
			$('#error-'+destination_type+'-connection-secret-access-key').html(snapshot_messages.required_s3_cred.replace('%s', $('.'+destination_type+'-connection-secret-access-key-label').text() ));
			$('#error-'+destination_type+'-connection-secret-access-key').closest('.sui-form-field').addClass('sui-form-field-error');
			$('#'+destination_type+'-connection-secret-access-key').focus();

			abort_test_connection = true;
		}

		if(!data['tpd_accesskey'].trim()) {
			$('#error-'+destination_type+'-connection-access-key-id').show();
			$('#error-'+destination_type+'-connection-access-key-id').html(snapshot_messages.required_s3_cred.replace('%s', $('.'+destination_type+'-connection-access-key-id-label').text() ));
			$('#error-'+destination_type+'-connection-access-key-id').closest('.sui-form-field').addClass('sui-form-field-error');
			$('#'+destination_type+'-connection-access-key-id').focus();

			abort_test_connection = true;
		}

		if(!data['tpd_region'].trim()) {
			$('#error-'+destination_type+'-connection-region').show();
			$('#error-'+destination_type+'-connection-region').html(snapshot_messages.required_s3_cred.replace('%s', $('.'+destination_type+'-connection-region-label').text() ));

			if (destination_type==='s3') {
				$('#error-'+destination_type+'-connection-region').closest('.sui-form-field').find('.select2-selection.select2-selection--single').addClass('snapshot-error-select');
			} else {
				$('#error-'+destination_type+'-connection-region').closest('.sui-form-field').addClass('sui-form-field-error');
			}

			abort_test_connection = true;
		}

		if (abort_test_connection) {
			return false;
		}

		// Actually test the connection.
        $.ajax({
            type: 'POST',
            url: ajaxurl + '?action=snapshot-s3_connection',
            data: data,
            beforeSend: function () {
				$('#snapshot-submit-connection-test').removeClass('sui-button-icon-right', true);
				$('#snapshot-submit-connection-test').addClass('sui-button-onload-text', true);

				$('#snapshot-wrong-s3-creds').hide();
				$('#snapshot-wrong-s3-compatible-creds').hide();
				$('#snapshot-region-no-buckets').hide();
				$('#snapshot-region-no-buckets-s3-compatible').hide();
            },
			complete: function () {
				$('#snapshot-submit-connection-test').addClass('sui-button-icon-right', true);
				$('#snapshot-submit-connection-test').removeClass('sui-button-onload-text', true);
			},
            success: function (response) {
                if (response.success) {
					var selectedProvider = $('#s3-compatible-connection-provider').find(':selected').val();
					if (selectedProvider) {
						selectedProviderLink = snapshot_s3_providers[selectedProvider].link,
						selectedProviderName = snapshot_s3_providers[selectedProvider].providerName;
					}

					if (response.data.api_response.length > 0) {
						var buckets_dropdown = $("#s3-details-bucket");
						buckets_dropdown.empty();
						buckets_dropdown.append($("<option />"));
						$.each(response.data.api_response, function(val, text) {
							buckets_dropdown.append($("<option />").val(text).text(text));
						});
	
						buckets_dropdown.SUIselect2( {
							placeholder: snapshot_messages.choose_bucket,
							dropdownCssClass: 'sui-select-dropdown',
							dropdownParent: snapshot_middle_form
						} );
	
						// Since the connection is good, pass the data to the final step.
						snapshot_final_form.find("[name='tpd_accesskey']").val(data['tpd_accesskey']);
						snapshot_final_form.find("[name='tpd_secretkey']").val(data['tpd_secretkey']);
						snapshot_final_form.find("[name='tpd_region']").val(data['tpd_region']);
						snapshot_final_form.find("[name='tpd_type']").val(data['tpd_type']);
	
						//Also pass the data to the intermediate step.
						snapshot_middle_form.find("[name='tpd_accesskey']").val(data['tpd_accesskey']);
						snapshot_middle_form.find("[name='tpd_secretkey']").val(data['tpd_secretkey']);
						snapshot_middle_form.find("[name='tpd_region']").val(data['tpd_region']);
						snapshot_middle_form.find("[name='tpd_type']").val(data['tpd_type']);
	
						// Also, hide any previous results in the intermediate step.
						$('#snapshot-wrong-s3-details').hide();
						$('#snapshot-correct-s3-details').hide();

						$('#s3-save-name').val(check_if_on_aws() ? 'S3/Amazon' : 'S3/'+selectedProviderName);
	
						SUI.slideModal( 'snapshot-add-destination-dialog-slide-3' );

					} else {
						if (check_if_on_aws()) {
							$('#snapshot-region-no-buckets .snapshot-selected-region-no-buckets').html($('#s3-connection-region').find(':selected').text());
							$('#snapshot-region-no-buckets').show();
						} else {
							$('#snapshot-region-no-buckets-s3-compatible .snapshot-selected-region-no-buckets').html($('#s3-compatible-connection-region').val());
							$('#snapshot-region-no-buckets-s3-compatible .snapshot-s3-compatible-login-link').attr('href', selectedProviderLink);
							$('#snapshot-region-no-buckets-s3-compatible').show();
						}
					}
                } else {
                    $('#snapshot-wrong-'+destination_type+'-creds').show();
                }
            },
            error: function () {
                $('#snapshot-wrong-'+destination_type+'-creds').show();
            }
        });
        return false;
	}

	/**
	 * Handles AJAX for using connection details.
	 *
	 * @param {Object} e Event object
	 */
	function destination_intermediate_step(e) {
		if (e && e.preventDefault) e.preventDefault();
		// Hide any older error notices about data validation.
		hide_errors_pass_details();

		// Prepare the data.
		var data = {};
		var abort_details_connection = false;
		$(this).serializeArray().forEach(function (item) {
			data[item.name] = item.value;
		});
		data._wpnonce = $( '#_wpnonce-snapshot_s3_connection' ).val();

		if(!data['tpd_limit'].trim() || data['tpd_limit'] < 1) {
			$('#error-s3-details-limit').show();
			$('#error-s3-details-limit').html(snapshot_messages.require_limit);
			$('#error-s3-details-limit').closest('.sui-form-field').addClass('sui-form-field-error');
			$('#s3-details-limit').focus();

			abort_details_connection = true;
		}

		if(!data['tpd_bucket'].trim()) {
			$('#error-s3-details-bucket').show();
			$('#error-s3-details-bucket').html(snapshot_messages.require_bucket);
			$('#error-s3-details-bucket').closest('.sui-form-field').find('.select2-selection.select2-selection--single').addClass('snapshot-error-select');

			abort_details_connection = true;
		}

		if(data['tpd_directory'].trim() && data['tpd_directory'].charAt(0) !== "/") {
			$('#error-s3-details-directory').show();
			$('#error-s3-details-directory').html(snapshot_messages.require_valid_path);
			$('#error-s3-details-directory').closest('.sui-form-field').addClass('sui-form-field-error');
			$('#s3-details-directory').focus();

			abort_details_connection = true;
		}

		if (abort_details_connection) {
			return false;
		}

		// Concatenate bucket and directory path, to produce the final directory path to be used.
		var path = (data['tpd_directory'].trim()) ? data['tpd_bucket'] + data['tpd_directory'] : data['tpd_bucket'];

		if (data['tpd_action'] === 'move_to_next_screen') {
			// Actually pass the data to the next step.
			snapshot_final_form.find("[name='tpd_path']").val(path);
			snapshot_final_form.find("[name='tpd_limit']").val(data['tpd_limit']);

			// Hide any results from testing the connection.
			$('#snapshot-wrong-s3-details').hide();
			$('#snapshot-correct-s3-details').hide();
	
			SUI.slideModal( 'snapshot-add-destination-dialog-slide-4' );
		} else {
			// Don't forget to add the final path too.
			data['tpd_path'] = path;
			// We'll add a name too, as it's required for the endpoint. Since it isn't actually stored, it can be anything.
			data['tpd_name'] = 'test_name';

			// Just test the connection.
			$.ajax({
				type: 'POST',
				url: ajaxurl + '?action=snapshot-s3_connection',
				data: data,
				beforeSend: function () {
					$('#snapshot-test-connection-path').addClass('sui-button-onload-text', true);

					$('#snapshot-wrong-s3-details').hide();
					$('#snapshot-correct-s3-details').hide();
				},
				complete: function () {
					$('#snapshot-test-connection-path').removeClass('sui-button-onload-text', true);
				},
				success: function (response) {
					if (response.success && response.data.api_response.length > 0) {
						$('#snapshot-correct-s3-details').show();
					} else {
						$('#snapshot-wrong-s3-details').show();
					}
				},
				error: function () {
					$('#snapshot-wrong-s3-details').show();
				}
			});
		}

		return false;
	}

	/**
	 * Handles AJAX for saving connection.
	 *
	 * @param {Object} e Event object
	 */
	function destination_save( e ) {
		if (e && e.preventDefault) e.preventDefault();

		// Hide any older error notices about data validation.
		hide_errors_save();

		// Prepare the data to be sent for saving the connection.
		var data = {};
		$(this).serializeArray().forEach(function (item) {
			data[item.name] = item.value;
		});
		data._wpnonce = $( '#_wpnonce-snapshot_s3_connection' ).val();

		if(!data['tpd_name'].trim()) {
			$('#error-s3-save-name').show();
			$('#error-s3-save-name').html(snapshot_messages.require_name);
			$('#error-s3-save-name').closest('.sui-form-field').addClass('sui-form-field-error');
			$('#s3-save-name').focus();

			return false;
		}

		// Actually save the connection.
        $.ajax({
            type: 'POST',
            url: ajaxurl + '?action=snapshot-s3_connection',
            data: data,
            beforeSend: function () {
				$('#snapshot-submit-save-s3').addClass('sui-button-onload-text', true);
				$('#snapshot-save-failure').hide();
            },
			complete: function () {
				$('#snapshot-submit-save-s3').removeClass('sui-button-onload-text', true);
			},
            success: function (response) {
                if (response.success && response.data.api_response.tpd_name) {
					if (snapshot_stored_schedule.schedule_is_active) {
						var notice = $('<span></span>').html(snapshot_messages.destination_saved_schedule.replace('%1$s', response.data.api_response.tpd_name).replace('%2$s', snapshot_stored_schedule.text).replace('%3$s', snapshot_urls.backups + '#set-schedule'));
					} else {
						var notice = $('<span></span>').html(snapshot_messages.destination_saved_no_schedule.replace('%1$s', response.data.api_response.tpd_name).replace('%2$s', snapshot_urls.backups + '#set-schedule').replace('%3$s', snapshot_urls.backups + '#create-backup'));
					}

					jQuery(window).trigger('snapshot:show_top_notice', ['success', notice]);
					$(window).trigger('snapshot:close_modal');
					load_destinations();
                } else {
                    $('#snapshot-save-failure').show();
                }
            },
            error: function () {
				$('#snapshot-save-failure').show();
            }
        });
        return false;
	}

	function hide_errors_test_connection() {
		$('[id^="error-s3-connection-"]').hide();
		$('[id^="error-s3-connection-"]').html("");
		$('[id^="error-s3-compatible-connection-"]').hide();
		$('[id^="error-s3-compatible-connection-"]').html("");

		$('#error-s3-connection-secret-access-key').closest('.sui-form-field').removeClass('sui-form-field-error');
		$('#error-s3-connection-access-key-id').closest('.sui-form-field').removeClass('sui-form-field-error');
		$('#error-s3-connection-region').closest('.sui-form-field').find('.select2-selection.select2-selection--single').removeClass('snapshot-error-select');
		$('[id^="error-s3-compatible-connection-"]').closest('.sui-form-field').removeClass('sui-form-field-error');
	}

	function hide_errors_pass_details() {		
		$('[id^="error-s3-details-"]').hide();
		$('[id^="error-s3-details-"]').html("");

		$('#error-s3-details-limit').closest('.sui-form-field').removeClass('sui-form-field-error');
		$('#error-s3-details-directory').closest('.sui-form-field').removeClass('sui-form-field-error');
		$('#error-s3-details-bucket').closest('.sui-form-field').find('.select2-selection.select2-selection--single').removeClass('snapshot-error-select');
	}

	function hide_errors_save() {		
		$('#error-s3-save-name').hide();
		$('#error-s3-save-name').html("");
		$('#error-s3-save-name').closest('.sui-form-field').removeClass('sui-form-field-error');
	}

	function get_destinations() {
		var deferred = $.Deferred();

		var request_data = {
			action: 'snapshot-get_destinations',
			destination_page: 1,
			_wpnonce: $('#_wpnonce-snapshot-get-destinations').val()
		};

		$.ajax({
			type: 'GET',
			url: ajaxurl,
			data: request_data,
			cache: false,
			success: function (response) {
				if (response.success) {
					deferred.resolve(response.data);
				} else {
					deferred.reject();
				}
			},
			error: function () {
				deferred.reject();
			}
		});

		return deferred.promise();
	}

	function load_destinations() {
		var loaders = $('.snapshot-destinations .snapshot-loader, .snapshot-destinations-summary .sui-summary-details .sui-icon-loader');
		var summary_large = $('.snapshot-destinations-summary .sui-summary-large');
		var summary_subs = $('.snapshot-destinations-summary .sui-summary-sub>span');
		var api_error = $('.snapshot-destinations .api-error');
		var tbody = $('.snapshot-destinations .sui-table>tbody');
		var tpd_rows = tbody.find('>tr:not(:first)');

		tpd_rows.remove();
		loaders.show();
		summary_large.css('visibility', 'hidden');
		api_error.hide();

		get_destinations().then(function (data) {
			var destinations = data.destinations.length + 1;
			summary_large.text(destinations).css('visibility', 'visible');
			summary_subs.hide().filter(destinations === 1 ? '.singular' : '.plural').show();
			data.destinations.forEach(function (item) {
				tbody.append(item.html_row);
			});
			update_destination_backup_counts();
		}, function () {
			api_error.show();
			summary_large.text(1).css('visibility', 'visible');
			summary_subs.hide().filter('.singular').show();
		}).always(function () {
			loaders.hide();
		});
	}

	function set_destination_row_active(tpd_id, is_active) {
		var row = $('.snapshot-destinations .destination-row[data-tpd_id=' + tpd_id + ']');
		if (!row.length) {
			return;
		}
		var checkbox = row.find('.toggle-active');

		if (is_active) {
			row.removeClass('deactivated-destination');
			checkbox.prop('checked', true);
		} else {
			row.addClass('deactivated-destination');
			checkbox.prop('checked', false);
		}
	}

	function toggle_destination_active() {
		var checkbox = $(this);
		var row = checkbox.closest('.destination-row');
		var tpd_id = row.data('tpd_id');
		var tpd_name = row.data('tpd_name');
		var is_active = checkbox.prop('checked');

		var data = {
			tpd_id: tpd_id,
			aws_storage: is_active ? 1 : 0,
			_wpnonce: $('#_wpnonce-snapshot-update-destination').val()
		};

		$.ajax({
			type: 'POST',
			url: ajaxurl + '?action=snapshot-activate_destination',
			data: data,
			beforeSend: function () {
				set_destination_row_active(tpd_id, is_active);
				checkbox.prop('disabled', true);
			},
			complete: function () {
				checkbox.prop('disabled', false);
			},
			success: function (response) {
				if (response.success) {
					is_active = response.data.api_response.aws_storage === '1';
					set_destination_row_active(tpd_id, is_active);
					if (is_active) {
						var notice = $('<span></span>').html(snapshot_messages.destination_notice_activated.replace('%s', $('<span></span>').text(tpd_name).html()));
						jQuery(window).trigger('snapshot:show_top_notice', ['success', notice]);
					} else {
						var notice = $('<span></span>').html(snapshot_messages.destination_notice_deactivated.replace('%s', $('<span></span>').text(tpd_name).html()));
						jQuery(window).trigger('snapshot:show_top_notice', ['success', notice]);
					}
				} else {
					set_destination_row_active(tpd_id, !is_active);
				}
			},
			error: function () {
				set_destination_row_active(tpd_id, !is_active);
			}
        });


		if (checkbox.prop('checked')) {
			row.removeClass('deactivated-destination');
		} else {
			row.addClass('deactivated-destination');
		}
	}

	function row_dropdown_click() {
		var li = $(this);
		var row = li.closest('.destination-row');
		var tpd_id = row.data('tpd_id');

		if (li.hasClass('destination-edit')) {
			var data = row.data();
			var form = $('#modal-destination-edit #snapshot-edit-s3-connection');
			for (var name in data) {
				var el = form.find('[name=' + name + ']');
				if (el.length) {
					if (name === 'tpd_path') {
						var path_parts = data[name].split('/');
						var bucket = path_parts.shift();
						var path = path_parts.join('/');
						el.val(path === '' ? '' : ('/' + path));

						el = form.find('[name=tpd_bucket]');
						el.prop('disabled', true);
						el.empty().append($('<option selected></option>').val(bucket).text(bucket));
						el.val(bucket);
						el.SUIselect2({
							placeholder: snapshot_messages.choose_bucket,
							dropdownCssClass: 'sui-select-dropdown',
							dropdownParent: $('#snapshot-edit-s3-connection')
						});
					} else {
						el.val(data[name]);
					}
				}
			}
			form.find('select').change();
			hide_errors_edit_destination();
			$('#edit-s3-connection-region').SUIselect2({
				placeholder: snapshot_messages.choose_region,
				dropdownCssClass: 'sui-select-dropdown',
				dropdownParent: $('#snapshot-edit-s3-connection')
			});
			SUI.openModal('modal-destination-edit', this);
			load_buckets(form, bucket)
		} else if (li.hasClass('destination-delete')) {
			delete_destination_confirm(tpd_id);
		}
	}

	function load_buckets(form, selected_bucket) {
		var data = {
			tpd_action: 'test_connection',
			tpd_accesskey: form.find('[name=tpd_accesskey]').val(),
			tpd_secretkey: form.find('[name=tpd_secretkey]').val(),
			tpd_region: form.find('[name=tpd_region]').val(),
			tpd_type: form.find('[name=tpd_type]').val()
		};
		data._wpnonce = $( '#_wpnonce-snapshot_s3_connection' ).val();

		$.ajax({
			type: 'POST',
			url: ajaxurl + '?action=snapshot-s3_connection',
			data: data,
			success: function (response) {
				if (response.success && response.data.api_response.length > 0) {

					var el = form.find('[name=tpd_bucket]');
					var val = el.val();
					el.empty();
					response.data.api_response.forEach(function (bucket) {
						if (bucket===selected_bucket) {
							el.append($('<option selected></option>').val(bucket).text(bucket));
						} else {
							el.append($('<option></option>').val(bucket).text(bucket));
						}
					});
					el.prop('disabled', false);
					el.SUIselect2({
						placeholder: snapshot_messages.choose_bucket,
						dropdownCssClass: 'sui-select-dropdown',
						dropdownParent: $('#snapshot-edit-s3-connection')
					});
					el.val(val).change().trigger('sui:change');
				}
			}
		});
	}

	function on_update_destination_save() {
		hide_errors_edit_destination();

		var form = $('#snapshot-edit-s3-connection');
		var data = {tpd_bucket: $('#edit-s3-connection-bucket').find(':selected').val()};
		var abort = false;
		form.serializeArray().forEach(function (item) {
			data[item.name] = item.value;
		});
		data._wpnonce = $('#_wpnonce-snapshot-update-destination').val();

		if(!data['tpd_name'].trim()) {
			$('#error-edit-s3-connection-name').show();
			$('#error-edit-s3-connection-name').html(snapshot_messages.require_name);
			$('#error-edit-s3-connection-name').closest('.sui-form-field').addClass('sui-form-field-error');
			$('#edit-s3-connection-name').focus();
			abort = true;
		}

		if(!data['tpd_secretkey'].trim()) {
			$('#error-edit-s3-connection-secret-access-key').show();
			$('#error-edit-s3-connection-secret-access-key').html(snapshot_messages.require_secret_key);
			$('#error-edit-s3-connection-secret-access-key').closest('.sui-form-field').addClass('sui-form-field-error');
			$('#edit-s3-connection-secret-access-key').focus();
			abort = true;
		}

		if(!data['tpd_accesskey'].trim()) {
			$('#error-edit-s3-connection-access-key-id').show();
			$('#error-edit-s3-connection-access-key-id').html(snapshot_messages.require_access_key);
			$('#error-edit-s3-connection-access-key-id').closest('.sui-form-field').addClass('sui-form-field-error');
			$('#edit-s3-connection-access-key-id').focus();
			abort = true;
		}

		if(!data['tpd_region'].trim()) {
			$('#error-edit-s3-connection-region').show();
			$('#error-edit-s3-connection-region').html(snapshot_messages.require_region);
			$('#error-edit-s3-connection-region').closest('.sui-form-field').find('.select2-selection.select2-selection--single').addClass('snapshot-error-select');
			abort = true;
		}

		if(!data['tpd_bucket'].trim()) {
			$('#error-edit-s3-connection-bucket').show();
			$('#error-edit-s3-connection-bucket').html(snapshot_messages.require_bucket);
			$('#error-edit-s3-connection-bucket').closest('.sui-form-field').find('.select2-selection.select2-selection--single').addClass('snapshot-error-select');
			abort = true;
		}

		if(data['tpd_path'].trim() && data['tpd_path'].charAt(0) !== '/') {
			$('#error-edit-s3-connection-path').show();
			$('#error-edit-s3-connection-path').html(snapshot_messages.require_valid_path);
			$('#error-edit-s3-connection-path').closest('.sui-form-field').addClass('sui-form-field-error');
			$('#edit-s3-connection-path').focus();
			abort = true;
		}

		if(!data['tpd_limit'].trim() || data['tpd_limit'] < 1) {
			$('#error-edit-s3-connection-limit').show();
			$('#error-edit-s3-connection-limit').html(snapshot_messages.require_limit);
			$('#error-edit-s3-connection-limit').closest('.sui-form-field').addClass('sui-form-field-error');
			$('#edit-s3-connection-limit').focus();
			abort = true;
		}

		if (abort) {
			return false;
		}

		data.tpd_path = data.tpd_bucket + data.tpd_path.replace(/\/+$/, '');
		$.ajax({
			type: 'POST',
			url: ajaxurl + '?action=snapshot-update_destination',
			data: data,
			beforeSend: function () {
				$('#modal-destination-edit .save-button').addClass('sui-button-onload-text');
				form.find('input, select, button').prop('disabled', true);
			},
			complete: function () {
				form.find('input, select, button').prop('disabled', false);
				$('#modal-destination-edit .save-button').removeClass('sui-button-onload-text');
				$('#modal-destination-edit').closest('.sui-modal').animate({scrollTop: 0}, 1000);
			},
			success: function (response) {
				if (response.success) {
					$('#notice-edit-destination-success').show();
					load_destinations();
				} else {
					$('#notice-edit-destination-error').show();
				}
			},
			error: function () {
				$('#notice-edit-destination-error').show();
			}
        });
	}

	function hide_errors_edit_destination() {
		$('[id^="error-edit-s3-connection-"]').hide();
		$('[id^="error-edit-s3-connection-"]').html("");

		$('#error-edit-s3-connection-name').closest('.sui-form-field').removeClass('sui-form-field-error');
		$('#error-edit-s3-connection-secret-access-key').closest('.sui-form-field').removeClass('sui-form-field-error');
		$('#error-edit-s3-connection-access-key-id').closest('.sui-form-field').removeClass('sui-form-field-error');
		$('#error-edit-s3-connection-region').closest('.sui-form-field').find('.select2-selection.select2-selection--single').removeClass('snapshot-error-select');
		$('#error-edit-s3-connection-limit').closest('.sui-form-field').removeClass('sui-form-field-error');
		$('#error-edit-s3-connection-bucket').closest('.sui-form-field').find('.select2-selection.select2-selection--single').removeClass('snapshot-error-select');
		$('#error-edit-s3-connection-path').closest('.sui-form-field').removeClass('sui-form-field-error');

		$('#notice-edit-destination-success').hide();
		$('#notice-edit-destination-error').hide();
	}

	function on_update_destination_delete() {
		var form = $('#snapshot-edit-s3-connection');
		var tpd_id = form.find('[name=tpd_id]').val();
		$(window).trigger('snapshot:close_modal');
		delete_destination_confirm(tpd_id);
	}

	function delete_destination_request(tpd_id) {
		var deferred = $.Deferred();

		var request_data = {
			action: 'snapshot-delete_destination',
			_wpnonce: $('#_wpnonce-snapshot-delete-destination').val(),
			tpd_id: tpd_id
		};

		$.ajax({
			type: 'POST',
			url: ajaxurl,
			data: request_data,
			cache: false,
			success: function (response) {
				if (response.success) {
					deferred.resolve(response.data);
				} else {
					deferred.reject();
				}
			},
			error: function () {
				deferred.reject();
			}
		});

		return deferred.promise();
	}

	function delete_destination_confirm(tpd_id) {
		var row = $('.snapshot-destinations .destination-row[data-tpd_id=' + tpd_id + ']');
		if (!row.length) {
			return;
		}
		$('#modal-destinations-delete-description').find('strong').text(row.data('tpd_name'));
		$('#modal-destinations-delete-button').data({
			tpd_id: tpd_id,
			tpd_name: row.data('tpd_name')
		});
		SUI.openModal('modal-destinations-delete', this);
		return false;
	}

	function delete_destination() {
		var data = $(this).data();
		var modal = $(this).closest('.sui-modal');
		var modal_buttons = modal.find('.sui-button, sui-button-icon');

		modal_buttons.prop('disabled', true);
		delete_destination_request(data.tpd_id).then(function () {
			$(window).trigger('snapshot:close_modal');
			var notice = $('<span></span>').html(snapshot_messages.destination_delete_successful.replace('%s', $('<span></span>').text(data.tpd_name).html()));
			jQuery(window).trigger('snapshot:show_top_notice', ['success', notice]);
			load_destinations();
		}).always(function () {
			modal_buttons.prop('disabled', false);
		});
	}

	function history_replace_state() {
		if (window.history && window.history.replaceState) {
			window.history.replaceState('', document.title, window.location.pathname + window.location.search);
		}
	}

	function check_if_on_aws() {
		return $('.snapshot-aws-tab.active').length;
	}

	function change_selected_provider() {
		$('#label-s3-compatible-connection-provider .sui-label-link').show();
		$('#error-s3-compatible-connection-provider').hide();
		$('#error-s3-compatible-connection-provider').html('');
		$('#error-s3-compatible-connection-provider').closest('.sui-form-field').find('.select2-selection.select2-selection--single').removeClass('snapshot-error-select');

		$('.s3-compatible-creds').show();
		hide_errors_test_connection();

		var selectedProvider = $('#s3-compatible-connection-provider').find(':selected').val();
		
		// Create the special UI for Google Cloud.
		if (selectedProvider==='googlecloud') {
			$('.snapshot-s3-compatible-key').addClass('sui-control-with-icon');
			$('.snapshot-s3-compatible-key i').show();
		} else {
			$('.snapshot-s3-compatible-key').removeClass('sui-control-with-icon');
			$('.snapshot-s3-compatible-key i').hide();
		}
		['access-key-id','secret-access-key','region'].forEach(function(element) {
			var selectedProviderInfo = snapshot_s3_providers[selectedProvider].fields[element];
			$('input#s3-compatible-connection-' + element).attr('placeholder', snapshot_messages.provider_placeholder.replace('%s',selectedProviderInfo));
			$('.s3-compatible-connection-'+element+'-label').html(selectedProviderInfo);
		});
		$('.snapshot-s3-compatible-tab .sui-accordion').hide();
		$('.snapshot-'+ selectedProvider +'-credentials-howto').show();
	}

	function update_destination_backup_counts() {
		$('.snapshot-destinations .destination-row[data-tpd_id]').each(function () {
			var row = $(this);
			var tpd_id = row.data('tpd_id');
			var value = destination_backup_count[tpd_id] !== undefined ? destination_backup_count[tpd_id] : 0;
			row.find('.backup-count').text(value);
		});
	}

	$(function () {
		if ( $( '.snapshot-page-destinations' ).length ) {
			load_backup_count();

			get_current_storage();

			load_destinations();

			// Expand AWS instructions when "Follow the instructions" is clicked.
			$('.snapshot-expand-aws-instructions').on('click', function(e){
				$('.snapshot-aws-credentials-howto .sui-accordion-item').addClass('sui-accordion-item--open');
				$("#snapshot-add-destination-modal").animate({ scrollTop: $("#snapshot-add-destination-modal #snapshot-add-destination-dialog").height() }, 1000);
			});

			// Expand S3 instructions when "Guide to find the credentials" is clicked.
			$('#label-s3-compatible-connection-provider .sui-label-link').on('click', function(e){
				if (e && e.preventDefault) e.preventDefault();

				var selectedProvider = $('#s3-compatible-connection-provider').find(':selected').val();
				$('.snapshot-'+ selectedProvider +'-credentials-howto .sui-accordion-item').addClass('sui-accordion-item--open');
				$("#snapshot-add-destination-modal").animate({ scrollTop: $("#snapshot-add-destination-modal #snapshot-add-destination-dialog").height() }, 1000);
			});

			// Open the Add Destination modal and initialize the forms.
			$('#snapshot-add-destination').on('click', function(e){
				SUI.openModal( "snapshot-add-destination-dialog", this );

				hide_errors_test_connection();
				hide_errors_pass_details()
				hide_errors_save();
				
				// Create the AWS S3 region dropdown from the start.
				$('#s3-connection-region').SUIselect2("destroy");
				$("#s3-connection-region option").prop("selected", false);
				$('#s3-connection-region').SUIselect2( {
					placeholder: snapshot_messages.choose_region,
					dropdownCssClass: 'sui-select-dropdown',
					dropdownParent: $( '#snapshot-test-s3-connection' )
				} );

				// Create the S3 providers dropdown from the start.
				$('#s3-compatible-connection-provider').SUIselect2("destroy");
				$("#s3-compatible-connection-provider option").prop("selected", false);
				$('#s3-compatible-connection-provider').SUIselect2( {
					placeholder: snapshot_messages.choose_provider,
					dropdownCssClass: 'sui-select-dropdown',
					dropdownParent: $( '.s3-compatible-providers' )
				} );

				$('#s3-connection-access-key-id').val('');
				$('#s3-compatible-connection-access-key-id').val('');
				$('#s3-connection-secret-access-key').val('');
				$('#s3-compatible-connection-secret-access-key').val('');
				$('#s3-compatible-connection-region').val('');
				$('#s3-details-directory').val('');
				$('#s3-details-limit').val('30');
				$('.s3-compatible-creds').hide();
				$('.snapshot-s3-compatible-tab [class$="credentials-howto"]').hide();
				$('#label-s3-compatible-connection-provider .sui-label-link').hide();
			});

			// Submit the form on the 1st modal screen.
			$('#snapshot-submit-connection-test').on('click', function(e){
				if (e && e.preventDefault) e.preventDefault();
				if (check_if_on_aws()) {
					$('form#snapshot-test-s3-connection').submit();
				} else {
					$('form#snapshot-test-s3-compatible-connection').submit();
				}
			});

			$('form#snapshot-test-s3-connection, form#snapshot-test-s3-compatible-connection').on('submit', destination_test_connection);

			// Submit the form on the 2nd modal screen.
			$('#snapshot-submit-connection-details').on('click', function(e){
				if (e && e.preventDefault) e.preventDefault();
				snapshot_middle_form.find("[name='tpd_action']").val('move_to_next_screen');
				snapshot_middle_form.submit();
			});

			// Perform the non-required 'Test Connection' action on the 2st modal screen.
			$('#snapshot-test-connection-path').on('click', function(e){
				if (e && e.preventDefault) e.preventDefault();
				snapshot_middle_form.find("[name='tpd_action']").val('test_connection_bucket');
				snapshot_middle_form.submit();
			});

			snapshot_middle_form.on('submit', destination_intermediate_step);

			// Submit the final form on the last modal screen.
			$('#snapshot-submit-save-s3').on('click', function(e){
				if (e && e.preventDefault) e.preventDefault();
				snapshot_final_form.submit();
			});

			snapshot_final_form.on('submit', destination_save);

			// Hide any past error notices when going to a next modal screen.
			$('.snapshot-next-destination-screen').on('click', function(e){
				$('#snapshot-save-failure').hide();
				$('#snapshot-wrong-s3-creds').hide();
				$('#snapshot-wrong-s3-compatible-creds').hide();
				$('#snapshot-region-no-buckets').hide();
				$('#snapshot-region-no-buckets-s3-compatible').hide();
			});

			// Hide the Require Region notice when selecting a region
			$('#s3-connection-region').on('select2:select', function (e) {				
				$('#error-s3-connection-region').hide();
				$('#error-s3-connection-region').html('');
				$('#error-s3-connection-region').closest('.sui-form-field').find('.select2-selection.select2-selection--single').removeClass('snapshot-error-select');
			});

			  // Hide the Require Bucket notice when selecting a region
			$('#s3-details-bucket').on('select2:select', function (e) {				
				$('#error-s3-details-bucket').hide();
				$('#error-s3-details-bucket').html('');
				$('#error-s3-details-bucket').closest('.sui-form-field').find('.select2-selection.select2-selection--single').removeClass('snapshot-error-select');
			});

			// S3 providers dropdown listener.
			$('#s3-compatible-connection-provider').on('select2:select', change_selected_provider);

			$('.snapshot-destinations').on('change', 'input[type=checkbox].toggle-active', toggle_destination_active);
			$('.snapshot-destinations').on('click', '.sui-dropdown>ul>li', row_dropdown_click);
			$('#modal-destinations-delete-button').on('click', delete_destination);
			$('#modal-destination-edit').find('.delete-button').on('click', on_update_destination_delete);
			$('#modal-destination-edit').find('.save-button').on('click', on_update_destination_save);
			$('#modal-destination-edit').find('[name=tpd_accesskey], [name=tpd_secretkey], [name=tpd_region]').on('change', function() {
				var form = $(this).closest('form'),
					bucket = form.find('[name=tpd_bucket]').val();
				load_buckets(form, bucket);
			});
			$('#button-reload-destinations').on('click', load_destinations);

			$('.sui-notice .hide-notice').on('click', function () {
				$(this).closest('.sui-notice').fadeOut(300);
			});

			$(window).on('load', function () {
				if ('#add-destination' === window.location.hash) {
					$('#snapshot-add-destination').click();
					history_replace_state();
				}
			});

		}
	});
})(jQuery);
