/**
 * Page: Settings.
 */
;(function($) {
	// "null" means loading, "false" - error
	var snapshot_backups = null;
	var hosting_backups = snapshot_env.values.has_hosting_backups ? null : false;

	function get_current_storage() {
		var data = {};

		data._wpnonce = $( '#_wpnonce-snapshot_get_storage' ).val();

		var url = ajaxurl + '?action=snapshot-get_storage';

		$.ajax({
			type: 'POST',
			url: url,
			data: data,
			cache: false,
			dataType: 'json',
			success: function (response) {
				if (response.success) {
					$('.snapshot-storage-loading').hide();
					$('.wpmudev-snapshot-storage span').css({"width": response.data.width});
					$('.wpmudev-snapshot-storage').show();
					$('.snapshot-current-stats .used-space').html(response.data.current_stats);
					$('.snapshot-current-stats .used-space').show();
				}
			}
		});

		return false;
	}

	function get_backups(action, nonce_selector) {
		var deferred = $.Deferred();

		var request_data = {
			action: action,
			_wpnonce: $(nonce_selector).val()
		};

		$.ajax({
			type: 'POST',
			url: ajaxurl,
			data: request_data,
			cache: false,
			success: function (response) {
				if (response.success && response.data.backups) {
					deferred.resolve(response.data);
				} else {
					deferred.reject();
				}
			},
			error: function () {
				deferred.reject();
			}
		});

		return deferred.promise();
	}

	function get_snapshot_backups() {
		return get_backups('snapshot-list_backups', '#_wpnonce-list-backups');
	}

	function get_hosting_backups() {
		return get_backups('snapshot-list_hosting_backups', '#_wpnonce-list-hosting-backups');
	}

	function load_snapshot_backups() {
		snapshot_backups = null;
		update_summary();

		$('.snapshot-dashboard-backups .api-error').hide();
		$('.snapshot-dashboard-backups .snapshot-loading').show();
		$('.snapshot-dashboard-summary .snapshot-loading').show();

		get_snapshot_backups().then(function (data) {
			snapshot_backups = data;

			if (data.backups.length) {
				var last_backup = data.backups[0];

				// Disable the Backup Now button, if we're still in the same minute with the last backup taken.
				var time_elapsed = ( Date.now() / 1000 - last_backup.timestamp ) / 60 ;
				$(window).trigger('snapshot:toggle_cooldown', [time_elapsed]);

				$('.snapshot-listed-backups .sui-table > tbody:last-child').html('');
				data.backups.slice(0, 5).forEach(function (item) {
					var row = $(item.row);
					row.find('>td').slice(-5).remove();
					row.find('.failed-icon-tooltip').addClass('sui-tooltip-top-left');
					$('.snapshot-listed-backups .sui-table > tbody:last-child').append(row);
					$('.snapshot-dashboard-backups > .sui-box-body:not(.api-error)').show();
					$('.snapshot-dashboard-backups > .snapshot-listed-backups').show();
					$('.snapshot-dashboard-backups > .sui-box-footer').attr('style', 'display: flex !important');
				});
			} else {
				$('.snapshot-dashboard-backups > .snapshot-listed-backups-empty').show();
			}
		}, function () {
			snapshot_backups = false;
			$('.snapshot-dashboard-backups .api-error').show();
		}).always(function () {
			$('.snapshot-dashboard-backups .snapshot-loading').hide();
			update_summary();
		});
	}

	function load_hosting_backups() {
		hosting_backups = null;
		update_summary();

		var table = $('.snapshot-dashboard-hosting-backups table.snapshot-listed-hosting-backups');
		var footer = $('.snapshot-dashboard-hosting-backups .sui-box-footer');
		$('.snapshot-dashboard-hosting-backups .api-error').hide();
		$('.snapshot-dashboard-hosting-backups .body-description').hide();
		table.hide();
		footer.hide();
		$('.snapshot-dashboard-hosting-backups .snapshot-loading').show();
		$('.snapshot-dashboard-summary .snapshot-loading').show();

		get_hosting_backups().then(function (data) {
			hosting_backups = data;
			var tbody = table.find('> tbody');
			tbody.empty();
			data.backups.slice(0, 5).forEach(function (item) {
				var src_row = $('<tbody></tbody>').append(item.html_row);
				var row = src_row.find('>.hosting-backup-row');
				row.find('>td').slice(-1).remove();
				tbody.append(row);
			});
			$('.snapshot-dashboard-hosting-backups .body-description').show();
			table.show();
			footer.show();
		}, function () {
			hosting_backups = false;
			$('.snapshot-dashboard-hosting-backups .api-error').show();
		}).always(function () {
			$('.snapshot-dashboard-hosting-backups .snapshot-loading').hide();
			update_summary();
		});
	}

	function update_summary() {
		if (snapshot_backups === null || hosting_backups === null) {
			// any backup list is loading, show loaders
			$('.snapshot-dashboard-summary .snapshot-loading').show();
			$('.sui-summary-details.snapshot-backups-number .sui-summary-large').text('');
			$('.sui-summary-segment .snapshot-last-backup').text('');
			return;
		}
		if (snapshot_backups === false && hosting_backups === false) {
			// both backup lists are failed
			$('.snapshot-dashboard-summary .snapshot-loading').hide();
			$('.sui-summary-details.snapshot-backups-number .sui-summary-large').text('-');
			$('.sui-summary-segment .snapshot-last-backup').text('-');
			return;
		}

		var backups_number = 0;
		var last_backup_ts = 0;
		var last_backup = snapshot_messages.last_backup_unknown_date;
		if (snapshot_backups && snapshot_backups.backups) {
			var failed_backups_number = snapshot_backups.failed_backups || 0;
			backups_number += snapshot_backups.backups.length;
			backups_number -= failed_backups_number;
			var successful_backups = snapshot_backups.backups.filter(function (backup) {
				return !backup.is_failed;
			});
			if (successful_backups.length) {
				last_backup_ts = successful_backups[0].timestamp;
				last_backup = successful_backups[0].date;
			}
		}
		if (hosting_backups && hosting_backups.backups) {
			backups_number += hosting_backups.backups.length;
			if (hosting_backups.backups.length && hosting_backups.backups[0].created_at > last_backup_ts) {
				last_backup_ts = hosting_backups.backups[0].created_at;
				last_backup = hosting_backups.last_backup_time;
			}
		}

		$('.sui-summary-details.snapshot-backups-number .sui-summary-large').text(backups_number);
		$('.sui-summary-segment .snapshot-last-backup').text(last_backup);
		$('.snapshot-dashboard-summary .snapshot-loading').hide();
	}

	function load_all_backups() {
		load_snapshot_backups();
		if (snapshot_env.values.has_hosting_backups) {
			load_hosting_backups();
		}
	}

	function load_dashboard_destinations() {
		var loaders = $('.snapshot-destinations-number-loading');
		var destinations_number = $('.snapshot-destinations-number');

		loaders.show();

		get_destinations().then(function (data) {
			loaders.hide();

			var destinations = data.destinations.length + 1;
			destinations_number.text(destinations);
		}, function () {
		}).always(function () {
		});
	}

	function get_destinations() {
		var deferred = $.Deferred();

		var request_data = {
			action: 'snapshot-get_destinations',
			destination_page: 0,
			_wpnonce: $('#_wpnonce-snapshot-get-destinations').val()
		};

		$.ajax({
			type: 'GET',
			url: ajaxurl,
			data: request_data,
			cache: false,
			success: function (response) {
				if (response.success) {
					deferred.resolve(response.data);
				} else {
					deferred.reject();
				}
			},
			error: function () {
				deferred.reject();
			}
		});

		return deferred.promise();
	}

	$(function () {
		if ($('.snapshot-dashboard-backups').length) {
			load_all_backups();
			$('#button-reload-backups').on('click', load_snapshot_backups);
			$('#button-reload-hosting-backups').on('click', load_hosting_backups);

			get_current_storage();
			load_dashboard_destinations();
		}
	});
})(jQuery);
