/**ABDB**/DROP TABLE IF EXISTS `wp_users`;
/**ABDB**/CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `wp_users`  VALUES 
('1', 'wpengine', '$P$BW.QDWic4qANzqM/YlVIrw8TtVMnqS/', 'wpengine', 'bitbucket@wpengine.com', 'http://wpengine.com', '2017-06-20 20:39:42', '', '0', 'wpengine'),
('2', 'jhdogtraining', '$P$B/De40VLM6oVpmBmDETfjx8X8.8g.91', 'jhdogtraining', 'jennyharlow@bigpond.com', 'http://jhdogtraining.wpengine.com', '2017-11-14 01:03:35', '', '0', 'jhdogtraining'),
('3', 'wpetest', '$P$BXvWh5g22k/u8C0cdBSs/bYbLApI4./', 'wpetest', 'cody.pickren@wpengine.com', '', '2017-11-14 15:35:02', '', '0', 'wpetest'),
('4', 'jchapman', '$P$Bq4TVIXa4sXmwpeiiAv7N0c70mkBzu/', 'jchapman', 'jenrchapman@gmail.com', '', '2020-08-23 04:54:07', '', '0', 'jchapman');
/**ABDB**/DROP TABLE IF EXISTS `wp_usermeta`;
/**ABDB**/CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=206 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `wp_usermeta`  VALUES 
('1', '1', 'nickname', 'wpengine'),
('2', '1', 'first_name', ''),
('3', '1', 'last_name', ''),
('4', '1', 'description', 'This is the \"wpengine\" admin user that our staff uses to gain access to your admin area to provide support and troubleshooting. It can only be accessed by a button in our secure log that auto generates a password and dumps that password after the staff member has logged in. We have taken extreme measures to ensure that our own user is not going to be misused to harm any of our clients sites.'),
('5', '1', 'rich_editing', 'true'),
('6', '1', 'comment_shortcuts', 'false'),
('7', '1', 'admin_color', 'fresh'),
('8', '1', 'use_ssl', '0'),
('9', '1', 'show_admin_bar_front', 'false'),
('10', '1', 'locale', ''),
('11', '1', 'wp_capabilities', 'a:1:{s:13:\"administrator\";b:1;}'),
('12', '1', 'wp_user_level', '10'),
('13', '1', 'dismissed_wp_pointers', 'text_widget_custom_html'),
('14', '1', 'show_welcome_panel', '0'),
('15', '2', 'nickname', 'jhdogtraining'),
('16', '2', 'first_name', ''),
('17', '2', 'last_name', ''),
('18', '2', 'description', ''),
('19', '2', 'rich_editing', 'true'),
('20', '2', 'comment_shortcuts', 'false'),
('21', '2', 'admin_color', 'fresh'),
('22', '2', 'use_ssl', '0'),
('23', '2', 'show_admin_bar_front', 'true'),
('24', '2', 'locale', ''),
('25', '2', 'wp_capabilities', 'a:1:{s:13:\"administrator\";b:1;}'),
('26', '2', 'wp_user_level', '10'),
('28', '1', 'wp_dashboard_quick_press_last_post_id', '204720'),
('29', '1', 'community-events-location', 'a:1:{s:2:\"ip\";s:12:\"178.223.95.0\";}'),
('30', '3', 'nickname', 'wpetest'),
('31', '3', 'first_name', ''),
('32', '3', 'last_name', ''),
('33', '3', 'description', ''),
('34', '3', 'rich_editing', 'true'),
('35', '3', 'comment_shortcuts', 'false'),
('36', '3', 'admin_color', 'fresh'),
('37', '3', 'use_ssl', '0'),
('38', '3', 'show_admin_bar_front', 'true'),
('39', '3', 'locale', ''),
('40', '3', 'wp_capabilities', 'a:1:{s:13:\"administrator\";b:1;}'),
('41', '3', 'wp_user_level', '10'),
('42', '3', 'dismissed_wp_pointers', ''),
('43', '3', 'default_password_nag', ''),
('44', '3', 'session_tokens', 'a:1:{s:64:\"0edaf2d84bb4363a1e5f1ce42abfb20dc8dc00e19fbb90e7eecf222c673e3816\";a:4:{s:10:\"expiration\";i:1510846597;s:2:\"ip\";s:13:\"66.162.212.19\";s:2:\"ua\";s:120:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.89 Safari/537.36\";s:5:\"login\";i:1510673797;}}'),
('45', '3', 'wp_dashboard_quick_press_last_post_id', '4'),
('46', '3', 'community-events-location', 'a:1:{s:2:\"ip\";s:12:\"66.162.212.0\";}'),
('47', '1', 'meta-box-order_dashboard', 'a:4:{s:6:\"normal\";s:38:\"dashboard_right_now,wpe_dify_news_feed\";s:4:\"side\";s:36:\"dashboard_activity,dashboard_primary\";s:7:\"column3\";s:21:\"dashboard_quick_press\";s:7:\"column4\";s:0:\"\";}'),
('48', '1', 'wp_user-settings', 'libraryContent=browse&editor=tinymce&imgsize=full&align=left&mfold=o&advImgDetails=show&unfold=1&hidetb=1'),
('49', '1', 'wp_user-settings-time', '1513325036'),
('50', '1', 'closedpostboxes_page', 'a:2:{i:0;s:13:\"pageparentdiv\";i:1;s:12:\"postimagediv\";}'),
('51', '1', 'metaboxhidden_page', 'a:3:{i:0;s:12:\"et_pb_layout\";i:1;s:16:\"commentstatusdiv\";i:2;s:7:\"slugdiv\";}'),
('52', '1', 'syntax_highlighting', 'true'),
('53', '1', 'managenav-menuscolumnshidden', 'a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}'),
('54', '1', 'metaboxhidden_nav-menus', 'a:5:{i:0;s:21:\"add-post-type-project\";i:1;s:12:\"add-post_tag\";i:2;s:15:\"add-post_format\";i:3;s:20:\"add-project_category\";i:4;s:15:\"add-project_tag\";}'),
('55', '1', 'nav_menu_recently_edited', '5'),
('56', '1', 'closedpostboxes_dashboard', 'a:0:{}'),
('57', '1', 'metaboxhidden_dashboard', 'a:2:{i:0;s:18:\"wpe_dify_news_feed\";i:1;s:17:\"dashboard_primary\";}'),
('58', '1', 'meta-box-order_page', 'a:3:{s:4:\"side\";s:57:\"et_settings_meta_box,submitdiv,pageparentdiv,postimagediv\";s:6:\"normal\";s:82:\"et_pb_layout,postexcerpt,postcustom,commentstatusdiv,commentsdiv,slugdiv,authordiv\";s:8:\"advanced\";s:0:\"\";}'),
('59', '1', 'screen_layout_page', '2'),
('60', '1', 'closedpostboxes_post', 'a:0:{}'),
('61', '1', 'metaboxhidden_post', 'a:5:{i:0;s:12:\"et_pb_layout\";i:1;s:13:\"trackbacksdiv\";i:2;s:11:\"commentsdiv\";i:3;s:7:\"slugdiv\";i:4;s:9:\"authordiv\";}'),
('63', '2', 'syntax_highlighting', 'true'),
('65', '2', 'wp_dashboard_quick_press_last_post_id', '205278'),
('66', '2', 'community-events-location', 'a:1:{s:2:\"ip\";s:11:\"27.76.182.0\";}'),
('67', '2', 'nav_menu_recently_edited', '5'),
('68', '2', 'managenav-menuscolumnshidden', 'a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}'),
('69', '2', 'metaboxhidden_nav-menus', 'a:5:{i:0;s:21:\"add-post-type-project\";i:1;s:12:\"add-post_tag\";i:2;s:15:\"add-post_format\";i:3;s:20:\"add-project_category\";i:4;s:15:\"add-project_tag\";}'),
('70', '2', 'wp_user-settings', 'editor=tinymce&libraryContent=browse&posts_list_mode=list&hidetb=0&advImgDetails=show&imgsize='),
('71', '2', 'wp_user-settings-time', '1598630934'),
('72', '2', 'closedpostboxes_post', 'a:0:{}'),
('73', '2', 'metaboxhidden_post', 'a:6:{i:0;s:12:\"et_pb_layout\";i:1;s:13:\"trackbacksdiv\";i:2;s:16:\"commentstatusdiv\";i:3;s:11:\"commentsdiv\";i:4;s:7:\"slugdiv\";i:5;s:9:\"authordiv\";}'),
('74', '2', 'default_password_nag', ''),
('75', '2', 'closedpostboxes_page', 'a:1:{i:0;s:20:\"et_settings_meta_box\";}'),
('76', '2', 'metaboxhidden_page', 'a:3:{i:0;s:16:\"commentstatusdiv\";i:1;s:7:\"slugdiv\";i:2;s:9:\"authordiv\";}'),
('77', '1', 'session_tokens', 'a:1:{s:64:\"9b0851d7c744740447ed390b68350bf0ee6678354862f7acfff403743d234abc\";a:3:{s:10:\"expiration\";i:1559431197;s:2:\"ip\";s:9:\"127.0.0.1\";s:5:\"login\";i:1559258397;}}'),
('84', '2', 'last_login_time', '2020-11-03 02:00:07'),
('99', '2', 'edit_post_per_page', '20'),
('102', '2', 'dismissed_wp_pointers', 'wp496_privacy,text_widget_custom_html,plugin_editor_notice,theme_editor_notice'),
('110', '2', 'show_try_gutenberg_panel', '0'),
('113', '2', 'closedpostboxes_acf-field-group', 'a:0:{}'),
('114', '2', 'metaboxhidden_acf-field-group', 'a:1:{i:0;s:7:\"slugdiv\";}'),
('120', '2', 'ignore_pixel_id_notice', '1'),
('125', '2', 'itsec_user_activity_last_seen', '1625106187'),
('126', '2', 'itsec-password-strength', '4'),
('127', '2', '_itsec_password_requirements', 'a:1:{s:16:\"evaluation_times\";a:1:{s:8:\"strength\";i:1569886061;}}'),
('128', '2', '_itsec_has_logged_in', '1569886061'),
('129', '2', 'itsec-settings-view', 'grid'),
('134', '4', 'nickname', 'pete'),
('135', '4', 'first_name', ''),
('136', '4', 'last_name', ''),
('137', '4', 'description', ''),
('138', '4', 'rich_editing', 'true'),
('139', '4', 'syntax_highlighting', 'true'),
('140', '4', 'comment_shortcuts', 'false'),
('141', '4', 'admin_color', 'fresh'),
('142', '4', 'use_ssl', '0'),
('143', '4', 'show_admin_bar_front', 'true'),
('144', '4', 'locale', ''),
('145', '4', 'wp_capabilities', 'a:1:{s:13:\"administrator\";b:1;}'),
('146', '4', 'wp_user_level', '10'),
('147', '4', 'dismissed_wp_pointers', ''),
('148', '4', 'itsec-password-strength', '4'),
('149', '4', '_itsec_password_requirements', 'a:1:{s:16:\"evaluation_times\";a:1:{s:8:\"strength\";i:1598158464;}}'),
('150', '4', 'session_tokens', 'a:142:{s:64:\"91bcabbbe45313fdd2f771e9b34c35a0b957817e55f5fc6993eaa1ba7600c295\";a:4:{s:10:\"expiration\";i:1625115472;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1623905872;}s:64:\"b660c0af72a29fc119b4df89291a189c3eb1b4516279a977236e5c521e70f457\";a:4:{s:10:\"expiration\";i:1625115472;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1623905872;}s:64:\"e8862b7a0b584a93eba0108d8d123d3c5f63d3ccb1216406757ff7e2f0a52954\";a:4:{s:10:\"expiration\";i:1625128954;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1623919354;}s:64:\"c84a843d53ae17d7145d321275318d5ea9da641edb62f408a31d3f530a28cfb9\";a:4:{s:10:\"expiration\";i:1625128954;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1623919354;}s:64:\"cc43c5cc2424674cb8fdcf51d4d2406ab9e5bff50c15b202ceaa02a50f8737d5\";a:4:{s:10:\"expiration\";i:1625159912;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1623950312;}s:64:\"285c711052be102845e9eb253a6368ff13ce7b28e0cda4cd7606464d42ebbcbb\";a:4:{s:10:\"expiration\";i:1625159912;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1623950312;}s:64:\"bcf0f7e19c35b03e684c41ddd0f3cc3cc0493d702b8061e5ee2aa6edc4b4ff50\";a:4:{s:10:\"expiration\";i:1625172476;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1623962876;}s:64:\"d1bea4e7515c0c527f628c77be9a2b263bb1957098796f2d4a5659f9ff735933\";a:4:{s:10:\"expiration\";i:1625172476;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1623962876;}s:64:\"d5d39e39841ea2d2f3b4379245e7e9155c1f34fb3e0557701c5ccf8c9a174587\";a:4:{s:10:\"expiration\";i:1625202776;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1623993176;}s:64:\"d5c6f41fa6dff9e0349effbbc278e3fd0a00917bb66138f7318cbb6fd12b86e0\";a:4:{s:10:\"expiration\";i:1625202776;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1623993176;}s:64:\"395c93ee0d2bcfa0024e57b3e854e881662c075c865bdf8b10a4fb96f74982c9\";a:4:{s:10:\"expiration\";i:1625215676;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624006076;}s:64:\"a1353a6e5a357c7241a300a1b6695822b8bb5574eac49da0dbc8d4f08b5a10a3\";a:4:{s:10:\"expiration\";i:1625215676;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624006076;}s:64:\"fbcf8ff39c49cd4d5d0cad2eeaebff04302aeaf7b769902c395668b2d4ac9e7d\";a:4:{s:10:\"expiration\";i:1625245218;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624035618;}s:64:\"ef5aaaca71c671d7cbd8f564476acef370e1d1ad19434c6d67814b9a3ca174e3\";a:4:{s:10:\"expiration\";i:1625245218;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624035618;}s:64:\"dd5da39c1b4e16b1bf6e76392af74d678d48ec8be852b1194aab2390b1b1c36f\";a:4:{s:10:\"expiration\";i:1625259960;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624050360;}s:64:\"4b51deec419250fec98f138c226e7e9fb58e22148950527b12364ac765075f05\";a:4:{s:10:\"expiration\";i:1625259960;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624050361;}s:64:\"a7d374534cf6c51ecc44fc06f028730463677b7b6af4b162344ab84afab035d9\";a:4:{s:10:\"expiration\";i:1625290791;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624081191;}s:64:\"7f6f23b30305769a19aa2e87976964f30c3fb01aa33db76904e8cd06e87e42da\";a:4:{s:10:\"expiration\";i:1625290791;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624081191;}s:64:\"8b1358c7248e4b1291e07858739190af336e83db515e4fb95033072d36743a48\";a:4:{s:10:\"expiration\";i:1625301664;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624092064;}s:64:\"bd3a04cb8ca0a39cb427b4f049f065e2286674052a7b5e035ebb6fb9b6fc1f11\";a:4:{s:10:\"expiration\";i:1625301664;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624092064;}s:64:\"7a46535c67d2d415a60422f79a2bcad3b1f97a730c2f45999783126a265d162a\";a:4:{s:10:\"expiration\";i:1625332025;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624122425;}s:64:\"c777b5a6b2c587a91e9fb6117229f553b39ba5db2d05281792c2761cbf89071a\";a:4:{s:10:\"expiration\";i:1625332025;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624122425;}s:64:\"6c04602a561717ccf51c6df09d65b41b36e3b3394598f347197d471fb1c2bc5f\";a:4:{s:10:\"expiration\";i:1625346454;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624136854;}s:64:\"e821d7c64b8ccd3146bf5032c7ac286300a6cd6f0298d7e9dcd2da6e2ca1f950\";a:4:{s:10:\"expiration\";i:1625346454;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624136854;}s:64:\"0678f16ca3f77368446e3161fe159de8edb5b04b4a0c2a727450559812f7e844\";a:4:{s:10:\"expiration\";i:1625374672;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624165072;}s:64:\"3ffecc17254204a3730b4e0174d009499c090deb00bbb2c87e021af8066cb4ed\";a:4:{s:10:\"expiration\";i:1625374672;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624165072;}s:64:\"82f64d9406d83b012196300347b7ce50c67d157234ee2c38fc1ec00355e62faf\";a:4:{s:10:\"expiration\";i:1625389317;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624179717;}s:64:\"250f7cf616dc465804cc5cc7a6a324672929302a6e75219b7b15f7b9acd384c9\";a:4:{s:10:\"expiration\";i:1625389317;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624179717;}s:64:\"2f79196ef93e4c83e096d9732697dad65cfbb2df8d04be206e7bc36f94eb71ea\";a:4:{s:10:\"expiration\";i:1625418091;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624208491;}s:64:\"c4c9a053ce9cdc6f1675f657131710a26300dbea6b5573efb6d97ef6a5e441f8\";a:4:{s:10:\"expiration\";i:1625418091;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624208491;}s:64:\"278a3542b8ad05c9324d58ed14057ff20fbb0fb5d667733c0cc26223a9bddb64\";a:4:{s:10:\"expiration\";i:1625431218;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624221618;}s:64:\"f6a4d8641c6fa6d0bb66546bb7b433994528eec7f918c07b88a9f68cb6eac2b4\";a:4:{s:10:\"expiration\";i:1625431218;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624221618;}s:64:\"bb00490287c6e174062a22f14e1507883dcab987634bb3a591f1ef66ae97e608\";a:4:{s:10:\"expiration\";i:1625460985;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624251385;}s:64:\"80dfbdfd2bf74b68630d20b559b2da22388c2b42d266c9ba50cdd15da2dba940\";a:4:{s:10:\"expiration\";i:1625460985;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624251385;}s:64:\"c4ba4f3faafb2456ecea5181543ce3d0a11d3812953a3fedfb33b5a7220ff899\";a:4:{s:10:\"expiration\";i:1625476372;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624266772;}s:64:\"e3472b603d0f0b2152d1b62f32f5a514e93990ee24944d09e7339ff3594dac93\";a:4:{s:10:\"expiration\";i:1625476372;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624266772;}s:64:\"23a5f014df93d0b514ce1b9f4049a541f4f0eda8f6d04c545d7881c59ec2cbd0\";a:4:{s:10:\"expiration\";i:1625504131;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624294531;}s:64:\"4d922624749d038d11c78da0d1c5517fa498d96b1cbf88064db6f849bfe9ccbf\";a:4:{s:10:\"expiration\";i:1625504131;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624294531;}s:64:\"113df9815ef3d689f9ed538f244a6283185771f4095e14c0e799acc17b97f018\";a:4:{s:10:\"expiration\";i:1625519690;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624310090;}s:64:\"bc873406f7281cc13ec404a4ff25f1f0c679a15799d440080d3ad96a4ef6d602\";a:4:{s:10:\"expiration\";i:1625519690;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624310090;}s:64:\"8111c3195cff0339cdc44e52e4019142694aba6de664a95fb1d7b1c64e26a157\";a:4:{s:10:\"expiration\";i:1625547465;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624337865;}s:64:\"d547172bd3ff528639f249aace803e667af268467b93c5caabcfc59e0f5f4660\";a:4:{s:10:\"expiration\";i:1625547465;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624337865;}s:64:\"5edc123dfc9e90ce4e17beb7a65e95a6a50d26aa15b9a14b6cf1339f3bcd3f6f\";a:4:{s:10:\"expiration\";i:1625561767;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624352167;}s:64:\"280f434c519841fd5b12bdc423c9a34782b426158ebea695ac2ee9774c866c4e\";a:4:{s:10:\"expiration\";i:1625561767;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624352167;}s:64:\"3fe9fc43d8edbad13c0ab8d3e782c327430d33fc5b2075fb0df166728e41e59f\";a:4:{s:10:\"expiration\";i:1625591024;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624381424;}s:64:\"c7eea820f05ed4cf2c0396a506d7f02bb53f19fce1ecbe10c061b956afdbcb3b\";a:4:{s:10:\"expiration\";i:1625591024;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624381424;}s:64:\"f8f22f8f329044ac629e78403ac3ec00bffc33de84d582ce8a007f4667dae068\";a:4:{s:10:\"expiration\";i:1625606804;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624397204;}s:64:\"a2ee846d834e40c3edd0f637e7dc6bf6f083499a2e73dbcf7c573ed0302bdc6d\";a:4:{s:10:\"expiration\";i:1625606804;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624397204;}s:64:\"6a0768ab41479bb998a7c82202c4cb031992c258f3ab831a2aac3fffa281624d\";a:4:{s:10:\"expiration\";i:1625634210;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624424610;}s:64:\"2e5f649c6ca58752ac3d67b8ba309d39ac891259a2f06444c4755a964a3205e6\";a:4:{s:10:\"expiration\";i:1625634210;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624424610;}s:64:\"aa617f6438d51abc96465ff566f1d05584dc0b907da8fcf0524ff766d57d40c5\";a:4:{s:10:\"expiration\";i:1625647747;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624438147;}s:64:\"e8a848ffed68fd999325cbd14209235bd4ba6f1d079f05d293c0272d4d11fea5\";a:4:{s:10:\"expiration\";i:1625647747;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624438147;}s:64:\"d5b2a1135ce2f5f8187298b3b0a5c6c06fe80d0fffe5b6af50808996c840704e\";a:4:{s:10:\"expiration\";i:1625678518;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624468918;}s:64:\"9d2a1d24bf0d4a8ae0c5c789a0233328e35678377efa2b6086d4ddd32ce08551\";a:4:{s:10:\"expiration\";i:1625678518;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624468918;}s:64:\"45c00ca14b17bfe7e4c6b9332323d65f5681e6d11f38599863cdbe644be9f1ac\";a:4:{s:10:\"expiration\";i:1625691735;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624482135;}s:64:\"f411d5efafd03db2b448254f018d1f3cdbbaf7367f2d1a0dc04bf5ed5141fe49\";a:4:{s:10:\"expiration\";i:1625691735;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624482135;}s:64:\"c316b0024b24d9216a70cc9adfb079ca1a7210824a5aa729bb317f497db70a7f\";a:4:{s:10:\"expiration\";i:1625722077;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624512477;}s:64:\"9b1365e0bcb01e47bb47ecfb240d149014fe85a9d1594a369f7dcf6e6d905005\";a:4:{s:10:\"expiration\";i:1625722077;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624512477;}s:64:\"9459bc612ed9a645697261836fd3594d9ac1325f248c06707a936f986d5a39da\";a:4:{s:10:\"expiration\";i:1625733968;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624524368;}s:64:\"c0f104fabbf1f18a00b398ab770c658bbe33f453f52dbdf635cfa0f3653a7af6\";a:4:{s:10:\"expiration\";i:1625733968;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624524368;}s:64:\"1ee95801bdfa1ce0e62b85d12b962fdf23c4f65bb5c12c553cccb4a142f79ec5\";a:4:{s:10:\"expiration\";i:1625764126;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624554526;}s:64:\"7b9d0789e5926dd8715cb62fc9a6260b84c2b6eb53e14045afda8b4609acb897\";a:4:{s:10:\"expiration\";i:1625764126;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624554526;}s:64:\"2ee4ed50e51bc1158e20cbe983ee15bf30a8335d6f4a99002caa41c40bb500b2\";a:4:{s:10:\"expiration\";i:1625777122;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624567522;}s:64:\"14964cfa59accd1b729f6123aa1e7c9bd6f5bd3db4d12020bbaeb55232b67305\";a:4:{s:10:\"expiration\";i:1625777122;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624567522;}s:64:\"4ff581c7dd50fd355eb26e570ed9e05664cb894b5f3c76fa364ace300c37037b\";a:4:{s:10:\"expiration\";i:1625806598;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624596998;}s:64:\"96a05c6a0917d30b875941ceba25e50d6043258957ba11ebb9170fc5e65b1544\";a:4:{s:10:\"expiration\";i:1625806598;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624596998;}s:64:\"b8c3f470752787a56dd081296d9d7c2d7eed03dc617dffd19b1efa77669bc293\";a:4:{s:10:\"expiration\";i:1625822652;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624613052;}s:64:\"fe6243b12012099851018d305e93a22131f57741952fde19249c03b256801f67\";a:4:{s:10:\"expiration\";i:1625822652;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624613052;}s:64:\"1caa0a9ff63150db273a7d71b629578dc1a28b04cc634fe62b845d76fec9cea4\";a:4:{s:10:\"expiration\";i:1625850997;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624641397;}s:64:\"18d628aeeedbb4d66f6d75e966a9ddf5837c33396040fcea1e205ab5e7813015\";a:4:{s:10:\"expiration\";i:1625850997;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624641397;}s:64:\"e03c3086957a1cd8e43897ceda48aee9a2b3f727fe0a463e8d9d6f04dfd140d9\";a:4:{s:10:\"expiration\";i:1625863584;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624653984;}s:64:\"2da5052d8fd825b647e08623f6dbb6cff6bc3621b0f02352b10d78cfcd39087f\";a:4:{s:10:\"expiration\";i:1625863584;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624653984;}s:64:\"6f0af8c7301915a21e52e4dc0c09b510e37283e707f0242c2bf464b372f4d118\";a:4:{s:10:\"expiration\";i:1625894096;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624684496;}s:64:\"9e53117bd1c1657c45c300563e7c2e5883dbc8efb00f6b2cae79bc05228f561d\";a:4:{s:10:\"expiration\";i:1625894096;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624684496;}s:64:\"5d986165a2e4c88ed00ba5fc09c5d6ddde2911b5f6fd83ef1fa15afdf6b96481\";a:4:{s:10:\"expiration\";i:1625906422;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624696822;}s:64:\"033f9eade1df59f36ae635a04c7b9df25795599898a60f00d7495ed83c871f69\";a:4:{s:10:\"expiration\";i:1625906422;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624696822;}s:64:\"be9a2ba1c92f3f9d418833ccf3db3dfa3f1a47d543b09d5ea1ad766097411940\";a:4:{s:10:\"expiration\";i:1625936214;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624726614;}s:64:\"f53fccdbb7016c8386bb9821a3ff3b185ba93b6e185ece3c0cdd8ce960dca985\";a:4:{s:10:\"expiration\";i:1625936214;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624726614;}s:64:\"ada8af3a37506b287023ae8659987d49280907f20052b5a77f9a35a66578ac9c\";a:4:{s:10:\"expiration\";i:1625949681;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624740081;}s:64:\"ca0171f94f54e1a07c3d48ce2632ed5aa809420fc25a51d60dcb84d099eab7b9\";a:4:{s:10:\"expiration\";i:1625949681;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624740081;}s:64:\"6c911b2980f234c1dea5270f999456a263d153283209ef8cd4dc706400e1ed90\";a:4:{s:10:\"expiration\";i:1625979377;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624769777;}s:64:\"18954df6437491f5d7cb0a45a162469f384b7d277feb556fe9a0b3abdad27e51\";a:4:{s:10:\"expiration\";i:1625979377;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624769777;}s:64:\"35cc6b8370469f683b611eb719edb402ad2150a97ed7b0bd9eefd0c0c6b8cfbd\";a:4:{s:10:\"expiration\";i:1625993607;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624784007;}s:64:\"506c7eef2c6cddc0331b8caadc11dc812b1f3d241022d626480897a08b2cd1bf\";a:4:{s:10:\"expiration\";i:1625993607;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624784007;}s:64:\"3bbd703598e85aeef49a2c373bec92408c26367cff89ad242437d07bf244d7bc\";a:4:{s:10:\"expiration\";i:1626022653;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624813053;}s:64:\"254b264c4a2a4b65cc92f301f3743ae692508fd3c3840898f2ede8cdc0f4cbc6\";a:4:{s:10:\"expiration\";i:1626022653;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624813053;}s:64:\"25ecd0f093ffc279220f8e81587cdb6283d52b6fc36d330afde9268a52e624fa\";a:4:{s:10:\"expiration\";i:1626036153;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624826553;}s:64:\"6b0703723a568f2871c7154c44c58f800b51ce61121df98aca6694e937075c10\";a:4:{s:10:\"expiration\";i:1626036153;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624826553;}s:64:\"bb378c391e2d6e6aecd945b38d06084a871d64a56115025922b455dc99ca5fdc\";a:4:{s:10:\"expiration\";i:1626066257;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624856657;}s:64:\"74bb17d492e0497e59edde9444cafee162aa34e8631973bb52b0bf0cf9cc3321\";a:4:{s:10:\"expiration\";i:1626066257;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624856657;}s:64:\"54bf5744a5019fcfd00ecdd18981bbab459201c73dde4319ff3591e16e4bccc2\";a:4:{s:10:\"expiration\";i:1626079657;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624870057;}s:64:\"a9b06022e9c19ae16f2ea3c76cd63990fdfc4c61c224a0265685975811f35e10\";a:4:{s:10:\"expiration\";i:1626079657;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624870057;}s:64:\"4acc3d3ff49387a56e14fabb3095ac4b19af90b97bc62252ae22fec5a04ca82f\";a:4:{s:10:\"expiration\";i:1626108975;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624899375;}s:64:\"56ff86cf17a77c9202c35cd3337594c40e6546714db56d6894636c1f532a7dc3\";a:4:{s:10:\"expiration\";i:1626108975;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624899375;}s:64:\"b8ee593b61cdd3a8303c2a870996234d504ed0f976778e39ba0d4c1ba8bbb7d3\";a:4:{s:10:\"expiration\";i:1626122659;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624913059;}s:64:\"bd20b182425b0202f059170a39cf48cf8f4edb6b51db49d8f7e4509b07f892b5\";a:4:{s:10:\"expiration\";i:1626122659;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624913059;}s:64:\"4c781fcb6fe88b5e4846bb47e0bc682de6abdf7c33225abc38eca6bacd1b8aef\";a:4:{s:10:\"expiration\";i:1626152332;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624942732;}s:64:\"e732c97b63d76b1c3bb9e364bb183a87f0077f7f84e5ea6081b62b6378d43c0b\";a:4:{s:10:\"expiration\";i:1626152332;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624942732;}s:64:\"519bd7a4aa6d1e2df675ecdcbefa226a2f3a7a3cc71bf0716bbac7402c6f54aa\";a:4:{s:10:\"expiration\";i:1626165790;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624956190;}s:64:\"78854705a8117ba0583f0207a635fd2464ef74fd6f745b320123d2e5bd4055af\";a:4:{s:10:\"expiration\";i:1626165790;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624956190;}s:64:\"78f61fb404775a245beb095f71905aab7230f75f26aae10777811496a3701525\";a:4:{s:10:\"expiration\";i:1626196117;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624986517;}s:64:\"ca0f97b4f6dccc184375a0cb8ca42e1e4e5bbdef826846e55e4f967f7e4476d2\";a:4:{s:10:\"expiration\";i:1626196117;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1624986517;}s:64:\"cbb2e3a5c7ec81109a8d3f36398c9076b93b7044bc67eb8cc0788bd87efbb34e\";a:4:{s:10:\"expiration\";i:1626209720;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1625000120;}s:64:\"fa956a1b757f022721a68811b2e73854c57c1ca2938026b95f199b75b572042c\";a:4:{s:10:\"expiration\";i:1626209720;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1625000120;}s:64:\"c71054d1043fcab179cdc0ff8d30875cfe5056de3255b3c1246add9e9e7271f0\";a:4:{s:10:\"expiration\";i:1626239148;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1625029548;}s:64:\"f4027bc40d75fb0a6d6b638f3d8378165cf5be4e5bfe680559eb12b79c6ebba1\";a:4:{s:10:\"expiration\";i:1626239148;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1625029548;}s:64:\"7f34f546c99e102ebea6f73a702d2b65543de1f0df05b637e0820f03a958c4cb\";a:4:{s:10:\"expiration\";i:1626252420;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1625042820;}s:64:\"7bceacb9427b7a1fafa3b41a589460c83c484fcad246832860c157eb1ac19654\";a:4:{s:10:\"expiration\";i:1626252420;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1625042820;}s:64:\"b6edb915bf7175062dc4885ada00f6e9b4fac9a5a630a6c5d0cf5c2a8ff60ad4\";a:4:{s:10:\"expiration\";i:1626284456;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1625074856;}s:64:\"cbb3a01f9deea1e07dfcd2e5ed344be05af247c798845731a82a2bb92a5e7d2e\";a:4:{s:10:\"expiration\";i:1626284456;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1625074856;}s:64:\"bc705a4426fffa9a24497fe67c5b761a5e20bfde4b04242c7e168828dea5641b\";a:4:{s:10:\"expiration\";i:1626296046;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1625086446;}s:64:\"f4d91b0aa147cc7c7b3e2113502f58908c9f37d6cc4adc09714f87ec17d364bb\";a:4:{s:10:\"expiration\";i:1626296046;s:2:\"ip\";s:11:\"35.189.8.42\";s:2:\"ua\";s:45:\"WordPress/5.7.2; https://jhdogtraining.com.au\";s:5:\"login\";i:1625086446;}s:64:\"c0cf9d4c570ab871adb538ffb2e3f4e9d5e8e69a52de4d7c94e4f5e10e4eff6d\";a:4:{s:10:\"expiration\";i:1626305524;s:2:\"ip\";s:14:\"150.101.114.73\";s:2:\"ua\";s:121:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.114 Safari/537.36\";s:5:\"login\";i:1625095924;}s:64:\"6672413fdf327029752c45407073d7c6e4f9221ad4e50013402f4e2abdf0dca4\";a:4:{s:10:\"expiration\";i:1626305524;s:2:\"ip\";s:14:\"150.101.114.73\";s:2:\"ua\";s:121:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.114 Safari/537.36\";s:5:\"login\";i:1625095924;}s:64:\"1af21cf75c1a549c564a9b418f2330acf1b8e956833ad967b5deccebe1eeb5be\";a:4:{s:10:\"expiration\";i:1626306468;s:2:\"ip\";s:14:\"150.101.114.73\";s:2:\"ua\";s:121:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.114 Safari/537.36\";s:5:\"login\";i:1625096868;}s:64:\"231c2da6656b85b91f4b66200c98c4769ffb50ae38f1636519dd597714b99d49\";a:4:{s:10:\"expiration\";i:1626306468;s:2:\"ip\";s:14:\"150.101.114.73\";s:2:\"ua\";s:121:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.114 Safari/537.36\";s:5:\"login\";i:1625096868;}s:64:\"6c52dfb3c837c975cacf1f79d0bad6f80e765bf51ba72eb73c2c7e8ead9728af\";a:4:{s:10:\"expiration\";i:1626306469;s:2:\"ip\";s:14:\"150.101.114.73\";s:2:\"ua\";s:121:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.114 Safari/537.36\";s:5:\"login\";i:1625096869;}s:64:\"9b117c1ea32ecf44b7e113dc110dc931884dad46b70ef115988084a9fe383826\";a:4:{s:10:\"expiration\";i:1626306469;s:2:\"ip\";s:14:\"150.101.114.73\";s:2:\"ua\";s:121:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.114 Safari/537.36\";s:5:\"login\";i:1625096869;}s:64:\"139a468f94099bb160767da4a85d56cd8819444a71fa7807bec36ef12858f7e7\";a:4:{s:10:\"expiration\";i:1626307594;s:2:\"ip\";s:13:\"54.191.137.17\";s:2:\"ua\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.94 Safari/537.36\";s:5:\"login\";i:1625097994;}s:64:\"d952a7f40197968913e91aad61d7caffafeb97d27fe40c861e4254d868dff1c8\";a:4:{s:10:\"expiration\";i:1626307594;s:2:\"ip\";s:13:\"54.191.137.17\";s:2:\"ua\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.94 Safari/537.36\";s:5:\"login\";i:1625097994;}s:64:\"17f8223c4c721fcff6829cdc8beb555bd2bd1a3117b56e637f5cf08bc5dc88d8\";a:4:{s:10:\"expiration\";i:1626307599;s:2:\"ip\";s:13:\"54.191.137.17\";s:2:\"ua\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.94 Safari/537.36\";s:5:\"login\";i:1625097999;}s:64:\"2469297b4b96ca2fca305099e7dc73be87c20013c1629c7385dae3670732b356\";a:4:{s:10:\"expiration\";i:1626307599;s:2:\"ip\";s:13:\"54.191.137.17\";s:2:\"ua\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.94 Safari/537.36\";s:5:\"login\";i:1625097999;}s:64:\"c0584611427cd25311444fb97f7450fa8920ddb829f6d52ddf133495b0ae9a7a\";a:4:{s:10:\"expiration\";i:1627690018;s:2:\"ip\";s:13:\"54.191.137.17\";s:2:\"ua\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.94 Safari/537.36\";s:5:\"login\";i:1625098018;}s:64:\"e34b8106429375c638e2f052451941c467037f7e17e6c7e140501780a7697661\";a:4:{s:10:\"expiration\";i:1627690018;s:2:\"ip\";s:13:\"54.191.137.17\";s:2:\"ua\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.94 Safari/537.36\";s:5:\"login\";i:1625098018;}s:64:\"765b5c27b03d5ed2254fe667b8888d68ce182f77c6976b7a765ab4b57c1de138\";a:4:{s:10:\"expiration\";i:1626307618;s:2:\"ip\";s:13:\"54.191.137.17\";s:2:\"ua\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.94 Safari/537.36\";s:5:\"login\";i:1625098018;}s:64:\"abf5cc2da287a8ebd952ab8a5db98c864bf4eaa36544d8883d22d699af52c4cf\";a:4:{s:10:\"expiration\";i:1626307618;s:2:\"ip\";s:13:\"54.191.137.17\";s:2:\"ua\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.94 Safari/537.36\";s:5:\"login\";i:1625098018;}s:64:\"2c6268086fc6f437562c8b597d81703a612aed50e525b97a11964639948a60cd\";a:4:{s:10:\"expiration\";i:1627690255;s:2:\"ip\";s:13:\"54.191.137.17\";s:2:\"ua\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.94 Safari/537.36\";s:5:\"login\";i:1625098255;}s:64:\"97fc598323367fa9a5baef21556d6eb3756c642167d97cce0522f9c8b5688b02\";a:4:{s:10:\"expiration\";i:1627690255;s:2:\"ip\";s:13:\"54.191.137.17\";s:2:\"ua\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.94 Safari/537.36\";s:5:\"login\";i:1625098255;}s:64:\"8a4be7731912de492dd9a2712e7c754b46f2baa3383f80451725c810d9c66180\";a:4:{s:10:\"expiration\";i:1626307855;s:2:\"ip\";s:13:\"54.191.137.17\";s:2:\"ua\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.94 Safari/537.36\";s:5:\"login\";i:1625098255;}s:64:\"dc7a059e5b3c211b25b60b1edcbde8e7544d229cf715f2a23515ec21914c548b\";a:4:{s:10:\"expiration\";i:1626307855;s:2:\"ip\";s:13:\"54.191.137.17\";s:2:\"ua\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.94 Safari/537.36\";s:5:\"login\";i:1625098255;}s:64:\"a75dbfe3c78724aaaae2c12826af81b06070a00e6ad640a86b6a9e37cf7a14c4\";a:4:{s:10:\"expiration\";i:1626307866;s:2:\"ip\";s:14:\"150.101.114.73\";s:2:\"ua\";s:121:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.114 Safari/537.36\";s:5:\"login\";i:1625098266;}s:64:\"a8f098766022539e3fce68d2b038bae9e181f0dba1d9c08c44c7e260f0c90789\";a:4:{s:10:\"expiration\";i:1626307866;s:2:\"ip\";s:14:\"150.101.114.73\";s:2:\"ua\";s:121:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.114 Safari/537.36\";s:5:\"login\";i:1625098266;}s:64:\"5158cef039f239ccae7894928f547f43dc5bfc9d6f4aa32083167699cfb3c0d4\";a:4:{s:10:\"expiration\";i:1627695622;s:2:\"ip\";s:13:\"54.191.137.17\";s:2:\"ua\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.94 Safari/537.36\";s:5:\"login\";i:1625103622;}s:64:\"f7932616f68b821aa90f6366bf9a4fc2c819c0ad2741ef0f9d1f429bf8c8d65f\";a:4:{s:10:\"expiration\";i:1627695622;s:2:\"ip\";s:13:\"54.191.137.17\";s:2:\"ua\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.94 Safari/537.36\";s:5:\"login\";i:1625103622;}s:64:\"9421554fff9db969ae6094c0ea9189039dca421efce630565ef0086e25c5acfd\";a:4:{s:10:\"expiration\";i:1626313223;s:2:\"ip\";s:13:\"54.191.137.17\";s:2:\"ua\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.94 Safari/537.36\";s:5:\"login\";i:1625103623;}s:64:\"57ff223f541901e53be1bc76de01b3e4c3ae52b80e0542dad7e4c3028adac6b5\";a:4:{s:10:\"expiration\";i:1626313223;s:2:\"ip\";s:13:\"54.191.137.17\";s:2:\"ua\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.94 Safari/537.36\";s:5:\"login\";i:1625103623;}s:64:\"0a1628c32fd91e53407b5bf07f7a9c922ff083e4d8d1e5e45ecf950050599fd1\";a:4:{s:10:\"expiration\";i:1626315805;s:2:\"ip\";s:13:\"27.76.182.129\";s:2:\"ua\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36\";s:5:\"login\";i:1625106205;}s:64:\"52b28cd9f45730aa3b2c9f2554506755642ba88b52861a3f905713bde5d4a127\";a:4:{s:10:\"expiration\";i:1626315805;s:2:\"ip\";s:13:\"27.76.182.129\";s:2:\"ua\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36\";s:5:\"login\";i:1625106205;}s:64:\"21ee1116b59fcd9ccba37fce932defdffb88a89676760fb7114e463ff128e880\";a:4:{s:10:\"expiration\";i:1626315874;s:2:\"ip\";s:13:\"27.76.182.129\";s:2:\"ua\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36\";s:5:\"login\";i:1625106274;}s:64:\"470c6445891bee771761296d9ad0b16cd1fbdb4220853c7f3254651a44105a3b\";a:4:{s:10:\"expiration\";i:1626315874;s:2:\"ip\";s:13:\"27.76.182.129\";s:2:\"ua\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36\";s:5:\"login\";i:1625106274;}s:64:\"a60ff594b0ddb3fbc16b5545ac5ddb2712d3fb77fce56438b3e89ed5b9d7c90b\";a:4:{s:10:\"expiration\";i:1626315883;s:2:\"ip\";s:13:\"27.76.182.129\";s:2:\"ua\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36\";s:5:\"login\";i:1625106284;}s:64:\"b7dec109056ee0eca2be85d27437ce39ee1ce61432991ca935a72730457b6c13\";a:4:{s:10:\"expiration\";i:1626315883;s:2:\"ip\";s:13:\"27.76.182.129\";s:2:\"ua\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36\";s:5:\"login\";i:1625106284;}}'),
('151', '4', '_itsec_has_logged_in', '1598158464'),
('152', '4', 'itsec_user_activity_last_seen', '1625103623'),
('153', '2', 'ignore_ssapi_notice', '1'),
('154', '4', 'wp_dashboard_quick_press_last_post_id', '205273'),
('155', '4', 'community-events-location', 'a:1:{s:2:\"ip\";s:11:\"24.68.112.0\";}'),
('157', '2', 'session_tokens', 'a:7:{s:64:\"7f32594394fc87b7309719a76b4a70048f7e5c06cac0c40747c84674709a67a1\";a:4:{s:10:\"expiration\";i:1625268704;s:2:\"ip\";s:14:\"150.101.114.73\";s:2:\"ua\";s:121:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.114 Safari/537.36\";s:5:\"login\";i:1625095904;}s:64:\"af6cc67c08cb3bde4df0fce4308e4ca6976563b139735d86dc3f071f271286fd\";a:4:{s:10:\"expiration\";i:1625270783;s:2:\"ip\";s:13:\"54.191.137.17\";s:2:\"ua\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.94 Safari/537.36\";s:5:\"login\";i:1625097983;}s:64:\"549a7b359d6375a8248a927403f2bc660cd665b71f4f0e17b921d53fadc8701b\";a:4:{s:10:\"expiration\";i:1627690004;s:2:\"ip\";s:13:\"54.191.137.17\";s:2:\"ua\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.94 Safari/537.36\";s:5:\"login\";i:1625098004;}s:64:\"383745ac1050f2525e51b1862bbbb77d49b0ce25dba0f1b45202a3ade6831378\";a:4:{s:10:\"expiration\";i:1627690004;s:2:\"ip\";s:13:\"54.191.137.17\";s:2:\"ua\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.94 Safari/537.36\";s:5:\"login\";i:1625098004;}s:64:\"4890539d607df33d568285b2992f514a5e6540cc70c4fa01a17091fd393fc3c2\";a:4:{s:10:\"expiration\";i:1627690004;s:2:\"ip\";s:13:\"54.191.137.17\";s:2:\"ua\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.94 Safari/537.36\";s:5:\"login\";i:1625098004;}s:64:\"538942dd867bbb109a6c349b4bc884934cb2df215a9284e7a586a9ed40da3773\";a:4:{s:10:\"expiration\";i:1627690004;s:2:\"ip\";s:13:\"54.191.137.17\";s:2:\"ua\";s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.94 Safari/537.36\";s:5:\"login\";i:1625098004;}s:64:\"e41b912e0b542c05d6a15f8b8cc61b02a2ecc5cebc766d18e950975bfa15e7aa\";a:4:{s:10:\"expiration\";i:1625278985;s:2:\"ip\";s:13:\"27.76.182.129\";s:2:\"ua\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36\";s:5:\"login\";i:1625106185;}}'),
('159', '2', 'AkeebaSession_d3e59c5f93467b6b93a8362862c20a57', 'a:8:{s:9:\"insideCMS\";b:1;s:22:\"platformNameForUpdates\";s:9:\"wordpress\";s:25:\"platformVersionForUpdates\";s:5:\"5.7.2\";s:7:\"user_id\";i:2;s:13:\"newSecretWord\";N;s:7:\"__flash\";a:0:{}s:7:\"profile\";i:1;s:15:\"update_password\";s:44:\"xSmK32U275cRWuDwoVypQehT+V85OBVTgm5KAHy79/0=\";}'),
('160', '2', 'AkeebaSession_ba19a440619a16bbc773c5f1ed30bf68', 'a:1:{s:5:\"value\";s:128:\"f5f19d0c33140c5eb2cc82c277b1fe85725de327bb4c7a30507b708d60bad67d8e02d62567c3b1ae56ddf2398c13d8f1a06485becce1da4929a55b731673de3e\";}'),
('205', '2', 'AkeebaSession_7d7d2718644b93cd6f10d19ed7d851b8', NULL);
/**ABDB**/DROP TABLE IF EXISTS `wp_terms`;
/**ABDB**/CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `wp_terms`  VALUES 
('1', 'Uncategorized', 'uncategorized', '0'),
('2', 'layout', 'layout', '0'),
('3', 'not_global', 'not_global', '0'),
('4', 'regular', 'regular', '0'),
('5', 'Main Menu', 'main-menu', '0'),
('6', 'Top menu', 'top-menu', '0'),
('7', 'On The Road With Buddy', 'on-the-road-with-buddy', '0'),
('8', 'Bark &amp; Lunge Remedy', 'bark-lunge-remedy', '0'),
('9', 'Cautious Canines', 'cautious-canines', '0'),
('10', 'Other', 'other', '0'),
('11', 'Other', 'other', '0'),
('12', 'Essential Skills', 'essential-skills', '0');
/**ABDB**/DROP TABLE IF EXISTS `wp_termmeta`;
/**ABDB**/CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `wp_termmeta`  VALUES 
('1', '12', 'tax_position', '1'),
('2', '11', 'tax_position', '3'),
('3', '8', 'tax_position', '2'),
('4', '9', 'tax_position', '3'),
('5', '7', 'tax_position', '1'),
('6', '10', 'tax_position', '4');
/**ABDB**/DROP TABLE IF EXISTS `wp_term_taxonomy`;
/**ABDB**/CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `wp_term_taxonomy`  VALUES 
('1', '1', 'category', '', '0', '10'),
('2', '2', 'layout_type', '', '0', '4'),
('3', '3', 'scope', '', '0', '4'),
('4', '4', 'module_width', '', '0', '4'),
('5', '5', 'nav_menu', '', '0', '9'),
('6', '6', 'nav_menu', '', '0', '2'),
('7', '7', 'pr_video_types', '', '0', '2'),
('8', '8', 'pr_video_types', '', '0', '0'),
('9', '9', 'pr_video_types', '', '0', '0'),
('10', '10', 'pr_video_types', '', '0', '0'),
('11', '11', 'video_types', '', '0', '0'),
('12', '12', 'video_types', '', '0', '3');
/**ABDB**/DROP TABLE IF EXISTS `wp_term_relationships`;
/**ABDB**/CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `wp_term_relationships`  VALUES 
('47106', '2', '0'),
('47106', '3', '0'),
('47106', '4', '0'),
('204548', '2', '0'),
('204548', '3', '0'),
('204548', '4', '0'),
('204554', '5', '0'),
('204558', '5', '0'),
('204560', '5', '0'),
('204563', '5', '0'),
('204605', '5', '0'),
('204607', '5', '0'),
('204653', '1', '0'),
('204673', '1', '0'),
('204736', '1', '0'),
('204758', '1', '0'),
('204806', '2', '0'),
('204806', '3', '0'),
('204806', '4', '0'),
('204815', '2', '0'),
('204815', '3', '0'),
('204815', '4', '0'),
('204822', '6', '0'),
('204823', '6', '0'),
('204841', '7', '0'),
('204842', '7', '0'),
('204859', '12', '0'),
('204867', '12', '0'),
('204868', '12', '0'),
('204879', '5', '0'),
('204886', '1', '0'),
('204921', '1', '0'),
('205083', '5', '0'),
('205084', '5', '0'),
('205121', '1', '0'),
('205124', '1', '0'),
('205146', '1', '0'),
('205193', '1', '0');
/**ABDB**/DROP TABLE IF EXISTS `wp_posts`;
/**ABDB**/CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=205280 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `wp_posts`  VALUES 
('40', '1', '2017-11-20 14:18:06', '2017-11-20 14:18:06', 'input.wpcf7-form-control {\r\n    width: 100%;\r\n    padding: 16px;\r\n    border: none;\r\n    -webkit-border-radius: 0;\r\n    -moz-border-radius: 0;\r\n    border-radius: 0;\r\n    color: #999;\r\n    background-color: #eee;\r\n    font-size: 14px;\r\n    margin-bottom: 10px;\r\n}\r\n\r\ninput[type=\"submit\"].wpcf7-form-control  {\r\n    color: #1f1e86 !important;\r\n    cursor: pointer;\r\n    border:  2px solid #1f1e86;\r\n}\r\n\r\ntextarea.wpcf7-form-control {\r\n    width: 100%;\r\n    padding: 16px;\r\n    border: none;\r\n    -webkit-border-radius: 0;\r\n    -moz-border-radius: 0;\r\n    border-radius: 0;\r\n    color: #999;\r\n    background-color: #eee;\r\n    font-size: 14px;\r\n    margin-bottom: 10px;\r\n}\r\n\r\n.fwidget  {\r\n  text-align: center;  \r\nwidth: 100%;\r\n}\r\n\r\n#footer-icons {\r\n  float:none;\r\n  text-align: center;\r\n}\r\n\r\n.et-social-icon {\r\n  display: inline-block;\r\n  margin: 0 5px !important;\r\n  padding: 0 !important;\r\n}\r\n\r\n.et-social-icon:before {\r\n  display:none;\r\n}\r\n\r\n#footer-logos {\r\n  text-align: center;\r\n}\r\n\r\n#footer-logos>img{\r\n  margin: 0 5px;\r\n}\r\n\r\n#footer-info {\r\n  float: none;\r\n}\r\n\r\n#bottom-bar-text {\r\n  text-align: center;\r\n}', 'Divi', '', 'publish', 'closed', 'closed', '', 'divi', '', '', '2018-01-11 11:31:38', '2018-01-11 11:31:38', '', '0', 'http://jhdogtraining.wpengine.com/divi/', '0', 'custom_css', '', '0'),
('41', '1', '2017-11-20 14:19:11', '2017-11-20 14:19:11', '', 'logo', '', 'inherit', 'open', 'closed', '', 'logo', '', '', '2017-11-20 14:19:11', '2017-11-20 14:19:11', '', '0', 'http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/logo.png', '0', 'attachment', 'image/png', '0'),
('42', '1', '2017-11-20 14:29:34', '2017-11-20 14:29:34', '[et_pb_section bb_built=\"1\" module_class=\"home-banner\" _builder_version=\"3.12.2\" background_image=\"https://jhdogtraining.com.au/wp-content/uploads/2017/12/AdobeStock_180762320_o.jpg\" custom_padding=\"100px||100px|\" next_background_color=\"#f6f6f6\"][et_pb_row custom_padding=\"||0px|\" custom_margin=\"||0px|\" _builder_version=\"3.12.2\"][et_pb_column type=\"1_2\"][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_text _builder_version=\"3.2.2\" text_font=\"|700|||||||\" text_font_size=\"48px\" header_font=\"|700|||||||\" header_text_color=\"#ffffff\" header_font_size=\"48px\" header_line_height=\"1.2em\" custom_margin=\"200px|||\"]\r\n\r\n<h1>Better training for a better behaved dog</h1>\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section bb_built=\"1\" _builder_version=\"3.12.2\" background_color=\"#f6f6f6\" custom_margin=\"||0px|\" custom_padding=\"||0px|\" prev_background_color=\"#ffffff\" next_background_color=\"#000000\"][et_pb_row _builder_version=\"3.12.2\"][et_pb_column type=\"4_4\"][et_pb_text _builder_version=\"3.2.2\" header_text_color=\"#1f1e86\"]\r\n\r\n<h1 style=\"text-align: center;\"><strong>Better training for a better-behaved dog</strong></h1>\r\n<p style=\"text-align: center;\">Feeling frustrated by your dog’s behaviour? Not sure where to turn? Jenny is here to help! In addition to specializing in the treatment of separation anxiety, she helps owners solve common behaviour issues like barking, chewing and lunging. Using only science-based, positive-reinforcement techniques,  Jenny knows how to bring out the very best in your best friend!.</p>\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section bb_built=\"1\" _builder_version=\"3.12.2\" background_color=\"#f6f6f6\" custom_margin=\"0px|||\" custom_padding=\"0px|||\" prev_background_color=\"#000000\" next_background_color=\"#ffffff\"][et_pb_row _builder_version=\"3.0.48\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"4_4\"][et_pb_button button_url=\"/blog/\" button_text=\"click here to read Jenny’s latest blog\" button_alignment=\"center\" _builder_version=\"3.0.89\" custom_button=\"on\" button_text_color=\"#000084\" button_border_color=\"#000084\" /][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section bb_built=\"1\" _builder_version=\"3.0.47\" prev_background_color=\"#f6f6f6\" next_background_color=\"#000000\"][et_pb_row disabled_on=\"off|off|\" module_class=\"switch-image\" _builder_version=\"3.0.89\"][et_pb_column type=\"1_2\"][et_pb_text _builder_version=\"3.0.89\" header_text_color=\"#1f1e86\"]\r\n\r\n<h1 style=\"text-align: right;\"><strong>Separation Anxiety</strong></h1>\r\n<p style=\"text-align: right;\">Separation anxiety is a devastating and stressful condition. But there is hope! As Australia’s first Certified Separation Anxiety Trainer (CSAT), Jenny’s compassionate, knowledgeable approach will bring peace and harmony back to your home.</p>\r\n\r\n[/et_pb_text][et_pb_button button_url=\"/separation-anxiety/\" button_text=\"Learn More\" button_alignment=\"right\" _builder_version=\"3.0.89\" custom_button=\"on\" button_text_color=\"#000084\" button_border_color=\"#000084\" /][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_image src=\"/wp-content/uploads/2017/12/sepanx-terrier.jpg\" _builder_version=\"3.12.2\" /][/et_pb_column][/et_pb_row][et_pb_row _builder_version=\"3.0.89\"][et_pb_column type=\"1_2\"][et_pb_image src=\"/wp-content/uploads/2017/12/IMG_2019_o.jpg\" _builder_version=\"3.12.2\" /][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_text _builder_version=\"3.0.89\" header_text_color=\"#1f1e86\"]\r\n\r\n<h1><strong>Private Training</strong></h1>\r\nNeed help with your dog but can’t attend group training class? Private training lessons are tailor-made to address your needs and your dog’s behaviour problems, at a time and place that suits you.\r\n\r\n[/et_pb_text][et_pb_button button_url=\"/private-training/\" button_text=\"Learn More\" _builder_version=\"3.0.89\" custom_button=\"on\" button_text_color=\"#000084\" button_border_color=\"#000084\" /][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section bb_built=\"1\" _builder_version=\"3.0.47\" prev_background_color=\"#000000\" next_background_color=\"#1f1e86\"][et_pb_row module_class=\"switch-image\" _builder_version=\"3.0.89\"][et_pb_column type=\"1_2\"][et_pb_text _builder_version=\"3.0.89\" header_text_color=\"#1f1e86\"]\r\n\r\n<h1 class=\"et_pb_module_header\" style=\"text-align: right;\"><strong>Premium Puppy</strong></h1>\r\n<div class=\"et_pb_blurb_description\">\r\n<p style=\"text-align: right;\">If your new puppy has just arrived, or you are thinking of getting one, calm the chaos of those first few weeks and months with a Premium Puppy package. An individual package to address your puppy-related concerns and questions at a time and place convenient for you.</p>\r\n\r\n</div>\r\n\r\n[/et_pb_text][et_pb_button button_url=\"/premium-puppy/\" button_text=\"Learn More\" button_alignment=\"right\" _builder_version=\"3.0.89\" custom_button=\"on\" button_text_color=\"#000084\" button_border_color=\"#000084\" /][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_image src=\"/wp-content/uploads/2017/12/AdobeStock_119270241_o.jpg\" _builder_version=\"3.12.2\" /][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section bb_built=\"1\" _builder_version=\"3.0.89\" background_color=\"#1f1e86\" prev_background_color=\"#ffffff\" next_background_color=\"#ffffff\"][et_pb_row _builder_version=\"3.12.2\"][et_pb_column type=\"4_4\"][et_pb_blurb title=\"Receive Jenny’s free training tips.\" use_icon=\"on\" font_icon=\"%%45%%\" icon_color=\"#ffffff\" _builder_version=\"3.12\" header_level=\"h2\" header_text_color=\"#ffffff\" text_orientation=\"center\" background_layout=\"dark\" /][et_pb_button button_url=\"https://jennyharlowdogtraining.activehosted.com/f/19%20\" url_new_window=\"on\" button_text=\"Training Tips\" button_alignment=\"center\" _builder_version=\"3.12.2\" custom_button=\"on\" button_text_color=\"#ffffff\" button_border_color=\"#ffffff\" /][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section bb_built=\"1\" _builder_version=\"3.0.47\" prev_background_color=\"#1f1e86\"][et_pb_row module_class=\"switch-image\" _builder_version=\"3.0.89\"][et_pb_column type=\"3_4\"][et_pb_text _builder_version=\"3.0.89\" header_text_color=\"#1f1e86\"]\r\n\r\n<h1 style=\"text-align: right;\"><strong>About Jenny</strong></h1>\r\n<p style=\"text-align: right;\">Jenny Harlow is a professional dog trainer who understands the unique training challenges and time constraints faced by today’s dog owners. As a Certified Separation Anxiety Trainer, an accredited Canine Good Citizen trainer, and a member of the Association of Pet Dog Trainers Australia, she has both the knowledge and experience to helpher clients and their dogs succeed for a lifetime.</p>\r\n\r\n[/et_pb_text][et_pb_button button_url=\"/abbout-jenny/\" button_text=\"Learn More\" button_alignment=\"right\" _builder_version=\"3.0.89\" custom_button=\"on\" button_text_color=\"#000084\" button_border_color=\"#000084\" /][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_image src=\"/wp-content/uploads/2017/12/Jenny-Bonnie-laying-in-the-grass.jpg\" _builder_version=\"3.12.2\" /][/et_pb_column][/et_pb_row][/et_pb_section]', 'Home', '', 'publish', 'closed', 'closed', '', 'home', '', '', '2018-09-14 19:25:56', '2018-09-14 19:25:56', '', '0', 'http://jhdogtraining.wpengine.com/?page_id=42', '0', 'page', '', '0'),
('43', '1', '2017-11-20 14:28:25', '2017-11-20 14:28:25', '', 'bulldog-lead-in-mouth', '', 'inherit', 'open', 'closed', '', 'bulldog-lead-in-mouth', '', '', '2017-11-20 14:28:25', '2017-11-20 14:28:25', '', '42', 'http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/bulldog-lead-in-mouth.jpg', '0', 'attachment', 'image/jpeg', '0'),
('47106', '1', '2017-10-16 09:16:54', '2017-10-16 09:16:54', '[et_pb_section fb_built=\"1\" admin_label=\"Landing Hero\" _builder_version=\"3.0.82\" use_background_color_gradient=\"on\" background_color_gradient_start=\"#474ab6\" background_color_gradient_end=\"#9271f6\" background_image=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/coding-background-texture.jpg\" background_blend=\"overlay\" custom_padding=\"100px|0px|100px|0px\" animation_style=\"slide\" animation_direction=\"top\" animation_intensity_slide=\"2%\" locked=\"off\"][et_pb_row custom_width_px=\"1280px\" custom_margin=\"|||\" _builder_version=\"3.0.82\"][et_pb_column type=\"1_2\" _builder_version=\"3.0.82\" parallax=\"off\" parallax_method=\"on\"][et_pb_text background_layout=\"dark\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_font_size=\"42px\" header_font_size_last_edited=\"off|desktop\" header_line_height=\"1.3em\" custom_padding=\"|||\" locked=\"off\"]<h1>Learn to Code Websites, Apps & Games</h1>[/et_pb_text][et_pb_text _builder_version=\"3.0.82\" text_font_size=\"16px\" text_text_color=\"#d4ccff\" text_line_height=\"1.9em\" locked=\"off\"]<p>Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Sed molestie, velit ut eleifend sollicitudin, neque orci tempor nulla, id sagittis nisi ante nec arcu.</p>[/et_pb_text][et_pb_button button_url=\"#\" button_text=\"View Courses\" _builder_version=\"3.0.82\" custom_margin=\"20px|||\" custom_button=\"on\" button_text_size=\"16px\" button_text_color=\"#ffffff\" button_bg_color=\"#09e1c0\" button_border_width=\"10px\" button_border_color=\"#09e1c0\" button_border_radius=\"100px\" button_letter_spacing=\"1px\" button_font=\"|on||on|\" button_icon=\"%%36%%\" button_on_hover=\"off\" button_letter_spacing_hover=\"2px\" animation_style=\"zoom\" animation_delay=\"100ms\" animation_intensity_zoom=\"10%\" box_shadow_style=\"preset1\" box_shadow_vertical=\"10px\" box_shadow_blur=\"50px\" box_shadow_spread=\"5px\" box_shadow_color=\"rgba(0,188,160,0.6)\" saved_tabs=\"all\" locked=\"off\"][/et_pb_button][/et_pb_column][et_pb_column type=\"1_2\" _builder_version=\"3.0.82\" parallax=\"off\" parallax_method=\"on\"][et_pb_image src=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/coding-isometric-01.png\" _builder_version=\"3.0.82\" custom_margin=\"|||\" custom_padding=\"|||\" animation_style=\"zoom\" animation_direction=\"left\" animation_delay=\"100ms\" animation_intensity_zoom=\"20%\"][/et_pb_image][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" specialty=\"on\" admin_label=\"All Courses\" _builder_version=\"3.0.82\" custom_padding=\"100px|0px|100px|0px\"][et_pb_column type=\"1_3\" _builder_version=\"3.0.47\"][et_pb_text _builder_version=\"3.0.82\" text_text_color=\"#7272ff\" header_font=\"|on|||\" header_font_size=\"36px\" header_text_color=\"#7272ff\" header_line_height=\"1.5em\" custom_margin=\"||20px|\" animation_style=\"slide\" animation_direction=\"bottom\" animation_intensity_slide=\"10%\" locked=\"off\"]<h1>100\'s of Courses</h1>[/et_pb_text][et_pb_divider color=\"#09e1c0\" show_divider=\"on\" divider_weight=\"4px\" disabled_on=\"on|on|off\" _builder_version=\"3.0.82\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\" max_width=\"40px\" module_alignment=\"left\" custom_margin=\"||10px|\" animation_style=\"zoom\" animation_direction=\"left\" saved_tabs=\"all\" locked=\"off\"][/et_pb_divider][et_pb_text _builder_version=\"3.0.82\" text_font_size=\"16px\" text_text_color=\"#8585bd\" text_line_height=\"1.9em\" animation_style=\"zoom\" animation_intensity_zoom=\"6%\" locked=\"off\"]<p><span style=\"color: #2e2545;\"><strong>Class aptent taciti sociosqu ad litora torquent per conubia nostra</strong></span></p>\n<p>himenaeos. Sed molestie, velit ut eleifend sollicitudin, neque orci tempor nulla, id sagittis nisi ante nec arcu. Fusce porta bibendum convallis. Morbi fringilla sollicitudin scelerisque. In pellentesque</p>[/et_pb_text][et_pb_button button_url=\"#\" button_text=\"View All Courses\" button_alignment=\"left\" _builder_version=\"3.0.82\" custom_margin=\"20px|||\" custom_button=\"on\" button_text_size=\"16px\" button_text_color=\"#ffffff\" button_bg_color=\"#7272ff\" button_border_width=\"10px\" button_border_color=\"#7272ff\" button_border_radius=\"100px\" button_letter_spacing=\"1px\" button_font=\"|on||on|\" button_icon=\"%%36%%\" button_on_hover=\"off\" button_letter_spacing_hover=\"2px\" animation_style=\"zoom\" animation_delay=\"100ms\" animation_intensity_zoom=\"6%\" box_shadow_style=\"preset1\" box_shadow_vertical=\"10px\" box_shadow_blur=\"50px\" box_shadow_spread=\"5px\" box_shadow_color=\"rgba(114,114,255,0.4)\" saved_tabs=\"all\" locked=\"off\"][/et_pb_button][/et_pb_column][et_pb_column type=\"2_3\" specialty_columns=\"2\" _builder_version=\"3.0.47\"][et_pb_row_inner custom_padding=\"0px|0px|0px|0px\" use_custom_gutter=\"on\" gutter_width=\"1\" module_class_1=\"et_pb_column_1_2\" module_class_2=\"et_pb_column_1_2\" _builder_version=\"3.0.82\" animation_style=\"zoom\" animation_intensity_zoom=\"6%\" box_shadow_style=\"preset1\" box_shadow_vertical=\"10px\" box_shadow_blur=\"60px\" box_shadow_color=\"rgba(71,74,182,0.12)\"][et_pb_column_inner type=\"1_2\" saved_specialty_column_type=\"2_3\" _builder_version=\"3.0.47\" box_shadow_horizontal=\"0px\" box_shadow_vertical=\"2px\" box_shadow_blur=\"18px\" box_shadow_spread=\"0px\" box_shadow_position=\"outer\" parallax=\"off\" parallax_method=\"on\" module_class=\"et_pb_column_1_2\"][et_pb_blurb title=\"Web Development\" url=\"#\" image=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/coding-icon_8.jpg\" icon_placement=\"left\" image_max_width=\"64px\" content_max_width=\"1100px\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" header_line_height=\"1.5em\" body_text_color=\"#8585bd\" body_line_height=\"1.9em\" background_color=\"#ffffff\" custom_margin=\"|||\" custom_padding=\"30px|30px|30px|30px\" animation_style=\"zoom\" animation_direction=\"bottom\" animation_intensity_zoom=\"20%\" animation_starting_opacity=\"100%\" box_shadow_style=\"preset7\" box_shadow_horizontal=\"-1px\" box_shadow_vertical=\"-1px\" box_shadow_color=\"rgba(71,74,182,0.12)\" locked=\"off\"]<p>Duis egestas aliquet aliquet. Maecenas erat eros, fringilla et leo eget, viverra pretium nulla.</p>[/et_pb_blurb][et_pb_blurb title=\"Python\" url=\"#\" image=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/coding-icon_1.jpg\" icon_placement=\"left\" image_max_width=\"64px\" content_max_width=\"1100px\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" header_line_height=\"1.5em\" body_text_color=\"#8585bd\" body_line_height=\"1.9em\" background_color=\"#ffffff\" custom_margin=\"|||\" custom_padding=\"30px|30px|30px|30px\" animation_style=\"zoom\" animation_direction=\"bottom\" animation_intensity_zoom=\"20%\" animation_starting_opacity=\"100%\" box_shadow_style=\"preset7\" box_shadow_horizontal=\"-1px\" box_shadow_vertical=\"-1px\" box_shadow_color=\"rgba(71,74,182,0.12)\" locked=\"off\"]<p>Duis egestas aliquet aliquet. Maecenas erat eros, fringilla et leo eget, viverra pretium nulla.</p>[/et_pb_blurb][et_pb_blurb title=\"UX Design\" url=\"#\" image=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/coding-icon_3.jpg\" icon_placement=\"left\" image_max_width=\"64px\" content_max_width=\"1100px\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" header_line_height=\"1.5em\" body_text_color=\"#8585bd\" body_line_height=\"1.9em\" background_color=\"#ffffff\" custom_margin=\"|||\" custom_padding=\"30px|30px|30px|30px\" animation_style=\"zoom\" animation_direction=\"bottom\" animation_intensity_zoom=\"20%\" animation_starting_opacity=\"100%\" box_shadow_style=\"preset7\" box_shadow_horizontal=\"-1px\" box_shadow_vertical=\"-1px\" box_shadow_color=\"rgba(71,74,182,0.12)\" locked=\"off\"]<p>Duis egestas aliquet aliquet. Maecenas erat eros, fringilla et leo eget, viverra pretium nulla.</p>[/et_pb_blurb][et_pb_blurb title=\"Database Design\" url=\"#\" image=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/coding-icon_5.jpg\" icon_placement=\"left\" image_max_width=\"64px\" content_max_width=\"1100px\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" header_line_height=\"1.5em\" body_text_color=\"#8585bd\" body_line_height=\"1.9em\" background_color=\"#ffffff\" custom_margin=\"|||\" custom_padding=\"30px|30px|30px|30px\" animation_style=\"zoom\" animation_direction=\"bottom\" animation_intensity_zoom=\"20%\" animation_starting_opacity=\"100%\" box_shadow_style=\"preset7\" box_shadow_horizontal=\"-1px\" box_shadow_vertical=\"-1px\" box_shadow_color=\"rgba(71,74,182,0.12)\" locked=\"off\"]<p>Duis egestas aliquet aliquet. Maecenas erat eros, fringilla et leo eget, viverra pretium nulla.</p>[/et_pb_blurb][/et_pb_column_inner][et_pb_column_inner type=\"1_2\" saved_specialty_column_type=\"2_3\" _builder_version=\"3.0.47\" box_shadow_horizontal=\"0px\" box_shadow_vertical=\"2px\" box_shadow_blur=\"18px\" box_shadow_spread=\"0px\" box_shadow_position=\"outer\" parallax=\"off\" parallax_method=\"on\" module_class=\"et_pb_column_1_2\"][et_pb_blurb title=\"Javascript\" url=\"#\" image=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/coding-icon_7.jpg\" icon_placement=\"left\" image_max_width=\"64px\" content_max_width=\"1100px\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" header_line_height=\"1.5em\" body_text_color=\"#8585bd\" body_line_height=\"1.9em\" background_color=\"#ffffff\" custom_margin=\"|||\" custom_padding=\"30px|30px|30px|30px\" animation_style=\"zoom\" animation_direction=\"bottom\" animation_intensity_zoom=\"20%\" animation_starting_opacity=\"100%\" box_shadow_style=\"preset7\" box_shadow_horizontal=\"-1px\" box_shadow_vertical=\"-1px\" box_shadow_color=\"rgba(71,74,182,0.12)\" locked=\"off\"]<p>Duis egestas aliquet aliquet. Maecenas erat eros, fringilla et leo eget, viverra pretium nulla.</p>[/et_pb_blurb][et_pb_blurb title=\"HTML & CSS\" url=\"#\" image=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/coding-icon_2.jpg\" icon_placement=\"left\" image_max_width=\"64px\" content_max_width=\"1100px\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" header_line_height=\"1.5em\" body_text_color=\"#8585bd\" body_line_height=\"1.9em\" background_color=\"#ffffff\" custom_margin=\"|||\" custom_padding=\"30px|30px|30px|30px\" animation_style=\"zoom\" animation_direction=\"bottom\" animation_intensity_zoom=\"20%\" animation_starting_opacity=\"100%\" box_shadow_style=\"preset7\" box_shadow_horizontal=\"-1px\" box_shadow_vertical=\"-1px\" box_shadow_color=\"rgba(71,74,182,0.12)\" locked=\"off\"]<p>Duis egestas aliquet aliquet. Maecenas erat eros, fringilla et leo eget, viverra pretium nulla.</p>[/et_pb_blurb][et_pb_blurb title=\"Intro to Coding\" url=\"#\" image=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/coding-icon_4.jpg\" icon_placement=\"left\" image_max_width=\"64px\" content_max_width=\"1100px\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" header_line_height=\"1.5em\" body_text_color=\"#8585bd\" body_line_height=\"1.9em\" background_color=\"#ffffff\" custom_margin=\"|||\" custom_padding=\"30px|30px|30px|30px\" animation_style=\"zoom\" animation_direction=\"bottom\" animation_intensity_zoom=\"20%\" animation_starting_opacity=\"100%\" box_shadow_style=\"preset7\" box_shadow_horizontal=\"-1px\" box_shadow_vertical=\"-1px\" box_shadow_color=\"rgba(71,74,182,0.12)\" locked=\"off\"]<p>Duis egestas aliquet aliquet. Maecenas erat eros, fringilla et leo eget, viverra pretium nulla.</p>[/et_pb_blurb][et_pb_blurb title=\"Apps & Games\" url=\"#\" image=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/coding-icon_6.jpg\" icon_placement=\"left\" image_max_width=\"64px\" content_max_width=\"1100px\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" header_line_height=\"1.5em\" body_text_color=\"#8585bd\" body_line_height=\"1.9em\" background_color=\"#ffffff\" custom_margin=\"|||\" custom_padding=\"30px|30px|30px|30px\" animation_style=\"zoom\" animation_direction=\"bottom\" animation_intensity_zoom=\"20%\" animation_starting_opacity=\"100%\" box_shadow_style=\"preset7\" box_shadow_horizontal=\"-1px\" box_shadow_vertical=\"-1px\" box_shadow_color=\"rgba(71,74,182,0.12)\" locked=\"off\"]<p>Duis egestas aliquet aliquet. Maecenas erat eros, fringilla et leo eget, viverra pretium nulla.</p>[/et_pb_blurb][/et_pb_column_inner][/et_pb_row_inner][/et_pb_column][/et_pb_section][et_pb_section fb_built=\"1\" admin_label=\"Features\" _builder_version=\"3.0.82\" use_background_color_gradient=\"on\" background_color_gradient_start=\"#474ab6\" background_color_gradient_end=\"#9271f6\" background_image=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/coding-background-texture.jpg\" background_blend=\"overlay\" custom_padding=\"100px|0px|100px|0px\"][et_pb_row padding_top_2=\"60px\" admin_label=\"Become an Expert\" _builder_version=\"3.0.82\" animation_style=\"zoom\" animation_direction=\"bottom\" animation_intensity_zoom=\"6%\"][et_pb_column type=\"1_2\" _builder_version=\"3.0.82\" parallax=\"off\" parallax_method=\"on\"][et_pb_image src=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/coding-isometric-02.png\" _builder_version=\"3.0.82\" max_width=\"90%\" module_alignment=\"center\" animation_style=\"zoom\" animation_direction=\"right\" animation_delay=\"100ms\" animation_intensity_zoom=\"20%\"][/et_pb_image][/et_pb_column][et_pb_column type=\"1_2\" _builder_version=\"3.0.82\" padding_top=\"60px\" parallax=\"off\" parallax_method=\"on\"][et_pb_text background_layout=\"dark\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_font_size=\"36px\" header_line_height=\"1.5em\" custom_margin=\"||20px|\" animation_style=\"slide\" animation_direction=\"bottom\" animation_intensity_slide=\"10%\" locked=\"off\"]<h1>Become an expert</h1>[/et_pb_text][et_pb_divider color=\"#09e1c0\" show_divider=\"on\" divider_weight=\"4px\" disabled_on=\"on|on|off\" _builder_version=\"3.0.82\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\" max_width=\"40px\" module_alignment=\"left\" custom_margin=\"||10px|\" animation_style=\"zoom\" animation_direction=\"left\" saved_tabs=\"all\" locked=\"off\"][/et_pb_divider][et_pb_text _builder_version=\"3.0.82\" text_font_size=\"16px\" text_text_color=\"#d4ccff\" text_line_height=\"1.9em\" animation_style=\"zoom\" animation_intensity_zoom=\"6%\" locked=\"off\"]<p>Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Sed molestie, velit ut eleifend sollicitudin, neque orci tempor nulla, id sagittis nisi ante nec arcu. Fusce porta bibendum convallis. Morbi fringilla sollicitudin scelerisque.</p>[/et_pb_text][et_pb_button button_url=\"#\" button_text=\"View All Courses\" _builder_version=\"3.0.82\" custom_margin=\"20px|||\" custom_button=\"on\" button_text_size=\"16px\" button_text_color=\"#ffffff\" button_bg_color=\"#09e1c0\" button_border_width=\"10px\" button_border_color=\"#09e1c0\" button_border_radius=\"100px\" button_letter_spacing=\"1px\" button_font=\"|on||on|\" button_icon=\"%%36%%\" button_on_hover=\"off\" button_letter_spacing_hover=\"2px\" animation_style=\"zoom\" animation_delay=\"100ms\" animation_intensity_zoom=\"10%\" box_shadow_style=\"preset1\" box_shadow_vertical=\"10px\" box_shadow_blur=\"50px\" box_shadow_spread=\"5px\" box_shadow_color=\"rgba(0,188,160,0.6)\" saved_tabs=\"all\" locked=\"off\"][/et_pb_button][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" admin_label=\"Learn by Doing\" _builder_version=\"3.0.82\" custom_padding=\"100px|0px|100px|0px\"][et_pb_row custom_padding=\"90px|0px|90px|0px\" _builder_version=\"3.0.82\"][et_pb_column type=\"1_2\" _builder_version=\"3.0.82\" parallax=\"off\" parallax_method=\"on\"][et_pb_image src=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/coding-iconArtboard-19-copy-8.jpg\" _builder_version=\"3.0.82\" max_width=\"64px\" animation_style=\"zoom\" locked=\"off\"][/et_pb_image][et_pb_text _builder_version=\"3.0.82\" text_text_color=\"#7272ff\" header_font=\"|on|||\" header_font_size=\"36px\" header_text_color=\"#7272ff\" header_line_height=\"1.5em\" custom_margin=\"||20px|\" animation_style=\"slide\" animation_direction=\"bottom\" animation_intensity_slide=\"10%\" locked=\"off\"]<h1>Learn by Doing</h1>[/et_pb_text][et_pb_divider color=\"#09e1c0\" show_divider=\"on\" divider_weight=\"4px\" disabled_on=\"on|on|off\" _builder_version=\"3.0.82\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\" max_width=\"40px\" module_alignment=\"left\" custom_margin=\"||10px|\" animation_style=\"zoom\" animation_direction=\"left\" saved_tabs=\"all\" locked=\"off\"][/et_pb_divider][et_pb_text _builder_version=\"3.0.82\" text_font_size=\"16px\" text_text_color=\"#8585bd\" text_line_height=\"1.9em\" animation_style=\"zoom\" animation_intensity_zoom=\"6%\" locked=\"off\"]<p><span style=\"color: #2e2545;\"><strong>Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos </strong></span></p>\n<p>himenaeos. Sed molestie, velit ut eleifend sollicitudin, neque orci tempor nulla, id sagittis nisi ante nec arcu. Fusce porta bibendum convallis. Morbi fringilla sollicitudin scelerisque.</p>[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\" _builder_version=\"3.0.82\" parallax=\"off\" parallax_method=\"on\"][et_pb_image src=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/coding-isometric-03.png\" _builder_version=\"3.0.82\" animation_style=\"zoom\" animation_direction=\"left\" animation_delay=\"100ms\" animation_intensity_zoom=\"20%\"][/et_pb_image][/et_pb_column][/et_pb_row][et_pb_row custom_padding=\"90px|0px|90px|0px\" admin_label=\"Build Your Portfolio\" _builder_version=\"3.0.82\"][et_pb_column type=\"1_2\" _builder_version=\"3.0.82\" parallax=\"off\" parallax_method=\"on\"][et_pb_image src=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/coding-isometric-04.png\" _builder_version=\"3.0.82\" max_width=\"90%\" module_alignment=\"center\" animation_style=\"zoom\" animation_direction=\"right\" animation_delay=\"100ms\" animation_intensity_zoom=\"20%\"][/et_pb_image][/et_pb_column][et_pb_column type=\"1_2\" _builder_version=\"3.0.82\" parallax=\"off\" parallax_method=\"on\"][et_pb_image src=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/coding-iconArtboard-19-copy-9.jpg\" _builder_version=\"3.0.82\" max_width=\"64px\" animation_style=\"zoom\" locked=\"off\"][/et_pb_image][et_pb_text _builder_version=\"3.0.82\" text_text_color=\"#7272ff\" header_font=\"|on|||\" header_font_size=\"36px\" header_text_color=\"#7272ff\" header_line_height=\"1.5em\" custom_margin=\"||20px|\" animation_style=\"slide\" animation_direction=\"bottom\" animation_intensity_slide=\"10%\" locked=\"off\"]<h1>Build your portfolio</h1>[/et_pb_text][et_pb_divider color=\"#09e1c0\" show_divider=\"on\" divider_weight=\"4px\" disabled_on=\"on|on|off\" _builder_version=\"3.0.82\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\" max_width=\"40px\" module_alignment=\"left\" custom_margin=\"||10px|\" animation_style=\"zoom\" animation_direction=\"left\" saved_tabs=\"all\" locked=\"off\"][/et_pb_divider][et_pb_text _builder_version=\"3.0.82\" text_font_size=\"16px\" text_text_color=\"#8585bd\" text_line_height=\"1.9em\" animation_style=\"zoom\" animation_intensity_zoom=\"6%\" locked=\"off\"]<p><span style=\"color: #2e2545;\"><strong>Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos </strong></span></p>\n<p>himenaeos. Sed molestie, velit ut eleifend sollicitudin, neque orci tempor nulla, id sagittis nisi ante nec arcu. Fusce porta bibendum convallis. Morbi fringilla sollicitudin scelerisque. In pellentesque</p>[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row custom_padding=\"90px|0px|90px|0px\" custom_margin=\"|||\" admin_label=\"Achieve Your Goals\" _builder_version=\"3.0.82\"][et_pb_column type=\"1_2\" _builder_version=\"3.0.82\" parallax=\"off\" parallax_method=\"on\"][et_pb_image src=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/coding-iconArtboard-19-copy-10.jpg\" _builder_version=\"3.0.82\" max_width=\"64px\" animation_style=\"zoom\"][/et_pb_image][et_pb_text _builder_version=\"3.0.82\" text_text_color=\"#7272ff\" header_font=\"|on|||\" header_font_size=\"36px\" header_text_color=\"#7272ff\" header_line_height=\"1.5em\" custom_margin=\"||20px|\" animation_style=\"slide\" animation_direction=\"bottom\" animation_intensity_slide=\"10%\" locked=\"off\"]<h1>Achieve your goals</h1>[/et_pb_text][et_pb_divider color=\"#09e1c0\" show_divider=\"on\" divider_weight=\"4px\" disabled_on=\"on|on|off\" _builder_version=\"3.0.82\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\" max_width=\"40px\" module_alignment=\"left\" custom_margin=\"||10px|\" animation_style=\"zoom\" animation_direction=\"left\" saved_tabs=\"all\" locked=\"off\"][/et_pb_divider][et_pb_text _builder_version=\"3.0.82\" text_font_size=\"16px\" text_text_color=\"#8585bd\" text_line_height=\"1.9em\" animation_style=\"zoom\" animation_intensity_zoom=\"6%\" locked=\"off\"]<p><span style=\"color: #2e2545;\"><strong>Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos </strong></span></p>\n<p>himenaeos. Sed molestie, velit ut eleifend sollicitudin, neque orci tempor nulla, id sagittis nisi ante nec arcu. Fusce porta bibendum convallis. Morbi fringilla sollicitudin scelerisque. In pellentesque</p>[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\" _builder_version=\"3.0.82\" parallax=\"off\" parallax_method=\"on\"][et_pb_image src=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/coding-isometric-05.png\" _builder_version=\"3.0.82\" max_width=\"90%\" module_alignment=\"center\" animation_style=\"zoom\" animation_direction=\"left\" animation_delay=\"100ms\" animation_intensity_zoom=\"20%\" locked=\"off\"][/et_pb_image][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" admin_label=\"Testimonial\" _builder_version=\"3.0.82\" use_background_color_gradient=\"on\" background_color_gradient_start=\"#474ab6\" background_color_gradient_end=\"#9271f6\" background_image=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/coding-background-texture.jpg\" background_blend=\"overlay\" custom_margin=\"|||\" custom_padding=\"0px||0px|\" box_shadow_style=\"preset7\" box_shadow_horizontal=\"0px\" box_shadow_vertical=\"80px\" box_shadow_color=\"#ffffff\" locked=\"off\"][et_pb_row use_custom_width=\"on\" custom_width_px=\"1280px\" custom_padding=\"0px|0px|0px|0px\" custom_padding_tablet=\"|10%||10%\" custom_padding_phone=\"|||\" make_equal=\"on\" bg_img_2=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/coding-dot-bg.png\" padding_top_1=\"150px\" padding_bottom_1=\"80px\" parallax_2=\"on\" padding_1_tablet=\"100px|||\" padding_1_last_edited=\"on|phone\" custom_padding_last_edited=\"on|tablet\" _builder_version=\"3.0.82\"][et_pb_column type=\"1_2\" _builder_version=\"3.0.82\" padding_tablet=\"100px|||\" padding_last_edited=\"on|phone\" padding_bottom=\"80px\" padding_top=\"150px\" parallax=\"off\" parallax_method=\"on\"][et_pb_text background_layout=\"dark\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_font_size=\"36px\" header_line_height=\"1.5em\" custom_margin=\"||20px|\" animation_style=\"slide\" animation_direction=\"bottom\" animation_intensity_slide=\"10%\" locked=\"off\"]<h1>\"<br />My entire team was prototyping by the end of the first day!</h1>[/et_pb_text][et_pb_text _builder_version=\"3.0.82\" text_font_size=\"18px\" text_text_color=\"#d4ccff\" text_line_height=\"1.9em\" animation_style=\"slide\" animation_direction=\"top\" animation_intensity_slide=\"6%\" locked=\"off\"]<p>Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Sed molestie, velit ut eleifend sollicitudin, neque orci tempor nulla, id sagittis nisi ante nec arcu.</p>[/et_pb_text][et_pb_blurb image=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/testimonial-avatar.png\" icon_placement=\"left\" background_layout=\"dark\" content_max_width=\"800px\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" body_font_size=\"16px\" body_text_color=\"#d4ccff\" custom_margin=\"|||\" custom_padding=\"|||\" animation_style=\"fade\" locked=\"off\"]<p><strong>John Smith,</strong> Divi Design Initiative</p>[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_2\" _builder_version=\"3.0.82\" bg_img=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/coding-dot-bg.png\" parallax=\"on\" parallax_method=\"on\"][et_pb_image src=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/coding-dots.png\" _builder_version=\"3.0.82\" custom_margin=\"|||\" animation_style=\"slide\" animation_direction=\"top\" animation_intensity_slide=\"3%\" animation_speed_curve=\"ease-out\"][/et_pb_image][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" admin_label=\"FAQ\" _builder_version=\"3.0.82\" custom_padding=\"100px|0px|180px|0px\"][et_pb_row _builder_version=\"3.0.82\"][et_pb_column type=\"1_3\" _builder_version=\"3.0.82\" parallax=\"off\" parallax_method=\"on\"][et_pb_text _builder_version=\"3.0.82\" text_text_color=\"#7272ff\" header_font=\"|on|||\" header_font_size=\"36px\" header_text_color=\"#7272ff\" header_line_height=\"1.5em\" custom_margin=\"||20px|\" animation_style=\"slide\" animation_direction=\"bottom\" animation_intensity_slide=\"10%\" locked=\"off\"]<h1>FAQ</h1>[/et_pb_text][et_pb_divider color=\"#09e1c0\" show_divider=\"on\" divider_weight=\"4px\" disabled_on=\"on|on|off\" _builder_version=\"3.0.82\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\" max_width=\"40px\" module_alignment=\"left\" custom_margin=\"||10px|\" animation_style=\"zoom\" animation_direction=\"left\" saved_tabs=\"all\" locked=\"off\"][/et_pb_divider][et_pb_text _builder_version=\"3.0.82\" text_font_size=\"16px\" text_text_color=\"#8585bd\" text_line_height=\"1.9em\" animation_style=\"zoom\" animation_intensity_zoom=\"6%\" locked=\"off\"]<p><span style=\"color: #2e2545;\"><strong>Class aptent taciti sociosqu ad litora torquent per conubia nostra</strong></span></p>\n<p>himenaeos. Sed molestie, velit ut eleifend sollicitudin, neque orci tempor nulla, id sagittis nisi ante nec arcu. Fusce porta bibendum convallis. Morbi fringilla sollicitudin scelerisque. In pellentesque</p>[/et_pb_text][et_pb_button button_url=\"#\" button_text=\"Contact Us\" button_alignment=\"left\" _builder_version=\"3.0.82\" custom_margin=\"20px|||\" custom_button=\"on\" button_text_size=\"16px\" button_text_color=\"#ffffff\" button_bg_color=\"#7272ff\" button_border_width=\"10px\" button_border_color=\"#7272ff\" button_border_radius=\"100px\" button_letter_spacing=\"1px\" button_font=\"|on||on|\" button_icon=\"%%36%%\" button_on_hover=\"off\" button_letter_spacing_hover=\"2px\" animation_style=\"zoom\" animation_delay=\"100ms\" animation_intensity_zoom=\"6%\" box_shadow_style=\"preset1\" box_shadow_vertical=\"10px\" box_shadow_blur=\"50px\" box_shadow_spread=\"5px\" box_shadow_color=\"rgba(114,114,255,0.4)\" saved_tabs=\"all\" locked=\"off\"][/et_pb_button][/et_pb_column][et_pb_column type=\"1_3\" _builder_version=\"3.0.82\" parallax=\"off\" parallax_method=\"on\"][et_pb_blurb title=\"Praesent non massa egestas? \" use_icon=\"on\" font_icon=\"%%220%%\" icon_color=\"#09e1c0\" icon_placement=\"left\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" header_line_height=\"1.5em\" body_text_color=\"#8585bd\" body_line_height=\"1.9em\" custom_margin=\"||0px|\" custom_padding=\"20px||20px|\" animation_style=\"zoom\" animation_direction=\"left\" animation_intensity_zoom=\"10%\" locked=\"off\"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ornare in neque rutrum imperdiet. Quisque ante ante, lobortis at dapibus et, congue a orci. [/et_pb_blurb][et_pb_blurb title=\"Quisque ante ante lobortis?\" use_icon=\"on\" font_icon=\"%%220%%\" icon_color=\"#09e1c0\" icon_placement=\"left\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" header_line_height=\"1.5em\" body_text_color=\"#8585bd\" body_line_height=\"1.9em\" custom_margin=\"||0px|\" custom_padding=\"20px||20px|\" animation_style=\"zoom\" animation_direction=\"left\" animation_intensity_zoom=\"10%\" locked=\"off\"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ornare in neque rutrum imperdiet. Quisque ante ante, lobortis at dapibus et, congue a orci.[/et_pb_blurb][et_pb_blurb title=\"Lorem ipsum dolor sit?\" use_icon=\"on\" font_icon=\"%%220%%\" icon_color=\"#09e1c0\" icon_placement=\"left\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" header_line_height=\"1.5em\" body_text_color=\"#8585bd\" body_line_height=\"1.9em\" custom_margin=\"||0px|\" custom_padding=\"20px||20px|\" animation_style=\"zoom\" animation_direction=\"left\" animation_intensity_zoom=\"10%\" locked=\"off\"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ornare in neque rutrum imperdiet. Quisque ante ante, lobortis at dapibus et, congue a orci.[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\" _builder_version=\"3.0.82\" parallax=\"off\" parallax_method=\"on\"][et_pb_blurb title=\"Tis at dapibus et congue?\" use_icon=\"on\" font_icon=\"%%220%%\" icon_color=\"#09e1c0\" icon_placement=\"left\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" header_line_height=\"1.5em\" body_text_color=\"#8585bd\" body_line_height=\"1.9em\" custom_margin=\"||0px|\" custom_padding=\"20px||20px|\" animation_style=\"zoom\" animation_direction=\"left\" animation_intensity_zoom=\"10%\" locked=\"off\"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ornare in neque rutrum imperdiet. Quisque ante ante, lobortis at dapibus et, congue a orci.[/et_pb_blurb][et_pb_blurb title=\"At dapibus et congue?\" use_icon=\"on\" font_icon=\"%%220%%\" icon_color=\"#09e1c0\" icon_placement=\"left\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" header_line_height=\"1.5em\" body_text_color=\"#8585bd\" body_line_height=\"1.9em\" custom_margin=\"||0px|\" custom_padding=\"20px||20px|\" animation_style=\"zoom\" animation_direction=\"left\" animation_intensity_zoom=\"10%\" locked=\"off\"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ornare in neque rutrum imperdiet. Quisque ante ante, lobortis at dapibus et, congue a orci.[/et_pb_blurb][et_pb_blurb title=\" Sit Etiam porttitor ligula?\" use_icon=\"on\" font_icon=\"%%220%%\" icon_color=\"#09e1c0\" icon_placement=\"left\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#2e2545\" header_line_height=\"1.5em\" body_text_color=\"#8585bd\" body_line_height=\"1.9em\" custom_margin=\"||0px|\" custom_padding=\"20px||20px|\" animation_style=\"zoom\" animation_direction=\"left\" animation_intensity_zoom=\"10%\" locked=\"off\"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ornare in neque rutrum imperdiet. Quisque ante ante, lobortis at dapibus et, congue a orci.[/et_pb_blurb][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" background_color=\"#f7f8fc\" admin_label=\"Footer\" _builder_version=\"3.0.82\" custom_padding=\"0px|0px|100px|0px\" animation_style=\"zoom\" animation_direction=\"bottom\" animation_intensity_zoom=\"6%\" animation_starting_opacity=\"100%\" global_module=\"46771\" saved_tabs=\"all\"][et_pb_row custom_padding=\"0px|0px|100px|0px\" _builder_version=\"3.0.82\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"1_2\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_blurb title=\"Free Courses\" url=\"#\" image=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/coding-icon_2.jpg\" icon_placement=\"left\" image_max_width=\"64px\" content_max_width=\"1100px\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#7272ff\" header_line_height=\"1.5em\" body_text_color=\"#8585bd\" body_line_height=\"1.9em\" background_color=\"#ffffff\" custom_margin=\"-80px|||\" custom_padding=\"30px|40px|30px|40px\" animation_style=\"zoom\" animation_direction=\"bottom\" animation_intensity_zoom=\"20%\" animation_starting_opacity=\"100%\" box_shadow_style=\"preset2\" box_shadow_horizontal=\"0px\" box_shadow_vertical=\"0px\" box_shadow_blur=\"60px\" box_shadow_color=\"rgba(71,74,182,0.12)\" locked=\"off\"]\n<p>Duis egestas aliquet aliquet. Maecenas erat eros, fringilla et leo eget, viverra pretium nulla. Quisque sed augue tincidunt, posuere dui tempor.</p>\n[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_2\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_blurb title=\"Premium Courses\" url=\"#\" image=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/coding-icon_8.jpg\" icon_placement=\"left\" image_max_width=\"64px\" content_max_width=\"1100px\" _builder_version=\"3.0.82\" header_font=\"|on|||\" header_text_color=\"#7272ff\" header_line_height=\"1.5em\" body_text_color=\"#8585bd\" body_line_height=\"1.9em\" background_color=\"#ffffff\" custom_margin=\"-80px|||\" custom_margin_tablet=\"0px|||\" custom_margin_last_edited=\"on|phone\" custom_padding=\"30px|40px|30px|40px\" animation_style=\"zoom\" animation_direction=\"bottom\" animation_delay=\"100ms\" animation_intensity_zoom=\"20%\" animation_starting_opacity=\"100%\" box_shadow_style=\"preset2\" box_shadow_horizontal=\"0px\" box_shadow_vertical=\"0px\" box_shadow_blur=\"60px\" box_shadow_color=\"rgba(71,74,182,0.12)\" locked=\"off\"]\n<p>Duis egestas aliquet aliquet. Maecenas erat eros, fringilla et leo eget, viverra pretium nulla. Quisque sed augue tincidunt, posuere dui tempor.</p>\n[/et_pb_blurb][/et_pb_column][/et_pb_row][et_pb_row use_custom_gutter=\"on\" gutter_width=\"2\" _builder_version=\"3.0.82\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"1_2\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_text _builder_version=\"3.0.82\" text_text_color=\"#7272ff\" header_font=\"|on|||\" header_font_size=\"36px\" header_text_color=\"#7272ff\" header_line_height=\"1.5em\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\" custom_margin=\"||20px|\" animation_style=\"slide\" animation_direction=\"bottom\" animation_intensity_slide=\"10%\"]\n<h1>Ready to get started?</h1>\n[/et_pb_text][et_pb_text _builder_version=\"3.0.82\" text_font_size=\"22px\" text_text_color=\"#8585bd\" text_line_height=\"1.9em\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\" animation_style=\"fade\" locked=\"off\"]\n<p>Get in touch, or create an account</p>\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_button button_url=\"#\" button_text=\"Create Account\" button_alignment=\"left\" _builder_version=\"3.0.82\" custom_margin=\"|||\" custom_button=\"on\" button_text_size=\"16px\" button_text_color=\"#ffffff\" button_bg_color=\"#7272ff\" button_border_width=\"10px\" button_border_color=\"#7272ff\" button_border_radius=\"100px\" button_letter_spacing=\"1px\" button_font=\"|on||on|\" button_icon=\"%%36%%\" button_on_hover=\"off\" button_letter_spacing_hover=\"2px\" animation_style=\"zoom\" animation_delay=\"100ms\" animation_intensity_zoom=\"6%\" box_shadow_style=\"preset1\" box_shadow_vertical=\"10px\" box_shadow_blur=\"50px\" box_shadow_spread=\"5px\" box_shadow_color=\"rgba(114,114,255,0.4)\" locked=\"off\"][/et_pb_button][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_button button_url=\"#\" button_text=\"Contact Us\" button_alignment=\"left\" _builder_version=\"3.0.82\" custom_margin=\"|||\" custom_button=\"on\" button_text_size=\"16px\" button_text_color=\"#7272ff\" button_bg_color=\"#ffffff\" button_border_width=\"10px\" button_border_color=\"#ffffff\" button_border_radius=\"100px\" button_letter_spacing=\"1px\" button_font=\"|on||on|\" button_icon=\"%%36%%\" button_on_hover=\"off\" button_letter_spacing_hover=\"2px\" animation_style=\"zoom\" animation_intensity_zoom=\"6%\" box_shadow_style=\"preset1\" box_shadow_vertical=\"10px\" box_shadow_blur=\"50px\" box_shadow_spread=\"5px\" box_shadow_color=\"rgba(181,181,255,0.38)\" locked=\"off\"][/et_pb_button][/et_pb_column][/et_pb_row][/et_pb_section]', 'Coding Landing', '', 'publish', 'closed', 'closed', '', 'coding-landing', '', '', '2017-10-16 09:16:54', '2017-10-16 09:16:54', '', '0', 'http://jhdogtraining.wpengine.com/et_pb_layout/coding-landing/', '0', 'et_pb_layout', '', '0'),
('204548', '1', '2017-10-02 15:26:31', '2017-10-02 15:26:31', '<p>[et_pb_section fb_built=\"1\" admin_label=\"Hero\" _builder_version=\"3.0.76\" background_image=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/travel-landscape-19.jpg\" parallax=\"on\" custom_padding=\"110px|||\"][et_pb_row make_fullwidth=\"on\" use_custom_gutter=\"on\" gutter_width=\"1\" custom_padding=\"|||\" custom_margin=\"|||\" background_position_1=\"top_left\" background_position_2=\"top_left\" background_repeat_1=\"no-repeat\" background_repeat_2=\"no-repeat\" _builder_version=\"3.0.76\" padding_right_2=\"10%\" padding_left_2=\"10%\"][et_pb_column type=\"1_2\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\" background_position=\"top_left\" background_repeat=\"no-repeat\"][et_pb_image src=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/travel-person-iso.png\" show_bottom_space=\"off\" force_fullwidth=\"on\" disabled_on=\"on|on|off\" _builder_version=\"3.0.76\" custom_margin=\"|||\" animation_direction=\"%22fade_in%22\" animation=\"fade_in\"][/et_pb_image][/et_pb_column][et_pb_column type=\"1_2\" _builder_version=\"3.0.47\" padding_left=\"10%\" padding_right=\"10%\" parallax=\"off\" parallax_method=\"on\" background_position=\"top_left\" background_repeat=\"no-repeat\"][et_pb_text background_layout=\"dark\" admin_label=\"Hero Title\" _builder_version=\"3.0.76\" text_font=\"||||\" text_text_color=\"#1a1a1a\" header_font=\"Oswald|on||on|\" header_text_align=\"left\" header_font_size=\"60px\" header_line_height=\"1.3em\" max_width=\"450px\" custom_margin=\"|||\" custom_padding=\"|||\" animation_style=\"slide\" animation_direction=\"top\" animation_intensity_slide=\"10%\" locked=\"off\"]</p><h1>About Us</h1><p>[/et_pb_text][et_pb_divider color=\"#ed4441\" show_divider=\"on\" divider_style=\"solid\" divider_position=\"center\" divider_weight=\"3px\" height=\"false\" disabled_on=\"on|on|off%22\" _builder_version=\"3.0.76\" max_width=\"150px\" custom_margin=\"30px|||\" animation_style=\"slide\" animation_direction=\"top\" animation_delay=\"100ms\" animation_intensity_slide=\"10%\" locked=\"off\"][/et_pb_divider][et_pb_text background_layout=\"dark\" admin_label=\"Hero Sub Title\" _builder_version=\"3.0.76\" text_font=\"Roboto||||\" text_font_size=\"24px\" text_line_height=\"1.4em\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\" max_width=\"450px\" custom_padding=\"30px|||\" animation_style=\"slide\" animation_direction=\"top\" animation_delay=\"200ms\" animation_intensity_slide=\"10%\" locked=\"off\"]</p><p>Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt.</p><p>[/et_pb_text][et_pb_text background_layout=\"dark\" admin_label=\"Hero Text\" _builder_version=\"3.0.76\" text_font=\"Roboto||||\" text_font_size=\"16px\" text_line_height=\"1.9em\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\" max_width=\"450px\" custom_margin=\"60|||\" custom_padding=\"||60px|\" animation_style=\"slide\" animation_direction=\"top\" animation_delay=\"400ms\" animation_intensity_slide=\"4%\" locked=\"off\"]</p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut.</p><p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" _builder_version=\"3.0.69\" custom_padding=\"110px||110px|\"][et_pb_row _builder_version=\"3.0.69\"][et_pb_column type=\"1_2\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_text admin_label=\"Title\" _builder_version=\"3.0.76\" text_font=\"||||\" text_text_color=\"#1a1a1a\" header_font=\"Oswald|on||on|\" header_text_align=\"left\" header_font_size=\"60px\" header_line_height=\"1.3em\" max_width=\"450px\" custom_margin=\"|||\" custom_padding=\"|||\" animation_style=\"slide\" animation_direction=\"top\" animation_intensity_slide=\"10%\" locked=\"off\"]</p><h1>Custom Travel Experiences</h1><p>[/et_pb_text][et_pb_divider color=\"#ed4441\" show_divider=\"on\" divider_style=\"solid\" divider_position=\"center\" divider_weight=\"3px\" height=\"false\" disabled_on=\"on|on|off%22\" _builder_version=\"3.0.76\" max_width=\"150px\" custom_margin=\"30px|||\" animation_style=\"slide\" animation_direction=\"top\" animation_delay=\"100ms\" animation_intensity_slide=\"10%\" locked=\"off\"][/et_pb_divider][et_pb_text admin_label=\"Sub Title\" _builder_version=\"3.0.76\" text_font=\"Roboto||||\" text_font_size=\"24px\" text_text_color=\"#1a1a1a\" text_line_height=\"1.4em\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\" max_width=\"450px\" custom_padding=\"30px|||\" animation_style=\"slide\" animation_direction=\"top\" animation_delay=\"200ms\" animation_intensity_slide=\"10%\" locked=\"off\"] Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit laborum. [/et_pb_text][et_pb_text _builder_version=\"3.0.76\" text_font=\"Roboto||||\" text_font_size=\"16px\" text_line_height=\"1.9em\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\" max_width=\"450px\" custom_margin=\"60|||\" custom_padding=\"||60px|\" animation_style=\"slide\" animation_direction=\"top\" animation_delay=\"400ms\" animation_intensity_slide=\"4%\" locked=\"off\"]</p><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit.</p><p>[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_image src=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/travel-binoculars.jpg\" force_fullwidth=\"on\" _builder_version=\"3.0.76\" custom_margin=\"|||\" animation_style=\"slide\" animation_direction=\"%22fade_in%22\" animation_duration=\"500ms\" animation_intensity_slide=\"10%\" animation=\"fade_in\"][/et_pb_image][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" _builder_version=\"3.0.76\" parallax=\"on\" custom_padding=\"110px||200px|\"][et_pb_row _builder_version=\"3.0.69\" locked=\"off\"][et_pb_column type=\"4_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_text admin_label=\"Title\" _builder_version=\"3.0.76\" text_font=\"||||\" text_text_color=\"#1a1a1a\" header_font=\"Oswald|on||on|\" header_text_align=\"center\" header_font_size=\"60px\" header_line_height=\"1.3em\" module_alignment=\"center\" custom_margin=\"|||\" custom_padding=\"|||\" animation_style=\"slide\" animation_direction=\"top\" animation_intensity_slide=\"10%\" locked=\"off\"]</p><h1>Building Memories</h1><p>[/et_pb_text][et_pb_divider color=\"#ed4441\" show_divider=\"on\" divider_style=\"solid\" divider_position=\"center\" divider_weight=\"3px\" height=\"false\" disabled_on=\"on|on|off%22\" _builder_version=\"3.0.76\" max_width=\"150px\" module_alignment=\"center\" custom_margin=\"30px|||\" animation_style=\"slide\" animation_direction=\"top\" animation_delay=\"100ms\" animation_intensity_slide=\"10%\" locked=\"off\"][/et_pb_divider][et_pb_text admin_label=\"Sub Title\" _builder_version=\"3.0.76\" text_font=\"Roboto||||\" text_font_size=\"24px\" text_text_color=\"#1a1a1a\" text_line_height=\"1.4em\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\" text_orientation=\"center\" max_width=\"800px\" module_alignment=\"center\" custom_margin=\"|||\" custom_padding=\"30px|||\" animation_style=\"slide\" animation_direction=\"top\" animation_delay=\"200ms\" animation_intensity_slide=\"10%\" locked=\"off\"] Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit laborum. [/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row use_custom_width=\"on\" custom_width_px=\"1280px\" _builder_version=\"3.0.76\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"4_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_video src=\"https://www.youtube.com/watch?v=FkQuawiGWUw&amp;t=2s\" image_src=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/travel-landscape-18.jpg\" play_icon_color=\"#ffffff\" _builder_version=\"3.0.76\" animation_style=\"zoom\" animation_direction=\"bottom\" animation_intensity_zoom=\"6%\"][/et_pb_video][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" admin_label=\"Look Inside Section\" _builder_version=\"3.0.76\" background_image=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/travel-landscape-17.jpg\" parallax=\"on\" custom_padding=\"0px||0px|\"][et_pb_row make_fullwidth=\"on\" use_custom_gutter=\"on\" gutter_width=\"1\" custom_padding=\"0px||0px|\" make_equal=\"on\" padding_top_1=\"8%\" padding_right_1=\"6%\" padding_bottom_1=\"6%\" padding_left_1=\"6%\" parallax_1=\"on\" use_background_color_gradient_1=\"on\" use_background_color_gradient_2=\"off\" background_color_gradient_start_1=\"#ffffff\" background_color_gradient_start_2=\"#ffffff\" background_color_gradient_end_1=\"rgba(255,255,255,0.85)\" background_color_gradient_end_2=\"rgba(255,255,255,0.87)\" background_color_gradient_end_position_1=\"50%\" _builder_version=\"3.0.76\"][et_pb_column type=\"1_2\" _builder_version=\"3.0.47\" padding_bottom=\"6%\" padding_left=\"6%\" padding_right=\"6%\" padding_top=\"8%\" parallax=\"on\" parallax_method=\"on\" use_background_color_gradient=\"on\" background_color_gradient_start=\"#ffffff\" background_color_gradient_end=\"rgba(255,255,255,0.85)\" background_color_gradient_end_position=\"50%\"][et_pb_text admin_label=\"Look Inside Title\" _builder_version=\"3.0.76\" text_font=\"||||\" text_text_color=\"#1a1a1a\" header_font=\"Oswald|on||on|\" header_text_align=\"right\" header_font_size=\"60px\" header_line_height=\"1.3em\" max_width=\"450px\" module_alignment=\"right\" custom_margin=\"|||\" custom_padding=\"|||\" animation_style=\"slide\" animation_direction=\"top\" animation_intensity_slide=\"10%\" locked=\"off\"]</p><h1>No Distance Is too Far</h1><p>[/et_pb_text][et_pb_image _builder_version=\"3.0.69\" animation_style=\"slide\" animation_direction=\"left\" animation_duration=\"500ms\" animation_intensity_slide=\"10%\" _i=\"1\" _address=\"3.0.0.1\"][/et_pb_image][et_pb_divider color=\"#ed4441\" show_divider=\"on\" divider_style=\"solid\" divider_position=\"center\" divider_weight=\"3px\" height=\"false\" disabled_on=\"on|on|off%22\" _builder_version=\"3.0.76\" max_width=\"150px\" module_alignment=\"right\" custom_margin=\"30px|||\" animation_style=\"slide\" animation_direction=\"top\" animation_delay=\"100ms\" animation_intensity_slide=\"10%\" locked=\"off\"][/et_pb_divider][et_pb_text admin_label=\"Look Inside Sub Title\" _builder_version=\"3.0.76\" text_font=\"Roboto||||\" text_font_size=\"24px\" text_text_color=\"#1a1a1a\" text_line_height=\"1.4em\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\" text_orientation=\"right\" max_width=\"450px\" module_alignment=\"right\" custom_padding=\"30px|||\" animation_style=\"slide\" animation_direction=\"top\" animation_delay=\"200ms\" animation_intensity_slide=\"10%\" locked=\"off\"] Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit laborum. [/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\" use_background_color_gradient=\"off\" background_color_gradient_start=\"#ffffff\" background_color_gradient_end=\"rgba(255,255,255,0.87)\"][/et_pb_column][/et_pb_row][et_pb_row make_fullwidth=\"on\" use_custom_gutter=\"on\" gutter_width=\"1\" custom_padding=\"6%|10%|110px|10%\" custom_padding_tablet=\"|0px||0px\" custom_margin=\"0px||0px|\" disabled_on=\"off|off|off\" admin_label=\"Stats\" custom_padding_last_edited=\"on|tablet\" _builder_version=\"3.0.76\" use_background_color_gradient=\"on\" background_color_gradient_start=\"rgba(255,255,255,0.85)\" background_color_gradient_end=\"#ffffff\" background_color_gradient_end_position=\"70%\"][et_pb_column type=\"1_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_number_counter title=\"Continents\" number=\"7\" percent_sign=\"off\" disabled_on=\"off|off|off\" _builder_version=\"3.0.76\" title_font=\"Oswald|on||on|\" title_font_size=\"24px\" title_line_height=\"1.6em\" number_font=\"Oswald||||\" number_font_size=\"72px\" number_text_color=\"#ed4441\" animation_style=\"zoom\" animation_intensity_zoom=\"29%\"][/et_pb_number_counter][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_number_counter title=\"Countries\" number=\"102\" percent_sign=\"off\" _builder_version=\"3.0.76\" title_font=\"Oswald|on||on|\" title_font_size=\"24px\" title_line_height=\"1.6em\" number_font=\"Oswald||||\" number_font_size=\"72px\" number_text_color=\"#ed4441\" animation_style=\"zoom\" animation_delay=\"100ms\" animation_intensity_zoom=\"29%\" locked=\"off\"][/et_pb_number_counter][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_number_counter title=\"Oceans\" number=\"5\" percent_sign=\"off\" _builder_version=\"3.0.76\" title_font=\"Oswald|on||on|\" title_font_size=\"24px\" title_line_height=\"1.6em\" number_font=\"Oswald||||\" number_font_size=\"72px\" number_text_color=\"#ed4441\" animation_style=\"zoom\" animation_delay=\"200ms\" animation_intensity_zoom=\"29%\" locked=\"off\"][/et_pb_number_counter][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_number_counter title=\"Cities\" number=\"1752\" percent_sign=\"off\" _builder_version=\"3.0.76\" title_font=\"Oswald|on||on|\" title_font_size=\"24px\" title_line_height=\"1.6em\" number_font=\"Oswald||||\" number_font_size=\"72px\" number_text_color=\"#ed4441\" animation_style=\"zoom\" animation_intensity_zoom=\"29%\" locked=\"off\"][/et_pb_number_counter][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" admin_label=\"Gallery\" _builder_version=\"3.0.76\" custom_padding=\"0px||0px|\"][et_pb_row make_fullwidth=\"on\" use_custom_gutter=\"on\" gutter_width=\"1\" custom_padding=\"0px|0px|0px|0px\" make_equal=\"on\" admin_label=\"Image Grid\" _builder_version=\"3.0.76\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"1_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_image src=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/travel-landscape-05.jpg\" show_in_lightbox=\"on\" force_fullwidth=\"on\" _builder_version=\"3.0.76\" animation_style=\"zoom\" animation_intensity_zoom=\"10%\"][/et_pb_image][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_image src=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/travel-landscape-04.jpg\" show_in_lightbox=\"on\" force_fullwidth=\"on\" _builder_version=\"3.0.76\" animation_style=\"zoom\" animation_delay=\"100ms\" animation_intensity_zoom=\"10%\" locked=\"off\"][/et_pb_image][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_image src=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/travel-landscape-08.jpg\" show_in_lightbox=\"on\" force_fullwidth=\"on\" _builder_version=\"3.0.76\" animation_style=\"zoom\" animation_delay=\"200ms\" animation_intensity_zoom=\"10%\" locked=\"off\"][/et_pb_image][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_image src=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/travel-landscape-11.jpg\" show_in_lightbox=\"on\" force_fullwidth=\"on\" _builder_version=\"3.0.76\" animation_style=\"zoom\" animation_delay=\"300ms\" animation_intensity_zoom=\"10%\" locked=\"off\"][/et_pb_image][/et_pb_column][/et_pb_row][et_pb_row make_fullwidth=\"on\" use_custom_gutter=\"on\" gutter_width=\"1\" custom_padding=\"0px|0px|0px|0px\" make_equal=\"on\" admin_label=\"Image Grid\" _builder_version=\"3.0.76\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"1_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_image src=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/travel-coffee.jpg\" show_in_lightbox=\"on\" force_fullwidth=\"on\" _builder_version=\"3.0.76\" animation_style=\"zoom\" animation_intensity_zoom=\"10%\"][/et_pb_image][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_image src=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/travel-landscape-10.jpg\" show_in_lightbox=\"on\" force_fullwidth=\"on\" _builder_version=\"3.0.76\" animation_style=\"zoom\" animation_delay=\"100ms\" animation_intensity_zoom=\"10%\" locked=\"off\"][/et_pb_image][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_image src=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/travel-landscape-12.jpg\" show_in_lightbox=\"on\" force_fullwidth=\"on\" _builder_version=\"3.0.76\" animation_style=\"zoom\" animation_delay=\"200ms\" animation_intensity_zoom=\"10%\" locked=\"off\"][/et_pb_image][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_image src=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/travel-bank.jpg\" show_in_lightbox=\"on\" force_fullwidth=\"on\" _builder_version=\"3.0.76\" animation_style=\"zoom\" animation_delay=\"300ms\" animation_intensity_zoom=\"10%\" locked=\"off\"][/et_pb_image][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" _builder_version=\"3.0.76\" custom_padding=\"180px||180px|\" custom_padding_tablet=\"80px||80px|\" custom_padding_last_edited=\"on|tablet\"][et_pb_row _builder_version=\"3.0.69\" locked=\"off\"][et_pb_column type=\"4_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_text admin_label=\"More Places Title\" _builder_version=\"3.0.76\" text_font=\"||||\" header_font=\"Oswald|on||on|\" header_font_size=\"60px\" header_line_height=\"1.3em\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\" text_orientation=\"center\" custom_margin=\"|||\" custom_padding=\"|||\" animation_style=\"slide\" animation_direction=\"top\" animation_intensity_slide=\"10%\"]</p><h1>WE Got You Covered</h1><p>[/et_pb_text][et_pb_divider color=\"#ed4441\" show_divider=\"on\" divider_style=\"solid\" divider_position=\"center\" divider_weight=\"3px\" height=\"false\" disabled_on=\"on|on|off%22\" _builder_version=\"3.0.76\" max_width=\"150px\" module_alignment=\"center\" custom_margin=\"30px|||\" animation_style=\"slide\" animation_direction=\"top\" animation_delay=\"100ms\" animation_intensity_slide=\"10%\" locked=\"off\"][/et_pb_divider][/et_pb_column][/et_pb_row][et_pb_row custom_padding=\"70px|||\" _builder_version=\"3.0.69\" locked=\"off\"][et_pb_column type=\"1_3\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_blurb title=\"Endangered Wildlife\" use_icon=\"on\" font_icon=\"%%110%%\" icon_color=\"#ed4441\" use_icon_font_size=\"on\" icon_font_size=\"60px\" _builder_version=\"3.0.76\" header_font=\"Oswald|on||on|\" header_font_size=\"24px\" body_font=\"Roboto||||\" body_font_size=\"16px\" body_line_height=\"1.8em\" text_orientation=\"center\"] Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore. [/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_blurb title=\"Eco lodges &amp; tours\" use_icon=\"on\" font_icon=\"%%102%%\" icon_color=\"#ed4441\" use_icon_font_size=\"on\" icon_font_size=\"60px\" _builder_version=\"3.0.76\" header_font=\"Oswald|on||on|\" header_font_size=\"24px\" body_font=\"Roboto||||\" body_font_size=\"16px\" body_line_height=\"1.8em\" text_orientation=\"center\"] Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore. [/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_blurb title=\"Epic journeys\" use_icon=\"on\" font_icon=\"%%121%%\" icon_color=\"#ed4441\" use_icon_font_size=\"on\" icon_font_size=\"60px\" _builder_version=\"3.0.76\" header_font=\"Oswald|on||on|\" header_font_size=\"24px\" body_font=\"Roboto||||\" body_font_size=\"16px\" body_line_height=\"1.8em\" text_orientation=\"center\"] Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore. [/et_pb_blurb][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" background_color=\"rgba(0,0,0,0.5)\" admin_label=\"Offer\" _builder_version=\"3.0.76\" background_image=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/travel-map.jpg\" background_blend=\"color\" custom_padding=\"120px||120px|\" custom_padding_tablet=\"80px||80px|\" custom_padding_last_edited=\"on|tablet\"][et_pb_row custom_margin=\"|||\" _builder_version=\"3.0.76\"][et_pb_column type=\"4_4\" _builder_version=\"3.0.47\" parallax=\"off\" parallax_method=\"on\"][et_pb_text background_layout=\"dark\" admin_label=\"CTA Section Subtitle\" _builder_version=\"3.0.76\" text_font=\"Roboto|on||on|\" text_font_size=\"24px\" text_letter_spacing=\"4px\" text_orientation=\"center\" module_alignment=\"center\" animation_style=\"zoom\" animation_intensity_zoom=\"20%\"] Exclusive Offer [/et_pb_text][et_pb_text background_layout=\"dark\" admin_label=\"CTA Section Title\" _builder_version=\"3.0.76\" text_font=\"||||\" header_font=\"Oswald|on||on|\" header_text_align=\"center\" header_font_size=\"60px\" header_line_height=\"1.3em\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\" module_alignment=\"center\" custom_margin=\"|||\" custom_padding=\"|||\" animation_style=\"zoom\" animation_delay=\"100ms\" animation_intensity_zoom=\"20%\" locked=\"off\"]</p><h1>Get 30% Off Your First Trip</h1><p>[/et_pb_text][et_pb_divider show_divider=\"on\" divider_style=\"solid\" divider_position=\"center\" divider_weight=\"3px\" height=\"false\" disabled_on=\"on|on|off%22\" _builder_version=\"3.0.76\" max_width=\"150px\" module_alignment=\"center\" animation_style=\"zoom\" animation_delay=\"200ms\" animation_intensity_zoom=\"20%\" locked=\"off\"][/et_pb_divider][et_pb_text background_layout=\"dark\" _builder_version=\"3.0.76\" text_font=\"Roboto||||\" text_font_size=\"24px\" text_line_height=\"1.4em\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\" text_orientation=\"center\" max_width=\"750px\" module_alignment=\"center\" custom_padding=\"30px||40px|\" animation_style=\"zoom\" animation_delay=\"300ms\" animation_intensity_zoom=\"20%\"]</p><p>Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.</p><p>[/et_pb_text][et_pb_button button_text=\"View Packages\" button_alignment=\"center\" background_layout=\"dark\" _builder_version=\"3.0.76\" custom_button=\"on\" button_text_size=\"20\" button_text_color=\"#ffffff\" button_border_radius=\"0px\" button_letter_spacing=\"4px\" button_font=\"Oswald|on||on|\" button_icon=\"%%3%%\" button_icon_color=\"#ffffff\" button_bg_color_hover=\"rgba(0,0,0,0)\" button_border_color_hover=\"#ffffff\" button_border_radius_hover=\"0px\" button_letter_spacing_hover=\"4px\" animation_style=\"zoom\" animation_delay=\"400ms\" animation_intensity_zoom=\"20%\"][/et_pb_button][/et_pb_column][/et_pb_row][/et_pb_section]</p>', 'Travel_About', '', 'publish', 'closed', 'closed', '', 'travel_about', '', '', '2017-10-02 15:26:31', '2017-10-02 15:26:31', '', '0', 'http://jhdogtraining.wpengine.com/et_pb_layout/travel_about/', '0', 'et_pb_layout', '', '0'),
('204552', '1', '2017-11-20 15:50:22', '2017-11-20 15:50:22', '', 'Macy-C-31', '', 'inherit', 'open', 'closed', '', 'macy-c-31', '', '', '2017-11-20 15:50:22', '2017-11-20 15:50:22', '', '42', 'http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/Macy-C-31.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204553', '1', '2017-11-20 15:54:56', '2017-11-20 15:54:56', '[et_pb_section fb_built=\"1\" module_class=\"separation-anxiety\" _builder_version=\"3.22\" background_image=\"https://jhdogtraining.com.au/wp-content/uploads/2017/11/TOP-IMAGE_159644971.jpg\" background_blend=\"darken\"][et_pb_row _builder_version=\"3.25\"][et_pb_column type=\"4_4\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text _builder_version=\"4.5.3\" text_text_color=\"#ffffff\" header_text_color=\"#ffffff\" background_layout=\"dark\" custom_margin=\"170px||140px|\"]<h1 style=\"text-align: center;\"><strong>Treatment for Separation Anxiety</strong></h1>\n<p style=\"text-align: center;\"><strong>Are you afraid to leave your dog alone because he might hurt himself or destroy your things?</strong><br /><strong> Does he try to escape by clawing at your doors or windows?</strong><br /><strong> Do the neighbours complain about constant barking or howling?<br /></strong><strong>Have you been told there’s nothing that can help?</strong></p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" _builder_version=\"4.5.3\"][et_pb_row _builder_version=\"3.25\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"4_4\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text _builder_version=\"4.5.3\" header_3_line_height=\"1.4em\"]<p style=\"text-align: center;\">If you answered “yes” to most or all of these questions, stop, take a long, deep breath,and get ready for some good news. Your dog’s separation anxiety can be treated and you can finally get your life back.</p>\r[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row column_structure=\"1_2,1_2\" _builder_version=\"3.25\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"1_2\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_image src=\"/wp-content/uploads/2017/12/black-dog-in-window.jpg\" align_tablet=\"center\" align_phone=\"\" align_last_edited=\"on|desktop\" _builder_version=\"3.23\"][/et_pb_image][/et_pb_column][et_pb_column type=\"1_2\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text _builder_version=\"3.27.4\" header_2_text_color=\"#1f1e86\"]<h2>What is Separation Anxiety?</h2>\r\nSeparation anxiety is a complicated and devastating disorder that affects approximately 15 percent of all dogs. Not only does it cause extreme panic in the dogs that are left alone, it creates extreme levels of stress for the humans who love them. Left untreated, separation anxiety only worsens with time.\r\n\r\nSeparation anxiety can be caused by a number of things, from a traumatic experience to changes in the home to genetic disposition. Often it’s not clear why your dog feels so panicked when you leave. But it’s important to remember that it’s not your fault and your dog isn’t mad at you or trying to get back at you. Help is available, and by using online consultations, you and your dog will work with methods that have already helped hundreds of dogs over come this condition.\r[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row column_structure=\"1_2,1_2\" module_class=\"switch-image\" _builder_version=\"4.5.3\"][et_pb_column type=\"1_2\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text _builder_version=\"4.5.3\" header_2_text_color=\"#1f1e86\"]<h2 style=\"text-align: right;\">Expert help. How does it work?</h2>\r\n<p style=\"text-align: right;\">As the first Australian dog trainer to become a Certified Separation Anxiety Trainer (CSAT), Jenny has completed intensive study with international Separation Anxiety Training expert <a href=\"https://malenademartini.com\">Malena DeMartini</a>.  By using technology to work in real time, we introduce your dog to gradual absences at the rate that\'s right for them.  Which means your dog has the best opportunity to make progress!                               If the word \"technology\" makes you stressed, don\'t be.  Jenny can take you through that as well - it\'s easy! So no matter your location, help is at hand.</p>\r[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_image src=\"/wp-content/uploads/2017/11/AdobeStock_84330916_o.jpg\" align_tablet=\"center\" align_phone=\"\" align_last_edited=\"on|desktop\" _builder_version=\"3.23\"][/et_pb_image][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" _builder_version=\"3.22\" background_color=\"#1f1e86\"][et_pb_row _builder_version=\"3.25\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"4_4\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text _builder_version=\"4.5.3\" text_text_color=\"#ffffff\" header_3_line_height=\"1.4em\" background_layout=\"dark\"]<h3 style=\"text-align: center;\"><strong>Best of all, you won’t have to go it alone. Jenny will be with you every step of the way, giving you all the support and guidance you need to bring relief to your dog, and peace and harmony to your home.</strong></h3>\n<p>&nbsp;</p>\n<p><em>“We had a young puppy with separation anxiety who could not cope at being alone for even a few minutes. We were at our wits end until we found Jenny who was a life saver! She was so caring and understanding and helped us to work with our puppy to learn his signals of anxiety, and how to help him to overcome them. She was so patient and attentive and within four weeks there was such an enormous difference in Freddie. We could not be more thrilled with the results and can’t recommend Jenny highly enough!”</em>   Laura &amp; Chris with Freddie the Hungarian Viszla</p>\n<p>&nbsp;</p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" _builder_version=\"4.5.3\"][et_pb_row _builder_version=\"4.5.3\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"4_4\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text _builder_version=\"4.5.3\" header_2_text_color=\"#1f1e86\"]<h2 style=\"text-align: center;\"><strong>How it works</strong></h2>\r\n<p style=\"text-align: center;\">If you’re ready to separate yourself from separation anxiety, it’s easy to get started.</p>\r[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row column_structure=\"1_4,1_4,1_4,1_4\" _builder_version=\"3.25\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"1_4\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_blurb title=\"Reach out\" use_icon=\"on\" font_icon=\"%%75%%\" icon_color=\"#1f1f83\" use_icon_font_size=\"on\" icon_font_size=\"45px\" _builder_version=\"3.0.89\" header_font=\"|700|||||||\" header_text_color=\"#1f1e86\" text_orientation=\"center\"]Fill out the contact form by <u>clicking here</u> and Jenny will be in touch to further learn about your situation, and discuss the treatment protocol and fees.\r[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_blurb title=\"Complete a consultation\" use_icon=\"on\" font_icon=\"%%264%%\" icon_color=\"#1f1f83\" use_icon_font_size=\"on\" icon_font_size=\"45px\" _builder_version=\"3.0.89\" header_font=\"|700|||||||\" header_text_color=\"#1f1e86\" text_orientation=\"center\"]As soon you’re ready to get started, Jenny will set up an initial consultation with you to learn more about your dog and your goals for treatment. During this on line consultation, lasting 1 to 1.5hrs, she’ll gather information about your dog’s temperament, personality, and behavioral and medical histories. She will then conduct a short online assessment.\r[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_blurb title=\"Implement a treatment plan\" use_icon=\"on\" font_icon=\"%%175%%\" icon_color=\"#1f1f83\" use_icon_font_size=\"on\" icon_font_size=\"45px\" _builder_version=\"3.0.89\" header_font=\"|700|||||||\" header_text_color=\"#1f1e86\" text_orientation=\"center\"]Based on the assessment, a treatment plan will be customized especially for your dog and lifestyle, complete with easy-to-follow instructions and ongoing support.\r[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_blurb title=\"Live the dream\" use_icon=\"on\" font_icon=\"%%171%%\" icon_color=\"#1f1f83\" use_icon_font_size=\"on\" icon_font_size=\"45px\" _builder_version=\"3.0.89\" header_font=\"|700|||||||\" header_text_color=\"#1f1e86\" text_orientation=\"center\"]Imagine being able to run to the store or go to work while your dog peacefully snores away on the sofa. With patience, consistency and personal support from Jenny, this dream can be a reality!\r[/et_pb_blurb][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" _builder_version=\"3.22\"][et_pb_row _builder_version=\"3.25\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"4_4\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text _builder_version=\"3.27.4\"]<h1 class=\"et_pb_contact_main_title\" style=\"text-align: center;\">separation anxiety assessment form</h1>\r\n[contact-form-7 id=\"204679\" title=\"separation anxiety assessment form\"]\r[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]', 'Separation Anxiety', '', 'publish', 'closed', 'closed', '', 'separation-anxiety', '', '', '2020-08-10 02:43:51', '2020-08-10 02:43:51', '', '0', 'http://jhdogtraining.wpengine.com/?page_id=204553', '0', 'page', '', '0'),
('204554', '1', '2017-11-20 16:00:29', '2017-11-20 16:00:29', ' ', '', '', 'publish', 'closed', 'closed', '', '204554', '', '', '2020-02-26 20:09:40', '2020-02-26 20:09:40', '', '0', 'http://jhdogtraining.wpengine.com/?p=204554', '2', 'nav_menu_item', '', '0'),
('204556', '1', '2017-11-20 16:01:43', '2017-11-20 16:01:43', '', 'IMG_2019', '', 'inherit', 'open', 'closed', '', 'img_2019', '', '', '2017-11-20 16:01:43', '2017-11-20 16:01:43', '', '42', 'http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/IMG_2019.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204557', '1', '2017-11-20 16:03:42', '2017-11-20 16:03:42', '[et_pb_section fb_built=\"1\" module_class=\"private-training\" _builder_version=\"3.22\" background_image=\"https://jhdogtraining.com.au/wp-content/uploads/2017/12/AdobeStock_180762347_o-1.jpg\" background_position=\"top_center\" custom_padding=\"140px||140px|\"][et_pb_row _builder_version=\"3.25\"][et_pb_column type=\"4_4\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text admin_label=\"Text\" _builder_version=\"4.6.6\" text_text_color=\"#ffffff\" header_text_align=\"center\" header_text_color=\"#ffffff\" text_orientation=\"center\" module_alignment=\"center\" custom_margin=\"100px||100px|\" hover_enabled=\"0\" text_text_shadow_style=\"preset3\" sticky_enabled=\"0\"]<h1 style=\"text-align: center;\"><strong>Private Training</strong></h1>\r\n<p style=\"text-align: center;\"><strong>While group training classes are beneficial for many people and dogs, they may not work for everyone. If you are time poor, uncomfortable in a group setting, need help with one or two specific behavioural issues, or just enjoy more personalised instruction, a Private Training package may be the solution you’re looking for.</strong></p>\r[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" _builder_version=\"3.22\" background_color=\"#f6f6f6\"][et_pb_row _builder_version=\"3.25\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"4_4\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text admin_label=\"Text\" _builder_version=\"4.6.6\" hover_enabled=\"0\" sticky_enabled=\"0\"]<p style=\"text-align: center;\">Does your dog pull on lead, jump up on your guests, or have the neighbours complained about constant barking? Does your dog lunge and snarl at other dogs, or is your dog fearful of people or dogs?  Is door-dashing (complete with barking and jumping!) your dog’s favourite greeting ritual?</p><p style=\"text-align: center;\">Private training will put an end to your dog-related frustrations, with two convenient options that will work around your busy schedule.</p>\r[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" _builder_version=\"3.22\"][et_pb_row _builder_version=\"3.25\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"4_4\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text admin_label=\"Text\" _builder_version=\"4.6.6\" header_text_color=\"#1f1e86\" hover_enabled=\"0\" sticky_enabled=\"0\"]<h1 style=\"text-align: center;\"><strong>One-on-One Lessons</strong></h1>\r[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row column_structure=\"1_3,1_3,1_3\" _builder_version=\"3.25\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"1_3\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_blurb use_icon=\"on\" font_icon=\"%%83%%\" icon_color=\"#1f1e86\" use_icon_font_size=\"on\" icon_font_size=\"45px\" _builder_version=\"4.4.5\" text_orientation=\"center\"]<p style=\"text-align: center;\">Are you too busy for group classes but still want to learn how to train your dog yourself?</p>\r[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_blurb use_icon=\"on\" font_icon=\"%%83%%\" icon_color=\"#1e1d85\" use_icon_font_size=\"on\" icon_font_size=\"45px\" _builder_version=\"3.19.18\" text_orientation=\"center\"]<p style=\"text-align: center;\">Would you like personalised, step-by-step instructions and assistance from a professional trainer?</p>\r[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_blurb use_icon=\"on\" font_icon=\"%%83%%\" icon_color=\"#1e1d85\" use_icon_font_size=\"on\" icon_font_size=\"45px\" _builder_version=\"3.19.18\" text_orientation=\"center\"]<p style=\"text-align: center;\">Has your dog developed a new problem behavior and you’re not sure how to fix it on your own?</p>\r[/et_pb_blurb][/et_pb_column][/et_pb_row][et_pb_row column_structure=\"1_2,1_2\" _builder_version=\"3.25\"][et_pb_column type=\"1_2\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_image src=\"/wp-content/uploads/2017/11/beagle-at-end-of-leash.jpg\" align_tablet=\"center\" align_phone=\"\" align_last_edited=\"on|desktop\" _builder_version=\"3.23\"][/et_pb_image][/et_pb_column][et_pb_column type=\"1_2\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text _builder_version=\"3.27.4\"]<p>\r\nPrivate, one-on-one lessons are the easy way to address your training needs at a time and place that’s convenient for you. After an initial consultation, Jenny will design a training plan specifically for you and your dog. She’ll then come to your home or a nearby park each week to work with both of you using only the most up-to-date, positive reinforcement training methods.</p>\r\n<p>With focused attention and plenty of time to ask questions, you’ll be amazed at how much progress your dog makes in just a short amount of time!</p>\r[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" _builder_version=\"3.22\" background_color=\"#f6f6f6\"][et_pb_row _builder_version=\"3.25\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"4_4\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text admin_label=\"Text\" _builder_version=\"4.6.6\" header_2_line_height=\"1.2em\" header_3_line_height=\"1.2em\" hover_enabled=\"0\" sticky_enabled=\"0\"]<p style=\"text-align: center;\">Jenny can develop an individualised training program to address your goals and your dog\'s training needs.</p>\r[/et_pb_text][et_pb_text _builder_version=\"4.6.6\" header_3_text_color=\"#1f1e86\" hover_enabled=\"0\" sticky_enabled=\"0\"]<h3 style=\"text-align: center;\"><strong>Initial consultation 1.5hrs - $265</strong></h3>\n<h3 style=\"text-align: center;\"><strong>Subsequent Consultations 1hr - $160</strong></h3>\n<h3 style=\"text-align: center;\"> </h3>\n[/et_pb_text][et_pb_text _builder_version=\"4.6.6\" hover_enabled=\"0\" sticky_enabled=\"0\"]<p style=\"text-align: center;\"><a href=\"http://jhdogtraining.wpengine.com/contact/\">Book your <strong>initial consultation</strong> now to discuss the training package that best suits your needs.</a></p>\r[/et_pb_text][et_pb_text _builder_version=\"4.6.6\" hover_enabled=\"0\" sticky_enabled=\"0\"]<p style=\"text-align: center;\">For more complex behavioural problems, Jenny will discuss your package with you.</p>\r[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" _builder_version=\"3.22\"][et_pb_row column_structure=\"1_2,1_2\" _builder_version=\"3.25\"][et_pb_column type=\"1_2\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_image src=\"/wp-content/uploads/2017/11/AdobeStock_94700859_o.jpg\" align_tablet=\"center\" align_phone=\"\" align_last_edited=\"on|desktop\" _builder_version=\"3.23\"][/et_pb_image][/et_pb_column][et_pb_column type=\"1_2\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text _builder_version=\"3.27.4\" header_2_text_color=\"#1f1e86\"]<h2 style=\"text-align: left;\">Day Training: You work. Your dog trains.</h2>\r\n<p>A well-behaved, well-trained dog can make your life easier and happier. But between work, school, family or social commitments, it can be almost impossible to find time to train your best friend.</p>\r\n<p>With day training, Jenny will take care of the training, while you take care of the rest of your life.  This innovative solution saves you time and worry and your dog learns new skills – the fast track method to turn your dog into the welcome family you want him to be.</p>\r[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row column_structure=\"1_2,1_2\" module_class=\"switch-image\" _builder_version=\"3.25\"][et_pb_column type=\"1_2\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text _builder_version=\"3.27.4\" header_2_text_color=\"#1f1e86\"]<h2 style=\"text-align: right;\">How it Works</h2>\r\n<p style=\"text-align: right;\">After an initial consultation to understand your needs and develop a customised training plan, Jenny will come to your home to personally work with your dog while you’re away.</p>\r\n<p style=\"text-align: right;\">In addition to your dog’s training sessions, Jenny will meet with you regularly to go over what your dog has learned and show you how to continue to reinforce the new behaviours so you can enjoy and maintain your dog’s newfound skills.</p>\r[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_image src=\"/wp-content/uploads/2017/11/AdobeStock_115392600_o.jpg\" align_tablet=\"center\" align_phone=\"\" align_last_edited=\"on|desktop\" _builder_version=\"3.23\"][/et_pb_image][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" _builder_version=\"3.22\" background_color=\"#f6f6f6\"][et_pb_row _builder_version=\"3.25\" custom_css_main_element=\"display: -webkit-flex;||display: -ms-flex;||display: flex;||||-webkit-align-items: center; ||-ms-flex-align: center;||align-items: center; \"][et_pb_column type=\"4_4\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text _builder_version=\"3.27.4\" header_3_text_color=\"#1f1e86\"]<h3 style=\"text-align: center;\"><strong>Four-week package:</strong></h3>\r\n<p style=\"text-align: center;\">This package is perfect for common training and behavioural issues. However, if your dog has a more challengingbehaviour,Jenny will be happy to discuss your needs and develop an individualised program for you and your dog.</p>\r[/et_pb_text][et_pb_text _builder_version=\"4.5.1\" header_3_text_color=\"#1f1e86\"]<h3 style=\"text-align: center;\"><strong>2 sessions per week for your dog + 4 guardian training sessions - $1,175</strong></h3>\r\n<h3 style=\"text-align: center;\"><strong>3 sessions per week for your dog + 4 guardian training sessions - $1,450</strong></h3>\r[/et_pb_text][et_pb_text _builder_version=\"3.27.4\"]<p style=\"text-align: center;\"><a href=\"http://jhdogtraining.wpengine.com/contact/\">Book your <strong>initial consultation</strong> now to discuss the training package that best suits your needs.</a></p>\r[/et_pb_text][et_pb_text _builder_version=\"3.27.4\"]<p style=\"text-align: center;\">For more complex behavioural problems, Jenny will discuss your package with you.</p>\r[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" _builder_version=\"3.22\" background_color=\"#1f1e86\"][et_pb_row _builder_version=\"3.25\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"4_4\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text _builder_version=\"3.27.4\" text_text_color=\"#ffffff\" header_3_text_color=\"#ffffff\" header_3_line_height=\"1.4em\"]<h3 style=\"text-align: center;\"><a href=\"https://jennyharlowdogtraining.activehosted.com/f/13\" target=\"_blank\" rel=\"noopener noreferrer\"><strong>Click here to receive Jenny’s free training tips </strong></a></h3>\r[/et_pb_text][et_pb_button button_url=\"https://jhdogtraining.com.au/blog/\" url_new_window=\"on\" button_text=\"click here to read the latest blog\" button_alignment=\"center\" _builder_version=\"3.16\" custom_button=\"on\" button_text_color=\"#ffffff\" button_border_color=\"#ffffff\" button_text_size__hover_enabled=\"off\" button_text_size__hover=\"null\" button_one_text_size__hover_enabled=\"off\" button_one_text_size__hover=\"null\" button_two_text_size__hover_enabled=\"off\" button_two_text_size__hover=\"null\" button_text_color__hover_enabled=\"off\" button_text_color__hover=\"null\" button_one_text_color__hover_enabled=\"off\" button_one_text_color__hover=\"null\" button_two_text_color__hover_enabled=\"off\" button_two_text_color__hover=\"null\" button_border_width__hover_enabled=\"off\" button_border_width__hover=\"null\" button_one_border_width__hover_enabled=\"off\" button_one_border_width__hover=\"null\" button_two_border_width__hover_enabled=\"off\" button_two_border_width__hover=\"null\" button_border_color__hover_enabled=\"off\" button_border_color__hover=\"null\" button_one_border_color__hover_enabled=\"off\" button_one_border_color__hover=\"null\" button_two_border_color__hover_enabled=\"off\" button_two_border_color__hover=\"null\" button_border_radius__hover_enabled=\"off\" button_border_radius__hover=\"null\" button_one_border_radius__hover_enabled=\"off\" button_one_border_radius__hover=\"null\" button_two_border_radius__hover_enabled=\"off\" button_two_border_radius__hover=\"null\" button_letter_spacing__hover_enabled=\"off\" button_letter_spacing__hover=\"null\" button_one_letter_spacing__hover_enabled=\"off\" button_one_letter_spacing__hover=\"null\" button_two_letter_spacing__hover_enabled=\"off\" button_two_letter_spacing__hover=\"null\" button_bg_color__hover_enabled=\"off\" button_bg_color__hover=\"null\" button_one_bg_color__hover_enabled=\"off\" button_one_bg_color__hover=\"null\" button_two_bg_color__hover_enabled=\"off\" button_two_bg_color__hover=\"null\"][/et_pb_button][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" _builder_version=\"3.22\"][et_pb_row _builder_version=\"3.25\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"4_4\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_testimonial author=\"Jeanette & Boo\" _builder_version=\"3.2\" background_layout=\"dark\"]<p>\r\n<em>Jenny Harlow was great working with my young son and I to train our new puppy, Boo, to come back when called. We were both really nervous about the safety of our puppy as our last dog was hit by a car, which was very traumatic. Jenny helped us get over our fears and work with confidence in training our puppy. Teaching Boo to come back has become a fun game and now she is really good at it.  We are now relaxed with her off the lead at the park as we are confident that she will come back when called. </em></p>\r[/et_pb_testimonial][/et_pb_column][/et_pb_row][/et_pb_section]', 'Private Training', '', 'publish', 'closed', 'closed', '', 'private-training', '', '', '2021-05-10 05:51:48', '2021-05-10 05:51:48', '', '0', 'http://jhdogtraining.wpengine.com/?page_id=204557', '0', 'page', '', '0'),
('204558', '1', '2017-11-20 16:04:40', '2017-11-20 16:04:40', ' ', '', '', 'publish', 'closed', 'closed', '', '204558', '', '', '2020-02-26 20:09:40', '2020-02-26 20:09:40', '', '0', 'http://jhdogtraining.wpengine.com/?p=204558', '1', 'nav_menu_item', '', '0'),
('204559', '1', '2017-11-20 17:28:29', '2017-11-20 17:28:29', '[et_pb_section fb_built=\"1\" module_class=\"premium-puppy\" _builder_version=\"4.4.8\" background_image=\"https://jhdogtraining.com.au/wp-content/uploads/2017/11/TOP-IMAAGE_o-1.jpg\" background_position=\"top_center\" collapsed=\"on\"][et_pb_row _builder_version=\"3.25\" collapsed=\"off\"][et_pb_column type=\"4_4\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text _builder_version=\"3.27.4\" text_text_color=\"#ffffff\" background_layout=\"dark\" custom_margin=\"160px|||\" text_text_shadow_style=\"preset3\"]<h1 style=\"text-align: center;\"><strong>Puppy Training</strong></h1>\r\n<p style=\"text-align: center;\"><strong>Get the best start for your beautiful puppy. </strong></p>\r[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row column_structure=\"1_2,1_2\" _builder_version=\"3.25\" custom_padding=\"||160px|\"][et_pb_column type=\"1_2\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text module_class=\"force_marg\" _builder_version=\"3.27.4\" text_text_color=\"#ffffff\" text_font_size=\"18px\" text_orientation=\"center\" custom_margin_tablet=\"||40px|\" custom_margin_phone=\"\" custom_margin_last_edited=\"on|desktop\" custom_padding_tablet=\"\" custom_padding_phone=\"\" custom_padding_last_edited=\"on|desktop\"]<p>\r\nPremium Puppy Private Training</p>\r[/et_pb_text][et_pb_button button_url=\"#puppyprem\" button_text=\"Premium Puppy Class Private\" button_alignment=\"center\" _builder_version=\"4.5.7\" background_layout=\"dark\" button_text_size__hover_enabled=\"off\" button_text_size__hover=\"null\" button_one_text_size__hover_enabled=\"off\" button_one_text_size__hover=\"null\" button_two_text_size__hover_enabled=\"off\" button_two_text_size__hover=\"null\" button_text_color__hover_enabled=\"off\" button_text_color__hover=\"null\" button_one_text_color__hover_enabled=\"off\" button_one_text_color__hover=\"null\" button_two_text_color__hover_enabled=\"off\" button_two_text_color__hover=\"null\" button_border_width__hover_enabled=\"off\" button_border_width__hover=\"null\" button_one_border_width__hover_enabled=\"off\" button_one_border_width__hover=\"null\" button_two_border_width__hover_enabled=\"off\" button_two_border_width__hover=\"null\" button_border_color__hover_enabled=\"off\" button_border_color__hover=\"null\" button_one_border_color__hover_enabled=\"off\" button_one_border_color__hover=\"null\" button_two_border_color__hover_enabled=\"off\" button_two_border_color__hover=\"null\" button_border_radius__hover_enabled=\"off\" button_border_radius__hover=\"null\" button_one_border_radius__hover_enabled=\"off\" button_one_border_radius__hover=\"null\" button_two_border_radius__hover_enabled=\"off\" button_two_border_radius__hover=\"null\" button_letter_spacing__hover_enabled=\"off\" button_letter_spacing__hover=\"null\" button_one_letter_spacing__hover_enabled=\"off\" button_one_letter_spacing__hover=\"null\" button_two_letter_spacing__hover_enabled=\"off\" button_two_letter_spacing__hover=\"null\" button_bg_color__hover_enabled=\"off\" button_bg_color__hover=\"null\" button_one_bg_color__hover_enabled=\"off\" button_one_bg_color__hover=\"null\" button_two_bg_color__hover_enabled=\"off\" button_two_bg_color__hover=\"null\"][/et_pb_button][/et_pb_column][et_pb_column type=\"1_2\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text module_class=\"force_marg\" _builder_version=\"4.5.7\" text_text_color=\"#ffffff\" text_font_size=\"18px\" text_orientation=\"center\"]<p>Puppy Preschool Concord</p>[/et_pb_text][et_pb_button button_url=\"#concord\" button_text=\"Puppy Preschool\" button_alignment=\"center\" _builder_version=\"4.5.7\" background_layout=\"dark\" button_text_size__hover_enabled=\"off\" button_text_size__hover=\"null\" button_one_text_size__hover_enabled=\"off\" button_one_text_size__hover=\"null\" button_two_text_size__hover_enabled=\"off\" button_two_text_size__hover=\"null\" button_text_color__hover_enabled=\"off\" button_text_color__hover=\"null\" button_one_text_color__hover_enabled=\"off\" button_one_text_color__hover=\"null\" button_two_text_color__hover_enabled=\"off\" button_two_text_color__hover=\"null\" button_border_width__hover_enabled=\"off\" button_border_width__hover=\"null\" button_one_border_width__hover_enabled=\"off\" button_one_border_width__hover=\"null\" button_two_border_width__hover_enabled=\"off\" button_two_border_width__hover=\"null\" button_border_color__hover_enabled=\"off\" button_border_color__hover=\"null\" button_one_border_color__hover_enabled=\"off\" button_one_border_color__hover=\"null\" button_two_border_color__hover_enabled=\"off\" button_two_border_color__hover=\"null\" button_border_radius__hover_enabled=\"off\" button_border_radius__hover=\"null\" button_one_border_radius__hover_enabled=\"off\" button_one_border_radius__hover=\"null\" button_two_border_radius__hover_enabled=\"off\" button_two_border_radius__hover=\"null\" button_letter_spacing__hover_enabled=\"off\" button_letter_spacing__hover=\"null\" button_one_letter_spacing__hover_enabled=\"off\" button_one_letter_spacing__hover=\"null\" button_two_letter_spacing__hover_enabled=\"off\" button_two_letter_spacing__hover=\"null\" button_bg_color__hover_enabled=\"off\" button_bg_color__hover=\"null\" button_one_bg_color__hover_enabled=\"off\" button_one_bg_color__hover=\"null\" button_two_bg_color__hover_enabled=\"off\" button_two_bg_color__hover=\"null\"][/et_pb_button][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" module_id=\"puppyprem\" _builder_version=\"4.4.8\" background_color=\"#f6f6f6\" collapsed=\"on\"][et_pb_row _builder_version=\"3.25\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"4_4\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text _builder_version=\"4.4.8\"]<p style=\"text-align: center;\">If your schedule means you’re unable to attend group puppy classes, your whole family can enjoy learning to train your puppy at home.</p><p style=\"text-align: center;\">Premium Puppy covers all the information you need to manage those not-so-cute puppy behaviours such as toilet accidents, nipping, barking and jumping, as well as beginning basic training.</p><p style=\"text-align: center;\">An individual program will be tailored to address your specific concerns and needs, which Jenny will discuss at your first session.</p>\r[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" _builder_version=\"4.4.8\"][et_pb_row column_structure=\"1_2,1_2\" module_class=\"switch-image\" _builder_version=\"4.4.8\" custom_padding=\"27px|||||\"][et_pb_column type=\"1_2\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text _builder_version=\"4.6.6\" header_2_text_color=\"#1f1e86\" hover_enabled=\"0\" sticky_enabled=\"0\"]<h2 style=\"text-align: right;\">Your puppy will learn:</h2><p style=\"text-align: right;\">Basic behaviours, sit, drop down, stay, start leash walking, recall, how to release a treasure from their mouth, and how to go to his bed and settle.</p>\r[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_image src=\"/wp-content/uploads/2017/11/AdobeStock_123004237_o.jpg\" align_tablet=\"center\" align_phone=\"\" align_last_edited=\"on|desktop\" _builder_version=\"3.23\"][/et_pb_image][/et_pb_column][/et_pb_row][et_pb_row column_structure=\"1_2,1_2\" _builder_version=\"4.4.8\"][et_pb_column type=\"1_2\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_image src=\"/wp-content/uploads/2017/11/AdobeStock_163554641_o.jpg\" align_tablet=\"center\" align_phone=\"\" align_last_edited=\"on|desktop\" _builder_version=\"3.23\" hover_enabled=\"0\" sticky_enabled=\"0\"][/et_pb_image][et_pb_text _builder_version=\"4.6.6\" module_alignment=\"center\" hover_enabled=\"0\" sticky_enabled=\"0\"]<p style=\"text-align: center;\">If your schedule means you’re unable to attend group puppy classes, your whole family can enjoy learning to train your puppy at home.</p><p style=\"text-align: center;\">Premium Puppy covers all the information you need to manage those not-so-cute puppy behaviours such as toilet accidents, nipping, barking and jumping, as well as beginning basic training.</p><p style=\"text-align: center;\">An individual program will be tailored to address your specific concerns and needs, which Jenny will discuss at your first session.</p>\r[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text _builder_version=\"4.6.6\" header_2_text_color=\"#1f1e86\" hover_enabled=\"0\" sticky_enabled=\"0\"]<h2>You will learn:</h2><p>How to handle all those puppy challenges such as toilet training, nipping, barking, jumping up, preventing future problems and how to reinforce calm behaviour.  All taught using the latest science based positive reward training methods.</p>\r[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row _builder_version=\"3.25\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"4_4\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text _builder_version=\"4.6.6\" header_2_text_color=\"#1f1e86\" hover_enabled=\"0\" sticky_enabled=\"0\"]<h2 style=\"text-align: center;\">Socialization for your puppy</h2><p style=\"text-align: center;\">One of the most important steps in your puppy’s education, is a great socialization plan, a vital step to raising a confident, curious and happy puppy.  You will receive your Puppy Passport, a step-by-step guide to Operation Socialization, to ensure your puppy receivesa first class puppy socialization plan.</p><p style=\"text-align: center;\"><a href=\"http://www.operationsocialization.com/for-puppy-owners/about-for-puppy-owners.html\">www.OperationSocialization.com</a></p>\r[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" _builder_version=\"4.4.8\" background_color=\"#f6f6f6\"][et_pb_row column_structure=\"1_3,1_3,1_3\" _builder_version=\"4.4.8\" custom_css_main_element=\"display: -webkit-flex;||display: -ms-flex;||display: flex;||||-webkit-align-items: center; ||-ms-flex-align: center;||align-items: center; \"][et_pb_column type=\"1_3\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][/et_pb_column][et_pb_column type=\"1_3\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_pricing_tables header_background_color=\"#1f1e86\" _builder_version=\"4.6.6\" custom_button=\"on\" button_text_color=\"#1f1e86\" button_border_color=\"#1f1e86\" hover_enabled=\"0\" button_text_size__hover_enabled=\"off\" button_text_size__hover=\"null\" button_one_text_size__hover_enabled=\"off\" button_one_text_size__hover=\"null\" button_two_text_size__hover_enabled=\"off\" button_two_text_size__hover=\"null\" button_text_color__hover_enabled=\"off\" button_text_color__hover=\"null\" button_one_text_color__hover_enabled=\"off\" button_one_text_color__hover=\"null\" button_two_text_color__hover_enabled=\"off\" button_two_text_color__hover=\"null\" button_border_width__hover_enabled=\"off\" button_border_width__hover=\"null\" button_one_border_width__hover_enabled=\"off\" button_one_border_width__hover=\"null\" button_two_border_width__hover_enabled=\"off\" button_two_border_width__hover=\"null\" button_border_color__hover_enabled=\"off\" button_border_color__hover=\"null\" button_one_border_color__hover_enabled=\"off\" button_one_border_color__hover=\"null\" button_two_border_color__hover_enabled=\"off\" button_two_border_color__hover=\"null\" button_border_radius__hover_enabled=\"off\" button_border_radius__hover=\"null\" button_one_border_radius__hover_enabled=\"off\" button_one_border_radius__hover=\"null\" button_two_border_radius__hover_enabled=\"off\" button_two_border_radius__hover=\"null\" button_letter_spacing__hover_enabled=\"off\" button_letter_spacing__hover=\"null\" button_one_letter_spacing__hover_enabled=\"off\" button_one_letter_spacing__hover=\"null\" button_two_letter_spacing__hover_enabled=\"off\" button_two_letter_spacing__hover=\"null\" button_bg_color__hover_enabled=\"off\" button_bg_color__hover=\"null\" button_one_bg_color__hover_enabled=\"off\" button_one_bg_color__hover=\"null\" button_two_bg_color__hover_enabled=\"off\" button_two_bg_color__hover=\"null\" sticky_enabled=\"0\"][et_pb_pricing_table title=\"4 x 1hr lessons \" currency=\"$\" sum=\"485\" button_url=\"/contact/\" button_text=\"Book Now\" _builder_version=\"3.19.11\" price_text_color=\"#1f1e86\" header_text_color=\"#ffffff\" currency_frequency_text_color=\"#1f1e86\" background_color=\"#ffffff\" button_on_hover=\"on\" text_orientation=\"center\" border_color_all=\"#1f1e86\" sticky_transition=\"on\"][/et_pb_pricing_table][/et_pb_pricing_tables][/et_pb_column][et_pb_column type=\"1_3\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" _builder_version=\"3.22\"][et_pb_row _builder_version=\"3.25\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"4_4\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_testimonial author=\"Nicole & Mauro D\'Angelo\" _builder_version=\"4.6.6\" hover_enabled=\"0\" sticky_enabled=\"0\"]<p><em>“Our one-2-one home training with Jenny Harlow for our new pup Prince was an exceptional experience. Jenny is a highly experienced trainer, an absolute professional and incredibly astute and well organised. She specifically tailored private tuition for our pups needs, combining her very clear &amp; concise instruction using the ‘positive behavioural method’ ensured our dogs training was a huge success! Further, Jenny made training both educational &amp; fun. She’s very punctual and came super well prepared for our training…also providing us with extra tips, ideas, helpful references, and trouble shooting methods (including bespoke homework) specifically tailored  to ensure our dogs training success both during &amp; post tuition. Overall our training experience was a 10/10, and cannot recommend Jenny Harlow highly enough”.</em></p>\r[/et_pb_testimonial][et_pb_text module_id=\"concord\" _builder_version=\"4.6.6\" hover_enabled=\"0\" sticky_enabled=\"0\"]<h1 style=\"text-align: center;\">Puppy Preschool Concord</h1>\n<p style=\"text-align: center;\">Puppy Pre-school is a 4-week, small group class where you will learn all you need to care for and manage your new pup. In this class, we start foundation training and important socialisation exercises for your puppy. </p>[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row column_structure=\"1_2,1_2\" module_class=\"switch-image\" _builder_version=\"4.4.8\"][et_pb_column type=\"1_2\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text _builder_version=\"4.6.6\" header_2_text_color=\"#1f1e86\" hover_enabled=\"0\" sticky_enabled=\"0\"]<h2 style=\"text-align: left;\">Topics covered include:</h2>\n<ul style=\"text-align: left;\">\n<li style=\"text-align: left;\">Toilet Training</li>\n<li style=\"text-align: left;\">Puppy Nipping</li>\n<li style=\"text-align: left;\">Managing excited behaviour</li>\n<li style=\"text-align: left;\">Enrichment and food toys for your pup’s sharp teeth, curious brain and high energy</li>\n<li style=\"text-align: left;\">Exercise – what’s an appropriate amount and level</li>\n<li style=\"text-align: left;\">Socialisation – puppy play plus how to socialise your puppy to accept novel &amp; unexpected events, sights &amp; sounds</li>\n</ul>[/et_pb_text][et_pb_testimonial author=\"Chris & Leana with Lily the Whippet Puppy\" _builder_version=\"4.5.7\"]<p>“All of the techniques and management strategies have worked wonders on easing our frustrations and helping to manage our own expectations. Thanks for helping us go down this journey! We’ve taken it all on board and have noticed immediate results”.</p>[/et_pb_testimonial][/et_pb_column][et_pb_column type=\"1_2\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_image src=\"https://jhdogtraining.com.au/wp-content/uploads/2020/09/golden-retriever-puppy-scaled.jpg\" title_text=\"golden retriever puppy\" align_tablet=\"center\" align_phone=\"\" align_last_edited=\"on|desktop\" _builder_version=\"4.5.7\"][/et_pb_image][/et_pb_column][/et_pb_row][et_pb_row column_structure=\"1_2,1_2\" module_class=\"switch-image\" _builder_version=\"4.5.7\"][et_pb_column type=\"1_2\" _builder_version=\"4.5.7\" _module_preset=\"default\"][et_pb_image src=\"https://jhdogtraining.com.au/wp-content/uploads/2020/08/puppy-run.jpg\" title_text=\"puppy-run\" align_tablet=\"center\" align_phone=\"\" align_last_edited=\"on|desktop\" _builder_version=\"4.5.7\"][/et_pb_image][/et_pb_column][et_pb_column type=\"1_2\" _builder_version=\"4.5.7\" _module_preset=\"default\"][et_pb_text _builder_version=\"4.6.6\" header_2_text_color=\"#1f1e86\" hover_enabled=\"0\" sticky_enabled=\"0\"]<h2 style=\"text-align: left;\">Training:</h2>\n<p>Teach your puppy name recognition, sit, lure to mat and lie down, getting attention from your puppy, call your puppy to come, and start leash walking exercises</p>\n<p>When: Wednesday evenings, 6.30pm to 7.30pm<br />Address: St Luke’s Anglican Church, 17 Burton St Concord<br />Parking: There is free parking onsite<br />Cost: $180</p>\n<p>We provide ongoing support to new puppy owners with further training to continue your young dog’s education and development.<br />To join us at Puppy Preschool, <a href=\"https://jhdogtraining.com.au/contact/\">click here</a> and include your name, your puppy’s name, age &amp; breed and we will email you the next steps.</p>\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" fullwidth=\"on\" _builder_version=\"4.5.7\" _module_preset=\"default\"][/et_pb_section]', 'Puppy Pre-School', '', 'publish', 'closed', 'closed', '', 'premium-puppy', '', '', '2021-05-10 03:43:31', '2021-05-10 03:43:31', '', '0', 'http://jhdogtraining.wpengine.com/?page_id=204559', '0', 'page', '', '0'),
('204560', '1', '2017-11-20 17:36:42', '2017-11-20 17:36:42', ' ', '', '', 'publish', 'closed', 'closed', '', '204560', '', '', '2020-02-26 20:09:40', '2020-02-26 20:09:40', '', '0', 'http://jhdogtraining.wpengine.com/?p=204560', '3', 'nav_menu_item', '', '0'),
('204561', '1', '2017-11-20 17:42:12', '2017-11-20 17:42:12', '', 'shutterstock_134604923', '', 'inherit', 'open', 'closed', '', 'shutterstock_134604923', '', '', '2017-11-20 17:42:12', '2017-11-20 17:42:12', '', '42', 'http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/shutterstock_134604923.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204562', '1', '2017-11-20 17:44:07', '2017-11-20 17:44:07', '[et_pb_section fb_built=\"1\" _builder_version=\"3.22\" background_color=\"#e0e0e0\"][et_pb_row _builder_version=\"3.25\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"4_4\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text _builder_version=\"4.5.3\" header_font=\"|700|||||||\" header_text_color=\"#1f1e86\"]<h1 style=\"text-align: center;\"><strong>About Jenny Harlow</strong></h1>\r\n<p style=\"text-align: center;\">I am based in Marrickville, inner west Sydney.</p>\r[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" _builder_version=\"3.22\"][et_pb_row column_structure=\"1_3,2_3\" _builder_version=\"3.25\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"1_3\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_image src=\"/wp-content/uploads/2017/12/Jenny-Bonnie-laying-in-the-grass.jpg\" align_tablet=\"center\" align_phone=\"\" align_last_edited=\"on|desktop\" _builder_version=\"3.23\"][/et_pb_image][/et_pb_column][et_pb_column type=\"2_3\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text _builder_version=\"4.5.3\" hover_enabled=\"0\"]<p style=\"text-align: left;\">Jenny understands the unique training challenges faced by today’s dog owners, and she has the education, tools and experience to provide them with real solutions.</p>\n<p style=\"text-align: left;\">She is a Certified Training Partner of the Karen Pryor Academy, holds a Certificate IV in Companion Animal Services and is an accredited Canine Good Citizen (CGC) Trainer through the Delta Institute. In 2014, she learned about the devastating condition of separation anxiety in dogs and began researching the methods developed to treat this difficult issue. Today, she is proud to be the first Australian trainer to become a Certified Separation Anxiety Trainer (CSAT), having completed study with international Separation Anxiety Training expert, Malena DeMartini. She is also a member of the Association of Pet Dog Trainers Australia, Pet Professionals Guild and Dogs NSW. Whether a dog needs a little basic obedience training or has a more challenging behaviour issue, Jenny has the expertise to create a positive, lasting change.</p>\n<p style=\"text-align: left;\">Jenny first became interested in dog training when her Golden Retriever, Bonnie, turned into a doggie teenager. Suddenly, Bonnie was jumping on people, pulling on the lead, nipping her ankles and indulging in more than the occasional “gardening expedition. ”Jenny knew she needed help but wasn’t sure where to turn or who to trust. She began doing her own research and quickly learned that science-based, positive reinforcement training – both fun and highly effective for dogs and humans – was the answer! It wasn’t long before she began thinking of becoming a professional dog trainer so that she could help others with this knowledge.</p>\n<p style=\"text-align: left;\">Prior to making this transition, Jenny worked as an executive producer for a company responsible for touring major Broadway show in Australia and Asia. The job required clear communication, plenty of people skills, and constant attention to detail. Today, she uses these same skills – in addition to her experience and education as a dog trainer – to help her clients create happier, less stressful lives with their animal companions. For Jenny, working with dogs and their humans is “more rewarding than anything else I’ve ever done.” With compassion, patience and humour, she shows devoted dog owners how to cut through the clutter of Internet and dog park advice, communicate more clearly with their dogs, and get real results that last a lifetime.</p>\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" _builder_version=\"3.22\" background_color=\"#1f1e86\"][et_pb_row _builder_version=\"3.25\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"4_4\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text _builder_version=\"3.27.4\" text_text_color=\"#ffffff\" header_3_line_height=\"1.4em\" text_orientation=\"center\" background_layout=\"dark\" module_alignment=\"center\"]<h3 style=\"text-align: center;\"><strong>No matter what challenges you’re facing with your dog’s behavior, Jenny can help!</strong></h3>\r[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]', 'About Jenny Harlow', '', 'publish', 'closed', 'closed', '', 'abbout-jenny', '', '', '2020-08-10 02:47:03', '2020-08-10 02:47:03', '', '0', 'http://jhdogtraining.wpengine.com/?page_id=204562', '0', 'page', '', '0'),
('204563', '1', '2017-11-20 17:45:19', '2017-11-20 17:45:19', ' ', '', '', 'publish', 'closed', 'closed', '', '204563', '', '', '2020-02-26 20:09:40', '2020-02-26 20:09:40', '', '0', 'http://jhdogtraining.wpengine.com/?p=204563', '7', 'nav_menu_item', '', '0'),
('204568', '1', '2017-11-21 12:55:01', '2017-11-21 12:55:01', '', 'IMG_2019', '', 'inherit', 'open', 'closed', '', 'img_2019-2', '', '', '2017-11-21 12:55:01', '2017-11-21 12:55:01', '', '204557', 'http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/IMG_2019-1.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204590', '1', '2017-11-21 14:33:37', '2017-11-21 14:33:37', '', 'beagle-at-end-of-leash', '', 'inherit', 'open', 'closed', '', 'beagle-at-end-of-leash', '', '', '2017-11-21 14:33:37', '2017-11-21 14:33:37', '', '204557', 'http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/beagle-at-end-of-leash.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204592', '1', '2017-11-21 14:43:06', '2017-11-21 14:43:06', '', 'GD-pulling-on-leash', '', 'inherit', 'open', 'closed', '', 'gd-pulling-on-leash', '', '', '2017-11-21 14:43:06', '2017-11-21 14:43:06', '', '204559', 'http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/GD-pulling-on-leash.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204596', '1', '2017-11-22 07:00:58', '2017-11-22 07:00:58', '[et_pb_section bb_built=\"1\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_contact_form _builder_version=\"3.0.89\" title=\"Click here &amp;Jenny will call you to discuss your needs and book your training session \" captcha=\"on\" use_redirect=\"off\" custom_button=\"off\" button_icon_placement=\"right\"] [et_pb_contact_field field_title=\"First Name\" field_type=\"input\" field_id=\"first_name\" required_mark=\"on\" fullwidth_field=\"off\" _builder_version=\"3.0.89\" checkbox_checked=\"off\" checkbox_options=\"%91{%22value%22:%22Name%22,%22checked%22:0}%93\" radio_options=\"%91{%22value%22:%22Name%22,%22checked%22:0}%93\" select_options=\"%91{%22value%22:%22Name%22,%22checked%22:0}%93\" min_length=\"0\" max_length=\"0\" allowed_symbols=\"all\" conditional_logic=\"off\" conditional_logic_relation=\"off\" conditional_logic_rules=\"%91{%22field%22:%22email%22,%22condition%22:%22is%22,%22value%22:%22%22}%93\" use_background_color_gradient=\"off\" background_color_gradient_start=\"#2b87da\" background_color_gradient_end=\"#29c4a9\" background_color_gradient_type=\"linear\" background_color_gradient_direction=\"180deg\" background_color_gradient_direction_radial=\"center\" background_color_gradient_start_position=\"0%\" background_color_gradient_end_position=\"100%\" background_color_gradient_overlays_image=\"off\" parallax=\"off\" parallax_method=\"on\" background_size=\"cover\" background_position=\"center\" background_repeat=\"no-repeat\" background_blend=\"normal\" allow_player_pause=\"off\" /][et_pb_contact_field field_title=\"Email Address\" field_type=\"email\" field_id=\"email_address\" required_mark=\"on\" fullwidth_field=\"off\" _builder_version=\"3.0.89\" checkbox_checked=\"off\" checkbox_options=\"%91{%22value%22:%22Email Address%22,%22checked%22:0}%93\" radio_options=\"%91{%22value%22:%22Email Address%22,%22checked%22:0}%93\" select_options=\"%91{%22value%22:%22Email Address%22,%22checked%22:0}%93\" min_length=\"0\" max_length=\"0\" allowed_symbols=\"all\" conditional_logic=\"off\" conditional_logic_relation=\"off\" conditional_logic_rules=\"%91{%22field%22:%22first_name%22,%22condition%22:%22is%22,%22value%22:%22%22}%93\" use_background_color_gradient=\"off\" background_color_gradient_start=\"#2b87da\" background_color_gradient_end=\"#29c4a9\" background_color_gradient_type=\"linear\" background_color_gradient_direction=\"180deg\" background_color_gradient_direction_radial=\"center\" background_color_gradient_start_position=\"0%\" background_color_gradient_end_position=\"100%\" background_color_gradient_overlays_image=\"off\" parallax=\"off\" parallax_method=\"on\" background_size=\"cover\" background_position=\"center\" background_repeat=\"no-repeat\" background_blend=\"normal\" allow_player_pause=\"off\" /][et_pb_contact_field field_title=\"Message\" field_type=\"text\" field_id=\"Message\" required_mark=\"on\" fullwidth_field=\"on\" _builder_version=\"3.0.89\" /] [/et_pb_contact_form][/et_pb_column][/et_pb_row][/et_pb_section]', 'Private Consult Page', '', 'publish', 'closed', 'closed', '', 'private-consult-page', '', '', '2017-11-22 07:00:58', '2017-11-22 07:00:58', '', '0', 'http://jhdogtraining.wpengine.com/?page_id=204596', '0', 'page', '', '0'),
('204601', '1', '2017-11-30 10:07:48', '2017-11-30 10:07:48', '', 'TOP-IMAGE_o', '', 'inherit', 'open', 'closed', '', 'top-image_o', '', '', '2017-11-30 10:07:48', '2017-11-30 10:07:48', '', '42', 'http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/TOP-IMAGE_o.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204602', '1', '2017-11-30 10:12:44', '2017-11-30 10:12:44', '', 'TOP-IMAGE_o', '', 'inherit', 'open', 'closed', '', 'top-image_o-2', '', '', '2017-11-30 10:12:44', '2017-11-30 10:12:44', '', '42', 'http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/TOP-IMAGE_o-1.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204603', '1', '2017-11-30 10:16:32', '2017-11-30 10:16:32', '', 'separation-anxiety_o', '', 'inherit', 'open', 'closed', '', 'separation-anxiety_o', '', '', '2017-11-30 10:16:32', '2017-11-30 10:16:32', '', '42', 'http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/separation-anxiety_o.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204604', '1', '2017-11-30 10:26:17', '2017-11-30 10:26:17', '', 'Blog', '', 'publish', 'closed', 'closed', '', 'blog', '', '', '2018-05-23 04:16:50', '2018-05-23 04:16:50', '', '0', 'http://jhdogtraining.wpengine.com/?page_id=204604', '0', 'page', '', '0'),
('204605', '1', '2017-11-30 10:26:57', '2017-11-30 10:26:57', ' ', '', '', 'publish', 'closed', 'closed', '', '204605', '', '', '2020-02-26 20:09:40', '2020-02-26 20:09:40', '', '0', 'http://jhdogtraining.wpengine.com/?p=204605', '8', 'nav_menu_item', '', '0'),
('204606', '1', '2017-11-30 10:28:57', '2017-11-30 10:28:57', '[et_pb_section bb_built=\"1\" fullwidth=\"off\" specialty=\"off\" _builder_version=\"3.0.89\" background_color=\"#e0e0e0\" next_background_color=\"#ffffff\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text _builder_version=\"3.12.2\" header_font=\"|700|||||||\" header_text_color=\"#1f1e86\" module_class=\"head_link\"]\r\n<h1 style=\"text-align: center;\"><strong>It\'s always better to ask for help sooner rather than later. <a href=\"tel:0-419-535-236\">Call</a> or <a href=\"mailto:jenny@jhdogtraining.com.au\">email</a> Jenny, or you can submit the form below and Jenny will call you soon</strong><strong>. </strong></h1>\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section bb_built=\"1\" _builder_version=\"3.0.89\" prev_background_color=\"#e0e0e0\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text _builder_version=\"3.0.89\" background_layout=\"light\"]\r\n\r\n[contact-form-7 id=\"204678\" title=\"Contact form 1\"]\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]', 'Contact', '', 'publish', 'closed', 'closed', '', 'contact', '', '', '2018-09-14 14:59:26', '2018-09-14 14:59:26', '', '0', 'http://jhdogtraining.wpengine.com/?page_id=204606', '0', 'page', '', '0'),
('204607', '1', '2017-11-30 10:29:16', '2017-11-30 10:29:16', ' ', '', '', 'publish', 'closed', 'closed', '', '204607', '', '', '2020-02-26 20:09:40', '2020-02-26 20:09:40', '', '0', 'http://jhdogtraining.wpengine.com/?p=204607', '5', 'nav_menu_item', '', '0'),
('204608', '1', '2017-11-30 10:34:01', '2017-11-30 10:34:01', '', 'TOP-IMAGE_o', '', 'inherit', 'open', 'closed', '', 'top-image_o-3', '', '', '2017-11-30 10:34:01', '2017-11-30 10:34:01', '', '204557', 'http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/TOP-IMAGE_o-2.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204609', '1', '2017-11-30 10:42:03', '2017-11-30 10:42:03', '', 'TOP-IMAGE_o', '', 'inherit', 'open', 'closed', '', 'top-image_o-4', '', '', '2017-11-30 10:42:03', '2017-11-30 10:42:03', '', '204553', 'http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/TOP-IMAGE_o-3.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204610', '1', '2017-11-30 10:44:11', '2017-11-30 10:44:11', '', 'TOP-IMAGE_159644971', '', 'inherit', 'open', 'closed', '', 'top-image_159644971', '', '', '2017-11-30 10:44:11', '2017-11-30 10:44:11', '', '204553', 'http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/TOP-IMAGE_159644971.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204611', '1', '2017-11-30 17:10:36', '2017-11-30 17:10:36', '', 'AdobeStock_94700859_o', '', 'inherit', 'open', 'closed', '', 'adobestock_94700859_o', '', '', '2017-11-30 17:10:36', '2017-11-30 17:10:36', '', '204557', 'http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/AdobeStock_94700859_o.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204612', '1', '2017-11-30 17:11:27', '2017-11-30 17:11:27', '', 'AdobeStock_115392600_o', '', 'inherit', 'open', 'closed', '', 'adobestock_115392600_o', '', '', '2017-11-30 17:11:27', '2017-11-30 17:11:27', '', '204557', 'http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/AdobeStock_115392600_o.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204613', '1', '2017-11-30 17:32:32', '2017-11-30 17:32:32', '', 'AdobeStock_151809495_o', '', 'inherit', 'open', 'closed', '', 'adobestock_151809495_o', '', '', '2017-11-30 17:32:32', '2017-11-30 17:32:32', '', '204553', 'http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/AdobeStock_151809495_o.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204614', '1', '2017-11-30 17:33:09', '2017-11-30 17:33:09', '', 'AdobeStock_84330916_o', '', 'inherit', 'open', 'closed', '', 'adobestock_84330916_o', '', '', '2017-11-30 17:33:09', '2017-11-30 17:33:09', '', '204553', 'http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/AdobeStock_84330916_o.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204615', '1', '2017-11-30 18:25:27', '2017-11-30 18:25:27', '', 'TOP-IMAAGE_o', '', 'inherit', 'open', 'closed', '', 'top-imaage_o', '', '', '2017-11-30 18:25:27', '2017-11-30 18:25:27', '', '204559', 'http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/TOP-IMAAGE_o.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204616', '1', '2017-11-30 18:26:14', '2017-11-30 18:26:14', '', 'AdobeStock_123004237_o', '', 'inherit', 'open', 'closed', '', 'adobestock_123004237_o', '', '', '2017-11-30 18:26:14', '2017-11-30 18:26:14', '', '204559', 'http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/AdobeStock_123004237_o.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204617', '1', '2017-11-30 18:26:54', '2017-11-30 18:26:54', '', 'AdobeStock_163554641_o', '', 'inherit', 'open', 'closed', '', 'adobestock_163554641_o', '', '', '2017-11-30 18:26:54', '2017-11-30 18:26:54', '', '204559', 'http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/AdobeStock_163554641_o.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204618', '1', '2017-11-30 18:28:49', '2017-11-30 18:28:49', '', 'TOP-IMAAGE_o', '', 'inherit', 'open', 'closed', '', 'top-imaage_o-2', '', '', '2017-11-30 18:28:49', '2017-11-30 18:28:49', '', '204559', 'http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/TOP-IMAAGE_o-1.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204620', '1', '2017-11-30 18:32:24', '2017-11-30 18:32:24', 'The following document sets forth the Privacy Policy for the JENNY HARLOW DOG TRAINING website, <a href=\"https://www.jhdogtraining.com.au\"><em>www.jhdogtraining.com.au</em></a>\r\n\r\nJENNY HARLOW DOG TRAINING is committed to providing you with the best possible customer service experience. JENNY HARLOW DOG TRAINING is bound by the Privacy Act 1988 (Crh), which sets out a number of principles concerning the privacy of individuals.\r\n\r\n<strong>Collection of your personal information</strong>\r\n\r\nThere are many aspects of the site, which can be viewed without providing personal information, however, for access to future JENNY HARLOW DOG TRAINING customer support features you are required to submit personally identifiable information. This may include but not limited to a unique username and password, or provide sensitive information in the recovery of your lost password.\r\n\r\n<strong> </strong>\r\n\r\n<strong>Sharing of your personal information</strong>\r\n\r\nWe do not share or sell your contact details unless absolutely required in the delivery of our service to you- for example: We may occasionally hire other companies to provide services on our behalf, including but not limited to handling customer support inquiries, processing transactions or customer freight shipping. Those companies will be permitted to obtain only the personal information they need to deliver the service. JENNY HARLOW DOG TRAINING takes reasonable steps to ensure that these organisations are bound by confidentiality and privacy obligations in relation to the protection of your personal information.\r\n\r\n&nbsp;\r\n\r\n<strong>Use of your personal information</strong>\r\n\r\nFor each visitor to reach the site, we expressively collect the following <strong>non-personally identifiable</strong> information, including but not limited to browser type, version and language, operating system, pages viewed while browsing the Site, page access times and referring website address. This collected information is used solely internally for the purpose of gauging visitor traffic, trends and delivering personalized content to you while you are at this Site.\r\n\r\nFrom time to time, we may use customer information for new, unanticipated uses not previously disclosed in our privacy notice. If our information practices change at some time in the future we will use for these new purposes only, data collected from the time of the policy change forward will adhere to our updated practices.\r\n\r\n<strong>Changes to this Privacy Policy</strong>\r\n\r\nJENNY HARLOW DOG TRAINING reserves the right to make amendments to this Privacy Policy at any time. If you have objections to the Privacy Policy, you should not access or use the Site.\r\n\r\n&nbsp;\r\n\r\n<strong>Accessing Your Personal Information</strong>\r\n\r\nYou have a right to access your personal information, subject to exceptions allowed by law. If you would like to do so, please let us know. You may be required to put your request in writing for security reasons. JENNY HARLOW DOG TRAINING reserves the right to charge a fee for searching for, and providing access to, your information on a per request basis.\r\n\r\n&nbsp;\r\n\r\n<strong>Contacting us</strong>\r\n\r\nJENNY HARLOW DOG TRAINING welcomes your comments regarding this Privacy Policy. If you have any questions about this Privacy Policy and would like further information, please contact us by any of the following means during business hours Monday to Friday.\r\n\r\nPost: Attn: JENNY HARLOW DOG TRAINING, Jenny Harlow\r\n<em>19 South St, Marrickville NSW 2204</em>\r\n\r\nE-mail: <a href=\"mailto:jenny@jhdogtraining.com.au\"><em>jenny@jhdogtraining.com.au</em></a>\r\n\r\nT: Jenny Harlow on 0419 535 236', 'Privacy Policy', '', 'publish', 'closed', 'closed', '', 'privacy-policy', '', '', '2017-11-30 18:32:24', '2017-11-30 18:32:24', '', '0', 'http://jhdogtraining.wpengine.com/?page_id=204620', '0', 'page', '', '0'),
('204626', '1', '2017-12-02 16:41:49', '2017-12-02 16:41:49', '', 'JH_Horizontal', '', 'inherit', 'open', 'closed', '', 'jh_horizontal-5', '', '', '2017-12-02 16:41:49', '2017-12-02 16:41:49', '', '0', 'http://jhdogtraining.wpengine.com/wp-content/uploads/2017/12/JH_Horizontal-4.png', '0', 'attachment', 'image/png', '0'),
('204627', '1', '2017-12-02 16:45:01', '2017-12-02 16:45:01', '', 'IMG_2019_o', '', 'inherit', 'open', 'closed', '', 'img_2019_o', '', '', '2017-12-02 16:45:01', '2017-12-02 16:45:01', '', '42', 'http://jhdogtraining.wpengine.com/wp-content/uploads/2017/12/IMG_2019_o.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204628', '1', '2017-12-02 16:45:16', '2017-12-02 16:45:16', '', 'AdobeStock_119270241_o', '', 'inherit', 'open', 'closed', '', 'adobestock_119270241_o', '', '', '2017-12-02 16:45:16', '2017-12-02 16:45:16', '', '42', 'http://jhdogtraining.wpengine.com/wp-content/uploads/2017/12/AdobeStock_119270241_o.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204630', '1', '2017-12-02 16:58:07', '2017-12-02 16:58:07', '', 'csat_seal_web', '', 'inherit', 'open', 'closed', '', 'csat_seal_web', '', '', '2017-12-08 17:30:26', '2017-12-08 17:30:26', '', '204653', 'http://jhdogtraining.wpengine.com/wp-content/uploads/2017/12/csat_seal_web.png', '0', 'attachment', 'image/png', '0'),
('204633', '1', '2017-12-02 17:05:34', '2017-12-02 17:05:34', '', 'DELTA_INSTITUTE_LOGO_MEMBER_PATHS', '', 'inherit', 'open', 'closed', '', 'delta_institute_logo_member_paths', '', '', '2017-12-02 17:05:34', '2017-12-02 17:05:34', '', '0', 'http://jhdogtraining.wpengine.com/wp-content/uploads/2017/12/DELTA_INSTITUTE_LOGO_MEMBER_PATHS.png', '0', 'attachment', 'image/png', '0'),
('204641', '1', '2017-12-06 17:31:14', '2017-12-06 17:31:14', '', 'AdobeStock_180762320_o', '', 'inherit', 'open', 'closed', '', 'adobestock_180762320_o', '', '', '2017-12-06 17:31:14', '2017-12-06 17:31:14', '', '42', 'http://jhdogtraining.wpengine.com/wp-content/uploads/2017/12/AdobeStock_180762320_o.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204642', '1', '2017-12-06 17:34:54', '2017-12-06 17:34:54', '', 'sepanx-terrier', '', 'inherit', 'open', 'closed', '', 'sepanx-terrier', '', '', '2017-12-06 17:34:54', '2017-12-06 17:34:54', '', '42', 'http://jhdogtraining.wpengine.com/wp-content/uploads/2017/12/sepanx-terrier.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204643', '1', '2017-12-06 17:41:23', '2017-12-06 17:41:23', '', 'Jenny-&-Bonnie-laying-in-the-grass', '', 'inherit', 'open', 'closed', '', 'jenny-bonnie-laying-in-the-grass', '', '', '2017-12-06 17:41:23', '2017-12-06 17:41:23', '', '42', 'http://jhdogtraining.wpengine.com/wp-content/uploads/2017/12/Jenny-Bonnie-laying-in-the-grass.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204645', '1', '2017-12-07 06:30:35', '2017-12-07 06:30:35', '', 'AdobeStock_180762347_o', '', 'inherit', 'open', 'closed', '', 'adobestock_180762347_o', '', '', '2017-12-07 06:30:35', '2017-12-07 06:30:35', '', '204557', 'http://jhdogtraining.wpengine.com/wp-content/uploads/2017/12/AdobeStock_180762347_o.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204646', '1', '2017-12-07 06:32:12', '2017-12-07 06:32:12', '', 'AdobeStock_180762347_o', '', 'inherit', 'open', 'closed', '', 'adobestock_180762347_o-2', '', '', '2017-12-07 06:32:12', '2017-12-07 06:32:12', '', '204557', 'http://jhdogtraining.wpengine.com/wp-content/uploads/2017/12/AdobeStock_180762347_o-1.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204647', '1', '2017-12-07 06:57:46', '2017-12-07 06:57:46', '', 'black-dog-in-window', '', 'inherit', 'open', 'closed', '', 'black-dog-in-window', '', '', '2017-12-07 06:57:46', '2017-12-07 06:57:46', '', '204553', 'http://jhdogtraining.wpengine.com/wp-content/uploads/2017/12/black-dog-in-window.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204649', '1', '2017-12-08 14:09:55', '2017-12-08 14:09:55', '[et_pb_section bb_built=\"1\" fullwidth=\"off\" specialty=\"off\" _builder_version=\"3.0.89\" background_color=\"#e0e0e0\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text _builder_version=\"3.0.89\" background_layout=\"light\" header_font=\"|700|||||||\" header_text_color=\"#1f1e86\"]\r\n<h1 style=\"text-align: center;\"><strong>Group Classes</strong></h1>\r\n<p style=\"text-align: center;\">Learn to train your adolescent dog so they can become the welcome family member of your dreams!\r\nFor dogs 5 months of age and older.</p>\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section bb_built=\"1\"][et_pb_row][et_pb_column type=\"1_2\"][et_pb_text _builder_version=\"3.0.89\" background_layout=\"light\"]\r\n\r\nGladesville Veterinary Hospital\r\nCANINE COLLEGE\r\nfor bookings go to:\r\n<a href=\"https://gladesvillevet.com.au/dog-behaviour-training/\" target=\"_blank\" rel=\"noopener\">https://gladesvillevet.com.au/dog-behaviour-training/</a>\r\nPh: 02 9817 5758\r\n\r\n<img class=\"alignleft size-full wp-image-204651\" src=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/12/unnamed.png\" alt=\"\" width=\"189\" height=\"48\" />\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_text _builder_version=\"3.0.89\" background_layout=\"light\"]\r\n\r\nUniversity Veterinary Teaching Hospital Sydney\r\nPUPPY HIGH SCHOOL\r\nfor bookings go to:\r\n<a href=\"http://www.uvths.com.au/juvenile-programs\" target=\"_blank\" rel=\"noopener\">http://www.uvths.com.au/juvenile-programs</a>\r\nPh: 02 9351 3437\r\n\r\n<img class=\"alignleft size-full wp-image-204652\" src=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/12/unnamed-1.png\" alt=\"\" width=\"238\" height=\"88\" />\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]', 'Group Classes', '', 'publish', 'closed', 'closed', '', 'group-classes', '', '', '2017-12-08 14:18:40', '2017-12-08 14:18:40', '', '0', 'http://jhdogtraining.wpengine.com/?page_id=204649', '0', 'page', '', '0'),
('204651', '1', '2017-12-08 14:18:19', '2017-12-08 14:18:19', '', 'unnamed', '', 'inherit', 'open', 'closed', '', 'unnamed', '', '', '2017-12-08 14:18:19', '2017-12-08 14:18:19', '', '204649', 'http://jhdogtraining.wpengine.com/wp-content/uploads/2017/12/unnamed.png', '0', 'attachment', 'image/png', '0'),
('204652', '1', '2017-12-08 14:18:35', '2017-12-08 14:18:35', '', 'unnamed-1', '', 'inherit', 'open', 'closed', '', 'unnamed-1', '', '', '2017-12-08 14:18:35', '2017-12-08 14:18:35', '', '204649', 'http://jhdogtraining.wpengine.com/wp-content/uploads/2017/12/unnamed-1.png', '0', 'attachment', 'image/png', '0'),
('204653', '1', '2017-12-08 17:30:54', '2017-12-08 17:30:54', '[et_pb_section bb_built=\"1\" admin_label=\"section\" _builder_version=\"3.0.47\" custom_padding=\"52px|0px|52.3906px|0px\"][et_pb_row admin_label=\"row\" _builder_version=\"3.0.47\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"4_4\"][et_pb_text _builder_version=\"3.0.89\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\" background_layout=\"light\"]\r\n<p style=\"text-align: center;\"><strong>Separation anxiety in dogs?</strong></p>\r\nWhen I tell people I recently learned how to work with dogs with separation anxiety, some of them look at me a little funny. And for those lucky people who’s dogs don’t bat an eyelid when their human departs, it can be hard to understand the devastating affect of this condition, not just on the dog, but also on the humans who love them.\r\n\r\n<img class=\"wp-image-204642 aligncenter\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2017/12/sepanx-terrier-300x200.jpg\" alt=\"\" width=\"150\" height=\"100\" /><strong>What does it look like?</strong> Does your dog whimper, cry, bark or howl for hours after you’ve gone? Do you come home to a scene of destruction because your dog has been pawing and chewing at the door or skirting boards, destroying your furniture? Does your dog eliminate repeatedly all over your carpet? If this is your dog, he may be suffering from separation anxiety.\r\n\r\n<strong>What to do?</strong>\r\nThe good news is, help is available. You can work with a Certified Separation Anxiety Trainer (CSAT) to learn how to gradually introduce your dog to absences, at the rate and duration that your dog can accept calmly. And Jenny is proud to be the first dog trainer in Australia to become a Certified Separation Anxiety Trainer.\r\n\r\nWorking with a CSAT means you have access to well-trialled training methods that teach your dog how to be relaxed when left alone. Plus, you have access to all the support, help and cheerleading you need to get you through the challenge of being the guardian of a dog with separation anxiety.\r\n\r\n<strong>How?</strong>\r\nTechnology is our friend when working with separation anxiety. By working online you and and Jenny will see your dog’s response at each step of the process, which means instant feedback informing how to move forward. It is the most efficient route to reaching your goals, gives you more bang for you buck, and means Jenny can work with people across Australia and overseas.\r\n\r\n<strong>So what now?</strong>\r\nAs the first dog trainer in Australia to study with international separation anxiety expert Malena DeMartini (www.malenademartini.com ), Jenny is proud to be a CSAT working to improve the lives of dogs with separation anxiety and their long-suffering humans.\r\n\r\nHelp is available. To discuss your dog and learn about this training process, click <a href=\"https://jhdogtraining.com.au/separation-anxiety/\">here</a>.\r\n\r\n<img class=\"alignleft size-full wp-image-204654\" src=\"https://jhdogtraining.wpengine.com/wp-content/uploads/2017/12/csat_seal_web-1.png\" alt=\"\" width=\"107\" height=\"80\" />\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]', 'Separation anxiety in dogs', '', 'publish', 'closed', 'open', '', 'separation-anxiety-in-dogs', '', '', '2017-12-27 02:56:36', '2017-12-27 02:56:36', '', '0', 'http://jhdogtraining.wpengine.com/?p=204653', '0', 'post', '', '0'),
('204654', '1', '2017-12-08 17:30:47', '2017-12-08 17:30:47', '', 'csat_seal_web', '', 'inherit', 'open', 'closed', '', 'csat_seal_web-2', '', '', '2017-12-08 17:30:47', '2017-12-08 17:30:47', '', '204653', 'http://jhdogtraining.wpengine.com/wp-content/uploads/2017/12/csat_seal_web-1.png', '0', 'attachment', 'image/png', '0'),
('204656', '1', '2018-01-08 21:39:48', '2018-01-08 21:39:48', '[et_pb_section bb_built=\"1\" _builder_version=\"3.0.89\"][et_pb_row _builder_version=\"3.0.89\"][et_pb_column type=\"4_4\"][et_pb_text _builder_version=\"3.0.89\" /][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_4\"][et_pb_blurb _builder_version=\"3.0.89\" title=\"Reach out\" url_new_window=\"off\" use_icon=\"on\" font_icon=\"%%75%%\" icon_color=\"#1f1f83\" use_circle=\"off\" use_circle_border=\"off\" icon_placement=\"top\" use_icon_font_size=\"on\" background_layout=\"light\" text_orientation=\"center\" header_font=\"|700|||||||\" icon_font_size=\"45px\" header_text_color=\"#1f1e86\"]\r\n\r\nFill out the contact form by <u>clicking here</u> and Jenny will be in touch to further learn about your situation, and discuss the treatment protocol and fees.\r\n\r\n[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_blurb _builder_version=\"3.0.89\" title=\"Complete a consultation\" url_new_window=\"off\" use_icon=\"on\" font_icon=\"%%264%%\" icon_color=\"#1f1f83\" use_circle=\"off\" use_circle_border=\"off\" icon_placement=\"top\" use_icon_font_size=\"on\" background_layout=\"light\" text_orientation=\"center\" header_font=\"|700|||||||\" icon_font_size=\"45px\" header_text_color=\"#1f1e86\"]\r\n\r\nAs soon you’re ready to get started, Jenny will set up an initial consultation with you to learn more about your dog and your goals for treatment. During this on line consultation, lasting 1 to 1.5hrs, she’ll gather information about your dog’s temperament, personality, and behavioral and medical histories. She will then conduct a short assessment.\r\n\r\n[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_blurb _builder_version=\"3.0.89\" title=\"Implement a treatment plan\" url_new_window=\"off\" use_icon=\"on\" font_icon=\"%%175%%\" icon_color=\"#1f1f83\" use_circle=\"off\" use_circle_border=\"off\" icon_placement=\"top\" use_icon_font_size=\"on\" background_layout=\"light\" text_orientation=\"center\" header_font=\"|700|||||||\" icon_font_size=\"45px\" header_text_color=\"#1f1e86\"]\r\n\r\nBased on the assessment, a treatment plan will be customized especially for your dog and lifestyle, complete with easy-to-follow instructions and ongoing support.\r\n\r\n[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_blurb _builder_version=\"3.0.89\" title=\"Live the dream\" url_new_window=\"off\" use_icon=\"on\" font_icon=\"%%171%%\" icon_color=\"#1f1f83\" use_circle=\"off\" use_circle_border=\"off\" icon_placement=\"top\" use_icon_font_size=\"on\" background_layout=\"light\" text_orientation=\"center\" header_font=\"|700|||||||\" icon_font_size=\"45px\" header_text_color=\"#1f1e86\"]\r\n\r\nImagine being able to run to the store or go to work while your dog peacefully snores away on the sofa. With patience, consistency and personal support from Jenny, this dream can be a reality!\r\n\r\n[/et_pb_blurb][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_2\"][et_pb_text _builder_version=\"3.0.89\" background_layout=\"light\"]\r\n<h1>hfghfdghfdg</h1>\r\nsdhsdgfh\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"1_2\"][et_pb_text _builder_version=\"3.0.89\" background_layout=\"light\"]\r\n<h1>hfghfdghfdg</h1>\r\nsdhsdgfh\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section bb_built=\"1\" fullwidth=\"off\" specialty=\"off\"][et_pb_row][et_pb_column type=\"1_2\"][/et_pb_column][et_pb_column type=\"1_2\"][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section bb_built=\"1\" fullwidth=\"off\" specialty=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text _builder_version=\"3.0.89\" background_layout=\"light\"]\r\n<h1 class=\"et_pb_contact_main_title\">separation anxiety assessment form</h1>\r\n[contact-form-7 id=\"204679\" title=\"separation anxiety assessment form\"]\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section bb_built=\"1\" fullwidth=\"off\" specialty=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text _builder_version=\"3.0.89\" background_layout=\"light\"]\r\n\r\n[contact-form-7 id=\"204678\" title=\"Contact form 1\"]\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section bb_built=\"1\" _builder_version=\"3.0.89\"][et_pb_row _builder_version=\"3.0.89\"][et_pb_column type=\"4_4\"][et_pb_contact_form _builder_version=\"3.0.89\" captcha=\"on\" use_redirect=\"off\" custom_button=\"on\" button_icon_placement=\"right\" button_text_color=\"#1f1e86\" button_border_color=\"#1f1e86\" email=\"jenny@jhdogtraining.com.au\" success_message=\"Jenny will contact you shortly to discuss the best plan for you and your dog. \"]\r\n\r\n[et_pb_contact_field field_title=\"Name\" field_type=\"input\" field_id=\"Name\" required_mark=\"on\" fullwidth_field=\"off\" border_radii=\"on||||\" _builder_version=\"3.0.89\" /][et_pb_contact_field field_title=\"Email Address\" field_type=\"email\" field_id=\"Email\" required_mark=\"on\" fullwidth_field=\"off\" border_radii=\"on||||\" _builder_version=\"3.0.89\" /][et_pb_contact_field _builder_version=\"3.0.89\" field_id=\"phone\" field_title=\"Phone\" field_type=\"input\" checkbox_checked=\"off\" checkbox_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" radio_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" select_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" min_length=\"0\" max_length=\"0\" allowed_symbols=\"all\" required_mark=\"on\" conditional_logic=\"off\" conditional_logic_relation=\"off\" conditional_logic_rules=\"%91{%22field%22:%22name%22,%22condition%22:%22is%22,%22value%22:%22%22}%93\" use_background_color_gradient=\"off\" background_color_gradient_start=\"#2b87da\" background_color_gradient_end=\"#29c4a9\" background_color_gradient_type=\"linear\" background_color_gradient_direction=\"180deg\" background_color_gradient_direction_radial=\"center\" background_color_gradient_start_position=\"0%\" background_color_gradient_end_position=\"100%\" background_color_gradient_overlays_image=\"off\" parallax=\"off\" parallax_method=\"on\" background_size=\"cover\" background_position=\"center\" background_repeat=\"no-repeat\" background_blend=\"normal\" allow_player_pause=\"off\" fullwidth_field=\"on\" /][et_pb_contact_field field_title=\"How can I help?\" field_type=\"text\" field_id=\"Tell_me_about_your_dog.\" required_mark=\"on\" fullwidth_field=\"on\" _builder_version=\"3.0.89\" checkbox_checked=\"off\" checkbox_options=\"%91{%22value%22:%22Message%22,%22checked%22:0}%93\" radio_options=\"%91{%22value%22:%22Message%22,%22checked%22:0}%93\" select_options=\"%91{%22value%22:%22Message%22,%22checked%22:0}%93\" min_length=\"0\" max_length=\"0\" allowed_symbols=\"all\" conditional_logic=\"off\" conditional_logic_relation=\"off\" conditional_logic_rules=\"%91{%22field%22:%22name%22,%22condition%22:%22is%22,%22value%22:%22%22}%93\" use_background_color_gradient=\"off\" background_color_gradient_start=\"#2b87da\" background_color_gradient_end=\"#29c4a9\" background_color_gradient_type=\"linear\" background_color_gradient_direction=\"180deg\" background_color_gradient_direction_radial=\"center\" background_color_gradient_start_position=\"0%\" background_color_gradient_end_position=\"100%\" background_color_gradient_overlays_image=\"off\" parallax=\"off\" parallax_method=\"on\" background_size=\"cover\" background_position=\"center\" background_repeat=\"no-repeat\" background_blend=\"normal\" allow_player_pause=\"off\" /]\r\n\r\n[/et_pb_contact_form][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section bb_built=\"1\" fullwidth=\"off\" specialty=\"off\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_contact_form _builder_version=\"3.0.89\" captcha=\"on\" use_redirect=\"off\" custom_button=\"on\" button_icon_placement=\"right\" email=\"jenny@jhdogtraining.com.au\" button_text_color=\"#1f1e86\" button_border_color=\"#1f1e86\" title=\"separation anxiety assessment form\" title_text_align=\"center\" success_message=\"Thank you for filling out the form. Jenny will contact you shortly.\"]\r\n\r\n[et_pb_contact_field field_title=\"First Name\" field_type=\"input\" field_id=\"first_name\" required_mark=\"on\" fullwidth_field=\"off\" _builder_version=\"3.0.89\" checkbox_checked=\"off\" checkbox_options=\"%91{%22value%22:%22Name%22,%22checked%22:0}%93\" radio_options=\"%91{%22value%22:%22Name%22,%22checked%22:0}%93\" select_options=\"%91{%22value%22:%22Name%22,%22checked%22:0}%93\" min_length=\"0\" max_length=\"0\" allowed_symbols=\"all\" conditional_logic=\"off\" conditional_logic_relation=\"off\" conditional_logic_rules=\"%91{%22field%22:%22email%22,%22condition%22:%22is%22,%22value%22:%22%22}%93\" use_background_color_gradient=\"off\" background_color_gradient_start=\"#2b87da\" background_color_gradient_end=\"#29c4a9\" background_color_gradient_type=\"linear\" background_color_gradient_direction=\"180deg\" background_color_gradient_direction_radial=\"center\" background_color_gradient_start_position=\"0%\" background_color_gradient_end_position=\"100%\" background_color_gradient_overlays_image=\"off\" parallax=\"off\" parallax_method=\"on\" background_size=\"cover\" background_position=\"center\" background_repeat=\"no-repeat\" background_blend=\"normal\" allow_player_pause=\"off\" /][et_pb_contact_field field_title=\"Last Name\" field_type=\"input\" field_id=\"last_name\" required_mark=\"on\" fullwidth_field=\"off\" _builder_version=\"3.0.89\" checkbox_checked=\"off\" checkbox_options=\"%91{%22value%22:%22Name%22,%22checked%22:0}%93\" radio_options=\"%91{%22value%22:%22Name%22,%22checked%22:0}%93\" select_options=\"%91{%22value%22:%22Name%22,%22checked%22:0}%93\" min_length=\"0\" max_length=\"0\" allowed_symbols=\"all\" conditional_logic=\"off\" conditional_logic_relation=\"off\" conditional_logic_rules=\"%91{%22field%22:%22email%22,%22condition%22:%22is%22,%22value%22:%22%22}%93\" use_background_color_gradient=\"off\" background_color_gradient_start=\"#2b87da\" background_color_gradient_end=\"#29c4a9\" background_color_gradient_type=\"linear\" background_color_gradient_direction=\"180deg\" background_color_gradient_direction_radial=\"center\" background_color_gradient_start_position=\"0%\" background_color_gradient_end_position=\"100%\" background_color_gradient_overlays_image=\"off\" parallax=\"off\" parallax_method=\"on\" background_size=\"cover\" background_position=\"center\" background_repeat=\"no-repeat\" background_blend=\"normal\" allow_player_pause=\"off\" /][et_pb_contact_field _builder_version=\"3.0.89\" field_id=\"phone_number\" field_title=\"Phone Number\" field_type=\"input\" checkbox_checked=\"off\" checkbox_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" radio_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" select_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" min_length=\"0\" max_length=\"0\" allowed_symbols=\"all\" required_mark=\"on\" conditional_logic=\"off\" conditional_logic_relation=\"off\" conditional_logic_rules=\"%91{%22field%22:%22first_name%22,%22condition%22:%22is%22,%22value%22:%22%22}%93\" use_background_color_gradient=\"off\" background_color_gradient_start=\"#2b87da\" background_color_gradient_end=\"#29c4a9\" background_color_gradient_type=\"linear\" background_color_gradient_direction=\"180deg\" background_color_gradient_direction_radial=\"center\" background_color_gradient_start_position=\"0%\" background_color_gradient_end_position=\"100%\" background_color_gradient_overlays_image=\"off\" parallax=\"off\" parallax_method=\"on\" background_size=\"cover\" background_position=\"center\" background_repeat=\"no-repeat\" background_blend=\"normal\" allow_player_pause=\"off\" fullwidth_field=\"off\" /][et_pb_contact_field field_title=\"Email Address\" field_type=\"email\" field_id=\"email_address\" required_mark=\"on\" fullwidth_field=\"off\" _builder_version=\"3.0.89\" checkbox_checked=\"off\" checkbox_options=\"%91{%22value%22:%22Email Address%22,%22checked%22:0}%93\" radio_options=\"%91{%22value%22:%22Email Address%22,%22checked%22:0}%93\" select_options=\"%91{%22value%22:%22Email Address%22,%22checked%22:0}%93\" min_length=\"0\" max_length=\"0\" allowed_symbols=\"all\" conditional_logic=\"off\" conditional_logic_relation=\"off\" conditional_logic_rules=\"%91{%22field%22:%22first_name%22,%22condition%22:%22is%22,%22value%22:%22%22}%93\" use_background_color_gradient=\"off\" background_color_gradient_start=\"#2b87da\" background_color_gradient_end=\"#29c4a9\" background_color_gradient_type=\"linear\" background_color_gradient_direction=\"180deg\" background_color_gradient_direction_radial=\"center\" background_color_gradient_start_position=\"0%\" background_color_gradient_end_position=\"100%\" background_color_gradient_overlays_image=\"off\" parallax=\"off\" parallax_method=\"on\" background_size=\"cover\" background_position=\"center\" background_repeat=\"no-repeat\" background_blend=\"normal\" allow_player_pause=\"off\" /][et_pb_contact_field _builder_version=\"3.0.89\" field_id=\"your_location\" field_title=\"Your Location\" field_type=\"input\" checkbox_checked=\"off\" checkbox_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" radio_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" select_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" min_length=\"0\" max_length=\"0\" allowed_symbols=\"all\" required_mark=\"on\" conditional_logic=\"off\" conditional_logic_relation=\"off\" conditional_logic_rules=\"%91{%22field%22:%22first_name%22,%22condition%22:%22is%22,%22value%22:%22%22}%93\" use_background_color_gradient=\"off\" background_color_gradient_start=\"#2b87da\" background_color_gradient_end=\"#29c4a9\" background_color_gradient_type=\"linear\" background_color_gradient_direction=\"180deg\" background_color_gradient_direction_radial=\"center\" background_color_gradient_start_position=\"0%\" background_color_gradient_end_position=\"100%\" background_color_gradient_overlays_image=\"off\" parallax=\"off\" parallax_method=\"on\" background_size=\"cover\" background_position=\"center\" background_repeat=\"no-repeat\" background_blend=\"normal\" allow_player_pause=\"off\" fullwidth_field=\"on\" /][et_pb_contact_field _builder_version=\"3.0.89\" field_id=\"dogs_name\" field_title=\"Dog’s Name\" field_type=\"input\" checkbox_checked=\"off\" checkbox_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" radio_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" select_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" min_length=\"0\" max_length=\"0\" allowed_symbols=\"all\" required_mark=\"on\" conditional_logic=\"off\" conditional_logic_relation=\"off\" conditional_logic_rules=\"%91{%22field%22:%22first_name%22,%22condition%22:%22is%22,%22value%22:%22%22}%93\" use_background_color_gradient=\"off\" background_color_gradient_start=\"#2b87da\" background_color_gradient_end=\"#29c4a9\" background_color_gradient_type=\"linear\" background_color_gradient_direction=\"180deg\" background_color_gradient_direction_radial=\"center\" background_color_gradient_start_position=\"0%\" background_color_gradient_end_position=\"100%\" background_color_gradient_overlays_image=\"off\" parallax=\"off\" parallax_method=\"on\" background_size=\"cover\" background_position=\"center\" background_repeat=\"no-repeat\" background_blend=\"normal\" allow_player_pause=\"off\" fullwidth_field=\"off\" /][et_pb_contact_field _builder_version=\"3.0.89\" field_id=\"dogs_age\" field_title=\"Dog’s Age\" field_type=\"input\" checkbox_checked=\"off\" checkbox_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" radio_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" select_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" min_length=\"0\" max_length=\"0\" allowed_symbols=\"all\" required_mark=\"on\" conditional_logic=\"off\" conditional_logic_relation=\"off\" conditional_logic_rules=\"%91{%22field%22:%22first_name%22,%22condition%22:%22is%22,%22value%22:%22%22}%93\" use_background_color_gradient=\"off\" background_color_gradient_start=\"#2b87da\" background_color_gradient_end=\"#29c4a9\" background_color_gradient_type=\"linear\" background_color_gradient_direction=\"180deg\" background_color_gradient_direction_radial=\"center\" background_color_gradient_start_position=\"0%\" background_color_gradient_end_position=\"100%\" background_color_gradient_overlays_image=\"off\" parallax=\"off\" parallax_method=\"on\" background_size=\"cover\" background_position=\"center\" background_repeat=\"no-repeat\" background_blend=\"normal\" allow_player_pause=\"off\" fullwidth_field=\"off\" /][et_pb_contact_field _builder_version=\"3.0.89\" field_id=\"dogs_breed\" field_title=\"Dog’s Breed\" field_type=\"input\" checkbox_checked=\"off\" checkbox_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" radio_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" select_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" min_length=\"0\" max_length=\"0\" allowed_symbols=\"all\" required_mark=\"on\" conditional_logic=\"off\" conditional_logic_relation=\"off\" conditional_logic_rules=\"%91{%22field%22:%22first_name%22,%22condition%22:%22is%22,%22value%22:%22%22}%93\" use_background_color_gradient=\"off\" background_color_gradient_start=\"#2b87da\" background_color_gradient_end=\"#29c4a9\" background_color_gradient_type=\"linear\" background_color_gradient_direction=\"180deg\" background_color_gradient_direction_radial=\"center\" background_color_gradient_start_position=\"0%\" background_color_gradient_end_position=\"100%\" background_color_gradient_overlays_image=\"off\" parallax=\"off\" parallax_method=\"on\" background_size=\"cover\" background_position=\"center\" background_repeat=\"no-repeat\" background_blend=\"normal\" allow_player_pause=\"off\" fullwidth_field=\"off\" /][et_pb_contact_field _builder_version=\"3.0.89\" field_id=\"dogs_gender\" field_title=\"Dog’s Gender\" field_type=\"input\" checkbox_checked=\"off\" checkbox_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" radio_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" select_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" min_length=\"0\" max_length=\"0\" allowed_symbols=\"all\" required_mark=\"on\" conditional_logic=\"off\" conditional_logic_relation=\"off\" conditional_logic_rules=\"%91{%22field%22:%22first_name%22,%22condition%22:%22is%22,%22value%22:%22%22}%93\" use_background_color_gradient=\"off\" background_color_gradient_start=\"#2b87da\" background_color_gradient_end=\"#29c4a9\" background_color_gradient_type=\"linear\" background_color_gradient_direction=\"180deg\" background_color_gradient_direction_radial=\"center\" background_color_gradient_start_position=\"0%\" background_color_gradient_end_position=\"100%\" background_color_gradient_overlays_image=\"off\" parallax=\"off\" parallax_method=\"on\" background_size=\"cover\" background_position=\"center\" background_repeat=\"no-repeat\" background_blend=\"normal\" allow_player_pause=\"off\" fullwidth_field=\"off\" /][et_pb_contact_field _builder_version=\"3.0.89\" field_id=\"where_did_you_get_the_dog\" field_title=\"Where did you get the dog? (breeder, shelter etc)\" field_type=\"input\" checkbox_checked=\"off\" checkbox_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" radio_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" select_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" min_length=\"0\" max_length=\"0\" allowed_symbols=\"all\" required_mark=\"on\" conditional_logic=\"off\" conditional_logic_relation=\"off\" conditional_logic_rules=\"%91{%22field%22:%22first_name%22,%22condition%22:%22is%22,%22value%22:%22%22}%93\" use_background_color_gradient=\"off\" background_color_gradient_start=\"#2b87da\" background_color_gradient_end=\"#29c4a9\" background_color_gradient_type=\"linear\" background_color_gradient_direction=\"180deg\" background_color_gradient_direction_radial=\"center\" background_color_gradient_start_position=\"0%\" background_color_gradient_end_position=\"100%\" background_color_gradient_overlays_image=\"off\" parallax=\"off\" parallax_method=\"on\" background_size=\"cover\" background_position=\"center\" background_repeat=\"no-repeat\" background_blend=\"normal\" allow_player_pause=\"off\" fullwidth_field=\"on\" /][et_pb_contact_field _builder_version=\"3.0.89\" field_id=\"how_long_has_the_dog_been_in_your_home\" field_title=\"How long has the dog been in your home?\" field_type=\"input\" checkbox_checked=\"off\" checkbox_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" radio_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" select_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" min_length=\"0\" max_length=\"0\" allowed_symbols=\"all\" required_mark=\"on\" conditional_logic=\"off\" conditional_logic_relation=\"off\" conditional_logic_rules=\"%91{%22field%22:%22first_name%22,%22condition%22:%22is%22,%22value%22:%22%22}%93\" use_background_color_gradient=\"off\" background_color_gradient_start=\"#2b87da\" background_color_gradient_end=\"#29c4a9\" background_color_gradient_type=\"linear\" background_color_gradient_direction=\"180deg\" background_color_gradient_direction_radial=\"center\" background_color_gradient_start_position=\"0%\" background_color_gradient_end_position=\"100%\" background_color_gradient_overlays_image=\"off\" parallax=\"off\" parallax_method=\"on\" background_size=\"cover\" background_position=\"center\" background_repeat=\"no-repeat\" background_blend=\"normal\" allow_player_pause=\"off\" fullwidth_field=\"on\" /][et_pb_contact_field _builder_version=\"3.0.89\" field_id=\"how_often_is_the_dog_currently_being_left_alone\" field_title=\"How often is the dog currently being left alone? \" field_type=\"input\" checkbox_checked=\"off\" checkbox_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" radio_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" select_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" min_length=\"0\" max_length=\"0\" allowed_symbols=\"all\" required_mark=\"on\" conditional_logic=\"off\" conditional_logic_relation=\"off\" conditional_logic_rules=\"%91{%22field%22:%22first_name%22,%22condition%22:%22is%22,%22value%22:%22%22}%93\" use_background_color_gradient=\"off\" background_color_gradient_start=\"#2b87da\" background_color_gradient_end=\"#29c4a9\" background_color_gradient_type=\"linear\" background_color_gradient_direction=\"180deg\" background_color_gradient_direction_radial=\"center\" background_color_gradient_start_position=\"0%\" background_color_gradient_end_position=\"100%\" background_color_gradient_overlays_image=\"off\" parallax=\"off\" parallax_method=\"on\" background_size=\"cover\" background_position=\"center\" background_repeat=\"no-repeat\" background_blend=\"normal\" allow_player_pause=\"off\" fullwidth_field=\"on\" /][et_pb_contact_field _builder_version=\"3.0.89\" field_id=\"other_comments_about_your_dogs_home_alone_time\" field_title=\"If you have any other comments about your dog’s home alone time, please enter here. \" field_type=\"text\" checkbox_checked=\"off\" checkbox_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" radio_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" select_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" min_length=\"0\" max_length=\"0\" allowed_symbols=\"all\" required_mark=\"on\" conditional_logic=\"off\" conditional_logic_relation=\"off\" conditional_logic_rules=\"%91{%22field%22:%22first_name%22,%22condition%22:%22is%22,%22value%22:%22%22}%93\" use_background_color_gradient=\"off\" background_color_gradient_start=\"#2b87da\" background_color_gradient_end=\"#29c4a9\" background_color_gradient_type=\"linear\" background_color_gradient_direction=\"180deg\" background_color_gradient_direction_radial=\"center\" background_color_gradient_start_position=\"0%\" background_color_gradient_end_position=\"100%\" background_color_gradient_overlays_image=\"off\" parallax=\"off\" parallax_method=\"on\" background_size=\"cover\" background_position=\"center\" background_repeat=\"no-repeat\" background_blend=\"normal\" allow_player_pause=\"off\" fullwidth_field=\"on\" /][et_pb_contact_field _builder_version=\"3.0.89\" field_id=\"alter_your_schedule\" field_title=\"Can you alter your schedule so that your dog will not have to be left alone during the training period? ( Please keep in mind, dog is not considered alone when accompanied by someone, in or outside of your home, in an environment where they are comfortable.)\" field_type=\"radio\" checkbox_checked=\"off\" checkbox_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" radio_options=\"%91{%22value%22:%22Yes%22,%22checked%22:0},{%22value%22:%22No%22,%22checked%22:0},{%22value%22:%22Maybe%22,%22checked%22:0}%93\" select_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" min_length=\"0\" max_length=\"0\" allowed_symbols=\"all\" required_mark=\"on\" conditional_logic=\"off\" conditional_logic_relation=\"off\" conditional_logic_rules=\"%91{%22field%22:%22first_name%22,%22condition%22:%22is%22,%22value%22:%22%22}%93\" use_background_color_gradient=\"off\" background_color_gradient_start=\"#2b87da\" background_color_gradient_end=\"#29c4a9\" background_color_gradient_type=\"linear\" background_color_gradient_direction=\"180deg\" background_color_gradient_direction_radial=\"center\" background_color_gradient_start_position=\"0%\" background_color_gradient_end_position=\"100%\" background_color_gradient_overlays_image=\"off\" parallax=\"off\" parallax_method=\"on\" background_size=\"cover\" background_position=\"center\" background_repeat=\"no-repeat\" background_blend=\"normal\" allow_player_pause=\"off\" fullwidth_field=\"on\" /][et_pb_contact_field _builder_version=\"3.0.89\" field_id=\"any_previous_training\" field_title=\"Have you done any previous training to address your dog\'s separation anxiety?*\" field_type=\"radio\" checkbox_checked=\"off\" checkbox_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" radio_options=\"%91{%22value%22:%22Yes%22,%22checked%22:0},{%22value%22:%22No%22,%22checked%22:0}%93\" select_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" min_length=\"0\" max_length=\"0\" allowed_symbols=\"all\" required_mark=\"on\" conditional_logic=\"off\" conditional_logic_relation=\"off\" conditional_logic_rules=\"%91{%22field%22:%22first_name%22,%22condition%22:%22is%22,%22value%22:%22%22}%93\" use_background_color_gradient=\"off\" background_color_gradient_start=\"#2b87da\" background_color_gradient_end=\"#29c4a9\" background_color_gradient_type=\"linear\" background_color_gradient_direction=\"180deg\" background_color_gradient_direction_radial=\"center\" background_color_gradient_start_position=\"0%\" background_color_gradient_end_position=\"100%\" background_color_gradient_overlays_image=\"off\" parallax=\"off\" parallax_method=\"on\" background_size=\"cover\" background_position=\"center\" background_repeat=\"no-repeat\" background_blend=\"normal\" allow_player_pause=\"off\" fullwidth_field=\"on\" /][et_pb_contact_field _builder_version=\"3.0.89\" field_id=\"please_describe.\" field_title=\"Please describe.\" field_type=\"text\" checkbox_checked=\"off\" checkbox_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" radio_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" select_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" min_length=\"0\" max_length=\"0\" allowed_symbols=\"all\" required_mark=\"on\" conditional_logic=\"off\" conditional_logic_relation=\"off\" conditional_logic_rules=\"%91{%22field%22:%22first_name%22,%22condition%22:%22is%22,%22value%22:%22%22}%93\" use_background_color_gradient=\"off\" background_color_gradient_start=\"#2b87da\" background_color_gradient_end=\"#29c4a9\" background_color_gradient_type=\"linear\" background_color_gradient_direction=\"180deg\" background_color_gradient_direction_radial=\"center\" background_color_gradient_start_position=\"0%\" background_color_gradient_end_position=\"100%\" background_color_gradient_overlays_image=\"off\" parallax=\"off\" parallax_method=\"on\" background_size=\"cover\" background_position=\"center\" background_repeat=\"no-repeat\" background_blend=\"normal\" allow_player_pause=\"off\" fullwidth_field=\"on\" /][et_pb_contact_field _builder_version=\"3.0.89\" field_id=\"discussed_with_your_veterinarian\" field_title=\"Have you discussed your dog\'s separation anxiety with your veterinarian?*\" field_type=\"radio\" checkbox_checked=\"off\" checkbox_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" radio_options=\"%91{%22value%22:%22Yes%22,%22checked%22:0},{%22value%22:%22No%22,%22checked%22:0}%93\" select_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" min_length=\"0\" max_length=\"0\" allowed_symbols=\"all\" required_mark=\"on\" conditional_logic=\"off\" conditional_logic_relation=\"off\" conditional_logic_rules=\"%91{%22field%22:%22first_name%22,%22condition%22:%22is%22,%22value%22:%22%22}%93\" use_background_color_gradient=\"off\" background_color_gradient_start=\"#2b87da\" background_color_gradient_end=\"#29c4a9\" background_color_gradient_type=\"linear\" background_color_gradient_direction=\"180deg\" background_color_gradient_direction_radial=\"center\" background_color_gradient_start_position=\"0%\" background_color_gradient_end_position=\"100%\" background_color_gradient_overlays_image=\"off\" parallax=\"off\" parallax_method=\"on\" background_size=\"cover\" background_position=\"center\" background_repeat=\"no-repeat\" background_blend=\"normal\" allow_player_pause=\"off\" fullwidth_field=\"on\" /][et_pb_contact_field _builder_version=\"3.0.89\" field_id=\"explain_veterinarian\" field_title=\"If you answered \'yes\' to the above question, please explain.\" field_type=\"text\" checkbox_checked=\"off\" checkbox_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" radio_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" select_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" min_length=\"0\" max_length=\"0\" allowed_symbols=\"all\" required_mark=\"on\" conditional_logic=\"off\" conditional_logic_relation=\"off\" conditional_logic_rules=\"%91{%22field%22:%22first_name%22,%22condition%22:%22is%22,%22value%22:%22%22}%93\" use_background_color_gradient=\"off\" background_color_gradient_start=\"#2b87da\" background_color_gradient_end=\"#29c4a9\" background_color_gradient_type=\"linear\" background_color_gradient_direction=\"180deg\" background_color_gradient_direction_radial=\"center\" background_color_gradient_start_position=\"0%\" background_color_gradient_end_position=\"100%\" background_color_gradient_overlays_image=\"off\" parallax=\"off\" parallax_method=\"on\" background_size=\"cover\" background_position=\"center\" background_repeat=\"no-repeat\" background_blend=\"normal\" allow_player_pause=\"off\" fullwidth_field=\"on\" /][et_pb_contact_field _builder_version=\"3.0.89\" field_id=\"dog_alone_in_the_future\" field_title=\"How long would you like to be able to leave your dog alone in the future?*\" field_type=\"input\" checkbox_checked=\"off\" checkbox_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" radio_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" select_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" min_length=\"0\" max_length=\"0\" allowed_symbols=\"all\" required_mark=\"on\" conditional_logic=\"off\" conditional_logic_relation=\"off\" conditional_logic_rules=\"%91{%22field%22:%22first_name%22,%22condition%22:%22is%22,%22value%22:%22%22}%93\" use_background_color_gradient=\"off\" background_color_gradient_start=\"#2b87da\" background_color_gradient_end=\"#29c4a9\" background_color_gradient_type=\"linear\" background_color_gradient_direction=\"180deg\" background_color_gradient_direction_radial=\"center\" background_color_gradient_start_position=\"0%\" background_color_gradient_end_position=\"100%\" background_color_gradient_overlays_image=\"off\" parallax=\"off\" parallax_method=\"on\" background_size=\"cover\" background_position=\"center\" background_repeat=\"no-repeat\" background_blend=\"normal\" allow_player_pause=\"off\" fullwidth_field=\"on\" /][et_pb_contact_field _builder_version=\"3.0.89\" field_id=\"additional_comments\" field_title=\"If you have any additional comments regarding your dog’s future alone time, please enter those here.\" field_type=\"text\" checkbox_checked=\"off\" checkbox_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" radio_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" select_options=\"%91{%22value%22:%22%22,%22checked%22:0}%93\" min_length=\"0\" max_length=\"0\" allowed_symbols=\"all\" required_mark=\"on\" conditional_logic=\"off\" conditional_logic_relation=\"off\" conditional_logic_rules=\"%91{%22field%22:%22first_name%22,%22condition%22:%22is%22,%22value%22:%22%22}%93\" use_background_color_gradient=\"off\" background_color_gradient_start=\"#2b87da\" background_color_gradient_end=\"#29c4a9\" background_color_gradient_type=\"linear\" background_color_gradient_direction=\"180deg\" background_color_gradient_direction_radial=\"center\" background_color_gradient_start_position=\"0%\" background_color_gradient_end_position=\"100%\" background_color_gradient_overlays_image=\"off\" parallax=\"off\" parallax_method=\"on\" background_size=\"cover\" background_position=\"center\" background_repeat=\"no-repeat\" background_blend=\"normal\" allow_player_pause=\"off\" fullwidth_field=\"on\" /]\r\n\r\n[/et_pb_contact_form][/et_pb_column][/et_pb_row][/et_pb_section]', 'Sample', '', 'draft', 'closed', 'closed', '', '', '', '', '2018-01-11 11:49:01', '2018-01-11 11:49:01', '', '0', 'http://jhdogtraining.wpengine.com/?page_id=204656', '0', 'page', '', '0'),
('204659', '2', '2017-12-15 07:41:31', '0000-00-00 00:00:00', '[et_pb_section bb_built=\"1\"][et_pb_row][et_pb_column type=\"1_2\"][et_pb_text _builder_version=\"3.0.89\" background_layout=\"light\"]\n\n<p><a href=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/12/toilet-training-lh.pdf\">Download toilet training document</a></p>\n\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][/et_pb_column][/et_pb_row][/et_pb_section]', 'Resources', '', 'draft', 'closed', 'closed', '', '', '', '', '2017-12-15 07:41:31', '2017-12-15 07:41:31', '', '0', 'http://jhdogtraining.wpengine.com/?page_id=204659', '0', 'page', '', '0'),
('204660', '2', '2017-12-15 07:39:50', '2017-12-15 07:39:50', '', 'toilet training lh', '', 'inherit', 'open', 'closed', '', 'toilet-training-lh', '', '', '2017-12-15 07:39:50', '2017-12-15 07:39:50', '', '204659', 'http://jhdogtraining.wpengine.com/wp-content/uploads/2017/12/toilet-training-lh.pdf', '0', 'attachment', 'application/pdf', '0'),
('204672', '2', '2017-12-27 02:59:29', '0000-00-00 00:00:00', '', 'Helpful Stuff', '', 'draft', 'closed', 'closed', '', '', '', '', '2017-12-27 02:59:29', '2017-12-27 02:59:29', '', '0', 'https://jhdogtraining.com.au/?page_id=204672', '0', 'page', '', '0'),
('204673', '2', '2017-12-27 04:05:51', '2017-12-27 04:05:51', '[et_pb_section bb_built=\"1\" _builder_version=\"3.0.89\"][et_pb_row _builder_version=\"3.0.89\"][et_pb_column type=\"4_4\"][et_pb_text _builder_version=\"3.0.89\" background_layout=\"light\"]\r\n<p style=\"text-align: center;\"><strong>Toilet training for your new puppy</strong></p>\r\nYour new puppy is a dream-come-true. Cute as can be, funny, warm, cuddly. But with the good, comes the … not-so-good. Your gorgeous bundle of fur and fun is also pooping and peeing machine!  Toilet training is the top of most new pet-parent’s agenda, and it’s important you understand what to do from the get-go.\r\n\r\n<strong>Follow these key steps for success: </strong>\r\n<ul>\r\n 	<li><img class=\" wp-image-204674 alignright\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2017/12/puppy-siberian-toilet-300x199.jpg\" alt=\"\" width=\"259\" height=\"172\" />Puppies have small bladder capacity, so they must have frequent opportunities to go outside. If your pup is inside with you, set your alarm &amp; take him out every hour on the hour.</li>\r\n 	<li>When your puppy is outside for a toilet break, wait with him so you can reward him when he’s finished. While waiting for the puppy to do his business be as boring as possible!</li>\r\n 	<li><u>After he has finished</u>, reward with a treat &amp; lots of praise.</li>\r\n 	<li>Be patient and always go with him – even if it’s cold!</li>\r\n 	<li>Walk your puppy to the desired area so that he learns to walk there. If he finds that too hard at the beginning, carry him part the way there and let him walk the last few metres. As he gains more confidence, start to decrease the distance he is carried.</li>\r\n</ul>\r\n<strong>When will he want “to go”?</strong>\r\n<ul>\r\n 	<li>If your puppy is sniffing the ground, circling it is a sign they are about to toilet, so immediately take your pup to the toilet area.</li>\r\n 	<li>Regular breaks – take puppy outside every 1-2hrs for an 8-week old puppy. As he gets older, the time between toilet breaks can increase.</li>\r\n 	<li>After meals – regardless of how regularly he has been taken outside, always take him out after a meal. Watch for the signs, (sniffing, circling), anywhere from 5 minutes to an hour after the meal.</li>\r\n 	<li>After a nap – when your puppy wakes after a sleep, take him to the toilet area.</li>\r\n 	<li>After a play period – take puppy outside for a toilet break after a play session. He is likely to have been so engrossed in the play that he will have forgotten to think about toileting needs. And he is likely to want a sleep after play and will settle much more quickly with an empty bladder.</li>\r\n 	<li>The middle of the night wake-up call – if your puppy wakes at 5am or the middle of the night and starts to whimper, this probably means he needs a toilet break. If his cries are not answered &amp; he toilets in his sleeping area, both he &amp; you will be stressed. Worse, if puppy learns that no one listens to his cries, he may stop crying and just toilet wherever he is.</li>\r\n</ul>\r\n<strong>Accidents Happen!</strong>\r\n<ul>\r\n 	<li>Dogs are attracted to a place they have previously done their business by the residual smell, which normal detergents and cleaners do not remove. Clean up accidents using an enzymatic cleaner such as Biozet Attack or another enzymatic laundry detergent. Rinse carefully and if necessary, use a pet odour neutraliser to remove any residual smell.</li>\r\n 	<li>When your puppy has an accident, clean it up but ignore it and make a note to yourself to be more vigilant in supervising your pup in future.</li>\r\n 	<li>Never punish your pup for having an accident. The most likely consequence of being punished is that he will learn to toilet where you can’t see him, behind the sofa or under the bed. Instead, make a note to yourself to be more vigilant.</li>\r\n 	<li>Confine your puppy using baby gates or a puppy pen, so that he doesn’t have the run of the house. Remember, if you can\'t see him, you will miss the warning signs that he\'s about to toilet.</li>\r\n 	<li>Crate training is another way to confine your puppy. He will be reluctant to soil his eating &amp; sleeping area, so encouraging him to use a crate with a food bowl, sleeping mat &amp; toys will encourage him to hang on until his next outing. Be sure not to leave your puppy in his crate for longer than he is able to hold on.</li>\r\n 	<li>Excitement wees? Some little puppies lose control of their bladder &amp; urinate when excited, such as when visitors arrive. Try your best to make these occasions calm, and give your puppy a chew toy on which he can direct his excitement. Or better still, have these greetings outside where it doesn’t matter if he has an accident.</li>\r\n</ul>\r\n<strong>Remember </strong>\r\n<ul>\r\n 	<li>Your pup doesn’t toilet inside to “get back at you”, or to be naughty. It takes a while for them to put the pieces of the puzzle together, and understand that when they need to toilet, they\'re supposed to take themselves outside.</li>\r\n 	<li>And often they forget where they are and just \'do it\' because they can’t hold on!</li>\r\n 	<li>This is only a short phase in your puppy’s life – be patient, consistent, and reward him when he does the right thing.</li>\r\n 	<li>House training your puppy will ensure he can become a welcome member of your family who can happily be indoors with you.</li>\r\n 	<li>Be vigilant and NEVER USE PUNISHMENT- A very famous English trainer by the name of Dr Ian Dunbar said it best: “ If your puppy has a toilet accident inside, roll up a newspaper, hold out your hand and give yourself a smack so YOU remember to be more vigilant next time.”</li>\r\n 	<li>Hang in there, and to quote another famous person: “It won’t happen overnight, but it will happen”!</li>\r\n</ul>\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]', 'Toilet training your puppy', '', 'publish', 'open', 'open', '', 'toilet-training-your-puppy', '', '', '2017-12-27 04:05:51', '2017-12-27 04:05:51', '', '0', 'https://jhdogtraining.com.au/?p=204673', '0', 'post', '', '0'),
('204674', '2', '2017-12-27 04:03:44', '2017-12-27 04:03:44', '', 'puppy siberian toilet', '', 'inherit', 'open', 'closed', '', 'puppy-siberian-toilet', '', '', '2017-12-27 04:03:44', '2017-12-27 04:03:44', '', '204673', 'https://jhdogtraining.com.au/wp-content/uploads/2017/12/puppy-siberian-toilet.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204678', '1', '2018-01-08 21:37:55', '2018-01-08 21:37:55', '<div>[text* your-name placeholder \"Name\"]</div>\r\n<div>[email* your-email placeholder \"Email Address\"]</div>\r\n<div>[tel tel-499 placeholder \"Phone\"]</div>\r\n<div>[textarea your-message placeholder \"How can I help?\"]</div>\r\n\r\n[submit \"Send\"]\n1\nJenny Harlow - from website\n[your-name] <wordpress@jhdogtraining.com.au>\njenny@jhdogtraining.com.au\nFrom: [your-name] <[your-email]>\r\nSubject: From website\r\n\r\nMessage Body:\r\n[your-message]\r\nPhone: [tel-499]\r\n\r\n-- \r\nThis e-mail was sent from a contact form on Jenny Harlow (https://jhdogtraining.com.au)\nReply-To: [your-email]\n\n\n\n\nJenny Harlow \"[your-subject]\"\nJenny Harlow <wordpress@jhdogtraining.com.au>\n[your-email]\nMessage Body:\r\n[your-message]\r\n\r\n-- \r\nThis e-mail was sent from a contact form on Jenny Harlow (https://jhdogtraining.com.au)\nReply-To: jennyharlow@bigpond.com\n\n\n\nThank you for your message. It has been sent.\nThere was an error trying to send your message. Please try again later.\nOne or more fields have an error. Please check and try again.\nThere was an error trying to send your message. Please try again later.\nYou must accept the terms and conditions before sending your message.\nThe field is required.\nThe field is too long.\nThe field is too short.\nThe date format is incorrect.\nThe date is before the earliest one allowed.\nThe date is after the latest one allowed.\nThere was an unknown error uploading the file.\nYou are not allowed to upload files of this type.\nThe file is too big.\nThere was an error uploading the file.\nThe number format is invalid.\nThe number is smaller than the minimum allowed.\nThe number is larger than the maximum allowed.\nThe answer to the quiz is incorrect.\nYour entered code is incorrect.\nThe e-mail address entered is invalid.\nThe URL is invalid.\nThe telephone number is invalid.', 'Contact form 1', '', 'publish', 'closed', 'closed', '', 'contact-form-1', '', '', '2018-01-11 11:37:34', '2018-01-11 11:37:34', '', '0', 'https://jhdogtraining.com.au/?post_type=wpcf7_contact_form&#038;p=204678', '0', 'wpcf7_contact_form', '', '0'),
('204679', '1', '2018-01-11 11:43:57', '2018-01-11 11:43:57', '<div>[text* your-name placeholder \"First Name\"]</div>\r\n<div>[text text-879 placeholder \"Last Name\"]</div>\r\n<div>[tel tel-499 placeholder \"Phone Number\"]</div>\r\n<div>[email* your-email placeholder \"Email Address\"]</div>\r\n<div>[text location placeholder \"Your Location\"]</div>\r\n<div>[text dogs-name placeholder \"Dog\'s Name\"]</div>\r\n<div>[text dogs-age placeholder \"Dog\'s Age\"]</div>\r\n<div>[text dogs-breed placeholder \"Dog\'s Breed\"]</div>\r\n<div>[text dogs-gender placeholder \"Dog\'s Gender\"]</div>\r\n<div>[text where-is-dog-from placeholder \"Where did you get the dog? (breeder, shelter etc)\"]</div>\r\n<div>[text how-long-id-dog-with-you placeholder \"How Long has the dog been in your home?\"]</div>\r\n<div>[text how-often-is-dog-alone placeholder \"How often is the dog currently being left alone?\"]</div>\r\n<div>[textarea other-comments-dog-alone placeholder \"If you have any other comments about your dog’s home alone time, please enter here.\"]</div>\r\n<p>Can you alter your schedule so that your dog will not have to be left alone during the training period? ( Please keep in mind, dog is not considered alone when accompanied by someone, in or outside of your home, in an environment where they are comfortable.)</p>\r\n<div>[radio alter-schedule default:1 \"Yes\" \"No\" \"Maybe\"]</div>\r\n<p>Have you done any previous training to address your dog\'s separation anxiety?*</p>\r\n<div>[radio previous-training default:1 \"Yes\" \"No\"]</div>\r\n<div>[textarea describe-previous-training placeholder \"Please describe.\"]</div>\r\n<div>[radio discussed-with-veterinarian default:1 \"Yes\" \"No\" placeholder \"Have you discussed your dog\'s separation anxiety with your veterinarian?*\"]</div>\r\n<div>[textarea explain-veterinarian placeholder \"If you answered \'yes\' to the above question, please explain.\"]</div>\r\n<div>[text how-long-alone placeholder \"How long would you like to be able to leave your dog alone in the future?\"]</div>\r\n<div>[textarea additional-comments-alone placeholder \"If you have any additional comments regarding your dog’s future alone time, please enter those here.\"]</div>\r\n\r\n[submit \"Send\"]\n1\nJenny Harlow - separation anxiety assessment form\n[your-name] <wordpress@jhdogtraining.com.au>\njenny@jhdogtraining.com.au\nFrom: [your-name] <[your-email]>\r\nSubject: From website\r\n\r\nMessage Body:\r\nLast Name: [text-879]\r\nPhone: [tel-499]\r\nLocation: [location]\r\nDog\'s Name: [dogs-name]\r\nDog\'s Age: [dogs-age]\r\nDog\'s Breed: [dogs-breed]\r\nDog\'s Gender: [dogs-gender]\r\nWhere did you get the dog? - [where-is-dog-from]\r\nHow Long has the dog been in your home? - [how-long-id-dog-with-you]\r\nHow often is the dog currently being left alone? - [how-often-is-dog-alone]\r\nOther Comments: [other-comments-dog-alone]\r\nAlter Schedule: [alter-schedule]\r\nPrevious Training: [previous-training]\r\nDescribe Previous Training: [describe-previous-training]\r\nDiscussed with veterinarian: [discussed-with-veterinarian]\r\nExplain veterinarian: [explain-veterinarian]\r\nHow long would you like to be able to leave your dog alone in the future? - [how-long-alone]\r\nAdditional comments regarding your dog’s future alone time: [additional-comments-alone]\r\n\r\n-- \r\nThis e-mail was sent from a contact form on Jenny Harlow (https://jhdogtraining.com.au)\nReply-To: [your-email]\n\n\n\n\nJenny Harlow \"[your-subject]\"\nJenny Harlow <wordpress@jhdogtraining.com.au>\n[your-email]\nMessage Body:\r\n[your-message]\r\n\r\n-- \r\nThis e-mail was sent from a contact form on Jenny Harlow (https://jhdogtraining.com.au)\nReply-To: jennyharlow@bigpond.com\n\n\n\nThank you for your message. It has been sent.\nThere was an error trying to send your message. Please try again later.\nOne or more fields have an error. Please check and try again.\nThere was an error trying to send your message. Please try again later.\nYou must accept the terms and conditions before sending your message.\nThe field is required.\nThe field is too long.\nThe field is too short.\nThe date format is incorrect.\nThe date is before the earliest one allowed.\nThe date is after the latest one allowed.\nThere was an unknown error uploading the file.\nYou are not allowed to upload files of this type.\nThe file is too big.\nThere was an error uploading the file.\nThe number format is invalid.\nThe number is smaller than the minimum allowed.\nThe number is larger than the maximum allowed.\nThe answer to the quiz is incorrect.\nYour entered code is incorrect.\nThe e-mail address entered is invalid.\nThe URL is invalid.\nThe telephone number is invalid.', 'separation anxiety assessment form', '', 'publish', 'closed', 'closed', '', 'contact-form-1_copy', '', '', '2018-01-11 16:06:39', '2018-01-11 16:06:39', '', '0', 'https://jhdogtraining.com.au/?post_type=wpcf7_contact_form&#038;p=204679', '0', 'wpcf7_contact_form', '', '0'),
('204684', '1', '2018-02-07 14:20:02', '2018-02-07 14:20:02', 'input.wpcf7-form-control {\r\n    width: 100%;\r\n    padding: 16px;\r\n    border: none;\r\n    -webkit-border-radius: 0;\r\n    -moz-border-radius: 0;\r\n    border-radius: 0;\r\n    color: #999;\r\n    background-color: #eee;\r\n    font-size: 14px;\r\n    margin-bottom: 10px;\r\n}\r\n\r\ninput[type=\"submit\"].wpcf7-form-control  {\r\n    color: #1f1e86 !important;\r\n    cursor: pointer;\r\n    border:  2px solid #1f1e86;\r\n}\r\n\r\ntextarea.wpcf7-form-control {\r\n    width: 100%;\r\n    padding: 16px;\r\n    border: none;\r\n    -webkit-border-radius: 0;\r\n    -moz-border-radius: 0;\r\n    border-radius: 0;\r\n    color: #999;\r\n    background-color: #eee;\r\n    font-size: 14px;\r\n    margin-bottom: 10px;\r\n}\r\n\r\n.fwidget  {\r\n  text-align: center;  \r\nwidth: 100%;\r\n}\r\n\r\n#footer-icons {\r\n  float:none;\r\n  text-align: center;\r\n}\r\n\r\n.et-social-icon {\r\n  display: inline-block;\r\n  margin: 0 5px !important;\r\n  padding: 0 !important;\r\n}\r\n\r\n.et-social-icon:before {\r\n  display:none;\r\n}\r\n\r\n#footer-logos {\r\n  text-align: center;\r\n}\r\n\r\n#footer-logos>img{\r\n  margin: 0 5px;\r\n}\r\n\r\n#footer-info {\r\n  float: none;\r\n}\r\n\r\n#bottom-bar-text {\r\n  text-align: center;\r\n} \r\n.head_link a {\r\n    color: black;\r\n}\r\n.head_link a:hover {\r\n    color: #848484;\r\n}\r\n.force_marg .et_pb_text_inner {\r\n    margin-bottom: 30px !important;\r\n}\r\n#et-secondary-menu {\r\n    float: left;\r\n}\r\ndiv#et-secondary-menu {\r\n    width: 100%;\r\n    text-align: center;\r\n}', 'Divi-child', '', 'publish', 'closed', 'closed', '', 'divi-child', '', '', '2018-09-14 19:23:21', '2018-09-14 19:23:21', '', '0', 'https://jhdogtraining.com.au/divi-child/', '0', 'custom_css', '', '0');
/**ABDB**/INSERT INTO `wp_posts`  VALUES 
('204685', '1', '2018-02-07 14:20:03', '2018-02-07 14:20:03', '[et_pb_section fullwidth=\"on\" background_color=\"#1f0030\"][et_pb_fullwidth_header title=\"Divi Builder\" background_layout=\"dark\" text_orientation=\"center\" scroll_down_icon_color=\"#ffffff\" scroll_down_icon_size=\"36px\" content_font_color=\"rgba(255,255,255,0.85)\" max_width=\"700px\" button_one_text=\"Join Now\" button_one_url=\"Join today\" background_overlay_color=\"rgba(40,40,48,0.8)\" title_font=\"Old Standard TT|on||on|\" title_font_size=\"62px\" title_font_size_phone=\"48px\" title_font_size_last_edited=\"on|phone\" content_font=\"Raleway||||\" content_font_size=\"20px\" custom_button_one=\"on\" button_one_text_size=\"16px\" button_one_text_color=\"#ffffff\" button_one_bg_color=\"#e85929\" button_one_border_width=\"0px\" button_one_border_radius=\"2px\" button_one_letter_spacing=\"3px\" button_one_font=\"Raleway|on||on|\" button_one_use_icon=\"off\" button_one_bg_color_hover=\"rgba(232,89,41,0.85)\" button_one_letter_spacing_hover=\"2px\" custom_css_main_element=\"padding: 6% 0 12% 0;\" custom_css_header_container=\"width: 100%;\" custom_css_button_1=\"margin-top: 40px;\" background_image=\"https://cdn.elegantthemes.com/images/tour/hummus2.jpg\" header_fullscreen=\"off\" header_scroll_down=\"off\" image_orientation=\"center\" content_orientation=\"center\" button_one_icon_placement=\"right\" custom_button_two=\"off\" button_two_letter_spacing=\"0\" button_two_icon_placement=\"right\" button_two_letter_spacing_hover=\"0\"]Divi 3.0 introduces a completely new visual interface that will forever change how you build websites. This front end editor allows you to make changes to your website...on your actual website![/et_pb_fullwidth_header][/et_pb_section][et_pb_section background_color=\"#efefe8\" custom_css_main_element=\"z-index: 999;\"][et_pb_row use_custom_gutter=\"on\" gutter_width=\"1\" custom_padding=\"0px||0px|\" custom_margin=\"-100px||60px|\" make_equal=\"on\" background_color_1=\"#ffffff\" background_color_2=\"#ffffff\" bg_img_1=\"https://cdn.elegantthemes.com/images/tour/limes.jpg\" bg_img_2=\"https://cdn.elegantthemes.com/images/tour/springrolls.jpg\" bg_img_3=\"https://cdn.elegantthemes.com/images/tour/eggs.jpg\" bg_img_4=\"https://cdn.elegantthemes.com/images/tour/lemons.jpg\" background_position_1=\"bottom_center\" background_position_2=\"bottom_center\" background_position_3=\"bottom_center\" background_position_4=\"bottom_center\" background_repeat_1=\"no-repeat\" background_repeat_2=\"no-repeat\" background_repeat_3=\"no-repeat\" background_repeat_4=\"no-repeat\" custom_css_main_element=\"overflow: visible !important;||-webkit-box-shadow: 0px 4px 30px 4px rgba(0,0,0,0.08);||-moz-box-shadow: 0px 4px 30px 4px rgba(0,0,0,0.08);||box-shadow: 0px 4px 30px 4px rgba(0,0,0,0.08);\" background_position=\"top_left\" background_repeat=\"repeat\" background_size=\"initial\"][et_pb_column type=\"1_4\"][et_pb_blurb title=\"Click & type\" use_icon=\"on\" font_icon=\"%%119%%\" icon_color=\"rgba(46,48,55,0.38)\" animation=\"off\" text_orientation=\"center\" use_icon_font_size=\"on\" icon_font_size=\"32px\" header_font=\"Raleway|on||on|\" header_font_size=\"20\" header_text_color=\"#3a3e59\" body_font_size=\"16px\" body_text_color=\"rgba(46,48,55,0.5)\" body_line_height=\"1.8em\" use_background_color_gradient=\"on\" background_color_gradient_start=\"#ffffff\" background_color_gradient_end=\"rgba(255,255,255,0)\" custom_padding=\"40px|24px|140%|24px\" custom_css_blurb_title=\"margin-bottom: 10px;\" saved_tabs=\"all\" background_position=\"top_left\" background_repeat=\"repeat\" background_size=\"initial\"]<p>Lorem ipsum dolor sit amet consectetur adipiscing elit el vivamus eu vehicula.</p>[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_blurb title=\"Drag & Drop\" use_icon=\"on\" font_icon=\"%%372%%\" icon_color=\"rgba(46,48,55,0.38)\" animation=\"off\" text_orientation=\"center\" use_icon_font_size=\"on\" icon_font_size=\"32px\" header_font=\"Raleway|on||on|\" header_font_size=\"20\" header_text_color=\"#3a3e59\" body_font_size=\"16px\" body_text_color=\"rgba(46,48,55,0.5)\" body_line_height=\"1.8em\" use_background_color_gradient=\"on\" background_color_gradient_start=\"#e4e4e4\" background_color_gradient_end=\"rgba(228,228,228,0)\" background_color_gradient_start_position=\"30%\" background_color_gradient_end_position=\"90%\" custom_padding=\"40px|24px|140%|24px\" custom_css_blurb_title=\"margin-bottom: 10px;\" saved_tabs=\"all\" background_position=\"top_left\" background_repeat=\"repeat\" background_size=\"initial\"]<p>Lorem ipsum dolor sit amet consectetur adipiscing elit el vivamus eu vehicula.</p>[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_blurb title=\"Fully Customize\" use_icon=\"on\" font_icon=\"%%70%%\" icon_color=\"rgba(46,48,55,0.38)\" animation=\"off\" text_orientation=\"center\" use_icon_font_size=\"on\" icon_font_size=\"32px\" header_font=\"Raleway|on||on|\" header_font_size=\"20\" header_text_color=\"#3a3e59\" body_font_size=\"16px\" body_text_color=\"rgba(46,48,55,0.5)\" body_line_height=\"1.8em\" use_background_color_gradient=\"on\" background_color_gradient_start=\"#efefef\" background_color_gradient_end=\"rgba(239,239,239,0)\" background_color_gradient_start_position=\"30%\" background_color_gradient_end_position=\"90%\" custom_padding=\"40px|24px|140%|24px\" custom_css_blurb_title=\"margin-bottom: 10px;\" saved_tabs=\"all\" background_position=\"top_left\" background_repeat=\"repeat\" background_size=\"initial\"]<p>Lorem ipsum dolor sit amet consectetur adipiscing elit el vivamus eu vehicula.</p>[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_4\"][et_pb_blurb title=\"Clone & Delete\" use_icon=\"on\" font_icon=\"%%100%%\" icon_color=\"rgba(46,48,55,0.38)\" animation=\"off\" text_orientation=\"center\" use_icon_font_size=\"on\" icon_font_size=\"32px\" header_font=\"Raleway|on||on|\" header_font_size=\"20\" header_text_color=\"#3a3e59\" body_font_size=\"16px\" body_text_color=\"rgba(46,48,55,0.5)\" body_line_height=\"1.8em\" use_background_color_gradient=\"on\" background_color_gradient_start=\"#d7d9d9\" background_color_gradient_end=\"rgba(215,217,217,0)\" background_color_gradient_start_position=\"30%\" background_color_gradient_end_position=\"90%\" custom_padding=\"40px|24px|140%|24px\" custom_css_blurb_title=\"margin-bottom: 10px;\" saved_tabs=\"all\" background_position=\"top_left\" background_repeat=\"repeat\" background_size=\"initial\"]<p>Lorem ipsum dolor sit amet consectetur adipiscing elit el vivamus eu vehicula.</p>[/et_pb_blurb][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fullwidth=\"off\" specialty=\"off\" custom_padding=\"0px|||\" background_color=\"#efefe8\"][et_pb_row custom_margin=\"|||\" padding_top_1=\"10%\" background_position_1=\"top_left\" background_position_2=\"top_left\" background_repeat_1=\"no-repeat\" background_repeat_2=\"no-repeat\" background_position=\"top_left\" background_repeat=\"repeat\" background_size=\"initial\"][et_pb_column type=\"1_2\"][et_pb_blurb title=\"So simple!\" animation=\"off\" text_orientation=\"right\" header_font=\"Raleway|on||on|\" header_font_size=\"36px\" header_text_color=\"#3a3e59\" custom_css_main_element=\"max-width: none;\" background_position=\"top_left\" background_repeat=\"repeat\" background_size=\"initial\"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse tempus sed odio non blandit. Ut varius purus eget erat ornare facilisis. Mauris pharetra lacus nec sapien iaculis, sit amet ullamcorper sapien finibus.[/et_pb_blurb][et_pb_button button_text=\"Learn more\" button_alignment=\"right\" background_layout=\"dark\" disabled_on=\"on|on|\" custom_button=\"on\" button_text_size=\"16px\" button_text_color=\"#ffffff\" button_bg_color=\"#e85929\" button_border_width=\"0px\" button_border_radius=\"3px\" button_letter_spacing=\"3px\" button_font=\"Raleway|on||on|\" button_use_icon=\"off\" button_bg_color_hover=\"#e84712\" button_letter_spacing_hover=\"2px\" background_color=\"#7EBEC5\" /][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_image src=\"https://cdn.elegantthemes.com/images/tour/jar.jpg\" align=\"center\" max_width=\"510px\" /][/et_pb_column][/et_pb_row][et_pb_row custom_margin=\"|||\" make_equal=\"on\" padding_top_2=\"14%\" background_position_1=\"top_left\" background_position_2=\"top_left\" background_repeat_1=\"no-repeat\" background_repeat_2=\"no-repeat\" background_position=\"top_left\" background_repeat=\"repeat\" background_size=\"initial\"][et_pb_column type=\"1_2\"][et_pb_image src=\"https://cdn.elegantthemes.com/images/tour/cake.jpg\" animation=\"right\" align=\"center\" max_width=\"510px\" /][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_blurb title=\"So sweet!\" animation=\"off\" header_font=\"Raleway|on||on|\" header_font_size=\"36px\" header_text_color=\"#3a3e59\" custom_css_main_element=\"max-width: none;\" background_position=\"top_left\" background_repeat=\"repeat\" background_size=\"initial\"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse tempus sed odio non blandit. Ut varius purus eget erat ornare facilisis. Mauris pharetra lacus nec sapien iaculis, sit amet ullamcorper sapien finibus.[/et_pb_blurb][et_pb_button button_text=\"Learn more\" button_alignment=\"left\" background_layout=\"dark\" disabled_on=\"on|on|\" custom_button=\"on\" button_text_size=\"16px\" button_text_color=\"#ffffff\" button_bg_color=\"#e85929\" button_border_width=\"0px\" button_border_radius=\"2px\" button_letter_spacing=\"3px\" button_font=\"Raleway|on||on|\" button_use_icon=\"off\" button_bg_color_hover=\"#e84712\" button_letter_spacing_hover=\"2px\" background_color=\"#7EBEC5\" /][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section background_color=\"#212127\" custom_padding=\"|||\" fullwidth=\"on\"][et_pb_fullwidth_header title=\"Perfectly Diverse\" background_layout=\"dark\" text_orientation=\"center\" scroll_down_icon_color=\"#ffffff\" scroll_down_icon_size=\"36px\" content_font_color=\"rgba(255,255,255,0.72)\" button_one_text=\"Download\" background_overlay_color=\"rgba(255,255,255,0)\" title_font=\"Old Standard TT|on||on|\" title_font_size=\"62px\" title_font_size_tablet=\"62px\" title_font_size_phone=\"48px\" title_font_size_last_edited=\"on|phone\" content_font=\"Raleway||||\" content_font_size=\"20px\" content_text_color=\"#ffffff\" custom_button_one=\"on\" button_one_text_size=\"16px\" button_one_text_color=\"#ffffff\" button_one_bg_color=\"#e85929\" button_one_border_width=\"0px\" button_one_border_radius=\"2px\" button_one_letter_spacing=\"3px\" button_one_font=\"Raleway|on||on|\" button_one_use_icon=\"off\" button_one_bg_color_hover=\"rgba(232,89,41,0.85)\" button_one_letter_spacing_hover=\"2px\" custom_css_main_element=\"padding: 6% 0;\" custom_css_header_container=\"width: 100%;\" custom_css_button_1=\"margin-top: 40px;\"]<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer vel mollis eros. Vestibulum in blandit massa. Nunc lorem lacus, lacinia ut lobortis id, tempor a sem. Vivamus rhoncus imperdiet quam quis vestibulum. Sed at dui orci. </p>[/et_pb_fullwidth_header][/et_pb_section][et_pb_section fullwidth=\"on\"][et_pb_fullwidth_image src=\"https://cdn.elegantthemes.com/images/tour/cheese.jpg\" animation=\"off\" /][/et_pb_section]', 'Divi Builder Demo', '', 'publish', 'closed', 'closed', '', 'divi-builder-demo', '', '', '2018-02-07 14:20:03', '2018-02-07 14:20:03', '', '0', 'https://jhdogtraining.com.au/et_pb_layout/divi-builder-demo/', '0', 'et_pb_layout', '', '0'),
('204726', '2', '2018-05-06 00:00:05', '2018-05-06 00:00:05', '', 'iwp_log_5aef1f965aa87', '', 'publish', 'closed', 'closed', '', 'iwp_log_5aef1f965aa87', '', '', '2018-05-06 00:00:05', '2018-05-06 00:00:05', '', '0', 'https://jhdogtraining.com.au/iwp_log_5aef1f965aa87/', '0', 'iwp_log', '', '0'),
('204727', '2', '2018-05-08 07:53:09', '2018-05-08 07:53:09', '', 'iwp_log_5af1f53074f54', '', 'publish', 'closed', 'closed', '', 'iwp_log_5af1f53074f54', '', '', '2018-05-08 07:53:09', '2018-05-08 07:53:09', '', '0', 'https://jhdogtraining.com.au/iwp_log_5af1f53074f54/', '0', 'iwp_log', '', '0'),
('204728', '2', '2018-05-08 20:43:20', '2018-05-08 20:43:20', '', 'iwp_log_5af20be87efb8', '', 'publish', 'closed', 'closed', '', 'iwp_log_5af20be87efb8', '', '', '2018-05-08 20:43:20', '2018-05-08 20:43:20', '', '0', 'https://jhdogtraining.com.au/iwp_log_5af20be87efb8/', '0', 'iwp_log', '', '0'),
('204729', '2', '2018-05-13 00:00:04', '2018-05-13 00:00:04', '', 'iwp_log_5af81d9e5e234', '', 'publish', 'closed', 'closed', '', 'iwp_log_5af81d9e5e234', '', '', '2018-05-13 00:00:04', '2018-05-13 00:00:04', '', '0', 'https://jhdogtraining.com.au/iwp_log_5af81d9e5e234/', '0', 'iwp_log', '', '0'),
('204730', '2', '2018-05-20 00:05:03', '2018-05-20 00:05:03', '', 'iwp_log_5b01922d3307c', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b01922d3307c', '', '', '2018-05-20 00:05:03', '2018-05-20 00:05:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b01922d3307c/', '0', 'iwp_log', '', '0'),
('204734', '2', '2018-05-23 04:04:54', '2018-05-23 04:04:54', '<p style=\"text-align: center;\"><strong>Why does my dog have separation anxiety?</strong></p>\r\nWhy does my dog whine and cry when I leave? Is she mad at me?\r\n\r\nI always come back, so why does my dog not know this?\r\n\r\nMy dog cries and chews up the hall rug when I go out. Why?\r\n\r\nMy dog is so unhappy when I leave and I feel so, so guilty – am I a bad doggy parent?\r\n\r\nMy neighbour left a note saying my dog howls, whines and cries when I leave. Why is my dog so upset when I’m not there?\r\n\r\n<img class=\" wp-image-204609 aligncenter\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2017/11/TOP-IMAGE_o-3-300x200.jpg\" alt=\"\" width=\"261\" height=\"174\" />\r\n\r\nIf you have a dog that suffers from separation anxiety, you might feel guilty and stressed at the sight of your dog experiencing so much stress.\r\n\r\nAnd you want to know why.  Why my dog?\r\n\r\nThere can be a range of reasons why some dogs struggle when left alone.\r\n\r\nDogs that have experience multiple home-life changes, including a person leaving or arriving, change of home location, or when adopted to a new home can experience anxiety left alone.\r\n\r\nA dog that is accustomed to be being left alone with another dog, may struggle if that dog is no longer present.\r\n\r\nThe start of noisy building construction in close proximity can add to the stress a dog feels when left alone.\r\n\r\nAny one, or combination of these events, may herald the starting point for a dog to be unable to cope when left home alone. But sometimes, there is no clear indication of why a dog develops separation anxiety.\r\n\r\nIt’s important to remember however, that your dog isn’t mad at you, nor is your dog trying to “get back at you” for leaving.\r\n\r\nThe reason your dog barks or whines or destroys furniture when you leave them, is because he experiences a <strong>panic</strong> <strong>response</strong> when left alone. A response he cannot control.\r\n\r\nThe good news is, you are not alone and help is available. Learn how <strong>your dog</strong> can learn to be alone, so you and your dog can be less stressed! Click<a href=\"https://jhdogtraining.com.au/separation-anxiety/\"> here</a>.', 'Why does my dog have separation anxiety', '', 'publish', 'closed', 'closed', '', 'why-does-my-dog-have-separation-anxiety', '', '', '2018-05-23 04:05:29', '2018-05-23 04:05:29', '', '0', 'https://jhdogtraining.com.au/?page_id=204734', '0', 'page', '', '0'),
('204736', '2', '2018-05-23 04:11:32', '2018-05-23 04:11:32', 'Why does my dog whine and cry when I leave? Is she mad at me?\r\n\r\nI always come back, so why does my dog not know this?\r\n\r\nMy dog cries and chews up the hall rug when I go out. Why?\r\n\r\nMy dog is so unhappy when I leave and I feel so, so guilty – am I a bad doggy parent?\r\n\r\nMy neighbour left a note saying my dog howls, whines and cries when I leave. Why is my dog so upset when I’m not there?\r\n\r\n<img class=\"size-medium wp-image-204610 aligncenter\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2017/11/TOP-IMAGE_159644971-300x200.jpg\" alt=\"\" width=\"300\" height=\"200\" />\r\n\r\n&nbsp;\r\n\r\nIf you have a dog that suffers from separation anxiety, you might feel guilty and stressed when you see your dog experiencing so much stress.\r\n\r\nAnd you want to know why.  Why my dog?\r\n\r\nThere can be a range of reasons why some dogs struggle when left alone.\r\n\r\nDogs that have experienced multiple home-life changes, including a person leaving or arriving, a change of home location, or when adopted to a new home; these scenarios can make a dog susceptible to experiencing separation anxiety.\r\n\r\nA dog that is accustomed to be being left alone with another dog, may struggle if that dog is no longer present.\r\n\r\nThe start of noisy building construction in close proximity can add to the stress a dog feels when left alone.\r\n\r\nAny one, or combination of these may herald the starting point for a dog to be unable to cope when left home alone. But sometimes, there is no clear indication of why a dog develops separation anxiety.\r\n\r\nIt’s important to remember however, that your dog isn’t mad at you, nor is your dog trying to “get back at you” for leaving.\r\n\r\nThe reason your dog barks or whines or destroys furniture when you leave them, is because he experiences a <strong>panic</strong> response when left alone. A response he cannot control.\r\n\r\nThe good news is, you are not alone and help is available. If you would like to learn more, click <a href=\"https://jhdogtraining.com.au/separation-anxiety/\">here.</a>', 'Why does my dog have separation anxiety?', '', 'publish', 'open', 'open', '', 'why-does-my-dog-have-separation-anxiety', '', '', '2018-05-25 05:24:52', '2018-05-25 05:24:52', '', '0', 'https://jhdogtraining.com.au/?p=204736', '0', 'post', '', '0'),
('204740', '2', '2018-05-27 00:05:04', '2018-05-27 00:05:04', '', 'iwp_log_5b0a946724628', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b0a946724628', '', '', '2018-05-27 00:05:04', '2018-05-27 00:05:04', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b0a946724628/', '0', 'iwp_log', '', '0'),
('204741', '2', '2018-05-27 00:05:04', '2018-05-27 00:05:04', '', 'iwp_log_5b0a94672bd44', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b0a94672bd44', '', '', '2018-05-27 00:05:04', '2018-05-27 00:05:04', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b0a94672bd44/', '0', 'iwp_log', '', '0'),
('204742', '2', '2018-05-27 23:17:39', '2018-05-27 23:17:39', '', 'iwp_log_5b0b3c93a97c0', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b0b3c93a97c0', '', '', '2018-05-27 23:17:39', '2018-05-27 23:17:39', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b0b3c93a97c0/', '0', 'iwp_log', '', '0'),
('204743', '2', '2018-05-27 23:18:59', '2018-05-27 23:18:59', '', 'iwp_log_5b0b3ce3ac4f2', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b0b3ce3ac4f2', '', '', '2018-05-27 23:18:59', '2018-05-27 23:18:59', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b0b3ce3ac4f2/', '0', 'iwp_log', '', '0'),
('204744', '2', '2018-05-27 23:18:59', '2018-05-27 23:18:59', '', 'iwp_log_5b0b3ce3b3c46', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b0b3ce3b3c46', '', '', '2018-05-27 23:18:59', '2018-05-27 23:18:59', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b0b3ce3b3c46/', '0', 'iwp_log', '', '0'),
('204745', '2', '2018-05-27 23:19:27', '2018-05-27 23:19:27', '', 'iwp_log_5b0b3cff77a4b', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b0b3cff77a4b', '', '', '2018-05-27 23:19:27', '2018-05-27 23:19:27', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b0b3cff77a4b/', '0', 'iwp_log', '', '0'),
('204746', '2', '2018-06-03 00:00:03', '2018-06-03 00:00:03', '', 'iwp_log_5b13cd47f2a24', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b13cd47f2a24', '', '', '2018-06-03 00:00:03', '2018-06-03 00:00:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b13cd47f2a24/', '0', 'iwp_log', '', '0'),
('204747', '2', '2018-06-08 05:05:12', '2018-06-08 05:05:12', '', 'iwp_log_5b1aacd99451d', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b1aacd99451d', '', '', '2018-06-08 05:05:12', '2018-06-08 05:05:12', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b1aacd99451d/', '0', 'iwp_log', '', '0'),
('204749', '2', '2018-06-08 08:01:37', '2018-06-08 08:01:37', '', 'iwp_log_5b1ad29fc7497', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b1ad29fc7497', '', '', '2018-06-08 08:01:37', '2018-06-08 08:01:37', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b1ad29fc7497/', '0', 'iwp_log', '', '0'),
('204750', '2', '2018-06-08 19:23:40', '2018-06-08 19:23:40', '', 'iwp_log_5b1ad7bc86eaa', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b1ad7bc86eaa', '', '', '2018-06-08 19:23:40', '2018-06-08 19:23:40', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b1ad7bc86eaa/', '0', 'iwp_log', '', '0'),
('204751', '2', '2018-06-10 00:00:04', '2018-06-10 00:00:04', '', 'iwp_log_5b1d4b06a7d74', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b1d4b06a7d74', '', '', '2018-06-10 00:00:04', '2018-06-10 00:00:04', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b1d4b06a7d74/', '0', 'iwp_log', '', '0'),
('204752', '2', '2018-06-11 05:25:05', '2018-06-11 05:25:05', 'Does your puppy cry when you leave the house?\r\n\r\nHave you arrived home to find your dog has spread your kitchen garbage all over the place?\r\n\r\nHave you received a note from your neighbour saying your dog howls when you\'re out?\r\n\r\n<img class=\"size-medium wp-image-204754 alignleft\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2018/06/bc-puppy-in-rubbish-bin-300x201.jpg\" alt=\"\" width=\"300\" height=\"201\" />\r\n\r\n&nbsp;\r\n\r\nDo you know if they are symptoms of separation anxiety or signs of something else? If your dog is not settled and calm when left alone, it can be hard to know what is going on, and hard to know what to do.\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\nMany young dogs might think playing with kitchen garbage was the best fun ever! A young active dog that gets little exercise might resort to constant barking when alone, just because he’s bored. A puppy that cries when alone might not have been shown some simple puppy ‘home alone’ training steps.\r\n\r\n&nbsp;\r\n\r\n<img class=\"size-medium wp-image-204753 alignleft\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2018/06/dog-howling-300x200.jpg\" alt=\"\" width=\"300\" height=\"200\" />But destructive behaviour, crying &amp; barking can also be outward signs your dog is suffering panic and anxiety when you leave them home alone.\r\n\r\nIt’s important to sort through the different outward signs, to get to the ‘bottom-line’, so you know whether that garbage spree is just puppy shenanigans, or if it’s a more serious issue and your dog is experiencing panic.\r\n\r\n&nbsp;\r\n\r\nBy working through these questions with a trainer who knows the difference, you and your dog will be on the right path towards a life of less stress in no time!\r\n\r\nAs both a Certified Separation Anxiety Trainer (CSAT) and a Delta qualified positive reinforcement trainer, Jenny can help you and your dog.\r\n\r\nTo start the conversation, <a href=\"https://jhdogtraining.com.au/contact/\">click here</a>.  Remember … the sooner you get on to a problem, the sooner it’ll be fixed!', 'Does my dog have separation anxiety?', '', 'publish', 'closed', 'closed', '', 'does-my-dog-have-separation-anxiety', '', '', '2018-06-11 05:25:15', '2018-06-11 05:25:15', '', '0', 'https://jhdogtraining.com.au/?page_id=204752', '0', 'page', '', '0'),
('204753', '2', '2018-06-11 05:09:37', '2018-06-11 05:09:37', '', 'dog howling', '', 'inherit', 'open', 'closed', '', 'dog-howling', '', '', '2018-06-11 05:09:37', '2018-06-11 05:09:37', '', '204752', 'https://jhdogtraining.com.au/wp-content/uploads/2018/06/dog-howling.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204754', '2', '2018-06-11 05:10:27', '2018-06-11 05:10:27', '', 'bc puppy in rubbish bin', '', 'inherit', 'open', 'closed', '', 'bc-puppy-in-rubbish-bin', '', '', '2018-06-11 05:10:27', '2018-06-11 05:10:27', '', '204752', 'https://jhdogtraining.com.au/wp-content/uploads/2018/06/bc-puppy-in-rubbish-bin.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204755', '2', '2018-06-11 05:11:30', '2018-06-11 05:11:30', '', 'puppy in garbage bin', '', 'inherit', 'open', 'closed', '', 'puppy-in-garbage-bin', '', '', '2018-06-11 05:11:30', '2018-06-11 05:11:30', '', '204752', 'https://jhdogtraining.com.au/wp-content/uploads/2018/06/puppy-in-garbage-bin.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204756', '2', '2018-06-11 05:28:27', '0000-00-00 00:00:00', '', 'Is my dog suffering from separation anxiety?', '', 'draft', 'closed', 'closed', '', '', '', '', '2018-06-11 05:28:27', '2018-06-11 05:28:27', '', '0', 'https://jhdogtraining.com.au/?page_id=204756', '0', 'page', '', '0'),
('204757', '2', '2018-06-11 05:41:18', '2018-06-11 05:41:18', 'Does your puppy cry when you leave the house…?\r\n\r\nHave you arrived home to find your dog has spread the contents of the kitchen bin all over the place?\r\n\r\nHave you received a note from your neighbour saying your dog barks all day when you’re out?\r\n\r\n<img class=\"size-medium wp-image-204754 alignleft\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2018/06/bc-puppy-in-rubbish-bin-300x201.jpg\" alt=\"\" width=\"300\" height=\"201\" />\r\n\r\nMany young dogs would think playing with kitchen garbage was the best fun ever! A young active dog that gets little exercise might resort to constant barking when alone, just because he’s bored. A puppy that cries when left might never have been shown some simple puppy ‘home alone’ training steps.\r\n\r\n&nbsp;\r\n<p style=\"text-align: left;\"><img class=\"size-medium wp-image-204753 alignright\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2018/06/dog-howling-300x200.jpg\" alt=\"\" width=\"300\" height=\"200\" />                                                                                                                                                            Do you know if they are symptoms of separation anxiety or signs of something else? Destructive behaviour, crying &amp; barking can be outward signs your dog is suffering panic and anxiety when you leave them home alone.</p>\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\nIf your dog is not settled and calm when left alone, it can be hard to know what is going on, and hard to know what to do.  It’s important to sort through the different outward signs, to get to the ‘bottom-line’, so you know whether that garbage spree is just puppy shenanigans, or if it’s a more serious issue and your dog is experiencing panic.\r\n\r\nBy working through these questions with a trainer who knows the difference, you and your dog will be on the right path towards a life of less stress in no time!\r\n\r\nAs both a Certified Separation Anxiety Trainer (CSAT) and a Delta qualified positive reinforcement trainer, Jenny can help you and your dog, whether the problem is \"shenanigans\" or separation problems.\r\n\r\nTo start the conversation,<a href=\"https://jhdogtraining.com.au/contact/\"> click here</a>.  Remember … the sooner you get on to it, the sooner it’ll be fixed!', 'Does my dog have separation anxiety?', '', 'publish', 'closed', 'closed', '', 'does-my-dog-have-separation-anxiety-2', '', '', '2018-06-11 05:41:29', '2018-06-11 05:41:29', '', '0', 'https://jhdogtraining.com.au/?page_id=204757', '0', 'page', '', '0'),
('204758', '2', '2018-06-11 05:50:47', '2018-06-11 05:50:47', 'Does your puppy cry when you leave the house…?\r\n\r\nHave you arrived home to find your dog has spread the contents of the kitchen bin all over the place?\r\n\r\nHave you received a note from your neighbour saying your dog barks all day when you’re out?\r\n\r\n<img class=\"size-medium wp-image-204754 alignleft\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2018/06/bc-puppy-in-rubbish-bin-300x201.jpg\" alt=\"\" width=\"300\" height=\"201\" />\r\n\r\nMany young dogs would think playing with kitchen garbage was the best fun ever! A young active dog that gets little exercise might resort to constant barking when alone, just because he’s bored. A puppy that cries when left might never have been shown some simple puppy ‘home alone’ training steps.\r\n\r\n&nbsp;\r\n<p style=\"text-align: center;\">It can be hard to know what is going on, and hard to know what to do.</p>\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n<img class=\"size-medium wp-image-204753 alignright\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2018/06/dog-howling-300x200.jpg\" alt=\"\" width=\"300\" height=\"200\" />\r\n\r\nAre these are symptoms of separation issues or signs of something else? Destructive behaviour, crying &amp; barking can also be outward signs your dog is suffering panic and anxiety when you leave them home alone.\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\nIt’s important to sort through the different outward signs, to get to the ‘bottom-line’, so you know whether that garbage spree is just puppy shenanigans, or if it’s a more serious issue and your dog is experiencing panic.\r\n\r\n&nbsp;\r\n\r\nBy working through these questions with a trainer who knows the difference, you and your dog will be on the right path towards a life of less stress in no time!\r\n\r\n&nbsp;\r\n\r\nAs both a Certified Separation Anxiety Trainer (CSAT) and a Delta qualified positive reinforcement trainer, Jenny can help you and your dog.\r\n\r\n&nbsp;\r\n\r\nTo start the conversation, <a href=\"https://jhdogtraining.com.au/separation-anxiety/\">click here.  </a>Remember … the sooner you get on to it, the sooner it’ll be fixed!\r\n\r\n&nbsp;\r\n\r\n&nbsp;', 'Does my dog have separation anxiety?', '', 'publish', 'open', 'open', '', 'does-my-dog-have-separation-anxiety', '', '', '2019-03-07 01:11:50', '2019-03-07 01:11:50', '', '0', 'https://jhdogtraining.com.au/?p=204758', '0', 'post', '', '0'),
('204759', '2', '2018-06-17 00:00:03', '2018-06-17 00:00:03', '', 'iwp_log_5b2685a0a28f3', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b2685a0a28f3', '', '', '2018-06-17 00:00:03', '2018-06-17 00:00:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b2685a0a28f3/', '0', 'iwp_log', '', '0'),
('204760', '2', '2018-06-24 00:05:03', '2018-06-24 00:05:03', '', 'iwp_log_5b2fba30c5a2b', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b2fba30c5a2b', '', '', '2018-06-24 00:05:03', '2018-06-24 00:05:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b2fba30c5a2b/', '0', 'iwp_log', '', '0'),
('204761', '2', '2018-06-25 10:47:46', '2018-06-25 10:47:46', '', 'iwp_log_5b31767b4fbfb', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b31767b4fbfb', '', '', '2018-06-25 10:47:46', '2018-06-25 10:47:46', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b31767b4fbfb/', '0', 'iwp_log', '', '0'),
('204762', '2', '2018-07-01 00:05:03', '2018-07-01 00:05:03', '', 'iwp_log_5b38f126cdab7', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b38f126cdab7', '', '', '2018-07-01 00:05:03', '2018-07-01 00:05:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b38f126cdab7/', '0', 'iwp_log', '', '0'),
('204763', '2', '2018-07-03 05:44:47', '2018-07-03 05:44:47', '', 'iwp_log_5b3baaf044e12', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b3baaf044e12', '', '', '2018-07-03 05:44:47', '2018-07-03 05:44:47', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b3baaf044e12/', '0', 'iwp_log', '', '0'),
('204765', '2', '2018-07-04 15:38:47', '2018-07-04 15:38:47', '', 'iwp_log_5b3cea0740ed6', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b3cea0740ed6', '', '', '2018-07-04 15:38:47', '2018-07-04 15:38:47', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b3cea0740ed6/', '0', 'iwp_log', '', '0'),
('204766', '2', '2018-07-08 00:00:03', '2018-07-08 00:00:03', '', 'iwp_log_5b422e1bd8b99', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b422e1bd8b99', '', '', '2018-07-08 00:00:03', '2018-07-08 00:00:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b422e1bd8b99/', '0', 'iwp_log', '', '0'),
('204767', '2', '2018-07-15 00:05:02', '2018-07-15 00:05:02', '', 'iwp_log_5b4b69c802a2c', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b4b69c802a2c', '', '', '2018-07-15 00:05:02', '2018-07-15 00:05:02', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b4b69c802a2c/', '0', 'iwp_log', '', '0'),
('204768', '2', '2018-07-22 00:05:03', '2018-07-22 00:05:03', '', 'iwp_log_5b54b23ad0c0e', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b54b23ad0c0e', '', '', '2018-07-22 00:05:03', '2018-07-22 00:05:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b54b23ad0c0e/', '0', 'iwp_log', '', '0'),
('204769', '2', '2018-07-29 00:05:02', '2018-07-29 00:05:02', '', 'iwp_log_5b5dedec01519', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b5dedec01519', '', '', '2018-07-29 00:05:02', '2018-07-29 00:05:02', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b5dedec01519/', '0', 'iwp_log', '', '0'),
('204771', '2', '2018-08-01 04:49:36', '2018-08-01 04:49:36', '<img class=\"size-medium wp-image-204772 alignleft\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2018/08/orchids-dogs-300x225.jpg\" alt=\"\" width=\"300\" height=\"225\" />\r\n<p style=\"text-align: center;\"><strong>ORCHIDS AND DOG TRAINING</strong></p>\r\nHow gorgeous is my orchid! For years, and I mean “years”, I’ve worked at, loved and encouraged an array of different orchids in the hope of seeing a beautiful flower. I’ve fertilised, watered, changed their position for better light, all in the name of that elusive flower.\r\n\r\nI asked anyone who had an orchid that flowered – how did you do that? How did you get success? I looked up on the www, I checked magazines for tips. And guess what? They all died! Every single plant died. The leaves went yellow, or sometimes they grew lots of leaves and then died, but no flowers. Ever.\r\n\r\nI swore I’d never waste another cent on buying more orchids. Until one day I was at a small nursery and they had this gorgeous orchid, in flower, plus it was “on special”. Who doesn’t love a bargain? So I bought it. One last try, I reasoned.\r\n\r\nBefore I paid, I told the attendant my sorry tale of orchid-woe. All the things I’d tried, and all the times I’d failed. And she gave me three tips. Do these things, she said, and just wait.\r\n\r\nI did, I followed her advice and now for the first time I have an orchid flower which I’ve grown. I’m thrilled, it’s so beautiful, I can’t stop looking at it!\r\n\r\nSo what does this have to do with dog training, I hear you say?\r\n\r\nWell it reminds of things my clients tell me. “My neighbour has an [insert dog breed], and she said [insert instruction]”. Or, I saw online that I should…. I watched a TV show that said … someone at the dog park told me … and on it goes. But they come to me because, despite all the well-meaning advice and things they’ve tried, they still have a problem. They are struggling to reach their goal with their dog.\r\n\r\nThis was me with the orchid – looking everywhere for help, listening to anyone with an opinion. But I had never asked a trained person who could advise me about my situation, the particular kind of orchid I had, the particular conditions in my garden, the time of year for moving the plant to my garden.\r\n\r\nI achieved success when I asked the right person, the person who knows, and whose job it is to assist clients with their individual needs.\r\n\r\nYou might have noticed I haven’t included the three tips the nursery attendant gave me. One flower stalk, no matter how beautiful, does not make me an orchid expert and I don’t want to waste your time with poor advice about orchids.\r\n\r\nIf you need advice about your dog, ask <strong>trained</strong> trainer.\r\n\r\nI can’t help you with your orchids, but I can help you with advice about your dog! It’s my job and I love it, so if you have a question about your dog, head over <a href=\"https://jhdogtraining.com.au/contact/\">here.</a>', 'Dog Training & Orchids', '', 'publish', 'closed', 'closed', '', 'dog-training-orchids', '', '', '2018-08-01 04:49:49', '2018-08-01 04:49:49', '', '0', 'https://jhdogtraining.com.au/?page_id=204771', '0', 'page', '', '0'),
('204772', '2', '2018-08-01 04:46:17', '2018-08-01 04:46:17', '', 'orchids & dogs', '', 'inherit', 'open', 'closed', '', 'orchids-dogs', '', '', '2018-08-01 04:46:17', '2018-08-01 04:46:17', '', '204771', 'https://jhdogtraining.com.au/wp-content/uploads/2018/08/orchids-dogs.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204774', '2', '2018-08-05 00:05:03', '2018-08-05 00:05:03', '', 'iwp_log_5b6735636021d', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b6735636021d', '', '', '2018-08-05 00:05:03', '2018-08-05 00:05:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b6735636021d/', '0', 'iwp_log', '', '0'),
('204775', '2', '2018-08-06 06:14:54', '2018-08-06 06:14:54', '', 'iwp_log_5b68863b989e9', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b68863b989e9', '', '', '2018-08-06 06:14:54', '2018-08-06 06:14:54', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b68863b989e9/', '0', 'iwp_log', '', '0'),
('204776', '2', '2018-08-06 21:48:34', '2018-08-06 21:48:34', '', 'iwp_log_5b68c23296f0c', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b68c23296f0c', '', '', '2018-08-06 21:48:34', '2018-08-06 21:48:34', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b68c23296f0c/', '0', 'iwp_log', '', '0'),
('204777', '2', '2018-08-06 21:49:01', '2018-08-06 21:49:01', '', 'iwp_log_5b68c24d3578b', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b68c24d3578b', '', '', '2018-08-06 21:49:01', '2018-08-06 21:49:01', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b68c24d3578b/', '0', 'iwp_log', '', '0'),
('204778', '2', '2018-08-06 21:49:01', '2018-08-06 21:49:01', '', 'iwp_log_5b68c24d3cba0', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b68c24d3cba0', '', '', '2018-08-06 21:49:01', '2018-08-06 21:49:01', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b68c24d3cba0/', '0', 'iwp_log', '', '0'),
('204780', '2', '2018-08-08 05:36:42', '2018-08-08 05:36:42', '', 'dog training focus.look', '', 'inherit', 'open', 'closed', '', 'dog-training-focus-look', '', '', '2018-08-08 05:36:42', '2018-08-08 05:36:42', '', '0', 'https://jhdogtraining.com.au/wp-content/uploads/2018/08/dog-training-focus.look_.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204781', '2', '2018-08-08 05:37:13', '2018-08-08 05:37:13', '', 'reward while walking', '', 'inherit', 'open', 'closed', '', 'reward-while-walking', '', '', '2018-08-08 05:37:13', '2018-08-08 05:37:13', '', '0', 'https://jhdogtraining.com.au/wp-content/uploads/2018/08/reward-while-walking.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204782', '2', '2018-08-08 05:39:07', '2018-08-08 05:39:07', '', 'reward while walking 2', '', 'inherit', 'open', 'closed', '', 'reward-while-walking-2', '', '', '2018-08-08 05:39:07', '2018-08-08 05:39:07', '', '0', 'https://jhdogtraining.com.au/wp-content/uploads/2018/08/reward-while-walking-2.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204784', '2', '2018-08-12 00:05:03', '2018-08-12 00:05:03', '', 'iwp_log_5b7088741ffe9', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b7088741ffe9', '', '', '2018-08-12 00:05:03', '2018-08-12 00:05:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b7088741ffe9/', '0', 'iwp_log', '', '0'),
('204785', '2', '2018-08-13 08:50:48', '2018-08-13 08:50:48', '', 'iwp_log_5b71e4ff26c8d', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b71e4ff26c8d', '', '', '2018-08-13 08:50:48', '2018-08-13 08:50:48', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b71e4ff26c8d/', '0', 'iwp_log', '', '0'),
('204786', '2', '2018-08-13 22:14:53', '2018-08-13 22:14:53', '', 'iwp_log_5b7202dd026d2', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b7202dd026d2', '', '', '2018-08-13 22:14:53', '2018-08-13 22:14:53', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b7202dd026d2/', '0', 'iwp_log', '', '0'),
('204787', '2', '2018-08-19 00:05:03', '2018-08-19 00:05:03', '', 'iwp_log_5b79a34a942d9', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b79a34a942d9', '', '', '2018-08-19 00:05:03', '2018-08-19 00:05:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b79a34a942d9/', '0', 'iwp_log', '', '0'),
('204790', '2', '2018-08-20 15:45:56', '2018-08-20 15:45:56', '', 'iwp_log_5b7ae234ed62e', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b7ae234ed62e', '', '', '2018-08-20 15:45:56', '2018-08-20 15:45:56', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b7ae234ed62e/', '0', 'iwp_log', '', '0'),
('204791', '2', '2018-08-26 00:05:03', '2018-08-26 00:05:03', '', 'iwp_log_5b82e14c47c0d', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b82e14c47c0d', '', '', '2018-08-26 00:05:03', '2018-08-26 00:05:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b82e14c47c0d/', '0', 'iwp_log', '', '0'),
('204792', '2', '2018-08-29 05:47:18', '2018-08-29 05:47:18', '', 'iwp_log_5b86d1cfc178e', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b86d1cfc178e', '', '', '2018-08-29 05:47:18', '2018-08-29 05:47:18', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b86d1cfc178e/', '0', 'iwp_log', '', '0'),
('204793', '2', '2018-09-02 00:00:03', '2018-09-02 00:00:03', '', 'iwp_log_5b8c1e3f1e917', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b8c1e3f1e917', '', '', '2018-09-02 00:00:03', '2018-09-02 00:00:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b8c1e3f1e917/', '0', 'iwp_log', '', '0'),
('204795', '2', '2018-09-09 00:05:02', '2018-09-09 00:05:02', '', 'iwp_log_5b9552c38ae5e', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b9552c38ae5e', '', '', '2018-09-09 00:05:02', '2018-09-09 00:05:02', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b9552c38ae5e/', '0', 'iwp_log', '', '0'),
('204797', '2', '2018-09-12 15:58:58', '2018-09-12 15:58:58', '', 'iwp_log_5b9937c224349', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b9937c224349', '', '', '2018-09-12 15:58:58', '2018-09-12 15:58:58', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b9937c224349/', '0', 'iwp_log', '', '0'),
('204804', '2', '2018-09-14 16:34:16', '2018-09-14 16:34:16', '[et_pb_section bb_built=\"1\" _builder_version=\"3.12.2\" background_image=\"https://jhdogtraining.com.au/wp-content/uploads/2018/09/TOP-IMAAGE_o-new-1.jpg\" background_position=\"top_center\" module_class=\"premium-puppy\" next_background_color=\"#ffffff\"][et_pb_row _builder_version=\"3.12.2\" custom_padding=\"||120px|\"][et_pb_column type=\"4_4\"][et_pb_text _builder_version=\"3.12.2\" background_layout=\"dark\" text_text_color=\"#ffffff\" text_text_shadow_style=\"preset3\" custom_margin=\"160px|||\"]\r\n<h1 style=\"text-align: center;\"><strong>Club Canine</strong></h1>\r\n<p style=\"text-align: center;\"><strong>You’ve done the basics, but your dog needs more training and you to learn new activities you can enjoy with your dog.</strong></p>\r\n[/et_pb_text][et_pb_text _builder_version=\"3.12.2\" background_layout=\"dark\" text_text_color=\"#ffffff\" text_text_shadow_style=\"preset3\"]\r\n<h4 style=\"text-align: center;\"><strong>Let’s go to Club Canine.</strong></h4>\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section bb_built=\"1\" fullwidth=\"off\" specialty=\"off\" prev_background_color=\"#000000\" next_background_color=\"#f6f6f6\"][et_pb_row _builder_version=\"3.0.89\" module_class=\"switch-image\"][et_pb_column type=\"1_2\"][et_pb_text _builder_version=\"3.12.2\" header_2_text_color=\"#1f1e86\"]\r\n<h2 style=\"text-align: right;\">For dogs 6 months of age and older:</h2>\r\n<p style=\"text-align: right;\">Club Canine has continuous enrolment procedures, so you can start whenever you’re ready! We work with you &amp; your dog, at your level.</p>\r\n<p style=\"text-align: right;\">Introducing different tasks each week, Club Canine is a series of fun activities where you will learn new skills as you play with your dog.</p>\r\n<p style=\"text-align: right;\">Club Canine incorporates trick training, games to teach your dog to focus on you, games that teach recall and calm walking on the lead, games to send your dog through a tunnel and over a jump, and games to engage your dog’s amazing sense of smell.</p>\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_image _builder_version=\"3.12.2\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2018/09/train.jpg\" /][/et_pb_column][/et_pb_row][et_pb_row _builder_version=\"3.0.89\"][et_pb_column type=\"1_2\"][et_pb_image _builder_version=\"3.12.2\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2018/09/callback_.jpg\" /][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_text _builder_version=\"3.12.2\" header_2_text_color=\"#1f1e86\" text_font_size=\"18px\" text_line_height=\"1.8em\" custom_margin=\"40px|||\"]\r\n\r\n<strong>Where:</strong> XXX Park\r\n<strong>When:</strong> Wednesdays 7pm (each class is 1hr)\r\n<strong>Cost:</strong> Initial 4-week membership $180\r\nFurther 4-week packages $155\r\n\r\n<strong>Maximum 8 dogs per class so you will receive the personal tuition you need.</strong>\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section bb_built=\"1\" fullwidth=\"off\" specialty=\"off\" _builder_version=\"3.0.89\" background_color=\"#f6f6f6\" prev_background_color=\"#ffffff\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text _builder_version=\"3.12.2\" header_2_text_color=\"#1f1e86\"]\r\n<h2 style=\"text-align: center;\">3 Easy ways to book.</h2>\r\n<p style=\"text-align: center;\">Fill out the form below, <a href=\"mailto:jenny@jhdogtraining.com.au\">email</a><a href=\"mailto:jenny@jhdogtraining.com.au\"> jenny@jhdogtraining.com.au</a> or phone <a href=\"tel:0-419-535-236\">0419 535 236</a></p>\r\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row _builder_version=\"3.0.89\" custom_css_main_element=\"display: -webkit-flex;||display: -ms-flex;||display: flex;||||-webkit-align-items: center; ||-ms-flex-align: center;||align-items: center; \"][et_pb_column type=\"1_4\"][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_text _builder_version=\"3.12.2\"]\r\n\r\n[contact-form-7 id=\"204807\" title=\"Club Canine\"]\r\n\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_4\"][/et_pb_column][/et_pb_row][/et_pb_section]', 'Club Canine', '', 'publish', 'closed', 'closed', '', 'club-canine', '', '', '2018-09-14 17:10:19', '2018-09-14 17:10:19', '', '0', 'https://jhdogtraining.com.au/?page_id=204804', '0', 'page', '', '0'),
('204806', '2', '2018-09-14 16:34:33', '2018-09-14 16:34:33', '[et_pb_section bb_built=\"1\" _builder_version=\"3.12.2\" background_image=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/TOP-IMAAGE_o-1.jpg\" background_position=\"top_center\" module_class=\"premium-puppy\" next_background_color=\"#f6f6f6\"][et_pb_row _builder_version=\"3.0.89\"][et_pb_column type=\"4_4\"][et_pb_text _builder_version=\"3.12.2\" background_layout=\"dark\" text_text_color=\"#ffffff\" text_text_shadow_style=\"preset3\" custom_margin=\"160px|||\"]\n\n<h1 style=\"text-align: center;\"><strong>Puppy Pre-School</strong></h1>\n<p style=\"text-align: center;\"><strong>Early training and socialisation are vital for all puppies.</strong></p>\n\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row _builder_version=\"3.12.2\" custom_padding=\"||160px|\"][et_pb_column type=\"1_2\"][et_pb_text _builder_version=\"3.12.2\" text_text_color=\"#ffffff\" text_orientation=\"center\" text_font_size=\"18px\" custom_margin_tablet=\"||40px|\" custom_margin_last_edited=\"on|desktop\" custom_padding_last_edited=\"on|desktop\" module_class=\"force_marg\"]\n\nPremium Puppy class Private - for your new puppy in the comfort and convenience of your home, at a time that suits you and your family.\n\n[/et_pb_text][et_pb_button _builder_version=\"3.12.2\" button_text=\"Premium Puppy Class Private\" background_layout=\"dark\" button_alignment=\"center\" button_url=\"#\" /][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_text _builder_version=\"3.12.2\" text_text_color=\"#ffffff\" text_font_size=\"18px\" text_orientation=\"center\" module_class=\"force_marg\"]\n\nGladesville Vet Hospital &amp; University Vet Teaching Hospital Sydney\n\n[/et_pb_text][et_pb_button _builder_version=\"3.12.2\" button_text=\"Group Puppy Class\" background_layout=\"dark\" button_alignment=\"center\" button_url=\"#\" /][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section bb_built=\"1\" fullwidth=\"off\" specialty=\"off\" _builder_version=\"3.0.89\" background_color=\"#f6f6f6\" prev_background_color=\"#ffffff\" next_background_color=\"#ffffff\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text _builder_version=\"3.0.89\" background_layout=\"light\"]\n\n<p style=\"text-align: center;\">If your schedule means you’re unable to attend group puppy classes, your whole family can enjoy learning to train your puppy at home.</p>\n<p style=\"text-align: center;\">Premium Puppy covers all the information you need to manage those not-so-cute puppy behaviours such as toilet accidents, nipping, barking and jumping, as well as beginning basic training.</p>\n<p style=\"text-align: center;\">An individual program will be tailored to address your specific concerns and needs, which Jenny will discuss at your first session.</p>\n\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section bb_built=\"1\" fullwidth=\"off\" specialty=\"off\" prev_background_color=\"#f6f6f6\" next_background_color=\"#f6f6f6\"][et_pb_row _builder_version=\"3.0.89\" module_class=\"switch-image\"][et_pb_column type=\"1_2\"][et_pb_text _builder_version=\"3.0.89\" background_layout=\"light\" header_2_text_color=\"#1f1e86\"]\n\n<h2 style=\"text-align: right;\">Your puppy will learn:</h2>\n<p style=\"text-align: right;\">Basic behaviours, sit, drop down, stay, start leash walking, recall, how to release a treasure from their mouth, and how to go to his bed and settle.</p>\n\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_image _builder_version=\"3.0.89\" src=\"https://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/AdobeStock_123004237_o.jpg\" show_in_lightbox=\"off\" url_new_window=\"off\" use_overlay=\"off\" always_center_on_mobile=\"on\" force_fullwidth=\"off\" show_bottom_space=\"on\" /][/et_pb_column][/et_pb_row][et_pb_row _builder_version=\"3.0.89\"][et_pb_column type=\"1_2\"][et_pb_image _builder_version=\"3.0.89\" src=\"https://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/AdobeStock_163554641_o.jpg\" show_in_lightbox=\"off\" url_new_window=\"off\" use_overlay=\"off\" always_center_on_mobile=\"on\" force_fullwidth=\"off\" show_bottom_space=\"on\" /][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_text _builder_version=\"3.0.89\" background_layout=\"light\" header_2_text_color=\"#1f1e86\"]\n\n<h2>You will learn:</h2>\nHow to handle all those puppy challenges such as toilet training, nipping, barking, jumping up, preventing future problems and how to reinforce calm behaviour.  All taught using the latest science based positive reward training methods.\n\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text _builder_version=\"3.0.89\" background_layout=\"light\" header_2_text_color=\"#1f1e86\"]\n\n<h2 style=\"text-align: center;\">Socialization for your puppy</h2>\n<p style=\"text-align: center;\">One of the most important steps in your puppy’s education, is a great socialization plan, a vital step to raising a confident, curious and happy puppy.  You will receive your Puppy Passport, a step-by-step guide to Operation Socialization, to ensure your puppy receivesa first class puppy socialization plan.</p>\n<p style=\"text-align: center;\"><a href=\"http://www.operationsocialization.com/for-puppy-owners/about-for-puppy-owners.html\">www.OperationSocialization.com</a></p>\n\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section bb_built=\"1\" fullwidth=\"off\" specialty=\"off\" _builder_version=\"3.0.89\" background_color=\"#f6f6f6\" prev_background_color=\"#ffffff\" next_background_color=\"#ffffff\"][et_pb_row _builder_version=\"3.0.89\" custom_css_main_element=\"display: -webkit-flex;||display: -ms-flex;||display: flex;||||-webkit-align-items: center; ||-ms-flex-align: center;||align-items: center; \"][et_pb_column type=\"1_3\"][/et_pb_column][et_pb_column type=\"1_3\"][et_pb_pricing_tables _builder_version=\"3.0.89\" show_bullet=\"on\" center_list_items=\"off\" show_featured_drop_shadow=\"on\" custom_button=\"on\" button_icon_placement=\"right\" header_background_color=\"#1f1e86\" button_text_color=\"#1f1e86\" button_border_color=\"#1f1e86\"][et_pb_pricing_table _builder_version=\"3.0.89\" title=\"4 x 1hr lessons \" currency=\"$\" sum=\"450\" button_text=\"Book Now\" use_background_color_gradient=\"off\" background_color_gradient_start=\"#2b87da\" background_color_gradient_end=\"#29c4a9\" background_color_gradient_type=\"linear\" background_color_gradient_direction=\"180deg\" background_color_gradient_direction_radial=\"center\" background_color_gradient_start_position=\"0%\" background_color_gradient_end_position=\"100%\" background_color_gradient_overlays_image=\"off\" parallax=\"off\" parallax_method=\"on\" background_size=\"cover\" background_position=\"center\" background_repeat=\"no-repeat\" background_blend=\"normal\" allow_player_pause=\"off\" featured=\"off\" background_color=\"#ffffff\" text_orientation=\"center\" header_text_color=\"#ffffff\" currency_frequency_text_color=\"#1f1e86\" price_text_color=\"#1f1e86\" border_color_all=\"#1f1e86\" border_color_top=\"#1f1e86\" border_color_right=\"#1f1e86\" border_color_bottom=\"#1f1e86\" border_color_left=\"#1f1e86\" button_url=\"/contact/\" custom_button=\"off\" /][/et_pb_pricing_tables][/et_pb_column][et_pb_column type=\"1_3\"][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section bb_built=\"1\" fullwidth=\"off\" specialty=\"off\" prev_background_color=\"#f6f6f6\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_testimonial _builder_version=\"3.0.89\" url_new_window=\"off\" quote_icon=\"on\" use_background_color=\"on\" quote_icon_background_color=\"#f5f5f5\" background_layout=\"light\" author=\"Nicole &amp; Angelo Mauro\"]\n\n<em>“Our one-2-one home training with Jenny Harlow for our new pup Prince was an exceptional experience. Jenny is a highly experienced trainer, an absolute professional and incredibly astute and well organised. She specifically tailored private tuition for our pups needs, combining her very clear &amp; concise instruction using the ‘positive behavioural method’ ensured our dogs training was a huge success! Further, Jenny made training both educational &amp; fun. She’s very punctual and came super well prepared for our training…also providing us with extra tips, ideas, helpful references, and trouble shooting methods (including bespoke homework) specifically tailored  to ensure our dogs training success both during &amp; post tuition. Overall our training experience was a 10/10, and cannot recommend Jenny Harlow highly enough”.</em>\n\n[/et_pb_testimonial][/et_pb_column][/et_pb_row][/et_pb_section]', 'working', '', 'publish', 'closed', 'closed', '', 'working', '', '', '2018-09-14 16:34:33', '2018-09-14 16:34:33', '', '0', 'https://jhdogtraining.com.au/et_pb_layout/working/', '0', 'et_pb_layout', '', '0'),
('204807', '2', '2018-09-14 16:55:25', '2018-09-14 16:55:25', '<label>Name (required)\r\n    [text* your-name] </label>\r\n\r\n<label>Dog\'s Name (required)\r\n[text* dogs-name] </label>\r\n\r\n<label>Dog\'s Age (required)\r\n[text* dogs-age] </label>\r\n\r\n<label>Email Address (required)\r\n    [email* your-email] </label>\r\n\r\n<label>Phone Number (required)\r\n[tel* tel-729] </label>\r\n\r\n<label>Start Date\r\n[date start-date] </label>\r\n\r\n\r\n[submit \"Send\"]\n1\nJenny Harlow \"[your-subject]\"\n[your-name] <wordpress@jhdogtraining.com.au>\njennyharlow@bigpond.com\nFrom: [your-name] <[your-email]>\r\nSubject: [your-subject]\r\n\r\nName: [your-name]\r\nDog\'s Name: [dogs-name]\r\nDog\'s Age: [dogs-age]\r\nEmail: [your-email]\r\nPhone:[tel-729]\r\nStart Date: [start-date]\r\n\r\n-- \r\nThis e-mail was sent from a contact form on Jenny Harlow (https://jhdogtraining.com.au)\nReply-To: [your-email]\n\n\n\n\nJenny Harlow \"[your-subject]\"\nJenny Harlow <wordpress@jhdogtraining.com.au>\n[your-email]\nMessage Body:\r\n[your-message]\r\n\r\n-- \r\nThis e-mail was sent from a contact form on Jenny Harlow (https://jhdogtraining.com.au)\nReply-To: jennyharlow@bigpond.com\n\n\n\nThank you for your message. It has been sent.\nThere was an error trying to send your message. Please try again later.\nOne or more fields have an error. Please check and try again.\nThere was an error trying to send your message. Please try again later.\nYou must accept the terms and conditions before sending your message.\nThe field is required.\nThe field is too long.\nThe field is too short.\nThe date format is incorrect.\nThe date is before the earliest one allowed.\nThe date is after the latest one allowed.\nThere was an unknown error uploading the file.\nYou are not allowed to upload files of this type.\nThe file is too big.\nThere was an error uploading the file.\nThe number format is invalid.\nThe number is smaller than the minimum allowed.\nThe number is larger than the maximum allowed.\nThe answer to the quiz is incorrect.\nYour entered code is incorrect.\nThe e-mail address entered is invalid.\nThe URL is invalid.\nThe telephone number is invalid.', 'Club Canine', '', 'publish', 'closed', 'closed', '', 'club-canine', '', '', '2018-09-14 16:57:10', '2018-09-14 16:57:10', '', '0', 'https://jhdogtraining.com.au/?post_type=wpcf7_contact_form&#038;p=204807', '0', 'wpcf7_contact_form', '', '0'),
('204808', '2', '2018-09-14 17:05:12', '2018-09-14 17:05:12', '', 'TOP-IMAAGE_o-new', '', 'inherit', 'open', 'closed', '', 'top-imaage_o-new', '', '', '2018-09-14 17:05:12', '2018-09-14 17:05:12', '', '204804', 'https://jhdogtraining.com.au/wp-content/uploads/2018/09/TOP-IMAAGE_o-new.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204809', '2', '2018-09-14 17:06:28', '2018-09-14 17:06:28', '', 'TOP-IMAAGE_o-new', '', 'inherit', 'open', 'closed', '', 'top-imaage_o-new-2', '', '', '2018-09-14 17:06:28', '2018-09-14 17:06:28', '', '204804', 'https://jhdogtraining.com.au/wp-content/uploads/2018/09/TOP-IMAAGE_o-new-1.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204810', '2', '2018-09-14 17:08:17', '2018-09-14 17:08:17', '', 'callback_', '', 'inherit', 'open', 'closed', '', 'callback_', '', '', '2018-09-14 17:08:17', '2018-09-14 17:08:17', '', '204804', 'https://jhdogtraining.com.au/wp-content/uploads/2018/09/callback_.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204811', '2', '2018-09-14 17:09:19', '2018-09-14 17:09:19', '', 'train', '', 'inherit', 'open', 'closed', '', 'train', '', '', '2018-09-14 17:09:19', '2018-09-14 17:09:19', '', '204804', 'https://jhdogtraining.com.au/wp-content/uploads/2018/09/train.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204815', '2', '2018-09-14 18:10:03', '2018-09-14 18:10:03', '[et_pb_section bb_built=\"1\" _builder_version=\"3.12.2\" background_image=\"http://jhdogtraining.wpengine.com/wp-content/uploads/2017/11/TOP-IMAAGE_o-1.jpg\" background_position=\"top_center\" module_class=\"premium-puppy\" next_background_color=\"#f6f6f6\"][et_pb_row _builder_version=\"3.0.89\"][et_pb_column type=\"4_4\"][et_pb_text _builder_version=\"3.12.2\" background_layout=\"dark\" text_text_color=\"#ffffff\" text_text_shadow_style=\"preset3\" custom_margin=\"160px||160px|\"]\n\n<h1 style=\"text-align: center;\"><strong>Video Lessons</strong></h1>\n<p style=\"text-align: center;\"><strong>Video lessons that build essential skills for your dog.</strong></p>\n\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section bb_built=\"1\" fullwidth=\"off\" specialty=\"off\" _builder_version=\"3.0.89\" background_color=\"#f6f6f6\" prev_background_color=\"#ffffff\" next_background_color=\"#ffffff\"][et_pb_row][et_pb_column type=\"4_4\"][et_pb_text _builder_version=\"3.12.2\"]\n\n<h2 style=\"text-align: center;\"><strong>Essential Skills</strong></h2>\n\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section bb_built=\"1\" fullwidth=\"off\" specialty=\"off\" prev_background_color=\"#f6f6f6\"][et_pb_row _builder_version=\"3.12.2\" module_class=\"switch-image\" custom_margin=\"0px|||\" custom_padding=\"0px|||\" padding_1_last_edited=\"off|tablet\" padding_2_last_edited=\"off|tablet\" padding_bottom_1=\"0px\" padding_bottom_2=\"0px\"][et_pb_column type=\"1_2\"][et_pb_video _builder_version=\"3.12.2\" src=\"https://youtu.be/AcL0MeVZIxM\" /][et_pb_text _builder_version=\"3.12.2\" header_2_text_color=\"#1f1e86\" custom_margin=\"||0px|\" custom_padding=\"||0px|\"]\n\n<h3 style=\"text-align: center;\">How to hold the lead</h3>\n\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_video _builder_version=\"3.12.2\" src=\"https://youtu.be/AcL0MeVZIxM\" /][et_pb_text _builder_version=\"3.12.2\" header_2_text_color=\"#1f1e86\" custom_margin=\"||0px|\" custom_padding=\"||0px|\"]\n\n<h3 style=\"text-align: center;\">Learn to Focus</h3>\n\n[/et_pb_text][et_pb_divider _builder_version=\"3.12.2\" show_divider=\"off\" height=\"50px\" disabled=\"off\" disabled_on=\"off|off|on\" /][/et_pb_column][/et_pb_row][et_pb_row _builder_version=\"3.12.2\" module_class=\"switch-image\" custom_margin=\"0px|||\" custom_padding=\"0px|||\" padding_1_last_edited=\"off|tablet\" padding_2_last_edited=\"off|tablet\" padding_bottom_1=\"0px\" padding_bottom_2=\"0px\"][et_pb_column type=\"1_2\"][et_pb_video _builder_version=\"3.12.2\" src=\"https://youtu.be/AcL0MeVZIxM\" /][et_pb_text _builder_version=\"3.12.2\" header_2_text_color=\"#1f1e86\" custom_margin=\"||0px|\" custom_padding=\"||0px|\"]\n\n<h3 style=\"text-align: center;\">Learn to walk on lead</h3>\n\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_video _builder_version=\"3.12.2\" src=\"https://youtu.be/AcL0MeVZIxM\" /][et_pb_text _builder_version=\"3.12.2\" header_2_text_color=\"#1f1e86\" custom_margin=\"||0px|\" custom_padding=\"||0px|\"]\n\n<h3 style=\"text-align: center;\">“Look”</h3>\n\n[/et_pb_text][et_pb_divider _builder_version=\"3.12.2\" show_divider=\"off\" height=\"50px\" disabled=\"off\" disabled_on=\"off|off|on\" /][/et_pb_column][/et_pb_row][et_pb_row _builder_version=\"3.12.2\" module_class=\"switch-image\" custom_margin=\"0px|||\" custom_padding=\"0px|||\" padding_1_last_edited=\"off|tablet\" padding_2_last_edited=\"off|tablet\" padding_bottom_1=\"0px\" padding_bottom_2=\"0px\"][et_pb_column type=\"1_2\"][et_pb_video _builder_version=\"3.12.2\" src=\"https://youtu.be/AcL0MeVZIxM\" /][et_pb_text _builder_version=\"3.12.2\" header_2_text_color=\"#1f1e86\" custom_margin=\"||0px|\" custom_padding=\"||0px|\"]\n\n<h3 style=\"text-align: center;\">Take it “On The Road</h3>\n\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\"][et_pb_video _builder_version=\"3.12.2\" src=\"https://youtu.be/AcL0MeVZIxM\" disabled=\"on\" disabled_on=\"on|on|on\" /][et_pb_text _builder_version=\"3.12.2\" header_2_text_color=\"#1f1e86\" custom_margin=\"||0px|\" custom_padding=\"||0px|\" disabled=\"on\" disabled_on=\"on|on|on\"]\n\n<h3 style=\"text-align: center;\">“Look”</h3>\n\n[/et_pb_text][et_pb_divider _builder_version=\"3.12.2\" show_divider=\"off\" height=\"50px\" disabled=\"on\" disabled_on=\"on|on|on\" /][/et_pb_column][/et_pb_row][/et_pb_section]', 'videolayout', '', 'publish', 'closed', 'closed', '', 'videolayout', '', '', '2018-09-14 18:10:03', '2018-09-14 18:10:03', '', '0', 'https://jhdogtraining.com.au/et_pb_layout/videolayout/', '0', 'et_pb_layout', '', '0'),
('204817', '2', '2018-09-14 18:47:20', '2018-09-14 18:47:20', '', 'TOP-IMAAGE_vids', '', 'inherit', 'open', 'closed', '', 'top-imaage_vids', '', '', '2018-09-14 18:47:20', '2018-09-14 18:47:20', '', '0', 'https://jhdogtraining.com.au/wp-content/uploads/2018/09/TOP-IMAAGE_vids.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204822', '2', '2018-09-14 19:08:44', '2018-09-14 19:08:44', '', '0419 535 236', '', 'publish', 'closed', 'closed', '', '0419-535-236', '', '', '2018-09-14 19:08:44', '2018-09-14 19:08:44', '', '0', 'https://jhdogtraining.com.au/?p=204822', '2', 'nav_menu_item', '', '0'),
('204823', '2', '2018-09-14 19:08:44', '2018-09-14 19:08:44', '', 'jenny@jhdogtraining.com.au', '', 'publish', 'closed', 'closed', '', 'jennyjhdogtraining-com-au', '', '', '2018-09-14 19:08:44', '2018-09-14 19:08:44', '', '0', 'https://jhdogtraining.com.au/?p=204823', '1', 'nav_menu_item', '', '0'),
('204826', '2', '2018-09-14 19:15:18', '2018-09-14 19:15:18', '', 'iwp_log_5b9c08c660379', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b9c08c660379', '', '', '2018-09-14 19:15:18', '2018-09-14 19:15:18', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b9c08c660379/', '0', 'iwp_log', '', '0'),
('204830', '2', '2018-09-14 19:22:17', '2018-09-14 19:22:17', 'https://jhdogtraining.com.au/wp-content/uploads/2017/12/cropped-JH_Horizontal-4.png', 'cropped-JH_Horizontal-4.png', '', 'inherit', 'open', 'closed', '', 'cropped-jh_horizontal-4-png', '', '', '2018-09-14 19:22:17', '2018-09-14 19:22:17', '', '0', 'https://jhdogtraining.com.au/wp-content/uploads/2017/12/cropped-JH_Horizontal-4.png', '0', 'attachment', 'image/png', '0'),
('204832', '2', '2018-09-16 00:05:03', '2018-09-16 00:05:03', '', 'iwp_log_5b9ea25e250d6', '', 'publish', 'closed', 'closed', '', 'iwp_log_5b9ea25e250d6', '', '', '2018-09-16 00:05:03', '2018-09-16 00:05:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5b9ea25e250d6/', '0', 'iwp_log', '', '0'),
('204835', '2', '2018-09-22 00:15:25', '2018-09-22 00:15:25', 'a:7:{s:8:\"location\";a:2:{i:0;a:1:{i:0;a:3:{s:5:\"param\";s:9:\"post_type\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:9:\"pr_videos\";}}i:1;a:1:{i:0;a:3:{s:5:\"param\";s:9:\"post_type\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:6:\"videos\";}}}s:8:\"position\";s:6:\"normal\";s:5:\"style\";s:7:\"default\";s:15:\"label_placement\";s:3:\"top\";s:21:\"instruction_placement\";s:5:\"label\";s:14:\"hide_on_screen\";a:13:{i:0;s:9:\"permalink\";i:1;s:11:\"the_content\";i:2;s:7:\"excerpt\";i:3;s:10:\"discussion\";i:4;s:8:\"comments\";i:5;s:9:\"revisions\";i:6;s:4:\"slug\";i:7;s:6:\"author\";i:8;s:6:\"format\";i:9;s:15:\"page_attributes\";i:10;s:14:\"featured_image\";i:11;s:4:\"tags\";i:12;s:15:\"send-trackbacks\";}s:11:\"description\";s:0:\"\";}', 'Add Video', 'add-video', 'publish', 'closed', 'closed', '', 'group_5ba589422a16f', '', '', '2018-09-22 00:15:25', '2018-09-22 00:15:25', '', '0', 'https://jhdogtraining.com.au/?post_type=acf-field-group&#038;p=204835', '0', 'acf-field-group', '', '0'),
('204836', '2', '2018-09-22 00:15:25', '2018-09-22 00:15:25', 'a:7:{s:4:\"type\";s:6:\"oembed\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";}', 'Video Link', 'video_link', 'publish', 'closed', 'closed', '', 'field_5ba5897f45966', '', '', '2018-09-22 00:15:25', '2018-09-22 00:15:25', '', '204835', 'https://jhdogtraining.com.au/?post_type=acf-field&p=204836', '0', 'acf-field', '', '0'),
('204841', '2', '2018-09-22 00:26:26', '2018-09-22 00:26:26', '', 'Sit & wait!', '', 'publish', 'closed', 'closed', '', 'lets-go-lead-on-out-the-gate', '', '', '2018-10-13 19:53:46', '2018-10-13 19:53:46', '', '0', 'https://jhdogtraining.com.au/?post_type=pr_videos&#038;p=204841', '0', 'pr_videos', '', '0'),
('204842', '2', '2018-09-22 00:26:54', '2018-09-22 00:26:54', '', 'Let\'s go to the park', '', 'publish', 'closed', 'closed', '', 'walk-nicely-on-lead', '', '', '2018-10-13 19:54:38', '2018-10-13 19:54:38', '', '0', 'https://jhdogtraining.com.au/?post_type=pr_videos&#038;p=204842', '1', 'pr_videos', '', '0'),
('204859', '2', '2018-09-22 00:44:24', '2018-09-22 00:44:24', '', 'Teach your dog to look at you step 1', '', 'publish', 'closed', 'closed', '', 'learn-to-focus', '', '', '2018-10-15 23:46:33', '2018-10-15 23:46:33', '', '0', 'https://jhdogtraining.com.au/?post_type=videos&#038;p=204859', '0', 'videos', '', '0'),
('204864', '2', '2018-09-23 00:05:02', '2018-09-23 00:05:02', '', 'iwp_log_5ba77a7fbe147', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ba77a7fbe147', '', '', '2018-09-23 00:05:02', '2018-09-23 00:05:02', '', '0', 'https://jhdogtraining.com.au/iwp_log_5ba77a7fbe147/', '0', 'iwp_log', '', '0'),
('204865', '2', '2018-09-24 17:45:41', '2018-09-24 17:45:41', '', 'iwp_log_5ba922c5e9d89', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ba922c5e9d89', '', '', '2018-09-24 17:45:41', '2018-09-24 17:45:41', '', '0', 'https://jhdogtraining.com.au/iwp_log_5ba922c5e9d89/', '0', 'iwp_log', '', '0'),
('204866', '2', '2018-09-24 17:46:18', '2018-09-24 17:46:18', '', 'iwp_log_5ba922eaa6c0a', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ba922eaa6c0a', '', '', '2018-09-24 17:46:18', '2018-09-24 17:46:18', '', '0', 'https://jhdogtraining.com.au/iwp_log_5ba922eaa6c0a/', '0', 'iwp_log', '', '0'),
('204867', '2', '2018-09-25 01:44:00', '2018-09-25 01:44:00', '', 'My dog walks with focus step 2', '', 'publish', 'closed', 'closed', '', 'walk-focus', '', '', '2018-10-15 23:47:07', '2018-10-15 23:47:07', '', '0', 'https://jhdogtraining.com.au/?post_type=videos&#038;p=204867', '1', 'videos', '', '0'),
('204868', '2', '2018-09-25 01:45:27', '2018-09-25 01:45:27', '', 'Walk On Lead With Focus', '', 'publish', 'closed', 'closed', '', 'walk-on-lead-with-focus', '', '', '2018-09-25 01:45:27', '2018-09-25 01:45:27', '', '0', 'https://jhdogtraining.com.au/?post_type=videos&#038;p=204868', '2', 'videos', '', '0'),
('204869', '2', '2018-09-30 00:05:02', '2018-09-30 00:05:02', '', 'iwp_log_5bb1450fd4860', '', 'publish', 'closed', 'closed', '', 'iwp_log_5bb1450fd4860', '', '', '2018-09-30 00:05:02', '2018-09-30 00:05:02', '', '0', 'https://jhdogtraining.com.au/iwp_log_5bb1450fd4860/', '0', 'iwp_log', '', '0'),
('204871', '2', '2018-10-01 21:46:04', '2018-10-01 21:46:04', '', 'iwp_log_5bb2959c88447', '', 'publish', 'closed', 'closed', '', 'iwp_log_5bb2959c88447', '', '', '2018-10-01 21:46:04', '2018-10-01 21:46:04', '', '0', 'https://jhdogtraining.com.au/iwp_log_5bb2959c88447/', '0', 'iwp_log', '', '0'),
('204872', '2', '2018-10-01 21:46:04', '2018-10-01 21:46:04', '', 'iwp_log_5bb2959c9583b', '', 'publish', 'closed', 'closed', '', 'iwp_log_5bb2959c9583b', '', '', '2018-10-01 21:46:04', '2018-10-01 21:46:04', '', '0', 'https://jhdogtraining.com.au/iwp_log_5bb2959c9583b/', '0', 'iwp_log', '', '0'),
('204873', '2', '2018-10-07 00:05:04', '2018-10-07 00:05:04', '', 'iwp_log_5bba7c0a954e1', '', 'publish', 'closed', 'closed', '', 'iwp_log_5bba7c0a954e1', '', '', '2018-10-07 00:05:04', '2018-10-07 00:05:04', '', '0', 'https://jhdogtraining.com.au/iwp_log_5bba7c0a954e1/', '0', 'iwp_log', '', '0'),
('204875', '2', '2018-10-13 19:47:43', '2018-10-13 19:47:43', '{{unknown}}', '', '', 'publish', 'closed', 'closed', '', 'aa00250acafce5c1fcf0880da464202d', '', '', '2018-10-13 19:47:43', '2018-10-13 19:47:43', '', '0', 'https://jhdogtraining.com.au/aa00250acafce5c1fcf0880da464202d/', '0', 'oembed_cache', '', '0'),
('204878', '2', '2018-10-14 00:05:03', '2018-10-14 00:05:03', '', 'iwp_log_5bc3c12a846d5', '', 'publish', 'closed', 'closed', '', 'iwp_log_5bc3c12a846d5', '', '', '2018-10-14 00:05:03', '2018-10-14 00:05:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5bc3c12a846d5/', '0', 'iwp_log', '', '0'),
('204879', '2', '2018-10-21 08:21:09', '2018-10-21 08:21:09', '', 'Videos', '', 'publish', 'closed', 'closed', '', 'videos', '', '', '2020-02-26 20:09:40', '2020-02-26 20:09:40', '', '0', 'https://jhdogtraining.com.au/?p=204879', '9', 'nav_menu_item', '', '0'),
('204880', '2', '2018-10-21 00:05:02', '2018-10-21 00:05:02', '', 'iwp_log_5bccfcd12e1ce', '', 'publish', 'closed', 'closed', '', 'iwp_log_5bccfcd12e1ce', '', '', '2018-10-21 00:05:02', '2018-10-21 00:05:02', '', '0', 'https://jhdogtraining.com.au/iwp_log_5bccfcd12e1ce/', '0', 'iwp_log', '', '0'),
('204882', '2', '2018-10-22 02:27:04', '2018-10-22 02:27:04', '', 'iwp_log_5bcd35784683a', '', 'publish', 'closed', 'closed', '', 'iwp_log_5bcd35784683a', '', '', '2018-10-22 02:27:04', '2018-10-22 02:27:04', '', '0', 'https://jhdogtraining.com.au/iwp_log_5bcd35784683a/', '0', 'iwp_log', '', '0'),
('204883', '2', '2018-10-22 02:34:23', '2018-10-22 02:34:23', '', 'iwp_log_5bcd372f0b9c6', '', 'publish', 'closed', 'closed', '', 'iwp_log_5bcd372f0b9c6', '', '', '2018-10-22 02:34:23', '2018-10-22 02:34:23', '', '0', 'https://jhdogtraining.com.au/iwp_log_5bcd372f0b9c6/', '0', 'iwp_log', '', '0'),
('204884', '2', '2018-10-28 00:05:02', '2018-10-28 00:05:02', '', 'iwp_log_5bd63d24d6911', '', 'publish', 'closed', 'closed', '', 'iwp_log_5bd63d24d6911', '', '', '2018-10-28 00:05:02', '2018-10-28 00:05:02', '', '0', 'https://jhdogtraining.com.au/iwp_log_5bd63d24d6911/', '0', 'iwp_log', '', '0'),
('204886', '2', '2018-10-31 00:39:13', '2018-10-31 00:39:13', '<strong>How can I teach my dog to walk nicely on lead?</strong>\r\n\r\n\"My shoulder hurts because my dog is pulling so hard on lead.\"\r\n\r\n\"Why won’t my dog walk beside me?\"\r\n\r\n\"My dog gets so excited, what can I do to get his attention?\"\r\n\r\n\"My dog get’s frightened when we\'re out for a walk. How can I help him?\"\r\n\r\n&nbsp;\r\n\r\nI hear these questions from many of my clients. All the things mentioned above are normal ways of acting for a dog. For us, the humans at the other end of the leash, they can be frustrating, annoying or, sometimes, baffling.\r\n\r\nA frustrated/confused/annoyed human can lead to a frustrated/confused/annoyed dog.\r\n\r\nSo how can you turn this into a win-win for both? How can you show your dog that working with you is more better than pulling every which-way?...\r\n\r\nBy training a simple exercise that teaches your dog that looking at you, giving attention to you is the action that is most rewarding and fun. It\'s more rewarding, more fun, more relaxing.\r\n\r\nIn the case of an excited dog, if they learn that being with you, focusing on you is better than pulling forward or jumping around, then your dog will stay close to you.\r\n\r\nFor a dog that’s a little unsure of things, teaching this exercise gives them a point of focus that is safe and rewarding. They start to forget about “potentially scary things”. The dog becomes calmer and more confident.\r\n\r\nWhat is this amazing new skill and how do I do it?\r\n\r\nI have had the pleasure to work with a gorgeous, young, excited (pulling, jumping :) ) Labrador called Buddy. Here he is, waiting to get started!\r\n\r\n<img class=\"wp-image-204888 aligncenter\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2018/10/Buddy-Labrador-2-e1540945935286-225x300.jpg\" alt=\"\" width=\"173\" height=\"231\" />\r\n\r\nBuddy and I have created three free videos, called “On The Road With Buddy” to show you how to start this training, how to make it rewarding and fun for you and your dog, and then how to “take it on the road”.\r\n\r\nThere are 3 steps. Make sure to practice each well, practice until your dog is solid with the exercise. This will ensure that when you move to the next step, your dog clearly understands the “game” of this exercise.\r\n\r\n<em><strong>TIPS</strong></em>: Start somewhere quiet and calm. Have a handful of treats, hands behind your back. Be generous with the treats!\r\n\r\n<span style=\"color: #ff0000;\"><a style=\"color: #ff0000;\" href=\"https://jhdogtraining.com.au/videos/\">Click here</a></span> to be taken to 3 free videos so I can share my favourite training exercise for beautiful leash walking with your dog.\r\n\r\nIf you have questions, <a href=\"https://jhdogtraining.com.au/contact/\">click here</a> to get in touch with Jenny.', 'How can I train my dog to walk nicely on lead?', '', 'publish', 'open', 'open', '', 'how-can-i-train-my-dog-to-walk-nicely-on-lead', '', '', '2018-10-31 06:35:31', '2018-10-31 06:35:31', '', '0', 'https://jhdogtraining.com.au/?p=204886', '0', 'post', '', '0'),
('204888', '2', '2018-10-31 00:30:39', '2018-10-31 00:30:39', '', 'Buddy Labrador 2', '', 'inherit', 'open', 'closed', '', 'buddy-labrador-2', '', '', '2018-10-31 00:30:39', '2018-10-31 00:30:39', '', '204886', 'https://jhdogtraining.com.au/wp-content/uploads/2018/10/Buddy-Labrador-2.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204889', '2', '2018-10-31 00:31:22', '2018-10-31 00:31:22', '', 'Buddy Labrador 1', '', 'inherit', 'open', 'closed', '', 'buddy-labrador-1', '', '', '2018-10-31 00:31:22', '2018-10-31 00:31:22', '', '204886', 'https://jhdogtraining.com.au/wp-content/uploads/2018/10/Buddy-Labrador-1.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204892', '2', '2018-11-04 00:05:02', '2018-11-04 00:05:02', '', 'iwp_log_5bdf8239c2e07', '', 'publish', 'closed', 'closed', '', 'iwp_log_5bdf8239c2e07', '', '', '2018-11-04 00:05:02', '2018-11-04 00:05:02', '', '0', 'https://jhdogtraining.com.au/iwp_log_5bdf8239c2e07/', '0', 'iwp_log', '', '0'),
('204893', '2', '2018-11-11 00:05:03', '2018-11-11 00:05:03', '', 'iwp_log_5be8bcb14b031', '', 'publish', 'closed', 'closed', '', 'iwp_log_5be8bcb14b031', '', '', '2018-11-11 00:05:03', '2018-11-11 00:05:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5be8bcb14b031/', '0', 'iwp_log', '', '0'),
('204895', '2', '2018-11-14 20:25:21', '2018-11-14 20:25:21', '', 'iwp_log_5bec84b1432ca', '', 'publish', 'closed', 'closed', '', 'iwp_log_5bec84b1432ca', '', '', '2018-11-14 20:25:21', '2018-11-14 20:25:21', '', '0', 'https://jhdogtraining.com.au/iwp_log_5bec84b1432ca/', '0', 'iwp_log', '', '0'),
('204896', '2', '2018-11-14 20:25:21', '2018-11-14 20:25:21', '', 'iwp_log_5bec84b14c301', '', 'publish', 'closed', 'closed', '', 'iwp_log_5bec84b14c301', '', '', '2018-11-14 20:25:21', '2018-11-14 20:25:21', '', '0', 'https://jhdogtraining.com.au/iwp_log_5bec84b14c301/', '0', 'iwp_log', '', '0'),
('204897', '2', '2018-11-14 20:25:21', '2018-11-14 20:25:21', '', 'iwp_log_5bec84b153657', '', 'publish', 'closed', 'closed', '', 'iwp_log_5bec84b153657', '', '', '2018-11-14 20:25:21', '2018-11-14 20:25:21', '', '0', 'https://jhdogtraining.com.au/iwp_log_5bec84b153657/', '0', 'iwp_log', '', '0'),
('204898', '2', '2018-11-14 20:29:40', '2018-11-14 20:29:40', '', 'iwp_log_5bec85b42d780', '', 'publish', 'closed', 'closed', '', 'iwp_log_5bec85b42d780', '', '', '2018-11-14 20:29:40', '2018-11-14 20:29:40', '', '0', 'https://jhdogtraining.com.au/iwp_log_5bec85b42d780/', '0', 'iwp_log', '', '0'),
('204899', '2', '2018-11-18 00:05:03', '2018-11-18 00:05:03', '', 'iwp_log_5bf216cf4e727', '', 'publish', 'closed', 'closed', '', 'iwp_log_5bf216cf4e727', '', '', '2018-11-18 00:05:03', '2018-11-18 00:05:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5bf216cf4e727/', '0', 'iwp_log', '', '0'),
('204900', '2', '2018-11-25 00:05:02', '2018-11-25 00:05:02', '', 'iwp_log_5bfb354c24dc7', '', 'publish', 'closed', 'closed', '', 'iwp_log_5bfb354c24dc7', '', '', '2018-11-25 00:05:02', '2018-11-25 00:05:02', '', '0', 'https://jhdogtraining.com.au/iwp_log_5bfb354c24dc7/', '0', 'iwp_log', '', '0'),
('204902', '2', '2018-11-26 18:35:45', '2018-11-26 18:35:45', '', 'iwp_log_5bfc3d0188dc3', '', 'publish', 'closed', 'closed', '', 'iwp_log_5bfc3d0188dc3', '', '', '2018-11-26 18:35:45', '2018-11-26 18:35:45', '', '0', 'https://jhdogtraining.com.au/iwp_log_5bfc3d0188dc3/', '0', 'iwp_log', '', '0'),
('204903', '2', '2018-12-02 00:05:03', '2018-12-02 00:05:03', '', 'iwp_log_5c0491b2192c9', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c0491b2192c9', '', '', '2018-12-02 00:05:03', '2018-12-02 00:05:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c0491b2192c9/', '0', 'iwp_log', '', '0'),
('204904', '2', '2018-12-09 00:05:03', '2018-12-09 00:05:03', '', 'iwp_log_5c0df092e5fe9', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c0df092e5fe9', '', '', '2018-12-09 00:05:03', '2018-12-09 00:05:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c0df092e5fe9/', '0', 'iwp_log', '', '0'),
('204906', '2', '2018-12-15 01:29:03', '2018-12-15 01:29:03', '', 'iwp_log_5c1458dfb8bf6', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c1458dfb8bf6', '', '', '2018-12-15 01:29:03', '2018-12-15 01:29:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c1458dfb8bf6/', '0', 'iwp_log', '', '0'),
('204907', '2', '2018-12-15 01:29:03', '2018-12-15 01:29:03', '', 'iwp_log_5c1458dfc3fe8', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c1458dfc3fe8', '', '', '2018-12-15 01:29:03', '2018-12-15 01:29:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c1458dfc3fe8/', '0', 'iwp_log', '', '0'),
('204908', '2', '2018-12-15 01:29:03', '2018-12-15 01:29:03', '', 'iwp_log_5c1458dfcf936', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c1458dfcf936', '', '', '2018-12-15 01:29:03', '2018-12-15 01:29:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c1458dfcf936/', '0', 'iwp_log', '', '0'),
('204909', '2', '2018-12-15 01:29:03', '2018-12-15 01:29:03', '', 'iwp_log_5c1458dfd7766', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c1458dfd7766', '', '', '2018-12-15 01:29:03', '2018-12-15 01:29:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c1458dfd7766/', '0', 'iwp_log', '', '0'),
('204910', '2', '2018-12-15 01:29:03', '2018-12-15 01:29:03', '', 'iwp_log_5c1458dfdf3f2', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c1458dfdf3f2', '', '', '2018-12-15 01:29:03', '2018-12-15 01:29:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c1458dfdf3f2/', '0', 'iwp_log', '', '0'),
('204911', '2', '2018-12-15 01:34:11', '2018-12-15 01:34:11', '', 'iwp_log_5c145a13b64ec', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c145a13b64ec', '', '', '2018-12-15 01:34:11', '2018-12-15 01:34:11', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c145a13b64ec/', '0', 'iwp_log', '', '0'),
('204912', '2', '2018-12-15 01:34:11', '2018-12-15 01:34:11', '', 'iwp_log_5c145a13bde32', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c145a13bde32', '', '', '2018-12-15 01:34:11', '2018-12-15 01:34:11', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c145a13bde32/', '0', 'iwp_log', '', '0'),
('204913', '2', '2018-12-16 00:05:03', '2018-12-16 00:05:03', '', 'iwp_log_5c17240498c3c', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c17240498c3c', '', '', '2018-12-16 00:05:03', '2018-12-16 00:05:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c17240498c3c/', '0', 'iwp_log', '', '0'),
('204914', '2', '2018-12-23 00:05:03', '2018-12-23 00:05:03', '', 'iwp_log_5c204ce2ce1b3', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c204ce2ce1b3', '', '', '2018-12-23 00:05:03', '2018-12-23 00:05:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c204ce2ce1b3/', '0', 'iwp_log', '', '0'),
('204915', '2', '2018-12-30 00:05:03', '2018-12-30 00:05:03', '', 'iwp_log_5c298e7cbac55', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c298e7cbac55', '', '', '2018-12-30 00:05:03', '2018-12-30 00:05:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c298e7cbac55/', '0', 'iwp_log', '', '0'),
('204917', '2', '2019-01-01 23:24:16', '2019-01-01 23:24:16', 'Puppy … by definition\r\n\r\n<strong>Puppy</strong> <em>noun </em>; a young dog less than 1 year old\r\n\r\n<strong>Nip </strong><em>verb </em>: bite or pinch sharply\r\n\r\n<strong>Ouch!</strong> <em>exclamation</em> : used to express pain\r\n\r\n<img class=\"wp-image-204918 aligncenter\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2019/01/puppy-bite-300x200.jpg\" alt=\"\" width=\"173\" height=\"115\" />\r\n\r\nIf Santa brought you a puppy for Christmas, then this might ring a few bells!\r\n\r\nPuppies are gorgeous, cuddly, fun and adorable. But they can also come packaged with some challenging behaviour.\r\n<ul>\r\n 	<li>Is your puppy a “bitey-monster”, a set of needle-sharp teeth racing around on four legs attacking whoever /whatever is in reach?</li>\r\n</ul>\r\nYour puppy is wired to chew, nip and bite. They use their mouths to explore the world. But by redirecting those teeth on to appropriate chew items, you can manage this challenging phase minus the scratched arms and ripped clothing.\r\n<ul>\r\n 	<li>How’s the toilet training going? It’s easy to feel your puppy is just a pooping and peeing machine.</li>\r\n</ul>\r\nRemember to reward your puppy when they “do it” in the right place. Smell is a very strong trigger for toileting, so when they have an accident  inside, clean it up with enzymatic cleaner like Biozet laundry liquid to ensure you remove the smell.\r\n\r\n<img class=\"wp-image-204674 aligncenter\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2017/12/puppy-siberian-toilet-300x199.jpg\" alt=\"\" width=\"130\" height=\"86\" />\r\n\r\nHave you introduced your puppy to being home alone? This is an important skill for all pups but some can find it challenging. Make sure you introduce them to home alone gradually, in small steps they can handle.  If you would like Jenny\'s \"Home Alone\" handout, you can request it by clicking the email address above.\r\n\r\nPuppies are not puppies for very long and you want to enjoy this adorable phase, but it’s easy to become frustrated. Don’t.\r\n\r\nIf you have a question, ask Jenny.   Click on the number at the top of the page to call now.\r\n\r\nOr click the email address to tell me what you need.', 'Puppy Love', '', 'publish', 'closed', 'closed', '', 'puppy-love', '', '', '2019-01-01 23:34:01', '2019-01-01 23:34:01', '', '204604', 'https://jhdogtraining.com.au/?page_id=204917', '0', 'page', '', '0'),
('204918', '2', '2019-01-01 23:16:03', '2019-01-01 23:16:03', '', 'puppy bite', '', 'inherit', 'open', 'closed', '', 'puppy-bite', '', '', '2019-01-01 23:16:03', '2019-01-01 23:16:03', '', '204917', 'https://jhdogtraining.com.au/wp-content/uploads/2019/01/puppy-bite.jpg', '0', 'attachment', 'image/jpeg', '0'),
('204921', '2', '2019-01-02 00:43:13', '2019-01-02 00:43:13', 'Puppy … by definition\r\n\r\n<strong>Puppy</strong> <em>noun </em>; a young dog less than 1 year old\r\n\r\n<strong>Nip </strong><em>verb </em>: bite or pinch sharply\r\n\r\n<strong>Ouch!</strong> <em>exclamation</em> : used to express pain\r\n\r\n<img class=\"wp-image-204918\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2019/01/puppy-bite-300x200.jpg\" alt=\"\" width=\"203\" height=\"135\" />\r\n\r\nIf Santa brought you a puppy for Christmas, then this might ring a few bells!\r\n\r\nPuppies are gorgeous, cuddly, fun and adorable. But they can also come packaged with some challenging behaviour.\r\n<ul>\r\n 	<li>Is your puppy a “bitey-monster”, a set of needle-sharp teeth racing around on four legs attacking whoever /whatever is in reach?</li>\r\n</ul>\r\nYour puppy is wired to chew, nip and bite. They use their mouths to explore the world. But by redirecting those teeth on to appropriate chew items, you can manage this challenging phase, minus the scratched arms and ripped clothing.\r\n<ul>\r\n 	<li>How’s the toilet training going? It’s easy to feel your puppy is just a pooping and peeing machine.</li>\r\n</ul>\r\n<img class=\"wp-image-204674 aligncenter\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2017/12/puppy-siberian-toilet-300x199.jpg\" alt=\"\" width=\"162\" height=\"108\" />\r\n\r\nReward your puppy when they “do it” in the right place. Smell is a very strong trigger for toileting, so when they have an accident inside make sure you clean it up thoroughly with enzymatic cleaner like Biozet laundry liquid.  This will remove residual the smell.\r\n<ul>\r\n 	<li>Have you introduced your puppy to being home alone? This is an important skill for all pups but some can find it challenging. Make sure you introduce them to home alone gradually, in small steps they can handle. If you need Jenny\'s \"Home Alone\" information, click the email address above to request a copy.</li>\r\n</ul>\r\nPuppies are not puppies for very long and you want to enjoy this adorable phase. It’s easy to become frustrated. Don’t.\r\n\r\nIf you have a question, ask Jenny.   Click the mobile number above to call now.\r\n\r\nOr send an email to the address at the top of the page and tell Jenny what you need.\r\n\r\n&nbsp;', 'Puppy Love', '', 'publish', 'open', 'open', '', 'puppy-love', '', '', '2019-01-02 00:43:22', '2019-01-02 00:43:22', '', '0', 'https://jhdogtraining.com.au/?p=204921', '0', 'post', '', '0'),
('204922', '2', '2019-01-06 00:05:05', '2019-01-06 00:05:05', '', 'iwp_log_5c32d38741744', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c32d38741744', '', '', '2019-01-06 00:05:05', '2019-01-06 00:05:05', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c32d38741744/', '0', 'iwp_log', '', '0'),
('204923', '2', '2019-01-13 00:00:03', '2019-01-13 00:00:03', '', 'iwp_log_5c3c0cd9b048c', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c3c0cd9b048c', '', '', '2019-01-13 00:00:03', '2019-01-13 00:00:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c3c0cd9b048c/', '0', 'iwp_log', '', '0'),
('204924', '2', '2019-01-20 00:05:03', '2019-01-20 00:05:03', '', 'iwp_log_5c447add18f9e', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c447add18f9e', '', '', '2019-01-20 00:05:03', '2019-01-20 00:05:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c447add18f9e/', '0', 'iwp_log', '', '0'),
('204926', '2', '2019-01-26 00:59:36', '2019-01-26 00:59:36', '', 'iwp_log_5c4bb0f8bd21a', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c4bb0f8bd21a', '', '', '2019-01-26 00:59:36', '2019-01-26 00:59:36', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c4bb0f8bd21a/', '0', 'iwp_log', '', '0'),
('204927', '2', '2019-01-26 00:59:36', '2019-01-26 00:59:36', '', 'iwp_log_5c4bb0f8cfa20', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c4bb0f8cfa20', '', '', '2019-01-26 00:59:36', '2019-01-26 00:59:36', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c4bb0f8cfa20/', '0', 'iwp_log', '', '0'),
('204928', '2', '2019-01-26 01:00:36', '2019-01-26 01:00:36', '', 'iwp_log_5c4bb134730f6', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c4bb134730f6', '', '', '2019-01-26 01:00:36', '2019-01-26 01:00:36', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c4bb134730f6/', '0', 'iwp_log', '', '0'),
('204929', '2', '2019-01-26 01:01:18', '2019-01-26 01:01:18', '', 'iwp_log_5c4bb15e6d695', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c4bb15e6d695', '', '', '2019-01-26 01:01:18', '2019-01-26 01:01:18', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c4bb15e6d695/', '0', 'iwp_log', '', '0'),
('204930', '2', '2019-01-26 01:01:32', '2019-01-26 01:01:32', '', 'iwp_log_5c4bb16c44409', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c4bb16c44409', '', '', '2019-01-26 01:01:32', '2019-01-26 01:01:32', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c4bb16c44409/', '0', 'iwp_log', '', '0'),
('204931', '2', '2019-01-26 01:01:41', '2019-01-26 01:01:41', '', 'iwp_log_5c4bb175456f5', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c4bb175456f5', '', '', '2019-01-26 01:01:41', '2019-01-26 01:01:41', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c4bb175456f5/', '0', 'iwp_log', '', '0'),
('204932', '2', '2019-01-26 01:01:50', '2019-01-26 01:01:50', '', 'iwp_log_5c4bb17eb3da2', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c4bb17eb3da2', '', '', '2019-01-26 01:01:50', '2019-01-26 01:01:50', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c4bb17eb3da2/', '0', 'iwp_log', '', '0'),
('204933', '2', '2019-01-27 00:05:03', '2019-01-27 00:05:03', '', 'iwp_log_5c4db7ca34bf3', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c4db7ca34bf3', '', '', '2019-01-27 00:05:03', '2019-01-27 00:05:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c4db7ca34bf3/', '0', 'iwp_log', '', '0'),
('204948', '2', '2019-02-03 00:05:03', '2019-02-03 00:05:03', '', 'iwp_log_5c579dd25bb3b', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c579dd25bb3b', '', '', '2019-02-03 00:05:03', '2019-02-03 00:05:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c579dd25bb3b/', '0', 'iwp_log', '', '0'),
('204949', '2', '2019-02-04 16:55:59', '2019-02-04 16:55:59', '', 'iwp_log_5c586e9f5e783', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c586e9f5e783', '', '', '2019-02-04 16:55:59', '2019-02-04 16:55:59', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c586e9f5e783/', '0', 'iwp_log', '', '0'),
('204950', '2', '2019-02-04 16:55:59', '2019-02-04 16:55:59', '', 'iwp_log_5c586e9f66b21', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c586e9f66b21', '', '', '2019-02-04 16:55:59', '2019-02-04 16:55:59', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c586e9f66b21/', '0', 'iwp_log', '', '0'),
('204951', '2', '2019-02-04 16:57:03', '2019-02-04 16:57:03', '', 'iwp_log_5c586edf8e2aa', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c586edf8e2aa', '', '', '2019-02-04 16:57:03', '2019-02-04 16:57:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c586edf8e2aa/', '0', 'iwp_log', '', '0'),
('204952', '2', '2019-02-10 00:05:03', '2019-02-10 00:05:03', '', 'iwp_log_5c60e661dc51d', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c60e661dc51d', '', '', '2019-02-10 00:05:03', '2019-02-10 00:05:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c60e661dc51d/', '0', 'iwp_log', '', '0'),
('204953', '2', '2019-02-17 00:05:03', '2019-02-17 00:05:03', '', 'iwp_log_5c6a4e9add239', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c6a4e9add239', '', '', '2019-02-17 00:05:03', '2019-02-17 00:05:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c6a4e9add239/', '0', 'iwp_log', '', '0'),
('204954', '2', '2019-02-24 00:05:02', '2019-02-24 00:05:02', '', 'iwp_log_5c73c4dc1389a', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c73c4dc1389a', '', '', '2019-02-24 00:05:02', '2019-02-24 00:05:02', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c73c4dc1389a/', '0', 'iwp_log', '', '0'),
('204957', '2', '2019-03-01 20:07:32', '2019-03-01 20:07:32', '', 'iwp_log_5c799104a1954', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c799104a1954', '', '', '2019-03-01 20:07:32', '2019-03-01 20:07:32', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c799104a1954/', '0', 'iwp_log', '', '0'),
('204958', '2', '2019-03-01 20:07:38', '2019-03-01 20:07:38', '', 'iwp_log_5c79910aef8b6', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c79910aef8b6', '', '', '2019-03-01 20:07:38', '2019-03-01 20:07:38', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c79910aef8b6/', '0', 'iwp_log', '', '0'),
('204959', '2', '2019-03-01 20:07:45', '2019-03-01 20:07:45', '', 'iwp_log_5c799111e9874', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c799111e9874', '', '', '2019-03-01 20:07:45', '2019-03-01 20:07:45', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c799111e9874/', '0', 'iwp_log', '', '0'),
('204960', '2', '2019-03-01 20:09:52', '2019-03-01 20:09:52', '', 'iwp_log_5c7991908258a', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c7991908258a', '', '', '2019-03-01 20:09:52', '2019-03-01 20:09:52', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c7991908258a/', '0', 'iwp_log', '', '0'),
('204961', '2', '2019-03-01 20:09:52', '2019-03-01 20:09:52', '', 'iwp_log_5c7991908a560', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c7991908a560', '', '', '2019-03-01 20:09:52', '2019-03-01 20:09:52', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c7991908a560/', '0', 'iwp_log', '', '0'),
('204962', '2', '2019-03-01 20:09:52', '2019-03-01 20:09:52', '', 'iwp_log_5c799190903ed', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c799190903ed', '', '', '2019-03-01 20:09:52', '2019-03-01 20:09:52', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c799190903ed/', '0', 'iwp_log', '', '0'),
('204963', '2', '2019-03-01 20:10:41', '2019-03-01 20:10:41', '', 'iwp_log_5c7991c1c0b7e', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c7991c1c0b7e', '', '', '2019-03-01 20:10:41', '2019-03-01 20:10:41', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c7991c1c0b7e/', '0', 'iwp_log', '', '0'),
('204964', '2', '2019-03-03 00:05:03', '2019-03-03 00:05:03', '', 'iwp_log_5c7d27418d6db', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c7d27418d6db', '', '', '2019-03-03 00:05:03', '2019-03-03 00:05:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c7d27418d6db/', '0', 'iwp_log', '', '0'),
('204966', '2', '2019-03-10 00:05:03', '2019-03-10 00:05:03', '', 'iwp_log_5c862be8ecb89', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c862be8ecb89', '', '', '2019-03-10 00:05:03', '2019-03-10 00:05:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c862be8ecb89/', '0', 'iwp_log', '', '0'),
('204967', '2', '2019-03-17 00:05:02', '2019-03-17 00:05:02', '', 'iwp_log_5c8f8cf9a1a02', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c8f8cf9a1a02', '', '', '2019-03-17 00:05:02', '2019-03-17 00:05:02', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c8f8cf9a1a02/', '0', 'iwp_log', '', '0'),
('204968', '2', '2019-03-24 00:05:02', '2019-03-24 00:05:02', '', 'iwp_log_5c97e4049d913', '', 'publish', 'closed', 'closed', '', 'iwp_log_5c97e4049d913', '', '', '2019-03-24 00:05:02', '2019-03-24 00:05:02', '', '0', 'https://jhdogtraining.com.au/iwp_log_5c97e4049d913/', '0', 'iwp_log', '', '0'),
('204969', '2', '2019-03-31 00:05:03', '2019-03-31 00:05:03', '', 'iwp_log_5ca2020cbd375', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ca2020cbd375', '', '', '2019-03-31 00:05:03', '2019-03-31 00:05:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5ca2020cbd375/', '0', 'iwp_log', '', '0'),
('204971', '2', '2019-04-01 22:22:37', '2019-04-01 22:22:37', '', 'iwp_log_5ca28f2d962fd', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ca28f2d962fd', '', '', '2019-04-01 22:22:37', '2019-04-01 22:22:37', '', '0', 'https://jhdogtraining.com.au/iwp_log_5ca28f2d962fd/', '0', 'iwp_log', '', '0'),
('204972', '2', '2019-04-01 22:22:43', '2019-04-01 22:22:43', '', 'iwp_log_5ca28f33ba422', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ca28f33ba422', '', '', '2019-04-01 22:22:43', '2019-04-01 22:22:43', '', '0', 'https://jhdogtraining.com.au/iwp_log_5ca28f33ba422/', '0', 'iwp_log', '', '0'),
('204973', '2', '2019-04-01 22:22:52', '2019-04-01 22:22:52', '', 'iwp_log_5ca28f3cb0c20', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ca28f3cb0c20', '', '', '2019-04-01 22:22:52', '2019-04-01 22:22:52', '', '0', 'https://jhdogtraining.com.au/iwp_log_5ca28f3cb0c20/', '0', 'iwp_log', '', '0'),
('204974', '2', '2019-04-01 22:22:58', '2019-04-01 22:22:58', '', 'iwp_log_5ca28f4243170', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ca28f4243170', '', '', '2019-04-01 22:22:58', '2019-04-01 22:22:58', '', '0', 'https://jhdogtraining.com.au/iwp_log_5ca28f4243170/', '0', 'iwp_log', '', '0'),
('204975', '2', '2019-04-07 00:05:04', '2019-04-07 00:05:04', '', 'iwp_log_5caafd3c9fa74', '', 'publish', 'closed', 'closed', '', 'iwp_log_5caafd3c9fa74', '', '', '2019-04-07 00:05:04', '2019-04-07 00:05:04', '', '0', 'https://jhdogtraining.com.au/iwp_log_5caafd3c9fa74/', '0', 'iwp_log', '', '0'),
('204976', '2', '2019-04-14 00:00:03', '2019-04-14 00:00:03', '', 'iwp_log_5cb456415f141', '', 'publish', 'closed', 'closed', '', 'iwp_log_5cb456415f141', '', '', '2019-04-14 00:00:03', '2019-04-14 00:00:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5cb456415f141/', '0', 'iwp_log', '', '0'),
('204977', '2', '2019-04-21 00:05:03', '2019-04-21 00:05:03', '', 'iwp_log_5cbd9c6076b80', '', 'publish', 'closed', 'closed', '', 'iwp_log_5cbd9c6076b80', '', '', '2019-04-21 00:05:03', '2019-04-21 00:05:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5cbd9c6076b80/', '0', 'iwp_log', '', '0'),
('204979', '2', '2019-04-22 21:23:34', '2019-04-22 21:23:34', '', 'iwp_log_5cbe30d6cbe95', '', 'publish', 'closed', 'closed', '', 'iwp_log_5cbe30d6cbe95', '', '', '2019-04-22 21:23:34', '2019-04-22 21:23:34', '', '0', 'https://jhdogtraining.com.au/iwp_log_5cbe30d6cbe95/', '0', 'iwp_log', '', '0'),
('204980', '2', '2019-04-22 21:23:40', '2019-04-22 21:23:40', '', 'iwp_log_5cbe30dca7b32', '', 'publish', 'closed', 'closed', '', 'iwp_log_5cbe30dca7b32', '', '', '2019-04-22 21:23:40', '2019-04-22 21:23:40', '', '0', 'https://jhdogtraining.com.au/iwp_log_5cbe30dca7b32/', '0', 'iwp_log', '', '0'),
('204981', '2', '2019-04-28 00:05:03', '2019-04-28 00:05:03', '', 'iwp_log_5cc6d49b69978', '', 'publish', 'closed', 'closed', '', 'iwp_log_5cc6d49b69978', '', '', '2019-04-28 00:05:03', '2019-04-28 00:05:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5cc6d49b69978/', '0', 'iwp_log', '', '0'),
('204982', '2', '2019-05-05 07:05:03', '2019-05-05 07:05:03', '', 'iwp_log_5ccf3663500bb', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ccf3663500bb', '', '', '2019-05-05 07:05:03', '2019-05-05 07:05:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5ccf3663500bb/', '0', 'iwp_log', '', '0'),
('204983', '2', '2019-05-12 00:05:02', '2019-05-12 00:05:02', '', 'iwp_log_5cd98564b8d04', '', 'publish', 'closed', 'closed', '', 'iwp_log_5cd98564b8d04', '', '', '2019-05-12 00:05:02', '2019-05-12 00:05:02', '', '0', 'https://jhdogtraining.com.au/iwp_log_5cd98564b8d04/', '0', 'iwp_log', '', '0'),
('204985', '2', '2019-05-19 09:18:09', '2019-05-19 09:18:09', '', 'iwp_log_5ce11f514df1b', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ce11f514df1b', '', '', '2019-05-19 09:18:09', '2019-05-19 09:18:09', '', '0', 'https://jhdogtraining.com.au/iwp_log_5ce11f514df1b/', '0', 'iwp_log', '', '0'),
('204986', '2', '2019-05-19 09:18:16', '2019-05-19 09:18:16', '', 'iwp_log_5ce11f58683b0', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ce11f58683b0', '', '', '2019-05-19 09:18:16', '2019-05-19 09:18:16', '', '0', 'https://jhdogtraining.com.au/iwp_log_5ce11f58683b0/', '0', 'iwp_log', '', '0'),
('204987', '2', '2019-05-19 09:18:21', '2019-05-19 09:18:21', '', 'iwp_log_5ce11f5df10da', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ce11f5df10da', '', '', '2019-05-19 09:18:21', '2019-05-19 09:18:21', '', '0', 'https://jhdogtraining.com.au/iwp_log_5ce11f5df10da/', '0', 'iwp_log', '', '0'),
('204988', '2', '2019-05-19 09:18:27', '2019-05-19 09:18:27', '', 'iwp_log_5ce11f63ab1a8', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ce11f63ab1a8', '', '', '2019-05-19 09:18:27', '2019-05-19 09:18:27', '', '0', 'https://jhdogtraining.com.au/iwp_log_5ce11f63ab1a8/', '0', 'iwp_log', '', '0'),
('204989', '2', '2019-05-19 09:18:33', '2019-05-19 09:18:33', '', 'iwp_log_5ce11f6957d4c', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ce11f6957d4c', '', '', '2019-05-19 09:18:33', '2019-05-19 09:18:33', '', '0', 'https://jhdogtraining.com.au/iwp_log_5ce11f6957d4c/', '0', 'iwp_log', '', '0'),
('204990', '2', '2019-05-19 09:18:41', '2019-05-19 09:18:41', '', 'iwp_log_5ce11f71b0b16', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ce11f71b0b16', '', '', '2019-05-19 09:18:41', '2019-05-19 09:18:41', '', '0', 'https://jhdogtraining.com.au/iwp_log_5ce11f71b0b16/', '0', 'iwp_log', '', '0'),
('204991', '2', '2019-05-19 09:20:04', '2019-05-19 09:20:04', '', 'iwp_log_5ce11fc461a3b', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ce11fc461a3b', '', '', '2019-05-19 09:20:04', '2019-05-19 09:20:04', '', '0', 'https://jhdogtraining.com.au/iwp_log_5ce11fc461a3b/', '0', 'iwp_log', '', '0'),
('204992', '2', '2019-05-19 00:05:02', '2019-05-19 00:05:02', '', 'iwp_log_5ce22b0c9e7bf', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ce22b0c9e7bf', '', '', '2019-05-19 00:05:02', '2019-05-19 00:05:02', '', '0', 'https://jhdogtraining.com.au/iwp_log_5ce22b0c9e7bf/', '0', 'iwp_log', '', '0'),
('204993', '2', '2019-05-26 00:05:02', '2019-05-26 00:05:02', '', 'iwp_log_5ceb9b6273625', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ceb9b6273625', '', '', '2019-05-26 00:05:02', '2019-05-26 00:05:02', '', '0', 'https://jhdogtraining.com.au/iwp_log_5ceb9b6273625/', '0', 'iwp_log', '', '0'),
('204994', '2', '2019-06-02 00:05:02', '2019-06-02 00:05:02', '', 'iwp_log_5cf4d96485ad6', '', 'publish', 'closed', 'closed', '', 'iwp_log_5cf4d96485ad6', '', '', '2019-06-02 00:05:02', '2019-06-02 00:05:02', '', '0', 'https://jhdogtraining.com.au/iwp_log_5cf4d96485ad6/', '0', 'iwp_log', '', '0'),
('204995', '2', '2019-06-09 00:00:03', '2019-06-09 00:00:03', '', 'iwp_log_5cfe038ebda8c', '', 'publish', 'closed', 'closed', '', 'iwp_log_5cfe038ebda8c', '', '', '2019-06-09 00:00:03', '2019-06-09 00:00:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5cfe038ebda8c/', '0', 'iwp_log', '', '0'),
('204996', '2', '2019-06-16 00:05:03', '2019-06-16 00:05:03', '', 'iwp_log_5d076ced8b9b7', '', 'publish', 'closed', 'closed', '', 'iwp_log_5d076ced8b9b7', '', '', '2019-06-16 00:05:03', '2019-06-16 00:05:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5d076ced8b9b7/', '0', 'iwp_log', '', '0'),
('204998', '2', '2019-06-23 00:05:02', '2019-06-23 00:05:02', '', 'iwp_log_5d10af909aa56', '', 'publish', 'closed', 'closed', '', 'iwp_log_5d10af909aa56', '', '', '2019-06-23 00:05:02', '2019-06-23 00:05:02', '', '0', 'https://jhdogtraining.com.au/iwp_log_5d10af909aa56/', '0', 'iwp_log', '', '0'),
('204999', '2', '2019-06-27 18:36:59', '2019-06-27 18:36:59', '', 'kpalogo', '', 'inherit', 'open', 'closed', '', 'kpalogo', '', '', '2019-06-27 18:36:59', '2019-06-27 18:36:59', '', '0', 'https://jhdogtraining.com.au/wp-content/uploads/2019/06/kpalogo.jpg', '0', 'attachment', 'image/jpeg', '0'),
('205001', '2', '2019-06-27 18:37:56', '2019-06-27 18:37:56', '', 'kpalogo', '', 'inherit', 'open', 'closed', '', 'kpalogo-2', '', '', '2019-06-27 18:37:56', '2019-06-27 18:37:56', '', '0', 'https://jhdogtraining.com.au/wp-content/uploads/2019/06/kpalogo.png', '0', 'attachment', 'image/png', '0'),
('205003', '2', '2019-06-27 21:27:11', '2019-06-27 21:27:11', '', 'iwp_log_5d1534af976b8', '', 'publish', 'closed', 'closed', '', 'iwp_log_5d1534af976b8', '', '', '2019-06-27 21:27:11', '2019-06-27 21:27:11', '', '0', 'https://jhdogtraining.com.au/iwp_log_5d1534af976b8/', '0', 'iwp_log', '', '0'),
('205004', '2', '2019-06-27 21:27:18', '2019-06-27 21:27:18', '', 'iwp_log_5d1534b6d5526', '', 'publish', 'closed', 'closed', '', 'iwp_log_5d1534b6d5526', '', '', '2019-06-27 21:27:18', '2019-06-27 21:27:18', '', '0', 'https://jhdogtraining.com.au/iwp_log_5d1534b6d5526/', '0', 'iwp_log', '', '0'),
('205005', '2', '2019-06-27 21:27:25', '2019-06-27 21:27:25', '', 'iwp_log_5d1534bd75868', '', 'publish', 'closed', 'closed', '', 'iwp_log_5d1534bd75868', '', '', '2019-06-27 21:27:25', '2019-06-27 21:27:25', '', '0', 'https://jhdogtraining.com.au/iwp_log_5d1534bd75868/', '0', 'iwp_log', '', '0'),
('205006', '2', '2019-06-27 21:32:54', '2019-06-27 21:32:54', '', 'iwp_log_5d15360650dcb', '', 'publish', 'closed', 'closed', '', 'iwp_log_5d15360650dcb', '', '', '2019-06-27 21:32:54', '2019-06-27 21:32:54', '', '0', 'https://jhdogtraining.com.au/iwp_log_5d15360650dcb/', '0', 'iwp_log', '', '0'),
('205007', '2', '2019-06-30 00:05:03', '2019-06-30 00:05:03', '', 'iwp_log_5d19cba761cf3', '', 'publish', 'closed', 'closed', '', 'iwp_log_5d19cba761cf3', '', '', '2019-06-30 00:05:03', '2019-06-30 00:05:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5d19cba761cf3/', '0', 'iwp_log', '', '0'),
('205008', '2', '2019-07-07 00:00:04', '2019-07-07 00:00:04', '', 'iwp_log_5d22b5497b205', '', 'publish', 'closed', 'closed', '', 'iwp_log_5d22b5497b205', '', '', '2019-07-07 00:00:04', '2019-07-07 00:00:04', '', '0', 'https://jhdogtraining.com.au/iwp_log_5d22b5497b205/', '0', 'iwp_log', '', '0'),
('205010', '2', '2019-07-14 00:05:04', '2019-07-14 00:05:04', '', 'iwp_log_5d2c2937bc95d', '', 'publish', 'closed', 'closed', '', 'iwp_log_5d2c2937bc95d', '', '', '2019-07-14 00:05:04', '2019-07-14 00:05:04', '', '0', 'https://jhdogtraining.com.au/iwp_log_5d2c2937bc95d/', '0', 'iwp_log', '', '0'),
('205011', '2', '2019-07-17 18:34:00', '2019-07-17 18:34:00', '', 'iwp_log_5d2f6a180fe00', '', 'publish', 'closed', 'closed', '', 'iwp_log_5d2f6a180fe00', '', '', '2019-07-17 18:34:00', '2019-07-17 18:34:00', '', '0', 'https://jhdogtraining.com.au/iwp_log_5d2f6a180fe00/', '0', 'iwp_log', '', '0'),
('205012', '2', '2019-07-21 00:05:03', '2019-07-21 00:05:03', '', 'iwp_log_5d35916c4e860', '', 'publish', 'closed', 'closed', '', 'iwp_log_5d35916c4e860', '', '', '2019-07-21 00:05:03', '2019-07-21 00:05:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5d35916c4e860/', '0', 'iwp_log', '', '0'),
('205014', '2', '2019-08-18 20:56:51', '2019-08-18 20:56:51', '', 'iwp_log_5d59bb93108e7', '', 'publish', 'closed', 'closed', '', 'iwp_log_5d59bb93108e7', '', '', '2019-08-18 20:56:51', '2019-08-18 20:56:51', '', '0', 'https://jhdogtraining.com.au/iwp_log_5d59bb93108e7/', '0', 'iwp_log', '', '0'),
('205015', '2', '2019-08-18 20:56:51', '2019-08-18 20:56:51', '', 'iwp_log_5d59bb931e94a', '', 'publish', 'closed', 'closed', '', 'iwp_log_5d59bb931e94a', '', '', '2019-08-18 20:56:51', '2019-08-18 20:56:51', '', '0', 'https://jhdogtraining.com.au/iwp_log_5d59bb931e94a/', '0', 'iwp_log', '', '0'),
('205016', '2', '2019-08-18 20:56:51', '2019-08-18 20:56:51', '', 'iwp_log_5d59bb932b4f7', '', 'publish', 'closed', 'closed', '', 'iwp_log_5d59bb932b4f7', '', '', '2019-08-18 20:56:51', '2019-08-18 20:56:51', '', '0', 'https://jhdogtraining.com.au/iwp_log_5d59bb932b4f7/', '0', 'iwp_log', '', '0'),
('205017', '2', '2019-08-22 00:20:03', '2019-08-22 00:20:03', '', 'iwp_log_5d5eb5cb4552d', '', 'publish', 'closed', 'closed', '', 'iwp_log_5d5eb5cb4552d', '', '', '2019-08-22 00:20:03', '2019-08-22 00:20:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5d5eb5cb4552d/', '0', 'iwp_log', '', '0'),
('205018', '2', '2019-08-25 00:00:03', '2019-08-25 00:00:03', '', 'iwp_log_5d6347cf39c89', '', 'publish', 'closed', 'closed', '', 'iwp_log_5d6347cf39c89', '', '', '2019-08-25 00:00:03', '2019-08-25 00:00:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5d6347cf39c89/', '0', 'iwp_log', '', '0'),
('205019', '2', '2019-09-01 00:05:02', '2019-09-01 00:05:02', '', 'iwp_log_5d6c4a3412bfc', '', 'publish', 'closed', 'closed', '', 'iwp_log_5d6c4a3412bfc', '', '', '2019-09-01 00:05:02', '2019-09-01 00:05:02', '', '0', 'https://jhdogtraining.com.au/iwp_log_5d6c4a3412bfc/', '0', 'iwp_log', '', '0'),
('205020', '2', '2019-09-08 00:05:04', '2019-09-08 00:05:04', '', 'iwp_log_5d760c686db07', '', 'publish', 'closed', 'closed', '', 'iwp_log_5d760c686db07', '', '', '2019-09-08 00:05:04', '2019-09-08 00:05:04', '', '0', 'https://jhdogtraining.com.au/iwp_log_5d760c686db07/', '0', 'iwp_log', '', '0'),
('205021', '2', '2019-09-15 00:00:04', '2019-09-15 00:00:04', '', 'iwp_log_5d7f1df6d01bb', '', 'publish', 'closed', 'closed', '', 'iwp_log_5d7f1df6d01bb', '', '', '2019-09-15 00:00:04', '2019-09-15 00:00:04', '', '0', 'https://jhdogtraining.com.au/iwp_log_5d7f1df6d01bb/', '0', 'iwp_log', '', '0'),
('205023', '2', '2019-09-16 16:42:26', '2019-09-16 16:42:26', '', 'iwp_log_5d7fbb724de78', '', 'publish', 'closed', 'closed', '', 'iwp_log_5d7fbb724de78', '', '', '2019-09-16 16:42:26', '2019-09-16 16:42:26', '', '0', 'https://jhdogtraining.com.au/iwp_log_5d7fbb724de78/', '0', 'iwp_log', '', '0'),
('205024', '2', '2019-09-16 16:42:26', '2019-09-16 16:42:26', '', 'iwp_log_5d7fbb725a49f', '', 'publish', 'closed', 'closed', '', 'iwp_log_5d7fbb725a49f', '', '', '2019-09-16 16:42:26', '2019-09-16 16:42:26', '', '0', 'https://jhdogtraining.com.au/iwp_log_5d7fbb725a49f/', '0', 'iwp_log', '', '0'),
('205025', '2', '2019-09-22 00:05:04', '2019-09-22 00:05:04', '', 'iwp_log_5d885d202bca4', '', 'publish', 'closed', 'closed', '', 'iwp_log_5d885d202bca4', '', '', '2019-09-22 00:05:04', '2019-09-22 00:05:04', '', '0', 'https://jhdogtraining.com.au/iwp_log_5d885d202bca4/', '0', 'iwp_log', '', '0'),
('205027', '2', '2019-09-29 00:05:04', '2019-09-29 00:05:04', '', 'iwp_log_5d91a22a0df67', '', 'publish', 'closed', 'closed', '', 'iwp_log_5d91a22a0df67', '', '', '2019-09-29 00:05:04', '2019-09-29 00:05:04', '', '0', 'https://jhdogtraining.com.au/iwp_log_5d91a22a0df67/', '0', 'iwp_log', '', '0'),
('205029', '2', '2019-10-24 17:22:14', '2019-10-24 17:22:14', '', 'iwp_log_5db1ddc6dfee9', '', 'publish', 'closed', 'closed', '', 'iwp_log_5db1ddc6dfee9', '', '', '2019-10-24 17:22:14', '2019-10-24 17:22:14', '', '0', 'https://jhdogtraining.com.au/iwp_log_5db1ddc6dfee9/', '0', 'iwp_log', '', '0'),
('205030', '2', '2019-10-24 17:26:34', '2019-10-24 17:26:34', '', 'iwp_log_5db1decaa9490', '', 'publish', 'closed', 'closed', '', 'iwp_log_5db1decaa9490', '', '', '2019-10-24 17:26:34', '2019-10-24 17:26:34', '', '0', 'https://jhdogtraining.com.au/iwp_log_5db1decaa9490/', '0', 'iwp_log', '', '0'),
('205032', '2', '2019-11-13 12:49:43', '2019-11-13 12:49:43', '', 'iwp_log_5dcc96a5e8636', '', 'publish', 'closed', 'closed', '', 'iwp_log_5dcc96a5e8636', '', '', '2019-11-13 12:49:43', '2019-11-13 12:49:43', '', '0', 'https://jhdogtraining.com.au/iwp_log_5dcc96a5e8636/', '0', 'iwp_log', '', '0'),
('205033', '2', '2019-11-13 12:49:44', '2019-11-13 12:49:44', '', 'iwp_log_5dcc96b0363a5', '', 'publish', 'closed', 'closed', '', 'iwp_log_5dcc96b0363a5', '', '', '2019-11-13 12:49:44', '2019-11-13 12:49:44', '', '0', 'https://jhdogtraining.com.au/iwp_log_5dcc96b0363a5/', '0', 'iwp_log', '', '0'),
('205034', '2', '2019-11-13 12:49:45', '2019-11-13 12:49:45', '', 'iwp_log_5dcc96bae33a3', '', 'publish', 'closed', 'closed', '', 'iwp_log_5dcc96bae33a3', '', '', '2019-11-13 12:49:45', '2019-11-13 12:49:45', '', '0', 'https://jhdogtraining.com.au/iwp_log_5dcc96bae33a3/', '0', 'iwp_log', '', '0'),
('205036', '2', '2019-11-13 23:53:25', '2019-11-13 23:53:25', '', 'iwp_log_5dcc9775f1680', '', 'publish', 'closed', 'closed', '', 'iwp_log_5dcc9775f1680', '', '', '2019-11-13 23:53:25', '2019-11-13 23:53:25', '', '0', 'https://jhdogtraining.com.au/iwp_log_5dcc9775f1680/', '0', 'iwp_log', '', '0'),
('205037', '2', '2019-11-19 11:51:30', '2019-11-19 11:51:30', '', 'iwp_log_5dd3d742a051b', '', 'publish', 'closed', 'closed', '', 'iwp_log_5dd3d742a051b', '', '', '2019-11-19 11:51:30', '2019-11-19 11:51:30', '', '0', 'https://jhdogtraining.com.au/iwp_log_5dd3d742a051b/', '0', 'iwp_log', '', '0'),
('205038', '2', '2019-11-28 07:25:05', '2019-11-28 07:25:05', '', 'iwp_log_5de0b2d3ccde9', '', 'publish', 'closed', 'closed', '', 'iwp_log_5de0b2d3ccde9', '', '', '2019-11-28 07:25:05', '2019-11-28 07:25:05', '', '0', 'https://jhdogtraining.com.au/iwp_log_5de0b2d3ccde9/', '0', 'iwp_log', '', '0'),
('205039', '2', '2019-12-01 00:10:04', '2019-12-01 00:10:04', '', 'iwp_log_5de4f4af942df', '', 'publish', 'closed', 'closed', '', 'iwp_log_5de4f4af942df', '', '', '2019-12-01 00:10:04', '2019-12-01 00:10:04', '', '0', 'https://jhdogtraining.com.au/iwp_log_5de4f4af942df/', '0', 'iwp_log', '', '0'),
('205040', '2', '2019-12-08 00:05:03', '2019-12-08 00:05:03', '', 'iwp_log_5dee15574d42d', '', 'publish', 'closed', 'closed', '', 'iwp_log_5dee15574d42d', '', '', '2019-12-08 00:05:03', '2019-12-08 00:05:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5dee15574d42d/', '0', 'iwp_log', '', '0'),
('205041', '2', '2019-12-15 00:05:04', '2019-12-15 00:05:04', '', 'iwp_log_5df74fdf20e71', '', 'publish', 'closed', 'closed', '', 'iwp_log_5df74fdf20e71', '', '', '2019-12-15 00:05:04', '2019-12-15 00:05:04', '', '0', 'https://jhdogtraining.com.au/iwp_log_5df74fdf20e71/', '0', 'iwp_log', '', '0'),
('205043', '2', '2019-12-18 03:44:10', '2019-12-18 03:44:10', '', 'iwp_log_5df9a08a957fc', '', 'publish', 'closed', 'closed', '', 'iwp_log_5df9a08a957fc', '', '', '2019-12-18 03:44:10', '2019-12-18 03:44:10', '', '0', 'https://jhdogtraining.com.au/iwp_log_5df9a08a957fc/', '0', 'iwp_log', '', '0'),
('205044', '2', '2019-12-18 03:44:10', '2019-12-18 03:44:10', '', 'iwp_log_5df9a08aa16bc', '', 'publish', 'closed', 'closed', '', 'iwp_log_5df9a08aa16bc', '', '', '2019-12-18 03:44:10', '2019-12-18 03:44:10', '', '0', 'https://jhdogtraining.com.au/iwp_log_5df9a08aa16bc/', '0', 'iwp_log', '', '0'),
('205045', '2', '2019-12-18 03:44:10', '2019-12-18 03:44:10', '', 'iwp_log_5df9a08aaad32', '', 'publish', 'closed', 'closed', '', 'iwp_log_5df9a08aaad32', '', '', '2019-12-18 03:44:10', '2019-12-18 03:44:10', '', '0', 'https://jhdogtraining.com.au/iwp_log_5df9a08aaad32/', '0', 'iwp_log', '', '0'),
('205046', '2', '2019-12-18 03:44:10', '2019-12-18 03:44:10', '', 'iwp_log_5df9a08ab4251', '', 'publish', 'closed', 'closed', '', 'iwp_log_5df9a08ab4251', '', '', '2019-12-18 03:44:10', '2019-12-18 03:44:10', '', '0', 'https://jhdogtraining.com.au/iwp_log_5df9a08ab4251/', '0', 'iwp_log', '', '0'),
('205047', '2', '2019-12-18 03:44:10', '2019-12-18 03:44:10', '', 'iwp_log_5df9a08abc88a', '', 'publish', 'closed', 'closed', '', 'iwp_log_5df9a08abc88a', '', '', '2019-12-18 03:44:10', '2019-12-18 03:44:10', '', '0', 'https://jhdogtraining.com.au/iwp_log_5df9a08abc88a/', '0', 'iwp_log', '', '0'),
('205048', '2', '2019-12-22 00:05:04', '2019-12-22 00:05:04', '', 'iwp_log_5e007c3cc222c', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e007c3cc222c', '', '', '2019-12-22 00:05:04', '2019-12-22 00:05:04', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e007c3cc222c/', '0', 'iwp_log', '', '0'),
('205049', '2', '2019-12-29 00:05:04', '2019-12-29 00:05:04', '', 'iwp_log_5e099e3a212ed', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e099e3a212ed', '', '', '2019-12-29 00:05:04', '2019-12-29 00:05:04', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e099e3a212ed/', '0', 'iwp_log', '', '0'),
('205050', '2', '2020-01-03 08:15:18', '2020-01-03 08:15:18', '', 'iwp_log_5e0f92f2d0b94', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e0f92f2d0b94', '', '', '2020-01-03 08:15:18', '2020-01-03 08:15:18', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e0f92f2d0b94/', '0', 'iwp_log', '', '0'),
('205051', '2', '2020-01-03 08:15:21', '2020-01-03 08:15:21', '', 'iwp_log_5e0f9301ae1e1', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e0f9301ae1e1', '', '', '2020-01-03 08:15:21', '2020-01-03 08:15:21', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e0f9301ae1e1/', '0', 'iwp_log', '', '0'),
('205053', '2', '2020-01-05 00:00:06', '2020-01-05 00:00:06', '', 'iwp_log_5e12eca8c0e4d', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e12eca8c0e4d', '', '', '2020-01-05 00:00:06', '2020-01-05 00:00:06', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e12eca8c0e4d/', '0', 'iwp_log', '', '0'),
('205054', '2', '2020-01-12 00:05:03', '2020-01-12 00:05:03', '', 'iwp_log_5e1c24c76f077', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e1c24c76f077', '', '', '2020-01-12 00:05:03', '2020-01-12 00:05:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e1c24c76f077/', '0', 'iwp_log', '', '0'),
('205055', '2', '2020-01-19 00:05:04', '2020-01-19 00:05:04', '', 'iwp_log_5e2577d11fdc4', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e2577d11fdc4', '', '', '2020-01-19 00:05:04', '2020-01-19 00:05:04', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e2577d11fdc4/', '0', 'iwp_log', '', '0'),
('205056', '2', '2020-01-20 06:56:40', '2020-01-20 06:56:40', '', 'iwp_log_5e25ea01980c1', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e25ea01980c1', '', '', '2020-01-20 06:56:40', '2020-01-20 06:56:40', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e25ea01980c1/', '0', 'iwp_log', '', '0'),
('205057', '2', '2020-01-20 06:56:41', '2020-01-20 06:56:41', '', 'iwp_log_5e25ea0bdd371', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e25ea0bdd371', '', '', '2020-01-20 06:56:41', '2020-01-20 06:56:41', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e25ea0bdd371/', '0', 'iwp_log', '', '0'),
('205058', '2', '2020-01-20 06:56:42', '2020-01-20 06:56:42', '', 'iwp_log_5e25ea1572b89', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e25ea1572b89', '', '', '2020-01-20 06:56:42', '2020-01-20 06:56:42', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e25ea1572b89/', '0', 'iwp_log', '', '0'),
('205060', '2', '2020-01-26 00:05:04', '2020-01-26 00:05:04', '', 'iwp_log_5e2eab5d681b8', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e2eab5d681b8', '', '', '2020-01-26 00:05:04', '2020-01-26 00:05:04', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e2eab5d681b8/', '0', 'iwp_log', '', '0'),
('205061', '2', '2020-02-02 00:05:04', '2020-02-02 00:05:04', '', 'iwp_log_5e37f0718688d', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e37f0718688d', '', '', '2020-02-02 00:05:04', '2020-02-02 00:05:04', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e37f0718688d/', '0', 'iwp_log', '', '0'),
('205062', '2', '2020-02-03 04:15:34', '2020-02-03 04:15:34', '', 'iwp_log_5e3839233e8d6', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e3839233e8d6', '', '', '2020-02-03 04:15:34', '2020-02-03 04:15:34', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e3839233e8d6/', '0', 'iwp_log', '', '0'),
('205064', '2', '2020-02-03 15:29:57', '2020-02-03 15:29:57', '', 'iwp_log_5e383c75bb193', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e383c75bb193', '', '', '2020-02-03 15:29:57', '2020-02-03 15:29:57', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e383c75bb193/', '0', 'iwp_log', '', '0'),
('205065', '2', '2020-02-09 00:00:06', '2020-02-09 00:00:06', '', 'iwp_log_5e410d970be00', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e410d970be00', '', '', '2020-02-09 00:00:06', '2020-02-09 00:00:06', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e410d970be00/', '0', 'iwp_log', '', '0'),
('205066', '2', '2020-02-16 00:00:06', '2020-02-16 00:00:06', '', 'iwp_log_5e4a4baa865ed', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e4a4baa865ed', '', '', '2020-02-16 00:00:06', '2020-02-16 00:00:06', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e4a4baa865ed/', '0', 'iwp_log', '', '0'),
('205067', '2', '2020-02-17 08:04:16', '2020-02-17 08:04:16', '', 'iwp_log_5e4ae3ba18e8b', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e4ae3ba18e8b', '', '', '2020-02-17 08:04:16', '2020-02-17 08:04:16', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e4ae3ba18e8b/', '0', 'iwp_log', '', '0'),
('205068', '2', '2020-02-17 08:04:16', '2020-02-17 08:04:16', '', 'iwp_log_5e4ae3c556625', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e4ae3c556625', '', '', '2020-02-17 08:04:16', '2020-02-17 08:04:16', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e4ae3c556625/', '0', 'iwp_log', '', '0'),
('205069', '2', '2020-02-17 08:23:12', '2020-02-17 08:23:12', '', 'iwp_log_5e4ae82f513b4', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e4ae82f513b4', '', '', '2020-02-17 08:23:12', '2020-02-17 08:23:12', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e4ae82f513b4/', '0', 'iwp_log', '', '0'),
('205070', '2', '2020-02-23 00:05:04', '2020-02-23 00:05:04', '', 'iwp_log_5e53a6f7ce921', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e53a6f7ce921', '', '', '2020-02-23 00:05:04', '2020-02-23 00:05:04', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e53a6f7ce921/', '0', 'iwp_log', '', '0'),
('205072', '2', '2020-02-25 08:45:41', '2020-02-25 08:45:41', '', 'iwp_log_5e557982133bf', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e557982133bf', '', '', '2020-02-25 08:45:41', '2020-02-25 08:45:41', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e557982133bf/', '0', 'iwp_log', '', '0'),
('205073', '2', '2020-02-25 08:45:42', '2020-02-25 08:45:42', '', 'iwp_log_5e55798cd3194', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e55798cd3194', '', '', '2020-02-25 08:45:42', '2020-02-25 08:45:42', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e55798cd3194/', '0', 'iwp_log', '', '0'),
('205074', '2', '2020-02-25 22:47:37', '2020-02-25 22:47:37', '[et_pb_section fb_built=\"1\" admin_label=\"Section\" module_class=\"private-training\" _builder_version=\"4.5.3\" background_image=\"https://jhdogtraining.com.au/wp-content/uploads/2020/08/dog-training-banner-2.jpg\" background_position=\"top_center\" custom_padding=\"140px||140px|\" collapsed=\"off\"][et_pb_row admin_label=\"Row\" _builder_version=\"4.4.8\" collapsed=\"on\"][et_pb_column type=\"4_4\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text _builder_version=\"4.3.4\" text_text_color=\"#ffffff\" header_text_align=\"center\" header_text_color=\"#ffffff\" text_orientation=\"center\" module_alignment=\"center\" custom_margin=\"100px||100px|\" text_text_shadow_style=\"preset3\"]<h1 style=\"text-align: center;\"><strong>The Dog Training Game</strong></h1>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" _builder_version=\"3.22\" background_color=\"#f6f6f6\"][et_pb_row _builder_version=\"3.25\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"4_4\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text admin_label=\"Text\" _builder_version=\"4.5.3\" custom_padding=\"||0px|||\"]<p style=\"text-align: center;\"><em>“Jumping at people has got much less on the lead … We can now walk past people with me actively distracting her which is a major improvement.” </em></p>\n<p style=\"text-align: center;\">—Jackie with Chloe the Labrador</p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" _builder_version=\"3.22\"][et_pb_row _builder_version=\"4.3.4\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\" custom_padding=\"||5px||false|false\"][et_pb_column type=\"4_4\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text _builder_version=\"4.3.4\" header_text_color=\"#1f1e86\"]<h1 style=\"text-align: center;\"><strong>Puppy High School</strong></h1>[/et_pb_text][et_pb_text _builder_version=\"4.3.4\" header_text_color=\"#1f1e86\" header_2_text_color=\"#1f1e86\"]<p style=\"text-align: center;\">Once your pup reaches 4 months of age they’re ready for <strong>Puppy High School</strong>. </p>\n<h2></h2>[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row column_structure=\"1_2,1_2\" _builder_version=\"4.3.4\" custom_margin=\"5px||||false|false\" custom_padding=\"0px||||false|false\"][et_pb_column type=\"1_2\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_image src=\"https://jhdogtraining.com.au/wp-content/uploads/2020/08/walk-with-my-dog-cropped-scaled.jpg\" title_text=\"walk with my dog cropped\" _builder_version=\"4.6.6\" _module_preset=\"default\" hover_enabled=\"0\" sticky_enabled=\"0\"][/et_pb_image][/et_pb_column][et_pb_column type=\"1_2\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text _builder_version=\"4.6.6\" header_2_text_color=\"#1f1e86\" header_2_line_height=\"1.2em\" hover_enabled=\"0\" sticky_enabled=\"0\"]<h2>What is Puppy High School?</h2>\n<p>Puppy High School is a small group, 5-week course designed for you and your dog to train and learn using games. Games that teach your dog the foundation skills they need and keep your dog more focussed on you rather than on the other dogs in the class.</p>\n<ul>\n<li><strong>Focus and Lead walking</strong> – how to get your dog to give you attention so you can teach them to walk beside you</li>\n<li><strong>Wait, pause &amp; sit!</strong> - don\'t jump forward for the cat/the person/the kids/food</li>\n<li><strong>Recall</strong> – how to be more exciting than whatever is happening around you, so you can get your dog to come back to you!</li>\n<li><strong>Stay on your mat while I walk away</strong> – so important that the bed is a cue to settle</li>\n<li><strong>Leave it!</strong> – don’t eat that food on the ground</li>\n<li><strong>A trick</strong> – a great way to apply the training from the classes to a new exercise (and you can show off to your friends and family )</li>\n<li>Plus lots more</li>\n</ul>\n<p><strong>Cost: $250.00</strong><br />Where: St Lukes Anglican Church, 17 Burton St, Concord<br />When: Monday evening @ 7pm &amp; Wednesday evenings @ 7.45pm<br /><span style=\"font-size: 14px;\">Parking: There is free parking onsite</span></p>\n<p>&nbsp;</p>\n<p>To join us at Puppy High School, <a href=\"https://jhdogtraining.com.au/contact/\">click here</a> and include your name, your dog’s name, age &amp; breed and we will email you the next steps.</p>\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" _builder_version=\"3.22\" background_color=\"#1f1e86\"][et_pb_row _builder_version=\"3.25\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"4_4\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text _builder_version=\"3.27.4\" text_text_color=\"#ffffff\" header_3_text_color=\"#ffffff\" header_3_line_height=\"1.4em\"]<h3 style=\"text-align: center;\"><a href=\"https://jennyharlowdogtraining.activehosted.com/f/13\" target=\"_blank\" rel=\"noopener noreferrer\"><strong>Click here to receive Jenny’s free training tips </strong></a></h3>\r[/et_pb_text][et_pb_button button_url=\"https://jhdogtraining.com.au/blog/\" url_new_window=\"on\" button_text=\"click here to read the latest blog\" button_alignment=\"center\" _builder_version=\"3.16\" custom_button=\"on\" button_text_color=\"#ffffff\" button_border_color=\"#ffffff\" button_text_size__hover_enabled=\"off\" button_text_size__hover=\"null\" button_one_text_size__hover_enabled=\"off\" button_one_text_size__hover=\"null\" button_two_text_size__hover_enabled=\"off\" button_two_text_size__hover=\"null\" button_text_color__hover_enabled=\"off\" button_text_color__hover=\"null\" button_one_text_color__hover_enabled=\"off\" button_one_text_color__hover=\"null\" button_two_text_color__hover_enabled=\"off\" button_two_text_color__hover=\"null\" button_border_width__hover_enabled=\"off\" button_border_width__hover=\"null\" button_one_border_width__hover_enabled=\"off\" button_one_border_width__hover=\"null\" button_two_border_width__hover_enabled=\"off\" button_two_border_width__hover=\"null\" button_border_color__hover_enabled=\"off\" button_border_color__hover=\"null\" button_one_border_color__hover_enabled=\"off\" button_one_border_color__hover=\"null\" button_two_border_color__hover_enabled=\"off\" button_two_border_color__hover=\"null\" button_border_radius__hover_enabled=\"off\" button_border_radius__hover=\"null\" button_one_border_radius__hover_enabled=\"off\" button_one_border_radius__hover=\"null\" button_two_border_radius__hover_enabled=\"off\" button_two_border_radius__hover=\"null\" button_letter_spacing__hover_enabled=\"off\" button_letter_spacing__hover=\"null\" button_one_letter_spacing__hover_enabled=\"off\" button_one_letter_spacing__hover=\"null\" button_two_letter_spacing__hover_enabled=\"off\" button_two_letter_spacing__hover=\"null\" button_bg_color__hover_enabled=\"off\" button_bg_color__hover=\"null\" button_one_bg_color__hover_enabled=\"off\" button_one_bg_color__hover=\"null\" button_two_bg_color__hover_enabled=\"off\" button_two_bg_color__hover=\"null\"][/et_pb_button][/et_pb_column][/et_pb_row][/et_pb_section]', 'The Dog Training Game', '', 'publish', 'closed', 'closed', '', 'the-dog-training-game', '', '', '2021-05-10 03:39:11', '2021-05-10 03:39:11', '', '0', 'https://jhdogtraining.com.au/?page_id=205074', '0', 'page', '', '0'),
('205083', '2', '2020-02-26 20:08:28', '2020-02-26 20:08:28', '', 'About', '', 'publish', 'closed', 'closed', '', 'about', '', '', '2020-02-26 20:09:40', '2020-02-26 20:09:40', '', '0', 'https://jhdogtraining.com.au/?p=205083', '6', 'nav_menu_item', '', '0'),
('205084', '2', '2020-02-26 20:09:20', '2020-02-26 20:09:20', '', 'Training Classes', '', 'publish', 'closed', 'closed', '', 'training-classes', '', '', '2020-02-26 20:09:40', '2020-02-26 20:09:40', '', '0', 'https://jhdogtraining.com.au/?p=205084', '4', 'nav_menu_item', '', '0'),
('205085', '2', '2020-03-01 00:05:04', '2020-03-01 00:05:04', '', 'iwp_log_5e5ccfce16ea7', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e5ccfce16ea7', '', '', '2020-03-01 00:05:04', '2020-03-01 00:05:04', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e5ccfce16ea7/', '0', 'iwp_log', '', '0'),
('205086', '2', '2020-03-02 05:01:31', '2020-03-02 05:01:31', '', 'iwp_log_5e5d2e1882d3d', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e5d2e1882d3d', '', '', '2020-03-02 05:01:31', '2020-03-02 05:01:31', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e5d2e1882d3d/', '0', 'iwp_log', '', '0'),
('205091', '2', '2020-03-08 00:00:06', '2020-03-08 00:00:06', '', 'iwp_log_5e662c4e0f22e', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e662c4e0f22e', '', '', '2020-03-08 00:00:06', '2020-03-08 00:00:06', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e662c4e0f22e/', '0', 'iwp_log', '', '0'),
('205092', '2', '2020-03-09 02:59:00', '2020-03-09 02:59:00', '', 'iwp_log_5e664be7675c6', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e664be7675c6', '', '', '2020-03-09 02:59:00', '2020-03-09 02:59:00', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e664be7675c6/', '0', 'iwp_log', '', '0'),
('205093', '2', '2020-03-09 02:59:03', '2020-03-09 02:59:03', '', 'iwp_log_5e664bf2f21c7', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e664bf2f21c7', '', '', '2020-03-09 02:59:03', '2020-03-09 02:59:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e664bf2f21c7/', '0', 'iwp_log', '', '0'),
('205094', '2', '2020-03-09 02:59:06', '2020-03-09 02:59:06', '', 'iwp_log_5e664bfdb59de', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e664bfdb59de', '', '', '2020-03-09 02:59:06', '2020-03-09 02:59:06', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e664bfdb59de/', '0', 'iwp_log', '', '0'),
('205095', '2', '2020-03-15 00:00:06', '2020-03-15 00:00:06', '', 'iwp_log_5e6f58bb30c4a', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e6f58bb30c4a', '', '', '2020-03-15 00:00:06', '2020-03-15 00:00:06', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e6f58bb30c4a/', '0', 'iwp_log', '', '0'),
('205096', '2', '2020-03-17 09:02:14', '2020-03-17 09:02:14', '', 'iwp_log_5e712cd698757', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e712cd698757', '', '', '2020-03-17 09:02:14', '2020-03-17 09:02:14', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e712cd698757/', '0', 'iwp_log', '', '0'),
('205097', '2', '2020-03-17 09:02:14', '2020-03-17 09:02:14', '', 'iwp_log_5e712ce28a41b', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e712ce28a41b', '', '', '2020-03-17 09:02:14', '2020-03-17 09:02:14', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e712ce28a41b/', '0', 'iwp_log', '', '0'),
('205098', '2', '2020-03-17 09:02:16', '2020-03-17 09:02:16', '', 'iwp_log_5e712cece6183', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e712cece6183', '', '', '2020-03-17 09:02:16', '2020-03-17 09:02:16', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e712cece6183/', '0', 'iwp_log', '', '0'),
('205100', '2', '2020-03-22 00:00:05', '2020-03-22 00:00:05', '', 'iwp_log_5e788c3c2ba8d', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e788c3c2ba8d', '', '', '2020-03-22 00:00:05', '2020-03-22 00:00:05', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e788c3c2ba8d/', '0', 'iwp_log', '', '0'),
('205101', '2', '2020-03-25 11:42:55', '2020-03-25 11:42:55', '', 'iwp_log_5e7bde999cf76', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e7bde999cf76', '', '', '2020-03-25 11:42:55', '2020-03-25 11:42:55', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e7bde999cf76/', '0', 'iwp_log', '', '0'),
('205105', '2', '2020-03-26 00:18:14', '2020-03-26 00:18:14', 'Puppy Pre-school during COVID-19? We can help via Zoom\r\n\r\nThis is a challenging time for everyone, and as a new puppy-parent, you want to ensure your puppy grows into a confident, curious dog, right?  It’s top of your list.  But how do you do that at the moment? The internet is full of conflicting advice, as are your friends and family. Everyone’s an expert!  If you\'re confused and need help we can provide the information you need!  You can join from any location.\r\n\r\n<img class=\"wp-image-205106 alignright\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2020/03/macy-puppy-225x300.jpg\" alt=\"\" width=\"140\" height=\"187\" />\r\n\r\nJoin our online puppy pre-school, ask questions, receive information handouts to keep and start foundation training.  Topics covered include:\r\n\r\nToilet Training\r\n\r\nPuppy Nipping\r\n\r\nManaging excited behaviour\r\n\r\nEnrichment and food toys for your pup’s sharp teeth, curious brain and high energy\r\n\r\nExercise – what’s an appropriate amount and level\r\n\r\nSocialisation – how to do this with limited outside access\r\n\r\nTraining: Teach your puppy name recognition, sit, lure to mat and lie down\r\n\r\n<img class=\"wp-image-204674 alignright\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2017/12/puppy-siberian-toilet-300x199.jpg\" alt=\"\" width=\"173\" height=\"115\" />\r\n\r\nZoom is free and easy to install.  All you need is a computer or tablet with a camera. The course is 3 sessions, of 75mins, over 3 weeks.\r\n\r\nTotal cost: $90 ($30/session)\r\n\r\nMaximum: 6 participants per session (so you can ask lots of questions!)\r\n\r\nNext course starts: <strong>Saturday 4 April at 11am</strong>\r\n\r\nBookings: Click <a href=\"https://jhdogtraining.com.au/contact/\">here</a> to submit your name, puppy’s name and contact details then Jenny will be in touch with next steps.\r\n\r\nSee you there with your puppy.\r\n\r\n&nbsp;', 'Puppy Pre-school during COVID 19', '', 'publish', 'closed', 'closed', '', 'puppy-pre-school-during-covid-19', '', '', '2020-03-26 00:18:14', '2020-03-26 00:18:14', '', '0', 'https://jhdogtraining.com.au/?page_id=205105', '0', 'page', '', '0'),
('205106', '2', '2020-03-26 00:11:42', '2020-03-26 00:11:42', '', 'macy puppy', '', 'inherit', 'open', 'closed', '', 'macy-puppy', '', '', '2020-03-26 00:11:42', '2020-03-26 00:11:42', '', '205105', 'https://jhdogtraining.com.au/wp-content/uploads/2020/03/macy-puppy.jpg', '0', 'attachment', 'image/jpeg', '0'),
('205107', '2', '2020-03-26 00:13:21', '2020-03-26 00:13:21', '', 'puppy siberian toilet', '', 'inherit', 'open', 'closed', '', 'puppy-siberian-toilet-2', '', '', '2020-03-26 00:13:21', '2020-03-26 00:13:21', '', '205105', 'https://jhdogtraining.com.au/wp-content/uploads/2020/03/puppy-siberian-toilet.jpg', '0', 'attachment', 'image/jpeg', '0'),
('205108', '2', '2020-03-26 00:23:40', '0000-00-00 00:00:00', 'Puppy Pre-school during COVID-19? We can help via Zoom\r\n\r\nThis is a challenging time for everyone, and as a new puppy-parent, you want to ensure your puppy grows into a confident, curious dog, right?  It’s top of your list.  But how do you do that at the moment? The internet is full of conflicting advice, as are your friends and family. Everyone’s an expert!  If you\'re confused and need help we can provide the information you need!  You can join from any location.\r\n\r\n<img class=\"wp-image-205106 alignright\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2020/03/macy-puppy-225x300.jpg\" alt=\"\" width=\"140\" height=\"187\" />\r\n\r\nJoin our online puppy pre-school, ask questions, receive information handouts to keep and start foundation training.  Topics covered include:\r\n\r\nToilet Training\r\n\r\nPuppy Nipping\r\n\r\nManaging excited behaviour\r\n\r\nEnrichment and food toys for your pup’s sharp teeth, curious brain and high energy\r\n\r\nExercise – what’s an appropriate amount and level\r\n\r\nSocialisation – how to do this with limited outside access\r\n\r\nTraining: Teach your puppy name recognition, sit, lure to mat and lie down\r\n\r\n<img class=\"wp-image-204674 alignright\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2017/12/puppy-siberian-toilet-300x199.jpg\" alt=\"\" width=\"173\" height=\"115\" />\r\n\r\nZoom is free and easy to install.  All you need is a computer or tablet with a camera. The course is 3 sessions, of 75mins, over 3 weeks.\r\n\r\nTotal cost: $90 ($30/session)\r\n\r\nMaximum: 6 participants per session (so you can ask lots of questions!)\r\n\r\nNext course starts: <strong>Saturday 4 April at 11am</strong>\r\n\r\nBookings: Click <a href=\"https://jhdogtraining.com.au/contact/\">here</a> to submit your name, puppy’s name and contact details then Jenny will be in touch with next steps.\r\n\r\nSee you there with your puppy.\r\n\r\n&nbsp;', 'Puppy Pre-school during COVID 19', '', 'draft', 'closed', 'closed', '', '', '', '', '2020-03-26 00:23:40', '0000-00-00 00:00:00', '', '0', 'https://jhdogtraining.com.au/?page_id=205108', '0', 'page', '', '0'),
('205110', '2', '2020-03-26 00:25:58', '2020-03-26 00:25:58', 'Puppy Pre-school during COVID-19? We can help via Zoom\r\n\r\nThis is a challenging time for everyone, and as a new puppy-parent, you want to ensure your puppy grows into a confident, curious dog, right?  It’s top of your list.  But how do you do that at the moment? The internet is full of conflicting advice, as are your friends and family. Everyone’s an expert!  If you\'re confused and need help we can provide the information you need!  You can join from any location.\r\n\r\n<img class=\"wp-image-205106 alignright\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2020/03/macy-puppy-225x300.jpg\" alt=\"\" width=\"140\" height=\"187\" />\r\n\r\nJoin our online puppy pre-school, ask questions, receive information handouts to keep and start foundation training.  Topics covered include:\r\n\r\nToilet Training\r\n\r\nPuppy Nipping\r\n\r\nManaging excited behaviour\r\n\r\nEnrichment and food toys for your pup’s sharp teeth, curious brain and high energy\r\n\r\nExercise – what’s an appropriate amount and level\r\n\r\nSocialisation – how to do this with limited outside access\r\n\r\nTraining: Teach your puppy name recognition, sit, lure to mat and lie down\r\n\r\n<img class=\"wp-image-204674 alignright\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2017/12/puppy-siberian-toilet-300x199.jpg\" alt=\"\" width=\"173\" height=\"115\" />\r\n\r\nZoom is free and easy to install.  All you need is a computer or tablet with a camera. The course is 3 sessions, of 75mins, over 3 weeks.\r\n\r\nTotal cost: $90 ($30/session)\r\n\r\nMaximum: 6 participants per session (so you can ask lots of questions!)\r\n\r\nNext course starts: <strong>Saturday 4 April at 11am</strong>\r\n\r\nBookings: Click <a href=\"https://jhdogtraining.com.au/contact/\">here</a> to submit your name, puppy’s name and contact details then Jenny will be in touch with next steps.\r\n\r\nSee you there with your puppy.', 'Puppy Pre-school & COVID-19', '', 'publish', 'closed', 'closed', '', 'puppy-pre-school-covid-19', '', '', '2020-03-26 00:25:58', '2020-03-26 00:25:58', '', '0', 'https://jhdogtraining.com.au/?page_id=205110', '0', 'page', '', '0'),
('205112', '2', '2020-03-26 12:59:00', '2020-03-26 12:59:00', '', 'iwp_log_5e7d41cf119c2', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e7d41cf119c2', '', '', '2020-03-26 12:59:00', '2020-03-26 12:59:00', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e7d41cf119c2/', '0', 'iwp_log', '', '0'),
('205113', '2', '2020-03-26 12:59:01', '2020-03-26 12:59:01', '', 'iwp_log_5e7d41d8b5e03', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e7d41d8b5e03', '', '', '2020-03-26 12:59:01', '2020-03-26 12:59:01', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e7d41d8b5e03/', '0', 'iwp_log', '', '0'),
('205114', '2', '2020-03-26 12:59:03', '2020-03-26 12:59:03', '', 'iwp_log_5e7d41e654e00', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e7d41e654e00', '', '', '2020-03-26 12:59:03', '2020-03-26 12:59:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e7d41e654e00/', '0', 'iwp_log', '', '0'),
('205115', '2', '2020-03-29 00:05:03', '2020-03-29 00:05:03', '', 'iwp_log_5e81af5fb0c76', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e81af5fb0c76', '', '', '2020-03-29 00:05:03', '2020-03-29 00:05:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e81af5fb0c76/', '0', 'iwp_log', '', '0'),
('205116', '2', '2020-03-31 02:26:59', '2020-03-31 02:26:59', 'New puppy owners know about the importance of a thorough socialisation process for their new pup.  They know that they need to expose their new puppy to lots of different events and experiences in a positive manner.\r\n\r\nHow can you do this during COVID-19 when you can’t visit friends, you can’t have play sessions, nor can you let strangers pat your puppy?\r\n\r\nThe <strong>key message</strong> your pup needs to learn is that new things, strange or novel things prompt treats and praise to rain down from the sky. Yippee! That way they understand that “new things” = something good for the pup.\r\n\r\nLet’s pull it apart.\r\n\r\nFirst of all, what is “socialisation”?  It’s the process whereby the puppy takes on information about events, stimuli, noises, smells and experiences in the wider world.  When a pup is between the ages of 3 weeks to 12 weeks, they are in a very strong phase of emotional learning.  During this time, their response to new and novel events can imprint on them with lifelong effects.\r\n\r\nA puppy should be introduced to as many new <u>positive</u> experiences as possible.  Scary or negative experiences should be kept to a minimum. Good, positive exposure to a variety of stimuli gives a pup the tools to grow into a confident and curious adult dog. Even exposure from a distance is helpful in the socialisation process.  For example, if your puppy is sitting with you in a car and watching a dog play in the park, they are receiving valuable exposure to big dogs running around.\r\n\r\n<strong>Here are some very important safety messages for you and your pup:</strong>\r\n\r\n1) Medical safety.  If your puppy is not fully vaccinated, ensure you only take them to safe areas where they will not be exposed to diseases such as Parvo Virus.  That means avoiding grassy areas outside your property or parks, or any area where other dogs toilet.  Don’t let your puppy run up to dogs whose vaccination status and health you don’t know.\r\n\r\n2) Physical Safety: If introducing your puppy to new environments, e.g. letting them explore your garage, ensure there is nothing within reach that your pup could swallow. If a puppy (or dog) swallows foreign objects, the object can become lodged in their intestine, often requiring surgery to remove.\r\n\r\n3) In the time of COVID-19, social distancing is paramount for your safety as well.  Always follow the government recommendations and guidelines for social distancing.  Keep abreast of the changes to these guidelines which are regularly updated by the state and federal authorities. If you are taking your puppy in the car to sit in a carpark and watch people walk by, or carrying your puppy around the block, remember that <strong>puppies are people-magnets</strong> and it can be difficult to stop people coming up to pat your pup.  During this time of social restrictions, you should remind people to remain the appropriate distance from you and your pup.\r\n\r\nHere is a list of activities you can do safely to socialise your pup. When your pup is brave or shows confidence, sprinkle treats and lavish them with praise.\r\n\r\n<strong>Important Note: </strong>When doing socialisation exercises your pup should not be frightened.  If your pup is showing fear, you should dial back the experience to a level where they are calm.  Provide additional distance, reduce the volume of noises, or lessen the intensity of the experience.\r\n\r\n<strong>The message is: </strong>\r\n\r\nSomething new appears, treats appear.  The sequence of events is important.  New thing happens, followed by something good for your pup (treats).\r\n\r\nBarriers – climb over pool noodles, or over soft low barriers such as cushions\r\n\r\nExplore a different surface like a tarpaulin\r\n<p style=\"text-align: center;\">  <img class=\"alignnone wp-image-205119\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2020/03/puppy-on-tarp-300x200.jpg\" alt=\"\" width=\"176\" height=\"117\" /></p>\r\nWheel barrel – bring out and wheel around\r\n\r\nBring out the vacuum cleaner, move around\r\n\r\nWalk a bike past your pup, if they are OK, ride past them\r\n\r\nIf you have crutches or a cane in the house, use them to walk near the puppy\r\n\r\nPlay dress ups! Wear different hats, a false beard, get out the kids’ dress up box, walk around in high heels, rubber boots etc\r\n\r\nDifferent surfaces – sprinkle odd surfaces with kibble to encourage your pup to walk across rubber mats with different textures.\r\n\r\nEncourage your pup to walk under a coffee table or dining table.  When they are comfortable with that, drape a sheet or towel over the edge to create an extra sensation.\r\n<p style=\"text-align: left;\">Take your puppy in the car to a shop, wind down the window and let them observe people from a distance, trollies, trucks.  Or drive to the park and watch the big dogs playing from the car.</p>\r\n<p style=\"text-align: left;\"><img class=\"alignnone wp-image-205117 aligncenter\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2020/03/puppies-in-car-300x217.jpg\" alt=\"\" width=\"301\" height=\"218\" /></p>\r\nGarages are full of strange items, smells and shapes.  After making sure that the area is safe, and you’re sure there is nothing your puppy could swallow, let your puppy explore the garage.   Stay with your pup and shower him with praise or treats for being brave.\r\n\r\nPlace your puppy on lead and spend time together in front yard.  Whenever a car or truck or person walking a dog passes your house, practice calling your puppy to you, reward them with treats, play and praise.\r\n\r\nAny time your puppy notices or registers something in the front or back yard, call them to you and reward.  This teaches your puppy that when they see something new or something that might be concerning or alarming, come back to the human to be reinforced. This is a great lesson.\r\n\r\n<strong>Introducing new Sounds</strong>\r\n\r\nYou can purchase the Soundproof Puppy App and introduce your pup to a range of new sounds. Commence playing the sounds at low volume, while you sprinkle treats. Only increase the volume in very small increments.\r\n\r\n<strong>Sniffing! </strong> Here is something interesting about your dog’s nose from an article published on NOVA (<a href=\"https://www.pbs.org/wgbh/nova/article/dogs-sense-of-smell/\">https://www.pbs.org/wgbh/nova/article/dogs-sense-of-smell/</a>  ) where they noted, “Alexandra Horowitz, a dog-cognition researcher at Barnard College, writes in her book <em>Inside of a Dog</em>, that while we might notice if our coffee has had a teaspoon of sugar added to it, a dog could detect a teaspoon of sugar in a million gallons of water, or two Olympic-sized pools worth.\"\r\n\r\n<img class=\"size-medium wp-image-205118 aligncenter\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2020/03/puppy-nose-300x200.jpg\" alt=\"\" width=\"300\" height=\"200\" />\r\n\r\nYour puppy’s sense of smell has been estimated to be between 10,000 – 100,000 times more sensitive than ours. Letting your puppy sniff his environment is a great way for him to explore the world and further the socialisation process.\r\n\r\nLet him sniff new things, sniff your car tyres, the curb side near your house, other safe areas close to home so that he can use his wonderful nose to explore and investigate his immediate world.\r\n\r\nThe exercise of sitting in car with the window down in a mall carpark also let’s your pup <span style=\"text-decoration: underline;\">smell</span> that experience as well as see it.\r\n\r\nWe are all having to find new ways to do the things we need to do. If you get creative about ways to provide your puppy with exposure to a range of new experiences in a positive manner, then you are providing the socialisation process he needs.  And my prediction is that even during this time of social restrictions, we can find creative solutions for socialisation and the puppies will be just fine.\r\n\r\nFor more information on puppy-essentials, click <a href=\"https://jhdogtraining.com.au/puppy-pre-school-covid-19/\">here</a>', 'Puppy Socialisation in COVID-19', '', 'publish', 'closed', 'closed', '', 'puppy-socialisation-in-covid-19', '', '', '2020-03-31 02:28:51', '2020-03-31 02:28:51', '', '0', 'https://jhdogtraining.com.au/?page_id=205116', '0', 'page', '', '0'),
('205117', '2', '2020-03-31 02:10:53', '2020-03-31 02:10:53', '', 'puppies in car', '', 'inherit', 'open', 'closed', '', 'puppies-in-car', '', '', '2020-03-31 02:10:53', '2020-03-31 02:10:53', '', '205116', 'https://jhdogtraining.com.au/wp-content/uploads/2020/03/puppies-in-car.jpg', '0', 'attachment', 'image/jpeg', '0'),
('205118', '2', '2020-03-31 02:12:32', '2020-03-31 02:12:32', '', 'puppy nose', '', 'inherit', 'open', 'closed', '', 'puppy-nose', '', '', '2020-03-31 02:12:32', '2020-03-31 02:12:32', '', '205116', 'https://jhdogtraining.com.au/wp-content/uploads/2020/03/puppy-nose.jpg', '0', 'attachment', 'image/jpeg', '0'),
('205119', '2', '2020-03-31 02:15:09', '2020-03-31 02:15:09', '', 'puppy on tarp', '', 'inherit', 'open', 'closed', '', 'puppy-on-tarp', '', '', '2020-03-31 02:15:09', '2020-03-31 02:15:09', '', '205116', 'https://jhdogtraining.com.au/wp-content/uploads/2020/03/puppy-on-tarp.jpg', '0', 'attachment', 'image/jpeg', '0'),
('205121', '2', '2020-03-31 03:27:36', '2020-03-31 03:27:36', 'New puppy owners understand the importance of thorough socialisation for their new pup.  They know that they need to expose their new puppy to lots of different events and experiences in a positive manner.\r\n\r\n<strong>How can you do this during COVID-19</strong> when you can’t visit friends, you can’t have play sessions, nor can you let strangers pat your puppy?\r\n\r\n<strong>The key message</strong> your pup needs to learn is that new things, strange or novel things prompt treats and praise to rain down from the sky. Yippee! That way they understand that <strong>“new things” = something good for the pup. </strong>\r\n\r\nLet’s pull it apart.\r\n\r\nFirst of all, what is “socialisation”?  It’s the process whereby the puppy takes on information about events, stimuli, noises, smells and experiences in the wider world.  When a pup is between the ages of 3 weeks to 12 weeks, they are in a very strong phase of emotional learning.  During this time, their response to new and novel events can imprint on them with lifelong effects.\r\n\r\nA puppy should be introduced to as many new <strong>positive</strong> experiences as possible.  Scary or negative experiences should be kept to a minimum. Good, positive exposure to a variety of stimuli gives a pup the tools to grow into a confident and curious adult dog. Even exposure from a distance is helpful in the socialisation process.  For example, if your puppy is sitting with you in a car and watching a dog play in the park, they are receiving valuable exposure to big dogs running around.\r\n\r\n<strong>Here are some very important safety messages for you and your pup:</strong>\r\n\r\n1) <strong>Medical safety:</strong>  If your puppy is not fully vaccinated, ensure you only take them to safe areas where they will not be exposed to diseases such as Parvo Virus.  That means avoiding grassy areas outside your property or parks, any area where other dogs toilet.  Don’t let your puppy run up to dogs whose vaccination status and health you don’t know.\r\n\r\n2) <strong>Physical Safety:</strong> If introducing your puppy to new environments, e.g. letting them explore your garage, ensure there is nothing within reach that your pup could swallow. If a puppy (or dog) swallows foreign objects, the object can become lodged in their intestine, often requiring surgery to remove.\r\n\r\n3) <strong>In the time of COVID-19</strong>, social distancing is paramount for your safety as well.  Always follow the government recommendations and guidelines for social distancing.  Keep abreast of the changes to these guidelines which are regularly updated by the state and federal authorities.\r\n\r\nIf you are taking your puppy in the car to sit in a carpark and watch people walk by, or carrying your puppy around the block, remember that puppies are people-magnets and it can be difficult to stop people coming up to pat your pup.  During this time of social restrictions, you should remind people to remain the appropriate distance from you and your pup.\r\n\r\n<strong>Here is a list of activities</strong> you can do safely to socialise your pup. When your pup is brave or shows confidence, sprinkle treats and lavish them with praise.\r\n\r\n<strong>Important Note:</strong> When introducing new things, your pup should never be frightened.  If they are showing fear, you should dial back the experience to a level where the pup is calm.  Provide additional distance, reduce the volume of noises, or lessen the intensity of the experience.\r\n\r\n<strong>The message is: </strong>\r\n\r\nSomething new appears, treats appear.  The sequence of events is important.  New thing happens, followed by something good for your pup (treats).\r\n\r\n<strong>New Sights and Events</strong>\r\n\r\nBarriers – climb over pool noodles, or over soft low barriers such as cushions\r\n\r\nExplore a new crackly-surface like a tarpaulin sprinkled with treats.\r\n\r\n<img class=\"wp-image-205119 aligncenter\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2020/03/puppy-on-tarp-300x200.jpg\" alt=\"\" width=\"206\" height=\"137\" />\r\n\r\nWheel barrel – bring it out and wheel around\r\n\r\nBring out the vacuum cleaner, move around\r\n\r\nWalk a bike past your pup, if they are OK, ride past them\r\n\r\nIf you have crutches or a cane in the house, use them to walk near the puppy\r\n\r\nPlay dress ups! Wear different hats, a false beard, get out the kids’ dress up box, walk around in high heels, rubber boots etc.\r\n\r\nEncourage your pup to walk under a coffee table or dining table.  When they are comfortable with that, drape a sheet or towel over the edge to create an extra sensation.\r\n\r\nTake your puppy in the car to a shop, wind down the window and let them observe, and smell, people from a distance, with trollies, trucks passing by.\r\n\r\n<img class=\"alignnone size-medium wp-image-205117 aligncenter\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2020/03/puppies-in-car-300x217.jpg\" alt=\"\" width=\"300\" height=\"217\" />\r\n\r\nGarages are full of strange items, smells and shapes.  After making sure that the area is safe, and you’re sure there is nothing your puppy could swallow, let your puppy explore the garage.   Stay with your pup and shower him with praise or treats for being brave.\r\n\r\nPlace your puppy on lead and spend time together in front yard.  Whenever a car or truck or person walking a dog passes your house, practice calling your puppy to you, reward them with treats, play and praise.\r\n\r\nAny time your puppy notices or registers something in the front or back yard, call them to you and reward.  This teaches your puppy that when they see something new or something that might be concerning or alarming, come back to the human to be reinforced. This is a great lesson.\r\n\r\n<strong>New Sounds</strong>\r\n\r\nPurchase the Soundproof Puppy App and introduce your pup to a range of new sounds. Commence playing the sounds at low volume, sprinkle treats. Only increase the volume in very small increments.\r\n\r\n<strong>New Smells</strong>\r\n\r\nHere is an interesting note about your dog’s amazing nose, from an article published on NOVA (<a href=\"https://www.pbs.org/wgbh/nova/article/dogs-sense-of-smell/\">https://www.pbs.org/wgbh/nova/article/dogs-sense-of-smell/</a>  ) where they noted, “Alexandra Horowitz, a dog-cognition researcher at Barnard College, writes in her book <em>Inside of a Dog</em>, that while we might notice if our coffee has had a teaspoon of sugar added to it, a dog could detect a teaspoon of sugar in a million gallons of water, or two Olympic-sized pools worth.\"\r\n\r\n<img class=\"alignnone size-medium wp-image-205118 aligncenter\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2020/03/puppy-nose-300x200.jpg\" alt=\"\" width=\"300\" height=\"200\" />\r\n\r\nYour puppy’s sense of smell has been estimated to be between 10,000 – 100,000 times more sensitive than yours. Which means it’s a great way for your pup to explore the world and further the socialisation process.\r\n\r\nLet him sniff new things, sniff your car tyres, the curb side near your house, other safe areas close to home so that he can use his wonderful nose to explore and investigate his immediate world.\r\n\r\nThe sitting in the car with the window down at a shop or a park let’s your pup experience that place through smell as well as sight.\r\n\r\nWe all have to find new ways to do the things we need to do. If you get creative about ways to provide your puppy with the opportunity to be exposed to a wide range of new experiences in a positive manner, then you are providing the socialisation process he needs.  And my prediction is that even during this time of social restrictions, we can find creative solutions for socialisation and the puppies will be just fine.\r\n\r\nFor more information on puppy-essentials, click <a href=\"https://jhdogtraining.com.au/puppy-pre-school-covid-19/\">here</a>', 'Puppy Socialisation during COVID-19', '', 'publish', 'open', 'open', '', 'puppy-socialisation-during-covid-19', '', '', '2020-03-31 03:27:45', '2020-03-31 03:27:45', '', '0', 'https://jhdogtraining.com.au/?p=205121', '0', 'post', '', '0'),
('205124', '2', '2020-04-02 23:26:54', '2020-04-02 23:26:54', '<span style=\"font-family: \'Helvetica Neue\';\">This is a challenging time for everyone, and as a new puppy-parent, you want to ensure your puppy grows into a confident, curious dog, right?  It’s top of your list.  But how do you do that at the moment? </span>\r\n\r\n<span style=\"font-family: \'Helvetica Neue\';\">The internet is full of conflicting advice, as are your friends and family.  If you\'re confused and need help we can provide the information you need with small group Puppy Class on Zoom!  You can join from any location.</span>\r\n\r\n<span style=\"font-family: \'Helvetica Neue\';\">Join in so you can ask questions, receive information handouts to keep and start foundation training.  </span>\r\n\r\n<strong><span style=\"font-family: \'Helvetica Neue\';\">Topics covered include:</span></strong>\r\n\r\n<span style=\"font-family: \'Helvetica Neue\';\">Toilet Training</span><img class=\"wp-image-205107 alignright\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2020/03/puppy-siberian-toilet-300x199.jpg\" alt=\"\" width=\"124\" height=\"82\" /><span style=\"font-family: \'Helvetica Neue\';\">Puppy Nipping</span>\r\n\r\n<span style=\"font-family: \'Helvetica Neue\';\">Managing excited behaviour</span>\r\n\r\n<span style=\"font-family: \'Helvetica Neue\';\">Enrichment and food toys for your pup’s sharp teeth, curious brain and high energy</span>\r\n\r\n<span style=\"font-family: \'Helvetica Neue\';\">Exercise – what’s an appropriate amount and level</span>\r\n\r\n<span style=\"font-family: \'Helvetica Neue\';\">Socialisation – how to do this with limited outside access <img class=\"wp-image-205117 alignright\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2020/03/puppies-in-car-300x217.jpg\" alt=\"\" width=\"145\" height=\"105\" /></span>\r\n\r\n<span style=\"font-family: \'Helvetica Neue\';\"><strong>Training:</strong> Teach your puppy name recognition, sit, lure to mat and lie down</span>\r\n\r\n<span style=\"font-family: \'Helvetica Neue\';\">Zoom is free and easy to install.  All you need is a computer or tablet with a camera. The course is 3 sessions, of 75mins, over 3 weeks.</span>\r\n\r\n<span style=\"font-family: \'Helvetica Neue\';\">Total cost: $105 ($35/session)</span>\r\n\r\n<span style=\"font-family: \'Helvetica Neue\';\">Maximum: 6 participants per session (so you can ask lots of questions!)</span>\r\n\r\n<strong><span style=\"font-family: \'Helvetica Neue\';\">A new course starts regularly on either Wednesday evening or Saturday morning. </span></strong>\r\n\r\n<span style=\"font-family: \'Helvetica Neue\';\">To find out when you can join, click <a href=\"https://jhdogtraining.com.au/contact/\">here</a> to submit your name, puppy’s name and contact details then Jenny will be in touch.</span>', 'Puppy Class during COVID-19', '', 'publish', 'open', 'open', '', 'puppy-class-during-covid-19', '', '', '2020-04-02 23:27:03', '2020-04-02 23:27:03', '', '0', 'https://jhdogtraining.com.au/?p=205124', '0', 'post', '', '0'),
('205125', '2', '2020-04-03 10:59:41', '2020-04-03 10:59:41', '', 'iwp_log_5e87b1ebec6e0', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e87b1ebec6e0', '', '', '2020-04-03 10:59:41', '2020-04-03 10:59:41', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e87b1ebec6e0/', '0', 'iwp_log', '', '0'),
('205126', '2', '2020-04-03 10:59:41', '2020-04-03 10:59:41', '', 'iwp_log_5e87b1f7bc173', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e87b1f7bc173', '', '', '2020-04-03 10:59:41', '2020-04-03 10:59:41', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e87b1f7bc173/', '0', 'iwp_log', '', '0'),
('205127', '2', '2020-04-03 10:59:41', '2020-04-03 10:59:41', '', 'iwp_log_5e87b2041a7c8', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e87b2041a7c8', '', '', '2020-04-03 10:59:41', '2020-04-03 10:59:41', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e87b2041a7c8/', '0', 'iwp_log', '', '0'),
('205128', '2', '2020-04-03 10:59:41', '2020-04-03 10:59:41', '', 'iwp_log_5e87b204806a2', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e87b204806a2', '', '', '2020-04-03 10:59:41', '2020-04-03 10:59:41', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e87b204806a2/', '0', 'iwp_log', '', '0'),
('205129', '2', '2020-04-03 10:59:41', '2020-04-03 10:59:41', '', 'iwp_log_5e87b20e1e24f', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e87b20e1e24f', '', '', '2020-04-03 10:59:41', '2020-04-03 10:59:41', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e87b20e1e24f/', '0', 'iwp_log', '', '0'),
('205130', '2', '2020-04-03 10:59:41', '2020-04-03 10:59:41', '', 'iwp_log_5e87b21f1fc69', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e87b21f1fc69', '', '', '2020-04-03 10:59:41', '2020-04-03 10:59:41', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e87b21f1fc69/', '0', 'iwp_log', '', '0'),
('205131', '2', '2020-04-05 14:35:03', '2020-04-05 14:35:03', '', 'iwp_log_5e8bb5ab675a0', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e8bb5ab675a0', '', '', '2020-04-05 14:35:03', '2020-04-05 14:35:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e8bb5ab675a0/', '0', 'iwp_log', '', '0'),
('205132', '2', '2020-04-12 00:00:04', '2020-04-12 00:00:04', '', 'iwp_log_5e95563325e66', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e95563325e66', '', '', '2020-04-12 00:00:04', '2020-04-12 00:00:04', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e95563325e66/', '0', 'iwp_log', '', '0'),
('205133', '2', '2020-04-17 04:44:48', '2020-04-17 04:44:48', '', 'iwp_log_5e99cf08ee0e8', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e99cf08ee0e8', '', '', '2020-04-17 04:44:48', '2020-04-17 04:44:48', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e99cf08ee0e8/', '0', 'iwp_log', '', '0'),
('205134', '2', '2020-04-17 04:44:48', '2020-04-17 04:44:48', '', 'iwp_log_5e99cf1395a67', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e99cf1395a67', '', '', '2020-04-17 04:44:48', '2020-04-17 04:44:48', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e99cf1395a67/', '0', 'iwp_log', '', '0'),
('205135', '2', '2020-04-17 04:44:48', '2020-04-17 04:44:48', '', 'iwp_log_5e99cf1e7eafd', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e99cf1e7eafd', '', '', '2020-04-17 04:44:48', '2020-04-17 04:44:48', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e99cf1e7eafd/', '0', 'iwp_log', '', '0'),
('205136', '2', '2020-04-19 13:20:03', '2020-04-19 13:20:03', '', 'iwp_log_5e9efed51037f', '', 'publish', 'closed', 'closed', '', 'iwp_log_5e9efed51037f', '', '', '2020-04-19 13:20:03', '2020-04-19 13:20:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5e9efed51037f/', '0', 'iwp_log', '', '0'),
('205137', '2', '2020-04-23 16:55:14', '2020-04-23 16:55:14', '', 'iwp_log_5ea263452a4e2', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ea263452a4e2', '', '', '2020-04-23 16:55:14', '2020-04-23 16:55:14', '', '0', 'https://jhdogtraining.com.au/iwp_log_5ea263452a4e2/', '0', 'iwp_log', '', '0'),
('205138', '2', '2020-04-23 16:55:14', '2020-04-23 16:55:14', '', 'iwp_log_5ea2636dd3af1', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ea2636dd3af1', '', '', '2020-04-23 16:55:14', '2020-04-23 16:55:14', '', '0', 'https://jhdogtraining.com.au/iwp_log_5ea2636dd3af1/', '0', 'iwp_log', '', '0'),
('205139', '2', '2020-04-23 17:02:35', '2020-04-23 17:02:35', '', 'iwp_log_5ea264f860daa', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ea264f860daa', '', '', '2020-04-23 17:02:35', '2020-04-23 17:02:35', '', '0', 'https://jhdogtraining.com.au/iwp_log_5ea264f860daa/', '0', 'iwp_log', '', '0'),
('205140', '2', '2020-04-23 17:02:35', '2020-04-23 17:02:35', '', 'iwp_log_5ea265029a585', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ea265029a585', '', '', '2020-04-23 17:02:35', '2020-04-23 17:02:35', '', '0', 'https://jhdogtraining.com.au/iwp_log_5ea265029a585/', '0', 'iwp_log', '', '0'),
('205142', '2', '2020-04-27 07:46:52', '2020-04-27 07:46:52', 'During this time of social distancing and restriction, when most or all of your family is locked down at home, you’re able to spend heaps of time with your new pup. It’s fabulous fun for you and your puppy now, but when restrictions are eased and everyone leaves the house each morning, your puppy needs to be comfortable being left home alone.\r\n\r\nTeaching your puppy to be comfortable when they are left alone is one of the most valuable lessons you can give them.\r\n\r\n<img class=\"wp-image-205143 alignleft\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2020/04/puppy-sleeping-300x200.jpg\" alt=\"\" width=\"257\" height=\"171\" />\r\n\r\nWhen you first bring your puppy home, it is likely the first time they have been separated completely from their littermates.  And when you first leave your puppy completely alone in the house, it is likely the first time that has happened as well.\r\n\r\n&nbsp;\r\n\r\n<strong>The Puppy Pen</strong>\r\n\r\nThe puppy pen can be set up in your main living area, so when your puppy is placed in it, he still feels a part of the family.  If the pen is central in the house the puppy will also learn to accept the normal household &amp; kitchen noises and activities.  It should be big enough for a bed or crate, a toilet area and small area for chewing toys.\r\n\r\nWhen you place your puppy in the pen it should be a cue that it is time to rest.  You may need to secure the pen at the corners so your pup cannot push it over. Provide a delicious chew or raw meaty bone or chew toys to give your puppy something that will help them relax.\r\n\r\nYou should plan to be home for the first week you have your puppy so you can help them settle into their new home and routine.  Introduce the puppy to the pen by feeding all meals or treats in the pen.  This will create a good association to the pen.  Once your puppy is settled and comfortable with the pen, you should start home alone training.\r\n\r\nTo help with a smooth transition, there are 3 stages of alone time you can introduce:\r\n<ul>\r\n 	<li>Puppy is in the secure pen while you are within sight but occupied with another task;</li>\r\n 	<li>Puppy is in the secure pen while you are out of sight, in another room;</li>\r\n 	<li>Puppy is in the secure pen while you leave the house</li>\r\n</ul>\r\nIntroduce alone time for your puppy slowly, starting with leaving them in a puppy pen with a chew when you are occupied with another activity such as working on your computer.  If your puppy whimpers or cries, do not be tempted to turn around or go to your puppy.  If you do, your puppy will learn that crying is a way to get your attention, and for sure they will do it again.  Wait for the puppy to quiet before approaching them. You may feel more comfortable setting up camera on a tablet or smart phone so you can surreptitiously observe your puppy to make sure that crying &amp; noise isn’t due to their paw caught in the pen.\r\n\r\n<img class=\"size-full wp-image-205144 alignleft\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2020/04/golden-retriever-sleeping.png\" alt=\"\" width=\"211\" height=\"159\" />\r\n\r\nYour puppy should learn to settle at each stage of the process before moving on to the next step.  When you start to leave the house, begin slowly, only leaving the home for short periods of times.  Provide yummy food toys when you leave to create a positive association for when the front door closes. It is very helpful to know exactly what your puppy is doing when you leave, so use in home cameras, or record them on a tablet or smart phone.\r\n\r\nOnce you are leaving your puppy for longer and longer periods, ask your neighbours to let you know if they hear them crying, whimpering or barking.  It’s very important for you to know exactly how your puppy copes when alone and having this information will help you provide a smooth transition from constant supervision to snoozy, relaxed alone time.\r\n<ul>\r\n 	<li>Trial all the enrichment items several times to ensure your puppy is safe and they know how to use them before leaving them unsupervised.</li>\r\n 	<li>Provide several chew toys in addition to the food toys and rotate all of them to keep them fresh and fun for your pup.</li>\r\n 	<li>Only give these special toys and treats when the pup will be left alone. This helps make your absence fun and something to look forward to.</li>\r\n 	<li>When leaving your pup, keep your exit and return routine calm and relaxed. Leaving and returning should be non-events rather than exciting ones. When the humans leave and return, it’s just ‘normal’ parts of your pup’s day.</li>\r\n 	<li>For all separations, call you pup to their puppy pen, quietly say goodbye, which becomes the cue that you are leaving and good stuff (chew toys and food toys) is about to happen. When practicing, use the same routine and wear your ‘going out’ shoes as you would if you were leaving for work or going shopping.</li>\r\n 	<li>Ensure your pup has a place to sleep and rest, a place to toilet, water, appropriate chew items and toys.</li>\r\n 	<li>When you begin to practice it helps to have a pup who has had some exercise and is ready for a nap. Therefore, plan your training times.</li>\r\n 	<li>Mix up the difficulty (length) of the absence and don’t always just make it harder. Sometimes your departure should be shorter, or stay the same length, sometimes longer.  Mix it up so the length of time they will be left alone is not predictable.</li>\r\n</ul>\r\n<strong>Other Things That Can Help</strong>\r\n<ul>\r\n 	<li>Put out a call to your family &amp; friends to ask for volunteer dog sitters – a person dropping in at lunchtime for a play or activity outside can help to break up a long day of alone time.</li>\r\n 	<li>You might be working from home now, and you could ask your boss if you can work from home in the future if your pup needs more time to learn how to be comfortable for long periods.</li>\r\n 	<li>Our dogs are VERY observant. Your puppy will quickly learn which of your shoes or clothes means you are staying or leaving.  When you are practicing, ensure you leave home as you would do when you go shopping, leave for work etc.  Take the car if you drive or walk up the street if you don’t.</li>\r\n 	<li>Don’t be tempted to try leaving your puppy outside while you remain inside. Leave the home area so your dog can’t hear or smell you. Most dogs of all ages know when you’re hiding inside and will whimper, bark or scratch to get to you, regardless of how clever you think you’ve been!</li>\r\n 	<li>Your puppy needs to know you are not home, and that they are alone.</li>\r\n</ul>\r\n<strong>Sample Schedule</strong>\r\n\r\n<strong>Day 1-7</strong> Stay at home with your pup so they are fully supervised and managed.  Practice steps 1 and 2 above so that your pup is introduced to being in their pen while you move out of sight. After the first week you can start to implement an alone schedule.  An example of what this might look like is below. However, it is important to observe your puppy and work at the rate that they can accept.\r\n\r\nMix up the length of your absence. Toggle up and down so that it doesn’t just always get longer and longer.  This helps to stop our pup anticipating what’s about to happen.\r\n\r\n<strong>Day 8    </strong>Leave house for 2 minutes                                     <strong>Day 15</strong> Leave pup for 1.5 hours\r\n\r\n<strong>Day 9</strong>    Leave pup for 5 minutes                                         <strong>Day 16 </strong>Leave pup for 2.5 hours\r\n\r\n<strong>Day 10  </strong>Leave pup for 10 minutes                                       <strong>Day 17 </strong>Leave pup for 2 hours\r\n\r\n<strong>Day 11</strong> Leave pup for 20 minutes                                       <strong>Day 18 </strong>Leave pup for 3 hours\r\n\r\n<strong>Day 12</strong> Leave pup for 35 minutes                                       <strong>Day 19 </strong>Leave pup for 4 hours\r\n\r\n<strong>Day 13</strong>  Leave pup for 1hour                                                 <strong>Day 20</strong> Leave pup for 3 hours\r\n\r\n<strong>Day 14</strong>  Leave pup for 45 minutes                                       <strong>Day 21 </strong>Leave pup for 5 hou\r\n\r\n<strong>                                                   Day 22 </strong>Leave pup for 7 hours\r\n\r\nEvery puppy is different, and you need to assess how well your pup is handling the alone time and adjust accordingly.  Video your puppy on a tablet or use an App so you can monitor your pup’s progress.  Don’t rush this process, it is better to take things slowly rather than to leave your puppy home alone too quickly or for too long.  Once the puppy has experienced being alone for approximately 3 hours, most pups can cope with the alone time being extended by one-hour increments.\r\n\r\nIf you provide a variety food-based toys and chews each time you leave, in no time your pup will actually look forward to you leaving just so they can find all the chew toys, treat balls and stuffed Kongs hidden in their area.\r\n\r\nThe area you leave your puppy should be contained and secure.  For many dogs being left inside provides a quieter environment which allows them to settle more easily. There should be an area for the puppy to toilet, which they have been trained to use. But if they are outside, ensure the fences are tall and secure to prevent escapes. They need several shade areas especially in summer, and cover from rain.  Provide at least two water bowls so they have a constant supply of cool fresh water, two beds, shelter for protection from rain or adverse weather.\r\n\r\nChanges in the home environment can sometimes cause a dog who was previously relaxed when alone, to become anxious about being left.  In the future, if you move to a new house, if there is a change to the people living in your house, or you add another dog to your household, it’s a good idea to practice home alone as a training exercise to ensure the changes do not cause separation distress for your dog. <img class=\"wp-image-205145 alignright\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2020/04/sleeping-lab-puppy-300x200.jpg\" alt=\"\" width=\"218\" height=\"145\" />\r\n\r\nMost puppies learn quite quickly that being alone is just fine.  But if your puppy is barking &amp; yelping for an extended period, is destructive or toilets constantly when you leave the house, then it’s time to seek help from a suitably qualified separation trainer.  Click <a href=\"https://jhdogtraining.com.au/contact/\">here</a> to contact Jenny.', 'Home Alone Training for Puppy', '', 'publish', 'closed', 'closed', '', 'home-alone-training-for-puppy', '', '', '2020-04-27 07:46:58', '2020-04-27 07:46:58', '', '0', 'https://jhdogtraining.com.au/?page_id=205142', '0', 'page', '', '0'),
('205143', '2', '2020-04-27 07:32:24', '2020-04-27 07:32:24', '', 'puppy sleeping', '', 'inherit', 'open', 'closed', '', 'puppy-sleeping', '', '', '2020-04-27 07:32:24', '2020-04-27 07:32:24', '', '205142', 'https://jhdogtraining.com.au/wp-content/uploads/2020/04/puppy-sleeping.jpg', '0', 'attachment', 'image/jpeg', '0'),
('205144', '2', '2020-04-27 07:33:53', '2020-04-27 07:33:53', '', 'golden retriever sleeping', '', 'inherit', 'open', 'closed', '', 'golden-retriever-sleeping', '', '', '2020-04-27 07:33:53', '2020-04-27 07:33:53', '', '205142', 'https://jhdogtraining.com.au/wp-content/uploads/2020/04/golden-retriever-sleeping.png', '0', 'attachment', 'image/png', '0'),
('205145', '2', '2020-04-27 07:45:05', '2020-04-27 07:45:05', '', 'sleeping lab puppy', '', 'inherit', 'open', 'closed', '', 'sleeping-lab-puppy', '', '', '2020-04-27 07:45:05', '2020-04-27 07:45:05', '', '205142', 'https://jhdogtraining.com.au/wp-content/uploads/2020/04/sleeping-lab-puppy.jpg', '0', 'attachment', 'image/jpeg', '0'),
('205146', '2', '2020-04-27 08:08:56', '2020-04-27 08:08:56', 'If you have a new puppy and most or all of your family is locked down at home, you’re probably enjoying heaps of time playing and hanging out with them. It’s fabulous fun but when restrictions are eased and everyone leaves the house each morning, your puppy needs to be comfortable being left home alone.\r\n\r\nTeaching your puppy to be comfortable when they are left alone is one of the most valuable lessons you can give them.\r\n\r\n<img class=\"size-medium wp-image-205143 alignright\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2020/04/puppy-sleeping-300x200.jpg\" alt=\"\" width=\"300\" height=\"200\" />When you first bring your puppy home, it is likely the first time they have been separated completely from their littermates.  And when you first leave your puppy completely alone in the house, it is likely the first time that has happened as well.\r\n\r\n&nbsp;\r\n\r\n<strong>The Puppy Pen</strong>\r\n\r\nThe puppy pen can be set up in your main living area, so when your puppy is placed in it, he still feels a part of the family.  If the pen is central in the house the puppy will also learn to accept the normal household &amp; kitchen noises and activities.  It should be big enough for a bed or crate, a toilet area and small area for chewing toys.\r\n\r\nPlacing your puppy in a pen should teach them that it is time to rest.  You may need to secure the pen at the corners so your pup cannot push it over. Provide a delicious chew or raw meaty bone or chew toys to give your puppy something that will help them relax.\r\n\r\nYou should plan to be home for the first week you have your puppy so you can help them settle into their new home and routine.  Introduce the puppy to the pen by feeding all meals or treats in the pen.  This will create a good association to the pen.  Once your puppy is settled and comfortable with the pen, you should start home alone training.\r\n\r\nTo help with a smooth transition, there are 3 stages of alone time you can introduce:\r\n<ul>\r\n 	<li>Puppy is in the secure pen while you are within sight but occupied with another task;</li>\r\n 	<li>Puppy is in the secure pen while you are out of sight, in another room;</li>\r\n 	<li>Puppy is in the secure pen while you leave the house</li>\r\n</ul>\r\n<img class=\"alignnone size-full wp-image-205144 alignleft\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2020/04/golden-retriever-sleeping.png\" alt=\"\" width=\"211\" height=\"159\" />\r\n\r\nIntroduce alone time for your puppy slowly, starting with leaving them in a puppy pen with a chew when you are occupied with another activity such as working on your computer.  If your puppy whimpers or cries, do not be tempted to turn around or go to your puppy.  If you do, your puppy will learn that crying is a way to get your attention, and for sure they will do it again.  Wait for the puppy to quiet before approaching them. You may feel more comfortable setting up camera on a tablet or smart phone so you can surreptitiously observe your puppy to make sure that                                                              crying &amp; noise isn’t due to their paw caught in the pen.\r\n\r\nYour puppy should learn to settle at each stage of the process before moving on to the next step.  When you start to leave the house, begin slowly, only leaving the home for short periods of times.  Provide yummy food toys (enrichment) when you leave to create a positive association for when the front door closes. It is very helpful to know exactly what your puppy is doing when you leave, so use in home cameras, or record them on a tablet or smart phone.\r\n\r\nOnce you are leaving your puppy for longer and longer periods, ask your neighbours to let you know if they hear them crying, whimpering or barking.  It’s very important for you to know exactly how your puppy copes when alone and having this information will help you provide a smooth transition from constant supervision to snoozy, relaxed alone time.\r\n<ul>\r\n 	<li>Trial all the food toys several times to ensure your puppy is safe and they know how to use them before leaving them unsupervised.</li>\r\n 	<li>Provide several chew toys in addition to the food toys and rotate all of them to keep them fresh and fun for your pup.</li>\r\n 	<li>Only give these special toys and treats when the pup will be left alone. This helps make your absence fun and something to look forward to.</li>\r\n 	<li>When leaving your pup, keep your exit and return routine calm and relaxed. Leaving and returning should be non-events rather than exciting ones. When the humans leave and return, it’s just ‘normal’ parts of your pup’s day.</li>\r\n 	<li>For all separations, call you pup to their puppy pen, quietly say goodbye, which becomes the cue that you are leaving and good stuff (chew toys and food toys) is about to happen. When practicing, use the same routine and wear your ‘going out’ shoes as you would if you were leaving for work or going shopping.</li>\r\n 	<li>Ensure your pup has a place to sleep and rest, a place to toilet, water, appropriate chew items and toys.</li>\r\n 	<li>When you begin to practice it helps to have a pup who has had some exercise and is ready for a nap. Therefore, plan your training times.</li>\r\n 	<li>Mix up the difficulty (length) of the absence and don’t always just make it harder. Sometimes your departure should be shorter, or stay the same length, sometimes longer.  Mix it up so the length of time they will be left alone is not predictable.</li>\r\n</ul>\r\n<strong>Other Things That Can Help</strong>\r\n<ul>\r\n 	<li>Put out a call to your family &amp; friends to ask for volunteer dog sitters – a person dropping in at lunchtime for a play or activity outside can help to break up a long day of alone time.</li>\r\n 	<li>You might be working from home now, so ask your boss if you can work from home in the future if your pup needs more time to learn how to be comfortable for long periods.</li>\r\n 	<li>Our dogs are VERY observant. Your puppy will quickly learn which of your shoes or clothes means you are staying or leaving.  When you are practicing, ensure you leave home as you would do when you go shopping, leave for work etc.  Take the car if you drive or walk up the street if you don’t.</li>\r\n 	<li>Don’t be tempted to try leaving your puppy outside while you remain inside. Leave the home area so your dog can’t hear or smell you. Most dogs of all ages know when you’re hiding inside and will whimper, bark or scratch to get to you, regardless of how clever you think you’ve been!</li>\r\n 	<li>Your puppy needs to know you are not home, and that they are alone.</li>\r\n</ul>\r\n<strong> Sample </strong><strong>Schedule</strong>\r\n\r\n<strong>Day 1-7</strong> Stay at home with your pup so they are fully supervised and managed.  Practice steps 1 and 2 above so that your pup is introduced to being in their pen while you move out of sight. After the first week you can start to implement an alone schedule.  An example of what this might look like is below. However, it is important to observe your puppy and work at the rate that they can accept.\r\n\r\nMix up the length of your absence. Toggle up and down so that it doesn’t just always get longer and longer.  This helps to stop our pup anticipating what’s about to happen.\r\n\r\n<strong>Day 8    </strong>Leave house for 2 minutes                                     <strong>Day 15</strong> Leave pup for 1.5 hours\r\n\r\n<strong>Day 9</strong>    Leave pup for 5 minutes                                         <strong>Day 16 </strong>Leave pup for 2.5 hours\r\n\r\n<strong>Day 10  </strong>Leave pup for 10 minutes                                       <strong>Day 17 </strong>Leave pup for 2 hours\r\n\r\n<strong>Day 11</strong> Leave pup for 20 minutes                                        <strong>Day 18 </strong>Leave pup for 3 hours\r\n\r\n<strong>Day 12</strong> Leave pup for 35 minutes                                        <strong>Day 19 </strong>Leave pup for 4 hours\r\n\r\n<strong>Day 13</strong>  Leave pup for 1hour                                                <strong>Day 20</strong> Leave pup for 3 hours\r\n\r\n<strong>Day 14</strong>  Leave pup for 45 minutes                                        <strong>Day 21 </strong>Leave pup for 5 hours\r\n\r\n<strong>                                                    Day 22 </strong>Leave pup for 7 hours\r\n\r\nEvery puppy is different, and you need to assess how well your pup is handling the alone time and adjust accordingly.  Video your puppy on a tablet or use an App so you can monitor your pup’s progress.  Don’t rush this process, it is better to take things slowly, rather than to leave your puppy home alone too quickly or for too long.  Once you reach 3 hours, most pups can cope with the alone time being extended by one-hour increments.\r\n\r\nIf you provide a variety food-based toys and chews each time you leave, in no time your pup will actually look forward to you leaving just so they can find all the chew toys, treat balls and stuffed Kongs hidden in their area.\r\n\r\n<img class=\"alignnone size-medium wp-image-205145 alignright\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2020/04/sleeping-lab-puppy-300x200.jpg\" alt=\"\" width=\"300\" height=\"200\" />\r\n\r\nThe area you leave your puppy should be contained and secure.  For many dogs being left inside provides a quieter environment for settling and ensure they have an area to toilet, which they have been trained to use. But if they are outside, ensure the fences are tall and secure to prevent escapes. They need several shade areas especially in summer, and cover from rain.  Provide at least two water bowls so they have a constant supply of cool fresh water, two beds, shelter for protection from rain or adverse weather.\r\n\r\nChanges in the home environment can sometimes cause a dog who was previously relaxed when alone, to become anxious about being left.  In the future, if you move to a new house, if there is a change to the people living in your house, or you add another dog to your household, it’s a good idea to practice home alone as a training exercise to ensure the changes do not cause separation distress for your dog.\r\n\r\nMost puppies learn quite quickly that being alone is just fine.  But if your puppy is barking &amp; yelping for an extended period, is destructive or toilets constantly when you leave the house, then it’s time to seek help from a suitably qualified separation trainer. Click <a href=\"https://jhdogtraining.com.au/contact/\">here</a> to contact Jenny.\r\n\r\n&nbsp;', 'Home Alone Training for Puppy', '', 'publish', 'open', 'open', '', 'home-alone-training-for-puppy', '', '', '2020-04-27 08:09:46', '2020-04-27 08:09:46', '', '0', 'https://jhdogtraining.com.au/?p=205146', '0', 'post', '', '0'),
('205148', '2', '2020-04-26 13:35:02', '2020-04-26 13:35:02', '', 'iwp_log_5ea7108ef38d8', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ea7108ef38d8', '', '', '2020-04-26 13:35:02', '2020-04-26 13:35:02', '', '0', 'https://jhdogtraining.com.au/iwp_log_5ea7108ef38d8/', '0', 'iwp_log', '', '0'),
('205149', '2', '2020-05-03 00:00:03', '2020-05-03 00:00:03', '', 'iwp_log_5eb14acb5c40e', '', 'publish', 'closed', 'closed', '', 'iwp_log_5eb14acb5c40e', '', '', '2020-05-03 00:00:03', '2020-05-03 00:00:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5eb14acb5c40e/', '0', 'iwp_log', '', '0'),
('205150', '2', '2020-05-07 05:54:40', '2020-05-07 05:54:40', '', 'iwp_log_5eb43d6c8926c', '', 'publish', 'closed', 'closed', '', 'iwp_log_5eb43d6c8926c', '', '', '2020-05-07 05:54:40', '2020-05-07 05:54:40', '', '0', 'https://jhdogtraining.com.au/iwp_log_5eb43d6c8926c/', '0', 'iwp_log', '', '0'),
('205151', '2', '2020-05-10 00:05:03', '2020-05-10 00:05:03', '', 'iwp_log_5eb7eedf3e614', '', 'publish', 'closed', 'closed', '', 'iwp_log_5eb7eedf3e614', '', '', '2020-05-10 00:05:03', '2020-05-10 00:05:03', '', '0', 'https://jhdogtraining.com.au/iwp_log_5eb7eedf3e614/', '0', 'iwp_log', '', '0'),
('205154', '2', '2020-05-12 12:17:57', '2020-05-12 12:17:57', '', 'iwp_log_5ebb2eb656eea', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ebb2eb656eea', '', '', '2020-05-12 12:17:57', '2020-05-12 12:17:57', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5ebb2eb656eea/', '0', 'iwp_log', '', '0'),
('205155', '2', '2020-05-12 12:17:58', '2020-05-12 12:17:58', '', 'iwp_log_5ebb2ec1cbd17', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ebb2ec1cbd17', '', '', '2020-05-12 12:17:58', '2020-05-12 12:17:58', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5ebb2ec1cbd17/', '0', 'iwp_log', '', '0'),
('205156', '2', '2020-05-17 00:10:03', '2020-05-17 00:10:03', '', 'iwp_log_5ec1a26a0f089', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ec1a26a0f089', '', '', '2020-05-17 00:10:03', '2020-05-17 00:10:03', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5ec1a26a0f089/', '0', 'iwp_log', '', '0'),
('205157', '2', '2020-05-21 07:32:04', '2020-05-21 07:32:04', '', 'iwp_log_5ec6c942381cd', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ec6c942381cd', '', '', '2020-05-21 07:32:04', '2020-05-21 07:32:04', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5ec6c942381cd/', '0', 'iwp_log', '', '0'),
('205158', '2', '2020-05-21 07:32:04', '2020-05-21 07:32:04', '', 'iwp_log_5ec6c94c3ad72', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ec6c94c3ad72', '', '', '2020-05-21 07:32:04', '2020-05-21 07:32:04', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5ec6c94c3ad72/', '0', 'iwp_log', '', '0'),
('205159', '2', '2020-05-21 07:32:04', '2020-05-21 07:32:04', '', 'iwp_log_5ec6c9580e67b', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ec6c9580e67b', '', '', '2020-05-21 07:32:04', '2020-05-21 07:32:04', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5ec6c9580e67b/', '0', 'iwp_log', '', '0'),
('205161', '2', '2020-05-24 00:00:04', '2020-05-24 00:00:04', '', 'iwp_log_5ecc483214d26', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ecc483214d26', '', '', '2020-05-24 00:00:04', '2020-05-24 00:00:04', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5ecc483214d26/', '0', 'iwp_log', '', '0'),
('205162', '2', '2020-06-04 07:43:53', '2020-06-04 07:43:53', '', 'iwp_log_5ed940fe64807', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ed940fe64807', '', '', '2020-06-04 07:43:53', '2020-06-04 07:43:53', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5ed940fe64807/', '0', 'iwp_log', '', '0'),
('205163', '2', '2020-05-31 00:05:04', '2020-05-31 00:05:04', '', 'iwp_log_5ed9423f809fd', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ed9423f809fd', '', '', '2020-05-31 00:05:04', '2020-05-31 00:05:04', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5ed9423f809fd/', '0', 'iwp_log', '', '0'),
('205164', '2', '2020-06-07 00:05:03', '2020-06-07 00:05:03', '', 'iwp_log_5edcdb0ec6304', '', 'publish', 'closed', 'closed', '', 'iwp_log_5edcdb0ec6304', '', '', '2020-06-07 00:05:03', '2020-06-07 00:05:03', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5edcdb0ec6304/', '0', 'iwp_log', '', '0'),
('205165', '2', '2020-06-11 06:14:10', '2020-06-11 06:14:10', '', 'iwp_log_5ee2669b48484', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ee2669b48484', '', '', '2020-06-11 06:14:10', '2020-06-11 06:14:10', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5ee2669b48484/', '0', 'iwp_log', '', '0'),
('205166', '2', '2020-06-11 06:14:10', '2020-06-11 06:14:10', '', 'iwp_log_5ee266a683ef6', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ee266a683ef6', '', '', '2020-06-11 06:14:10', '2020-06-11 06:14:10', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5ee266a683ef6/', '0', 'iwp_log', '', '0'),
('205167', '2', '2020-06-11 06:14:10', '2020-06-11 06:14:10', '', 'iwp_log_5ee266b0ec98f', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ee266b0ec98f', '', '', '2020-06-11 06:14:10', '2020-06-11 06:14:10', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5ee266b0ec98f/', '0', 'iwp_log', '', '0'),
('205168', '2', '2020-06-11 06:19:24', '2020-06-11 06:19:24', '', 'iwp_log_5ee267b7227be', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ee267b7227be', '', '', '2020-06-11 06:19:24', '2020-06-11 06:19:24', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5ee267b7227be/', '0', 'iwp_log', '', '0'),
('205169', '2', '2020-06-11 06:30:49', '2020-06-11 06:30:49', '', 'iwp_log_5ee26a6d268ce', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ee26a6d268ce', '', '', '2020-06-11 06:30:49', '2020-06-11 06:30:49', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5ee26a6d268ce/', '0', 'iwp_log', '', '0'),
('205170', '2', '2020-06-14 00:00:05', '2020-06-14 00:00:05', '', 'iwp_log_5ee7f9fa10b86', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ee7f9fa10b86', '', '', '2020-06-14 00:00:05', '2020-06-14 00:00:05', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5ee7f9fa10b86/', '0', 'iwp_log', '', '0'),
('205177', '2', '2020-06-21 00:00:04', '2020-06-21 00:00:04', '', 'iwp_log_5ef202bc395b4', '', 'publish', 'closed', 'closed', '', 'iwp_log_5ef202bc395b4', '', '', '2020-06-21 00:00:04', '2020-06-21 00:00:04', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5ef202bc395b4/', '0', 'iwp_log', '', '0'),
('205178', '2', '2020-06-28 01:50:03', '2020-06-28 01:50:03', '', 'iwp_log_5efec4c0d82c3', '', 'publish', 'closed', 'closed', '', 'iwp_log_5efec4c0d82c3', '', '', '2020-06-28 01:50:03', '2020-06-28 01:50:03', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5efec4c0d82c3/', '0', 'iwp_log', '', '0'),
('205179', '2', '2020-07-05 00:00:03', '2020-07-05 00:00:03', '', 'iwp_log_5f0748d87d250', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f0748d87d250', '', '', '2020-07-05 00:00:03', '2020-07-05 00:00:03', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f0748d87d250/', '0', 'iwp_log', '', '0'),
('205180', '2', '2020-07-09 06:33:53', '2020-07-09 06:33:53', '', 'iwp_log_5f0755155fd78', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f0755155fd78', '', '', '2020-07-09 06:33:53', '2020-07-09 06:33:53', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f0755155fd78/', '0', 'iwp_log', '', '0'),
('205181', '2', '2020-07-09 06:33:54', '2020-07-09 06:33:54', '', 'iwp_log_5f07552231131', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f07552231131', '', '', '2020-07-09 06:33:54', '2020-07-09 06:33:54', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f07552231131/', '0', 'iwp_log', '', '0'),
('205182', '2', '2020-07-09 06:33:55', '2020-07-09 06:33:55', '', 'iwp_log_5f0755310f5d1', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f0755310f5d1', '', '', '2020-07-09 06:33:55', '2020-07-09 06:33:55', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f0755310f5d1/', '0', 'iwp_log', '', '0'),
('205183', '2', '2020-07-09 06:33:58', '2020-07-09 06:33:58', '', 'iwp_log_5f07553f9153a', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f07553f9153a', '', '', '2020-07-09 06:33:58', '2020-07-09 06:33:58', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f07553f9153a/', '0', 'iwp_log', '', '0'),
('205184', '2', '2020-07-12 00:20:03', '2020-07-12 00:20:03', '', 'iwp_log_5f1116ab77b23', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f1116ab77b23', '', '', '2020-07-12 00:20:03', '2020-07-12 00:20:03', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f1116ab77b23/', '0', 'iwp_log', '', '0');
/**ABDB**/INSERT INTO `wp_posts`  VALUES 
('205187', '2', '2020-07-21 01:53:16', '2020-07-21 01:53:16', '&nbsp;\r\n\r\nIf you have recently become the guardian of a new puppy, you are no doubt enjoying lots of cuddles and games with your delightful new fur-friend.  If you’re home more than normal at the moment, it’s easy to spend most of the day in each other’s company.  The first step in helping your puppy be confident and comfortable in their new home, is developing a strong bond with you, the #1-human.  Those cuddles and games are important in the bonding process, so go fo it!  Once your puppy has settled in, they also need to learn that being alone is just fine as well.  If you are struggling to help your pup learn to be alone, here are some guidelines to get them on track with this very important skill.\r\n\r\nAs part of your pup’s toilet training and management strategy, you might have already established a confinement area or pen for them.  This area is a safe place for them to rest when your attention is elsewhere, a place for them to be when you go out, and a great place for a nap during the day. If you haven’t already set this up, it’s not too late.\r\n\r\n<img class=\"wp-image-205188 aligncenter\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2020/07/puppy-in-pen-300x195.jpg\" alt=\"\" width=\"304\" height=\"198\" />\r\n\r\nThe key with this special area, and to introducing alone time, is that your pup must LOVE being there!  It’s not a prison, it’s a wonderland!  There should be a toilet area, a bed, chew toys and a water bowl.  When it’s mealtime, they can be fed in the pen. Introduce favourite chews in the pen, because chewing (on appropriate items) is a great calming activity for dogs of any age.  Ensure the chew-project is appropriate for their age, size &amp; chew style.  Let your pup audition various chew items in the pen and see which suits them best. Remember to always supervise your pup with chew items to ensure they are safe.\r\n\r\nA general note about the process below: Your pup should not be worked up at any stage. By breaking down the departure steps, our aim is for our pup to ignore us! Your “coming and going” need to be a normal part of the day not a stress filled event.  If your pup is crying incessantly or barking, go back to an easier step for a short period, and when you do move ahead, make the next step a smaller increase in difficulty level.\r\n\r\nYour aim, at each step, is to return while your pup is relaxed.\r\n\r\nIf, during one of the steps below your pup suddenly starts crying or barking, often they will not be able to calm themselves down and their distress will continue to escalate.  In this instance, it’s best that you return and gently calm them down with a soothing word or gentle pat through the pen. Make a note of how long you were out of sight so that you can choose an easier step when you next do the training.\r\n\r\n<strong>Step One:</strong> Start the training when your pup has had a play and a run around, they’ve pooped and peed, and are ready for a nap. Place them in the area and give them a chew.  You should hang out nearby, in view but make it clear you’re not available – turn your back, check emails, make a phone call.  Give them their favourite chew to help them settle.\r\n\r\nDon’t rush through this step, your pup should learn that the going into the pen is a cue to chill-out.  Hang out nearby in view, so they feel safe.\r\n\r\n<strong>Step Two:</strong> When your pup is lying down, or happily engaged in chewing, you can start to move partially out of view. Partially out of view means they can still see that you’re nearby, but not all of you.  Toggle between fully in view and partially out of view.\r\n\r\n<strong>Step Three:</strong> You guessed it – toggle between moving out of sight and partially in view. If your pup is worried about this, spend a little longer on Step Two.  When you do start Step Three, the move out of sight should be very small.\r\n\r\n<strong>Step Four:</strong> When your pup is not worried about you being fully out of sight, you can start to incorporate you walking to the front door the sound of the front door opening.  Some pups will be fine with this.  If your pup isn’t fine with this, you need to slice the steps into smaller increments.  You might walk partially to the front door, then return.  You might turn the front door handle without actually opening the door. Adapt the process to your circumstance and environment.\r\n\r\n<strong>Step Five:</strong> You’re out the door.  Keep watching your pup through a camera so you can monitor progress.  Don’t always make the absence longer and longer – if your pup is at all concerned, they might anticipate that each step is just getting harder, making them uncomfortable.\r\n\r\nHere is an example of how to extend your absences day by day:\r\n\r\nDay 1: 1-minute                                                        Day 8: 30 minutes\r\n\r\nDay 2: 3 minutes                                                      Day 9: 1 hour\r\n\r\nDay 3: 10 minutes                                                    Day 10: 1 hour 15 minutes\r\n\r\nDay 4: 15 minutes                                                    Day 11: 1.5hours\r\n\r\nDay 5: 12 minutes                                                    Day 12: 1 hour\r\n\r\nDay 6: 20 minutes                                                    Day 13: 2 hours\r\n\r\nDay 7: 40 minutes                                                    Day 14: 3 hours\r\n\r\nAnd then you just continue to extend the duration as required. Once your pup reaches about 3 hours happily alone, you can move ahead in increments of about one-hour.\r\n\r\n<img class=\"alignnone size-full wp-image-205144 alignright\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2020/04/golden-retriever-sleeping.png\" alt=\"\" width=\"211\" height=\"159\" /><strong>Trouble Shooting</strong>\r\n\r\nActivities such as sniffing and searching for food not only entertain our pups but help them to relax.  To create this, use a snuffle mat, scatter feed by sprinkling dry food in the pen, or hide cardboard rolls containing special food in the pen.  Not only do they help create a calm relaxed pup, they help to create a good association with the pen.\r\n\r\nFood toys that make a loud noise or are designed to be knocked about, like a treat ball or a wobble food dispenser, are exciting. A pup that plays with these is likely to be very excited and fired up after using them, which is counter-productive to our aim in this instance. Save these exciting food toys for other times.\r\n\r\nObserve your puppy, know what they are doing when you go out of sight. If you don’t have an in-home camera, it’s easy to set up a FaceTime, Skype or Zoom session on two devices so that you can observe them. This gives you the information you need in deciding if it’s time for your pup to move ahead or go back a step for short time.\r\n\r\nAll pups are different and learn these steps at different rates.  In any of the training you do with your dog over their lifetime, it’s always important to observe and work according to the dog you see in front of you. If your pup is struggling, go back a step and ask yourself “how can I split the training into smaller steps to help my puppy succeed?”.  By being observant and choosing appropriate steps, your puppy will be happily snoozing at home alone before you know it.\r\n\r\nIf you are not sure how to proceed, click <a href=\"https://jhdogtraining.com.au/contact/\">here</a>  to contact Jenny and so you can help your puppy learn that it’s OK to be home alone.\r\n\r\n© Jenny Harlow July 2020', 'Does Your Puppy Struggle When Alone?', '', 'publish', 'closed', 'closed', '', 'does-your-puppy-struggle-when-alone', '', '', '2020-07-21 01:54:19', '2020-07-21 01:54:19', '', '0', 'https://jhdogtraining.com.au/?page_id=205187', '0', 'page', '', '0'),
('205188', '2', '2020-07-21 01:44:26', '2020-07-21 01:44:26', '', 'puppy in pen', '', 'inherit', 'open', 'closed', '', 'puppy-in-pen', '', '', '2020-07-21 01:44:26', '2020-07-21 01:44:26', '', '205187', 'https://jhdogtraining.com.au/wp-content/uploads/2020/07/puppy-in-pen.jpg', '0', 'attachment', 'image/jpeg', '0'),
('205190', '2', '2020-07-22 13:13:14', '2020-07-22 13:13:14', '', 'iwp_log_5f18d6274aa5f', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f18d6274aa5f', '', '', '2020-07-22 13:13:14', '2020-07-22 13:13:14', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f18d6274aa5f/', '0', 'iwp_log', '', '0'),
('205191', '2', '2020-07-22 13:13:14', '2020-07-22 13:13:14', '', 'iwp_log_5f18d637f3122', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f18d637f3122', '', '', '2020-07-22 13:13:14', '2020-07-22 13:13:14', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f18d637f3122/', '0', 'iwp_log', '', '0'),
('205193', '2', '2020-07-29 03:27:05', '2020-07-29 03:27:05', 'I have blogged before about training steps to introduce home alone to a new pup, but the reality is that some pups take to this quicker than others.  If your pup is struggling, here is some more detailed information to help get the process back on track.\r\n\r\nIf you are have recently become the guardian of a new puppy, you are no doubt enjoying lots of cuddles and games with your delightful new fur-friend.  If you’re home more than normal at the moment, it’s easy to spend most of the day in each other’s company.  The first step in helping your puppy be confident and comfortable in their new home, is developing a strong bond with you, the #1human.  Those cuddles and games are important in the bonding process, but they also need to learn that being alone is just fine as well.  If you are struggling to help your pup learn to be alone, here are some guidelines to get them on track with this very important skill.\r\n\r\nAs part of your pup’s toilet training and management strategy, you might have already established a confinement area or pen for them.  This area is a safe place for them to rest when your attention is elsewhere, a place for them to be when you go out, and a great place for a nap during the day. If you haven’t already set this up, it’s not too late.\r\n\r\n<img class=\"size-medium wp-image-205188 aligncenter\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2020/07/puppy-in-pen-300x195.jpg\" alt=\"\" width=\"300\" height=\"195\" />\r\n\r\nThe key with this special area, and to introducing alone time, is that your pup must LOVE being there!  It’s not a prison, it’s a wonderland!  There should be a toilet area, a bed, chew toys and a water bowl.  When it’s mealtime, they can be fed in the pen. Introduce favourite chews in the pen, because chewing (on appropriate items) is a great calming activity for dogs of any age.  Ensure the chew-project is appropriate for their age, size &amp; chew style.  Let your pup audition various chew items in the pen and see which suits them best. Remember to always supervise your pup with chew items to ensure they are safe.\r\n\r\nA general note about the process below: Your pup should not be worked up at any stage. By breaking down the departure steps, our aim is for our pup to ignore us! You “coming and going” should be a normal part of the day not a stress filled event.  If your pup is crying incessantly or barking, go back to an easier step for a short period, and when you do move ahead, make the next step a smaller increase in difficulty level.\r\n\r\nYour aim, at each step, is to return while your pup is relaxed. <img class=\"wp-image-205144 alignright\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2020/04/golden-retriever-sleeping.png\" alt=\"\" width=\"163\" height=\"123\" />\r\n\r\nIf, during one of the steps below your pup suddenly starts crying or barking, often they will not be able to calm themselves down and their distress will continue to escalate.  In this instance, it’s best that you return and gently calm them down with a soothing word or gentle pat through the pen. Make a note of how long you were out of sight so that you can choose an easier step when you next do the training.\r\n\r\n<strong>Step One:</strong> Start the training when your pup has had a play and a run around, they’ve pooped and peed, and are ready for a nap. Place them in the area and give them a chew.  You should hang out nearby, in view but make it clear you’re not available – turn your back, check emails, make a phone call.  Give them their favourite chew to help them settle.\r\n\r\nDon’t rush through this step, your pup should learn that the going into the pen is a cue to chill-out.  Hang out nearby in view, so they feel safe.\r\n\r\n<strong>Step Two:</strong> When your pup is lying down, or happily engaged in chewing, you can start to move partially out of view. Partially out of view means they can still see that you’re nearby, but not all of you.  Toggle between fully in view and partially out of view.\r\n\r\n<strong>Step Three:</strong> You guessed it – toggle between moving out of sight and partially in view. If your pup is worried about this, spend a little longer on Step Two.  When you do start Step Three, the move out of sight should be very small.\r\n\r\n<strong>Step Four:</strong> When your pup is not worried about you being fully out of sight, you can start to incorporate you walking to the front door the sound of the front door opening.  Some pups will be fine with this.  If your pup isn’t fine with this, you need to slice the steps into smaller increments.  You might walk partially to the front door, then return.  You might turn the front door handle without actually opening the door. Adapt the process to your circumstance and environment.\r\n\r\n<strong>Step Five:</strong> You’re out the door.  Keep watching your pup through a camera so you can monitor progress.  Don’t always make the absence longer and longer – if your pup is at all concerned, they might anticipate that each step is just getting harder, making them uncomfortable.\r\n\r\nHere is an example of how to extend your absences day by day:\r\n\r\nDay 1: 1-minute                                                        Day 8: 30 minutes\r\n\r\nDay 2: 3 minutes                                                      Day 9: 1 hour\r\n\r\nDay 3: 10 minutes                                                    Day 10: 1 hour 15 minutes\r\n\r\nDay 4: 15 minutes                                                    Day 11: 1.5hours\r\n\r\nDay 5: 12 minutes                                                    Day 12: 1 hour\r\n\r\nDay 6: 20 minutes                                                    Day 13: 2 hours\r\n\r\nDay 7: 40 minutes                                                    Day 14: 3 hours\r\n\r\n<img class=\"wp-image-205143 alignleft\" src=\"https://jhdogtraining.com.au/wp-content/uploads/2020/04/puppy-sleeping-300x200.jpg\" alt=\"\" width=\"167\" height=\"111\" />\r\n\r\nFrom this point, you just continue to extend the duration as required. Once your pup reaches about 3 hours happily alone, you can move ahead in increments of about one-hour.\r\n\r\n&nbsp;\r\n\r\n<strong>Trouble Shooting</strong>\r\n\r\nActivities such as sniffing and searching for food not only entertain our pups but help them to relax.  To create this, use a snuffle mat, scatter feed by sprinkling dry food in the pen, or hide cardboard rolls containing special food in the pen.  Not only do they help create a calm relaxed pup, they help to create a good association with the pen.\r\n\r\nFood toys that make a loud noise or are designed to be knocked about, like a treat ball or a wobble food dispenser, are exciting. A pup that plays with these is likely to be very excited and fired up after using them, which is counter-productive to our aim in this instance. Save these exciting food toys for other times.\r\n\r\nObserve your puppy, know what they are doing when you go out of sight. If you don’t have an in-home camera, it’s easy to set up a FaceTime, Skype or Zoom session on two devices so that you can observe them. This gives you the information you need in deciding if it’s time for your pup to move ahead or go back a step for short time.\r\n\r\nAll pups are different and learn these steps at different rates.  In any of the training you do with your dog over their lifetime, it’s always important to observe and work according to the dog you see in front of you. If your pup is struggling, go back a step and ask yourself “how can I split the training into smaller steps to help my puppy succeed?”.  By being observant and choosing appropriate steps, your puppy will be happily snoozing at home alone before you know it.\r\n\r\nIf you need help with your puppy, <a href=\"https://jhdogtraining.com.au/contact/\">click here</a>\r\n\r\n&nbsp;', 'Teaching Puppy \"It\'s OK to be Home Alone\"', '', 'publish', 'open', 'open', '', 'teaching-puppy-its-ok-to-be-home-alone', '', '', '2020-07-29 03:27:14', '2020-07-29 03:27:14', '', '0', 'https://jhdogtraining.com.au/?p=205193', '0', 'post', '', '0'),
('205195', '2', '2020-07-26 00:10:04', '2020-07-26 00:10:04', '', 'iwp_log_5f2365021f4ba', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f2365021f4ba', '', '', '2020-07-26 00:10:04', '2020-07-26 00:10:04', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f2365021f4ba/', '0', 'iwp_log', '', '0'),
('205196', '2', '2020-08-02 00:10:04', '2020-08-02 00:10:04', '', 'iwp_log_5f2c4339e2063', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f2c4339e2063', '', '', '2020-08-02 00:10:04', '2020-08-02 00:10:04', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f2c4339e2063/', '0', 'iwp_log', '', '0'),
('205197', '2', '2020-08-06 09:31:30', '2020-08-06 09:31:30', '', 'iwp_log_5f2c68d42b4ba', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f2c68d42b4ba', '', '', '2020-08-06 09:31:30', '2020-08-06 09:31:30', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f2c68d42b4ba/', '0', 'iwp_log', '', '0'),
('205198', '2', '2020-08-06 09:31:31', '2020-08-06 09:31:31', '', 'iwp_log_5f2c68ed5e1a0', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f2c68ed5e1a0', '', '', '2020-08-06 09:31:31', '2020-08-06 09:31:31', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f2c68ed5e1a0/', '0', 'iwp_log', '', '0'),
('205199', '2', '2020-08-06 09:31:32', '2020-08-06 09:31:32', '', 'iwp_log_5f2c68fdb7264', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f2c68fdb7264', '', '', '2020-08-06 09:31:32', '2020-08-06 09:31:32', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f2c68fdb7264/', '0', 'iwp_log', '', '0'),
('205200', '2', '2020-08-06 09:31:33', '2020-08-06 09:31:33', '', 'iwp_log_5f2c690d8d416', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f2c690d8d416', '', '', '2020-08-06 09:31:33', '2020-08-06 09:31:33', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f2c690d8d416/', '0', 'iwp_log', '', '0'),
('205207', '2', '2020-08-09 00:25:04', '2020-08-09 00:25:04', '', 'iwp_log_5f388777c2690', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f388777c2690', '', '', '2020-08-09 00:25:04', '2020-08-09 00:25:04', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f388777c2690/', '0', 'iwp_log', '', '0'),
('205208', '2', '2020-08-16 00:10:05', '2020-08-16 00:10:05', '', 'iwp_log_5f3acf4d66be3', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f3acf4d66be3', '', '', '2020-08-16 00:10:05', '2020-08-16 00:10:05', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f3acf4d66be3/', '0', 'iwp_log', '', '0'),
('205212', '2', '2020-08-21 16:05:30', '2020-08-21 16:05:30', '', 'dog-training', '', 'inherit', 'open', 'closed', '', 'dog-training', '', '', '2020-08-21 16:05:30', '2020-08-21 16:05:30', '', '0', 'https://jhdogtraining.com.au/wp-content/uploads/2020/08/dog-training.jpg', '0', 'attachment', 'image/jpeg', '0'),
('205214', '2', '2020-08-21 16:07:23', '2020-08-21 16:07:23', '', 'dog-training-banner', '', 'inherit', 'open', 'closed', '', 'dog-training-banner', '', '', '2020-08-21 16:07:23', '2020-08-21 16:07:23', '', '0', 'https://jhdogtraining.com.au/wp-content/uploads/2020/08/dog-training-banner.jpg', '0', 'attachment', 'image/jpeg', '0'),
('205215', '2', '2020-08-21 16:08:15', '2020-08-21 16:08:15', '', 'dog-training-banner-2', '', 'inherit', 'open', 'closed', '', 'dog-training-banner-2', '', '', '2020-08-21 16:08:15', '2020-08-21 16:08:15', '', '0', 'https://jhdogtraining.com.au/wp-content/uploads/2020/08/dog-training-banner-2.jpg', '0', 'attachment', 'image/jpeg', '0'),
('205217', '2', '2020-08-23 06:05:39', '2020-08-23 06:05:39', '', 'iwp_log_5f420733a9cac', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f420733a9cac', '', '', '2020-08-23 06:05:39', '2020-08-23 06:05:39', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f420733a9cac/', '0', 'iwp_log', '', '0'),
('205218', '2', '2020-08-23 06:05:46', '2020-08-23 06:05:46', '', 'iwp_log_5f42073a4efb8', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f42073a4efb8', '', '', '2020-08-23 06:05:46', '2020-08-23 06:05:46', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f42073a4efb8/', '0', 'iwp_log', '', '0'),
('205219', '2', '2020-08-23 06:07:28', '2020-08-23 06:07:28', '', 'iwp_log_5f4207a056ab6', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f4207a056ab6', '', '', '2020-08-23 06:07:28', '2020-08-23 06:07:28', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f4207a056ab6/', '0', 'iwp_log', '', '0'),
('205220', '2', '2020-08-23 06:07:41', '2020-08-23 06:07:41', '', 'iwp_log_5f4207ad37ee7', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f4207ad37ee7', '', '', '2020-08-23 06:07:41', '2020-08-23 06:07:41', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f4207ad37ee7/', '0', 'iwp_log', '', '0'),
('205221', '2', '2020-08-23 06:07:52', '2020-08-23 06:07:52', '', 'iwp_log_5f4207b86473b', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f4207b86473b', '', '', '2020-08-23 06:07:52', '2020-08-23 06:07:52', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f4207b86473b/', '0', 'iwp_log', '', '0'),
('205222', '2', '2020-08-23 06:08:25', '2020-08-23 06:08:25', '', 'iwp_log_5f4207d991a2f', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f4207d991a2f', '', '', '2020-08-23 06:08:25', '2020-08-23 06:08:25', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f4207d991a2f/', '0', 'iwp_log', '', '0'),
('205223', '2', '2020-08-26 21:48:00', '2020-08-26 21:48:00', '', 'iwp_log_5f46d8901d40d', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f46d8901d40d', '', '', '2020-08-26 21:48:00', '2020-08-26 21:48:00', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f46d8901d40d/', '0', 'iwp_log', '', '0'),
('205224', '2', '2020-08-26 21:48:04', '2020-08-26 21:48:04', '', 'iwp_log_5f46d8943d6ae', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f46d8943d6ae', '', '', '2020-08-26 21:48:04', '2020-08-26 21:48:04', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f46d8943d6ae/', '0', 'iwp_log', '', '0'),
('205225', '2', '2020-08-26 21:48:08', '2020-08-26 21:48:08', '', 'iwp_log_5f46d898ae025', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f46d898ae025', '', '', '2020-08-26 21:48:08', '2020-08-26 21:48:08', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f46d898ae025/', '0', 'iwp_log', '', '0'),
('205226', '2', '2020-08-23 00:40:03', '2020-08-23 00:40:03', '', 'iwp_log_5f479137ef8aa', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f479137ef8aa', '', '', '2020-08-23 00:40:03', '2020-08-23 00:40:03', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f479137ef8aa/', '0', 'iwp_log', '', '0'),
('205227', '0', '2020-08-27 21:43:29', '2020-08-27 21:43:29', '', 'iwp_log_5f48290155c5e', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f48290155c5e', '', '', '2020-08-27 21:43:29', '2020-08-27 21:43:29', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f48290155c5e/', '0', 'iwp_log', '', '0'),
('205230', '2', '2020-08-28 16:21:06', '2020-08-28 16:21:06', '', 'walk with my dog cropped', '', 'inherit', 'open', 'closed', '', 'walk-with-my-dog-cropped', '', '', '2020-08-28 16:21:06', '2020-08-28 16:21:06', '', '0', 'https://jhdogtraining.com.au/wp-content/uploads/2020/08/walk-with-my-dog-cropped.jpg', '0', 'attachment', 'image/jpeg', '0'),
('205231', '2', '2020-08-28 16:22:28', '2020-08-28 16:22:28', '', 'walk-with-my-dog-cropped', '', 'inherit', 'open', 'closed', '', 'walk-with-my-dog-cropped-2', '', '', '2020-08-28 16:22:28', '2020-08-28 16:22:28', '', '0', 'https://jhdogtraining.com.au/wp-content/uploads/2020/08/walk-with-my-dog-cropped-1.jpg', '0', 'attachment', 'image/jpeg', '0'),
('205232', '2', '2020-08-28 16:34:22', '2020-08-28 16:34:22', '', 'puppy-run', '', 'inherit', 'open', 'closed', '', 'puppy-run', '', '', '2020-08-28 16:34:22', '2020-08-28 16:34:22', '', '0', 'https://jhdogtraining.com.au/wp-content/uploads/2020/08/puppy-run.jpg', '0', 'attachment', 'image/jpeg', '0'),
('205241', '2', '2020-08-28 21:49:38', '2020-08-28 21:49:38', '', 'iwp_log_5f497bf235af3', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f497bf235af3', '', '', '2020-08-28 21:49:38', '2020-08-28 21:49:38', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f497bf235af3/', '0', 'iwp_log', '', '0'),
('205242', '2', '2020-08-28 21:49:43', '2020-08-28 21:49:43', '', 'iwp_log_5f497bf7071b5', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f497bf7071b5', '', '', '2020-08-28 21:49:43', '2020-08-28 21:49:43', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f497bf7071b5/', '0', 'iwp_log', '', '0'),
('205245', '2', '2020-09-01 02:49:17', '2020-09-01 02:49:17', '', 'golden retriever puppy', '', 'inherit', 'open', 'closed', '', 'golden-retriever-puppy', '', '', '2020-09-01 02:49:17', '2020-09-01 02:49:17', '', '204559', 'https://jhdogtraining.com.au/wp-content/uploads/2020/09/golden-retriever-puppy.jpg', '0', 'attachment', 'image/jpeg', '0'),
('205247', '2', '2020-09-03 18:11:09', '2020-09-03 18:11:09', '', 'iwp_log_5f5131bdd07a5', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f5131bdd07a5', '', '', '2020-09-03 18:11:09', '2020-09-03 18:11:09', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f5131bdd07a5/', '0', 'iwp_log', '', '0'),
('205248', '2', '2020-08-30 00:05:03', '2020-08-30 00:05:03', '', 'iwp_log_5f513d1ddcef0', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f513d1ddcef0', '', '', '2020-08-30 00:05:03', '2020-08-30 00:05:03', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f513d1ddcef0/', '0', 'iwp_log', '', '0'),
('205249', '2', '2020-09-03 09:51:26', '2020-09-03 09:51:26', '', 'iwp_log_5f5157864570d', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f5157864570d', '', '', '2020-09-03 09:51:26', '2020-09-03 09:51:26', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f5157864570d/', '0', 'iwp_log', '', '0'),
('205250', '2', '2020-09-08 02:33:53', '2020-09-08 02:33:53', '', 'iwp_log_5f56ed91a3f69', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f56ed91a3f69', '', '', '2020-09-08 02:33:53', '2020-09-08 02:33:53', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f56ed91a3f69/', '0', 'iwp_log', '', '0'),
('205251', '2', '2020-09-09 23:05:57', '2020-09-09 23:05:57', '', 'iwp_log_5f595fd542bd9', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f595fd542bd9', '', '', '2020-09-09 23:05:57', '2020-09-09 23:05:57', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f595fd542bd9/', '0', 'iwp_log', '', '0'),
('205252', '2', '2020-09-10 17:27:09', '2020-09-10 17:27:09', '', 'iwp_log_5f5a61eda6a26', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f5a61eda6a26', '', '', '2020-09-10 17:27:09', '2020-09-10 17:27:09', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f5a61eda6a26/', '0', 'iwp_log', '', '0'),
('205253', '2', '2020-09-06 00:00:04', '2020-09-06 00:00:04', '', 'iwp_log_5f5a666db24ea', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f5a666db24ea', '', '', '2020-09-06 00:00:04', '2020-09-06 00:00:04', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f5a666db24ea/', '0', 'iwp_log', '', '0'),
('205254', '2', '2020-09-15 05:45:34', '2020-09-15 05:45:34', '', 'iwp_log_5f6054fe750c9', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f6054fe750c9', '', '', '2020-09-15 05:45:34', '2020-09-15 05:45:34', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f6054fe750c9/', '0', 'iwp_log', '', '0'),
('205255', '2', '2020-09-13 00:05:03', '2020-09-13 00:05:03', '', 'iwp_log_5f64e01e683c7', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f64e01e683c7', '', '', '2020-09-13 00:05:03', '2020-09-13 00:05:03', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f64e01e683c7/', '0', 'iwp_log', '', '0'),
('205256', '0', '2020-09-21 20:50:05', '2020-09-21 20:50:05', '', 'iwp_log_5f6911fd80ddc', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f6911fd80ddc', '', '', '2020-09-21 20:50:05', '2020-09-21 20:50:05', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f6911fd80ddc/', '0', 'iwp_log', '', '0'),
('205257', '2', '2020-09-20 00:00:05', '2020-09-20 00:00:05', '', 'iwp_log_5f6930ce95d65', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f6930ce95d65', '', '', '2020-09-20 00:00:05', '2020-09-20 00:00:05', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f6930ce95d65/', '0', 'iwp_log', '', '0'),
('205258', '2', '2020-09-22 06:28:51', '2020-09-22 06:28:51', '', 'iwp_log_5f6999a3a3dcb', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f6999a3a3dcb', '', '', '2020-09-22 06:28:51', '2020-09-22 06:28:51', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f6999a3a3dcb/', '0', 'iwp_log', '', '0'),
('205259', '2', '2020-09-27 00:10:03', '2020-09-27 00:10:03', '', 'iwp_log_5f7610d42b5a3', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f7610d42b5a3', '', '', '2020-09-27 00:10:03', '2020-09-27 00:10:03', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f7610d42b5a3/', '0', 'iwp_log', '', '0'),
('205260', '2', '2020-10-01 06:31:53', '2020-10-01 06:31:53', '', 'iwp_log_5f7612961d9c6', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f7612961d9c6', '', '', '2020-10-01 06:31:53', '2020-10-01 06:31:53', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f7612961d9c6/', '0', 'iwp_log', '', '0'),
('205261', '0', '2020-10-06 20:40:51', '2020-10-06 20:40:51', '', 'iwp_log_5f7cd653d1978', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f7cd653d1978', '', '', '2020-10-06 20:40:51', '2020-10-06 20:40:51', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f7cd653d1978/', '0', 'iwp_log', '', '0'),
('205262', '2', '2020-10-08 16:56:50', '2020-10-08 16:56:50', '', 'iwp_log_5f7f44d208cd7', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f7f44d208cd7', '', '', '2020-10-08 16:56:50', '2020-10-08 16:56:50', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f7f44d208cd7/', '0', 'iwp_log', '', '0'),
('205263', '2', '2020-10-04 00:15:04', '2020-10-04 00:15:04', '', 'iwp_log_5f7f4834e13d6', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f7f4834e13d6', '', '', '2020-10-04 00:15:04', '2020-10-04 00:15:04', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f7f4834e13d6/', '0', 'iwp_log', '', '0'),
('205264', '2', '2020-10-11 00:10:04', '2020-10-11 00:10:04', '', 'iwp_log_5f82fbc2e72ff', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f82fbc2e72ff', '', '', '2020-10-11 00:10:04', '2020-10-11 00:10:04', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f82fbc2e72ff/', '0', 'iwp_log', '', '0'),
('205265', '2', '2020-10-15 17:24:06', '2020-10-15 17:24:06', '', 'iwp_log_5f8885b66f607', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f8885b66f607', '', '', '2020-10-15 17:24:06', '2020-10-15 17:24:06', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f8885b66f607/', '0', 'iwp_log', '', '0'),
('205266', '2', '2020-10-15 17:24:16', '2020-10-15 17:24:16', '', 'iwp_log_5f8885c092966', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f8885c092966', '', '', '2020-10-15 17:24:16', '2020-10-15 17:24:16', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f8885c092966/', '0', 'iwp_log', '', '0'),
('205267', '2', '2020-10-18 00:15:04', '2020-10-18 00:15:04', '', 'iwp_log_5f9082f4ab8ce', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f9082f4ab8ce', '', '', '2020-10-18 00:15:04', '2020-10-18 00:15:04', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f9082f4ab8ce/', '0', 'iwp_log', '', '0'),
('205268', '2', '2020-10-21 23:13:11', '2020-10-21 23:13:11', '', 'iwp_log_5f90c087d28eb', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f90c087d28eb', '', '', '2020-10-21 23:13:11', '2020-10-21 23:13:11', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f90c087d28eb/', '0', 'iwp_log', '', '0'),
('205269', '2', '2020-10-25 00:00:04', '2020-10-25 00:00:04', '', 'iwp_log_5f99c4c4efb5f', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f99c4c4efb5f', '', '', '2020-10-25 00:00:04', '2020-10-25 00:00:04', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f99c4c4efb5f/', '0', 'iwp_log', '', '0'),
('205270', '2', '2020-10-29 08:30:19', '2020-10-29 08:30:19', '', 'iwp_log_5f9b1a94ebc2c', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f9b1a94ebc2c', '', '', '2020-10-29 08:30:19', '2020-10-29 08:30:19', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f9b1a94ebc2c/', '0', 'iwp_log', '', '0'),
('205271', '2', '2020-10-29 14:32:23', '2020-10-29 14:32:23', '', 'iwp_log_5f9b6d92480c8', '', 'publish', 'closed', 'closed', '', 'iwp_log_5f9b6d92480c8', '', '', '2020-10-29 14:32:23', '2020-10-29 14:32:23', '', '0', 'https://jhdogtraining.com.au/iwp_log/iwp_log_5f9b6d92480c8/', '0', 'iwp_log', '', '0'),
('205277', '2', '2021-05-10 05:51:59', '2021-05-10 05:51:59', '[et_pb_section fb_built=\"1\" module_class=\"private-training\" _builder_version=\"3.22\" background_image=\"https://jhdogtraining.com.au/wp-content/uploads/2017/12/AdobeStock_180762347_o-1.jpg\" background_position=\"top_center\" custom_padding=\"140px||140px|\"][et_pb_row _builder_version=\"3.25\"][et_pb_column type=\"4_4\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text admin_label=\"Text\" _builder_version=\"4.6.6\" text_text_color=\"#ffffff\" header_text_align=\"center\" header_text_color=\"#ffffff\" text_orientation=\"center\" module_alignment=\"center\" custom_margin=\"100px||100px|\" text_text_shadow_style=\"preset3\"]\r\n<h1 style=\"text-align: center;\"><strong>Private Training</strong></h1>\r\n<p style=\"text-align: center;\"><strong>While group training classes are beneficial for many people and dogs, they may not work for everyone. If you are time poor, uncomfortable in a group setting, need help with one or two specific behavioural issues, or just enjoy more personalised instruction, a Private Training package may be the solution you’re looking for.</strong></p>\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" _builder_version=\"3.22\" background_color=\"#f6f6f6\"][et_pb_row _builder_version=\"3.25\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"4_4\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text admin_label=\"Text\" _builder_version=\"4.6.6\"]\r\n<p style=\"text-align: center;\">Does your dog pull on lead, jump up on your guests, or have the neighbours complained about constant barking? Does your dog lunge and snarl at other dogs, or is your dog fearful of people or dogs?  Is door-dashing (complete with barking and jumping!) your dog’s favourite greeting ritual?</p>\r\n<p style=\"text-align: center;\">Private training will put an end to your dog-related frustrations, with two convenient options that will work around your busy schedule.</p>\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" _builder_version=\"3.22\"][et_pb_row _builder_version=\"3.25\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"4_4\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text admin_label=\"Text\" _builder_version=\"4.6.6\" header_text_color=\"#1f1e86\"]\r\n<h1 style=\"text-align: center;\"><strong>One-on-One Lessons</strong></h1>\r\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row column_structure=\"1_3,1_3,1_3\" _builder_version=\"3.25\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"1_3\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_blurb use_icon=\"on\" font_icon=\"%%83%%\" icon_color=\"#1f1e86\" use_icon_font_size=\"on\" icon_font_size=\"45px\" _builder_version=\"4.4.5\" text_orientation=\"center\"]\r\n<p style=\"text-align: center;\">Are you too busy for group classes but still want to learn how to train your dog yourself?</p>\r\n[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_blurb use_icon=\"on\" font_icon=\"%%83%%\" icon_color=\"#1e1d85\" use_icon_font_size=\"on\" icon_font_size=\"45px\" _builder_version=\"3.19.18\" text_orientation=\"center\"]\r\n<p style=\"text-align: center;\">Would you like personalised, step-by-step instructions and assistance from a professional trainer?</p>\r\n[/et_pb_blurb][/et_pb_column][et_pb_column type=\"1_3\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_blurb use_icon=\"on\" font_icon=\"%%83%%\" icon_color=\"#1e1d85\" use_icon_font_size=\"on\" icon_font_size=\"45px\" _builder_version=\"3.19.18\" text_orientation=\"center\"]\r\n<p style=\"text-align: center;\">Has your dog developed a new problem behavior and you’re not sure how to fix it on your own?</p>\r\n[/et_pb_blurb][/et_pb_column][/et_pb_row][et_pb_row column_structure=\"1_2,1_2\" _builder_version=\"3.25\"][et_pb_column type=\"1_2\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_image src=\"/wp-content/uploads/2017/11/beagle-at-end-of-leash.jpg\" align_tablet=\"center\" align_phone=\"\" align_last_edited=\"on|desktop\" _builder_version=\"3.23\"][/et_pb_image][/et_pb_column][et_pb_column type=\"1_2\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text _builder_version=\"3.27.4\"]\r\n\r\nPrivate, one-on-one lessons are the easy way to address your training needs at a time and place that’s convenient for you. After an initial consultation, Jenny will design a training plan specifically for you and your dog. She’ll then come to your home or a nearby park each week to work with both of you using only the most up-to-date, positive reinforcement training methods.\r\n\r\nWith focused attention and plenty of time to ask questions, you’ll be amazed at how much progress your dog makes in just a short amount of time!\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" _builder_version=\"3.22\" background_color=\"#f6f6f6\"][et_pb_row _builder_version=\"3.25\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"4_4\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text admin_label=\"Text\" _builder_version=\"4.6.6\" header_2_line_height=\"1.2em\" header_3_line_height=\"1.2em\"]\r\n<p style=\"text-align: center;\">Jenny can develop an individualised training program to address your goals and your dog\'s training needs.</p>\r\n[/et_pb_text][et_pb_text _builder_version=\"4.6.6\" header_3_text_color=\"#1f1e86\"]\r\n<h3 style=\"text-align: center;\"><strong>Initial consultation 1.5hrs - $265</strong></h3>\r\n<h3 style=\"text-align: center;\"><strong>Subsequent Consultations 1hr - $160</strong></h3>\r\n<h3 style=\"text-align: center;\"></h3>\r\n[/et_pb_text][et_pb_text _builder_version=\"4.6.6\"]\r\n<p style=\"text-align: center;\"><a href=\"http://jhdogtraining.wpengine.com/contact/\">Book your <strong>initial consultation</strong> now to discuss the training package that best suits your needs.</a></p>\r\n[/et_pb_text][et_pb_text _builder_version=\"4.6.6\"]\r\n<p style=\"text-align: center;\">For more complex behavioural problems, Jenny will discuss your package with you.</p>\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" _builder_version=\"3.22\"][et_pb_row column_structure=\"1_2,1_2\" _builder_version=\"3.25\"][et_pb_column type=\"1_2\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_image src=\"/wp-content/uploads/2017/11/AdobeStock_94700859_o.jpg\" align_tablet=\"center\" align_phone=\"\" align_last_edited=\"on|desktop\" _builder_version=\"3.23\"][/et_pb_image][/et_pb_column][et_pb_column type=\"1_2\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text _builder_version=\"3.27.4\" header_2_text_color=\"#1f1e86\"]\r\n<h2 style=\"text-align: left;\">Day Training: You work. Your dog trains.</h2>\r\nA well-behaved, well-trained dog can make your life easier and happier. But between work, school, family or social commitments, it can be almost impossible to find time to train your best friend.\r\n\r\nWith day training, Jenny will take care of the training, while you take care of the rest of your life.  This innovative solution saves you time and worry and your dog learns new skills – the fast track method to turn your dog into the welcome family you want him to be.\r\n\r\n[/et_pb_text][/et_pb_column][/et_pb_row][et_pb_row column_structure=\"1_2,1_2\" module_class=\"switch-image\" _builder_version=\"3.25\"][et_pb_column type=\"1_2\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text _builder_version=\"3.27.4\" header_2_text_color=\"#1f1e86\"]\r\n<h2 style=\"text-align: right;\">How it Works</h2>\r\n<p style=\"text-align: right;\">After an initial consultation to understand your needs and develop a customised training plan, Jenny will come to your home to personally work with your dog while you’re away.</p>\r\n<p style=\"text-align: right;\">In addition to your dog’s training sessions, Jenny will meet with you regularly to go over what your dog has learned and show you how to continue to reinforce the new behaviours so you can enjoy and maintain your dog’s newfound skills.</p>\r\n[/et_pb_text][/et_pb_column][et_pb_column type=\"1_2\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_image src=\"/wp-content/uploads/2017/11/AdobeStock_115392600_o.jpg\" align_tablet=\"center\" align_phone=\"\" align_last_edited=\"on|desktop\" _builder_version=\"3.23\"][/et_pb_image][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" _builder_version=\"3.22\" background_color=\"#f6f6f6\"][et_pb_row _builder_version=\"3.25\" custom_css_main_element=\"display: -webkit-flex;||display: -ms-flex;||display: flex;||||-webkit-align-items: center; ||-ms-flex-align: center;||align-items: center; \"][et_pb_column type=\"4_4\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text _builder_version=\"3.27.4\" header_3_text_color=\"#1f1e86\"]\r\n<h3 style=\"text-align: center;\"><strong>Four-week package:</strong></h3>\r\n<p style=\"text-align: center;\">This package is perfect for common training and behavioural issues. However, if your dog has a more challengingbehaviour,Jenny will be happy to discuss your needs and develop an individualised program for you and your dog.</p>\r\n[/et_pb_text][et_pb_text _builder_version=\"4.5.1\" header_3_text_color=\"#1f1e86\"]\r\n<h3 style=\"text-align: center;\"><strong>2 sessions per week for your dog + 4 guardian training sessions - $1,175</strong></h3>\r\n<h3 style=\"text-align: center;\"><strong>3 sessions per week for your dog + 4 guardian training sessions - $1,450</strong></h3>\r\n[/et_pb_text][et_pb_text _builder_version=\"3.27.4\"]\r\n<p style=\"text-align: center;\"><a href=\"http://jhdogtraining.wpengine.com/contact/\">Book your <strong>initial consultation</strong> now to discuss the training package that best suits your needs.</a></p>\r\n[/et_pb_text][et_pb_text _builder_version=\"3.27.4\"]\r\n<p style=\"text-align: center;\">For more complex behavioural problems, Jenny will discuss your package with you.</p>\r\n[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" _builder_version=\"3.22\" background_color=\"#1f1e86\"][et_pb_row _builder_version=\"3.25\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"4_4\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_text _builder_version=\"3.27.4\" text_text_color=\"#ffffff\" header_3_text_color=\"#ffffff\" header_3_line_height=\"1.4em\"]\r\n<h3 style=\"text-align: center;\"><a href=\"https://jennyharlowdogtraining.activehosted.com/f/13\" target=\"_blank\" rel=\"noopener noreferrer\"><strong>Click here to receive Jenny’s free training tips </strong></a></h3>\r\n[/et_pb_text][et_pb_button button_url=\"https://jhdogtraining.com.au/blog/\" url_new_window=\"on\" button_text=\"click here to read the latest blog\" button_alignment=\"center\" _builder_version=\"3.16\" custom_button=\"on\" button_text_color=\"#ffffff\" button_border_color=\"#ffffff\" button_text_size__hover_enabled=\"off\" button_text_size__hover=\"null\" button_one_text_size__hover_enabled=\"off\" button_one_text_size__hover=\"null\" button_two_text_size__hover_enabled=\"off\" button_two_text_size__hover=\"null\" button_text_color__hover_enabled=\"off\" button_text_color__hover=\"null\" button_one_text_color__hover_enabled=\"off\" button_one_text_color__hover=\"null\" button_two_text_color__hover_enabled=\"off\" button_two_text_color__hover=\"null\" button_border_width__hover_enabled=\"off\" button_border_width__hover=\"null\" button_one_border_width__hover_enabled=\"off\" button_one_border_width__hover=\"null\" button_two_border_width__hover_enabled=\"off\" button_two_border_width__hover=\"null\" button_border_color__hover_enabled=\"off\" button_border_color__hover=\"null\" button_one_border_color__hover_enabled=\"off\" button_one_border_color__hover=\"null\" button_two_border_color__hover_enabled=\"off\" button_two_border_color__hover=\"null\" button_border_radius__hover_enabled=\"off\" button_border_radius__hover=\"null\" button_one_border_radius__hover_enabled=\"off\" button_one_border_radius__hover=\"null\" button_two_border_radius__hover_enabled=\"off\" button_two_border_radius__hover=\"null\" button_letter_spacing__hover_enabled=\"off\" button_letter_spacing__hover=\"null\" button_one_letter_spacing__hover_enabled=\"off\" button_one_letter_spacing__hover=\"null\" button_two_letter_spacing__hover_enabled=\"off\" button_two_letter_spacing__hover=\"null\" button_bg_color__hover_enabled=\"off\" button_bg_color__hover=\"null\" button_one_bg_color__hover_enabled=\"off\" button_one_bg_color__hover=\"null\" button_two_bg_color__hover_enabled=\"off\" button_two_bg_color__hover=\"null\"][/et_pb_button][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" _builder_version=\"3.22\"][et_pb_row _builder_version=\"3.25\" background_size=\"initial\" background_position=\"top_left\" background_repeat=\"repeat\"][et_pb_column type=\"4_4\" _builder_version=\"3.25\" custom_padding=\"|||\" custom_padding__hover=\"|||\"][et_pb_testimonial author=\"Jeanette &amp; Boo\" _builder_version=\"3.2\" background_layout=\"dark\"]\r\n\r\n<em>Jenny Harlow was great working with my young son and I to train our new puppy, Boo, to come back when called. We were both really nervous about the safety of our puppy as our last dog was hit by a car, which was very traumatic. Jenny helped us get over our fears and work with confidence in training our puppy. Teaching Boo to come back has become a fun game and now she is really good at it.  We are now relaxed with her off the lead at the park as we are confident that she will come back when called. </em>\r\n\r\n[/et_pb_testimonial][/et_pb_column][/et_pb_row][/et_pb_section]', 'Private Training', '', 'inherit', 'closed', 'closed', '', '204557-autosave-v1', '', '', '2021-05-10 05:51:59', '2021-05-10 05:51:59', '', '204557', 'https://jhdogtraining.com.au/?p=205277', '0', 'revision', '', '0'),
('205278', '2', '2021-06-28 23:10:34', '0000-00-00 00:00:00', '', 'Auto Draft', '', 'auto-draft', 'open', 'open', '', '', '', '', '2021-06-28 23:10:34', '0000-00-00 00:00:00', '', '0', 'https://jhdogtraining.com.au/?p=205278', '0', 'post', '', '0');
/**ABDB**/DROP TABLE IF EXISTS `wp_postmeta`;
/**ABDB**/CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2907 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `wp_postmeta`  VALUES 
('80', '41', '_wp_attached_file', '2017/11/logo.png'),
('81', '41', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:507;s:6:\"height\";i:507;s:4:\"file\";s:16:\"2017/11/logo.png\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:16:\"logo-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:16:\"logo-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:16:\"logo-400x250.png\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:16:\"logo-400x284.png\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:9:\"image/png\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:16:\"logo-507x382.png\";s:5:\"width\";i:507;s:6:\"height\";i:382;s:9:\"mime-type\";s:9:\"image/png\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:16:\"logo-400x507.png\";s:5:\"width\";i:400;s:6:\"height\";i:507;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('82', '42', '_edit_lock', '1536953038:2'),
('83', '42', '_edit_last', '2'),
('84', '43', '_wp_attached_file', '2017/11/bulldog-lead-in-mouth.jpg'),
('85', '43', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:2048;s:6:\"height\";i:1305;s:4:\"file\";s:33:\"2017/11/bulldog-lead-in-mouth.jpg\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"bulldog-lead-in-mouth-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:33:\"bulldog-lead-in-mouth-300x191.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:191;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:33:\"bulldog-lead-in-mouth-768x489.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:489;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:34:\"bulldog-lead-in-mouth-1024x653.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:653;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:33:\"bulldog-lead-in-mouth-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:34:\"bulldog-lead-in-mouth-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:33:\"bulldog-lead-in-mouth-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:33:\"bulldog-lead-in-mouth-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:34:\"bulldog-lead-in-mouth-1080x688.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:688;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:33:\"bulldog-lead-in-mouth-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:21:\"Willee Cole - Fotolia\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('86', '42', '_wp_page_template', 'default'),
('87', '42', '_et_pb_post_hide_nav', 'default'),
('88', '42', '_et_pb_page_layout', 'et_full_width_page'),
('89', '42', '_et_pb_side_nav', 'off'),
('90', '42', '_et_pb_use_builder', 'on'),
('91', '42', '_et_builder_version', 'BB|Divi|3.12.2'),
('92', '42', '_et_pb_ab_stats_refresh_interval', 'hourly'),
('93', '42', '_et_pb_old_content', ''),
('94', '42', '_et_pb_enable_shortcode_tracking', ''),
('95', '42', '_et_pb_custom_css', ''),
('96', '42', '_et_pb_color_palette', '#000000|#FFFFFF|#E02B20|#E09900|#EDF000|#7CDA24|#0C71C3|#8300E9'),
('125', '204548', '_et_pb_built_for_post_type', 'page'),
('126', '204548', '_edit_lock', '1511189695:1'),
('127', '204552', '_wp_attached_file', '2017/11/Macy-C-31.jpg'),
('128', '204552', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:5446;s:6:\"height\";i:3631;s:4:\"file\";s:21:\"2017/11/Macy-C-31.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"Macy-C-31-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"Macy-C-31-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:21:\"Macy-C-31-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:22:\"Macy-C-31-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:21:\"Macy-C-31-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:22:\"Macy-C-31-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:21:\"Macy-C-31-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:21:\"Macy-C-31-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:22:\"Macy-C-31-1080x720.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:21:\"Macy-C-31-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:37:\"et-pb-post-main-image-fullwidth-large\";a:4:{s:4:\"file\";s:23:\"Macy-C-31-2880x1800.jpg\";s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:21:\"Canon EOS 5D Mark III\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1496478061\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"200\";s:3:\"iso\";s:3:\"400\";s:13:\"shutter_speed\";s:6:\"0.0025\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('129', '204553', '_edit_last', '2'),
('130', '204553', '_wp_page_template', 'default'),
('131', '204553', '_et_pb_post_hide_nav', 'default'),
('132', '204553', '_et_pb_page_layout', 'et_right_sidebar'),
('133', '204553', '_et_pb_side_nav', 'off'),
('134', '204553', '_et_pb_use_builder', 'on'),
('135', '204553', '_et_builder_version', 'BB|Divi|3.12.2'),
('137', '204553', '_et_pb_old_content', ''),
('138', '204553', '_et_pb_enable_shortcode_tracking', ''),
('139', '204553', '_et_pb_custom_css', ''),
('140', '204553', '_edit_lock', '1597027294:2'),
('141', '204554', '_menu_item_type', 'post_type'),
('142', '204554', '_menu_item_menu_item_parent', '0'),
('143', '204554', '_menu_item_object_id', '204553'),
('144', '204554', '_menu_item_object', 'page'),
('145', '204554', '_menu_item_target', ''),
('146', '204554', '_menu_item_classes', 'a:1:{i:0;s:0:\"\";}'),
('147', '204554', '_menu_item_xfn', ''),
('148', '204554', '_menu_item_url', ''),
('159', '204556', '_wp_attached_file', '2017/11/IMG_2019.jpg'),
('160', '204556', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:1136;s:6:\"height\";i:757;s:4:\"file\";s:20:\"2017/11/IMG_2019.jpg\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"IMG_2019-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"IMG_2019-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:20:\"IMG_2019-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"IMG_2019-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:20:\"IMG_2019-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:21:\"IMG_2019-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:20:\"IMG_2019-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:20:\"IMG_2019-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:21:\"IMG_2019-1080x720.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:20:\"IMG_2019-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}'),
('161', '204557', '_edit_last', '2'),
('162', '204557', '_wp_page_template', 'default'),
('163', '204557', '_et_pb_post_hide_nav', 'default'),
('164', '204557', '_et_pb_page_layout', 'et_full_width_page'),
('165', '204557', '_et_pb_side_nav', 'off'),
('166', '204557', '_et_pb_use_builder', 'on'),
('167', '204557', '_et_builder_version', 'BB|Divi|3.19.18'),
('169', '204557', '_et_pb_old_content', ''),
('170', '204557', '_et_pb_enable_shortcode_tracking', ''),
('171', '204557', '_et_pb_custom_css', ''),
('172', '204557', '_edit_lock', '1620625927:2'),
('173', '204558', '_menu_item_type', 'post_type'),
('174', '204558', '_menu_item_menu_item_parent', '0'),
('175', '204558', '_menu_item_object_id', '204557'),
('176', '204558', '_menu_item_object', 'page'),
('177', '204558', '_menu_item_target', ''),
('178', '204558', '_menu_item_classes', 'a:1:{i:0;s:0:\"\";}'),
('179', '204558', '_menu_item_xfn', ''),
('180', '204558', '_menu_item_url', ''),
('182', '204559', '_edit_lock', '1620618433:2'),
('183', '204559', '_edit_last', '2'),
('184', '204559', '_wp_page_template', 'default'),
('185', '204559', '_et_pb_post_hide_nav', 'default'),
('186', '204559', '_et_pb_page_layout', 'et_right_sidebar'),
('187', '204559', '_et_pb_side_nav', 'off'),
('188', '204559', '_et_pb_use_builder', 'on'),
('189', '204559', '_et_builder_version', 'VB|Divi|4.5.7'),
('191', '204559', '_et_pb_old_content', ''),
('192', '204559', '_et_pb_enable_shortcode_tracking', ''),
('193', '204559', '_et_pb_custom_css', ''),
('194', '204560', '_menu_item_type', 'post_type'),
('195', '204560', '_menu_item_menu_item_parent', '0'),
('196', '204560', '_menu_item_object_id', '204559'),
('197', '204560', '_menu_item_object', 'page'),
('198', '204560', '_menu_item_target', ''),
('199', '204560', '_menu_item_classes', 'a:1:{i:0;s:0:\"\";}'),
('200', '204560', '_menu_item_xfn', ''),
('201', '204560', '_menu_item_url', ''),
('203', '204561', '_wp_attached_file', '2017/11/shutterstock_134604923.jpg'),
('204', '204561', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:4724;s:6:\"height\";i:3144;s:4:\"file\";s:34:\"2017/11/shutterstock_134604923.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"shutterstock_134604923-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"shutterstock_134604923-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:34:\"shutterstock_134604923-768x511.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:511;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:35:\"shutterstock_134604923-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:34:\"shutterstock_134604923-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:35:\"shutterstock_134604923-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:34:\"shutterstock_134604923-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:34:\"shutterstock_134604923-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:35:\"shutterstock_134604923-1080x719.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:719;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:34:\"shutterstock_134604923-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:37:\"et-pb-post-main-image-fullwidth-large\";a:4:{s:4:\"file\";s:36:\"shutterstock_134604923-2880x1800.jpg\";s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('205', '204562', '_edit_last', '2'),
('206', '204562', '_wp_page_template', 'default'),
('207', '204562', '_et_pb_post_hide_nav', 'default'),
('208', '204562', '_et_pb_page_layout', 'et_right_sidebar'),
('209', '204562', '_et_pb_side_nav', 'off'),
('210', '204562', '_et_pb_use_builder', 'on'),
('211', '204562', '_et_builder_version', 'BB|Divi|3.12.2'),
('213', '204562', '_et_pb_old_content', ''),
('214', '204562', '_et_pb_enable_shortcode_tracking', ''),
('215', '204562', '_et_pb_custom_css', ''),
('216', '204562', '_edit_lock', '1597027644:2'),
('217', '204563', '_menu_item_type', 'post_type'),
('218', '204563', '_menu_item_menu_item_parent', '205083'),
('219', '204563', '_menu_item_object_id', '204562'),
('220', '204563', '_menu_item_object', 'page'),
('221', '204563', '_menu_item_target', ''),
('222', '204563', '_menu_item_classes', 'a:1:{i:0;s:0:\"\";}'),
('223', '204563', '_menu_item_xfn', ''),
('224', '204563', '_menu_item_url', ''),
('230', '204568', '_wp_attached_file', '2017/11/IMG_2019-1.jpg'),
('231', '204568', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:1136;s:6:\"height\";i:757;s:4:\"file\";s:22:\"2017/11/IMG_2019-1.jpg\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"IMG_2019-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"IMG_2019-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"IMG_2019-1-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"IMG_2019-1-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:22:\"IMG_2019-1-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:23:\"IMG_2019-1-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:22:\"IMG_2019-1-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:22:\"IMG_2019-1-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:23:\"IMG_2019-1-1080x720.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:22:\"IMG_2019-1-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}'),
('272', '47106', '_et_pb_built_for_post_type', 'page'),
('273', '47106', '_edit_lock', '1511270148:1'),
('274', '204590', '_wp_attached_file', '2017/11/beagle-at-end-of-leash.jpg'),
('275', '204590', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:2048;s:6:\"height\";i:1397;s:4:\"file\";s:34:\"2017/11/beagle-at-end-of-leash.jpg\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"beagle-at-end-of-leash-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"beagle-at-end-of-leash-300x205.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:205;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:34:\"beagle-at-end-of-leash-768x524.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:524;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:35:\"beagle-at-end-of-leash-1024x699.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:699;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:34:\"beagle-at-end-of-leash-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:35:\"beagle-at-end-of-leash-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:34:\"beagle-at-end-of-leash-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:34:\"beagle-at-end-of-leash-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:35:\"beagle-at-end-of-leash-1080x737.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:737;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:34:\"beagle-at-end-of-leash-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:28:\"Soloviova Liudmyla - Fotolia\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('276', '204592', '_wp_attached_file', '2017/11/GD-pulling-on-leash.jpg'),
('277', '204592', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:2939;s:6:\"height\";i:1426;s:4:\"file\";s:31:\"2017/11/GD-pulling-on-leash.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"GD-pulling-on-leash-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:31:\"GD-pulling-on-leash-300x146.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:146;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:31:\"GD-pulling-on-leash-768x373.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:373;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:32:\"GD-pulling-on-leash-1024x497.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:497;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:31:\"GD-pulling-on-leash-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:32:\"GD-pulling-on-leash-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:31:\"GD-pulling-on-leash-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:31:\"GD-pulling-on-leash-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:32:\"GD-pulling-on-leash-1080x524.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:524;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:31:\"GD-pulling-on-leash-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:37:\"et-pb-post-main-image-fullwidth-large\";a:4:{s:4:\"file\";s:33:\"GD-pulling-on-leash-2880x1426.jpg\";s:5:\"width\";i:2880;s:6:\"height\";i:1426;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:12:\"Eric Isselee\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:21:\"Eric Issele - Fotolia\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('281', '204596', '_edit_lock', '1549242333:2'),
('282', '204596', '_edit_last', '1'),
('283', '204596', '_wp_page_template', 'default'),
('284', '204596', '_et_pb_post_hide_nav', 'default'),
('285', '204596', '_et_pb_page_layout', 'et_right_sidebar'),
('286', '204596', '_et_pb_side_nav', 'off'),
('287', '204596', '_et_pb_use_builder', 'on'),
('288', '204596', '_et_builder_version', 'BB|Divi|3.0.89'),
('289', '204596', '_et_pb_ab_stats_refresh_interval', 'hourly'),
('290', '204596', '_et_pb_old_content', ''),
('291', '204596', '_et_pb_enable_shortcode_tracking', ''),
('292', '204596', '_et_pb_custom_css', ''),
('300', '204601', '_wp_attached_file', '2017/11/TOP-IMAGE_o.jpg'),
('301', '204601', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:23:\"2017/11/TOP-IMAGE_o.jpg\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"TOP-IMAGE_o-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"TOP-IMAGE_o-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"TOP-IMAGE_o-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:24:\"TOP-IMAGE_o-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:23:\"TOP-IMAGE_o-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:24:\"TOP-IMAGE_o-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:23:\"TOP-IMAGE_o-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:23:\"TOP-IMAGE_o-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:24:\"TOP-IMAGE_o-1080x720.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:23:\"TOP-IMAGE_o-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:29:\"©wittybear - stock.adobe.com\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('302', '204602', '_wp_attached_file', '2017/11/TOP-IMAGE_o-1.jpg'),
('303', '204602', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:25:\"2017/11/TOP-IMAGE_o-1.jpg\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"TOP-IMAGE_o-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"TOP-IMAGE_o-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"TOP-IMAGE_o-1-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:26:\"TOP-IMAGE_o-1-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:25:\"TOP-IMAGE_o-1-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:26:\"TOP-IMAGE_o-1-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:25:\"TOP-IMAGE_o-1-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:25:\"TOP-IMAGE_o-1-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:26:\"TOP-IMAGE_o-1-1080x720.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:25:\"TOP-IMAGE_o-1-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:29:\"©wittybear - stock.adobe.com\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('304', '204603', '_wp_attached_file', '2017/11/separation-anxiety_o.jpg'),
('305', '204603', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:520;s:6:\"height\";i:345;s:4:\"file\";s:32:\"2017/11/separation-anxiety_o.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"separation-anxiety_o-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"separation-anxiety_o-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:32:\"separation-anxiety_o-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:32:\"separation-anxiety_o-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:32:\"separation-anxiety_o-510x345.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:345;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:32:\"separation-anxiety_o-400x345.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:345;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:26:\"©ksuksa - stock.adobe.com\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('306', '204604', '_edit_lock', '1585182175:2'),
('307', '204604', '_edit_last', '2'),
('308', '204604', '_wp_page_template', 'default'),
('309', '204604', '_et_pb_post_hide_nav', 'default'),
('310', '204604', '_et_pb_page_layout', 'et_full_width_page'),
('311', '204604', '_et_pb_side_nav', 'off'),
('312', '204604', '_et_pb_use_builder', ''),
('313', '204604', '_et_builder_version', 'BB|Divi|3.2.2'),
('314', '204604', '_et_pb_ab_stats_refresh_interval', 'hourly'),
('315', '204604', '_et_pb_old_content', ''),
('316', '204604', '_et_pb_enable_shortcode_tracking', ''),
('317', '204604', '_et_pb_custom_css', ''),
('318', '204605', '_menu_item_type', 'post_type'),
('319', '204605', '_menu_item_menu_item_parent', '205083'),
('320', '204605', '_menu_item_object_id', '204604'),
('321', '204605', '_menu_item_object', 'page'),
('322', '204605', '_menu_item_target', ''),
('323', '204605', '_menu_item_classes', 'a:1:{i:0;s:0:\"\";}'),
('324', '204605', '_menu_item_xfn', ''),
('325', '204605', '_menu_item_url', ''),
('327', '204606', '_edit_lock', '1536937098:2'),
('328', '204606', '_edit_last', '2'),
('329', '204606', '_wp_page_template', 'default'),
('330', '204606', '_et_pb_post_hide_nav', 'default'),
('331', '204606', '_et_pb_page_layout', 'et_right_sidebar'),
('332', '204606', '_et_pb_side_nav', 'off'),
('333', '204606', '_et_pb_use_builder', 'on'),
('334', '204606', '_et_builder_version', 'BB|Divi|3.12.2'),
('335', '204606', '_et_pb_ab_stats_refresh_interval', 'hourly'),
('336', '204606', '_et_pb_old_content', ''),
('337', '204606', '_et_pb_enable_shortcode_tracking', ''),
('338', '204606', '_et_pb_custom_css', ''),
('339', '204607', '_menu_item_type', 'post_type'),
('340', '204607', '_menu_item_menu_item_parent', '0'),
('341', '204607', '_menu_item_object_id', '204606'),
('342', '204607', '_menu_item_object', 'page'),
('343', '204607', '_menu_item_target', ''),
('344', '204607', '_menu_item_classes', 'a:1:{i:0;s:0:\"\";}'),
('345', '204607', '_menu_item_xfn', ''),
('346', '204607', '_menu_item_url', ''),
('348', '204608', '_wp_attached_file', '2017/11/TOP-IMAGE_o-2.jpg'),
('349', '204608', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:25:\"2017/11/TOP-IMAGE_o-2.jpg\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"TOP-IMAGE_o-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"TOP-IMAGE_o-2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"TOP-IMAGE_o-2-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:26:\"TOP-IMAGE_o-2-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:25:\"TOP-IMAGE_o-2-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:26:\"TOP-IMAGE_o-2-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:25:\"TOP-IMAGE_o-2-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:25:\"TOP-IMAGE_o-2-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:26:\"TOP-IMAGE_o-2-1080x720.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:25:\"TOP-IMAGE_o-2-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:30:\"©barbiturat - stock.adobe.com\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('350', '204609', '_wp_attached_file', '2017/11/TOP-IMAGE_o-3.jpg'),
('351', '204609', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:25:\"2017/11/TOP-IMAGE_o-3.jpg\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"TOP-IMAGE_o-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"TOP-IMAGE_o-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"TOP-IMAGE_o-3-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:26:\"TOP-IMAGE_o-3-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:25:\"TOP-IMAGE_o-3-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:26:\"TOP-IMAGE_o-3-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:25:\"TOP-IMAGE_o-3-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:25:\"TOP-IMAGE_o-3-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:26:\"TOP-IMAGE_o-3-1080x720.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:25:\"TOP-IMAGE_o-3-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:33:\"©Lindsay_Helms - stock.adobe.com\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('352', '204610', '_wp_attached_file', '2017/11/TOP-IMAGE_159644971.jpg'),
('353', '204610', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:31:\"2017/11/TOP-IMAGE_159644971.jpg\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"TOP-IMAGE_159644971-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:31:\"TOP-IMAGE_159644971-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:31:\"TOP-IMAGE_159644971-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:32:\"TOP-IMAGE_159644971-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:31:\"TOP-IMAGE_159644971-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:32:\"TOP-IMAGE_159644971-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:31:\"TOP-IMAGE_159644971-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:31:\"TOP-IMAGE_159644971-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:32:\"TOP-IMAGE_159644971-1080x720.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:31:\"TOP-IMAGE_159644971-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:33:\"©Lindsay_Helms - stock.adobe.com\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('354', '204611', '_wp_attached_file', '2017/11/AdobeStock_94700859_o.jpg'),
('355', '204611', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:520;s:6:\"height\";i:347;s:4:\"file\";s:33:\"2017/11/AdobeStock_94700859_o.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"AdobeStock_94700859_o-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:33:\"AdobeStock_94700859_o-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:33:\"AdobeStock_94700859_o-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:33:\"AdobeStock_94700859_o-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:33:\"AdobeStock_94700859_o-510x347.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:347;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:33:\"AdobeStock_94700859_o-400x347.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:347;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:24:\"Copyright:Jne Valokuvaus\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('356', '204612', '_wp_attached_file', '2017/11/AdobeStock_115392600_o.jpg'),
('357', '204612', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:520;s:6:\"height\";i:347;s:4:\"file\";s:34:\"2017/11/AdobeStock_115392600_o.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"AdobeStock_115392600_o-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"AdobeStock_115392600_o-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:34:\"AdobeStock_115392600_o-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:34:\"AdobeStock_115392600_o-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:34:\"AdobeStock_115392600_o-510x347.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:347;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:34:\"AdobeStock_115392600_o-400x347.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:347;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:11:\"Peter Mayer\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('358', '204613', '_wp_attached_file', '2017/11/AdobeStock_151809495_o.jpg'),
('359', '204613', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:520;s:6:\"height\";i:346;s:4:\"file\";s:34:\"2017/11/AdobeStock_151809495_o.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"AdobeStock_151809495_o-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"AdobeStock_151809495_o-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:34:\"AdobeStock_151809495_o-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:34:\"AdobeStock_151809495_o-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:34:\"AdobeStock_151809495_o-510x346.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:346;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:34:\"AdobeStock_151809495_o-400x346.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:346;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:26:\"©Evdoha - stock.adobe.com\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('360', '204614', '_wp_attached_file', '2017/11/AdobeStock_84330916_o.jpg'),
('361', '204614', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:520;s:6:\"height\";i:347;s:4:\"file\";s:33:\"2017/11/AdobeStock_84330916_o.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"AdobeStock_84330916_o-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:33:\"AdobeStock_84330916_o-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:33:\"AdobeStock_84330916_o-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:33:\"AdobeStock_84330916_o-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:33:\"AdobeStock_84330916_o-510x347.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:347;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:33:\"AdobeStock_84330916_o-400x347.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:347;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:21:\"© Jate Pattanachinda\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('362', '204615', '_wp_attached_file', '2017/11/TOP-IMAAGE_o.jpg'),
('363', '204615', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:24:\"2017/11/TOP-IMAAGE_o.jpg\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"TOP-IMAAGE_o-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"TOP-IMAAGE_o-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:24:\"TOP-IMAAGE_o-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:25:\"TOP-IMAAGE_o-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:24:\"TOP-IMAAGE_o-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:25:\"TOP-IMAAGE_o-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:24:\"TOP-IMAAGE_o-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:24:\"TOP-IMAAGE_o-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:25:\"TOP-IMAAGE_o-1080x720.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:24:\"TOP-IMAAGE_o-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:26:\"©annaav - stock.adobe.com\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('364', '204616', '_wp_attached_file', '2017/11/AdobeStock_123004237_o.jpg'),
('365', '204616', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:520;s:6:\"height\";i:344;s:4:\"file\";s:34:\"2017/11/AdobeStock_123004237_o.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"AdobeStock_123004237_o-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"AdobeStock_123004237_o-300x198.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:198;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:34:\"AdobeStock_123004237_o-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:34:\"AdobeStock_123004237_o-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:34:\"AdobeStock_123004237_o-510x344.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:344;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:34:\"AdobeStock_123004237_o-400x344.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:344;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:25:\"©Gerry - stock.adobe.com\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('366', '204617', '_wp_attached_file', '2017/11/AdobeStock_163554641_o.jpg'),
('367', '204617', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:520;s:6:\"height\";i:347;s:4:\"file\";s:34:\"2017/11/AdobeStock_163554641_o.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"AdobeStock_163554641_o-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"AdobeStock_163554641_o-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:34:\"AdobeStock_163554641_o-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:34:\"AdobeStock_163554641_o-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:34:\"AdobeStock_163554641_o-510x347.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:347;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:34:\"AdobeStock_163554641_o-400x347.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:347;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:27:\"©Tetiana - stock.adobe.com\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('368', '204618', '_wp_attached_file', '2017/11/TOP-IMAAGE_o-1.jpg'),
('369', '204618', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:893;s:4:\"file\";s:26:\"2017/11/TOP-IMAAGE_o-1.jpg\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"TOP-IMAAGE_o-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"TOP-IMAAGE_o-1-300x140.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:26:\"TOP-IMAAGE_o-1-768x357.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:357;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:27:\"TOP-IMAAGE_o-1-1024x476.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:476;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:26:\"TOP-IMAAGE_o-1-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:27:\"TOP-IMAAGE_o-1-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:26:\"TOP-IMAAGE_o-1-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:26:\"TOP-IMAAGE_o-1-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:27:\"TOP-IMAAGE_o-1-1080x502.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:502;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:26:\"TOP-IMAAGE_o-1-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:26:\"©annaav - stock.adobe.com\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('370', '204620', '_edit_lock', '1512066928:1'),
('371', '204620', '_edit_last', '1'),
('372', '204620', '_wp_page_template', 'default'),
('373', '204620', '_et_pb_post_hide_nav', 'default'),
('374', '204620', '_et_pb_page_layout', 'et_full_width_page'),
('375', '204620', '_et_pb_side_nav', 'off'),
('376', '204620', '_et_pb_use_builder', ''),
('377', '204620', '_et_builder_version', 'BB|Divi|3.0.89'),
('378', '204620', '_et_pb_ab_stats_refresh_interval', 'hourly'),
('379', '204620', '_et_pb_old_content', ''),
('380', '204620', '_et_pb_enable_shortcode_tracking', ''),
('381', '204620', '_et_pb_custom_css', ''),
('392', '204626', '_wp_attached_file', '2017/12/JH_Horizontal-4.png'),
('393', '204626', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:189;s:6:\"height\";i:40;s:4:\"file\";s:27:\"2017/12/JH_Horizontal-4.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"JH_Horizontal-4-150x40.png\";s:5:\"width\";i:150;s:6:\"height\";i:40;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('394', '204627', '_wp_attached_file', '2017/12/IMG_2019_o.jpg'),
('395', '204627', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:510;s:6:\"height\";i:340;s:4:\"file\";s:22:\"2017/12/IMG_2019_o.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"IMG_2019_o-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"IMG_2019_o-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:22:\"IMG_2019_o-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:22:\"IMG_2019_o-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:22:\"IMG_2019_o-510x340.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:340;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:22:\"IMG_2019_o-400x340.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:340;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('396', '204628', '_wp_attached_file', '2017/12/AdobeStock_119270241_o.jpg'),
('397', '204628', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:510;s:6:\"height\";i:318;s:4:\"file\";s:34:\"2017/12/AdobeStock_119270241_o.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"AdobeStock_119270241_o-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"AdobeStock_119270241_o-300x187.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:187;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:34:\"AdobeStock_119270241_o-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:34:\"AdobeStock_119270241_o-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:34:\"AdobeStock_119270241_o-510x318.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:318;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:34:\"AdobeStock_119270241_o-400x318.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:318;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:30:\"©jaybanipal - stock.adobe.com\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('400', '204630', '_wp_attached_file', '2017/12/csat_seal_web.png'),
('401', '204630', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:107;s:6:\"height\";i:80;s:4:\"file\";s:25:\"2017/12/csat_seal_web.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('407', '204633', '_wp_attached_file', '2017/12/DELTA_INSTITUTE_LOGO_MEMBER_PATHS.png'),
('408', '204633', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:75;s:6:\"height\";i:80;s:4:\"file\";s:45:\"2017/12/DELTA_INSTITUTE_LOGO_MEMBER_PATHS.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('421', '204641', '_wp_attached_file', '2017/12/AdobeStock_180762320_o.jpg'),
('422', '204641', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1281;s:4:\"file\";s:34:\"2017/12/AdobeStock_180762320_o.jpg\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"AdobeStock_180762320_o-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"AdobeStock_180762320_o-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:34:\"AdobeStock_180762320_o-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:35:\"AdobeStock_180762320_o-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:34:\"AdobeStock_180762320_o-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:35:\"AdobeStock_180762320_o-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:34:\"AdobeStock_180762320_o-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:34:\"AdobeStock_180762320_o-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:35:\"AdobeStock_180762320_o-1080x721.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:721;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:34:\"AdobeStock_180762320_o-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:33:\"©StockPhotoPro - stock.adobe.com\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('423', '204642', '_wp_attached_file', '2017/12/sepanx-terrier.jpg'),
('424', '204642', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:520;s:6:\"height\";i:347;s:4:\"file\";s:26:\"2017/12/sepanx-terrier.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"sepanx-terrier-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"sepanx-terrier-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:26:\"sepanx-terrier-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:26:\"sepanx-terrier-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:26:\"sepanx-terrier-510x347.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:347;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:26:\"sepanx-terrier-400x347.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:347;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('425', '204643', '_wp_attached_file', '2017/12/Jenny-Bonnie-laying-in-the-grass.jpg'),
('426', '204643', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:520;s:6:\"height\";i:943;s:4:\"file\";s:44:\"2017/12/Jenny-Bonnie-laying-in-the-grass.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:44:\"Jenny-Bonnie-laying-in-the-grass-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:44:\"Jenny-Bonnie-laying-in-the-grass-165x300.jpg\";s:5:\"width\";i:165;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:44:\"Jenny-Bonnie-laying-in-the-grass-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:44:\"Jenny-Bonnie-laying-in-the-grass-520x675.jpg\";s:5:\"width\";i:520;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:44:\"Jenny-Bonnie-laying-in-the-grass-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:44:\"Jenny-Bonnie-laying-in-the-grass-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:44:\"Jenny-Bonnie-laying-in-the-grass-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('429', '204645', '_wp_attached_file', '2017/12/AdobeStock_180762347_o.jpg'),
('430', '204645', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1281;s:4:\"file\";s:34:\"2017/12/AdobeStock_180762347_o.jpg\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"AdobeStock_180762347_o-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"AdobeStock_180762347_o-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:34:\"AdobeStock_180762347_o-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:35:\"AdobeStock_180762347_o-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:34:\"AdobeStock_180762347_o-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:35:\"AdobeStock_180762347_o-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:34:\"AdobeStock_180762347_o-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:34:\"AdobeStock_180762347_o-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:35:\"AdobeStock_180762347_o-1080x721.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:721;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:34:\"AdobeStock_180762347_o-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:33:\"©StockPhotoPro - stock.adobe.com\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('431', '204646', '_wp_attached_file', '2017/12/AdobeStock_180762347_o-1.jpg'),
('432', '204646', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:1063;s:4:\"file\";s:36:\"2017/12/AdobeStock_180762347_o-1.jpg\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"AdobeStock_180762347_o-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:36:\"AdobeStock_180762347_o-1-300x166.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:166;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:36:\"AdobeStock_180762347_o-1-768x425.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:425;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:37:\"AdobeStock_180762347_o-1-1024x567.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:567;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:36:\"AdobeStock_180762347_o-1-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:37:\"AdobeStock_180762347_o-1-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:36:\"AdobeStock_180762347_o-1-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:36:\"AdobeStock_180762347_o-1-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:37:\"AdobeStock_180762347_o-1-1080x598.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:598;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:36:\"AdobeStock_180762347_o-1-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:33:\"©StockPhotoPro - stock.adobe.com\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('433', '204647', '_wp_attached_file', '2017/12/black-dog-in-window.jpg'),
('434', '204647', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:520;s:6:\"height\";i:346;s:4:\"file\";s:31:\"2017/12/black-dog-in-window.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"black-dog-in-window-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:31:\"black-dog-in-window-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:31:\"black-dog-in-window-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:31:\"black-dog-in-window-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:31:\"black-dog-in-window-510x346.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:346;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:31:\"black-dog-in-window-400x346.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:346;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('435', '204649', '_edit_lock', '1512742614:1'),
('436', '204649', '_edit_last', '1'),
('437', '204649', '_wp_page_template', 'default'),
('438', '204649', '_et_pb_post_hide_nav', 'default'),
('439', '204649', '_et_pb_page_layout', 'et_full_width_page'),
('440', '204649', '_et_pb_side_nav', 'off'),
('441', '204649', '_et_pb_use_builder', 'on'),
('442', '204649', '_et_builder_version', 'BB|Divi|3.0.89'),
('443', '204649', '_et_pb_ab_stats_refresh_interval', 'hourly'),
('444', '204649', '_et_pb_old_content', ''),
('445', '204649', '_et_pb_enable_shortcode_tracking', ''),
('446', '204649', '_et_pb_custom_css', ''),
('447', '204651', '_wp_attached_file', '2017/12/unnamed.png'),
('448', '204651', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:189;s:6:\"height\";i:48;s:4:\"file\";s:19:\"2017/12/unnamed.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"unnamed-150x48.png\";s:5:\"width\";i:150;s:6:\"height\";i:48;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('449', '204652', '_wp_attached_file', '2017/12/unnamed-1.png'),
('450', '204652', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:238;s:6:\"height\";i:88;s:4:\"file\";s:21:\"2017/12/unnamed-1.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"unnamed-1-150x88.png\";s:5:\"width\";i:150;s:6:\"height\";i:88;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('451', '204653', '_edit_lock', '1514343400:2'),
('452', '204653', '_edit_last', '2'),
('453', '204654', '_wp_attached_file', '2017/12/csat_seal_web-1.png'),
('454', '204654', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:107;s:6:\"height\";i:80;s:4:\"file\";s:27:\"2017/12/csat_seal_web-1.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('456', '204653', '_et_post_bg_color', '#ffffff'),
('457', '204653', '_et_post_bg_layout', 'light'),
('458', '204653', '_et_pb_show_title', 'on'),
('459', '204653', '_et_pb_post_hide_nav', 'default'),
('460', '204653', '_et_pb_page_layout', 'et_full_width_page'),
('461', '204653', '_et_pb_side_nav', 'off'),
('462', '204653', '_et_pb_use_builder', 'on'),
('463', '204653', '_et_builder_version', 'BB|Divi|3.0.89'),
('464', '204653', '_et_pb_ab_stats_refresh_interval', 'hourly'),
('465', '204653', '_et_pb_old_content', 'Separation anxiety in dogs? When I tell people I recently learned how to work with dogs with separation anxiety, some of them look at me a little funny. And for those lucky people who’s dogs don’t bat an eyelid when their human departs, it can be hard to understand the devastating affect of this condition, not just on the dog, but also on the humans who love them.\r\n\r\nWhat does it look like?\r\nDoes your dog whimper, cry, bark or howl for hours after you’ve gone? Do you come home to a scene of destruction because your dog has been pawing and chewing at the door or skirting boards, destroying your furniture? Does your dog eliminate repeatedly all over your carpet? If this is your dog, he may be suffering from separation anxiety.\r\n\r\nWhat to do?\r\nThe good news is, help is available. Contact a Certified Separation Anxiety Trainer (CSAT) to learn how to gradually introduce your dog to absences, at the rate and duration that your dog can accept calmly.\r\n\r\nWorking with a CSAT means you have access to well-trialed training methods that teach your dog how to be relaxed when left alone. Plus, you have access to all the support, help andcheerleading you need to get you through the challenge of being the guardian of a dog with separation anxiety.\r\n\r\nHow?\r\nTechnology is our friend when working with separation anxiety. By working online you and your trainer see your dog’s response at each step of the process, which means instant feedback informing how to move forward. It is the most efficient route to reaching your goals, gives you more bang for you buck, and means Jenny can work with people across Australia and overseas.\r\n\r\nSo what now?\r\nAs the first dog trainer in Australia to study with international separation anxiety expert Malena DeMartini (www.malenademartini.com ), Jenny is proud to be a CSAT working to improve the lives of dogs with separation anxiety and their long-suffering humans.\r\n\r\nHelp is available. To discuss your dog and learn about this training process, click here (link to the sepanx form).\r\n\r\n<img class=\"alignleft size-full wp-image-204654\" src=\"https://jhdogtraining.wpengine.com/wp-content/uploads/2017/12/csat_seal_web-1.png\" alt=\"\" width=\"107\" height=\"80\" />'),
('466', '204653', '_et_pb_enable_shortcode_tracking', ''),
('467', '204653', '_et_pb_custom_css', ''),
('468', '204656', '_edit_lock', '1515690731:1'),
('469', '204656', '_edit_last', '1'),
('470', '204656', '_wp_page_template', 'default'),
('471', '204656', '_et_pb_post_hide_nav', 'default'),
('472', '204656', '_et_pb_page_layout', 'et_right_sidebar'),
('473', '204656', '_et_pb_side_nav', 'off'),
('474', '204656', '_et_pb_use_builder', 'on'),
('475', '204656', '_et_builder_version', 'BB|Divi|3.0.89'),
('476', '204656', '_et_pb_ab_stats_refresh_interval', 'hourly'),
('477', '204656', '_et_pb_old_content', ''),
('478', '204656', '_et_pb_enable_shortcode_tracking', ''),
('479', '204656', '_et_pb_custom_css', ''),
('480', '204659', '_edit_lock', '1513323811:2'),
('481', '204659', '_edit_last', '2'),
('482', '204660', '_wp_attached_file', '2017/12/toilet-training-lh.pdf'),
('483', '204660', '_wp_attachment_metadata', 'a:1:{s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"toilet-training-lh-pdf-106x150.jpg\";s:5:\"width\";i:106;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"toilet-training-lh-pdf-212x300.jpg\";s:5:\"width\";i:212;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:35:\"toilet-training-lh-pdf-724x1024.jpg\";s:5:\"width\";i:724;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:4:\"full\";a:4:{s:4:\"file\";s:26:\"toilet-training-lh-pdf.jpg\";s:5:\"width\";i:1058;s:6:\"height\";i:1497;s:9:\"mime-type\";s:10:\"image/jpeg\";}}}'),
('497', '204653', '_et_pb_use_ab_testing', 'off'),
('498', '204653', '_et_pb_ab_refresh_interval', 'hourly'),
('500', '204653', '_et_pb_ab_current_shortcode', '[et_pb_split_track id=\"204653\" /]'),
('503', '204672', '_edit_lock', '1514343631:2'),
('504', '204672', '_edit_last', '2'),
('508', '204673', '_edit_lock', '1518008573:1'),
('509', '204673', '_edit_last', '2'),
('510', '204674', '_wp_attached_file', '2017/12/puppy-siberian-toilet.jpg'),
('511', '204674', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:4528;s:6:\"height\";i:2999;s:4:\"file\";s:33:\"2017/12/puppy-siberian-toilet.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"puppy-siberian-toilet-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:33:\"puppy-siberian-toilet-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:33:\"puppy-siberian-toilet-768x509.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:509;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:34:\"puppy-siberian-toilet-1024x678.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:678;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:33:\"puppy-siberian-toilet-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:34:\"puppy-siberian-toilet-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:33:\"puppy-siberian-toilet-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:33:\"puppy-siberian-toilet-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:34:\"puppy-siberian-toilet-1080x715.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:715;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:33:\"puppy-siberian-toilet-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:37:\"et-pb-post-main-image-fullwidth-large\";a:4:{s:4:\"file\";s:35:\"puppy-siberian-toilet-2880x1800.jpg\";s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('513', '204673', '_et_post_bg_color', '#ffffff'),
('514', '204673', '_et_post_bg_layout', 'light'),
('515', '204673', '_et_pb_show_title', 'on'),
('516', '204673', '_et_pb_post_hide_nav', 'default'),
('517', '204673', '_et_pb_page_layout', 'et_right_sidebar'),
('518', '204673', '_et_pb_side_nav', 'off'),
('519', '204673', '_et_pb_use_builder', 'on'),
('520', '204673', '_et_builder_version', 'BB|Divi|3.0.89'),
('521', '204673', '_et_pb_ab_stats_refresh_interval', 'hourly'),
('522', '204673', '_et_pb_old_content', ''),
('523', '204673', '_et_pb_enable_shortcode_tracking', ''),
('524', '204673', '_et_pb_custom_css', ''),
('525', '204678', '_form', '<div>[text* your-name placeholder \"Name\"]</div>\n<div>[email* your-email placeholder \"Email Address\"]</div>\n<div>[tel tel-499 placeholder \"Phone\"]</div>\n<div>[textarea your-message placeholder \"How can I help?\"]</div>\n\n[submit \"Send\"]'),
('526', '204678', '_mail', 'a:9:{s:6:\"active\";b:1;s:7:\"subject\";s:27:\"Jenny Harlow - from website\";s:6:\"sender\";s:44:\"[your-name] <wordpress@jhdogtraining.com.au>\";s:9:\"recipient\";s:26:\"jenny@jhdogtraining.com.au\";s:4:\"body\";s:194:\"From: [your-name] <[your-email]>\nSubject: From website\n\nMessage Body:\n[your-message]\nPhone: [tel-499]\n\n-- \nThis e-mail was sent from a contact form on Jenny Harlow (https://jhdogtraining.com.au)\";s:18:\"additional_headers\";s:22:\"Reply-To: [your-email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}'),
('527', '204678', '_mail_2', 'a:9:{s:6:\"active\";b:0;s:7:\"subject\";s:29:\"Jenny Harlow \"[your-subject]\"\";s:6:\"sender\";s:45:\"Jenny Harlow <wordpress@jhdogtraining.com.au>\";s:9:\"recipient\";s:12:\"[your-email]\";s:4:\"body\";s:121:\"Message Body:\n[your-message]\n\n-- \nThis e-mail was sent from a contact form on Jenny Harlow (https://jhdogtraining.com.au)\";s:18:\"additional_headers\";s:33:\"Reply-To: jennyharlow@bigpond.com\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}'),
('528', '204678', '_messages', 'a:23:{s:12:\"mail_sent_ok\";s:45:\"Thank you for your message. It has been sent.\";s:12:\"mail_sent_ng\";s:71:\"There was an error trying to send your message. Please try again later.\";s:16:\"validation_error\";s:61:\"One or more fields have an error. Please check and try again.\";s:4:\"spam\";s:71:\"There was an error trying to send your message. Please try again later.\";s:12:\"accept_terms\";s:69:\"You must accept the terms and conditions before sending your message.\";s:16:\"invalid_required\";s:22:\"The field is required.\";s:16:\"invalid_too_long\";s:22:\"The field is too long.\";s:17:\"invalid_too_short\";s:23:\"The field is too short.\";s:12:\"invalid_date\";s:29:\"The date format is incorrect.\";s:14:\"date_too_early\";s:44:\"The date is before the earliest one allowed.\";s:13:\"date_too_late\";s:41:\"The date is after the latest one allowed.\";s:13:\"upload_failed\";s:46:\"There was an unknown error uploading the file.\";s:24:\"upload_file_type_invalid\";s:49:\"You are not allowed to upload files of this type.\";s:21:\"upload_file_too_large\";s:20:\"The file is too big.\";s:23:\"upload_failed_php_error\";s:38:\"There was an error uploading the file.\";s:14:\"invalid_number\";s:29:\"The number format is invalid.\";s:16:\"number_too_small\";s:47:\"The number is smaller than the minimum allowed.\";s:16:\"number_too_large\";s:46:\"The number is larger than the maximum allowed.\";s:23:\"quiz_answer_not_correct\";s:36:\"The answer to the quiz is incorrect.\";s:17:\"captcha_not_match\";s:31:\"Your entered code is incorrect.\";s:13:\"invalid_email\";s:38:\"The e-mail address entered is invalid.\";s:11:\"invalid_url\";s:19:\"The URL is invalid.\";s:11:\"invalid_tel\";s:32:\"The telephone number is invalid.\";}'),
('529', '204678', '_additional_settings', ''),
('530', '204678', '_locale', 'en_US'),
('531', '204679', '_form', '<div>[text* your-name placeholder \"First Name\"]</div>\n<div>[text text-879 placeholder \"Last Name\"]</div>\n<div>[tel tel-499 placeholder \"Phone Number\"]</div>\n<div>[email* your-email placeholder \"Email Address\"]</div>\n<div>[text location placeholder \"Your Location\"]</div>\n<div>[text dogs-name placeholder \"Dog\'s Name\"]</div>\n<div>[text dogs-age placeholder \"Dog\'s Age\"]</div>\n<div>[text dogs-breed placeholder \"Dog\'s Breed\"]</div>\n<div>[text dogs-gender placeholder \"Dog\'s Gender\"]</div>\n<div>[text where-is-dog-from placeholder \"Where did you get the dog? (breeder, shelter etc)\"]</div>\n<div>[text how-long-id-dog-with-you placeholder \"How Long has the dog been in your home?\"]</div>\n<div>[text how-often-is-dog-alone placeholder \"How often is the dog currently being left alone?\"]</div>\n<div>[textarea other-comments-dog-alone placeholder \"If you have any other comments about your dog’s home alone time, please enter here.\"]</div>\n<p>Can you alter your schedule so that your dog will not have to be left alone during the training period? ( Please keep in mind, dog is not considered alone when accompanied by someone, in or outside of your home, in an environment where they are comfortable.)</p>\n<div>[radio alter-schedule default:1 \"Yes\" \"No\" \"Maybe\"]</div>\n<p>Have you done any previous training to address your dog\'s separation anxiety?*</p>\n<div>[radio previous-training default:1 \"Yes\" \"No\"]</div>\n<div>[textarea describe-previous-training placeholder \"Please describe.\"]</div>\n<div>[radio discussed-with-veterinarian default:1 \"Yes\" \"No\" placeholder \"Have you discussed your dog\'s separation anxiety with your veterinarian?*\"]</div>\n<div>[textarea explain-veterinarian placeholder \"If you answered \'yes\' to the above question, please explain.\"]</div>\n<div>[text how-long-alone placeholder \"How long would you like to be able to leave your dog alone in the future?\"]</div>\n<div>[textarea additional-comments-alone placeholder \"If you have any additional comments regarding your dog’s future alone time, please enter those here.\"]</div>\n\n[submit \"Send\"]'),
('532', '204679', '_mail', 'a:9:{s:6:\"active\";b:1;s:7:\"subject\";s:49:\"Jenny Harlow - separation anxiety assessment form\";s:6:\"sender\";s:44:\"[your-name] <wordpress@jhdogtraining.com.au>\";s:9:\"recipient\";s:26:\"jenny@jhdogtraining.com.au\";s:4:\"body\";s:975:\"From: [your-name] <[your-email]>\nSubject: From website\n\nMessage Body:\nLast Name: [text-879]\nPhone: [tel-499]\nLocation: [location]\nDog\'s Name: [dogs-name]\nDog\'s Age: [dogs-age]\nDog\'s Breed: [dogs-breed]\nDog\'s Gender: [dogs-gender]\nWhere did you get the dog? - [where-is-dog-from]\nHow Long has the dog been in your home? - [how-long-id-dog-with-you]\nHow often is the dog currently being left alone? - [how-often-is-dog-alone]\nOther Comments: [other-comments-dog-alone]\nAlter Schedule: [alter-schedule]\nPrevious Training: [previous-training]\nDescribe Previous Training: [describe-previous-training]\nDiscussed with veterinarian: [discussed-with-veterinarian]\nExplain veterinarian: [explain-veterinarian]\nHow long would you like to be able to leave your dog alone in the future? - [how-long-alone]\nAdditional comments regarding your dog’s future alone time: [additional-comments-alone]\n\n-- \nThis e-mail was sent from a contact form on Jenny Harlow (https://jhdogtraining.com.au)\";s:18:\"additional_headers\";s:22:\"Reply-To: [your-email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}'),
('533', '204679', '_mail_2', 'a:9:{s:6:\"active\";b:0;s:7:\"subject\";s:29:\"Jenny Harlow \"[your-subject]\"\";s:6:\"sender\";s:45:\"Jenny Harlow <wordpress@jhdogtraining.com.au>\";s:9:\"recipient\";s:12:\"[your-email]\";s:4:\"body\";s:121:\"Message Body:\n[your-message]\n\n-- \nThis e-mail was sent from a contact form on Jenny Harlow (https://jhdogtraining.com.au)\";s:18:\"additional_headers\";s:33:\"Reply-To: jennyharlow@bigpond.com\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}'),
('534', '204679', '_messages', 'a:23:{s:12:\"mail_sent_ok\";s:45:\"Thank you for your message. It has been sent.\";s:12:\"mail_sent_ng\";s:71:\"There was an error trying to send your message. Please try again later.\";s:16:\"validation_error\";s:61:\"One or more fields have an error. Please check and try again.\";s:4:\"spam\";s:71:\"There was an error trying to send your message. Please try again later.\";s:12:\"accept_terms\";s:69:\"You must accept the terms and conditions before sending your message.\";s:16:\"invalid_required\";s:22:\"The field is required.\";s:16:\"invalid_too_long\";s:22:\"The field is too long.\";s:17:\"invalid_too_short\";s:23:\"The field is too short.\";s:12:\"invalid_date\";s:29:\"The date format is incorrect.\";s:14:\"date_too_early\";s:44:\"The date is before the earliest one allowed.\";s:13:\"date_too_late\";s:41:\"The date is after the latest one allowed.\";s:13:\"upload_failed\";s:46:\"There was an unknown error uploading the file.\";s:24:\"upload_file_type_invalid\";s:49:\"You are not allowed to upload files of this type.\";s:21:\"upload_file_too_large\";s:20:\"The file is too big.\";s:23:\"upload_failed_php_error\";s:38:\"There was an error uploading the file.\";s:14:\"invalid_number\";s:29:\"The number format is invalid.\";s:16:\"number_too_small\";s:47:\"The number is smaller than the minimum allowed.\";s:16:\"number_too_large\";s:46:\"The number is larger than the maximum allowed.\";s:23:\"quiz_answer_not_correct\";s:36:\"The answer to the quiz is incorrect.\";s:17:\"captcha_not_match\";s:31:\"Your entered code is incorrect.\";s:13:\"invalid_email\";s:38:\"The e-mail address entered is invalid.\";s:11:\"invalid_url\";s:19:\"The URL is invalid.\";s:11:\"invalid_tel\";s:32:\"The telephone number is invalid.\";}'),
('535', '204679', '_additional_settings', ''),
('536', '204679', '_locale', 'en_US'),
('537', '204685', '_et_pb_predefined_layout', 'on'),
('538', '204685', '_et_pb_built_for_post_type', 'page'),
('539', '204685', '_et_pb_layout_applicability', 'product_tour'),
('605', '204557', '_et_pb_ab_refresh_interval', 'hourly'),
('607', '204557', '_et_pb_ab_current_shortcode', '[et_pb_split_track id=\"204557\" /]'),
('608', '204726', 'iwp_log_type', 'scheduleBackup'),
('609', '204726', 'iwp_log_action', 'schedule'),
('610', '204726', 'iwp_log_activities_type', 'iwp_log'),
('611', '204726', 'iwp_log_actions', 'backups'),
('612', '204726', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('613', '204727', 'iwp_log_type', 'backup'),
('614', '204727', 'iwp_log_action', 'multiCallNow'),
('615', '204727', 'iwp_log_activities_type', 'iwp_log'),
('616', '204727', 'iwp_log_actions', 'backups'),
('617', '204727', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:11:\"siteupdates\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('618', '204728', 'iwp_log_type', 'themes'),
('619', '204728', 'iwp_log_action', 'update'),
('620', '204728', 'iwp_log_activities_type', 'direct'),
('621', '204728', 'iwp_log_actions', 'themes-updated'),
('622', '204728', 'iwp_log_details', 'a:4:{s:4:\"name\";s:4:\"Divi\";s:4:\"slug\";s:4:\"Divi\";s:11:\"old_version\";s:5:\"3.1.1\";s:15:\"updated_version\";s:5:\"3.2.2\";}'),
('623', '204729', 'iwp_log_type', 'scheduleBackup'),
('624', '204729', 'iwp_log_action', 'schedule'),
('625', '204729', 'iwp_log_activities_type', 'iwp_log'),
('626', '204729', 'iwp_log_actions', 'backups'),
('627', '204729', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('628', '204730', 'iwp_log_type', 'scheduleBackup'),
('629', '204730', 'iwp_log_action', 'schedule'),
('630', '204730', 'iwp_log_activities_type', 'iwp_log'),
('631', '204730', 'iwp_log_actions', 'backups'),
('632', '204730', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('633', '204734', '_edit_lock', '1527048194:2'),
('634', '204734', '_edit_last', '2'),
('635', '204734', '_wp_page_template', 'default'),
('636', '204734', '_et_pb_post_hide_nav', 'default'),
('637', '204734', '_et_pb_page_layout', 'et_right_sidebar'),
('638', '204734', '_et_pb_side_nav', 'off'),
('639', '204734', '_et_pb_use_builder', ''),
('640', '204734', '_et_builder_version', 'BB|Divi|3.2.2'),
('641', '204734', '_et_pb_ab_stats_refresh_interval', 'hourly'),
('642', '204734', '_et_pb_old_content', ''),
('643', '204734', '_et_pb_enable_shortcode_tracking', ''),
('644', '204734', '_et_pb_custom_css', ''),
('646', '204736', '_edit_lock', '1527225896:2'),
('647', '204736', '_edit_last', '2'),
('649', '204736', '_et_post_bg_color', '#ffffff'),
('650', '204736', '_et_post_bg_layout', 'light'),
('651', '204736', '_et_pb_show_title', 'on'),
('652', '204736', '_et_pb_post_hide_nav', 'default'),
('653', '204736', '_et_pb_page_layout', 'et_right_sidebar'),
('654', '204736', '_et_pb_side_nav', 'off'),
('655', '204736', '_et_pb_use_builder', ''),
('656', '204736', '_et_builder_version', 'BB|Divi|3.2.2'),
('657', '204736', '_et_pb_ab_stats_refresh_interval', 'hourly'),
('658', '204736', '_et_pb_old_content', ''),
('659', '204736', '_et_pb_enable_shortcode_tracking', ''),
('660', '204736', '_et_pb_custom_css', ''),
('662', '204740', 'iwp_log_type', 'scheduleBackup'),
('663', '204740', 'iwp_log_action', 'schedule'),
('664', '204740', 'iwp_log_activities_type', 'iwp_log'),
('665', '204740', 'iwp_log_actions', 'backups'),
('666', '204740', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('667', '204741', 'iwp_log_type', 'scheduleBackup'),
('668', '204741', 'iwp_log_action', 'schedule'),
('669', '204741', 'iwp_log_activities_type', 'iwp_log'),
('670', '204741', 'iwp_log_actions', 'backups'),
('671', '204741', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('672', '204742', 'iwp_log_type', 'themes'),
('673', '204742', 'iwp_log_action', 'update'),
('674', '204742', 'iwp_log_activities_type', 'direct'),
('675', '204742', 'iwp_log_actions', 'themes-updated'),
('676', '204742', 'iwp_log_details', 'a:4:{s:4:\"name\";s:16:\"Twenty Seventeen\";s:4:\"slug\";s:16:\"Twenty Seventeen\";s:11:\"old_version\";s:3:\"1.5\";s:15:\"updated_version\";s:3:\"1.6\";}'),
('677', '204743', 'iwp_log_type', 'plugins'),
('678', '204743', 'iwp_log_action', 'update'),
('679', '204743', 'iwp_log_activities_type', 'direct'),
('680', '204743', 'iwp_log_actions', 'plugins-updated'),
('681', '204743', 'iwp_log_details', 'a:4:{s:4:\"name\";s:14:\"ActiveCampaign\";s:4:\"slug\";s:52:\"activecampaign-subscription-forms/activecampaign.php\";s:11:\"old_version\";s:6:\"6.2.12\";s:15:\"updated_version\";s:3:\"6.3\";}'),
('682', '204744', 'iwp_log_type', 'plugins'),
('683', '204744', 'iwp_log_action', 'update'),
('684', '204744', 'iwp_log_activities_type', 'direct'),
('685', '204744', 'iwp_log_actions', 'plugins-updated'),
('686', '204744', 'iwp_log_details', 'a:4:{s:4:\"name\";s:14:\"Contact Form 7\";s:4:\"slug\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"old_version\";s:5:\"5.0.1\";s:15:\"updated_version\";s:5:\"5.0.2\";}'),
('687', '204745', 'iwp_log_type', 'themes'),
('688', '204745', 'iwp_log_action', 'update'),
('689', '204745', 'iwp_log_activities_type', 'direct'),
('690', '204745', 'iwp_log_actions', 'themes-updated'),
('691', '204745', 'iwp_log_details', 'a:4:{s:4:\"name\";s:4:\"Divi\";s:4:\"slug\";s:4:\"Divi\";s:11:\"old_version\";s:5:\"3.2.2\";s:15:\"updated_version\";s:5:\"3.4.1\";}'),
('692', '204746', 'iwp_log_type', 'scheduleBackup'),
('693', '204746', 'iwp_log_action', 'schedule'),
('694', '204746', 'iwp_log_activities_type', 'iwp_log'),
('695', '204746', 'iwp_log_actions', 'backups'),
('696', '204746', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('697', '204747', 'iwp_log_type', 'backup'),
('698', '204747', 'iwp_log_action', 'multiCallNow'),
('699', '204747', 'iwp_log_activities_type', 'iwp_log'),
('700', '204747', 'iwp_log_actions', 'backups'),
('701', '204747', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:14:\"weekly Updates\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('702', '204749', 'iwp_log_type', 'plugins'),
('703', '204749', 'iwp_log_action', 'update'),
('704', '204749', 'iwp_log_activities_type', 'iwp_log'),
('705', '204749', 'iwp_log_actions', 'plugins-updated'),
('706', '204749', 'iwp_log_details', 'a:4:{s:4:\"name\";s:14:\"ActiveCampaign\";s:4:\"slug\";s:33:\"activecampaign-subscription-forms\";s:11:\"old_version\";s:3:\"6.3\";s:15:\"updated_version\";s:3:\"7.0\";}'),
('707', '204750', 'iwp_log_type', 'themes'),
('708', '204750', 'iwp_log_action', 'update'),
('709', '204750', 'iwp_log_activities_type', 'direct'),
('710', '204750', 'iwp_log_actions', 'themes-updated'),
('711', '204750', 'iwp_log_details', 'a:4:{s:4:\"name\";s:4:\"Divi\";s:4:\"slug\";s:4:\"Divi\";s:11:\"old_version\";s:5:\"3.4.1\";s:15:\"updated_version\";s:3:\"3.6\";}'),
('712', '204751', 'iwp_log_type', 'scheduleBackup'),
('713', '204751', 'iwp_log_action', 'schedule'),
('714', '204751', 'iwp_log_activities_type', 'iwp_log'),
('715', '204751', 'iwp_log_actions', 'backups'),
('716', '204751', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('717', '204752', '_edit_lock', '1528694718:2'),
('718', '204752', '_edit_last', '2'),
('719', '204753', '_wp_attached_file', '2018/06/dog-howling.jpg'),
('720', '204753', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:5589;s:6:\"height\";i:3726;s:4:\"file\";s:23:\"2018/06/dog-howling.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"dog-howling-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"dog-howling-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"dog-howling-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:24:\"dog-howling-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:23:\"dog-howling-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:24:\"dog-howling-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:23:\"dog-howling-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:23:\"dog-howling-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:24:\"dog-howling-1080x720.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:23:\"dog-howling-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:37:\"et-pb-post-main-image-fullwidth-large\";a:4:{s:4:\"file\";s:25:\"dog-howling-2880x1800.jpg\";s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('721', '204754', '_wp_attached_file', '2018/06/bc-puppy-in-rubbish-bin.jpg'),
('722', '204754', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:5701;s:6:\"height\";i:3819;s:4:\"file\";s:35:\"2018/06/bc-puppy-in-rubbish-bin.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:35:\"bc-puppy-in-rubbish-bin-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:35:\"bc-puppy-in-rubbish-bin-300x201.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:201;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:35:\"bc-puppy-in-rubbish-bin-768x514.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:514;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:36:\"bc-puppy-in-rubbish-bin-1024x686.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:686;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:35:\"bc-puppy-in-rubbish-bin-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:36:\"bc-puppy-in-rubbish-bin-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:35:\"bc-puppy-in-rubbish-bin-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:35:\"bc-puppy-in-rubbish-bin-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:36:\"bc-puppy-in-rubbish-bin-1080x723.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:723;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:35:\"bc-puppy-in-rubbish-bin-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:37:\"et-pb-post-main-image-fullwidth-large\";a:4:{s:4:\"file\";s:37:\"bc-puppy-in-rubbish-bin-2880x1800.jpg\";s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('723', '204755', '_wp_attached_file', '2018/06/puppy-in-garbage-bin.jpg'),
('724', '204755', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:3514;s:6:\"height\";i:3514;s:4:\"file\";s:32:\"2018/06/puppy-in-garbage-bin.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:32:\"puppy-in-garbage-bin-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:32:\"puppy-in-garbage-bin-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:32:\"puppy-in-garbage-bin-768x768.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:34:\"puppy-in-garbage-bin-1024x1024.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:32:\"puppy-in-garbage-bin-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:33:\"puppy-in-garbage-bin-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:32:\"puppy-in-garbage-bin-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:32:\"puppy-in-garbage-bin-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:34:\"puppy-in-garbage-bin-1080x1080.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:1080;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:32:\"puppy-in-garbage-bin-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:37:\"et-pb-post-main-image-fullwidth-large\";a:4:{s:4:\"file\";s:34:\"puppy-in-garbage-bin-2880x1800.jpg\";s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('725', '204752', '_wp_page_template', 'default'),
('726', '204752', '_et_pb_post_hide_nav', 'default'),
('727', '204752', '_et_pb_page_layout', 'et_right_sidebar'),
('728', '204752', '_et_pb_side_nav', 'off'),
('729', '204752', '_et_pb_use_builder', ''),
('730', '204752', '_et_builder_version', 'BB|Divi|3.6'),
('731', '204752', '_et_pb_ab_stats_refresh_interval', 'hourly'),
('732', '204752', '_et_pb_old_content', ''),
('733', '204752', '_et_pb_enable_shortcode_tracking', ''),
('734', '204752', '_et_pb_custom_css', ''),
('735', '204756', '_edit_lock', '1528695002:2'),
('736', '204756', '_edit_last', '2'),
('737', '204757', '_edit_lock', '1528695692:2'),
('738', '204757', '_edit_last', '2'),
('739', '204757', '_wp_page_template', 'default'),
('740', '204757', '_et_pb_post_hide_nav', 'default'),
('741', '204757', '_et_pb_page_layout', 'et_right_sidebar'),
('742', '204757', '_et_pb_side_nav', 'off'),
('743', '204757', '_et_pb_use_builder', ''),
('744', '204757', '_et_builder_version', 'BB|Divi|3.6'),
('745', '204757', '_et_pb_ab_stats_refresh_interval', 'hourly'),
('746', '204757', '_et_pb_old_content', ''),
('747', '204757', '_et_pb_enable_shortcode_tracking', ''),
('748', '204757', '_et_pb_custom_css', ''),
('749', '204758', '_edit_lock', '1551921117:2'),
('750', '204758', '_edit_last', '2'),
('751', '204758', '_et_post_bg_color', '#ffffff'),
('752', '204758', '_et_post_bg_layout', 'light'),
('753', '204758', '_et_pb_show_title', 'on'),
('754', '204758', '_et_pb_post_hide_nav', 'default'),
('755', '204758', '_et_pb_page_layout', 'et_right_sidebar'),
('756', '204758', '_et_pb_side_nav', 'off'),
('757', '204758', '_et_pb_use_builder', ''),
('758', '204758', '_et_builder_version', 'BB|Divi|3.19.18'),
('759', '204758', '_et_pb_ab_stats_refresh_interval', 'hourly'),
('760', '204758', '_et_pb_old_content', ''),
('761', '204758', '_et_pb_enable_shortcode_tracking', ''),
('762', '204758', '_et_pb_custom_css', ''),
('763', '204759', 'iwp_log_type', 'scheduleBackup'),
('764', '204759', 'iwp_log_action', 'schedule'),
('765', '204759', 'iwp_log_activities_type', 'iwp_log'),
('766', '204759', 'iwp_log_actions', 'backups'),
('767', '204759', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('768', '204760', 'iwp_log_type', 'scheduleBackup'),
('769', '204760', 'iwp_log_action', 'schedule'),
('770', '204760', 'iwp_log_activities_type', 'iwp_log'),
('771', '204760', 'iwp_log_actions', 'backups'),
('772', '204760', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('773', '204761', 'iwp_log_type', 'backup'),
('774', '204761', 'iwp_log_action', 'now'),
('775', '204761', 'iwp_log_activities_type', 'iwp_log'),
('776', '204761', 'iwp_log_actions', 'backups'),
('777', '204761', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:7:\"updates\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:10:\"singleCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('778', '204762', 'iwp_log_type', 'scheduleBackup'),
('779', '204762', 'iwp_log_action', 'schedule'),
('780', '204762', 'iwp_log_activities_type', 'iwp_log'),
('781', '204762', 'iwp_log_actions', 'backups'),
('782', '204762', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('783', '204763', 'iwp_log_type', 'backup'),
('784', '204763', 'iwp_log_action', 'multiCallNow'),
('785', '204763', 'iwp_log_activities_type', 'iwp_log'),
('786', '204763', 'iwp_log_actions', 'backups'),
('787', '204763', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:10:\"preupdates\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('788', '204765', 'iwp_log_type', 'themes'),
('789', '204765', 'iwp_log_action', 'update'),
('790', '204765', 'iwp_log_activities_type', 'direct'),
('791', '204765', 'iwp_log_actions', 'themes-updated'),
('792', '204765', 'iwp_log_details', 'a:4:{s:4:\"name\";s:4:\"Divi\";s:4:\"slug\";s:4:\"Divi\";s:11:\"old_version\";s:3:\"3.6\";s:15:\"updated_version\";s:3:\"3.9\";}'),
('793', '204766', 'iwp_log_type', 'scheduleBackup'),
('794', '204766', 'iwp_log_action', 'schedule'),
('795', '204766', 'iwp_log_activities_type', 'iwp_log'),
('796', '204766', 'iwp_log_actions', 'backups'),
('797', '204766', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('798', '204767', 'iwp_log_type', 'scheduleBackup'),
('799', '204767', 'iwp_log_action', 'schedule'),
('800', '204767', 'iwp_log_activities_type', 'iwp_log'),
('801', '204767', 'iwp_log_actions', 'backups'),
('802', '204767', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('803', '204768', 'iwp_log_type', 'scheduleBackup'),
('804', '204768', 'iwp_log_action', 'schedule'),
('805', '204768', 'iwp_log_activities_type', 'iwp_log'),
('806', '204768', 'iwp_log_actions', 'backups'),
('807', '204768', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('808', '204769', 'iwp_log_type', 'scheduleBackup'),
('809', '204769', 'iwp_log_action', 'schedule'),
('810', '204769', 'iwp_log_activities_type', 'iwp_log'),
('811', '204769', 'iwp_log_actions', 'backups'),
('812', '204769', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('813', '204771', '_edit_lock', '1533098850:2'),
('814', '204771', '_edit_last', '2'),
('815', '204772', '_wp_attached_file', '2018/08/orchids-dogs.jpg'),
('816', '204772', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:4032;s:6:\"height\";i:3024;s:4:\"file\";s:24:\"2018/08/orchids-dogs.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"orchids-dogs-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"orchids-dogs-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:24:\"orchids-dogs-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:25:\"orchids-dogs-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:24:\"orchids-dogs-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:25:\"orchids-dogs-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:24:\"orchids-dogs-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:24:\"orchids-dogs-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:25:\"orchids-dogs-1080x810.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:810;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:24:\"orchids-dogs-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:37:\"et-pb-post-main-image-fullwidth-large\";a:4:{s:4:\"file\";s:26:\"orchids-dogs-2880x1800.jpg\";s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"1.8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:8:\"iPhone X\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1532963949\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"4\";s:3:\"iso\";s:2:\"25\";s:13:\"shutter_speed\";s:16:\"0.00833333333333\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"6\";s:8:\"keywords\";a:0:{}}}'),
('817', '204771', '_wp_page_template', 'default'),
('818', '204771', '_et_pb_post_hide_nav', 'default'),
('819', '204771', '_et_pb_page_layout', 'et_right_sidebar'),
('820', '204771', '_et_pb_side_nav', 'off'),
('821', '204771', '_et_pb_use_builder', ''),
('822', '204771', '_et_builder_version', 'BB|Divi|3.9'),
('823', '204771', '_et_pb_ab_stats_refresh_interval', 'hourly'),
('824', '204771', '_et_pb_old_content', ''),
('825', '204771', '_et_pb_enable_shortcode_tracking', ''),
('826', '204771', '_et_pb_custom_css', ''),
('844', '204774', 'iwp_log_type', 'scheduleBackup'),
('845', '204774', 'iwp_log_action', 'schedule'),
('846', '204774', 'iwp_log_activities_type', 'iwp_log'),
('847', '204774', 'iwp_log_actions', 'backups'),
('848', '204774', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('849', '204775', 'iwp_log_type', 'backup'),
('850', '204775', 'iwp_log_action', 'multiCallNow'),
('851', '204775', 'iwp_log_activities_type', 'iwp_log'),
('852', '204775', 'iwp_log_actions', 'backups'),
('853', '204775', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:11:\"preup-dates\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('854', '204776', 'iwp_log_type', 'plugins'),
('855', '204776', 'iwp_log_action', 'update'),
('856', '204776', 'iwp_log_activities_type', 'direct'),
('857', '204776', 'iwp_log_actions', 'plugins-updated'),
('858', '204776', 'iwp_log_details', 'a:4:{s:4:\"name\";s:14:\"Contact Form 7\";s:4:\"slug\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"old_version\";s:5:\"5.0.2\";s:15:\"updated_version\";s:5:\"5.0.3\";}'),
('859', '204777', 'iwp_log_type', 'themes'),
('860', '204777', 'iwp_log_action', 'update'),
('861', '204777', 'iwp_log_activities_type', 'direct'),
('862', '204777', 'iwp_log_actions', 'themes-updated'),
('863', '204777', 'iwp_log_details', 'a:4:{s:4:\"name\";s:16:\"Twenty Seventeen\";s:4:\"slug\";s:16:\"Twenty Seventeen\";s:11:\"old_version\";s:3:\"1.6\";s:15:\"updated_version\";s:3:\"1.7\";}'),
('864', '204778', 'iwp_log_type', 'themes'),
('865', '204778', 'iwp_log_action', 'update'),
('866', '204778', 'iwp_log_activities_type', 'direct'),
('867', '204778', 'iwp_log_actions', 'themes-updated'),
('868', '204778', 'iwp_log_details', 'a:4:{s:4:\"name\";s:4:\"Divi\";s:4:\"slug\";s:4:\"Divi\";s:11:\"old_version\";s:3:\"3.9\";s:15:\"updated_version\";s:6:\"3.11.1\";}'),
('871', '204780', '_wp_attached_file', '2018/08/dog-training-focus.look_-e1533706776374.jpg'),
('872', '204780', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:3024;s:6:\"height\";i:4032;s:4:\"file\";s:51:\"2018/08/dog-training-focus.look_-e1533706776374.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:51:\"dog-training-focus.look_-e1533706776374-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:51:\"dog-training-focus.look_-e1533706776374-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:52:\"dog-training-focus.look_-e1533706776374-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:52:\"dog-training-focus.look_-e1533706776374-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:51:\"dog-training-focus.look_-e1533706776374-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:52:\"dog-training-focus.look_-e1533706776374-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:51:\"dog-training-focus.look_-e1533706776374-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:51:\"dog-training-focus.look_-e1533706776374-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:53:\"dog-training-focus.look_-e1533706776374-1080x1440.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:1440;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:51:\"dog-training-focus.look_-e1533706776374-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:37:\"et-pb-post-main-image-fullwidth-large\";a:4:{s:4:\"file\";s:53:\"dog-training-focus.look_-e1533706776374-2880x1800.jpg\";s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"2.4\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:8:\"iPhone X\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1527179101\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"6\";s:3:\"iso\";s:3:\"100\";s:13:\"shutter_speed\";s:15:\"0.0166666666667\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"6\";s:8:\"keywords\";a:0:{}}}'),
('873', '204781', '_wp_attached_file', '2018/08/reward-while-walking-e1533706723807.jpg'),
('874', '204781', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:3024;s:6:\"height\";i:4032;s:4:\"file\";s:47:\"2018/08/reward-while-walking-e1533706723807.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:47:\"reward-while-walking-e1533706723807-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:47:\"reward-while-walking-e1533706723807-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:48:\"reward-while-walking-e1533706723807-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:48:\"reward-while-walking-e1533706723807-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:47:\"reward-while-walking-e1533706723807-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:48:\"reward-while-walking-e1533706723807-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:47:\"reward-while-walking-e1533706723807-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:47:\"reward-while-walking-e1533706723807-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:49:\"reward-while-walking-e1533706723807-1080x1440.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:1440;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:47:\"reward-while-walking-e1533706723807-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:37:\"et-pb-post-main-image-fullwidth-large\";a:4:{s:4:\"file\";s:49:\"reward-while-walking-e1533706723807-2880x1800.jpg\";s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"2.4\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:8:\"iPhone X\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1527179125\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"6\";s:3:\"iso\";s:3:\"200\";s:13:\"shutter_speed\";s:16:\"0.00833333333333\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"6\";s:8:\"keywords\";a:0:{}}}'),
('875', '204781', '_wp_attachment_backup_sizes', 'a:12:{s:9:\"full-orig\";a:3:{s:5:\"width\";i:4032;s:6:\"height\";i:3024;s:4:\"file\";s:24:\"reward-while-walking.jpg\";}s:14:\"thumbnail-orig\";a:4:{s:4:\"file\";s:32:\"reward-while-walking-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"medium-orig\";a:4:{s:4:\"file\";s:32:\"reward-while-walking-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:17:\"medium_large-orig\";a:4:{s:4:\"file\";s:32:\"reward-while-walking-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"large-orig\";a:4:{s:4:\"file\";s:33:\"reward-while-walking-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:26:\"et-pb-post-main-image-orig\";a:4:{s:4:\"file\";s:32:\"reward-while-walking-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:36:\"et-pb-post-main-image-fullwidth-orig\";a:4:{s:4:\"file\";s:33:\"reward-while-walking-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:26:\"et-pb-portfolio-image-orig\";a:4:{s:4:\"file\";s:32:\"reward-while-walking-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"et-pb-portfolio-module-image-orig\";a:4:{s:4:\"file\";s:32:\"reward-while-walking-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"et-pb-portfolio-image-single-orig\";a:4:{s:4:\"file\";s:33:\"reward-while-walking-1080x810.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:810;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:40:\"et-pb-gallery-module-image-portrait-orig\";a:4:{s:4:\"file\";s:32:\"reward-while-walking-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:42:\"et-pb-post-main-image-fullwidth-large-orig\";a:4:{s:4:\"file\";s:34:\"reward-while-walking-2880x1800.jpg\";s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:9:\"mime-type\";s:10:\"image/jpeg\";}}'),
('876', '204782', '_wp_attached_file', '2018/08/reward-while-walking-2.jpg'),
('877', '204782', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:1732;s:6:\"height\";i:1930;s:4:\"file\";s:34:\"2018/08/reward-while-walking-2.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"reward-while-walking-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"reward-while-walking-2-269x300.jpg\";s:5:\"width\";i:269;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:34:\"reward-while-walking-2-768x856.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:856;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:35:\"reward-while-walking-2-919x1024.jpg\";s:5:\"width\";i:919;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:34:\"reward-while-walking-2-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:35:\"reward-while-walking-2-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:34:\"reward-while-walking-2-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:34:\"reward-while-walking-2-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:36:\"reward-while-walking-2-1080x1203.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:1203;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:34:\"reward-while-walking-2-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:37:\"et-pb-post-main-image-fullwidth-large\";a:4:{s:4:\"file\";s:36:\"reward-while-walking-2-1732x1800.jpg\";s:5:\"width\";i:1732;s:6:\"height\";i:1800;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"2.4\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:8:\"iPhone X\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1527178953\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"6\";s:3:\"iso\";s:3:\"125\";s:13:\"shutter_speed\";s:4:\"0.01\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}'),
('878', '204780', '_wp_attachment_backup_sizes', 'a:12:{s:9:\"full-orig\";a:3:{s:5:\"width\";i:4032;s:6:\"height\";i:3024;s:4:\"file\";s:28:\"dog-training-focus.look_.jpg\";}s:14:\"thumbnail-orig\";a:4:{s:4:\"file\";s:36:\"dog-training-focus.look_-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"medium-orig\";a:4:{s:4:\"file\";s:36:\"dog-training-focus.look_-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:17:\"medium_large-orig\";a:4:{s:4:\"file\";s:36:\"dog-training-focus.look_-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"large-orig\";a:4:{s:4:\"file\";s:37:\"dog-training-focus.look_-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:26:\"et-pb-post-main-image-orig\";a:4:{s:4:\"file\";s:36:\"dog-training-focus.look_-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:36:\"et-pb-post-main-image-fullwidth-orig\";a:4:{s:4:\"file\";s:37:\"dog-training-focus.look_-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:26:\"et-pb-portfolio-image-orig\";a:4:{s:4:\"file\";s:36:\"dog-training-focus.look_-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"et-pb-portfolio-module-image-orig\";a:4:{s:4:\"file\";s:36:\"dog-training-focus.look_-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"et-pb-portfolio-image-single-orig\";a:4:{s:4:\"file\";s:37:\"dog-training-focus.look_-1080x810.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:810;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:40:\"et-pb-gallery-module-image-portrait-orig\";a:4:{s:4:\"file\";s:36:\"dog-training-focus.look_-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:42:\"et-pb-post-main-image-fullwidth-large-orig\";a:4:{s:4:\"file\";s:38:\"dog-training-focus.look_-2880x1800.jpg\";s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:9:\"mime-type\";s:10:\"image/jpeg\";}}'),
('898', '204784', 'iwp_log_type', 'scheduleBackup'),
('899', '204784', 'iwp_log_action', 'schedule'),
('900', '204784', 'iwp_log_activities_type', 'iwp_log'),
('901', '204784', 'iwp_log_actions', 'backups'),
('902', '204784', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('903', '204785', 'iwp_log_type', 'backup'),
('904', '204785', 'iwp_log_action', 'multiCallNow'),
('905', '204785', 'iwp_log_activities_type', 'iwp_log'),
('906', '204785', 'iwp_log_actions', 'backups'),
('907', '204785', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:10:\"preupdates\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('908', '204786', 'iwp_log_type', 'themes'),
('909', '204786', 'iwp_log_action', 'update'),
('910', '204786', 'iwp_log_activities_type', 'direct'),
('911', '204786', 'iwp_log_actions', 'themes-updated'),
('912', '204786', 'iwp_log_details', 'a:4:{s:4:\"name\";s:4:\"Divi\";s:4:\"slug\";s:4:\"Divi\";s:11:\"old_version\";s:6:\"3.11.1\";s:15:\"updated_version\";s:4:\"3.12\";}'),
('913', '204787', 'iwp_log_type', 'scheduleBackup'),
('914', '204787', 'iwp_log_action', 'schedule'),
('915', '204787', 'iwp_log_activities_type', 'iwp_log'),
('916', '204787', 'iwp_log_actions', 'backups'),
('917', '204787', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('918', '204790', 'iwp_log_type', 'themes'),
('919', '204790', 'iwp_log_action', 'update'),
('920', '204790', 'iwp_log_activities_type', 'direct'),
('921', '204790', 'iwp_log_actions', 'themes-updated'),
('922', '204790', 'iwp_log_details', 'a:4:{s:4:\"name\";s:4:\"Divi\";s:4:\"slug\";s:4:\"Divi\";s:11:\"old_version\";s:4:\"3.12\";s:15:\"updated_version\";s:6:\"3.12.2\";}'),
('923', '204791', 'iwp_log_type', 'scheduleBackup'),
('924', '204791', 'iwp_log_action', 'schedule'),
('925', '204791', 'iwp_log_activities_type', 'iwp_log'),
('926', '204791', 'iwp_log_actions', 'backups'),
('927', '204791', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('928', '204792', 'iwp_log_type', 'backup'),
('929', '204792', 'iwp_log_action', 'multiCallNow'),
('930', '204792', 'iwp_log_activities_type', 'iwp_log'),
('931', '204792', 'iwp_log_actions', 'backups'),
('932', '204792', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:10:\"preupdates\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:10;s:7:\"include\";a:1:{i:0;s:0:\"\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('933', '204793', 'iwp_log_type', 'scheduleBackup'),
('934', '204793', 'iwp_log_action', 'schedule'),
('935', '204793', 'iwp_log_activities_type', 'iwp_log'),
('936', '204793', 'iwp_log_actions', 'backups'),
('937', '204793', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('938', '204795', 'iwp_log_type', 'scheduleBackup'),
('939', '204795', 'iwp_log_action', 'schedule'),
('940', '204795', 'iwp_log_activities_type', 'iwp_log'),
('941', '204795', 'iwp_log_actions', 'backups'),
('942', '204795', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('943', '204797', 'iwp_log_type', 'plugins'),
('944', '204797', 'iwp_log_action', 'update'),
('945', '204797', 'iwp_log_activities_type', 'direct'),
('946', '204797', 'iwp_log_actions', 'plugins-updated'),
('947', '204797', 'iwp_log_details', 'a:4:{s:4:\"name\";s:14:\"Contact Form 7\";s:4:\"slug\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"old_version\";s:5:\"5.0.3\";s:15:\"updated_version\";s:5:\"5.0.4\";}'),
('951', '42', '_et_pb_built_for_post_type', 'page'),
('952', '42', '_et_pb_use_ab_testing', 'off'),
('954', '42', '_et_pb_ab_current_shortcode', '[et_pb_split_track id=\"42\" /]'),
('956', '42', '_et_pb_show_page_creation', 'off'),
('961', '204804', '_edit_lock', '1536945777:2'),
('962', '204804', '_edit_last', '2'),
('963', '204804', '_wp_page_template', 'default'),
('964', '204804', '_et_pb_post_hide_nav', 'default'),
('965', '204804', '_et_pb_page_layout', 'et_right_sidebar'),
('966', '204804', '_et_pb_side_nav', 'off'),
('967', '204804', '_et_pb_use_builder', 'on'),
('968', '204804', '_et_builder_version', 'BB|Divi|3.12.2'),
('969', '204804', '_et_pb_ab_stats_refresh_interval', 'hourly'),
('970', '204804', '_et_pb_old_content', ''),
('971', '204804', '_et_pb_enable_shortcode_tracking', ''),
('972', '204804', '_et_pb_custom_css', ''),
('973', '204806', '_et_pb_built_for_post_type', 'page'),
('974', '204804', '_et_pb_show_page_creation', 'off'),
('975', '204807', '_form', '<label>Name (required)\n    [text* your-name] </label>\n\n<label>Dog\'s Name (required)\n[text* dogs-name] </label>\n\n<label>Dog\'s Age (required)\n[text* dogs-age] </label>\n\n<label>Email Address (required)\n    [email* your-email] </label>\n\n<label>Phone Number (required)\n[tel* tel-729] </label>\n\n<label>Start Date\n[date start-date] </label>\n\n\n[submit \"Send\"]'),
('976', '204807', '_mail', 'a:9:{s:6:\"active\";b:1;s:7:\"subject\";s:29:\"Jenny Harlow \"[your-subject]\"\";s:6:\"sender\";s:44:\"[your-name] <wordpress@jhdogtraining.com.au>\";s:9:\"recipient\";s:23:\"jennyharlow@bigpond.com\";s:4:\"body\";s:275:\"From: [your-name] <[your-email]>\nSubject: [your-subject]\n\nName: [your-name]\nDog\'s Name: [dogs-name]\nDog\'s Age: [dogs-age]\nEmail: [your-email]\nPhone:[tel-729]\nStart Date: [start-date]\n\n-- \nThis e-mail was sent from a contact form on Jenny Harlow (https://jhdogtraining.com.au)\";s:18:\"additional_headers\";s:22:\"Reply-To: [your-email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}'),
('977', '204807', '_mail_2', 'a:9:{s:6:\"active\";b:0;s:7:\"subject\";s:29:\"Jenny Harlow \"[your-subject]\"\";s:6:\"sender\";s:45:\"Jenny Harlow <wordpress@jhdogtraining.com.au>\";s:9:\"recipient\";s:12:\"[your-email]\";s:4:\"body\";s:121:\"Message Body:\n[your-message]\n\n-- \nThis e-mail was sent from a contact form on Jenny Harlow (https://jhdogtraining.com.au)\";s:18:\"additional_headers\";s:33:\"Reply-To: jennyharlow@bigpond.com\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}'),
('978', '204807', '_messages', 'a:23:{s:12:\"mail_sent_ok\";s:45:\"Thank you for your message. It has been sent.\";s:12:\"mail_sent_ng\";s:71:\"There was an error trying to send your message. Please try again later.\";s:16:\"validation_error\";s:61:\"One or more fields have an error. Please check and try again.\";s:4:\"spam\";s:71:\"There was an error trying to send your message. Please try again later.\";s:12:\"accept_terms\";s:69:\"You must accept the terms and conditions before sending your message.\";s:16:\"invalid_required\";s:22:\"The field is required.\";s:16:\"invalid_too_long\";s:22:\"The field is too long.\";s:17:\"invalid_too_short\";s:23:\"The field is too short.\";s:12:\"invalid_date\";s:29:\"The date format is incorrect.\";s:14:\"date_too_early\";s:44:\"The date is before the earliest one allowed.\";s:13:\"date_too_late\";s:41:\"The date is after the latest one allowed.\";s:13:\"upload_failed\";s:46:\"There was an unknown error uploading the file.\";s:24:\"upload_file_type_invalid\";s:49:\"You are not allowed to upload files of this type.\";s:21:\"upload_file_too_large\";s:20:\"The file is too big.\";s:23:\"upload_failed_php_error\";s:38:\"There was an error uploading the file.\";s:14:\"invalid_number\";s:29:\"The number format is invalid.\";s:16:\"number_too_small\";s:47:\"The number is smaller than the minimum allowed.\";s:16:\"number_too_large\";s:46:\"The number is larger than the maximum allowed.\";s:23:\"quiz_answer_not_correct\";s:36:\"The answer to the quiz is incorrect.\";s:17:\"captcha_not_match\";s:31:\"Your entered code is incorrect.\";s:13:\"invalid_email\";s:38:\"The e-mail address entered is invalid.\";s:11:\"invalid_url\";s:19:\"The URL is invalid.\";s:11:\"invalid_tel\";s:32:\"The telephone number is invalid.\";}'),
('979', '204807', '_additional_settings', ''),
('980', '204807', '_locale', 'en_US'),
('981', '204808', '_wp_attached_file', '2018/09/TOP-IMAAGE_o-new.jpg'),
('982', '204808', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:893;s:4:\"file\";s:28:\"2018/09/TOP-IMAAGE_o-new.jpg\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"TOP-IMAAGE_o-new-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"TOP-IMAAGE_o-new-300x140.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:28:\"TOP-IMAAGE_o-new-768x357.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:357;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:29:\"TOP-IMAAGE_o-new-1024x476.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:476;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:28:\"TOP-IMAAGE_o-new-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:29:\"TOP-IMAAGE_o-new-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:28:\"TOP-IMAAGE_o-new-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:28:\"TOP-IMAAGE_o-new-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:29:\"TOP-IMAAGE_o-new-1080x502.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:502;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:28:\"TOP-IMAAGE_o-new-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:26:\"©annaav - stock.adobe.com\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('983', '204809', '_wp_attached_file', '2018/09/TOP-IMAAGE_o-new-1.jpg'),
('984', '204809', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:893;s:4:\"file\";s:30:\"2018/09/TOP-IMAAGE_o-new-1.jpg\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"TOP-IMAAGE_o-new-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"TOP-IMAAGE_o-new-1-300x140.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:30:\"TOP-IMAAGE_o-new-1-768x357.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:357;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:31:\"TOP-IMAAGE_o-new-1-1024x476.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:476;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:30:\"TOP-IMAAGE_o-new-1-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:31:\"TOP-IMAAGE_o-new-1-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:30:\"TOP-IMAAGE_o-new-1-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:30:\"TOP-IMAAGE_o-new-1-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:31:\"TOP-IMAAGE_o-new-1-1080x502.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:502;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:30:\"TOP-IMAAGE_o-new-1-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:26:\"©annaav - stock.adobe.com\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('985', '204810', '_wp_attached_file', '2018/09/callback_.jpg'),
('986', '204810', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:520;s:6:\"height\";i:344;s:4:\"file\";s:21:\"2018/09/callback_.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"callback_-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"callback_-300x198.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:198;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:21:\"callback_-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:21:\"callback_-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:21:\"callback_-510x344.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:344;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:21:\"callback_-400x344.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:344;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:25:\"©Gerry - stock.adobe.com\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('987', '204811', '_wp_attached_file', '2018/09/train.jpg'),
('988', '204811', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:520;s:6:\"height\";i:344;s:4:\"file\";s:17:\"2018/09/train.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"train-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"train-300x198.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:198;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:17:\"train-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:17:\"train-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:17:\"train-510x344.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:344;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:17:\"train-400x344.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:344;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:25:\"©Gerry - stock.adobe.com\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('1014', '204815', '_et_pb_built_for_post_type', 'page'),
('1016', '204817', '_wp_attached_file', '2018/09/TOP-IMAAGE_vids.jpg'),
('1017', '204817', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:1920;s:6:\"height\";i:893;s:4:\"file\";s:27:\"2018/09/TOP-IMAAGE_vids.jpg\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"TOP-IMAAGE_vids-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"TOP-IMAAGE_vids-300x140.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:27:\"TOP-IMAAGE_vids-768x357.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:357;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:28:\"TOP-IMAAGE_vids-1024x476.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:476;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:27:\"TOP-IMAAGE_vids-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:28:\"TOP-IMAAGE_vids-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:27:\"TOP-IMAAGE_vids-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:27:\"TOP-IMAAGE_vids-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:28:\"TOP-IMAAGE_vids-1080x502.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:502;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:27:\"TOP-IMAAGE_vids-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:26:\"©annaav - stock.adobe.com\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('1033', '204822', '_menu_item_type', 'custom'),
('1034', '204822', '_menu_item_menu_item_parent', '0'),
('1035', '204822', '_menu_item_object_id', '204822'),
('1036', '204822', '_menu_item_object', 'custom'),
('1037', '204822', '_menu_item_target', ''),
('1038', '204822', '_menu_item_classes', 'a:1:{i:0;s:0:\"\";}'),
('1039', '204822', '_menu_item_xfn', ''),
('1040', '204822', '_menu_item_url', 'tel:0419-535-236'),
('1042', '204823', '_menu_item_type', 'custom'),
('1043', '204823', '_menu_item_menu_item_parent', '0'),
('1044', '204823', '_menu_item_object_id', '204823'),
('1045', '204823', '_menu_item_object', 'custom'),
('1046', '204823', '_menu_item_target', ''),
('1047', '204823', '_menu_item_classes', 'a:1:{i:0;s:0:\"\";}'),
('1048', '204823', '_menu_item_xfn', ''),
('1049', '204823', '_menu_item_url', 'mailto:jenny@jhdogtraining.com.au'),
('1055', '204826', 'iwp_log_type', 'plugins'),
('1056', '204826', 'iwp_log_action', 'update'),
('1057', '204826', 'iwp_log_activities_type', 'direct'),
('1058', '204826', 'iwp_log_actions', 'plugins-updated'),
('1059', '204826', 'iwp_log_details', 'a:4:{s:4:\"name\";s:17:\"WP Migrate DB Pro\";s:4:\"slug\";s:39:\"wp-migrate-db-pro/wp-migrate-db-pro.php\";s:11:\"old_version\";s:5:\"1.8.1\";s:15:\"updated_version\";s:5:\"1.8.3\";}'),
('1063', '204830', '_wp_attached_file', '2017/12/cropped-JH_Horizontal-4.png'),
('1064', '204830', '_wp_attachment_context', 'site-icon'),
('1065', '204830', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:35:\"2017/12/cropped-JH_Horizontal-4.png\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:35:\"cropped-JH_Horizontal-4-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:35:\"cropped-JH_Horizontal-4-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:35:\"cropped-JH_Horizontal-4-400x250.png\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:35:\"cropped-JH_Horizontal-4-400x284.png\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:9:\"image/png\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:35:\"cropped-JH_Horizontal-4-510x382.png\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:9:\"image/png\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:35:\"cropped-JH_Horizontal-4-400x512.png\";s:5:\"width\";i:400;s:6:\"height\";i:512;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"site_icon-270\";a:4:{s:4:\"file\";s:35:\"cropped-JH_Horizontal-4-270x270.png\";s:5:\"width\";i:270;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"site_icon-192\";a:4:{s:4:\"file\";s:35:\"cropped-JH_Horizontal-4-192x192.png\";s:5:\"width\";i:192;s:6:\"height\";i:192;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"site_icon-180\";a:4:{s:4:\"file\";s:35:\"cropped-JH_Horizontal-4-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"site_icon-32\";a:4:{s:4:\"file\";s:33:\"cropped-JH_Horizontal-4-32x32.png\";s:5:\"width\";i:32;s:6:\"height\";i:32;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('1068', '204832', 'iwp_log_type', 'scheduleBackup'),
('1069', '204832', 'iwp_log_action', 'schedule'),
('1070', '204832', 'iwp_log_activities_type', 'iwp_log'),
('1071', '204832', 'iwp_log_actions', 'backups'),
('1072', '204832', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1075', '204835', '_edit_lock', '1537725995:2'),
('1076', '204835', '_edit_last', '2'),
('1077', '204841', '_edit_lock', '1539461369:2'),
('1078', '204841', '_edit_last', '2'),
('1079', '204841', 'video_link', 'https://youtu.be/xORRXgM8afs'),
('1080', '204841', '_video_link', 'field_5ba5897f45966'),
('1081', '204842', '_edit_lock', '1539460361:2'),
('1082', '204842', '_edit_last', '2'),
('1083', '204842', 'video_link', 'https://youtu.be/5uYjfq6DFIo'),
('1084', '204842', '_video_link', 'field_5ba5897f45966'),
('1125', '204859', '_edit_lock', '1539647054:2'),
('1126', '204859', '_edit_last', '2'),
('1127', '204859', 'video_link', 'https://youtu.be/ExxNlTxV4WY'),
('1128', '204859', '_video_link', 'field_5ba5897f45966'),
('1141', '204864', 'iwp_log_type', 'scheduleBackup'),
('1142', '204864', 'iwp_log_action', 'schedule'),
('1143', '204864', 'iwp_log_activities_type', 'iwp_log'),
('1144', '204864', 'iwp_log_actions', 'backups'),
('1145', '204864', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1152', '204865', 'iwp_log_type', 'plugins'),
('1153', '204865', 'iwp_log_action', 'update'),
('1154', '204865', 'iwp_log_activities_type', 'direct'),
('1155', '204865', 'iwp_log_actions', 'plugins-updated'),
('1156', '204865', 'iwp_log_details', 'a:4:{s:4:\"name\";s:17:\"WP Migrate DB Pro\";s:4:\"slug\";s:39:\"wp-migrate-db-pro/wp-migrate-db-pro.php\";s:11:\"old_version\";s:5:\"1.8.3\";s:15:\"updated_version\";s:5:\"1.8.4\";}'),
('1157', '204866', 'iwp_log_type', 'themes'),
('1158', '204866', 'iwp_log_action', 'update'),
('1159', '204866', 'iwp_log_activities_type', 'direct'),
('1160', '204866', 'iwp_log_actions', 'themes-updated'),
('1161', '204866', 'iwp_log_details', 'a:4:{s:4:\"name\";s:4:\"Divi\";s:4:\"slug\";s:4:\"Divi\";s:11:\"old_version\";s:6:\"3.12.2\";s:15:\"updated_version\";s:4:\"3.15\";}'),
('1162', '204867', '_edit_lock', '1539647678:2'),
('1163', '204867', '_edit_last', '2'),
('1164', '204867', 'video_link', 'https://youtu.be/hNUzE2PzCCw'),
('1165', '204867', '_video_link', 'field_5ba5897f45966'),
('1166', '204868', '_edit_lock', '1537839790:2'),
('1167', '204868', '_edit_last', '2'),
('1168', '204868', 'video_link', 'https://youtu.be/VK8Uybu-Bkc'),
('1169', '204868', '_video_link', 'field_5ba5897f45966'),
('1170', '204869', 'iwp_log_type', 'scheduleBackup'),
('1171', '204869', 'iwp_log_action', 'schedule'),
('1172', '204869', 'iwp_log_activities_type', 'iwp_log'),
('1173', '204869', 'iwp_log_actions', 'backups'),
('1174', '204869', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1175', '204871', 'iwp_log_type', 'plugins'),
('1176', '204871', 'iwp_log_action', 'update'),
('1177', '204871', 'iwp_log_activities_type', 'direct'),
('1178', '204871', 'iwp_log_actions', 'plugins-updated'),
('1179', '204871', 'iwp_log_details', 'a:4:{s:4:\"name\";s:26:\"Advanced Custom Fields PRO\";s:4:\"slug\";s:34:\"advanced-custom-fields-pro/acf.php\";s:11:\"old_version\";s:5:\"5.7.6\";s:15:\"updated_version\";s:5:\"5.7.7\";}'),
('1180', '204872', 'iwp_log_type', 'plugins'),
('1181', '204872', 'iwp_log_action', 'update'),
('1182', '204872', 'iwp_log_activities_type', 'direct'),
('1183', '204872', 'iwp_log_actions', 'plugins-updated'),
('1184', '204872', 'iwp_log_details', 'a:4:{s:4:\"name\";s:17:\"WP Migrate DB Pro\";s:4:\"slug\";s:39:\"wp-migrate-db-pro/wp-migrate-db-pro.php\";s:11:\"old_version\";s:5:\"1.8.4\";s:15:\"updated_version\";s:5:\"1.8.5\";}'),
('1185', '204873', 'iwp_log_type', 'scheduleBackup'),
('1186', '204873', 'iwp_log_action', 'schedule'),
('1187', '204873', 'iwp_log_activities_type', 'iwp_log'),
('1188', '204873', 'iwp_log_actions', 'backups'),
('1189', '204873', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1234', '204878', 'iwp_log_type', 'scheduleBackup'),
('1235', '204878', 'iwp_log_action', 'schedule'),
('1236', '204878', 'iwp_log_activities_type', 'iwp_log'),
('1237', '204878', 'iwp_log_actions', 'backups'),
('1238', '204878', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1239', '204879', '_menu_item_type', 'post_type_archive'),
('1240', '204879', '_menu_item_menu_item_parent', '205083'),
('1241', '204879', '_menu_item_object_id', '-47'),
('1242', '204879', '_menu_item_object', 'videos'),
('1243', '204879', '_menu_item_target', ''),
('1244', '204879', '_menu_item_classes', 'a:1:{i:0;s:0:\"\";}'),
('1245', '204879', '_menu_item_xfn', ''),
('1246', '204879', '_menu_item_url', ''),
('1248', '204880', 'iwp_log_type', 'scheduleBackup'),
('1249', '204880', 'iwp_log_action', 'schedule'),
('1250', '204880', 'iwp_log_activities_type', 'iwp_log'),
('1251', '204880', 'iwp_log_actions', 'backups'),
('1252', '204880', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1253', '204882', 'iwp_log_type', 'plugins'),
('1254', '204882', 'iwp_log_action', 'update'),
('1255', '204882', 'iwp_log_activities_type', 'direct'),
('1256', '204882', 'iwp_log_actions', 'plugins-updated'),
('1257', '204882', 'iwp_log_details', 'a:4:{s:4:\"name\";s:17:\"WP Migrate DB Pro\";s:4:\"slug\";s:39:\"wp-migrate-db-pro/wp-migrate-db-pro.php\";s:11:\"old_version\";s:5:\"1.8.5\";s:15:\"updated_version\";s:5:\"1.8.6\";}'),
('1258', '204883', 'iwp_log_type', 'themes'),
('1259', '204883', 'iwp_log_action', 'update'),
('1260', '204883', 'iwp_log_activities_type', 'direct'),
('1261', '204883', 'iwp_log_actions', 'themes-updated'),
('1262', '204883', 'iwp_log_details', 'a:4:{s:4:\"name\";s:4:\"Divi\";s:4:\"slug\";s:4:\"Divi\";s:11:\"old_version\";s:4:\"3.15\";s:15:\"updated_version\";s:6:\"3.17.2\";}'),
('1263', '204884', 'iwp_log_type', 'scheduleBackup'),
('1264', '204884', 'iwp_log_action', 'schedule'),
('1265', '204884', 'iwp_log_activities_type', 'iwp_log'),
('1266', '204884', 'iwp_log_actions', 'backups'),
('1267', '204884', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1268', '204886', '_edit_lock', '1540967735:2'),
('1269', '204886', '_edit_last', '2'),
('1275', '204888', '_wp_attached_file', '2018/10/Buddy-Labrador-2-e1540945935286.jpg'),
('1276', '204888', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:3024;s:6:\"height\";i:4032;s:4:\"file\";s:43:\"2018/10/Buddy-Labrador-2-e1540945935286.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:43:\"Buddy-Labrador-2-e1540945935286-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:43:\"Buddy-Labrador-2-e1540945935286-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:44:\"Buddy-Labrador-2-e1540945935286-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:44:\"Buddy-Labrador-2-e1540945935286-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:43:\"Buddy-Labrador-2-e1540945935286-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:44:\"Buddy-Labrador-2-e1540945935286-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:43:\"Buddy-Labrador-2-e1540945935286-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:43:\"Buddy-Labrador-2-e1540945935286-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:45:\"Buddy-Labrador-2-e1540945935286-1080x1440.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:1440;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:43:\"Buddy-Labrador-2-e1540945935286-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:37:\"et-pb-post-main-image-fullwidth-large\";a:4:{s:4:\"file\";s:45:\"Buddy-Labrador-2-e1540945935286-2880x1800.jpg\";s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"1.8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:8:\"iPhone X\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1536325414\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"4\";s:3:\"iso\";s:2:\"20\";s:13:\"shutter_speed\";s:16:\"0.00833333333333\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"6\";s:8:\"keywords\";a:0:{}}}'),
('1277', '204889', '_wp_attached_file', '2018/10/Buddy-Labrador-1-e1540945974815.jpg'),
('1278', '204889', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:3024;s:6:\"height\";i:4032;s:4:\"file\";s:43:\"2018/10/Buddy-Labrador-1-e1540945974815.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:43:\"Buddy-Labrador-1-e1540945974815-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:43:\"Buddy-Labrador-1-e1540945974815-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:44:\"Buddy-Labrador-1-e1540945974815-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:44:\"Buddy-Labrador-1-e1540945974815-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:43:\"Buddy-Labrador-1-e1540945974815-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:44:\"Buddy-Labrador-1-e1540945974815-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:43:\"Buddy-Labrador-1-e1540945974815-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:43:\"Buddy-Labrador-1-e1540945974815-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:45:\"Buddy-Labrador-1-e1540945974815-1080x1440.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:1440;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:43:\"Buddy-Labrador-1-e1540945974815-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:37:\"et-pb-post-main-image-fullwidth-large\";a:4:{s:4:\"file\";s:45:\"Buddy-Labrador-1-e1540945974815-2880x1800.jpg\";s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"1.8\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:8:\"iPhone X\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1536325295\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"4\";s:3:\"iso\";s:2:\"25\";s:13:\"shutter_speed\";s:16:\"0.00833333333333\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"6\";s:8:\"keywords\";a:0:{}}}'),
('1279', '204888', '_wp_attachment_backup_sizes', 'a:12:{s:9:\"full-orig\";a:3:{s:5:\"width\";i:4032;s:6:\"height\";i:3024;s:4:\"file\";s:20:\"Buddy-Labrador-2.jpg\";}s:14:\"thumbnail-orig\";a:4:{s:4:\"file\";s:28:\"Buddy-Labrador-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"medium-orig\";a:4:{s:4:\"file\";s:28:\"Buddy-Labrador-2-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:17:\"medium_large-orig\";a:4:{s:4:\"file\";s:28:\"Buddy-Labrador-2-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"large-orig\";a:4:{s:4:\"file\";s:29:\"Buddy-Labrador-2-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:26:\"et-pb-post-main-image-orig\";a:4:{s:4:\"file\";s:28:\"Buddy-Labrador-2-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:36:\"et-pb-post-main-image-fullwidth-orig\";a:4:{s:4:\"file\";s:29:\"Buddy-Labrador-2-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:26:\"et-pb-portfolio-image-orig\";a:4:{s:4:\"file\";s:28:\"Buddy-Labrador-2-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"et-pb-portfolio-module-image-orig\";a:4:{s:4:\"file\";s:28:\"Buddy-Labrador-2-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"et-pb-portfolio-image-single-orig\";a:4:{s:4:\"file\";s:29:\"Buddy-Labrador-2-1080x810.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:810;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:40:\"et-pb-gallery-module-image-portrait-orig\";a:4:{s:4:\"file\";s:28:\"Buddy-Labrador-2-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:42:\"et-pb-post-main-image-fullwidth-large-orig\";a:4:{s:4:\"file\";s:30:\"Buddy-Labrador-2-2880x1800.jpg\";s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:9:\"mime-type\";s:10:\"image/jpeg\";}}'),
('1280', '204889', '_wp_attachment_backup_sizes', 'a:12:{s:9:\"full-orig\";a:3:{s:5:\"width\";i:4032;s:6:\"height\";i:3024;s:4:\"file\";s:20:\"Buddy-Labrador-1.jpg\";}s:14:\"thumbnail-orig\";a:4:{s:4:\"file\";s:28:\"Buddy-Labrador-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"medium-orig\";a:4:{s:4:\"file\";s:28:\"Buddy-Labrador-1-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:17:\"medium_large-orig\";a:4:{s:4:\"file\";s:28:\"Buddy-Labrador-1-768x576.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"large-orig\";a:4:{s:4:\"file\";s:29:\"Buddy-Labrador-1-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:26:\"et-pb-post-main-image-orig\";a:4:{s:4:\"file\";s:28:\"Buddy-Labrador-1-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:36:\"et-pb-post-main-image-fullwidth-orig\";a:4:{s:4:\"file\";s:29:\"Buddy-Labrador-1-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:26:\"et-pb-portfolio-image-orig\";a:4:{s:4:\"file\";s:28:\"Buddy-Labrador-1-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"et-pb-portfolio-module-image-orig\";a:4:{s:4:\"file\";s:28:\"Buddy-Labrador-1-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:33:\"et-pb-portfolio-image-single-orig\";a:4:{s:4:\"file\";s:29:\"Buddy-Labrador-1-1080x810.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:810;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:40:\"et-pb-gallery-module-image-portrait-orig\";a:4:{s:4:\"file\";s:28:\"Buddy-Labrador-1-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:42:\"et-pb-post-main-image-fullwidth-large-orig\";a:4:{s:4:\"file\";s:30:\"Buddy-Labrador-1-2880x1800.jpg\";s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:9:\"mime-type\";s:10:\"image/jpeg\";}}'),
('1281', '204886', '_et_post_bg_color', '#ffffff'),
('1282', '204886', '_et_post_bg_layout', 'light'),
('1283', '204886', '_et_pb_show_title', 'on'),
('1284', '204886', '_et_pb_post_hide_nav', 'default'),
('1285', '204886', '_et_pb_page_layout', 'et_right_sidebar'),
('1286', '204886', '_et_pb_side_nav', 'off'),
('1287', '204886', '_et_pb_use_builder', ''),
('1288', '204886', '_et_builder_version', 'BB|Divi|3.17.2'),
('1289', '204886', '_et_pb_ab_stats_refresh_interval', 'hourly'),
('1290', '204886', '_et_pb_old_content', ''),
('1291', '204886', '_et_pb_enable_shortcode_tracking', ''),
('1292', '204886', '_et_pb_custom_css', ''),
('1302', '204892', 'iwp_log_type', 'scheduleBackup'),
('1303', '204892', 'iwp_log_action', 'schedule'),
('1304', '204892', 'iwp_log_activities_type', 'iwp_log'),
('1305', '204892', 'iwp_log_actions', 'backups'),
('1306', '204892', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1307', '204893', 'iwp_log_type', 'scheduleBackup'),
('1308', '204893', 'iwp_log_action', 'schedule'),
('1309', '204893', 'iwp_log_activities_type', 'iwp_log'),
('1310', '204893', 'iwp_log_actions', 'backups'),
('1311', '204893', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1312', '204895', 'iwp_log_type', 'plugins'),
('1313', '204895', 'iwp_log_action', 'update'),
('1314', '204895', 'iwp_log_activities_type', 'direct'),
('1315', '204895', 'iwp_log_actions', 'plugins-updated'),
('1316', '204895', 'iwp_log_details', 'a:4:{s:4:\"name\";s:14:\"Contact Form 7\";s:4:\"slug\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"old_version\";s:5:\"5.0.4\";s:15:\"updated_version\";s:5:\"5.0.5\";}'),
('1317', '204896', 'iwp_log_type', 'plugins'),
('1318', '204896', 'iwp_log_action', 'update'),
('1319', '204896', 'iwp_log_activities_type', 'direct'),
('1320', '204896', 'iwp_log_actions', 'plugins-updated'),
('1321', '204896', 'iwp_log_details', 'a:4:{s:4:\"name\";s:19:\"Custom Post Type UI\";s:4:\"slug\";s:43:\"custom-post-type-ui/custom-post-type-ui.php\";s:11:\"old_version\";s:5:\"1.5.8\";s:15:\"updated_version\";s:5:\"1.6.0\";}'),
('1322', '204897', 'iwp_log_type', 'plugins'),
('1323', '204897', 'iwp_log_action', 'update'),
('1324', '204897', 'iwp_log_activities_type', 'direct'),
('1325', '204897', 'iwp_log_actions', 'plugins-updated'),
('1326', '204897', 'iwp_log_details', 'a:4:{s:4:\"name\";s:23:\"Official Facebook Pixel\";s:4:\"slug\";s:48:\"official-facebook-pixel/FacebookForWordpress.php\";s:11:\"old_version\";s:6:\"1.7.15\";s:15:\"updated_version\";s:6:\"1.7.16\";}'),
('1327', '204898', 'iwp_log_type', 'themes'),
('1328', '204898', 'iwp_log_action', 'update'),
('1329', '204898', 'iwp_log_activities_type', 'direct'),
('1330', '204898', 'iwp_log_actions', 'themes-updated'),
('1331', '204898', 'iwp_log_details', 'a:4:{s:4:\"name\";s:4:\"Divi\";s:4:\"slug\";s:4:\"Divi\";s:11:\"old_version\";s:6:\"3.17.2\";s:15:\"updated_version\";s:6:\"3.17.6\";}'),
('1332', '204899', 'iwp_log_type', 'scheduleBackup'),
('1333', '204899', 'iwp_log_action', 'schedule'),
('1334', '204899', 'iwp_log_activities_type', 'iwp_log'),
('1335', '204899', 'iwp_log_actions', 'backups'),
('1336', '204899', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1337', '204900', 'iwp_log_type', 'scheduleBackup'),
('1338', '204900', 'iwp_log_action', 'schedule'),
('1339', '204900', 'iwp_log_activities_type', 'iwp_log'),
('1340', '204900', 'iwp_log_actions', 'backups'),
('1341', '204900', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1342', '204902', 'iwp_log_type', 'plugins'),
('1343', '204902', 'iwp_log_action', 'update'),
('1344', '204902', 'iwp_log_activities_type', 'direct'),
('1345', '204902', 'iwp_log_actions', 'plugins-updated'),
('1346', '204902', 'iwp_log_details', 'a:4:{s:4:\"name\";s:23:\"Official Facebook Pixel\";s:4:\"slug\";s:48:\"official-facebook-pixel/FacebookForWordpress.php\";s:11:\"old_version\";s:6:\"1.7.16\";s:15:\"updated_version\";s:6:\"1.7.19\";}'),
('1347', '204903', 'iwp_log_type', 'scheduleBackup'),
('1348', '204903', 'iwp_log_action', 'schedule'),
('1349', '204903', 'iwp_log_activities_type', 'iwp_log'),
('1350', '204903', 'iwp_log_actions', 'backups'),
('1351', '204903', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1352', '204904', 'iwp_log_type', 'scheduleBackup'),
('1353', '204904', 'iwp_log_action', 'schedule'),
('1354', '204904', 'iwp_log_activities_type', 'iwp_log'),
('1355', '204904', 'iwp_log_actions', 'backups'),
('1356', '204904', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1357', '204906', 'iwp_log_type', 'plugins'),
('1358', '204906', 'iwp_log_action', 'update'),
('1359', '204906', 'iwp_log_activities_type', 'direct'),
('1360', '204906', 'iwp_log_actions', 'plugins-updated'),
('1361', '204906', 'iwp_log_details', 'a:4:{s:4:\"name\";s:26:\"Advanced Custom Fields PRO\";s:4:\"slug\";s:34:\"advanced-custom-fields-pro/acf.php\";s:11:\"old_version\";s:5:\"5.7.7\";s:15:\"updated_version\";s:5:\"5.7.8\";}'),
('1362', '204907', 'iwp_log_type', 'plugins'),
('1363', '204907', 'iwp_log_action', 'update'),
('1364', '204907', 'iwp_log_activities_type', 'direct'),
('1365', '204907', 'iwp_log_actions', 'plugins-updated'),
('1366', '204907', 'iwp_log_details', 'a:4:{s:4:\"name\";s:14:\"Contact Form 7\";s:4:\"slug\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"old_version\";s:5:\"5.0.5\";s:15:\"updated_version\";s:3:\"5.1\";}'),
('1367', '204908', 'iwp_log_type', 'plugins'),
('1368', '204908', 'iwp_log_action', 'update'),
('1369', '204908', 'iwp_log_activities_type', 'direct'),
('1370', '204908', 'iwp_log_actions', 'plugins-updated'),
('1371', '204908', 'iwp_log_details', 'a:4:{s:4:\"name\";s:19:\"Custom Post Type UI\";s:4:\"slug\";s:43:\"custom-post-type-ui/custom-post-type-ui.php\";s:11:\"old_version\";s:5:\"1.6.0\";s:15:\"updated_version\";s:5:\"1.6.1\";}'),
('1372', '204909', 'iwp_log_type', 'plugins'),
('1373', '204909', 'iwp_log_action', 'update'),
('1374', '204909', 'iwp_log_activities_type', 'direct'),
('1375', '204909', 'iwp_log_actions', 'plugins-updated'),
('1376', '204909', 'iwp_log_details', 'a:4:{s:4:\"name\";s:0:\"\";s:4:\"slug\";s:48:\"official-facebook-pixel/FacebookForWordpress.php\";s:11:\"old_version\";s:0:\"\";s:15:\"updated_version\";s:0:\"\";}'),
('1377', '204910', 'iwp_log_type', 'plugins'),
('1378', '204910', 'iwp_log_action', 'update'),
('1379', '204910', 'iwp_log_activities_type', 'direct'),
('1380', '204910', 'iwp_log_actions', 'plugins-updated'),
('1381', '204910', 'iwp_log_details', 'a:4:{s:4:\"name\";s:17:\"WP Migrate DB Pro\";s:4:\"slug\";s:39:\"wp-migrate-db-pro/wp-migrate-db-pro.php\";s:11:\"old_version\";s:5:\"1.8.6\";s:15:\"updated_version\";s:5:\"1.9.1\";}'),
('1382', '204911', 'iwp_log_type', 'themes'),
('1383', '204911', 'iwp_log_action', 'update'),
('1384', '204911', 'iwp_log_activities_type', 'direct'),
('1385', '204911', 'iwp_log_actions', 'themes-updated'),
('1386', '204911', 'iwp_log_details', 'a:4:{s:4:\"name\";s:16:\"Twenty Seventeen\";s:4:\"slug\";s:16:\"Twenty Seventeen\";s:11:\"old_version\";s:3:\"1.7\";s:15:\"updated_version\";s:3:\"1.8\";}'),
('1387', '204912', 'iwp_log_type', 'themes'),
('1388', '204912', 'iwp_log_action', 'update'),
('1389', '204912', 'iwp_log_activities_type', 'direct'),
('1390', '204912', 'iwp_log_actions', 'themes-updated'),
('1391', '204912', 'iwp_log_details', 'a:4:{s:4:\"name\";s:4:\"Divi\";s:4:\"slug\";s:4:\"Divi\";s:11:\"old_version\";s:6:\"3.17.6\";s:15:\"updated_version\";s:6:\"3.18.7\";}'),
('1392', '204913', 'iwp_log_type', 'scheduleBackup'),
('1393', '204913', 'iwp_log_action', 'schedule'),
('1394', '204913', 'iwp_log_activities_type', 'iwp_log'),
('1395', '204913', 'iwp_log_actions', 'backups'),
('1396', '204913', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1397', '204914', 'iwp_log_type', 'scheduleBackup'),
('1398', '204914', 'iwp_log_action', 'schedule'),
('1399', '204914', 'iwp_log_activities_type', 'iwp_log'),
('1400', '204914', 'iwp_log_actions', 'backups'),
('1401', '204914', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1402', '204915', 'iwp_log_type', 'scheduleBackup'),
('1403', '204915', 'iwp_log_action', 'schedule'),
('1404', '204915', 'iwp_log_activities_type', 'iwp_log'),
('1405', '204915', 'iwp_log_actions', 'backups'),
('1406', '204915', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1407', '204917', '_edit_lock', '1546385507:2'),
('1408', '204917', '_edit_last', '2'),
('1409', '204917', '_wp_page_template', 'default'),
('1410', '204917', '_et_pb_post_hide_nav', 'default'),
('1411', '204917', '_et_pb_page_layout', 'et_right_sidebar'),
('1412', '204917', '_et_pb_side_nav', 'off'),
('1413', '204917', '_et_pb_use_builder', ''),
('1414', '204917', '_et_builder_version', 'BB|Divi|3.18.7'),
('1415', '204917', '_et_pb_ab_stats_refresh_interval', 'hourly'),
('1416', '204917', '_et_pb_old_content', ''),
('1417', '204917', '_et_pb_enable_shortcode_tracking', ''),
('1418', '204917', '_et_pb_custom_css', ''),
('1419', '204918', '_wp_attached_file', '2019/01/puppy-bite.jpg');
/**ABDB**/INSERT INTO `wp_postmeta`  VALUES 
('1420', '204918', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:4910;s:6:\"height\";i:3269;s:4:\"file\";s:22:\"2019/01/puppy-bite.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"puppy-bite-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"puppy-bite-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"puppy-bite-768x511.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:511;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"puppy-bite-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:22:\"puppy-bite-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:23:\"puppy-bite-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:22:\"puppy-bite-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:22:\"puppy-bite-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:23:\"puppy-bite-1080x719.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:719;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:22:\"puppy-bite-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:37:\"et-pb-post-main-image-fullwidth-large\";a:4:{s:4:\"file\";s:24:\"puppy-bite-2880x1800.jpg\";s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}'),
('1426', '204921', '_edit_lock', '1546389668:2'),
('1427', '204921', '_edit_last', '2'),
('1428', '204921', '_et_post_bg_color', '#ffffff'),
('1429', '204921', '_et_post_bg_layout', 'light'),
('1430', '204921', '_et_pb_show_title', 'on'),
('1431', '204921', '_et_pb_post_hide_nav', 'default'),
('1432', '204921', '_et_pb_page_layout', 'et_right_sidebar'),
('1433', '204921', '_et_pb_side_nav', 'off'),
('1434', '204921', '_et_pb_use_builder', ''),
('1435', '204921', '_et_builder_version', 'BB|Divi|3.18.7'),
('1436', '204921', '_et_pb_ab_stats_refresh_interval', 'hourly'),
('1437', '204921', '_et_pb_old_content', ''),
('1438', '204921', '_et_pb_enable_shortcode_tracking', ''),
('1439', '204921', '_et_pb_custom_css', ''),
('1440', '204922', 'iwp_log_type', 'scheduleBackup'),
('1441', '204922', 'iwp_log_action', 'schedule'),
('1442', '204922', 'iwp_log_activities_type', 'iwp_log'),
('1443', '204922', 'iwp_log_actions', 'backups'),
('1444', '204922', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1445', '204923', 'iwp_log_type', 'scheduleBackup'),
('1446', '204923', 'iwp_log_action', 'schedule'),
('1447', '204923', 'iwp_log_activities_type', 'iwp_log'),
('1448', '204923', 'iwp_log_actions', 'backups'),
('1449', '204923', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1450', '204924', 'iwp_log_type', 'scheduleBackup'),
('1451', '204924', 'iwp_log_action', 'schedule'),
('1452', '204924', 'iwp_log_activities_type', 'iwp_log'),
('1453', '204924', 'iwp_log_actions', 'backups'),
('1454', '204924', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1455', '204926', 'iwp_log_type', 'themes'),
('1456', '204926', 'iwp_log_action', 'update'),
('1457', '204926', 'iwp_log_activities_type', 'direct'),
('1458', '204926', 'iwp_log_actions', 'themes-updated'),
('1459', '204926', 'iwp_log_details', 'a:4:{s:4:\"name\";s:16:\"Twenty Seventeen\";s:4:\"slug\";s:16:\"Twenty Seventeen\";s:11:\"old_version\";s:3:\"1.8\";s:15:\"updated_version\";s:3:\"2.0\";}'),
('1460', '204927', 'iwp_log_type', 'themes'),
('1461', '204927', 'iwp_log_action', 'update'),
('1462', '204927', 'iwp_log_activities_type', 'direct'),
('1463', '204927', 'iwp_log_actions', 'themes-updated'),
('1464', '204927', 'iwp_log_details', 'a:4:{s:4:\"name\";s:4:\"Divi\";s:4:\"slug\";s:4:\"Divi\";s:11:\"old_version\";s:6:\"3.18.7\";s:15:\"updated_version\";s:6:\"3.19.9\";}'),
('1465', '204928', 'iwp_log_type', 'core'),
('1466', '204928', 'iwp_log_action', 'update'),
('1467', '204928', 'iwp_log_activities_type', 'direct'),
('1468', '204928', 'iwp_log_actions', 'core-updated'),
('1469', '204928', 'iwp_log_details', 'a:2:{s:11:\"old_version\";s:5:\"4.9.8\";s:15:\"updated_version\";s:5:\"5.0.3\";}'),
('1470', '204929', 'iwp_log_type', 'plugins'),
('1471', '204929', 'iwp_log_action', 'update'),
('1472', '204929', 'iwp_log_activities_type', 'direct'),
('1473', '204929', 'iwp_log_actions', 'plugins-updated'),
('1474', '204929', 'iwp_log_details', 'a:4:{s:4:\"name\";s:17:\"WP Migrate DB Pro\";s:4:\"slug\";s:39:\"wp-migrate-db-pro/wp-migrate-db-pro.php\";s:11:\"old_version\";s:5:\"1.9.1\";s:15:\"updated_version\";s:5:\"1.9.2\";}'),
('1475', '204930', 'iwp_log_type', 'plugins'),
('1476', '204930', 'iwp_log_action', 'update'),
('1477', '204930', 'iwp_log_activities_type', 'direct'),
('1478', '204930', 'iwp_log_actions', 'plugins-updated'),
('1479', '204930', 'iwp_log_details', 'a:4:{s:4:\"name\";s:23:\"Official Facebook Pixel\";s:4:\"slug\";s:50:\"official-facebook-pixel/facebook-for-wordpress.php\";s:11:\"old_version\";s:6:\"1.7.21\";s:15:\"updated_version\";s:6:\"1.7.22\";}'),
('1480', '204931', 'iwp_log_type', 'plugins'),
('1481', '204931', 'iwp_log_action', 'update'),
('1482', '204931', 'iwp_log_activities_type', 'direct'),
('1483', '204931', 'iwp_log_actions', 'plugins-updated'),
('1484', '204931', 'iwp_log_details', 'a:4:{s:4:\"name\";s:14:\"Contact Form 7\";s:4:\"slug\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"old_version\";s:3:\"5.1\";s:15:\"updated_version\";s:5:\"5.1.1\";}'),
('1485', '204932', 'iwp_log_type', 'plugins'),
('1486', '204932', 'iwp_log_action', 'update'),
('1487', '204932', 'iwp_log_activities_type', 'direct'),
('1488', '204932', 'iwp_log_actions', 'plugins-updated'),
('1489', '204932', 'iwp_log_details', 'a:4:{s:4:\"name\";s:26:\"Advanced Custom Fields PRO\";s:4:\"slug\";s:34:\"advanced-custom-fields-pro/acf.php\";s:11:\"old_version\";s:5:\"5.7.8\";s:15:\"updated_version\";s:6:\"5.7.10\";}'),
('1490', '204933', 'iwp_log_type', 'scheduleBackup'),
('1491', '204933', 'iwp_log_action', 'schedule'),
('1492', '204933', 'iwp_log_activities_type', 'iwp_log'),
('1493', '204933', 'iwp_log_actions', 'backups'),
('1494', '204933', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1508', '204948', 'iwp_log_type', 'scheduleBackup'),
('1509', '204948', 'iwp_log_action', 'schedule'),
('1510', '204948', 'iwp_log_activities_type', 'iwp_log'),
('1511', '204948', 'iwp_log_actions', 'backups'),
('1512', '204948', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1513', '204949', 'iwp_log_type', 'plugins'),
('1514', '204949', 'iwp_log_action', 'update'),
('1515', '204949', 'iwp_log_activities_type', 'direct'),
('1516', '204949', 'iwp_log_actions', 'plugins-updated'),
('1517', '204949', 'iwp_log_details', 'a:4:{s:4:\"name\";s:14:\"Classic Editor\";s:4:\"slug\";s:33:\"classic-editor/classic-editor.php\";s:11:\"old_version\";s:3:\"1.3\";s:15:\"updated_version\";s:3:\"1.4\";}'),
('1518', '204950', 'iwp_log_type', 'plugins'),
('1519', '204950', 'iwp_log_action', 'update'),
('1520', '204950', 'iwp_log_activities_type', 'direct'),
('1521', '204950', 'iwp_log_actions', 'plugins-updated'),
('1522', '204950', 'iwp_log_details', 'a:4:{s:4:\"name\";s:23:\"Official Facebook Pixel\";s:4:\"slug\";s:50:\"official-facebook-pixel/facebook-for-wordpress.php\";s:11:\"old_version\";s:6:\"1.7.22\";s:15:\"updated_version\";s:6:\"1.7.23\";}'),
('1523', '204951', 'iwp_log_type', 'themes'),
('1524', '204951', 'iwp_log_action', 'update'),
('1525', '204951', 'iwp_log_activities_type', 'direct'),
('1526', '204951', 'iwp_log_actions', 'themes-updated'),
('1527', '204951', 'iwp_log_details', 'a:4:{s:4:\"name\";s:4:\"Divi\";s:4:\"slug\";s:4:\"Divi\";s:11:\"old_version\";s:6:\"3.19.9\";s:15:\"updated_version\";s:7:\"3.19.11\";}'),
('1528', '204952', 'iwp_log_type', 'scheduleBackup'),
('1529', '204952', 'iwp_log_action', 'schedule'),
('1530', '204952', 'iwp_log_activities_type', 'iwp_log'),
('1531', '204952', 'iwp_log_actions', 'backups'),
('1532', '204952', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1533', '204953', 'iwp_log_type', 'scheduleBackup'),
('1534', '204953', 'iwp_log_action', 'schedule'),
('1535', '204953', 'iwp_log_activities_type', 'iwp_log'),
('1536', '204953', 'iwp_log_actions', 'backups'),
('1537', '204953', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1538', '204954', 'iwp_log_type', 'scheduleBackup'),
('1539', '204954', 'iwp_log_action', 'schedule'),
('1540', '204954', 'iwp_log_activities_type', 'iwp_log'),
('1541', '204954', 'iwp_log_actions', 'backups'),
('1542', '204954', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1543', '204957', 'iwp_log_type', 'plugins'),
('1544', '204957', 'iwp_log_action', 'update'),
('1545', '204957', 'iwp_log_activities_type', 'direct'),
('1546', '204957', 'iwp_log_actions', 'plugins-updated'),
('1547', '204957', 'iwp_log_details', 'a:4:{s:4:\"name\";s:26:\"Advanced Custom Fields PRO\";s:4:\"slug\";s:34:\"advanced-custom-fields-pro/acf.php\";s:11:\"old_version\";s:6:\"5.7.10\";s:15:\"updated_version\";s:6:\"5.7.12\";}'),
('1548', '204958', 'iwp_log_type', 'plugins'),
('1549', '204958', 'iwp_log_action', 'update'),
('1550', '204958', 'iwp_log_activities_type', 'direct'),
('1551', '204958', 'iwp_log_actions', 'plugins-updated'),
('1552', '204958', 'iwp_log_details', 'a:4:{s:4:\"name\";s:23:\"Official Facebook Pixel\";s:4:\"slug\";s:50:\"official-facebook-pixel/facebook-for-wordpress.php\";s:11:\"old_version\";s:6:\"1.7.23\";s:15:\"updated_version\";s:6:\"1.7.25\";}'),
('1553', '204959', 'iwp_log_type', 'plugins'),
('1554', '204959', 'iwp_log_action', 'update'),
('1555', '204959', 'iwp_log_activities_type', 'direct'),
('1556', '204959', 'iwp_log_actions', 'plugins-updated'),
('1557', '204959', 'iwp_log_details', 'a:4:{s:4:\"name\";s:17:\"WP Migrate DB Pro\";s:4:\"slug\";s:39:\"wp-migrate-db-pro/wp-migrate-db-pro.php\";s:11:\"old_version\";s:5:\"1.9.2\";s:15:\"updated_version\";s:5:\"1.9.3\";}'),
('1558', '204960', 'iwp_log_type', 'themes'),
('1559', '204960', 'iwp_log_action', 'update'),
('1560', '204960', 'iwp_log_activities_type', 'direct'),
('1561', '204960', 'iwp_log_actions', 'themes-updated'),
('1562', '204960', 'iwp_log_details', 'a:4:{s:4:\"name\";s:15:\"Twenty Nineteen\";s:4:\"slug\";s:15:\"Twenty Nineteen\";s:11:\"old_version\";s:3:\"1.2\";s:15:\"updated_version\";s:3:\"1.3\";}'),
('1563', '204961', 'iwp_log_type', 'themes'),
('1564', '204961', 'iwp_log_action', 'update'),
('1565', '204961', 'iwp_log_activities_type', 'direct'),
('1566', '204961', 'iwp_log_actions', 'themes-updated'),
('1567', '204961', 'iwp_log_details', 'a:4:{s:4:\"name\";s:16:\"Twenty Seventeen\";s:4:\"slug\";s:16:\"Twenty Seventeen\";s:11:\"old_version\";s:3:\"2.0\";s:15:\"updated_version\";s:3:\"2.1\";}'),
('1568', '204962', 'iwp_log_type', 'themes'),
('1569', '204962', 'iwp_log_action', 'update'),
('1570', '204962', 'iwp_log_activities_type', 'direct'),
('1571', '204962', 'iwp_log_actions', 'themes-updated'),
('1572', '204962', 'iwp_log_details', 'a:4:{s:4:\"name\";s:4:\"Divi\";s:4:\"slug\";s:4:\"Divi\";s:11:\"old_version\";s:7:\"3.19.11\";s:15:\"updated_version\";s:7:\"3.19.18\";}'),
('1573', '204963', 'iwp_log_type', 'core'),
('1574', '204963', 'iwp_log_action', 'update'),
('1575', '204963', 'iwp_log_activities_type', 'direct'),
('1576', '204963', 'iwp_log_actions', 'core-updated'),
('1577', '204963', 'iwp_log_details', 'a:2:{s:11:\"old_version\";s:5:\"5.0.3\";s:15:\"updated_version\";s:3:\"5.1\";}'),
('1578', '204964', 'iwp_log_type', 'scheduleBackup'),
('1579', '204964', 'iwp_log_action', 'schedule'),
('1580', '204964', 'iwp_log_activities_type', 'iwp_log'),
('1581', '204964', 'iwp_log_actions', 'backups'),
('1582', '204964', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1585', '204966', 'iwp_log_type', 'scheduleBackup'),
('1586', '204966', 'iwp_log_action', 'schedule'),
('1587', '204966', 'iwp_log_activities_type', 'iwp_log'),
('1588', '204966', 'iwp_log_actions', 'backups'),
('1589', '204966', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1590', '204967', 'iwp_log_type', 'scheduleBackup'),
('1591', '204967', 'iwp_log_action', 'schedule'),
('1592', '204967', 'iwp_log_activities_type', 'iwp_log'),
('1593', '204967', 'iwp_log_actions', 'backups'),
('1594', '204967', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1595', '204968', 'iwp_log_type', 'scheduleBackup'),
('1596', '204968', 'iwp_log_action', 'schedule'),
('1597', '204968', 'iwp_log_activities_type', 'iwp_log'),
('1598', '204968', 'iwp_log_actions', 'backups'),
('1599', '204968', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1600', '204969', 'iwp_log_type', 'scheduleBackup'),
('1601', '204969', 'iwp_log_action', 'schedule'),
('1602', '204969', 'iwp_log_activities_type', 'iwp_log'),
('1603', '204969', 'iwp_log_actions', 'backups'),
('1604', '204969', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1605', '204971', 'iwp_log_type', 'plugins'),
('1606', '204971', 'iwp_log_action', 'update'),
('1607', '204971', 'iwp_log_activities_type', 'direct'),
('1608', '204971', 'iwp_log_actions', 'plugins-updated'),
('1609', '204971', 'iwp_log_details', 'a:4:{s:4:\"name\";s:48:\"ActiveCampaign - Forms, Site Tracking, Live Chat\";s:4:\"slug\";s:52:\"activecampaign-subscription-forms/activecampaign.php\";s:11:\"old_version\";s:3:\"7.0\";s:15:\"updated_version\";s:3:\"7.1\";}'),
('1610', '204972', 'iwp_log_type', 'plugins'),
('1611', '204972', 'iwp_log_action', 'update'),
('1612', '204972', 'iwp_log_activities_type', 'direct'),
('1613', '204972', 'iwp_log_actions', 'plugins-updated'),
('1614', '204972', 'iwp_log_details', 'a:4:{s:4:\"name\";s:26:\"Advanced Custom Fields PRO\";s:4:\"slug\";s:34:\"advanced-custom-fields-pro/acf.php\";s:11:\"old_version\";s:6:\"5.7.12\";s:15:\"updated_version\";s:6:\"5.7.13\";}'),
('1615', '204973', 'iwp_log_type', 'plugins'),
('1616', '204973', 'iwp_log_action', 'update'),
('1617', '204973', 'iwp_log_activities_type', 'direct'),
('1618', '204973', 'iwp_log_actions', 'plugins-updated'),
('1619', '204973', 'iwp_log_details', 'a:4:{s:4:\"name\";s:17:\"WP Migrate DB Pro\";s:4:\"slug\";s:39:\"wp-migrate-db-pro/wp-migrate-db-pro.php\";s:11:\"old_version\";s:5:\"1.9.3\";s:15:\"updated_version\";s:5:\"1.9.5\";}'),
('1620', '204974', 'iwp_log_type', 'plugins'),
('1621', '204974', 'iwp_log_action', 'update'),
('1622', '204974', 'iwp_log_activities_type', 'direct'),
('1623', '204974', 'iwp_log_actions', 'plugins-updated'),
('1624', '204974', 'iwp_log_details', 'a:4:{s:4:\"name\";s:30:\"YIKES Simple Taxonomy Ordering\";s:4:\"slug\";s:56:\"simple-taxonomy-ordering/yikes-custom-taxonomy-order.php\";s:11:\"old_version\";s:5:\"1.2.7\";s:15:\"updated_version\";s:5:\"2.0.2\";}'),
('1625', '204673', '_et_pb_truncate_post', '<div class=\"et_pb_section et_pb_section_0 et_section_regular\">\n				\n				\n				\n				\n					<div class=\"et_pb_row et_pb_row_0\">\n				<div class=\"et_pb_column et_pb_column_4_4 et_pb_column_0    et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_0 et_pb_bg_layout_light  et_pb_text_align_left\">\n				\n				\n				<div class=\"et_pb_text_inner\">\n					Toilet training for your new puppy<br />\nYour new puppy is a dream-come-true. Cute as can be, funny, warm, cuddly. But with the good, comes the … not-so-good. Your gorgeous bundle of fur and fun is also pooping and peeing machine!  Toilet training is the top of most new pet-parent’s agenda, and it’s important you understand what to do from the get-go.</p>\n<p>Follow these key steps for success: </p>\n<p> 	Puppies have small bladder capacity, so they must have frequent opportunities to go outside. If your pup is inside with you, set your alarm &amp; take him out every hour on the hour.<br />\n 	When your puppy is outside for a toilet break, wait with him so you can reward him when he’s finished. While waiting for the puppy to do his business be as boring as possible!<br />\n 	After he has finished, reward with a treat &amp; lots of praise.<br />\n 	Be patient and always go with him – even if it’s cold!<br />\n 	Walk your puppy to the desired area so that he learns to walk there. If he finds that too hard at the beginning, carry him part the way there and let him walk the last few metres. As he gains more confidence, start to decrease the distance he is carried.</p>\n<p>When will he want “to go”?</p>\n<p> 	If your puppy is sniffing the ground, circling it is a sign they are about to toilet, so immediately take your pup to the toilet area.<br />\n 	Regular breaks – take puppy outside every 1-2hrs for an 8-week old puppy. As he gets older, the time between toilet breaks can increase.<br />\n 	After meals – regardless of how regularly he has been taken outside, always take him out after a meal. Watch for the signs, (sniffing, circling), anywhere from 5 minutes to an hour after the meal.<br />\n 	After a nap – when your puppy wakes after a sleep, take him to the toilet area.<br />\n 	After a play period – take puppy outside for a toilet break after a play session. He is likely to have been so engrossed in the play that he will have forgotten to think about toileting needs. And he is likely to want a sleep after play and will settle much more quickly with an empty bladder.<br />\n 	The middle of the night wake-up call – if your puppy wakes at 5am or the middle of the night and starts to whimper, this probably means he needs a toilet break. If his cries are not answered &amp; he toilets in his sleeping area, both he &amp; you will be stressed. Worse, if puppy learns that no one listens to his cries, he may stop crying and just toilet wherever he is.</p>\n<p>Accidents Happen!</p>\n<p> 	Dogs are attracted to a place they have previously done their business by the residual smell, which normal detergents and cleaners do not remove. Clean up accidents using an enzymatic cleaner such as Biozet Attack or another enzymatic laundry detergent. Rinse carefully and if necessary, use a pet odour neutraliser to remove any residual smell.<br />\n 	When your puppy has an accident, clean it up but ignore it and make a note to yourself to be more vigilant in supervising your pup in future.<br />\n 	Never punish your pup for having an accident. The most likely consequence of being punished is that he will learn to toilet where you can’t see him, behind the sofa or under the bed. Instead, make a note to yourself to be more vigilant.<br />\n 	Confine your puppy using baby gates or a puppy pen, so that he doesn’t have the run of the house. Remember, if you can&#8217;t see him, you will miss the warning signs that he&#8217;s about to toilet.<br />\n 	Crate training is another way to confine your puppy. He will be reluctant to soil his eating &amp; sleeping area, so encouraging him to use a crate with a food bowl, sleeping mat &amp; toys will encourage him to hang on until his next outing. Be sure not to leave your puppy in his crate for longer than he is able to hold on.<br />\n 	Excitement wees? Some little puppies lose control of their bladder &amp; urinate when excited, such as when visitors arrive. Try your best to make these occasions calm, and give your puppy a chew toy on which he can direct his excitement. Or better still, have these greetings outside where it doesn’t matter if he has an accident.</p>\n<p>Remember </p>\n<p> 	Your pup doesn’t toilet inside to “get back at you”, or to be naughty. It takes a while for them to put the pieces of the puzzle together, and understand that when they need to toilet, they&#8217;re supposed to take themselves outside.<br />\n 	And often they forget where they are and just &#8216;do it&#8217; because they can’t hold on!<br />\n 	This is only a short phase in your puppy’s life – be patient, consistent, and reward him when he does the right thing.<br />\n 	House training your puppy will ensure he can become a welcome member of your family who can happily be indoors with you.<br />\n 	Be vigilant and NEVER USE PUNISHMENT- A very famous English trainer by the name of Dr Ian Dunbar said it best: “ If your puppy has a toilet accident inside, roll up a newspaper, hold out your hand and give yourself a smack so YOU remember to be more vigilant next time.”<br />\n 	Hang in there, and to quote another famous person: “It won’t happen overnight, but it will happen”!</p>\n				</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section -->\n'),
('1626', '204653', '_et_pb_truncate_post', '<div class=\"et_pb_section et_pb_section_1 et_section_regular\">\n				\n				\n				\n				\n					<div class=\"et_pb_row et_pb_row_1\">\n				<div class=\"et_pb_column et_pb_column_4_4 et_pb_column_1    et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_1 et_pb_bg_layout_light  et_pb_text_align_left\">\n				\n				\n				<div class=\"et_pb_text_inner\">\n					Separation anxiety in dogs?<br />\nWhen I tell people I recently learned how to work with dogs with separation anxiety, some of them look at me a little funny. And for those lucky people who’s dogs don’t bat an eyelid when their human departs, it can be hard to understand the devastating affect of this condition, not just on the dog, but also on the humans who love them.</p>\n<p>What does it look like? Does your dog whimper, cry, bark or howl for hours after you’ve gone? Do you come home to a scene of destruction because your dog has been pawing and chewing at the door or skirting boards, destroying your furniture? Does your dog eliminate repeatedly all over your carpet? If this is your dog, he may be suffering from separation anxiety.</p>\n<p>What to do?<br />\nThe good news is, help is available. You can work with a Certified Separation Anxiety Trainer (CSAT) to learn how to gradually introduce your dog to absences, at the rate and duration that your dog can accept calmly. And Jenny is proud to be the first dog trainer in Australia to become a Certified Separation Anxiety Trainer.</p>\n<p>Working with a CSAT means you have access to well-trialled training methods that teach your dog how to be relaxed when left alone. Plus, you have access to all the support, help and cheerleading you need to get you through the challenge of being the guardian of a dog with separation anxiety.</p>\n<p>How?<br />\nTechnology is our friend when working with separation anxiety. By working online you and and Jenny will see your dog’s response at each step of the process, which means instant feedback informing how to move forward. It is the most efficient route to reaching your goals, gives you more bang for you buck, and means Jenny can work with people across Australia and overseas.</p>\n<p>So what now?<br />\nAs the first dog trainer in Australia to study with international separation anxiety expert Malena DeMartini (www.malenademartini.com ), Jenny is proud to be a CSAT working to improve the lives of dogs with separation anxiety and their long-suffering humans.</p>\n<p>Help is available. To discuss your dog and learn about this training process, click here.</p>\n				</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section -->\n'),
('1627', '204975', 'iwp_log_type', 'scheduleBackup'),
('1628', '204975', 'iwp_log_action', 'schedule'),
('1629', '204975', 'iwp_log_activities_type', 'iwp_log'),
('1630', '204975', 'iwp_log_actions', 'backups'),
('1631', '204975', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1632', '204976', 'iwp_log_type', 'scheduleBackup'),
('1633', '204976', 'iwp_log_action', 'schedule'),
('1634', '204976', 'iwp_log_activities_type', 'iwp_log'),
('1635', '204976', 'iwp_log_actions', 'backups'),
('1636', '204976', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1637', '204977', 'iwp_log_type', 'scheduleBackup'),
('1638', '204977', 'iwp_log_action', 'schedule'),
('1639', '204977', 'iwp_log_activities_type', 'iwp_log'),
('1640', '204977', 'iwp_log_actions', 'backups'),
('1641', '204977', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1642', '204979', 'iwp_log_type', 'plugins'),
('1643', '204979', 'iwp_log_action', 'update'),
('1644', '204979', 'iwp_log_activities_type', 'direct'),
('1645', '204979', 'iwp_log_actions', 'plugins-updated'),
('1646', '204979', 'iwp_log_details', 'a:4:{s:4:\"name\";s:48:\"ActiveCampaign - Forms, Site Tracking, Live Chat\";s:4:\"slug\";s:52:\"activecampaign-subscription-forms/activecampaign.php\";s:11:\"old_version\";s:3:\"7.1\";s:15:\"updated_version\";s:5:\"7.1.1\";}'),
('1647', '204980', 'iwp_log_type', 'plugins'),
('1648', '204980', 'iwp_log_action', 'update'),
('1649', '204980', 'iwp_log_activities_type', 'direct'),
('1650', '204980', 'iwp_log_actions', 'plugins-updated'),
('1651', '204980', 'iwp_log_details', 'a:4:{s:4:\"name\";s:30:\"YIKES Simple Taxonomy Ordering\";s:4:\"slug\";s:56:\"simple-taxonomy-ordering/yikes-custom-taxonomy-order.php\";s:11:\"old_version\";s:5:\"2.0.2\";s:15:\"updated_version\";s:5:\"2.0.3\";}'),
('1652', '204981', 'iwp_log_type', 'scheduleBackup'),
('1653', '204981', 'iwp_log_action', 'schedule'),
('1654', '204981', 'iwp_log_activities_type', 'iwp_log'),
('1655', '204981', 'iwp_log_actions', 'backups'),
('1656', '204981', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1657', '204982', 'iwp_log_type', 'scheduleBackup'),
('1658', '204982', 'iwp_log_action', 'schedule'),
('1659', '204982', 'iwp_log_activities_type', 'iwp_log'),
('1660', '204982', 'iwp_log_actions', 'backups'),
('1661', '204982', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1662', '204983', 'iwp_log_type', 'scheduleBackup'),
('1663', '204983', 'iwp_log_action', 'schedule'),
('1664', '204983', 'iwp_log_activities_type', 'iwp_log'),
('1665', '204983', 'iwp_log_actions', 'backups'),
('1666', '204983', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1667', '204985', 'iwp_log_type', 'plugins'),
('1668', '204985', 'iwp_log_action', 'update'),
('1669', '204985', 'iwp_log_activities_type', 'direct'),
('1670', '204985', 'iwp_log_actions', 'plugins-updated'),
('1671', '204985', 'iwp_log_details', 'a:4:{s:4:\"name\";s:14:\"ActiveCampaign\";s:4:\"slug\";s:52:\"activecampaign-subscription-forms/activecampaign.php\";s:11:\"old_version\";s:5:\"7.1.1\";s:15:\"updated_version\";s:5:\"7.1.2\";}'),
('1672', '204986', 'iwp_log_type', 'plugins'),
('1673', '204986', 'iwp_log_action', 'update'),
('1674', '204986', 'iwp_log_activities_type', 'direct'),
('1675', '204986', 'iwp_log_actions', 'plugins-updated'),
('1676', '204986', 'iwp_log_details', 'a:4:{s:4:\"name\";s:26:\"Advanced Custom Fields PRO\";s:4:\"slug\";s:34:\"advanced-custom-fields-pro/acf.php\";s:11:\"old_version\";s:6:\"5.7.13\";s:15:\"updated_version\";s:5:\"5.8.0\";}'),
('1677', '204987', 'iwp_log_type', 'plugins'),
('1678', '204987', 'iwp_log_action', 'update'),
('1679', '204987', 'iwp_log_activities_type', 'direct'),
('1680', '204987', 'iwp_log_actions', 'plugins-updated'),
('1681', '204987', 'iwp_log_details', 'a:4:{s:4:\"name\";s:14:\"Classic Editor\";s:4:\"slug\";s:33:\"classic-editor/classic-editor.php\";s:11:\"old_version\";s:3:\"1.4\";s:15:\"updated_version\";s:3:\"1.5\";}'),
('1682', '204988', 'iwp_log_type', 'plugins'),
('1683', '204988', 'iwp_log_action', 'update'),
('1684', '204988', 'iwp_log_activities_type', 'direct'),
('1685', '204988', 'iwp_log_actions', 'plugins-updated'),
('1686', '204988', 'iwp_log_details', 'a:4:{s:4:\"name\";s:14:\"Contact Form 7\";s:4:\"slug\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"old_version\";s:5:\"5.1.1\";s:15:\"updated_version\";s:5:\"5.1.2\";}'),
('1687', '204989', 'iwp_log_type', 'plugins'),
('1688', '204989', 'iwp_log_action', 'update'),
('1689', '204989', 'iwp_log_activities_type', 'direct'),
('1690', '204989', 'iwp_log_actions', 'plugins-updated'),
('1691', '204989', 'iwp_log_details', 'a:4:{s:4:\"name\";s:16:\"Post Types Order\";s:4:\"slug\";s:37:\"post-types-order/post-types-order.php\";s:11:\"old_version\";s:7:\"1.9.3.9\";s:15:\"updated_version\";s:7:\"1.9.4.1\";}'),
('1692', '204990', 'iwp_log_type', 'plugins'),
('1693', '204990', 'iwp_log_action', 'update'),
('1694', '204990', 'iwp_log_activities_type', 'direct'),
('1695', '204990', 'iwp_log_actions', 'plugins-updated'),
('1696', '204990', 'iwp_log_details', 'a:4:{s:4:\"name\";s:17:\"WP Migrate DB Pro\";s:4:\"slug\";s:39:\"wp-migrate-db-pro/wp-migrate-db-pro.php\";s:11:\"old_version\";s:5:\"1.9.5\";s:15:\"updated_version\";s:5:\"1.9.8\";}'),
('1697', '204991', 'iwp_log_type', 'core'),
('1698', '204991', 'iwp_log_action', 'update'),
('1699', '204991', 'iwp_log_activities_type', 'direct'),
('1700', '204991', 'iwp_log_actions', 'core-updated'),
('1701', '204991', 'iwp_log_details', 'a:2:{s:11:\"old_version\";s:5:\"5.1.1\";s:15:\"updated_version\";s:3:\"5.2\";}'),
('1702', '204992', 'iwp_log_type', 'scheduleBackup'),
('1703', '204992', 'iwp_log_action', 'schedule'),
('1704', '204992', 'iwp_log_activities_type', 'iwp_log'),
('1705', '204992', 'iwp_log_actions', 'backups'),
('1706', '204992', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1707', '204993', 'iwp_log_type', 'scheduleBackup'),
('1708', '204993', 'iwp_log_action', 'schedule'),
('1709', '204993', 'iwp_log_activities_type', 'iwp_log'),
('1710', '204993', 'iwp_log_actions', 'backups'),
('1711', '204993', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1712', '204994', 'iwp_log_type', 'scheduleBackup'),
('1713', '204994', 'iwp_log_action', 'schedule'),
('1714', '204994', 'iwp_log_activities_type', 'iwp_log'),
('1715', '204994', 'iwp_log_actions', 'backups'),
('1716', '204994', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1717', '204995', 'iwp_log_type', 'scheduleBackup'),
('1718', '204995', 'iwp_log_action', 'schedule'),
('1719', '204995', 'iwp_log_activities_type', 'iwp_log'),
('1720', '204995', 'iwp_log_actions', 'backups'),
('1721', '204995', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1722', '204996', 'iwp_log_type', 'scheduleBackup'),
('1723', '204996', 'iwp_log_action', 'schedule'),
('1724', '204996', 'iwp_log_activities_type', 'iwp_log'),
('1725', '204996', 'iwp_log_actions', 'backups'),
('1726', '204996', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1727', '204998', 'iwp_log_type', 'scheduleBackup'),
('1728', '204998', 'iwp_log_action', 'schedule'),
('1729', '204998', 'iwp_log_activities_type', 'iwp_log'),
('1730', '204998', 'iwp_log_actions', 'backups'),
('1731', '204998', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1732', '204999', '_wp_attached_file', '2019/06/kpalogo.jpg'),
('1733', '204999', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:123;s:6:\"height\";i:80;s:4:\"file\";s:19:\"2019/06/kpalogo.jpg\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('1734', '204999', '_edit_lock', '1561660525:2'),
('1735', '205001', '_wp_attached_file', '2019/06/kpalogo.png'),
('1736', '205001', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:123;s:6:\"height\";i:80;s:4:\"file\";s:19:\"2019/06/kpalogo.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('1737', '205001', '_edit_lock', '1561660558:2'),
('1738', '205003', 'iwp_log_type', 'plugins'),
('1739', '205003', 'iwp_log_action', 'update'),
('1740', '205003', 'iwp_log_activities_type', 'direct'),
('1741', '205003', 'iwp_log_actions', 'plugins-updated'),
('1742', '205003', 'iwp_log_details', 'a:4:{s:4:\"name\";s:26:\"Advanced Custom Fields PRO\";s:4:\"slug\";s:34:\"advanced-custom-fields-pro/acf.php\";s:11:\"old_version\";s:5:\"5.8.0\";s:15:\"updated_version\";s:5:\"5.8.1\";}'),
('1743', '205004', 'iwp_log_type', 'plugins'),
('1744', '205004', 'iwp_log_action', 'update'),
('1745', '205004', 'iwp_log_activities_type', 'direct'),
('1746', '205004', 'iwp_log_actions', 'plugins-updated'),
('1747', '205004', 'iwp_log_details', 'a:4:{s:4:\"name\";s:14:\"Contact Form 7\";s:4:\"slug\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"old_version\";s:5:\"5.1.2\";s:15:\"updated_version\";s:5:\"5.1.3\";}'),
('1748', '205005', 'iwp_log_type', 'plugins'),
('1749', '205005', 'iwp_log_action', 'update'),
('1750', '205005', 'iwp_log_activities_type', 'direct'),
('1751', '205005', 'iwp_log_actions', 'plugins-updated'),
('1752', '205005', 'iwp_log_details', 'a:4:{s:4:\"name\";s:19:\"Custom Post Type UI\";s:4:\"slug\";s:43:\"custom-post-type-ui/custom-post-type-ui.php\";s:11:\"old_version\";s:5:\"1.6.1\";s:15:\"updated_version\";s:5:\"1.6.2\";}'),
('1753', '205006', 'iwp_log_type', 'core'),
('1754', '205006', 'iwp_log_action', 'update'),
('1755', '205006', 'iwp_log_activities_type', 'direct'),
('1756', '205006', 'iwp_log_actions', 'core-updated'),
('1757', '205006', 'iwp_log_details', 'a:2:{s:11:\"old_version\";s:3:\"5.2\";s:15:\"updated_version\";s:5:\"5.2.2\";}'),
('1758', '205007', 'iwp_log_type', 'scheduleBackup'),
('1759', '205007', 'iwp_log_action', 'schedule'),
('1760', '205007', 'iwp_log_activities_type', 'iwp_log'),
('1761', '205007', 'iwp_log_actions', 'backups'),
('1762', '205007', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1763', '205008', 'iwp_log_type', 'scheduleBackup'),
('1764', '205008', 'iwp_log_action', 'schedule'),
('1765', '205008', 'iwp_log_activities_type', 'iwp_log'),
('1766', '205008', 'iwp_log_actions', 'backups'),
('1767', '205008', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1768', '205010', 'iwp_log_type', 'scheduleBackup'),
('1769', '205010', 'iwp_log_action', 'schedule'),
('1770', '205010', 'iwp_log_activities_type', 'iwp_log'),
('1771', '205010', 'iwp_log_actions', 'backups'),
('1772', '205010', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1773', '205011', 'iwp_log_type', 'plugins'),
('1774', '205011', 'iwp_log_action', 'update'),
('1775', '205011', 'iwp_log_activities_type', 'direct'),
('1776', '205011', 'iwp_log_actions', 'plugins-updated'),
('1777', '205011', 'iwp_log_details', 'a:4:{s:4:\"name\";s:26:\"Advanced Custom Fields PRO\";s:4:\"slug\";s:34:\"advanced-custom-fields-pro/acf.php\";s:11:\"old_version\";s:5:\"5.8.1\";s:15:\"updated_version\";s:5:\"5.8.2\";}'),
('1778', '205012', 'iwp_log_type', 'scheduleBackup'),
('1779', '205012', 'iwp_log_action', 'schedule'),
('1780', '205012', 'iwp_log_activities_type', 'iwp_log'),
('1781', '205012', 'iwp_log_actions', 'backups'),
('1782', '205012', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1783', '204559', '_et_pb_truncate_post', ''),
('1784', '205014', 'iwp_log_type', 'plugins'),
('1785', '205014', 'iwp_log_action', 'update'),
('1786', '205014', 'iwp_log_activities_type', 'direct'),
('1787', '205014', 'iwp_log_actions', 'plugins-updated'),
('1788', '205014', 'iwp_log_details', 'a:4:{s:4:\"name\";s:26:\"Advanced Custom Fields PRO\";s:4:\"slug\";s:34:\"advanced-custom-fields-pro/acf.php\";s:11:\"old_version\";s:5:\"5.8.2\";s:15:\"updated_version\";s:5:\"5.8.3\";}'),
('1789', '205015', 'iwp_log_type', 'plugins'),
('1790', '205015', 'iwp_log_action', 'update'),
('1791', '205015', 'iwp_log_activities_type', 'direct'),
('1792', '205015', 'iwp_log_actions', 'plugins-updated'),
('1793', '205015', 'iwp_log_details', 'a:4:{s:4:\"name\";s:14:\"Contact Form 7\";s:4:\"slug\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"old_version\";s:5:\"5.1.3\";s:15:\"updated_version\";s:5:\"5.1.4\";}'),
('1794', '205016', 'iwp_log_type', 'plugins'),
('1795', '205016', 'iwp_log_action', 'update'),
('1796', '205016', 'iwp_log_activities_type', 'direct'),
('1797', '205016', 'iwp_log_actions', 'plugins-updated'),
('1798', '205016', 'iwp_log_details', 'a:4:{s:4:\"name\";s:25:\"PHP Compatibility Checker\";s:4:\"slug\";s:48:\"php-compatibility-checker/wpengine-phpcompat.php\";s:11:\"old_version\";s:5:\"1.4.7\";s:15:\"updated_version\";s:5:\"1.5.0\";}'),
('1799', '205017', 'iwp_log_type', 'scheduleBackup'),
('1800', '205017', 'iwp_log_action', 'schedule'),
('1801', '205017', 'iwp_log_activities_type', 'iwp_log'),
('1802', '205017', 'iwp_log_actions', 'backups'),
('1803', '205017', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1804', '205018', 'iwp_log_type', 'scheduleBackup'),
('1805', '205018', 'iwp_log_action', 'schedule'),
('1806', '205018', 'iwp_log_activities_type', 'iwp_log'),
('1807', '205018', 'iwp_log_actions', 'backups'),
('1808', '205018', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1809', '205019', 'iwp_log_type', 'scheduleBackup'),
('1810', '205019', 'iwp_log_action', 'schedule'),
('1811', '205019', 'iwp_log_activities_type', 'iwp_log'),
('1812', '205019', 'iwp_log_actions', 'backups'),
('1813', '205019', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1814', '205020', 'iwp_log_type', 'scheduleBackup'),
('1815', '205020', 'iwp_log_action', 'schedule'),
('1816', '205020', 'iwp_log_activities_type', 'iwp_log'),
('1817', '205020', 'iwp_log_actions', 'backups'),
('1818', '205020', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1819', '205021', 'iwp_log_type', 'scheduleBackup'),
('1820', '205021', 'iwp_log_action', 'schedule'),
('1821', '205021', 'iwp_log_activities_type', 'iwp_log'),
('1822', '205021', 'iwp_log_actions', 'backups'),
('1823', '205021', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1824', '205023', 'iwp_log_type', 'plugins'),
('1825', '205023', 'iwp_log_action', 'update'),
('1826', '205023', 'iwp_log_activities_type', 'direct'),
('1827', '205023', 'iwp_log_actions', 'plugins-updated'),
('1828', '205023', 'iwp_log_details', 'a:4:{s:4:\"name\";s:26:\"Advanced Custom Fields PRO\";s:4:\"slug\";s:34:\"advanced-custom-fields-pro/acf.php\";s:11:\"old_version\";s:5:\"5.8.3\";s:15:\"updated_version\";s:5:\"5.8.4\";}'),
('1829', '205024', 'iwp_log_type', 'plugins'),
('1830', '205024', 'iwp_log_action', 'update'),
('1831', '205024', 'iwp_log_activities_type', 'direct'),
('1832', '205024', 'iwp_log_actions', 'plugins-updated'),
('1833', '205024', 'iwp_log_details', 'a:4:{s:4:\"name\";s:30:\"YIKES Simple Taxonomy Ordering\";s:4:\"slug\";s:56:\"simple-taxonomy-ordering/yikes-custom-taxonomy-order.php\";s:11:\"old_version\";s:5:\"2.0.3\";s:15:\"updated_version\";s:5:\"2.1.0\";}'),
('1834', '205025', 'iwp_log_type', 'scheduleBackup'),
('1835', '205025', 'iwp_log_action', 'schedule'),
('1836', '205025', 'iwp_log_activities_type', 'iwp_log'),
('1837', '205025', 'iwp_log_actions', 'backups'),
('1838', '205025', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1839', '205027', 'iwp_log_type', 'scheduleBackup'),
('1840', '205027', 'iwp_log_action', 'schedule'),
('1841', '205027', 'iwp_log_activities_type', 'iwp_log'),
('1842', '205027', 'iwp_log_actions', 'backups'),
('1843', '205027', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1844', '205029', 'iwp_log_type', 'plugins'),
('1845', '205029', 'iwp_log_action', 'update'),
('1846', '205029', 'iwp_log_activities_type', 'direct'),
('1847', '205029', 'iwp_log_actions', 'plugins-updated'),
('1848', '205029', 'iwp_log_details', 'a:4:{s:4:\"name\";s:26:\"Advanced Custom Fields PRO\";s:4:\"slug\";s:34:\"advanced-custom-fields-pro/acf.php\";s:11:\"old_version\";s:5:\"5.8.4\";s:15:\"updated_version\";s:5:\"5.8.6\";}'),
('1849', '205030', 'iwp_log_type', 'core'),
('1850', '205030', 'iwp_log_action', 'update'),
('1851', '205030', 'iwp_log_activities_type', 'direct'),
('1852', '205030', 'iwp_log_actions', 'core-updated'),
('1853', '205030', 'iwp_log_details', 'a:2:{s:11:\"old_version\";s:5:\"5.2.3\";s:15:\"updated_version\";s:5:\"5.2.4\";}'),
('1854', '205032', 'iwp_log_type', 'plugins'),
('1855', '205032', 'iwp_log_action', 'update'),
('1856', '205032', 'iwp_log_activities_type', 'iwp_log'),
('1857', '205032', 'iwp_log_actions', 'plugins-updated'),
('1858', '205032', 'iwp_log_details', 'a:4:{s:4:\"name\";s:26:\"Advanced Custom Fields PRO\";s:4:\"slug\";s:26:\"advanced-custom-fields-pro\";s:11:\"old_version\";s:5:\"5.8.6\";s:15:\"updated_version\";s:5:\"5.8.7\";}'),
('1859', '205033', 'iwp_log_type', 'plugins'),
('1860', '205033', 'iwp_log_action', 'update'),
('1861', '205033', 'iwp_log_activities_type', 'iwp_log'),
('1862', '205033', 'iwp_log_actions', 'plugins-updated'),
('1863', '205033', 'iwp_log_details', 'a:4:{s:4:\"name\";s:19:\"Custom Post Type UI\";s:4:\"slug\";s:19:\"custom-post-type-ui\";s:11:\"old_version\";s:5:\"1.6.2\";s:15:\"updated_version\";s:5:\"1.7.1\";}'),
('1864', '205034', 'iwp_log_type', 'plugins'),
('1865', '205034', 'iwp_log_action', 'update'),
('1866', '205034', 'iwp_log_activities_type', 'iwp_log'),
('1867', '205034', 'iwp_log_actions', 'plugins-updated'),
('1868', '205034', 'iwp_log_details', 'a:4:{s:4:\"name\";s:14:\"Contact Form 7\";s:4:\"slug\";s:14:\"contact-form-7\";s:11:\"old_version\";s:5:\"5.1.4\";s:15:\"updated_version\";s:5:\"5.1.5\";}'),
('1869', '205036', 'iwp_log_type', 'core'),
('1870', '205036', 'iwp_log_action', 'update'),
('1871', '205036', 'iwp_log_activities_type', 'direct'),
('1872', '205036', 'iwp_log_actions', 'core-updated'),
('1873', '205036', 'iwp_log_details', 'a:2:{s:11:\"old_version\";s:5:\"5.2.4\";s:15:\"updated_version\";s:3:\"5.3\";}'),
('1874', '205037', 'iwp_log_type', 'plugins'),
('1875', '205037', 'iwp_log_action', 'update'),
('1876', '205037', 'iwp_log_activities_type', 'direct'),
('1877', '205037', 'iwp_log_actions', 'plugins-updated'),
('1878', '205037', 'iwp_log_details', 'a:4:{s:4:\"name\";s:16:\"iThemes Security\";s:4:\"slug\";s:41:\"better-wp-security/better-wp-security.php\";s:11:\"old_version\";s:5:\"7.4.1\";s:15:\"updated_version\";s:5:\"7.5.0\";}'),
('1879', '205038', 'iwp_log_type', 'scheduleBackup'),
('1880', '205038', 'iwp_log_action', 'schedule'),
('1881', '205038', 'iwp_log_activities_type', 'iwp_log'),
('1882', '205038', 'iwp_log_actions', 'backups'),
('1883', '205038', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1884', '205039', 'iwp_log_type', 'scheduleBackup'),
('1885', '205039', 'iwp_log_action', 'schedule'),
('1886', '205039', 'iwp_log_activities_type', 'iwp_log'),
('1887', '205039', 'iwp_log_actions', 'backups'),
('1888', '205039', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1889', '205040', 'iwp_log_type', 'scheduleBackup'),
('1890', '205040', 'iwp_log_action', 'schedule'),
('1891', '205040', 'iwp_log_activities_type', 'iwp_log'),
('1892', '205040', 'iwp_log_actions', 'backups'),
('1893', '205040', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1894', '205041', 'iwp_log_type', 'scheduleBackup'),
('1895', '205041', 'iwp_log_action', 'schedule'),
('1896', '205041', 'iwp_log_activities_type', 'iwp_log'),
('1897', '205041', 'iwp_log_actions', 'backups'),
('1898', '205041', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1899', '205043', 'iwp_log_type', 'plugins'),
('1900', '205043', 'iwp_log_action', 'update'),
('1901', '205043', 'iwp_log_activities_type', 'direct'),
('1902', '205043', 'iwp_log_actions', 'plugins-updated'),
('1903', '205043', 'iwp_log_details', 'a:4:{s:4:\"name\";s:14:\"Contact Form 7\";s:4:\"slug\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"old_version\";s:5:\"5.1.5\";s:15:\"updated_version\";s:5:\"5.1.6\";}'),
('1904', '205044', 'iwp_log_type', 'plugins'),
('1905', '205044', 'iwp_log_action', 'update'),
('1906', '205044', 'iwp_log_activities_type', 'direct'),
('1907', '205044', 'iwp_log_actions', 'plugins-updated'),
('1908', '205044', 'iwp_log_details', 'a:4:{s:4:\"name\";s:16:\"iThemes Security\";s:4:\"slug\";s:41:\"better-wp-security/better-wp-security.php\";s:11:\"old_version\";s:5:\"7.5.0\";s:15:\"updated_version\";s:5:\"7.6.1\";}'),
('1909', '205045', 'iwp_log_type', 'plugins'),
('1910', '205045', 'iwp_log_action', 'update'),
('1911', '205045', 'iwp_log_activities_type', 'direct'),
('1912', '205045', 'iwp_log_actions', 'plugins-updated'),
('1913', '205045', 'iwp_log_details', 'a:4:{s:4:\"name\";s:23:\"Official Facebook Pixel\";s:4:\"slug\";s:50:\"official-facebook-pixel/facebook-for-wordpress.php\";s:11:\"old_version\";s:6:\"1.7.25\";s:15:\"updated_version\";s:5:\"1.8.0\";}'),
('1914', '205046', 'iwp_log_type', 'plugins'),
('1915', '205046', 'iwp_log_action', 'update'),
('1916', '205046', 'iwp_log_activities_type', 'direct'),
('1917', '205046', 'iwp_log_actions', 'plugins-updated'),
('1918', '205046', 'iwp_log_details', 'a:4:{s:4:\"name\";s:16:\"Post Types Order\";s:4:\"slug\";s:37:\"post-types-order/post-types-order.php\";s:11:\"old_version\";s:7:\"1.9.4.1\";s:15:\"updated_version\";s:7:\"1.9.4.2\";}'),
('1919', '205047', 'iwp_log_type', 'plugins'),
('1920', '205047', 'iwp_log_action', 'update'),
('1921', '205047', 'iwp_log_activities_type', 'direct'),
('1922', '205047', 'iwp_log_actions', 'plugins-updated'),
('1923', '205047', 'iwp_log_details', 'a:4:{s:4:\"name\";s:57:\"Sucuri Security - Auditing, Malware Scanner and Hardening\";s:4:\"slug\";s:25:\"sucuri-scanner/sucuri.php\";s:11:\"old_version\";s:6:\"1.8.21\";s:15:\"updated_version\";s:6:\"1.8.22\";}'),
('1924', '205048', 'iwp_log_type', 'scheduleBackup'),
('1925', '205048', 'iwp_log_action', 'schedule'),
('1926', '205048', 'iwp_log_activities_type', 'iwp_log'),
('1927', '205048', 'iwp_log_actions', 'backups'),
('1928', '205048', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1929', '205049', 'iwp_log_type', 'scheduleBackup'),
('1930', '205049', 'iwp_log_action', 'schedule'),
('1931', '205049', 'iwp_log_activities_type', 'iwp_log'),
('1932', '205049', 'iwp_log_actions', 'backups'),
('1933', '205049', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1934', '205050', 'iwp_log_type', 'core'),
('1935', '205050', 'iwp_log_action', 'update'),
('1936', '205050', 'iwp_log_activities_type', 'iwp_log'),
('1937', '205050', 'iwp_log_actions', 'core-updated'),
('1938', '205050', 'iwp_log_details', 'a:2:{s:11:\"old_version\";s:5:\"5.3.1\";s:15:\"updated_version\";s:5:\"5.3.2\";}'),
('1939', '205051', 'iwp_log_type', 'themes'),
('1940', '205051', 'iwp_log_action', 'update'),
('1941', '205051', 'iwp_log_activities_type', 'iwp_log'),
('1942', '205051', 'iwp_log_actions', 'themes-updated'),
('1943', '205051', 'iwp_log_details', 'a:4:{s:4:\"name\";s:4:\"Divi\";s:4:\"slug\";s:4:\"Divi\";s:11:\"old_version\";s:5:\"4.0.9\";s:15:\"updated_version\";s:6:\"4.0.11\";}'),
('1944', '205053', 'iwp_log_type', 'scheduleBackup'),
('1945', '205053', 'iwp_log_action', 'schedule'),
('1946', '205053', 'iwp_log_activities_type', 'iwp_log'),
('1947', '205053', 'iwp_log_actions', 'backups'),
('1948', '205053', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1949', '205054', 'iwp_log_type', 'scheduleBackup'),
('1950', '205054', 'iwp_log_action', 'schedule'),
('1951', '205054', 'iwp_log_activities_type', 'iwp_log'),
('1952', '205054', 'iwp_log_actions', 'backups'),
('1953', '205054', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1954', '205055', 'iwp_log_type', 'scheduleBackup'),
('1955', '205055', 'iwp_log_action', 'schedule'),
('1956', '205055', 'iwp_log_activities_type', 'iwp_log'),
('1957', '205055', 'iwp_log_actions', 'backups'),
('1958', '205055', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1959', '205056', 'iwp_log_type', 'themes'),
('1960', '205056', 'iwp_log_action', 'update'),
('1961', '205056', 'iwp_log_activities_type', 'iwp_log'),
('1962', '205056', 'iwp_log_actions', 'themes-updated'),
('1963', '205056', 'iwp_log_details', 'a:4:{s:4:\"name\";s:4:\"Divi\";s:4:\"slug\";s:4:\"Divi\";s:11:\"old_version\";s:6:\"4.0.11\";s:15:\"updated_version\";s:5:\"4.2.1\";}'),
('1964', '205057', 'iwp_log_type', 'plugins'),
('1965', '205057', 'iwp_log_action', 'update'),
('1966', '205057', 'iwp_log_activities_type', 'iwp_log'),
('1967', '205057', 'iwp_log_actions', 'plugins-updated'),
('1968', '205057', 'iwp_log_details', 'a:4:{s:4:\"name\";s:32:\"Head, Footer and Post Injections\";s:4:\"slug\";s:13:\"header-footer\";s:11:\"old_version\";s:5:\"3.1.3\";s:15:\"updated_version\";s:5:\"3.1.5\";}'),
('1969', '205058', 'iwp_log_type', 'plugins'),
('1970', '205058', 'iwp_log_action', 'update'),
('1971', '205058', 'iwp_log_activities_type', 'iwp_log'),
('1972', '205058', 'iwp_log_actions', 'plugins-updated'),
('1973', '205058', 'iwp_log_details', 'a:4:{s:4:\"name\";s:19:\"Custom Post Type UI\";s:4:\"slug\";s:19:\"custom-post-type-ui\";s:11:\"old_version\";s:5:\"1.7.1\";s:15:\"updated_version\";s:5:\"1.7.2\";}'),
('1974', '205060', 'iwp_log_type', 'scheduleBackup'),
('1975', '205060', 'iwp_log_action', 'schedule'),
('1976', '205060', 'iwp_log_activities_type', 'iwp_log'),
('1977', '205060', 'iwp_log_actions', 'backups'),
('1978', '205060', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1979', '205061', 'iwp_log_type', 'scheduleBackup'),
('1980', '205061', 'iwp_log_action', 'schedule'),
('1981', '205061', 'iwp_log_activities_type', 'iwp_log'),
('1982', '205061', 'iwp_log_actions', 'backups'),
('1983', '205061', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1984', '205062', 'iwp_log_type', 'themes'),
('1985', '205062', 'iwp_log_action', 'update'),
('1986', '205062', 'iwp_log_activities_type', 'iwp_log'),
('1987', '205062', 'iwp_log_actions', 'themes-updated'),
('1988', '205062', 'iwp_log_details', 'a:4:{s:4:\"name\";s:4:\"Divi\";s:4:\"slug\";s:4:\"Divi\";s:11:\"old_version\";s:5:\"4.2.1\";s:15:\"updated_version\";s:5:\"4.2.2\";}'),
('1989', '205064', 'iwp_log_type', 'plugins'),
('1990', '205064', 'iwp_log_action', 'update'),
('1991', '205064', 'iwp_log_activities_type', 'direct'),
('1992', '205064', 'iwp_log_actions', 'plugins-updated'),
('1993', '205064', 'iwp_log_details', 'a:4:{s:4:\"name\";s:32:\"Head, Footer and Post Injections\";s:4:\"slug\";s:24:\"header-footer/plugin.php\";s:11:\"old_version\";s:5:\"3.1.5\";s:15:\"updated_version\";s:5:\"3.1.6\";}'),
('1994', '205065', 'iwp_log_type', 'scheduleBackup'),
('1995', '205065', 'iwp_log_action', 'schedule'),
('1996', '205065', 'iwp_log_activities_type', 'iwp_log'),
('1997', '205065', 'iwp_log_actions', 'backups'),
('1998', '205065', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('1999', '205066', 'iwp_log_type', 'scheduleBackup'),
('2000', '205066', 'iwp_log_action', 'schedule'),
('2001', '205066', 'iwp_log_activities_type', 'iwp_log'),
('2002', '205066', 'iwp_log_actions', 'backups'),
('2003', '205066', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('2004', '205067', 'iwp_log_type', 'plugins'),
('2005', '205067', 'iwp_log_action', 'update'),
('2006', '205067', 'iwp_log_activities_type', 'iwp_log'),
('2007', '205067', 'iwp_log_actions', 'plugins-updated'),
('2008', '205067', 'iwp_log_details', 'a:4:{s:4:\"name\";s:19:\"Custom Post Type UI\";s:4:\"slug\";s:19:\"custom-post-type-ui\";s:11:\"old_version\";s:5:\"1.7.2\";s:15:\"updated_version\";s:5:\"1.7.3\";}'),
('2009', '205068', 'iwp_log_type', 'plugins'),
('2010', '205068', 'iwp_log_action', 'update'),
('2011', '205068', 'iwp_log_activities_type', 'iwp_log'),
('2012', '205068', 'iwp_log_actions', 'plugins-updated'),
('2013', '205068', 'iwp_log_details', 'a:4:{s:4:\"name\";s:57:\"Sucuri Security - Auditing, Malware Scanner and Hardening\";s:4:\"slug\";s:14:\"sucuri-scanner\";s:11:\"old_version\";s:6:\"1.8.22\";s:15:\"updated_version\";s:6:\"1.8.23\";}'),
('2014', '205069', 'iwp_log_type', 'themes'),
('2015', '205069', 'iwp_log_action', 'update'),
('2016', '205069', 'iwp_log_activities_type', 'iwp_log'),
('2017', '205069', 'iwp_log_actions', 'themes-updated'),
('2018', '205069', 'iwp_log_details', 'a:4:{s:4:\"name\";s:4:\"Divi\";s:4:\"slug\";s:4:\"Divi\";s:11:\"old_version\";s:5:\"4.2.2\";s:15:\"updated_version\";s:5:\"4.3.2\";}'),
('2019', '205070', 'iwp_log_type', 'scheduleBackup'),
('2020', '205070', 'iwp_log_action', 'schedule'),
('2021', '205070', 'iwp_log_activities_type', 'iwp_log'),
('2022', '205070', 'iwp_log_actions', 'backups'),
('2023', '205070', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('2024', '205072', 'iwp_log_type', 'plugins'),
('2025', '205072', 'iwp_log_action', 'update'),
('2026', '205072', 'iwp_log_activities_type', 'iwp_log'),
('2027', '205072', 'iwp_log_actions', 'plugins-updated'),
('2028', '205072', 'iwp_log_details', 'a:4:{s:4:\"name\";s:57:\"Sucuri Security - Auditing, Malware Scanner and Hardening\";s:4:\"slug\";s:14:\"sucuri-scanner\";s:11:\"old_version\";s:6:\"1.8.23\";s:15:\"updated_version\";s:6:\"1.8.24\";}'),
('2029', '205073', 'iwp_log_type', 'themes'),
('2030', '205073', 'iwp_log_action', 'update'),
('2031', '205073', 'iwp_log_activities_type', 'iwp_log'),
('2032', '205073', 'iwp_log_actions', 'themes-updated'),
('2033', '205073', 'iwp_log_details', 'a:4:{s:4:\"name\";s:4:\"Divi\";s:4:\"slug\";s:4:\"Divi\";s:11:\"old_version\";s:5:\"4.3.2\";s:15:\"updated_version\";s:5:\"4.3.4\";}'),
('2034', '205074', '_edit_last', '2'),
('2035', '205074', '_wp_page_template', 'default'),
('2036', '205074', '_et_pb_post_hide_nav', 'default'),
('2037', '205074', '_et_pb_page_layout', 'et_full_width_page'),
('2038', '205074', '_et_pb_side_nav', 'off'),
('2039', '205074', '_et_pb_use_builder', 'on'),
('2040', '205074', '_et_builder_version', 'VB|Divi|4.5.3'),
('2042', '205074', '_et_pb_old_content', ''),
('2043', '205074', '_et_pb_enable_shortcode_tracking', ''),
('2044', '205074', '_et_pb_custom_css', ''),
('2045', '205074', '_edit_lock', '1620617816:2'),
('2047', '205074', '_et_pb_ab_refresh_interval', 'hourly'),
('2048', '205074', '_et_pb_ab_current_shortcode', '[et_pb_split_track id=\"205074\" /]'),
('2049', '205074', '_et_pb_built_for_post_type', 'page'),
('2050', '205074', '_et_pb_ab_subjects', ''),
('2051', '205074', '_et_pb_gutter_width', '3'),
('2053', '205074', '_et_pb_first_image', ''),
('2054', '205074', '_et_pb_truncate_post', ''),
('2055', '205074', '_et_pb_truncate_post_date', ''),
('2056', '205074', '_et_pb_show_page_creation', 'off'),
('2069', '205083', '_menu_item_type', 'custom'),
('2070', '205083', '_menu_item_menu_item_parent', '0'),
('2071', '205083', '_menu_item_object_id', '205083'),
('2072', '205083', '_menu_item_object', 'custom'),
('2073', '205083', '_menu_item_target', ''),
('2074', '205083', '_menu_item_classes', 'a:1:{i:0;s:0:\"\";}'),
('2075', '205083', '_menu_item_xfn', ''),
('2076', '205083', '_menu_item_url', '#'),
('2078', '205084', '_menu_item_type', 'post_type'),
('2079', '205084', '_menu_item_menu_item_parent', '0'),
('2080', '205084', '_menu_item_object_id', '205074'),
('2081', '205084', '_menu_item_object', 'page'),
('2082', '205084', '_menu_item_target', ''),
('2083', '205084', '_menu_item_classes', 'a:1:{i:0;s:0:\"\";}'),
('2084', '205084', '_menu_item_xfn', ''),
('2085', '205084', '_menu_item_url', ''),
('2087', '205085', 'iwp_log_type', 'scheduleBackup'),
('2088', '205085', 'iwp_log_action', 'schedule'),
('2089', '205085', 'iwp_log_activities_type', 'iwp_log'),
('2090', '205085', 'iwp_log_actions', 'backups'),
('2091', '205085', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('2092', '205086', 'iwp_log_type', 'plugins'),
('2093', '205086', 'iwp_log_action', 'update'),
('2094', '205086', 'iwp_log_activities_type', 'iwp_log'),
('2095', '205086', 'iwp_log_actions', 'plugins-updated'),
('2096', '205086', 'iwp_log_details', 'a:4:{s:4:\"name\";s:17:\"WP Migrate DB Pro\";s:4:\"slug\";s:17:\"wp-migrate-db-pro\";s:11:\"old_version\";s:5:\"1.9.8\";s:15:\"updated_version\";s:5:\"1.9.9\";}'),
('2098', '205091', 'iwp_log_type', 'scheduleBackup'),
('2099', '205091', 'iwp_log_action', 'schedule'),
('2100', '205091', 'iwp_log_activities_type', 'iwp_log'),
('2101', '205091', 'iwp_log_actions', 'backups'),
('2102', '205091', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('2103', '205092', 'iwp_log_type', 'themes'),
('2104', '205092', 'iwp_log_action', 'update'),
('2105', '205092', 'iwp_log_activities_type', 'iwp_log'),
('2106', '205092', 'iwp_log_actions', 'themes-updated'),
('2107', '205092', 'iwp_log_details', 'a:4:{s:4:\"name\";s:4:\"Divi\";s:4:\"slug\";s:4:\"Divi\";s:11:\"old_version\";s:5:\"4.3.4\";s:15:\"updated_version\";s:3:\"4.4\";}'),
('2108', '205093', 'iwp_log_type', 'plugins'),
('2109', '205093', 'iwp_log_action', 'update'),
('2110', '205093', 'iwp_log_activities_type', 'iwp_log'),
('2111', '205093', 'iwp_log_actions', 'plugins-updated'),
('2112', '205093', 'iwp_log_details', 'a:4:{s:4:\"name\";s:14:\"Contact Form 7\";s:4:\"slug\";s:14:\"contact-form-7\";s:11:\"old_version\";s:5:\"5.1.6\";s:15:\"updated_version\";s:5:\"5.1.7\";}'),
('2113', '205094', 'iwp_log_type', 'plugins'),
('2114', '205094', 'iwp_log_action', 'update'),
('2115', '205094', 'iwp_log_activities_type', 'iwp_log'),
('2116', '205094', 'iwp_log_actions', 'plugins-updated'),
('2117', '205094', 'iwp_log_details', 'a:4:{s:4:\"name\";s:26:\"Advanced Custom Fields PRO\";s:4:\"slug\";s:26:\"advanced-custom-fields-pro\";s:11:\"old_version\";s:5:\"5.8.7\";s:15:\"updated_version\";s:5:\"5.8.8\";}'),
('2118', '205095', 'iwp_log_type', 'scheduleBackup'),
('2119', '205095', 'iwp_log_action', 'schedule'),
('2120', '205095', 'iwp_log_activities_type', 'iwp_log'),
('2121', '205095', 'iwp_log_actions', 'backups'),
('2122', '205095', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('2123', '205096', 'iwp_log_type', 'plugins'),
('2124', '205096', 'iwp_log_action', 'update'),
('2125', '205096', 'iwp_log_activities_type', 'iwp_log'),
('2126', '205096', 'iwp_log_actions', 'plugins-updated'),
('2127', '205096', 'iwp_log_details', 'a:4:{s:4:\"name\";s:23:\"Official Facebook Pixel\";s:4:\"slug\";s:23:\"official-facebook-pixel\";s:11:\"old_version\";s:5:\"1.8.0\";s:15:\"updated_version\";s:5:\"2.0.0\";}'),
('2128', '205097', 'iwp_log_type', 'plugins'),
('2129', '205097', 'iwp_log_action', 'update'),
('2130', '205097', 'iwp_log_activities_type', 'iwp_log'),
('2131', '205097', 'iwp_log_actions', 'plugins-updated'),
('2132', '205097', 'iwp_log_details', 'a:4:{s:4:\"name\";s:17:\"WP Migrate DB Pro\";s:4:\"slug\";s:17:\"wp-migrate-db-pro\";s:11:\"old_version\";s:5:\"1.9.9\";s:15:\"updated_version\";s:6:\"1.9.10\";}'),
('2133', '205098', 'iwp_log_type', 'themes'),
('2134', '205098', 'iwp_log_action', 'update'),
('2135', '205098', 'iwp_log_activities_type', 'iwp_log'),
('2136', '205098', 'iwp_log_actions', 'themes-updated'),
('2137', '205098', 'iwp_log_details', 'a:4:{s:4:\"name\";s:4:\"Divi\";s:4:\"slug\";s:4:\"Divi\";s:11:\"old_version\";s:5:\"4.4.0\";s:15:\"updated_version\";s:5:\"4.4.1\";}'),
('2138', '204649', '_oembed_4b30174d6f7832c91c894b873b036ff9', '<blockquote class=\"wp-embedded-content\" data-secret=\"J13YZsaovQ\"><a href=\"https://www.gladesvillevet.com.au/dog-behaviour-training/\">Dog Behaviour Training</a></blockquote><iframe title=\"&#8220;Dog Behaviour Training&#8221; &#8212; Gladesville Veterinary Hospital\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" style=\"position: absolute; clip: rect(1px, 1px, 1px, 1px);\" src=\"https://www.gladesvillevet.com.au/dog-behaviour-training/embed/#?secret=J13YZsaovQ\" data-secret=\"J13YZsaovQ\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>'),
('2139', '204649', '_oembed_time_4b30174d6f7832c91c894b873b036ff9', '1584837579'),
('2140', '204649', '_oembed_4cfbb187aa302169d1fd37043b389569', '{{unknown}}'),
('2141', '204649', '_et_pb_truncate_post', '<p><div class=\"et_pb_section et_pb_section_0 et_pb_with_background et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_row et_pb_row_0\">\n				<div class=\"et_pb_column et_pb_column_4_4 et_pb_column_0  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_0  et_pb_text_align_left et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_text_inner\">Group Classes<br />\nLearn to train your adolescent dog so they can become the welcome family member of your dreams!<br />\nFor dogs 5 months of age and older.</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_section et_pb_section_1 et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_row et_pb_row_1\">\n				<div class=\"et_pb_column et_pb_column_1_2 et_pb_column_1  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_1  et_pb_text_align_left et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_text_inner\"><p>Gladesville Veterinary Hospital<br />\nCANINE COLLEGE<br />\nfor bookings go to:</p>\n<blockquote class=\"wp-embedded-content\" data-secret=\"J13YZsaovQ\"><p><a href=\"https://www.gladesvillevet.com.au/dog-behaviour-training/\">Dog Behaviour Training</a></p></blockquote>\n<p><iframe title=\"&#8220;Dog Behaviour Training&#8221; &#8212; Gladesville Veterinary Hospital\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" style=\"position: absolute; clip: rect(1px, 1px, 1px, 1px);\" src=\"https://www.gladesvillevet.com.au/dog-behaviour-training/embed/#?secret=J13YZsaovQ\" data-secret=\"J13YZsaovQ\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe><br />\nPh: 02 9817 5758</p></div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_2 et_pb_column_2  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_2  et_pb_text_align_left et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_text_inner\"><p>University Veterinary Teaching Hospital Sydney<br />\nPUPPY HIGH SCHOOL<br />\nfor bookings go to:<br />\nhttp://www.uvths.com.au/juvenile-programs<br />\nPh: 02 9351 3437</p></div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --></p>\n'),
('2142', '204649', '_et_pb_truncate_post_date', '2020-03-22 00:39:44'),
('2143', '204557', '_et_pb_truncate_post', ''),
('2144', '204557', '_et_pb_truncate_post_date', ''),
('2145', '205100', 'iwp_log_type', 'scheduleBackup'),
('2146', '205100', 'iwp_log_action', 'schedule'),
('2147', '205100', 'iwp_log_activities_type', 'iwp_log'),
('2148', '205100', 'iwp_log_actions', 'backups'),
('2149', '205100', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('2150', '205101', 'iwp_log_type', 'plugins'),
('2151', '205101', 'iwp_log_action', 'update'),
('2152', '205101', 'iwp_log_activities_type', 'iwp_log'),
('2153', '205101', 'iwp_log_actions', 'plugins-updated'),
('2154', '205101', 'iwp_log_details', 'a:4:{s:4:\"name\";s:19:\"Custom Post Type UI\";s:4:\"slug\";s:19:\"custom-post-type-ui\";s:11:\"old_version\";s:5:\"1.7.3\";s:15:\"updated_version\";s:5:\"1.7.4\";}'),
('2160', '205105', '_edit_lock', '1585181896:2'),
('2161', '205105', '_oembed_0e4b3ee7cdd072f2c66815c0fc7c1cd4', '<blockquote class=\"wp-embedded-content\" data-secret=\"705sElZ2JK\"><a href=\"https://jhdogtraining.com.au/contact/\">Contact</a></blockquote><iframe title=\"&#8220;Contact&#8221; &#8212; Jenny Harlow\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" style=\"position: absolute; clip: rect(1px, 1px, 1px, 1px);\" src=\"https://jhdogtraining.com.au/contact/embed/#?secret=705sElZ2JK\" data-secret=\"705sElZ2JK\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>'),
('2162', '205105', '_oembed_time_0e4b3ee7cdd072f2c66815c0fc7c1cd4', '1585181163'),
('2163', '205105', '_edit_last', '2'),
('2164', '205106', '_wp_attached_file', '2020/03/macy-puppy-scaled.jpg'),
('2165', '205106', '_wp_attachment_metadata', 'a:6:{s:5:\"width\";i:1920;s:6:\"height\";i:2560;s:4:\"file\";s:29:\"2020/03/macy-puppy-scaled.jpg\";s:5:\"sizes\";a:16:{s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"macy-puppy-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"macy-puppy-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"macy-puppy-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"macy-puppy-768x1024.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:24:\"macy-puppy-1152x1536.jpg\";s:5:\"width\";i:1152;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"2048x2048\";a:4:{s:4:\"file\";s:24:\"macy-puppy-1536x2048.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:2048;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:22:\"macy-puppy-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:23:\"macy-puppy-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:22:\"macy-puppy-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:22:\"macy-puppy-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:24:\"macy-puppy-1080x1440.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:1440;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:22:\"macy-puppy-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:37:\"et-pb-post-main-image-fullwidth-large\";a:4:{s:4:\"file\";s:24:\"macy-puppy-2448x1800.jpg\";s:5:\"width\";i:2448;s:6:\"height\";i:1800;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"et-pb-image--responsive--desktop\";a:4:{s:4:\"file\";s:24:\"macy-puppy-1280x1707.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:1707;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-image--responsive--tablet\";a:4:{s:4:\"file\";s:23:\"macy-puppy-980x1307.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:1307;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:22:\"macy-puppy-480x640.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:640;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"2.4\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:8:\"iPhone 5\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1471094078\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:4:\"4.12\";s:3:\"iso\";s:2:\"50\";s:13:\"shutter_speed\";s:16:\"0.00467289719626\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:14:\"macy-puppy.jpg\";}'),
('2166', '205107', '_wp_attached_file', '2020/03/puppy-siberian-toilet-scaled.jpg'),
('2167', '205107', '_wp_attachment_metadata', 'a:6:{s:5:\"width\";i:2560;s:6:\"height\";i:1696;s:4:\"file\";s:40:\"2020/03/puppy-siberian-toilet-scaled.jpg\";s:5:\"sizes\";a:16:{s:6:\"medium\";a:4:{s:4:\"file\";s:33:\"puppy-siberian-toilet-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:34:\"puppy-siberian-toilet-1024x678.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:678;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"puppy-siberian-toilet-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:33:\"puppy-siberian-toilet-768x509.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:509;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:35:\"puppy-siberian-toilet-1536x1017.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1017;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"2048x2048\";a:4:{s:4:\"file\";s:35:\"puppy-siberian-toilet-2048x1356.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1356;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:33:\"puppy-siberian-toilet-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:34:\"puppy-siberian-toilet-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:33:\"puppy-siberian-toilet-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:33:\"puppy-siberian-toilet-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:34:\"puppy-siberian-toilet-1080x715.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:715;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:33:\"puppy-siberian-toilet-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:37:\"et-pb-post-main-image-fullwidth-large\";a:4:{s:4:\"file\";s:35:\"puppy-siberian-toilet-2880x1800.jpg\";s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"et-pb-image--responsive--desktop\";a:4:{s:4:\"file\";s:34:\"puppy-siberian-toilet-1280x848.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:848;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-image--responsive--tablet\";a:4:{s:4:\"file\";s:33:\"puppy-siberian-toilet-980x649.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:649;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:33:\"puppy-siberian-toilet-480x318.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:318;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:25:\"puppy-siberian-toilet.jpg\";}'),
('2168', '205105', '_wp_page_template', 'default'),
('2169', '205105', '_et_pb_post_hide_nav', 'default'),
('2170', '205105', '_et_pb_page_layout', 'et_right_sidebar'),
('2171', '205105', '_et_pb_side_nav', 'off'),
('2172', '205105', '_et_pb_use_builder', ''),
('2173', '205105', '_et_pb_first_image', ''),
('2174', '205105', '_et_pb_truncate_post', ''),
('2175', '205105', '_et_pb_truncate_post_date', ''),
('2176', '205105', '_et_pb_old_content', ''),
('2177', '205108', '_edit_lock', '1585182158:2'),
('2178', '205108', '_oembed_0e4b3ee7cdd072f2c66815c0fc7c1cd4', '<blockquote class=\"wp-embedded-content\" data-secret=\"705sElZ2JK\"><a href=\"https://jhdogtraining.com.au/contact/\">Contact</a></blockquote><iframe title=\"&#8220;Contact&#8221; &#8212; Jenny Harlow\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" style=\"position: absolute; clip: rect(1px, 1px, 1px, 1px);\" src=\"https://jhdogtraining.com.au/contact/embed/#?secret=705sElZ2JK\" data-secret=\"705sElZ2JK\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>'),
('2179', '205108', '_oembed_time_0e4b3ee7cdd072f2c66815c0fc7c1cd4', '1585181163'),
('2180', '205108', '_edit_last', '2'),
('2181', '205108', '_wp_page_template', 'default'),
('2182', '205108', '_et_pb_post_hide_nav', 'default'),
('2183', '205108', '_et_pb_page_layout', 'et_right_sidebar'),
('2184', '205108', '_et_pb_side_nav', 'off'),
('2185', '205108', '_et_pb_use_builder', ''),
('2186', '205108', '_et_pb_first_image', ''),
('2187', '205108', '_et_pb_truncate_post', ''),
('2188', '205108', '_et_pb_truncate_post_date', ''),
('2189', '205108', '_et_pb_old_content', ''),
('2195', '205110', '_edit_lock', '1585182360:2'),
('2196', '205110', '_edit_last', '2'),
('2197', '205110', '_wp_page_template', 'default'),
('2198', '205110', '_et_pb_post_hide_nav', 'default'),
('2199', '205110', '_et_pb_page_layout', 'et_right_sidebar'),
('2200', '205110', '_et_pb_side_nav', 'off'),
('2201', '205110', '_et_pb_use_builder', ''),
('2202', '205110', '_et_pb_first_image', ''),
('2203', '205110', '_et_pb_truncate_post', ''),
('2204', '205110', '_et_pb_truncate_post_date', ''),
('2205', '205110', '_et_pb_old_content', ''),
('2227', '205112', 'iwp_log_type', 'plugins'),
('2228', '205112', 'iwp_log_action', 'update'),
('2229', '205112', 'iwp_log_activities_type', 'iwp_log'),
('2230', '205112', 'iwp_log_actions', 'plugins-updated'),
('2231', '205112', 'iwp_log_details', 'a:4:{s:4:\"name\";s:26:\"Advanced Custom Fields PRO\";s:4:\"slug\";s:26:\"advanced-custom-fields-pro\";s:11:\"old_version\";s:5:\"5.8.8\";s:15:\"updated_version\";s:5:\"5.8.9\";}'),
('2232', '205113', 'iwp_log_type', 'plugins'),
('2233', '205113', 'iwp_log_action', 'update'),
('2234', '205113', 'iwp_log_activities_type', 'iwp_log'),
('2235', '205113', 'iwp_log_actions', 'plugins-updated'),
('2236', '205113', 'iwp_log_details', 'a:4:{s:4:\"name\";s:14:\"Duplicate Page\";s:4:\"slug\";s:14:\"duplicate-page\";s:11:\"old_version\";s:3:\"4.1\";s:15:\"updated_version\";s:3:\"4.2\";}'),
('2237', '205114', 'iwp_log_type', 'plugins'),
('2238', '205114', 'iwp_log_action', 'update'),
('2239', '205114', 'iwp_log_activities_type', 'iwp_log'),
('2240', '205114', 'iwp_log_actions', 'plugins-updated'),
('2241', '205114', 'iwp_log_details', 'a:4:{s:4:\"name\";s:23:\"Official Facebook Pixel\";s:4:\"slug\";s:23:\"official-facebook-pixel\";s:11:\"old_version\";s:5:\"2.0.0\";s:15:\"updated_version\";s:5:\"2.0.1\";}'),
('2242', '205115', 'iwp_log_type', 'scheduleBackup'),
('2243', '205115', 'iwp_log_action', 'schedule'),
('2244', '205115', 'iwp_log_activities_type', 'iwp_log'),
('2245', '205115', 'iwp_log_actions', 'backups'),
('2246', '205115', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('2247', '205116', '_edit_lock', '1585621732:2'),
('2248', '205116', '_edit_last', '2'),
('2249', '205117', '_wp_attached_file', '2020/03/puppies-in-car-scaled.jpg'),
('2250', '205117', '_wp_attachment_metadata', 'a:6:{s:5:\"width\";i:2560;s:6:\"height\";i:1853;s:4:\"file\";s:33:\"2020/03/puppies-in-car-scaled.jpg\";s:5:\"sizes\";a:16:{s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"puppies-in-car-300x217.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:217;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:27:\"puppies-in-car-1024x741.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:741;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"puppies-in-car-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:26:\"puppies-in-car-768x556.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:556;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:28:\"puppies-in-car-1536x1112.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1112;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"2048x2048\";a:4:{s:4:\"file\";s:28:\"puppies-in-car-2048x1483.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1483;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:26:\"puppies-in-car-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:27:\"puppies-in-car-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:26:\"puppies-in-car-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:26:\"puppies-in-car-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:27:\"puppies-in-car-1080x782.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:782;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:26:\"puppies-in-car-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:37:\"et-pb-post-main-image-fullwidth-large\";a:4:{s:4:\"file\";s:28:\"puppies-in-car-2880x1800.jpg\";s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"et-pb-image--responsive--desktop\";a:4:{s:4:\"file\";s:27:\"puppies-in-car-1280x927.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:927;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-image--responsive--tablet\";a:4:{s:4:\"file\";s:26:\"puppies-in-car-980x709.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:709;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:26:\"puppies-in-car-480x347.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:347;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:18:\"puppies-in-car.jpg\";}'),
('2251', '205118', '_wp_attached_file', '2020/03/puppy-nose-scaled.jpg'),
('2252', '205118', '_wp_attachment_metadata', 'a:6:{s:5:\"width\";i:2560;s:6:\"height\";i:1707;s:4:\"file\";s:29:\"2020/03/puppy-nose-scaled.jpg\";s:5:\"sizes\";a:16:{s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"puppy-nose-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"puppy-nose-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"puppy-nose-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"puppy-nose-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:24:\"puppy-nose-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"2048x2048\";a:4:{s:4:\"file\";s:24:\"puppy-nose-2048x1365.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1365;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:22:\"puppy-nose-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:23:\"puppy-nose-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:22:\"puppy-nose-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:22:\"puppy-nose-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:23:\"puppy-nose-1080x720.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:22:\"puppy-nose-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:37:\"et-pb-post-main-image-fullwidth-large\";a:4:{s:4:\"file\";s:24:\"puppy-nose-2880x1800.jpg\";s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"et-pb-image--responsive--desktop\";a:4:{s:4:\"file\";s:23:\"puppy-nose-1280x854.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:854;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-image--responsive--tablet\";a:4:{s:4:\"file\";s:22:\"puppy-nose-980x653.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:653;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:22:\"puppy-nose-480x320.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:14:\"puppy-nose.jpg\";}'),
('2253', '205119', '_wp_attached_file', '2020/03/puppy-on-tarp-scaled.jpg'),
('2254', '205119', '_wp_attachment_metadata', 'a:6:{s:5:\"width\";i:2560;s:6:\"height\";i:1707;s:4:\"file\";s:32:\"2020/03/puppy-on-tarp-scaled.jpg\";s:5:\"sizes\";a:16:{s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"puppy-on-tarp-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:26:\"puppy-on-tarp-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"puppy-on-tarp-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"puppy-on-tarp-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:27:\"puppy-on-tarp-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"2048x2048\";a:4:{s:4:\"file\";s:27:\"puppy-on-tarp-2048x1365.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1365;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:25:\"puppy-on-tarp-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:26:\"puppy-on-tarp-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:25:\"puppy-on-tarp-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:25:\"puppy-on-tarp-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:26:\"puppy-on-tarp-1080x720.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:25:\"puppy-on-tarp-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:37:\"et-pb-post-main-image-fullwidth-large\";a:4:{s:4:\"file\";s:27:\"puppy-on-tarp-2880x1800.jpg\";s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"et-pb-image--responsive--desktop\";a:4:{s:4:\"file\";s:26:\"puppy-on-tarp-1280x854.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:854;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-image--responsive--tablet\";a:4:{s:4:\"file\";s:25:\"puppy-on-tarp-980x653.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:653;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:25:\"puppy-on-tarp-480x320.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:17:\"puppy-on-tarp.jpg\";}'),
('2255', '205116', '_wp_page_template', 'default'),
('2256', '205116', '_et_pb_post_hide_nav', 'default'),
('2257', '205116', '_et_pb_page_layout', 'et_right_sidebar'),
('2258', '205116', '_et_pb_side_nav', 'off'),
('2259', '205116', '_et_pb_use_builder', ''),
('2260', '205116', '_et_pb_first_image', ''),
('2261', '205116', '_et_pb_truncate_post', ''),
('2262', '205116', '_et_pb_truncate_post_date', ''),
('2263', '205116', '_et_pb_old_content', ''),
('2266', '205121', '_edit_lock', '1585625266:2'),
('2267', '205121', '_edit_last', '2'),
('2268', '205121', '_et_post_bg_color', '#ffffff'),
('2269', '205121', '_et_post_bg_layout', 'light'),
('2270', '205121', '_et_pb_show_title', 'on'),
('2271', '205121', '_et_pb_post_hide_nav', 'default'),
('2272', '205121', '_et_pb_page_layout', 'et_right_sidebar'),
('2273', '205121', '_et_pb_side_nav', 'off'),
('2274', '205121', '_et_pb_use_builder', ''),
('2275', '205121', '_et_pb_first_image', ''),
('2276', '205121', '_et_pb_truncate_post', ''),
('2277', '205121', '_et_pb_truncate_post_date', ''),
('2278', '205121', '_et_pb_old_content', ''),
('2287', '205124', '_edit_lock', '1585869889:2'),
('2288', '205124', '_edit_last', '2'),
('2289', '205124', '_et_post_bg_color', '#ffffff'),
('2290', '205124', '_et_post_bg_layout', 'light'),
('2291', '205124', '_et_pb_show_title', 'on'),
('2292', '205124', '_et_pb_post_hide_nav', 'default'),
('2293', '205124', '_et_pb_page_layout', 'et_right_sidebar'),
('2294', '205124', '_et_pb_side_nav', 'off'),
('2295', '205124', '_et_pb_use_builder', ''),
('2296', '205124', '_et_pb_first_image', ''),
('2297', '205124', '_et_pb_truncate_post', ''),
('2298', '205124', '_et_pb_truncate_post_date', ''),
('2299', '205124', '_et_pb_old_content', ''),
('2302', '205125', 'iwp_log_type', 'themes'),
('2303', '205125', 'iwp_log_action', 'update'),
('2304', '205125', 'iwp_log_activities_type', 'iwp_log'),
('2305', '205125', 'iwp_log_actions', 'themes-updated'),
('2306', '205125', 'iwp_log_details', 'a:4:{s:4:\"name\";s:4:\"Divi\";s:4:\"slug\";s:4:\"Divi\";s:11:\"old_version\";s:5:\"4.4.1\";s:15:\"updated_version\";s:5:\"4.4.2\";}'),
('2307', '205126', 'iwp_log_type', 'themes'),
('2308', '205126', 'iwp_log_action', 'update'),
('2309', '205126', 'iwp_log_activities_type', 'iwp_log'),
('2310', '205126', 'iwp_log_actions', 'themes-updated'),
('2311', '205126', 'iwp_log_details', 'a:4:{s:4:\"name\";s:15:\"Twenty Nineteen\";s:4:\"slug\";s:15:\"Twenty Nineteen\";s:11:\"old_version\";s:3:\"1.4\";s:15:\"updated_version\";s:3:\"1.5\";}'),
('2312', '205127', 'iwp_log_type', 'themes'),
('2313', '205127', 'iwp_log_action', 'update'),
('2314', '205127', 'iwp_log_activities_type', 'iwp_log'),
('2315', '205127', 'iwp_log_actions', 'themes-updated'),
('2316', '205127', 'iwp_log_details', 'a:4:{s:4:\"name\";s:16:\"Twenty Seventeen\";s:4:\"slug\";s:16:\"Twenty Seventeen\";s:11:\"old_version\";s:3:\"2.2\";s:15:\"updated_version\";s:3:\"2.3\";}'),
('2317', '205128', 'iwp_log_type', 'themes'),
('2318', '205128', 'iwp_log_action', 'update'),
('2319', '205128', 'iwp_log_activities_type', 'iwp_log'),
('2320', '205128', 'iwp_log_actions', 'themes-updated'),
('2321', '205128', 'iwp_log_details', 'a:4:{s:4:\"name\";s:16:\"Twenty Seventeen\";s:4:\"slug\";s:16:\"Twenty Seventeen\";s:11:\"old_version\";s:3:\"2.2\";s:15:\"updated_version\";s:3:\"2.3\";}'),
('2322', '205129', 'iwp_log_type', 'themes'),
('2323', '205129', 'iwp_log_action', 'update'),
('2324', '205129', 'iwp_log_activities_type', 'iwp_log'),
('2325', '205129', 'iwp_log_actions', 'themes-updated'),
('2326', '205129', 'iwp_log_details', 'a:4:{s:4:\"name\";s:13:\"Twenty Twenty\";s:4:\"slug\";s:13:\"Twenty Twenty\";s:11:\"old_version\";s:3:\"1.1\";s:15:\"updated_version\";s:3:\"1.2\";}'),
('2327', '205130', 'iwp_log_type', 'core'),
('2328', '205130', 'iwp_log_action', 'update'),
('2329', '205130', 'iwp_log_activities_type', 'iwp_log'),
('2330', '205130', 'iwp_log_actions', 'core-updated'),
('2331', '205130', 'iwp_log_details', 'a:2:{s:11:\"old_version\";s:5:\"5.3.2\";s:15:\"updated_version\";s:3:\"5.4\";}'),
('2332', '205131', 'iwp_log_type', 'scheduleBackup'),
('2333', '205131', 'iwp_log_action', 'schedule'),
('2334', '205131', 'iwp_log_activities_type', 'iwp_log'),
('2335', '205131', 'iwp_log_actions', 'backups'),
('2336', '205131', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('2337', '205132', 'iwp_log_type', 'scheduleBackup'),
('2338', '205132', 'iwp_log_action', 'schedule'),
('2339', '205132', 'iwp_log_activities_type', 'iwp_log'),
('2340', '205132', 'iwp_log_actions', 'backups'),
('2341', '205132', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('2342', '205133', 'iwp_log_type', 'plugins'),
('2343', '205133', 'iwp_log_action', 'update'),
('2344', '205133', 'iwp_log_activities_type', 'iwp_log'),
('2345', '205133', 'iwp_log_actions', 'plugins-updated'),
('2346', '205133', 'iwp_log_details', 'a:4:{s:4:\"name\";s:16:\"iThemes Security\";s:4:\"slug\";s:18:\"better-wp-security\";s:11:\"old_version\";s:5:\"7.6.1\";s:15:\"updated_version\";s:5:\"7.7.0\";}'),
('2347', '205134', 'iwp_log_type', 'plugins'),
('2348', '205134', 'iwp_log_action', 'update'),
('2349', '205134', 'iwp_log_activities_type', 'iwp_log'),
('2350', '205134', 'iwp_log_actions', 'plugins-updated'),
('2351', '205134', 'iwp_log_details', 'a:4:{s:4:\"name\";s:16:\"Post Types Order\";s:4:\"slug\";s:16:\"post-types-order\";s:11:\"old_version\";s:7:\"1.9.4.2\";s:15:\"updated_version\";s:7:\"1.9.4.3\";}'),
('2352', '205135', 'iwp_log_type', 'themes'),
('2353', '205135', 'iwp_log_action', 'update'),
('2354', '205135', 'iwp_log_activities_type', 'iwp_log'),
('2355', '205135', 'iwp_log_actions', 'themes-updated'),
('2356', '205135', 'iwp_log_details', 'a:4:{s:4:\"name\";s:4:\"Divi\";s:4:\"slug\";s:4:\"Divi\";s:11:\"old_version\";s:5:\"4.4.2\";s:15:\"updated_version\";s:5:\"4.4.3\";}'),
('2357', '205136', 'iwp_log_type', 'scheduleBackup'),
('2358', '205136', 'iwp_log_action', 'schedule'),
('2359', '205136', 'iwp_log_activities_type', 'iwp_log'),
('2360', '205136', 'iwp_log_actions', 'backups'),
('2361', '205136', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('2362', '205137', 'iwp_log_type', 'plugins'),
('2363', '205137', 'iwp_log_action', 'update'),
('2364', '205137', 'iwp_log_activities_type', 'iwp_log'),
('2365', '205137', 'iwp_log_actions', 'plugins-updated'),
('2366', '205137', 'iwp_log_details', 'a:4:{s:4:\"name\";s:16:\"iThemes Security\";s:4:\"slug\";s:18:\"better-wp-security\";s:11:\"old_version\";s:5:\"7.7.0\";s:15:\"updated_version\";s:5:\"7.7.1\";}'),
('2367', '205138', 'iwp_log_type', 'plugins'),
('2368', '205138', 'iwp_log_action', 'update'),
('2369', '205138', 'iwp_log_activities_type', 'iwp_log'),
('2370', '205138', 'iwp_log_actions', 'plugins-updated'),
('2371', '205138', 'iwp_log_details', 'a:4:{s:4:\"name\";s:16:\"iThemes Security\";s:4:\"slug\";s:18:\"better-wp-security\";s:11:\"old_version\";s:5:\"7.7.0\";s:15:\"updated_version\";s:5:\"7.7.1\";}'),
('2372', '205139', 'iwp_log_type', 'plugins'),
('2373', '205139', 'iwp_log_action', 'update'),
('2374', '205139', 'iwp_log_activities_type', 'iwp_log'),
('2375', '205139', 'iwp_log_actions', 'plugins-updated'),
('2376', '205139', 'iwp_log_details', 'a:4:{s:4:\"name\";s:23:\"Official Facebook Pixel\";s:4:\"slug\";s:23:\"official-facebook-pixel\";s:11:\"old_version\";s:5:\"2.0.1\";s:15:\"updated_version\";s:5:\"2.0.2\";}'),
('2377', '205140', 'iwp_log_type', 'themes'),
('2378', '205140', 'iwp_log_action', 'update'),
('2379', '205140', 'iwp_log_activities_type', 'iwp_log'),
('2380', '205140', 'iwp_log_actions', 'themes-updated'),
('2381', '205140', 'iwp_log_details', 'a:4:{s:4:\"name\";s:4:\"Divi\";s:4:\"slug\";s:4:\"Divi\";s:11:\"old_version\";s:5:\"4.4.3\";s:15:\"updated_version\";s:5:\"4.4.4\";}'),
('2382', '205142', '_edit_lock', '1587973620:2'),
('2383', '205142', '_edit_last', '2'),
('2384', '205143', '_wp_attached_file', '2020/04/puppy-sleeping-scaled.jpg'),
('2385', '205143', '_wp_attachment_metadata', 'a:6:{s:5:\"width\";i:2560;s:6:\"height\";i:1707;s:4:\"file\";s:33:\"2020/04/puppy-sleeping-scaled.jpg\";s:5:\"sizes\";a:16:{s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"puppy-sleeping-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:27:\"puppy-sleeping-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"puppy-sleeping-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:26:\"puppy-sleeping-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:28:\"puppy-sleeping-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"2048x2048\";a:4:{s:4:\"file\";s:28:\"puppy-sleeping-2048x1365.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1365;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:26:\"puppy-sleeping-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:27:\"puppy-sleeping-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:26:\"puppy-sleeping-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:26:\"puppy-sleeping-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:27:\"puppy-sleeping-1080x720.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:26:\"puppy-sleeping-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:37:\"et-pb-post-main-image-fullwidth-large\";a:4:{s:4:\"file\";s:28:\"puppy-sleeping-2880x1800.jpg\";s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"et-pb-image--responsive--desktop\";a:4:{s:4:\"file\";s:27:\"puppy-sleeping-1280x854.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:854;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-image--responsive--tablet\";a:4:{s:4:\"file\";s:26:\"puppy-sleeping-980x653.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:653;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:26:\"puppy-sleeping-480x320.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:18:\"puppy-sleeping.jpg\";}'),
('2386', '205144', '_wp_attached_file', '2020/04/golden-retriever-sleeping.png'),
('2387', '205144', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:211;s:6:\"height\";i:159;s:4:\"file\";s:37:\"2020/04/golden-retriever-sleeping.png\";s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:37:\"golden-retriever-sleeping-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('2388', '205145', '_wp_attached_file', '2020/04/sleeping-lab-puppy-scaled.jpg'),
('2389', '205145', '_wp_attachment_metadata', 'a:6:{s:5:\"width\";i:2560;s:6:\"height\";i:1707;s:4:\"file\";s:37:\"2020/04/sleeping-lab-puppy-scaled.jpg\";s:5:\"sizes\";a:16:{s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"sleeping-lab-puppy-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:31:\"sleeping-lab-puppy-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"sleeping-lab-puppy-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:30:\"sleeping-lab-puppy-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:32:\"sleeping-lab-puppy-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"2048x2048\";a:4:{s:4:\"file\";s:32:\"sleeping-lab-puppy-2048x1365.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1365;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:30:\"sleeping-lab-puppy-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:31:\"sleeping-lab-puppy-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:30:\"sleeping-lab-puppy-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:30:\"sleeping-lab-puppy-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:31:\"sleeping-lab-puppy-1080x720.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:30:\"sleeping-lab-puppy-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:37:\"et-pb-post-main-image-fullwidth-large\";a:4:{s:4:\"file\";s:32:\"sleeping-lab-puppy-2880x1800.jpg\";s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"et-pb-image--responsive--desktop\";a:4:{s:4:\"file\";s:31:\"sleeping-lab-puppy-1280x854.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:854;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-image--responsive--tablet\";a:4:{s:4:\"file\";s:30:\"sleeping-lab-puppy-980x653.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:653;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:30:\"sleeping-lab-puppy-480x320.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:22:\"sleeping-lab-puppy.jpg\";}'),
('2390', '205142', '_wp_page_template', 'default'),
('2391', '205142', '_et_pb_post_hide_nav', 'default'),
('2392', '205142', '_et_pb_page_layout', 'et_right_sidebar'),
('2393', '205142', '_et_pb_side_nav', 'off'),
('2394', '205142', '_et_pb_use_builder', ''),
('2395', '205142', '_et_pb_first_image', ''),
('2396', '205142', '_et_pb_truncate_post', ''),
('2397', '205142', '_et_pb_truncate_post_date', ''),
('2398', '205142', '_et_pb_old_content', ''),
('2399', '205146', '_edit_lock', '1587974989:2'),
('2400', '205146', '_edit_last', '2');
/**ABDB**/INSERT INTO `wp_postmeta`  VALUES 
('2402', '205146', '_et_post_bg_color', '#ffffff'),
('2403', '205146', '_et_post_bg_layout', 'light'),
('2404', '205146', '_et_pb_show_title', 'on'),
('2405', '205146', '_et_pb_post_hide_nav', 'default'),
('2406', '205146', '_et_pb_page_layout', 'et_right_sidebar'),
('2407', '205146', '_et_pb_side_nav', 'off'),
('2408', '205146', '_et_pb_use_builder', ''),
('2409', '205146', '_et_pb_first_image', ''),
('2410', '205146', '_et_pb_truncate_post', ''),
('2411', '205146', '_et_pb_truncate_post_date', ''),
('2412', '205146', '_et_pb_old_content', ''),
('2416', '205148', 'iwp_log_type', 'scheduleBackup'),
('2417', '205148', 'iwp_log_action', 'schedule'),
('2418', '205148', 'iwp_log_activities_type', 'iwp_log'),
('2419', '205148', 'iwp_log_actions', 'backups'),
('2420', '205148', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('2421', '205149', 'iwp_log_type', 'scheduleBackup'),
('2422', '205149', 'iwp_log_action', 'schedule'),
('2423', '205149', 'iwp_log_activities_type', 'iwp_log'),
('2424', '205149', 'iwp_log_actions', 'backups'),
('2425', '205149', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('2426', '205150', 'iwp_log_type', 'themes'),
('2427', '205150', 'iwp_log_action', 'update'),
('2428', '205150', 'iwp_log_activities_type', 'iwp_log'),
('2429', '205150', 'iwp_log_actions', 'themes-updated'),
('2430', '205150', 'iwp_log_details', 'a:4:{s:4:\"name\";s:4:\"Divi\";s:4:\"slug\";s:4:\"Divi\";s:11:\"old_version\";s:5:\"4.4.4\";s:15:\"updated_version\";s:5:\"4.4.5\";}'),
('2431', '205151', 'iwp_log_type', 'scheduleBackup'),
('2432', '205151', 'iwp_log_action', 'schedule'),
('2433', '205151', 'iwp_log_activities_type', 'iwp_log'),
('2434', '205151', 'iwp_log_actions', 'backups'),
('2435', '205151', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('2436', '204557', '_et_pb_built_for_post_type', 'page'),
('2437', '204557', '_et_pb_ab_subjects', ''),
('2438', '204557', '_et_pb_gutter_width', '3'),
('2440', '204557', '_et_pb_first_image', ''),
('2441', '204557', '_et_pb_show_page_creation', 'off'),
('2443', '205154', 'iwp_log_type', 'themes'),
('2444', '205154', 'iwp_log_action', 'update'),
('2445', '205154', 'iwp_log_activities_type', 'iwp_log'),
('2446', '205154', 'iwp_log_actions', 'themes-updated'),
('2447', '205154', 'iwp_log_details', 'a:4:{s:4:\"name\";s:4:\"Divi\";s:4:\"slug\";s:4:\"Divi\";s:11:\"old_version\";s:5:\"4.4.5\";s:15:\"updated_version\";s:5:\"4.4.6\";}'),
('2448', '205155', 'iwp_log_type', 'plugins'),
('2449', '205155', 'iwp_log_action', 'update'),
('2450', '205155', 'iwp_log_activities_type', 'iwp_log'),
('2451', '205155', 'iwp_log_actions', 'plugins-updated'),
('2452', '205155', 'iwp_log_details', 'a:4:{s:4:\"name\";s:26:\"Advanced Custom Fields PRO\";s:4:\"slug\";s:26:\"advanced-custom-fields-pro\";s:11:\"old_version\";s:5:\"5.8.9\";s:15:\"updated_version\";s:6:\"5.8.11\";}'),
('2453', '205156', 'iwp_log_type', 'scheduleBackup'),
('2454', '205156', 'iwp_log_action', 'schedule'),
('2455', '205156', 'iwp_log_activities_type', 'iwp_log'),
('2456', '205156', 'iwp_log_actions', 'backups'),
('2457', '205156', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('2458', '205157', 'iwp_log_type', 'plugins'),
('2459', '205157', 'iwp_log_action', 'update'),
('2460', '205157', 'iwp_log_activities_type', 'iwp_log'),
('2461', '205157', 'iwp_log_actions', 'plugins-updated'),
('2462', '205157', 'iwp_log_details', 'a:4:{s:4:\"name\";s:14:\"Contact Form 7\";s:4:\"slug\";s:14:\"contact-form-7\";s:11:\"old_version\";s:5:\"5.1.7\";s:15:\"updated_version\";s:5:\"5.1.8\";}'),
('2463', '205158', 'iwp_log_type', 'themes'),
('2464', '205158', 'iwp_log_action', 'update'),
('2465', '205158', 'iwp_log_activities_type', 'iwp_log'),
('2466', '205158', 'iwp_log_actions', 'themes-updated'),
('2467', '205158', 'iwp_log_details', 'a:4:{s:4:\"name\";s:4:\"Divi\";s:4:\"slug\";s:4:\"Divi\";s:11:\"old_version\";s:5:\"4.4.6\";s:15:\"updated_version\";s:5:\"4.4.7\";}'),
('2468', '205159', 'iwp_log_type', 'themes'),
('2469', '205159', 'iwp_log_action', 'update'),
('2470', '205159', 'iwp_log_activities_type', 'iwp_log'),
('2471', '205159', 'iwp_log_actions', 'themes-updated'),
('2472', '205159', 'iwp_log_details', 'a:4:{s:4:\"name\";s:13:\"Twenty Twenty\";s:4:\"slug\";s:13:\"Twenty Twenty\";s:11:\"old_version\";s:3:\"1.2\";s:15:\"updated_version\";s:3:\"1.3\";}'),
('2473', '204562', '_et_pb_truncate_post', ''),
('2474', '204562', '_et_pb_truncate_post_date', ''),
('2475', '205161', 'iwp_log_type', 'scheduleBackup'),
('2476', '205161', 'iwp_log_action', 'schedule'),
('2477', '205161', 'iwp_log_activities_type', 'iwp_log'),
('2478', '205161', 'iwp_log_actions', 'backups'),
('2479', '205161', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('2480', '205162', 'iwp_log_type', 'plugins'),
('2481', '205162', 'iwp_log_action', 'update'),
('2482', '205162', 'iwp_log_activities_type', 'iwp_log'),
('2483', '205162', 'iwp_log_actions', 'plugins-updated'),
('2484', '205162', 'iwp_log_details', 'a:4:{s:4:\"name\";s:14:\"ActiveCampaign\";s:4:\"slug\";s:33:\"activecampaign-subscription-forms\";s:11:\"old_version\";s:5:\"7.1.2\";s:15:\"updated_version\";s:5:\"7.1.3\";}'),
('2485', '205163', 'iwp_log_type', 'scheduleBackup'),
('2486', '205163', 'iwp_log_action', 'schedule'),
('2487', '205163', 'iwp_log_activities_type', 'iwp_log'),
('2488', '205163', 'iwp_log_actions', 'backups'),
('2489', '205163', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('2490', '205164', 'iwp_log_type', 'scheduleBackup'),
('2491', '205164', 'iwp_log_action', 'schedule'),
('2492', '205164', 'iwp_log_activities_type', 'iwp_log'),
('2493', '205164', 'iwp_log_actions', 'backups'),
('2494', '205164', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('2495', '205165', 'iwp_log_type', 'themes'),
('2496', '205165', 'iwp_log_action', 'update'),
('2497', '205165', 'iwp_log_activities_type', 'iwp_log'),
('2498', '205165', 'iwp_log_actions', 'themes-updated'),
('2499', '205165', 'iwp_log_details', 'a:4:{s:4:\"name\";s:4:\"Divi\";s:4:\"slug\";s:4:\"Divi\";s:11:\"old_version\";s:5:\"4.4.7\";s:15:\"updated_version\";s:5:\"4.4.8\";}'),
('2500', '205166', 'iwp_log_type', 'themes'),
('2501', '205166', 'iwp_log_action', 'update'),
('2502', '205166', 'iwp_log_activities_type', 'iwp_log'),
('2503', '205166', 'iwp_log_actions', 'themes-updated'),
('2504', '205166', 'iwp_log_details', 'a:4:{s:4:\"name\";s:15:\"Twenty Nineteen\";s:4:\"slug\";s:15:\"Twenty Nineteen\";s:11:\"old_version\";s:3:\"1.5\";s:15:\"updated_version\";s:3:\"1.6\";}'),
('2505', '205167', 'iwp_log_type', 'themes'),
('2506', '205167', 'iwp_log_action', 'update'),
('2507', '205167', 'iwp_log_activities_type', 'iwp_log'),
('2508', '205167', 'iwp_log_actions', 'themes-updated'),
('2509', '205167', 'iwp_log_details', 'a:4:{s:4:\"name\";s:13:\"Twenty Twenty\";s:4:\"slug\";s:13:\"Twenty Twenty\";s:11:\"old_version\";s:3:\"1.3\";s:15:\"updated_version\";s:3:\"1.4\";}'),
('2510', '205168', 'iwp_log_type', 'plugins'),
('2511', '205168', 'iwp_log_action', 'update'),
('2512', '205168', 'iwp_log_activities_type', 'iwp_log'),
('2513', '205168', 'iwp_log_actions', 'plugins-updated'),
('2514', '205168', 'iwp_log_details', 'a:4:{s:4:\"name\";s:26:\"Advanced Custom Fields PRO\";s:4:\"slug\";s:26:\"advanced-custom-fields-pro\";s:11:\"old_version\";s:6:\"5.8.11\";s:15:\"updated_version\";s:6:\"5.8.12\";}'),
('2515', '205169', 'iwp_log_type', 'core'),
('2516', '205169', 'iwp_log_action', 'update'),
('2517', '205169', 'iwp_log_activities_type', 'iwp_log'),
('2518', '205169', 'iwp_log_actions', 'core-updated'),
('2519', '205169', 'iwp_log_details', 'a:2:{s:11:\"old_version\";s:5:\"5.4.1\";s:15:\"updated_version\";s:5:\"5.4.2\";}'),
('2520', '205170', 'iwp_log_type', 'scheduleBackup'),
('2521', '205170', 'iwp_log_action', 'schedule'),
('2522', '205170', 'iwp_log_activities_type', 'iwp_log'),
('2523', '205170', 'iwp_log_actions', 'backups'),
('2524', '205170', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('2525', '204559', '_et_pb_built_for_post_type', 'page'),
('2526', '204559', '_et_pb_ab_subjects', ''),
('2527', '204559', '_et_pb_ab_current_shortcode', '[et_pb_split_track id=\"204559\" /]'),
('2528', '204559', '_et_pb_gutter_width', '3'),
('2530', '204559', '_et_pb_first_image', ''),
('2531', '204559', '_et_pb_truncate_post_date', ''),
('2532', '204559', '_et_pb_show_page_creation', 'off'),
('2536', '205177', 'iwp_log_type', 'scheduleBackup'),
('2537', '205177', 'iwp_log_action', 'schedule'),
('2538', '205177', 'iwp_log_activities_type', 'iwp_log'),
('2539', '205177', 'iwp_log_actions', 'backups'),
('2540', '205177', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('2541', '205178', 'iwp_log_type', 'scheduleBackup'),
('2542', '205178', 'iwp_log_action', 'schedule'),
('2543', '205178', 'iwp_log_activities_type', 'iwp_log'),
('2544', '205178', 'iwp_log_actions', 'backups'),
('2545', '205178', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('2546', '205179', 'iwp_log_type', 'scheduleBackup'),
('2547', '205179', 'iwp_log_action', 'schedule'),
('2548', '205179', 'iwp_log_activities_type', 'iwp_log'),
('2549', '205179', 'iwp_log_actions', 'backups'),
('2550', '205179', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('2551', '205180', 'iwp_log_type', 'plugins'),
('2552', '205180', 'iwp_log_action', 'update'),
('2553', '205180', 'iwp_log_activities_type', 'iwp_log'),
('2554', '205180', 'iwp_log_actions', 'plugins-updated'),
('2555', '205180', 'iwp_log_details', 'a:4:{s:4:\"name\";s:14:\"Contact Form 7\";s:4:\"slug\";s:14:\"contact-form-7\";s:11:\"old_version\";s:5:\"5.1.9\";s:15:\"updated_version\";s:3:\"5.2\";}'),
('2556', '205181', 'iwp_log_type', 'plugins'),
('2557', '205181', 'iwp_log_action', 'update'),
('2558', '205181', 'iwp_log_activities_type', 'iwp_log'),
('2559', '205181', 'iwp_log_actions', 'plugins-updated'),
('2560', '205181', 'iwp_log_details', 'a:4:{s:4:\"name\";s:23:\"Official Facebook Pixel\";s:4:\"slug\";s:23:\"official-facebook-pixel\";s:11:\"old_version\";s:5:\"2.0.2\";s:15:\"updated_version\";s:5:\"2.1.0\";}'),
('2561', '205182', 'iwp_log_type', 'plugins'),
('2562', '205182', 'iwp_log_action', 'update'),
('2563', '205182', 'iwp_log_activities_type', 'iwp_log'),
('2564', '205182', 'iwp_log_actions', 'plugins-updated'),
('2565', '205182', 'iwp_log_details', 'a:4:{s:4:\"name\";s:16:\"Post Types Order\";s:4:\"slug\";s:16:\"post-types-order\";s:11:\"old_version\";s:7:\"1.9.4.3\";s:15:\"updated_version\";s:7:\"1.9.5.1\";}'),
('2566', '205183', 'iwp_log_type', 'themes'),
('2567', '205183', 'iwp_log_action', 'update'),
('2568', '205183', 'iwp_log_activities_type', 'iwp_log'),
('2569', '205183', 'iwp_log_actions', 'themes-updated'),
('2570', '205183', 'iwp_log_details', 'a:4:{s:4:\"name\";s:4:\"Divi\";s:4:\"slug\";s:4:\"Divi\";s:11:\"old_version\";s:5:\"4.4.8\";s:15:\"updated_version\";s:5:\"4.4.9\";}'),
('2571', '205184', 'iwp_log_type', 'scheduleBackup'),
('2572', '205184', 'iwp_log_action', 'schedule'),
('2573', '205184', 'iwp_log_activities_type', 'iwp_log'),
('2574', '205184', 'iwp_log_actions', 'backups'),
('2575', '205184', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('2576', '205187', '_edit_lock', '1595296320:2'),
('2577', '205187', '_edit_last', '2'),
('2578', '205188', '_wp_attached_file', '2020/07/puppy-in-pen-scaled.jpg'),
('2579', '205188', '_wp_attachment_metadata', 'a:6:{s:5:\"width\";i:2560;s:6:\"height\";i:1667;s:4:\"file\";s:31:\"2020/07/puppy-in-pen-scaled.jpg\";s:5:\"sizes\";a:16:{s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"puppy-in-pen-300x195.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:195;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:25:\"puppy-in-pen-1024x667.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:667;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"puppy-in-pen-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:24:\"puppy-in-pen-768x500.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:26:\"puppy-in-pen-1536x1000.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1000;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"2048x2048\";a:4:{s:4:\"file\";s:26:\"puppy-in-pen-2048x1333.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1333;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:24:\"puppy-in-pen-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:25:\"puppy-in-pen-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:24:\"puppy-in-pen-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:24:\"puppy-in-pen-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:25:\"puppy-in-pen-1080x703.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:703;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:24:\"puppy-in-pen-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:37:\"et-pb-post-main-image-fullwidth-large\";a:4:{s:4:\"file\";s:26:\"puppy-in-pen-2880x1800.jpg\";s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"et-pb-image--responsive--desktop\";a:4:{s:4:\"file\";s:25:\"puppy-in-pen-1280x834.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:834;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-image--responsive--tablet\";a:4:{s:4:\"file\";s:24:\"puppy-in-pen-980x638.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:638;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:24:\"puppy-in-pen-480x313.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:313;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:16:\"puppy-in-pen.jpg\";}'),
('2580', '205187', '_wp_page_template', 'default'),
('2581', '205187', '_et_pb_post_hide_nav', 'default'),
('2582', '205187', '_et_pb_page_layout', 'et_right_sidebar'),
('2583', '205187', '_et_pb_side_nav', 'off'),
('2584', '205187', '_et_pb_use_builder', ''),
('2585', '205187', '_et_pb_first_image', ''),
('2586', '205187', '_et_pb_truncate_post', ''),
('2587', '205187', '_et_pb_truncate_post_date', ''),
('2588', '205187', '_et_pb_old_content', ''),
('2589', '205190', 'iwp_log_type', 'themes'),
('2590', '205190', 'iwp_log_action', 'update'),
('2591', '205190', 'iwp_log_activities_type', 'iwp_log'),
('2592', '205190', 'iwp_log_actions', 'themes-updated'),
('2593', '205190', 'iwp_log_details', 'a:4:{s:4:\"name\";s:4:\"Divi\";s:4:\"slug\";s:4:\"Divi\";s:11:\"old_version\";s:5:\"4.4.9\";s:15:\"updated_version\";s:5:\"4.5.1\";}'),
('2594', '205191', 'iwp_log_type', 'plugins'),
('2595', '205191', 'iwp_log_action', 'update'),
('2596', '205191', 'iwp_log_activities_type', 'iwp_log'),
('2597', '205191', 'iwp_log_actions', 'plugins-updated'),
('2598', '205191', 'iwp_log_details', 'a:4:{s:4:\"name\";s:32:\"Head, Footer and Post Injections\";s:4:\"slug\";s:13:\"header-footer\";s:11:\"old_version\";s:5:\"3.1.6\";s:15:\"updated_version\";s:5:\"3.2.1\";}'),
('2599', '205193', '_edit_lock', '1595993237:2'),
('2600', '205193', '_edit_last', '2'),
('2602', '205193', 'hefo_before', '0'),
('2603', '205193', 'hefo_after', '0'),
('2604', '205193', '_et_post_bg_color', '#ffffff'),
('2605', '205193', '_et_post_bg_layout', 'light'),
('2606', '205193', '_et_pb_show_title', 'on'),
('2607', '205193', '_et_pb_post_hide_nav', 'default'),
('2608', '205193', '_et_pb_page_layout', 'et_right_sidebar'),
('2609', '205193', '_et_pb_side_nav', 'off'),
('2610', '205193', '_et_pb_use_builder', ''),
('2611', '205193', '_et_pb_first_image', ''),
('2612', '205193', '_et_pb_truncate_post', ''),
('2613', '205193', '_et_pb_truncate_post_date', ''),
('2614', '205193', '_et_pb_old_content', ''),
('2617', '204557', 'hefo_before', '0'),
('2618', '204557', 'hefo_after', '0'),
('2619', '205195', 'iwp_log_type', 'scheduleBackup'),
('2620', '205195', 'iwp_log_action', 'schedule'),
('2621', '205195', 'iwp_log_activities_type', 'iwp_log'),
('2622', '205195', 'iwp_log_actions', 'backups'),
('2623', '205195', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('2624', '204804', '_et_pb_truncate_post', '<p><div class=\"et_pb_section et_pb_section_5 premium-puppy et_pb_with_background et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_row et_pb_row_7\">\n				<div class=\"et_pb_column et_pb_column_4_4 et_pb_column_9  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_9  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Club Canine<br />\nYou’ve done the basics, but your dog needs more training and you to learn new activities you can enjoy with your dog.</div>\n			</div> <!-- .et_pb_text --><div class=\"et_pb_module et_pb_text et_pb_text_10  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Let’s go to Club Canine.</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_section et_pb_section_6 et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_row et_pb_row_8 switch-image\">\n				<div class=\"et_pb_column et_pb_column_1_2 et_pb_column_10  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_11  et_pb_text_align_left et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_text_inner\">For dogs 6 months of age and older:<br />\nClub Canine has continuous enrolment procedures, so you can start whenever you’re ready! We work with you &amp; your dog, at your level.<br />\nIntroducing different tasks each week, Club Canine is a series of fun activities where you will learn new skills as you play with your dog.<br />\nClub Canine incorporates trick training, games to teach your dog to focus on you, games that teach recall and calm walking on the lead, games to send your dog through a tunnel and over a jump, and games to engage your dog’s amazing sense of smell.</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_2 et_pb_column_11  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_image et_pb_image_2\">\n				\n				\n				<span class=\"et_pb_image_wrap \"><img src=\"https://jhdogtraining.com.au/wp-content/uploads/2018/09/train.jpg\" alt=\"\" title=\"\" srcset=\"https://jhdogtraining.com.au/wp-content/uploads/2018/09/train.jpg 520w, https://jhdogtraining.com.au/wp-content/uploads/2018/09/train-300x198.jpg 300w\" sizes=\"(max-width: 520px) 100vw, 520px\" /></span>\n			</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row --><div class=\"et_pb_row et_pb_row_9\">\n				<div class=\"et_pb_column et_pb_column_1_2 et_pb_column_12  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_image et_pb_image_3\">\n				\n				\n				<span class=\"et_pb_image_wrap \"><img src=\"https://jhdogtraining.com.au/wp-content/uploads/2018/09/callback_.jpg\" alt=\"\" title=\"\" srcset=\"https://jhdogtraining.com.au/wp-content/uploads/2018/09/callback_.jpg 520w, https://jhdogtraining.com.au/wp-content/uploads/2018/09/callback_-300x198.jpg 300w\" sizes=\"(max-width: 520px) 100vw, 520px\" /></span>\n			</div>\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_2 et_pb_column_13  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_12  et_pb_text_align_left et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_text_inner\"><p>Where: XXX Park<br />\nWhen: Wednesdays 7pm (each class is 1hr)<br />\nCost: Initial 4-week membership $180<br />\nFurther 4-week packages $155</p>\n<p>Maximum 8 dogs per class so you will receive the personal tuition you need.</p></div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_section et_pb_section_7 et_pb_with_background et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_row et_pb_row_10\">\n				<div class=\"et_pb_column et_pb_column_4_4 et_pb_column_14  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_13  et_pb_text_align_left et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_text_inner\">3 Easy ways to book.<br />\nFill out the form below, email jenny@jhdogtraining.com.au or phone 0419 535 236</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row --><div class=\"et_pb_row et_pb_row_11\">\n				<div class=\"et_pb_column et_pb_column_1_4 et_pb_column_15  et_pb_css_mix_blend_mode_passthrough et_pb_column_empty\">\n				\n				\n				\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_2 et_pb_column_16  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_14  et_pb_text_align_left et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_text_inner\"><div role=\"form\" class=\"wpcf7\" id=\"wpcf7-f204807-p204804-o1\" lang=\"en-US\" dir=\"ltr\">\n<div class=\"screen-reader-response\" role=\"alert\" aria-live=\"polite\"></div>\n<form action=\"/?s=recall#wpcf7-f204807-p204804-o1\" method=\"post\" class=\"wpcf7-form init\" novalidate=\"novalidate\">\n<div style=\"display: none;\">\n<input type=\"hidden\" name=\"_wpcf7\" value=\"204807\" />\n<input type=\"hidden\" name=\"_wpcf7_version\" value=\"5.2\" />\n<input type=\"hidden\" name=\"_wpcf7_locale\" value=\"en_US\" />\n<input type=\"hidden\" name=\"_wpcf7_unit_tag\" value=\"wpcf7-f204807-p204804-o1\" />\n<input type=\"hidden\" name=\"_wpcf7_container_post\" value=\"204804\" />\n<input type=\"hidden\" name=\"_wpcf7_posted_data_hash\" value=\"\" />\n<input type=\"hidden\" name=\"_wpcf7_recaptcha_response\" value=\"\" />\n</div>\n<p><label>Name (required)<br />\n    <span class=\"wpcf7-form-control-wrap your-name\"><input type=\"text\" name=\"your-name\" value=\"\" size=\"40\" class=\"wpcf7-form-control wpcf7-text wpcf7-validates-as-required\" aria-required=\"true\" aria-invalid=\"false\" /></span> </label></p>\n<p><label>Dog\'s Name (required)<br />\n<span class=\"wpcf7-form-control-wrap dogs-name\"><input type=\"text\" name=\"dogs-name\" value=\"\" size=\"40\" class=\"wpcf7-form-control wpcf7-text wpcf7-validates-as-required\" aria-required=\"true\" aria-invalid=\"false\" /></span> </label></p>\n<p><label>Dog\'s Age (required)<br />\n<span class=\"wpcf7-form-control-wrap dogs-age\"><input type=\"text\" name=\"dogs-age\" value=\"\" size=\"40\" class=\"wpcf7-form-control wpcf7-text wpcf7-validates-as-required\" aria-required=\"true\" aria-invalid=\"false\" /></span> </label></p>\n<p><label>Email Address (required)<br />\n    <span class=\"wpcf7-form-control-wrap your-email\"><input type=\"email\" name=\"your-email\" value=\"\" size=\"40\" class=\"wpcf7-form-control wpcf7-text wpcf7-email wpcf7-validates-as-required wpcf7-validates-as-email\" aria-required=\"true\" aria-invalid=\"false\" /></span> </label></p>\n<p><label>Phone Number (required)<br />\n<span class=\"wpcf7-form-control-wrap tel-729\"><input type=\"tel\" name=\"tel-729\" value=\"\" size=\"40\" class=\"wpcf7-form-control wpcf7-text wpcf7-tel wpcf7-validates-as-required wpcf7-validates-as-tel\" aria-required=\"true\" aria-invalid=\"false\" /></span> </label></p>\n<p><label>Start Date<br />\n<span class=\"wpcf7-form-control-wrap start-date\"><input type=\"date\" name=\"start-date\" value=\"\" class=\"wpcf7-form-control wpcf7-date wpcf7-validates-as-date\" aria-invalid=\"false\" /></span> </label></p>\n<p><input type=\"submit\" value=\"Send\" class=\"wpcf7-form-control wpcf7-submit\" /></p>\n<div class=\"wpcf7-response-output\" role=\"alert\" aria-hidden=\"true\"></div></form></div></div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_4 et_pb_column_17  et_pb_css_mix_blend_mode_passthrough et-last-child et_pb_column_empty\">\n				\n				\n				\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --></p>\n'),
('2625', '204804', '_et_pb_truncate_post_date', '2020-08-05 05:16:55'),
('2626', '205196', 'iwp_log_type', 'scheduleBackup'),
('2627', '205196', 'iwp_log_action', 'schedule'),
('2628', '205196', 'iwp_log_activities_type', 'iwp_log'),
('2629', '205196', 'iwp_log_actions', 'backups'),
('2630', '205196', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('2631', '205197', 'iwp_log_type', 'themes'),
('2632', '205197', 'iwp_log_action', 'update'),
('2633', '205197', 'iwp_log_activities_type', 'iwp_log'),
('2634', '205197', 'iwp_log_actions', 'themes-updated'),
('2635', '205197', 'iwp_log_details', 'a:4:{s:4:\"name\";s:4:\"Divi\";s:4:\"slug\";s:4:\"Divi\";s:11:\"old_version\";s:5:\"4.5.1\";s:15:\"updated_version\";s:5:\"4.5.3\";}'),
('2636', '205198', 'iwp_log_type', 'plugins'),
('2637', '205198', 'iwp_log_action', 'update'),
('2638', '205198', 'iwp_log_activities_type', 'iwp_log'),
('2639', '205198', 'iwp_log_actions', 'plugins-updated'),
('2640', '205198', 'iwp_log_details', 'a:4:{s:4:\"name\";s:17:\"WP Migrate DB Pro\";s:4:\"slug\";s:17:\"wp-migrate-db-pro\";s:11:\"old_version\";s:6:\"1.9.10\";s:15:\"updated_version\";s:6:\"1.9.12\";}'),
('2641', '205199', 'iwp_log_type', 'plugins'),
('2642', '205199', 'iwp_log_action', 'update'),
('2643', '205199', 'iwp_log_activities_type', 'iwp_log'),
('2644', '205199', 'iwp_log_actions', 'plugins-updated'),
('2645', '205199', 'iwp_log_details', 'a:4:{s:4:\"name\";s:30:\"YIKES Simple Taxonomy Ordering\";s:4:\"slug\";s:24:\"simple-taxonomy-ordering\";s:11:\"old_version\";s:5:\"2.1.0\";s:15:\"updated_version\";s:5:\"2.3.1\";}'),
('2646', '205200', 'iwp_log_type', 'plugins'),
('2647', '205200', 'iwp_log_action', 'update'),
('2648', '205200', 'iwp_log_activities_type', 'iwp_log'),
('2649', '205200', 'iwp_log_actions', 'plugins-updated'),
('2650', '205200', 'iwp_log_details', 'a:4:{s:4:\"name\";s:14:\"Contact Form 7\";s:4:\"slug\";s:14:\"contact-form-7\";s:11:\"old_version\";s:3:\"5.2\";s:15:\"updated_version\";s:5:\"5.2.1\";}'),
('2651', '204553', '_et_pb_built_for_post_type', 'page'),
('2652', '204553', '_et_pb_ab_subjects', ''),
('2653', '204553', '_et_pb_ab_current_shortcode', '[et_pb_split_track id=\"204553\" /]'),
('2654', '204553', '_et_pb_gutter_width', '3'),
('2656', '204553', '_et_pb_first_image', ''),
('2657', '204553', '_et_pb_truncate_post', '<p><div class=\"et_pb_section et_pb_section_0 separation-anxiety et_pb_with_background et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_row et_pb_row_0\">\n				<div class=\"et_pb_column et_pb_column_4_4 et_pb_column_0  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_0  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Treatment for Separation Anxiety<br />\nAre you afraid to leave your dog alone because he might hurt himself or destroy your things? Does he try to escape by clawing at your doors or windows? Do the neighbours complain about constant barking or howling?Have you been told there’s nothing that can help?</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_section et_pb_section_1 et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_row et_pb_row_1\">\n				<div class=\"et_pb_column et_pb_column_4_4 et_pb_column_1  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_1  et_pb_text_align_left et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_text_inner\">If you answered “yes” to most or all of these questions, stop, take a long, deep breath,and get ready for some good news. Your dog’s separation anxiety can be treated and you can finally get your life back.</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row --><div class=\"et_pb_row et_pb_row_2\">\n				<div class=\"et_pb_column et_pb_column_1_2 et_pb_column_2  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_image et_pb_image_0\">\n				\n				\n				<span class=\"et_pb_image_wrap \"><img loading=\"lazy\" src=\"/wp-content/uploads/2017/12/black-dog-in-window.jpg\" alt=\"\" title=\"\" height=\"auto\" width=\"auto\" srcset=\"https://jhdogtraining.com.au/wp-content/uploads/2017/12/black-dog-in-window.jpg 520w, https://jhdogtraining.com.au/wp-content/uploads/2017/12/black-dog-in-window-300x200.jpg 300w\" sizes=\"(max-width: 520px) 100vw, 520px\" class=\"wp-image-204647\" /></span>\n			</div>\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_2 et_pb_column_3  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_2  et_pb_text_align_left et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_text_inner\">What is Separation Anxiety?<br />\nSeparation anxiety is a complicated and devastating disorder that affects approximately 15 percent of all dogs. Not only does it cause extreme panic in the dogs that are left alone, it creates extreme levels of stress for the humans who love them. Left untreated, separation anxiety only worsens with time.</p>\n<p>Separation anxiety can be caused by a number of things, from a traumatic experience to changes in the home to genetic disposition. Often it’s not clear why your dog feels so panicked when you leave. But it’s important to remember that it’s not your fault and your dog isn’t mad at you or trying to get back at you. Help is available, and by using online consultations, you and your dog will work with methods that have already helped hundreds of dogs over come this condition.</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row --><div class=\"et_pb_row et_pb_row_3 switch-image\">\n				<div class=\"et_pb_column et_pb_column_1_2 et_pb_column_4  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_3  et_pb_text_align_left et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_text_inner\">Expert help. How does it work?<br />\nAs the first Australian dog trainer to become a Certified Separation Anxiety Trainer (CSAT), Jenny has completed intensive study with international Separation Anxiety Training expert Malena DeMartini.  By using technology to work in real time, we introduce your dog to gradual absences at the rate that&#8217;s right for them.  Which means your dog has the best opportunity to make progress!                               If the word &#8220;technology&#8221; makes you stressed, don&#8217;t be.  Jenny can take you through that as well &#8211; it&#8217;s easy! So no matter your location, help is at hand.</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_2 et_pb_column_5  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_image et_pb_image_1\">\n				\n				\n				<span class=\"et_pb_image_wrap \"><img loading=\"lazy\" src=\"/wp-content/uploads/2017/11/AdobeStock_84330916_o.jpg\" alt=\"\" title=\"\" height=\"auto\" width=\"auto\" srcset=\"https://jhdogtraining.com.au/wp-content/uploads/2017/11/AdobeStock_84330916_o.jpg 520w, https://jhdogtraining.com.au/wp-content/uploads/2017/11/AdobeStock_84330916_o-300x200.jpg 300w\" sizes=\"(max-width: 520px) 100vw, 520px\" class=\"wp-image-204614\" /></span>\n			</div>\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_section et_pb_section_2 et_pb_with_background et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_row et_pb_row_4\">\n				<div class=\"et_pb_column et_pb_column_4_4 et_pb_column_6  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_4  et_pb_text_align_left et_pb_bg_layout_dark\">\n				\n				\n				<div class=\"et_pb_text_inner\">Best of all, you won’t have to go it alone. Jenny will be with you every step of the way, giving you all the support and guidance you need to bring relief to your dog, and peace and harmony to your home.<br />\n&nbsp;<br />\n“We had a young puppy with separation anxiety who could not cope at being alone for even a few minutes. We were at our wits end until we found Jenny who was a life saver! She was so caring and understanding and helped us to work with our puppy to learn his signals of anxiety, and how to help him to overcome them. She was so patient and attentive and within four weeks there was such an enormous difference in Freddie. We could not be more thrilled with the results and can’t recommend Jenny highly enough!”   Laura &amp; Chris with Freddie the Hungarian Viszla<br />\n&nbsp;</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_section et_pb_section_3 et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_row et_pb_row_5\">\n				<div class=\"et_pb_column et_pb_column_4_4 et_pb_column_7  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_5  et_pb_text_align_left et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_text_inner\">How it works<br />\nIf you’re ready to separate yourself from separation anxiety, it’s easy to get started.</div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row --><div class=\"et_pb_row et_pb_row_6\">\n				<div class=\"et_pb_column et_pb_column_1_4 et_pb_column_8  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_blurb et_pb_blurb_0  et_pb_text_align_center  et_pb_blurb_position_top et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_blurb_content\">\n					<div class=\"et_pb_main_blurb_image\"><span class=\"et_pb_image_wrap\"><span class=\"et-waypoint et_pb_animation_top et-pb-icon\">&#x6c;</span></span></div>\n					<div class=\"et_pb_blurb_container\">\n						<h4 class=\"et_pb_module_header\"><span>Reach out</span></h4>\n						<div class=\"et_pb_blurb_description\">Fill out the contact form by clicking here and Jenny will be in touch to further learn about your situation, and discuss the treatment protocol and fees.</div>\n					</div>\n				</div> <!-- .et_pb_blurb_content -->\n			</div> <!-- .et_pb_blurb -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_4 et_pb_column_9  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_blurb et_pb_blurb_1  et_pb_text_align_center  et_pb_blurb_position_top et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_blurb_content\">\n					<div class=\"et_pb_main_blurb_image\"><span class=\"et_pb_image_wrap\"><span class=\"et-waypoint et_pb_animation_top et-pb-icon\">&#xe090;</span></span></div>\n					<div class=\"et_pb_blurb_container\">\n						<h4 class=\"et_pb_module_header\"><span>Complete a consultation</span></h4>\n						<div class=\"et_pb_blurb_description\">As soon you’re ready to get started, Jenny will set up an initial consultation with you to learn more about your dog and your goals for treatment. During this on line consultation, lasting 1 to 1.5hrs, she’ll gather information about your dog’s temperament, personality, and behavioral and medical histories. She will then conduct a short online assessment.</div>\n					</div>\n				</div> <!-- .et_pb_blurb_content -->\n			</div> <!-- .et_pb_blurb -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_4 et_pb_column_10  et_pb_css_mix_blend_mode_passthrough\">\n				\n				\n				<div class=\"et_pb_module et_pb_blurb et_pb_blurb_2  et_pb_text_align_center  et_pb_blurb_position_top et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_blurb_content\">\n					<div class=\"et_pb_main_blurb_image\"><span class=\"et_pb_image_wrap\"><span class=\"et-waypoint et_pb_animation_top et-pb-icon\">&#xe037;</span></span></div>\n					<div class=\"et_pb_blurb_container\">\n						<h4 class=\"et_pb_module_header\"><span>Implement a treatment plan</span></h4>\n						<div class=\"et_pb_blurb_description\">Based on the assessment, a treatment plan will be customized especially for your dog and lifestyle, complete with easy-to-follow instructions and ongoing support.</div>\n					</div>\n				</div> <!-- .et_pb_blurb_content -->\n			</div> <!-- .et_pb_blurb -->\n			</div> <!-- .et_pb_column --><div class=\"et_pb_column et_pb_column_1_4 et_pb_column_11  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_blurb et_pb_blurb_3  et_pb_text_align_center  et_pb_blurb_position_top et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_blurb_content\">\n					<div class=\"et_pb_main_blurb_image\"><span class=\"et_pb_image_wrap\"><span class=\"et-waypoint et_pb_animation_top et-pb-icon\">&#xe033;</span></span></div>\n					<div class=\"et_pb_blurb_container\">\n						<h4 class=\"et_pb_module_header\"><span>Live the dream</span></h4>\n						<div class=\"et_pb_blurb_description\">Imagine being able to run to the store or go to work while your dog peacefully snores away on the sofa. With patience, consistency and personal support from Jenny, this dream can be a reality!</div>\n					</div>\n				</div> <!-- .et_pb_blurb_content -->\n			</div> <!-- .et_pb_blurb -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --><div class=\"et_pb_section et_pb_section_4 et_section_regular\" >\n				\n				\n				\n				\n					<div class=\"et_pb_row et_pb_row_7\">\n				<div class=\"et_pb_column et_pb_column_4_4 et_pb_column_12  et_pb_css_mix_blend_mode_passthrough et-last-child\">\n				\n				\n				<div class=\"et_pb_module et_pb_text et_pb_text_6  et_pb_text_align_left et_pb_bg_layout_light\">\n				\n				\n				<div class=\"et_pb_text_inner\">separation anxiety assessment form<br />\n<div role=\"form\" class=\"wpcf7\" id=\"wpcf7-f204679-p204553-o1\" lang=\"en-US\" dir=\"ltr\">\n<div class=\"screen-reader-response\"><p role=\"status\" aria-live=\"polite\" aria-atomic=\"true\"></p> <ul></ul></div>\n<form action=\"/page/3/?s=home+alone#wpcf7-f204679-p204553-o1\" method=\"post\" class=\"wpcf7-form init\" novalidate=\"novalidate\" data-status=\"init\">\n<div style=\"display: none;\">\n<input type=\"hidden\" name=\"_wpcf7\" value=\"204679\" />\n<input type=\"hidden\" name=\"_wpcf7_version\" value=\"5.3\" />\n<input type=\"hidden\" name=\"_wpcf7_locale\" value=\"en_US\" />\n<input type=\"hidden\" name=\"_wpcf7_unit_tag\" value=\"wpcf7-f204679-p204553-o1\" />\n<input type=\"hidden\" name=\"_wpcf7_container_post\" value=\"204553\" />\n<input type=\"hidden\" name=\"_wpcf7_posted_data_hash\" value=\"\" />\n<input type=\"hidden\" name=\"_wpcf7_recaptcha_response\" value=\"\" />\n</div>\n<div><span class=\"wpcf7-form-control-wrap your-name\"><input type=\"text\" name=\"your-name\" value=\"\" size=\"40\" class=\"wpcf7-form-control wpcf7-text wpcf7-validates-as-required\" aria-required=\"true\" aria-invalid=\"false\" placeholder=\"First Name\" /></span></div>\n<div><span class=\"wpcf7-form-control-wrap text-879\"><input type=\"text\" name=\"text-879\" value=\"\" size=\"40\" class=\"wpcf7-form-control wpcf7-text\" aria-invalid=\"false\" placeholder=\"Last Name\" /></span></div>\n<div><span class=\"wpcf7-form-control-wrap tel-499\"><input type=\"tel\" name=\"tel-499\" value=\"\" size=\"40\" class=\"wpcf7-form-control wpcf7-text wpcf7-tel wpcf7-validates-as-tel\" aria-invalid=\"false\" placeholder=\"Phone Number\" /></span></div>\n<div><span class=\"wpcf7-form-control-wrap your-email\"><input type=\"email\" name=\"your-email\" value=\"\" size=\"40\" class=\"wpcf7-form-control wpcf7-text wpcf7-email wpcf7-validates-as-required wpcf7-validates-as-email\" aria-required=\"true\" aria-invalid=\"false\" placeholder=\"Email Address\" /></span></div>\n<div><span class=\"wpcf7-form-control-wrap location\"><input type=\"text\" name=\"location\" value=\"\" size=\"40\" class=\"wpcf7-form-control wpcf7-text\" aria-invalid=\"false\" placeholder=\"Your Location\" /></span></div>\n<div><span class=\"wpcf7-form-control-wrap dogs-name\"><input type=\"text\" name=\"dogs-name\" value=\"\" size=\"40\" class=\"wpcf7-form-control wpcf7-text\" aria-invalid=\"false\" placeholder=\"Dog&#039;s Name\" /></span></div>\n<div><span class=\"wpcf7-form-control-wrap dogs-age\"><input type=\"text\" name=\"dogs-age\" value=\"\" size=\"40\" class=\"wpcf7-form-control wpcf7-text\" aria-invalid=\"false\" placeholder=\"Dog&#039;s Age\" /></span></div>\n<div><span class=\"wpcf7-form-control-wrap dogs-breed\"><input type=\"text\" name=\"dogs-breed\" value=\"\" size=\"40\" class=\"wpcf7-form-control wpcf7-text\" aria-invalid=\"false\" placeholder=\"Dog&#039;s Breed\" /></span></div>\n<div><span class=\"wpcf7-form-control-wrap dogs-gender\"><input type=\"text\" name=\"dogs-gender\" value=\"\" size=\"40\" class=\"wpcf7-form-control wpcf7-text\" aria-invalid=\"false\" placeholder=\"Dog&#039;s Gender\" /></span></div>\n<div><span class=\"wpcf7-form-control-wrap where-is-dog-from\"><input type=\"text\" name=\"where-is-dog-from\" value=\"\" size=\"40\" class=\"wpcf7-form-control wpcf7-text\" aria-invalid=\"false\" placeholder=\"Where did you get the dog? (breeder, shelter etc)\" /></span></div>\n<div><span class=\"wpcf7-form-control-wrap how-long-id-dog-with-you\"><input type=\"text\" name=\"how-long-id-dog-with-you\" value=\"\" size=\"40\" class=\"wpcf7-form-control wpcf7-text\" aria-invalid=\"false\" placeholder=\"How Long has the dog been in your home?\" /></span></div>\n<div><span class=\"wpcf7-form-control-wrap how-often-is-dog-alone\"><input type=\"text\" name=\"how-often-is-dog-alone\" value=\"\" size=\"40\" class=\"wpcf7-form-control wpcf7-text\" aria-invalid=\"false\" placeholder=\"How often is the dog currently being left alone?\" /></span></div>\n<div><span class=\"wpcf7-form-control-wrap other-comments-dog-alone\"><textarea name=\"other-comments-dog-alone\" cols=\"40\" rows=\"10\" class=\"wpcf7-form-control wpcf7-textarea\" aria-invalid=\"false\" placeholder=\"If you have any other comments about your dog’s home alone time, please enter here.\"></textarea></span></div>\n<p>Can you alter your schedule so that your dog will not have to be left alone during the training period? ( Please keep in mind, dog is not considered alone when accompanied by someone, in or outside of your home, in an environment where they are comfortable.)</p>\n<div><span class=\"wpcf7-form-control-wrap alter-schedule\"><span class=\"wpcf7-form-control wpcf7-radio\"><span class=\"wpcf7-list-item first\"><input type=\"radio\" name=\"alter-schedule\" value=\"Yes\" checked=\"checked\" /><span class=\"wpcf7-list-item-label\">Yes</span></span><span class=\"wpcf7-list-item\"><input type=\"radio\" name=\"alter-schedule\" value=\"No\" /><span class=\"wpcf7-list-item-label\">No</span></span><span class=\"wpcf7-list-item last\"><input type=\"radio\" name=\"alter-schedule\" value=\"Maybe\" /><span class=\"wpcf7-list-item-label\">Maybe</span></span></span></span></div>\n<p>Have you done any previous training to address your dog\'s separation anxiety?*</p>\n<div><span class=\"wpcf7-form-control-wrap previous-training\"><span class=\"wpcf7-form-control wpcf7-radio\"><span class=\"wpcf7-list-item first\"><input type=\"radio\" name=\"previous-training\" value=\"Yes\" checked=\"checked\" /><span class=\"wpcf7-list-item-label\">Yes</span></span><span class=\"wpcf7-list-item last\"><input type=\"radio\" name=\"previous-training\" value=\"No\" /><span class=\"wpcf7-list-item-label\">No</span></span></span></span></div>\n<div><span class=\"wpcf7-form-control-wrap describe-previous-training\"><textarea name=\"describe-previous-training\" cols=\"40\" rows=\"10\" class=\"wpcf7-form-control wpcf7-textarea\" aria-invalid=\"false\" placeholder=\"Please describe.\"></textarea></span></div>\n<div></div>\n<div><span class=\"wpcf7-form-control-wrap explain-veterinarian\"><textarea name=\"explain-veterinarian\" cols=\"40\" rows=\"10\" class=\"wpcf7-form-control wpcf7-textarea\" aria-invalid=\"false\" placeholder=\"If you answered &#039;yes&#039; to the above question, please explain.\"></textarea></span></div>\n<div><span class=\"wpcf7-form-control-wrap how-long-alone\"><input type=\"text\" name=\"how-long-alone\" value=\"\" size=\"40\" class=\"wpcf7-form-control wpcf7-text\" aria-invalid=\"false\" placeholder=\"How long would you like to be able to leave your dog alone in the future?\" /></span></div>\n<div><span class=\"wpcf7-form-control-wrap additional-comments-alone\"><textarea name=\"additional-comments-alone\" cols=\"40\" rows=\"10\" class=\"wpcf7-form-control wpcf7-textarea\" aria-invalid=\"false\" placeholder=\"If you have any additional comments regarding your dog’s future alone time, please enter those here.\"></textarea></span></div>\n<p><input type=\"submit\" value=\"Send\" class=\"wpcf7-form-control wpcf7-submit\" /></p>\n<div class=\"wpcf7-response-output\" aria-hidden=\"true\"></div></form></div></div>\n			</div> <!-- .et_pb_text -->\n			</div> <!-- .et_pb_column -->\n				\n				\n			</div> <!-- .et_pb_row -->\n				\n				\n			</div> <!-- .et_pb_section --></p>\n'),
('2658', '204553', '_et_pb_truncate_post_date', '2021-06-15 13:30:23'),
('2659', '204553', '_et_pb_show_page_creation', 'off'),
('2660', '204553', 'hefo_before', '0'),
('2661', '204553', 'hefo_after', '0'),
('2663', '204562', '_et_pb_built_for_post_type', 'page'),
('2664', '204562', '_et_pb_ab_subjects', ''),
('2665', '204562', '_et_pb_ab_current_shortcode', '[et_pb_split_track id=\"204562\" /]'),
('2666', '204562', '_et_pb_gutter_width', '3'),
('2668', '204562', '_et_pb_first_image', ''),
('2669', '204562', '_et_pb_show_page_creation', 'off'),
('2670', '204562', 'hefo_before', '0'),
('2671', '204562', 'hefo_after', '0'),
('2673', '205207', 'iwp_log_type', 'scheduleBackup'),
('2674', '205207', 'iwp_log_action', 'schedule'),
('2675', '205207', 'iwp_log_activities_type', 'iwp_log'),
('2676', '205207', 'iwp_log_actions', 'backups'),
('2677', '205207', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('2678', '205208', 'iwp_log_type', 'scheduleBackup'),
('2679', '205208', 'iwp_log_action', 'schedule'),
('2680', '205208', 'iwp_log_activities_type', 'iwp_log'),
('2681', '205208', 'iwp_log_actions', 'backups'),
('2682', '205208', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('2684', '205074', 'hefo_before', '0'),
('2685', '205074', 'hefo_after', '0'),
('2687', '205212', '_wp_attached_file', '2020/08/dog-training.jpg'),
('2688', '205212', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:1500;s:6:\"height\";i:1023;s:4:\"file\";s:24:\"2020/08/dog-training.jpg\";s:5:\"sizes\";a:13:{s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"dog-training-300x205.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:205;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:25:\"dog-training-1024x698.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:698;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:24:\"dog-training-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:24:\"dog-training-768x524.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:524;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:24:\"dog-training-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:25:\"dog-training-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:24:\"dog-training-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:24:\"dog-training-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:25:\"dog-training-1080x737.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:737;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:24:\"dog-training-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"et-pb-image--responsive--desktop\";a:4:{s:4:\"file\";s:25:\"dog-training-1280x873.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:873;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-image--responsive--tablet\";a:4:{s:4:\"file\";s:24:\"dog-training-980x668.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:668;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:24:\"dog-training-480x327.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:327;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:28:\"Soloviova Liudmyla - Fotolia\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('2691', '205214', '_wp_attached_file', '2020/08/dog-training-banner.jpg'),
('2692', '205214', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:2000;s:6:\"height\";i:1333;s:4:\"file\";s:31:\"2020/08/dog-training-banner.jpg\";s:5:\"sizes\";a:14:{s:6:\"medium\";a:4:{s:4:\"file\";s:31:\"dog-training-banner-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:32:\"dog-training-banner-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"dog-training-banner-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:31:\"dog-training-banner-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:33:\"dog-training-banner-1536x1024.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:31:\"dog-training-banner-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:32:\"dog-training-banner-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:31:\"dog-training-banner-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:31:\"dog-training-banner-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:32:\"dog-training-banner-1080x720.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:720;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:31:\"dog-training-banner-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"et-pb-image--responsive--desktop\";a:4:{s:4:\"file\";s:32:\"dog-training-banner-1280x853.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:853;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-image--responsive--tablet\";a:4:{s:4:\"file\";s:31:\"dog-training-banner-980x653.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:653;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:31:\"dog-training-banner-480x320.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('2693', '205215', '_wp_attached_file', '2020/08/dog-training-banner-2.jpg'),
('2694', '205215', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:2000;s:6:\"height\";i:1118;s:4:\"file\";s:33:\"2020/08/dog-training-banner-2.jpg\";s:5:\"sizes\";a:14:{s:6:\"medium\";a:4:{s:4:\"file\";s:33:\"dog-training-banner-2-300x168.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:168;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:34:\"dog-training-banner-2-1024x572.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:572;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"dog-training-banner-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:33:\"dog-training-banner-2-768x429.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:429;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:34:\"dog-training-banner-2-1536x859.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:859;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:33:\"dog-training-banner-2-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:34:\"dog-training-banner-2-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:33:\"dog-training-banner-2-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:33:\"dog-training-banner-2-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:34:\"dog-training-banner-2-1080x604.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:604;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:33:\"dog-training-banner-2-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"et-pb-image--responsive--desktop\";a:4:{s:4:\"file\";s:34:\"dog-training-banner-2-1280x716.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:716;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-image--responsive--tablet\";a:4:{s:4:\"file\";s:33:\"dog-training-banner-2-980x548.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:548;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:33:\"dog-training-banner-2-480x268.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:268;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('2698', '205217', 'iwp_log_type', 'plugins'),
('2699', '205217', 'iwp_log_action', 'update'),
('2700', '205217', 'iwp_log_activities_type', 'automatic'),
('2701', '205217', 'iwp_log_actions', 'plugins-updated'),
('2702', '205217', 'iwp_log_details', 'a:4:{s:4:\"name\";s:14:\"ActiveCampaign\";s:4:\"slug\";s:52:\"activecampaign-subscription-forms/activecampaign.php\";s:11:\"old_version\";s:5:\"7.1.3\";s:15:\"updated_version\";s:5:\"8.0.1\";}'),
('2703', '205218', 'iwp_log_type', 'plugins'),
('2704', '205218', 'iwp_log_action', 'update'),
('2705', '205218', 'iwp_log_activities_type', 'automatic'),
('2706', '205218', 'iwp_log_actions', 'plugins-updated'),
('2707', '205218', 'iwp_log_details', 'a:4:{s:4:\"name\";s:14:\"Classic Editor\";s:4:\"slug\";s:33:\"classic-editor/classic-editor.php\";s:11:\"old_version\";s:3:\"1.5\";s:15:\"updated_version\";s:3:\"1.6\";}'),
('2708', '205219', 'iwp_log_type', 'plugins'),
('2709', '205219', 'iwp_log_action', 'update'),
('2710', '205219', 'iwp_log_activities_type', 'direct'),
('2711', '205219', 'iwp_log_actions', 'plugins-updated'),
('2712', '205219', 'iwp_log_details', 'a:4:{s:4:\"name\";s:26:\"Advanced Custom Fields PRO\";s:4:\"slug\";s:34:\"advanced-custom-fields-pro/acf.php\";s:11:\"old_version\";s:6:\"5.8.12\";s:15:\"updated_version\";s:5:\"5.9.0\";}'),
('2713', '205220', 'iwp_log_type', 'plugins'),
('2714', '205220', 'iwp_log_action', 'update'),
('2715', '205220', 'iwp_log_activities_type', 'direct'),
('2716', '205220', 'iwp_log_actions', 'plugins-updated'),
('2717', '205220', 'iwp_log_details', 'a:4:{s:4:\"name\";s:16:\"iThemes Security\";s:4:\"slug\";s:41:\"better-wp-security/better-wp-security.php\";s:11:\"old_version\";s:5:\"7.7.1\";s:15:\"updated_version\";s:5:\"7.8.0\";}'),
('2718', '205221', 'iwp_log_type', 'plugins'),
('2719', '205221', 'iwp_log_action', 'update'),
('2720', '205221', 'iwp_log_activities_type', 'direct'),
('2721', '205221', 'iwp_log_actions', 'plugins-updated'),
('2722', '205221', 'iwp_log_details', 'a:4:{s:4:\"name\";s:23:\"Official Facebook Pixel\";s:4:\"slug\";s:50:\"official-facebook-pixel/facebook-for-wordpress.php\";s:11:\"old_version\";s:5:\"2.1.0\";s:15:\"updated_version\";s:5:\"2.2.0\";}'),
('2723', '205222', 'iwp_log_type', 'core'),
('2724', '205222', 'iwp_log_action', 'update'),
('2725', '205222', 'iwp_log_activities_type', 'direct'),
('2726', '205222', 'iwp_log_actions', 'core-updated'),
('2727', '205222', 'iwp_log_details', 'a:2:{s:11:\"old_version\";s:5:\"5.4.2\";s:15:\"updated_version\";s:3:\"5.5\";}'),
('2728', '205223', 'iwp_log_type', 'plugins'),
('2729', '205223', 'iwp_log_action', 'update'),
('2730', '205223', 'iwp_log_activities_type', 'automatic'),
('2731', '205223', 'iwp_log_actions', 'plugins-updated'),
('2732', '205223', 'iwp_log_details', 'a:4:{s:4:\"name\";s:14:\"Contact Form 7\";s:4:\"slug\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"old_version\";s:5:\"5.2.1\";s:15:\"updated_version\";s:5:\"5.2.2\";}'),
('2733', '205224', 'iwp_log_type', 'plugins'),
('2734', '205224', 'iwp_log_action', 'update'),
('2735', '205224', 'iwp_log_activities_type', 'automatic'),
('2736', '205224', 'iwp_log_actions', 'plugins-updated'),
('2737', '205224', 'iwp_log_details', 'a:4:{s:4:\"name\";s:19:\"Custom Post Type UI\";s:4:\"slug\";s:43:\"custom-post-type-ui/custom-post-type-ui.php\";s:11:\"old_version\";s:5:\"1.7.4\";s:15:\"updated_version\";s:5:\"1.8.0\";}'),
('2738', '205225', 'iwp_log_type', 'plugins'),
('2739', '205225', 'iwp_log_action', 'update'),
('2740', '205225', 'iwp_log_activities_type', 'automatic'),
('2741', '205225', 'iwp_log_actions', 'plugins-updated'),
('2742', '205225', 'iwp_log_details', 'a:4:{s:4:\"name\";s:16:\"Post Types Order\";s:4:\"slug\";s:37:\"post-types-order/post-types-order.php\";s:11:\"old_version\";s:7:\"1.9.5.1\";s:15:\"updated_version\";s:7:\"1.9.5.2\";}'),
('2743', '205226', 'iwp_log_type', 'scheduleBackup'),
('2744', '205226', 'iwp_log_action', 'schedule'),
('2745', '205226', 'iwp_log_activities_type', 'iwp_log'),
('2746', '205226', 'iwp_log_actions', 'backups'),
('2747', '205226', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('2748', '205227', 'iwp_log_type', 'plugins'),
('2749', '205227', 'iwp_log_action', 'update'),
('2750', '205227', 'iwp_log_activities_type', 'automatic'),
('2751', '205227', 'iwp_log_actions', 'plugins-updated'),
('2752', '205227', 'iwp_log_details', 'a:4:{s:4:\"name\";s:18:\"WPMU DEV Dashboard\";s:4:\"slug\";s:40:\"wpmudev-updates/update-notifications.php\";s:11:\"old_version\";s:6:\"4.10.0\";s:15:\"updated_version\";s:6:\"4.10.1\";}'),
('2753', '205230', '_wp_attached_file', '2020/08/walk-with-my-dog-cropped-scaled.jpg'),
('2754', '205230', '_wp_attachment_metadata', 'a:6:{s:5:\"width\";i:1963;s:6:\"height\";i:2560;s:4:\"file\";s:43:\"2020/08/walk-with-my-dog-cropped-scaled.jpg\";s:5:\"sizes\";a:15:{s:6:\"medium\";a:4:{s:4:\"file\";s:36:\"walk-with-my-dog-cropped-230x300.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:37:\"walk-with-my-dog-cropped-785x1024.jpg\";s:5:\"width\";i:785;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"walk-with-my-dog-cropped-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:37:\"walk-with-my-dog-cropped-768x1002.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:1002;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:38:\"walk-with-my-dog-cropped-1178x1536.jpg\";s:5:\"width\";i:1178;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"2048x2048\";a:4:{s:4:\"file\";s:38:\"walk-with-my-dog-cropped-1570x2048.jpg\";s:5:\"width\";i:1570;s:6:\"height\";i:2048;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:36:\"walk-with-my-dog-cropped-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:37:\"walk-with-my-dog-cropped-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:36:\"walk-with-my-dog-cropped-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:36:\"walk-with-my-dog-cropped-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:38:\"walk-with-my-dog-cropped-1080x1409.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:1409;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:36:\"walk-with-my-dog-cropped-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:37:\"et-pb-post-main-image-fullwidth-large\";a:4:{s:4:\"file\";s:38:\"walk-with-my-dog-cropped-2880x1800.jpg\";s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-image--responsive--tablet\";a:4:{s:4:\"file\";s:37:\"walk-with-my-dog-cropped-980x1278.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:1278;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:36:\"walk-with-my-dog-cropped-480x626.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:626;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:3:\"3.5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:20:\"Canon EOS 5D Mark IV\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1526361876\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"50\";s:3:\"iso\";s:3:\"125\";s:13:\"shutter_speed\";s:7:\"0.00625\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:28:\"walk-with-my-dog-cropped.jpg\";}'),
('2755', '205231', '_wp_attached_file', '2020/08/walk-with-my-dog-cropped-1.jpg'),
('2756', '205231', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:520;s:6:\"height\";i:678;s:4:\"file\";s:38:\"2020/08/walk-with-my-dog-cropped-1.jpg\";s:5:\"sizes\";a:8:{s:6:\"medium\";a:4:{s:4:\"file\";s:38:\"walk-with-my-dog-cropped-1-230x300.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:38:\"walk-with-my-dog-cropped-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:38:\"walk-with-my-dog-cropped-1-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:38:\"walk-with-my-dog-cropped-1-520x675.jpg\";s:5:\"width\";i:520;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:38:\"walk-with-my-dog-cropped-1-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:38:\"walk-with-my-dog-cropped-1-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:38:\"walk-with-my-dog-cropped-1-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:38:\"walk-with-my-dog-cropped-1-480x626.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:626;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('2757', '205232', '_wp_attached_file', '2020/08/puppy-run.jpg'),
('2758', '205232', '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:520;s:6:\"height\";i:494;s:4:\"file\";s:21:\"2020/08/puppy-run.jpg\";s:5:\"sizes\";a:7:{s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"puppy-run-300x285.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:285;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"puppy-run-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:21:\"puppy-run-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:21:\"puppy-run-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:21:\"puppy-run-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:21:\"puppy-run-400x494.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:494;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:21:\"puppy-run-480x456.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:456;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
('2760', '204559', 'hefo_before', '0'),
('2761', '204559', 'hefo_after', '0'),
('2763', '205241', 'iwp_log_type', 'plugins'),
('2764', '205241', 'iwp_log_action', 'update'),
('2765', '205241', 'iwp_log_activities_type', 'automatic'),
('2766', '205241', 'iwp_log_actions', 'plugins-updated'),
('2767', '205241', 'iwp_log_details', 'a:4:{s:4:\"name\";s:14:\"Duplicate Page\";s:4:\"slug\";s:32:\"duplicate-page/duplicatepage.php\";s:11:\"old_version\";s:3:\"4.2\";s:15:\"updated_version\";s:3:\"4.3\";}'),
('2768', '205242', 'iwp_log_type', 'plugins'),
('2769', '205242', 'iwp_log_action', 'update'),
('2770', '205242', 'iwp_log_activities_type', 'automatic'),
('2771', '205242', 'iwp_log_actions', 'plugins-updated'),
('2772', '205242', 'iwp_log_details', 'a:4:{s:4:\"name\";s:30:\"YIKES Simple Taxonomy Ordering\";s:4:\"slug\";s:56:\"simple-taxonomy-ordering/yikes-custom-taxonomy-order.php\";s:11:\"old_version\";s:5:\"2.3.1\";s:15:\"updated_version\";s:5:\"2.3.2\";}'),
('2773', '205245', '_wp_attached_file', '2020/09/golden-retriever-puppy-scaled.jpg'),
('2774', '205245', '_wp_attachment_metadata', 'a:6:{s:5:\"width\";i:2427;s:6:\"height\";i:2560;s:4:\"file\";s:41:\"2020/09/golden-retriever-puppy-scaled.jpg\";s:5:\"sizes\";a:16:{s:6:\"medium\";a:4:{s:4:\"file\";s:34:\"golden-retriever-puppy-284x300.jpg\";s:5:\"width\";i:284;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:35:\"golden-retriever-puppy-971x1024.jpg\";s:5:\"width\";i:971;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:34:\"golden-retriever-puppy-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:34:\"golden-retriever-puppy-768x810.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:810;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"1536x1536\";a:4:{s:4:\"file\";s:36:\"golden-retriever-puppy-1456x1536.jpg\";s:5:\"width\";i:1456;s:6:\"height\";i:1536;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"2048x2048\";a:4:{s:4:\"file\";s:36:\"golden-retriever-puppy-1942x2048.jpg\";s:5:\"width\";i:1942;s:6:\"height\";i:2048;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:34:\"golden-retriever-puppy-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:35:\"golden-retriever-puppy-1080x675.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:675;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:34:\"golden-retriever-puppy-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:34:\"golden-retriever-puppy-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:28:\"et-pb-portfolio-image-single\";a:4:{s:4:\"file\";s:36:\"golden-retriever-puppy-1080x1139.jpg\";s:5:\"width\";i:1080;s:6:\"height\";i:1139;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:34:\"golden-retriever-puppy-400x516.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:37:\"et-pb-post-main-image-fullwidth-large\";a:4:{s:4:\"file\";s:36:\"golden-retriever-puppy-2880x1800.jpg\";s:5:\"width\";i:2880;s:6:\"height\";i:1800;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:32:\"et-pb-image--responsive--desktop\";a:4:{s:4:\"file\";s:36:\"golden-retriever-puppy-1280x1350.jpg\";s:5:\"width\";i:1280;s:6:\"height\";i:1350;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:31:\"et-pb-image--responsive--tablet\";a:4:{s:4:\"file\";s:35:\"golden-retriever-puppy-980x1034.jpg\";s:5:\"width\";i:980;s:6:\"height\";i:1034;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:34:\"golden-retriever-puppy-480x506.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:506;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:26:\"golden-retriever-puppy.jpg\";}'),
('2776', '205247', 'iwp_log_type', 'plugins'),
('2777', '205247', 'iwp_log_action', 'update'),
('2778', '205247', 'iwp_log_activities_type', 'automatic'),
('2779', '205247', 'iwp_log_actions', 'plugins-updated'),
('2780', '205247', 'iwp_log_details', 'a:4:{s:4:\"name\";s:12:\"Snapshot Pro\";s:4:\"slug\";s:37:\"snapshot-backups/snapshot-backups.php\";s:11:\"old_version\";s:5:\"4.0.2\";s:15:\"updated_version\";s:5:\"4.0.3\";}'),
('2781', '205248', 'iwp_log_type', 'scheduleBackup'),
('2782', '205248', 'iwp_log_action', 'schedule'),
('2783', '205248', 'iwp_log_activities_type', 'iwp_log'),
('2784', '205248', 'iwp_log_actions', 'backups'),
('2785', '205248', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('2786', '205249', 'iwp_log_type', 'core'),
('2787', '205249', 'iwp_log_action', 'update'),
('2788', '205249', 'iwp_log_activities_type', 'iwp_log'),
('2789', '205249', 'iwp_log_actions', 'core-updated'),
('2790', '205249', 'iwp_log_details', 'a:2:{s:11:\"old_version\";s:3:\"5.5\";s:15:\"updated_version\";s:5:\"5.5.1\";}'),
('2791', '205250', 'iwp_log_type', 'plugins'),
('2792', '205250', 'iwp_log_action', 'update'),
('2793', '205250', 'iwp_log_activities_type', 'automatic'),
('2794', '205250', 'iwp_log_actions', 'plugins-updated'),
('2795', '205250', 'iwp_log_details', 'a:4:{s:4:\"name\";s:14:\"ActiveCampaign\";s:4:\"slug\";s:52:\"activecampaign-subscription-forms/activecampaign.php\";s:11:\"old_version\";s:5:\"8.0.1\";s:15:\"updated_version\";s:5:\"8.0.2\";}'),
('2796', '205251', 'iwp_log_type', 'plugins'),
('2797', '205251', 'iwp_log_action', 'update'),
('2798', '205251', 'iwp_log_activities_type', 'automatic'),
('2799', '205251', 'iwp_log_actions', 'plugins-updated'),
('2800', '205251', 'iwp_log_details', 'a:4:{s:4:\"name\";s:26:\"Advanced Custom Fields PRO\";s:4:\"slug\";s:34:\"advanced-custom-fields-pro/acf.php\";s:11:\"old_version\";s:5:\"5.9.0\";s:15:\"updated_version\";s:5:\"5.9.1\";}'),
('2801', '205252', 'iwp_log_type', 'plugins'),
('2802', '205252', 'iwp_log_action', 'update'),
('2803', '205252', 'iwp_log_activities_type', 'automatic'),
('2804', '205252', 'iwp_log_actions', 'plugins-updated'),
('2805', '205252', 'iwp_log_details', 'a:4:{s:4:\"name\";s:18:\"WPMU DEV Dashboard\";s:4:\"slug\";s:40:\"wpmudev-updates/update-notifications.php\";s:11:\"old_version\";s:6:\"4.10.1\";s:15:\"updated_version\";s:6:\"4.10.2\";}'),
('2806', '205253', 'iwp_log_type', 'scheduleBackup'),
('2807', '205253', 'iwp_log_action', 'schedule'),
('2808', '205253', 'iwp_log_activities_type', 'iwp_log'),
('2809', '205253', 'iwp_log_actions', 'backups'),
('2810', '205253', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('2811', '205254', 'iwp_log_type', 'plugins'),
('2812', '205254', 'iwp_log_action', 'update'),
('2813', '205254', 'iwp_log_activities_type', 'automatic'),
('2814', '205254', 'iwp_log_actions', 'plugins-updated'),
('2815', '205254', 'iwp_log_details', 'a:4:{s:4:\"name\";s:14:\"ActiveCampaign\";s:4:\"slug\";s:52:\"activecampaign-subscription-forms/activecampaign.php\";s:11:\"old_version\";s:5:\"8.0.2\";s:15:\"updated_version\";s:5:\"8.0.3\";}'),
('2816', '205255', 'iwp_log_type', 'scheduleBackup'),
('2817', '205255', 'iwp_log_action', 'schedule'),
('2818', '205255', 'iwp_log_activities_type', 'iwp_log'),
('2819', '205255', 'iwp_log_actions', 'backups'),
('2820', '205255', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('2821', '205256', 'iwp_log_type', 'plugins'),
('2822', '205256', 'iwp_log_action', 'update'),
('2823', '205256', 'iwp_log_activities_type', 'automatic'),
('2824', '205256', 'iwp_log_actions', 'plugins-updated'),
('2825', '205256', 'iwp_log_details', 'a:4:{s:4:\"name\";s:18:\"WPMU DEV Dashboard\";s:4:\"slug\";s:40:\"wpmudev-updates/update-notifications.php\";s:11:\"old_version\";s:6:\"4.10.2\";s:15:\"updated_version\";s:6:\"4.10.3\";}'),
('2826', '205257', 'iwp_log_type', 'scheduleBackup'),
('2827', '205257', 'iwp_log_action', 'schedule'),
('2828', '205257', 'iwp_log_activities_type', 'iwp_log'),
('2829', '205257', 'iwp_log_actions', 'backups'),
('2830', '205257', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('2831', '205258', 'iwp_log_type', 'plugins'),
('2832', '205258', 'iwp_log_action', 'update'),
('2833', '205258', 'iwp_log_activities_type', 'automatic'),
('2834', '205258', 'iwp_log_actions', 'plugins-updated'),
('2835', '205258', 'iwp_log_details', 'a:4:{s:4:\"name\";s:19:\"Custom Post Type UI\";s:4:\"slug\";s:43:\"custom-post-type-ui/custom-post-type-ui.php\";s:11:\"old_version\";s:5:\"1.8.0\";s:15:\"updated_version\";s:5:\"1.8.1\";}'),
('2836', '205259', 'iwp_log_type', 'scheduleBackup'),
('2837', '205259', 'iwp_log_action', 'schedule'),
('2838', '205259', 'iwp_log_activities_type', 'iwp_log'),
('2839', '205259', 'iwp_log_actions', 'backups'),
('2840', '205259', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('2841', '205260', 'iwp_log_type', 'plugins'),
('2842', '205260', 'iwp_log_action', 'update'),
('2843', '205260', 'iwp_log_activities_type', 'iwp_log'),
('2844', '205260', 'iwp_log_actions', 'plugins-updated'),
('2845', '205260', 'iwp_log_details', 'a:4:{s:4:\"name\";s:17:\"WP Migrate DB Pro\";s:4:\"slug\";s:17:\"wp-migrate-db-pro\";s:11:\"old_version\";s:6:\"1.9.12\";s:15:\"updated_version\";s:6:\"1.9.13\";}'),
('2846', '205261', 'iwp_log_type', 'plugins'),
('2847', '205261', 'iwp_log_action', 'update'),
('2848', '205261', 'iwp_log_activities_type', 'automatic'),
('2849', '205261', 'iwp_log_actions', 'plugins-updated'),
('2850', '205261', 'iwp_log_details', 'a:4:{s:4:\"name\";s:18:\"WPMU DEV Dashboard\";s:4:\"slug\";s:40:\"wpmudev-updates/update-notifications.php\";s:11:\"old_version\";s:6:\"4.10.3\";s:15:\"updated_version\";s:6:\"4.10.4\";}'),
('2851', '205262', 'iwp_log_type', 'plugins'),
('2852', '205262', 'iwp_log_action', 'update'),
('2853', '205262', 'iwp_log_activities_type', 'automatic'),
('2854', '205262', 'iwp_log_actions', 'plugins-updated'),
('2855', '205262', 'iwp_log_details', 'a:4:{s:4:\"name\";s:18:\"WPMU DEV Dashboard\";s:4:\"slug\";s:40:\"wpmudev-updates/update-notifications.php\";s:11:\"old_version\";s:6:\"4.10.4\";s:15:\"updated_version\";s:6:\"4.10.5\";}'),
('2856', '205263', 'iwp_log_type', 'scheduleBackup'),
('2857', '205263', 'iwp_log_action', 'schedule'),
('2858', '205263', 'iwp_log_activities_type', 'iwp_log'),
('2859', '205263', 'iwp_log_actions', 'backups'),
('2860', '205263', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('2861', '205264', 'iwp_log_type', 'scheduleBackup'),
('2862', '205264', 'iwp_log_action', 'schedule'),
('2863', '205264', 'iwp_log_activities_type', 'iwp_log'),
('2864', '205264', 'iwp_log_actions', 'backups'),
('2865', '205264', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('2866', '205265', 'iwp_log_type', 'plugins'),
('2867', '205265', 'iwp_log_action', 'update'),
('2868', '205265', 'iwp_log_activities_type', 'automatic'),
('2869', '205265', 'iwp_log_actions', 'plugins-updated'),
('2870', '205265', 'iwp_log_details', 'a:4:{s:4:\"name\";s:12:\"Snapshot Pro\";s:4:\"slug\";s:37:\"snapshot-backups/snapshot-backups.php\";s:11:\"old_version\";s:5:\"4.0.3\";s:15:\"updated_version\";s:5:\"4.1.1\";}'),
('2871', '205266', 'iwp_log_type', 'plugins'),
('2872', '205266', 'iwp_log_action', 'update'),
('2873', '205266', 'iwp_log_activities_type', 'automatic'),
('2874', '205266', 'iwp_log_actions', 'plugins-updated'),
('2875', '205266', 'iwp_log_details', 'a:4:{s:4:\"name\";s:16:\"iThemes Security\";s:4:\"slug\";s:41:\"better-wp-security/better-wp-security.php\";s:11:\"old_version\";s:5:\"7.8.0\";s:15:\"updated_version\";s:5:\"7.9.0\";}'),
('2876', '205267', 'iwp_log_type', 'scheduleBackup'),
('2877', '205267', 'iwp_log_action', 'schedule'),
('2878', '205267', 'iwp_log_activities_type', 'iwp_log'),
('2879', '205267', 'iwp_log_actions', 'backups'),
('2880', '205267', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('2881', '205268', 'iwp_log_type', 'plugins'),
('2882', '205268', 'iwp_log_action', 'update'),
('2883', '205268', 'iwp_log_activities_type', 'automatic'),
('2884', '205268', 'iwp_log_actions', 'plugins-updated'),
('2885', '205268', 'iwp_log_details', 'a:4:{s:4:\"name\";s:14:\"Contact Form 7\";s:4:\"slug\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"old_version\";s:5:\"5.2.2\";s:15:\"updated_version\";s:3:\"5.3\";}'),
('2886', '205269', 'iwp_log_type', 'scheduleBackup'),
('2887', '205269', 'iwp_log_action', 'schedule'),
('2888', '205269', 'iwp_log_activities_type', 'iwp_log'),
('2889', '205269', 'iwp_log_actions', 'backups'),
('2890', '205269', 'iwp_log_details', 'a:16:{s:11:\"backup_name\";s:6:\"Weekly\";s:5:\"limit\";s:1:\"5\";s:12:\"disable_comp\";s:1:\"1\";s:15:\"optimize_tables\";s:0:\"\";s:4:\"what\";s:4:\"full\";s:7:\"exclude\";a:1:{i:0;s:0:\"\";}s:18:\"exclude_extensions\";s:0:\"\";s:17:\"exclude_file_size\";i:50;s:7:\"include\";a:1:{i:0;s:10:\"wp-content\";}s:9:\"mechanism\";s:9:\"multiCall\";s:15:\"fail_safe_files\";s:0:\"\";s:12:\"fail_safe_db\";s:0:\"\";s:13:\"del_host_file\";s:1:\"1\";s:16:\"backup_repo_type\";s:0:\"\";s:4:\"when\";s:0:\"\";s:2:\"at\";s:0:\"\";}'),
('2891', '205270', 'iwp_log_type', 'plugins'),
('2892', '205270', 'iwp_log_action', 'update'),
('2893', '205270', 'iwp_log_activities_type', 'iwp_log'),
('2894', '205270', 'iwp_log_actions', 'plugins-updated'),
('2895', '205270', 'iwp_log_details', 'a:4:{s:4:\"name\";s:26:\"Advanced Custom Fields PRO\";s:4:\"slug\";s:26:\"advanced-custom-fields-pro\";s:11:\"old_version\";s:5:\"5.9.1\";s:15:\"updated_version\";s:5:\"5.9.2\";}'),
('2896', '205271', 'iwp_log_type', 'core'),
('2897', '205271', 'iwp_log_action', 'update'),
('2898', '205271', 'iwp_log_activities_type', 'iwp_log'),
('2899', '205271', 'iwp_log_actions', 'core-updated'),
('2900', '205271', 'iwp_log_details', 'a:2:{s:11:\"old_version\";s:5:\"5.5.1\";s:15:\"updated_version\";s:5:\"5.5.2\";}'),
('2901', '204868', '_oembed_81b7413cdb046f4070fd5947b9c94cd5', '<iframe title=\"dog walks on lead with focus 3\" width=\"640\" height=\"360\" src=\"https://www.youtube.com/embed/VK8Uybu-Bkc?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe>'),
('2902', '204868', '_oembed_time_81b7413cdb046f4070fd5947b9c94cd5', '1607785754'),
('2903', '204859', '_oembed_7b9069dd804b06d3eac943a92098ccd5', '<iframe title=\"teach your dog to look at you step 1\" width=\"640\" height=\"360\" src=\"https://www.youtube.com/embed/ExxNlTxV4WY?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen></iframe>'),
('2904', '204859', '_oembed_time_7b9069dd804b06d3eac943a92098ccd5', '1607860974');
/**ABDB**/DROP TABLE IF EXISTS `wp_options`;
/**ABDB**/CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `wpe_autoload_options_index` (`autoload`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=89395 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `wp_options`  VALUES 
('1', 'siteurl', 'https://jhdogtraining.com.au', 'yes'),
('2', 'home', 'https://jhdogtraining.com.au', 'yes'),
('3', 'blogname', 'Jenny Harlow', 'yes'),
('4', 'blogdescription', 'DOG TRAINING', 'yes'),
('5', 'users_can_register', '0', 'yes'),
('6', 'admin_email', 'jennyharlow@bigpond.com', 'yes'),
('7', 'start_of_week', '1', 'yes'),
('8', 'use_balanceTags', '0', 'yes'),
('9', 'use_smilies', '1', 'yes'),
('10', 'require_name_email', '1', 'yes'),
('11', 'comments_notify', '1', 'yes'),
('12', 'posts_per_rss', '10', 'yes'),
('13', 'rss_use_excerpt', '0', 'yes'),
('14', 'mailserver_url', 'mail.example.com', 'yes'),
('15', 'mailserver_login', 'login@example.com', 'yes'),
('16', 'mailserver_pass', 'password', 'yes'),
('17', 'mailserver_port', '110', 'yes'),
('18', 'default_category', '1', 'yes'),
('19', 'default_comment_status', 'open', 'yes'),
('20', 'default_ping_status', 'open', 'yes'),
('21', 'default_pingback_flag', '0', 'yes'),
('22', 'posts_per_page', '10', 'yes'),
('23', 'date_format', 'F j, Y', 'yes'),
('24', 'time_format', 'g:i a', 'yes'),
('25', 'links_updated_date_format', 'F j, Y g:i a', 'yes'),
('26', 'comment_moderation', '0', 'yes'),
('27', 'moderation_notify', '1', 'yes'),
('28', 'permalink_structure', '/%postname%/', 'yes'),
('29', 'rewrite_rules', 'a:327:{s:10:\"project/?$\";s:27:\"index.php?post_type=project\";s:40:\"project/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=project&feed=$matches[1]\";s:35:\"project/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=project&feed=$matches[1]\";s:27:\"project/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=project&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:9:\"videos/?$\";s:26:\"index.php?post_type=videos\";s:39:\"videos/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?post_type=videos&feed=$matches[1]\";s:34:\"videos/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?post_type=videos&feed=$matches[1]\";s:26:\"videos/page/([0-9]{1,})/?$\";s:44:\"index.php?post_type=videos&paged=$matches[1]\";s:12:\"pr_videos/?$\";s:29:\"index.php?post_type=pr_videos\";s:42:\"pr_videos/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=pr_videos&feed=$matches[1]\";s:37:\"pr_videos/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=pr_videos&feed=$matches[1]\";s:29:\"pr_videos/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=pr_videos&paged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:56:\"layout_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:68:\"index.php?taxonomy=layout_category&term=$matches[1]&feed=$matches[2]\";s:51:\"layout_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:68:\"index.php?taxonomy=layout_category&term=$matches[1]&feed=$matches[2]\";s:32:\"layout_category/([^/]+)/embed/?$\";s:62:\"index.php?taxonomy=layout_category&term=$matches[1]&embed=true\";s:44:\"layout_category/([^/]+)/page/?([0-9]{1,})/?$\";s:69:\"index.php?taxonomy=layout_category&term=$matches[1]&paged=$matches[2]\";s:26:\"layout_category/([^/]+)/?$\";s:51:\"index.php?taxonomy=layout_category&term=$matches[1]\";s:52:\"layout_pack/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?taxonomy=layout_pack&term=$matches[1]&feed=$matches[2]\";s:47:\"layout_pack/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?taxonomy=layout_pack&term=$matches[1]&feed=$matches[2]\";s:28:\"layout_pack/([^/]+)/embed/?$\";s:58:\"index.php?taxonomy=layout_pack&term=$matches[1]&embed=true\";s:40:\"layout_pack/([^/]+)/page/?([0-9]{1,})/?$\";s:65:\"index.php?taxonomy=layout_pack&term=$matches[1]&paged=$matches[2]\";s:22:\"layout_pack/([^/]+)/?$\";s:47:\"index.php?taxonomy=layout_pack&term=$matches[1]\";s:52:\"layout_type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?taxonomy=layout_type&term=$matches[1]&feed=$matches[2]\";s:47:\"layout_type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?taxonomy=layout_type&term=$matches[1]&feed=$matches[2]\";s:28:\"layout_type/([^/]+)/embed/?$\";s:58:\"index.php?taxonomy=layout_type&term=$matches[1]&embed=true\";s:40:\"layout_type/([^/]+)/page/?([0-9]{1,})/?$\";s:65:\"index.php?taxonomy=layout_type&term=$matches[1]&paged=$matches[2]\";s:22:\"layout_type/([^/]+)/?$\";s:47:\"index.php?taxonomy=layout_type&term=$matches[1]\";s:46:\"scope/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?taxonomy=scope&term=$matches[1]&feed=$matches[2]\";s:41:\"scope/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?taxonomy=scope&term=$matches[1]&feed=$matches[2]\";s:22:\"scope/([^/]+)/embed/?$\";s:52:\"index.php?taxonomy=scope&term=$matches[1]&embed=true\";s:34:\"scope/([^/]+)/page/?([0-9]{1,})/?$\";s:59:\"index.php?taxonomy=scope&term=$matches[1]&paged=$matches[2]\";s:16:\"scope/([^/]+)/?$\";s:41:\"index.php?taxonomy=scope&term=$matches[1]\";s:53:\"module_width/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:65:\"index.php?taxonomy=module_width&term=$matches[1]&feed=$matches[2]\";s:48:\"module_width/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:65:\"index.php?taxonomy=module_width&term=$matches[1]&feed=$matches[2]\";s:29:\"module_width/([^/]+)/embed/?$\";s:59:\"index.php?taxonomy=module_width&term=$matches[1]&embed=true\";s:41:\"module_width/([^/]+)/page/?([0-9]{1,})/?$\";s:66:\"index.php?taxonomy=module_width&term=$matches[1]&paged=$matches[2]\";s:23:\"module_width/([^/]+)/?$\";s:48:\"index.php?taxonomy=module_width&term=$matches[1]\";s:40:\"et_pb_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"et_pb_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"et_pb_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"et_pb_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"et_pb_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"et_pb_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"et_pb_layout/([^/]+)/embed/?$\";s:60:\"index.php?post_type=et_pb_layout&name=$matches[1]&embed=true\";s:33:\"et_pb_layout/([^/]+)/trackback/?$\";s:54:\"index.php?post_type=et_pb_layout&name=$matches[1]&tb=1\";s:41:\"et_pb_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:67:\"index.php?post_type=et_pb_layout&name=$matches[1]&paged=$matches[2]\";s:48:\"et_pb_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:67:\"index.php?post_type=et_pb_layout&name=$matches[1]&cpage=$matches[2]\";s:37:\"et_pb_layout/([^/]+)(?:/([0-9]+))?/?$\";s:66:\"index.php?post_type=et_pb_layout&name=$matches[1]&page=$matches[2]\";s:29:\"et_pb_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"et_pb_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"et_pb_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"et_pb_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"et_pb_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"et_pb_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"project/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"project/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"project/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"project/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"project/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"project/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"project/([^/]+)/embed/?$\";s:40:\"index.php?project=$matches[1]&embed=true\";s:28:\"project/([^/]+)/trackback/?$\";s:34:\"index.php?project=$matches[1]&tb=1\";s:48:\"project/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?project=$matches[1]&feed=$matches[2]\";s:43:\"project/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?project=$matches[1]&feed=$matches[2]\";s:36:\"project/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?project=$matches[1]&paged=$matches[2]\";s:43:\"project/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?project=$matches[1]&cpage=$matches[2]\";s:32:\"project/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?project=$matches[1]&page=$matches[2]\";s:24:\"project/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"project/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"project/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"project/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"project/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"project/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:57:\"project_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?project_category=$matches[1]&feed=$matches[2]\";s:52:\"project_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?project_category=$matches[1]&feed=$matches[2]\";s:33:\"project_category/([^/]+)/embed/?$\";s:49:\"index.php?project_category=$matches[1]&embed=true\";s:45:\"project_category/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?project_category=$matches[1]&paged=$matches[2]\";s:27:\"project_category/([^/]+)/?$\";s:38:\"index.php?project_category=$matches[1]\";s:52:\"project_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project_tag=$matches[1]&feed=$matches[2]\";s:47:\"project_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project_tag=$matches[1]&feed=$matches[2]\";s:28:\"project_tag/([^/]+)/embed/?$\";s:44:\"index.php?project_tag=$matches[1]&embed=true\";s:40:\"project_tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?project_tag=$matches[1]&paged=$matches[2]\";s:22:\"project_tag/([^/]+)/?$\";s:33:\"index.php?project_tag=$matches[1]\";s:52:\"video_types/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?video_types=$matches[1]&feed=$matches[2]\";s:47:\"video_types/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?video_types=$matches[1]&feed=$matches[2]\";s:28:\"video_types/([^/]+)/embed/?$\";s:44:\"index.php?video_types=$matches[1]&embed=true\";s:40:\"video_types/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?video_types=$matches[1]&paged=$matches[2]\";s:22:\"video_types/([^/]+)/?$\";s:33:\"index.php?video_types=$matches[1]\";s:55:\"pr_video_types/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?pr_video_types=$matches[1]&feed=$matches[2]\";s:50:\"pr_video_types/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?pr_video_types=$matches[1]&feed=$matches[2]\";s:31:\"pr_video_types/([^/]+)/embed/?$\";s:47:\"index.php?pr_video_types=$matches[1]&embed=true\";s:43:\"pr_video_types/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?pr_video_types=$matches[1]&paged=$matches[2]\";s:25:\"pr_video_types/([^/]+)/?$\";s:36:\"index.php?pr_video_types=$matches[1]\";s:34:\"videos/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"videos/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"videos/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"videos/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"videos/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"videos/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"videos/([^/]+)/embed/?$\";s:39:\"index.php?videos=$matches[1]&embed=true\";s:27:\"videos/([^/]+)/trackback/?$\";s:33:\"index.php?videos=$matches[1]&tb=1\";s:47:\"videos/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?videos=$matches[1]&feed=$matches[2]\";s:42:\"videos/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?videos=$matches[1]&feed=$matches[2]\";s:35:\"videos/([^/]+)/page/?([0-9]{1,})/?$\";s:46:\"index.php?videos=$matches[1]&paged=$matches[2]\";s:42:\"videos/([^/]+)/comment-page-([0-9]{1,})/?$\";s:46:\"index.php?videos=$matches[1]&cpage=$matches[2]\";s:31:\"videos/([^/]+)(?:/([0-9]+))?/?$\";s:45:\"index.php?videos=$matches[1]&page=$matches[2]\";s:23:\"videos/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"videos/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"videos/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"videos/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"videos/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:29:\"videos/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:37:\"pr_videos/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"pr_videos/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"pr_videos/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"pr_videos/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"pr_videos/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"pr_videos/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"pr_videos/([^/]+)/embed/?$\";s:42:\"index.php?pr_videos=$matches[1]&embed=true\";s:30:\"pr_videos/([^/]+)/trackback/?$\";s:36:\"index.php?pr_videos=$matches[1]&tb=1\";s:50:\"pr_videos/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?pr_videos=$matches[1]&feed=$matches[2]\";s:45:\"pr_videos/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?pr_videos=$matches[1]&feed=$matches[2]\";s:38:\"pr_videos/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?pr_videos=$matches[1]&paged=$matches[2]\";s:45:\"pr_videos/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?pr_videos=$matches[1]&cpage=$matches[2]\";s:34:\"pr_videos/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?pr_videos=$matches[1]&page=$matches[2]\";s:26:\"pr_videos/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"pr_videos/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"pr_videos/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"pr_videos/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"pr_videos/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"pr_videos/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:45:\"wpephpcompat_jobs/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:55:\"wpephpcompat_jobs/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:75:\"wpephpcompat_jobs/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"wpephpcompat_jobs/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"wpephpcompat_jobs/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:51:\"wpephpcompat_jobs/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"wpephpcompat_jobs/([^/]+)/embed/?$\";s:50:\"index.php?wpephpcompat_jobs=$matches[1]&embed=true\";s:38:\"wpephpcompat_jobs/([^/]+)/trackback/?$\";s:44:\"index.php?wpephpcompat_jobs=$matches[1]&tb=1\";s:46:\"wpephpcompat_jobs/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?wpephpcompat_jobs=$matches[1]&paged=$matches[2]\";s:53:\"wpephpcompat_jobs/([^/]+)/comment-page-([0-9]{1,})/?$\";s:57:\"index.php?wpephpcompat_jobs=$matches[1]&cpage=$matches[2]\";s:42:\"wpephpcompat_jobs/([^/]+)(?:/([0-9]+))?/?$\";s:56:\"index.php?wpephpcompat_jobs=$matches[1]&page=$matches[2]\";s:34:\"wpephpcompat_jobs/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"wpephpcompat_jobs/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"wpephpcompat_jobs/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"wpephpcompat_jobs/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"wpephpcompat_jobs/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"wpephpcompat_jobs/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"et_theme_builder/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"et_theme_builder/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"et_theme_builder/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_theme_builder/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_theme_builder/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"et_theme_builder/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"et_theme_builder/([^/]+)/embed/?$\";s:64:\"index.php?post_type=et_theme_builder&name=$matches[1]&embed=true\";s:37:\"et_theme_builder/([^/]+)/trackback/?$\";s:58:\"index.php?post_type=et_theme_builder&name=$matches[1]&tb=1\";s:45:\"et_theme_builder/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_theme_builder&name=$matches[1]&paged=$matches[2]\";s:52:\"et_theme_builder/([^/]+)/comment-page-([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_theme_builder&name=$matches[1]&cpage=$matches[2]\";s:41:\"et_theme_builder/([^/]+)(?:/([0-9]+))?/?$\";s:70:\"index.php?post_type=et_theme_builder&name=$matches[1]&page=$matches[2]\";s:33:\"et_theme_builder/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"et_theme_builder/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"et_theme_builder/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_theme_builder/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_theme_builder/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"et_theme_builder/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"et_template/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"et_template/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"et_template/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"et_template/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"et_template/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"et_template/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"et_template/([^/]+)/embed/?$\";s:59:\"index.php?post_type=et_template&name=$matches[1]&embed=true\";s:32:\"et_template/([^/]+)/trackback/?$\";s:53:\"index.php?post_type=et_template&name=$matches[1]&tb=1\";s:40:\"et_template/([^/]+)/page/?([0-9]{1,})/?$\";s:66:\"index.php?post_type=et_template&name=$matches[1]&paged=$matches[2]\";s:47:\"et_template/([^/]+)/comment-page-([0-9]{1,})/?$\";s:66:\"index.php?post_type=et_template&name=$matches[1]&cpage=$matches[2]\";s:36:\"et_template/([^/]+)(?:/([0-9]+))?/?$\";s:65:\"index.php?post_type=et_template&name=$matches[1]&page=$matches[2]\";s:28:\"et_template/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"et_template/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"et_template/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"et_template/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"et_template/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"et_template/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"et_header_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"et_header_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"et_header_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_header_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_header_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"et_header_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"et_header_layout/([^/]+)/embed/?$\";s:64:\"index.php?post_type=et_header_layout&name=$matches[1]&embed=true\";s:37:\"et_header_layout/([^/]+)/trackback/?$\";s:58:\"index.php?post_type=et_header_layout&name=$matches[1]&tb=1\";s:45:\"et_header_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_header_layout&name=$matches[1]&paged=$matches[2]\";s:52:\"et_header_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_header_layout&name=$matches[1]&cpage=$matches[2]\";s:41:\"et_header_layout/([^/]+)(?:/([0-9]+))?/?$\";s:70:\"index.php?post_type=et_header_layout&name=$matches[1]&page=$matches[2]\";s:33:\"et_header_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"et_header_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"et_header_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_header_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_header_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"et_header_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:42:\"et_body_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"et_body_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"et_body_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"et_body_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"et_body_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"et_body_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"et_body_layout/([^/]+)/embed/?$\";s:62:\"index.php?post_type=et_body_layout&name=$matches[1]&embed=true\";s:35:\"et_body_layout/([^/]+)/trackback/?$\";s:56:\"index.php?post_type=et_body_layout&name=$matches[1]&tb=1\";s:43:\"et_body_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:69:\"index.php?post_type=et_body_layout&name=$matches[1]&paged=$matches[2]\";s:50:\"et_body_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:69:\"index.php?post_type=et_body_layout&name=$matches[1]&cpage=$matches[2]\";s:39:\"et_body_layout/([^/]+)(?:/([0-9]+))?/?$\";s:68:\"index.php?post_type=et_body_layout&name=$matches[1]&page=$matches[2]\";s:31:\"et_body_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"et_body_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"et_body_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"et_body_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"et_body_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"et_body_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"et_footer_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"et_footer_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"et_footer_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_footer_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_footer_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"et_footer_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"et_footer_layout/([^/]+)/embed/?$\";s:64:\"index.php?post_type=et_footer_layout&name=$matches[1]&embed=true\";s:37:\"et_footer_layout/([^/]+)/trackback/?$\";s:58:\"index.php?post_type=et_footer_layout&name=$matches[1]&tb=1\";s:45:\"et_footer_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_footer_layout&name=$matches[1]&paged=$matches[2]\";s:52:\"et_footer_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_footer_layout&name=$matches[1]&cpage=$matches[2]\";s:41:\"et_footer_layout/([^/]+)(?:/([0-9]+))?/?$\";s:70:\"index.php?post_type=et_footer_layout&name=$matches[1]&page=$matches[2]\";s:33:\"et_footer_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"et_footer_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"et_footer_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_footer_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_footer_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"et_footer_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=42&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}', 'yes'),
('30', 'hack_file', '0', 'yes'),
('31', 'blog_charset', 'UTF-8', 'yes'),
('32', 'moderation_keys', '', 'no'),
('33', 'active_plugins', 'a:19:{i:0;s:15:\"worker/init.php\";i:1;s:52:\"activecampaign-subscription-forms/activecampaign.php\";i:2;s:34:\"advanced-custom-fields-pro/acf.php\";i:3;s:33:\"akeebabackupwp/akeebabackupwp.php\";i:4;s:41:\"better-wp-security/better-wp-security.php\";i:5;s:33:\"classic-editor/classic-editor.php\";i:6;s:36:\"contact-form-7/wp-contact-form-7.php\";i:7;s:43:\"custom-post-type-ui/custom-post-type-ui.php\";i:8;s:32:\"duplicate-page/duplicatepage.php\";i:9;s:24:\"header-footer/plugin.php\";i:10;s:50:\"official-facebook-pixel/facebook-for-wordpress.php\";i:11;s:48:\"php-compatibility-checker/wpengine-phpcompat.php\";i:12;s:37:\"post-types-order/post-types-order.php\";i:13;s:56:\"simple-taxonomy-ordering/yikes-custom-taxonomy-order.php\";i:14;s:37:\"snapshot-backups/snapshot-backups.php\";i:15;s:25:\"sucuri-scanner/sucuri.php\";i:16;s:84:\"wordpress-easy-paypal-payment-or-donation-accept-plugin/WP_Accept_Paypal_Payment.php\";i:17;s:39:\"wp-migrate-db-pro/wp-migrate-db-pro.php\";i:18;s:40:\"wpmudev-updates/update-notifications.php\";}', 'yes'),
('34', 'category_base', '', 'yes'),
('35', 'ping_sites', 'http://rpc.pingomatic.com/', 'yes'),
('36', 'comment_max_links', '2', 'yes'),
('37', 'gmt_offset', '0', 'yes'),
('38', 'default_email_category', '1', 'yes'),
('39', 'recently_edited', 'a:3:{i:0;s:70:\"/nas/content/live/jhdogtraining/wp-content/themes/Divi-child/style.css\";i:2;s:103:\"/nas/content/live/jhdogtraining/wp-content/plugins/activecampaign-subscription-forms/activecampaign.php\";i:3;s:0:\"\";}', 'no'),
('40', 'template', 'Divi', 'yes'),
('41', 'stylesheet', 'Divi-child', 'yes'),
('44', 'comment_registration', '0', 'yes'),
('45', 'html_type', 'text/html', 'yes'),
('46', 'use_trackback', '0', 'yes'),
('47', 'default_role', 'subscriber', 'yes'),
('48', 'db_version', '49752', 'yes'),
('49', 'uploads_use_yearmonth_folders', '1', 'yes'),
('52', 'default_link_category', '2', 'yes'),
('53', 'show_on_front', 'page', 'yes'),
('54', 'tag_base', '', 'yes'),
('55', 'show_avatars', '1', 'yes'),
('56', 'avatar_rating', 'G', 'yes'),
('58', 'thumbnail_size_w', '150', 'yes'),
('59', 'thumbnail_size_h', '150', 'yes'),
('60', 'thumbnail_crop', '1', 'yes'),
('61', 'medium_size_w', '300', 'yes'),
('62', 'medium_size_h', '300', 'yes'),
('63', 'avatar_default', 'mystery', 'yes'),
('64', 'large_size_w', '1024', 'yes'),
('65', 'large_size_h', '1024', 'yes'),
('66', 'image_default_link_type', 'none', 'yes'),
('67', 'image_default_size', '', 'yes'),
('68', 'image_default_align', '', 'yes'),
('69', 'close_comments_for_old_posts', '0', 'yes'),
('70', 'close_comments_days_old', '14', 'yes'),
('71', 'thread_comments', '1', 'yes'),
('72', 'thread_comments_depth', '5', 'yes'),
('73', 'page_comments', '0', 'yes'),
('74', 'comments_per_page', '50', 'yes'),
('75', 'default_comments_page', 'newest', 'yes'),
('76', 'comment_order', 'asc', 'yes'),
('77', 'sticky_posts', 'a:0:{}', 'yes'),
('78', 'widget_categories', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
('79', 'widget_text', 'a:4:{i:1;a:0:{}i:3;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:391:\"<p id=\"footer-logos\"><img src=\"/wp-content/uploads/2019/06/kpalogo.png\" alt=\"\" /><a href=\"https://malenademartini.com/for-owners/why-hire-csat-trainer/\" target=\"_blank\" rel=\"noopener\"><img src=\"/wp-content/uploads/2017/12/csat_seal_web.png\" alt=\"\" width=\"107\" height=\"80\" /></a><img src=\"/wp-content/uploads/2017/12/DELTA_INSTITUTE_LOGO_MEMBER_PATHS.png\" alt=\"\" width=\"75\" height=\"80\" /></p>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:4;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:143:\"Email: <a href=\"mailto:jenny@jhdogtraining.com.au\">jenny@jhdogtraining.com.au</a>     Phone number: <a href=\"tel:0419535236\">0419 535 236</a>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}s:12:\"_multiwidget\";i:1;}', 'yes'),
('80', 'widget_rss', 'a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}', 'yes'),
('81', 'uninstall_plugins', 'a:6:{s:33:\"classic-editor/classic-editor.php\";a:2:{i:0;s:14:\"Classic_Editor\";i:1;s:9:\"uninstall\";}s:25:\"sucuri-scanner/sucuri.php\";s:19:\"sucuriscanUninstall\";s:41:\"better-wp-security/better-wp-security.php\";a:2:{i:0;s:10:\"ITSEC_Core\";i:1;s:16:\"handle_uninstall\";}s:40:\"wpmudev-updates/update-notifications.php\";a:2:{i:0;s:17:\"WPMUDEV_Dashboard\";i:1;s:16:\"uninstall_plugin\";}s:20:\"worker/functions.php\";s:13:\"mwp_uninstall\";s:33:\"akeebabackupwp/akeebabackupwp.php\";a:2:{i:0;s:14:\"AkeebaBackupWP\";i:1;s:9:\"uninstall\";}}', 'no'),
('82', 'timezone_string', '', 'yes'),
('83', 'page_for_posts', '204604', 'yes'),
('84', 'page_on_front', '42', 'yes'),
('85', 'default_post_format', '0', 'yes'),
('86', 'link_manager_enabled', '0', 'yes'),
('87', 'finished_splitting_shared_terms', '1', 'yes'),
('88', 'site_icon', '204830', 'yes'),
('89', 'medium_large_size_w', '768', 'yes'),
('90', 'medium_large_size_h', '0', 'yes'),
('91', 'initial_db_version', '38590', 'yes'),
('92', 'wp_user_roles', 'a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:67:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:17:\"et_support_center\";b:1;s:24:\"et_support_center_system\";b:1;s:31:\"et_support_center_remote_access\";b:1;s:31:\"et_support_center_documentation\";b:1;s:27:\"et_support_center_safe_mode\";b:1;s:22:\"et_support_center_logs\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}', 'yes'),
('93', 'fresh_site', '0', 'yes'),
('94', 'widget_search', 'a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}', 'yes'),
('95', 'widget_recent-posts', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
('96', 'widget_recent-comments', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
('97', 'widget_archives', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
('98', 'widget_meta', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
('99', 'sidebars_widgets', 'a:9:{s:19:\"wp_inactive_widgets\";a:1:{i:0;s:25:\"wp_paypal_payment_widgets\";}s:9:\"sidebar-1\";a:1:{i:0;s:8:\"search-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:13:\"custom_html-2\";i:1;s:6:\"text-3\";i:2;s:6:\"text-4\";}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";a:0:{}s:9:\"sidebar-5\";a:0:{}s:9:\"sidebar-6\";a:0:{}s:9:\"sidebar-7\";a:0:{}s:13:\"array_version\";i:3;}', 'yes'),
('100', 'widget_pages', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
('101', 'widget_calendar', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
('102', 'widget_media_audio', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
('103', 'widget_media_image', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
('104', 'widget_media_video', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
('105', 'widget_tag_cloud', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
('106', 'widget_nav_menu', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
('107', 'cron', 'a:24:{i:1625108811;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1625109767;a:1:{s:10:\"itsec_cron\";a:1:{s:32:\"12ca8767a64eac20d01836398698c811\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:1:{i:0;s:11:\"flush-files\";}s:8:\"interval\";i:3600;}}}i:1625112616;a:1:{s:10:\"itsec_cron\";a:1:{s:32:\"d3ad27d223d301b6ae68ed2a88d04d71\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:1:{i:0;s:12:\"health-check\";}s:8:\"interval\";i:86400;}}}i:1625113470;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"fab6536ca88a123161c6520d9874cefe\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:205279;}}}}i:1625115282;a:1:{s:22:\"wpmudev_scheduled_jobs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1625117659;a:1:{s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1625122102;a:1:{s:26:\"snapshot4_handle_schedules\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1625128783;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1625131661;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1625137008;a:1:{s:39:\"WPEngineSecurityAuditor_Scans_scheduler\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1625148407;a:1:{s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1625149188;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1625152579;a:1:{s:21:\"et_builder_fonts_cron\";a:1:{s:32:\"552cbb9d6515dadbbc4718ad75114f08\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:1:{s:8:\"interval\";s:5:\"daily\";}s:8:\"interval\";i:86400;}}}i:1625153596;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1625154913;a:1:{s:10:\"itsec_cron\";a:1:{s:32:\"c0ae31dfe60fdb9da055aa838519db0f\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:1:{i:0;s:12:\"clear-tokens\";}s:8:\"interval\";i:86400;}}}i:1625158329;a:1:{s:15:\"itsec_cron_test\";a:1:{s:32:\"1517158c37f54ec2069fa3ed0f7217e8\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1625158329;}}}}i:1625179294;a:1:{s:25:\"sucuriscan_scheduled_scan\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1625181149;a:1:{s:10:\"itsec_cron\";a:1:{s:32:\"aa768a35ceed34e467f270ebdc5d82f4\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:1:{i:0;s:14:\"purge-lockouts\";}s:8:\"interval\";i:86400;}}}i:1625181269;a:1:{s:10:\"itsec_cron\";a:1:{s:32:\"7a0fd5d064c59cf40c3df9ad0bb6e63d\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:1:{i:0;s:11:\"clear-locks\";}s:8:\"interval\";i:86400;}}}i:1625181389;a:1:{s:10:\"itsec_cron\";a:1:{s:32:\"3ec3d6914daf50bcdb5e5b065213e29b\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:1:{i:0;s:17:\"purge-log-entries\";}s:8:\"interval\";i:86400;}}}i:1625184398;a:1:{s:22:\"mwp_update_public_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1625349665;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1627314843;a:1:{s:32:\"et_core_page_resource_auto_clear\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:7:\"monthly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:2592000;}}}s:7:\"version\";i:2;}', 'yes'),
('109', 'widget_custom_html', 'a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:575:\"<ul id=\"footer-icons\" class=\"et-social-icons\">\r\n<li class=\"et-social-icon et-social-facebook\">\r\n<a href=\"https://www.facebook.com/JHDogTraining/\" class=\"icon\" target=\"_blank\">\r\n<span>Facebook</span>\r\n</a>\r\n</li>\r\n	\r\n<li class=\"et-social-icon et-social-instagram\">\r\n<a href=\"https://www.instagram.com/jhdogtraining/\" class=\"icon\" target=\"_blank\">\r\n<span>Facebook</span>\r\n</a>\r\n</li>\r\n	\r\n<li class=\"et-social-icon et-social-youtube\">\r\n<a href=\"https://www.youtube.com/channel/UCEUQ7srWFfw3JQCeAVludoQ/\" class=\"icon\" target=\"_blank\">\r\n<span>Facebook</span>\r\n</a>\r\n</li>\r\n\r\n</ul>\";}s:12:\"_multiwidget\";i:1;}', 'yes'),
('110', 'widget_wpe_powered_by_widget', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
('118', 'theme_mods_twentyseventeen', 'a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1510674841;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}}}', 'yes'),
('122', 'wpe_notices', 'a:1:{s:4:\"read\";s:0:\"\";}', 'yes'),
('123', 'wpe_notices_ttl', '1625109787', 'yes'),
('144', 'recently_activated', 'a:0:{}', 'yes'),
('155', 'current_theme', 'Divi child theme', 'yes'),
('156', 'theme_mods_Divi', 'a:9:{i:0;b:0;s:18:\"custom_css_post_id\";i:40;s:16:\"et_pb_css_synced\";s:3:\"yes\";s:21:\"et_pb_layouts_updated\";s:3:\"yes\";s:39:\"et_updated_layouts_built_for_post_types\";s:3:\"yes\";s:30:\"et_pb_predefined_layouts_added\";s:2:\"on\";s:34:\"et_pb_predefined_layouts_version_6\";s:2:\"on\";s:18:\"nav_menu_locations\";a:1:{s:12:\"primary-menu\";i:5;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1518013371;s:4:\"data\";a:6:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:1:{i:0;s:8:\"search-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:13:\"custom_html-2\";i:1;s:6:\"text-3\";i:2;s:6:\"text-4\";}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";a:0:{}s:9:\"sidebar-5\";a:0:{}}}}', 'yes'),
('157', 'theme_switched', '', 'yes'),
('158', 'et_pb_cache_notice', 'a:1:{s:6:\"3.0.89\";s:6:\"ignore\";}', 'yes'),
('163', 'et_core_version', '4.6.6', 'yes'),
('165', 'et_divi', 'a:172:{s:39:\"static_css_custom_css_safety_check_done\";b:1;s:23:\"2_5_flush_rewrite_rules\";s:4:\"done\";s:25:\"3_0_flush_rewrite_rules_2\";s:4:\"done\";s:27:\"divi_skip_font_subset_force\";b:1;s:40:\"divi_email_provider_credentials_migrated\";b:1;s:30:\"divi_2_4_documentation_message\";s:9:\"triggered\";s:15:\"divi_1_3_images\";s:7:\"checked\";s:24:\"footer_widget_text_color\";s:7:\"#ffffff\";s:24:\"footer_widget_link_color\";s:7:\"#ffffff\";s:9:\"divi_logo\";s:75:\"https://jhdogtraining.com.au/wp-content/uploads/2017/12/JH_Horizontal-4.png\";s:12:\"divi_favicon\";s:0:\"\";s:14:\"divi_fixed_nav\";s:2:\"on\";s:26:\"divi_gallery_layout_enable\";s:5:\"false\";s:18:\"divi_color_palette\";s:63:\"#000000|#ffffff|#e02b20|#e09900|#edf000|#7cda24|#0c71c3|#8300e9\";s:15:\"divi_grab_image\";s:5:\"false\";s:15:\"divi_blog_style\";s:5:\"false\";s:12:\"divi_sidebar\";s:16:\"et_right_sidebar\";s:22:\"divi_shop_page_sidebar\";s:16:\"et_right_sidebar\";s:23:\"divi_show_facebook_icon\";s:2:\"on\";s:22:\"divi_show_twitter_icon\";s:5:\"false\";s:21:\"divi_show_google_icon\";s:5:\"false\";s:18:\"divi_show_rss_icon\";s:5:\"false\";s:17:\"divi_facebook_url\";s:39:\"https://www.facebook.com/JHDogTraining/\";s:16:\"divi_twitter_url\";s:1:\"#\";s:15:\"divi_google_url\";s:1:\"#\";s:12:\"divi_rss_url\";s:0:\"\";s:34:\"divi_woocommerce_archive_num_posts\";i:9;s:17:\"divi_catnum_posts\";i:6;s:21:\"divi_archivenum_posts\";i:5;s:20:\"divi_searchnum_posts\";i:5;s:17:\"divi_tagnum_posts\";i:5;s:16:\"divi_date_format\";s:6:\"M j, Y\";s:16:\"divi_use_excerpt\";s:5:\"false\";s:26:\"divi_responsive_shortcodes\";s:2:\"on\";s:33:\"divi_gf_enable_all_character_sets\";s:5:\"false\";s:16:\"divi_back_to_top\";s:5:\"false\";s:18:\"divi_smooth_scroll\";s:5:\"false\";s:25:\"divi_disable_translations\";s:5:\"false\";s:27:\"divi_minify_combine_scripts\";s:2:\"on\";s:26:\"divi_minify_combine_styles\";s:2:\"on\";s:15:\"divi_custom_css\";s:1384:\"input.wpcf7-form-control {\r\n    width: 100%;\r\n    padding: 16px;\r\n    border: none;\r\n    -webkit-border-radius: 0;\r\n    -moz-border-radius: 0;\r\n    border-radius: 0;\r\n    color: #999;\r\n    background-color: #eee;\r\n    font-size: 14px;\r\n    margin-bottom: 10px;\r\n}\r\n\r\ninput[type=\"submit\"].wpcf7-form-control  {\r\n    color: #1f1e86 !important;\r\n    cursor: pointer;\r\n    border:  2px solid #1f1e86;\r\n}\r\n\r\ntextarea.wpcf7-form-control {\r\n    width: 100%;\r\n    padding: 16px;\r\n    border: none;\r\n    -webkit-border-radius: 0;\r\n    -moz-border-radius: 0;\r\n    border-radius: 0;\r\n    color: #999;\r\n    background-color: #eee;\r\n    font-size: 14px;\r\n    margin-bottom: 10px;\r\n}\r\n\r\n.fwidget  {\r\n  text-align: center;  \r\nwidth: 100%;\r\n}\r\n\r\n#footer-icons {\r\n  float:none;\r\n  text-align: center;\r\n}\r\n\r\n.et-social-icon {\r\n  display: inline-block;\r\n  margin: 0 5px !important;\r\n  padding: 0 !important;\r\n}\r\n\r\n.et-social-icon:before {\r\n  display:none;\r\n}\r\n\r\n#footer-logos {\r\n  text-align: center;\r\n}\r\n\r\n#footer-logos>img{\r\n  margin: 0 5px;\r\n}\r\n\r\n#footer-info {\r\n  float: none;\r\n}\r\n\r\n#bottom-bar-text {\r\n  text-align: center;\r\n} \r\n.head_link a {\r\n    color: black;\r\n}\r\n.head_link a:hover {\r\n    color: #848484;\r\n}\r\n.force_marg .et_pb_text_inner {\r\n    margin-bottom: 30px !important;\r\n}\r\n#et-secondary-menu {\r\n    float: left;\r\n}\r\ndiv#et-secondary-menu {\r\n    width: 100%;\r\n    text-align: center;\r\n}\";s:21:\"divi_enable_dropdowns\";s:2:\"on\";s:14:\"divi_home_link\";s:2:\"on\";s:15:\"divi_sort_pages\";s:10:\"post_title\";s:15:\"divi_order_page\";s:3:\"asc\";s:22:\"divi_tiers_shown_pages\";i:3;s:32:\"divi_enable_dropdowns_categories\";s:2:\"on\";s:21:\"divi_categories_empty\";s:2:\"on\";s:27:\"divi_tiers_shown_categories\";i:3;s:13:\"divi_sort_cat\";s:4:\"name\";s:14:\"divi_order_cat\";s:3:\"asc\";s:20:\"divi_disable_toptier\";s:5:\"false\";s:25:\"divi_scroll_to_anchor_fix\";s:5:\"false\";s:21:\"et_pb_static_css_file\";s:2:\"on\";s:19:\"et_pb_css_in_footer\";s:3:\"off\";s:25:\"et_pb_product_tour_global\";s:2:\"on\";s:14:\"divi_postinfo2\";a:4:{i:0;s:6:\"author\";i:1;s:4:\"date\";i:2;s:10:\"categories\";i:3;s:8:\"comments\";}s:22:\"divi_show_postcomments\";s:2:\"on\";s:15:\"divi_thumbnails\";s:2:\"on\";s:20:\"divi_page_thumbnails\";s:5:\"false\";s:23:\"divi_show_pagescomments\";s:5:\"false\";s:14:\"divi_postinfo1\";a:3:{i:0;s:6:\"author\";i:1;s:4:\"date\";i:2;s:10:\"categories\";}s:21:\"divi_thumbnails_index\";s:2:\"on\";s:19:\"divi_seo_home_title\";s:5:\"false\";s:25:\"divi_seo_home_description\";s:5:\"false\";s:22:\"divi_seo_home_keywords\";s:5:\"false\";s:23:\"divi_seo_home_canonical\";s:5:\"false\";s:23:\"divi_seo_home_titletext\";s:0:\"\";s:29:\"divi_seo_home_descriptiontext\";s:0:\"\";s:26:\"divi_seo_home_keywordstext\";s:0:\"\";s:18:\"divi_seo_home_type\";s:27:\"BlogName | Blog description\";s:22:\"divi_seo_home_separate\";s:3:\" | \";s:21:\"divi_seo_single_title\";s:5:\"false\";s:27:\"divi_seo_single_description\";s:5:\"false\";s:24:\"divi_seo_single_keywords\";s:5:\"false\";s:25:\"divi_seo_single_canonical\";s:5:\"false\";s:27:\"divi_seo_single_field_title\";s:9:\"seo_title\";s:33:\"divi_seo_single_field_description\";s:15:\"seo_description\";s:30:\"divi_seo_single_field_keywords\";s:12:\"seo_keywords\";s:20:\"divi_seo_single_type\";s:21:\"Post title | BlogName\";s:24:\"divi_seo_single_separate\";s:3:\" | \";s:24:\"divi_seo_index_canonical\";s:5:\"false\";s:26:\"divi_seo_index_description\";s:5:\"false\";s:19:\"divi_seo_index_type\";s:24:\"Category name | BlogName\";s:23:\"divi_seo_index_separate\";s:3:\" | \";s:28:\"divi_integrate_header_enable\";s:2:\"on\";s:26:\"divi_integrate_body_enable\";s:2:\"on\";s:31:\"divi_integrate_singletop_enable\";s:2:\"on\";s:34:\"divi_integrate_singlebottom_enable\";s:2:\"on\";s:21:\"divi_integration_head\";s:0:\"\";s:21:\"divi_integration_body\";s:0:\"\";s:27:\"divi_integration_single_top\";s:0:\"\";s:30:\"divi_integration_single_bottom\";s:0:\"\";s:15:\"divi_468_enable\";s:5:\"false\";s:14:\"divi_468_image\";s:0:\"\";s:12:\"divi_468_url\";s:0:\"\";s:16:\"divi_468_adsense\";s:0:\"\";s:19:\"product_tour_status\";a:2:{i:1;s:3:\"off\";i:2;s:3:\"off\";}s:21:\"custom_footer_credits\";s:109:\"<p id=\"bottom-bar-text\"><a href=\"/privacy-policy/\">Privacy Policy</a> | ©2018 Jenny Harlow Dog Training </p>\";s:24:\"show_footer_social_icons\";b:0;s:11:\"menu_height\";i:100;s:11:\"logo_height\";i:100;s:16:\"menu_link_active\";s:7:\"#1f1e86\";s:31:\"primary_nav_dropdown_line_color\";s:7:\"#1f1e86\";s:16:\"show_search_icon\";b:0;s:13:\"nav_fullwidth\";b:0;s:14:\"footer_columns\";s:1:\"1\";s:10:\"link_color\";s:7:\"#1f1e86\";s:32:\"et_fb_pref_settings_bar_location\";s:6:\"bottom\";s:28:\"et_fb_pref_builder_animation\";s:4:\"true\";s:41:\"et_fb_pref_builder_display_modal_settings\";s:5:\"false\";s:21:\"et_fb_pref_event_mode\";s:5:\"hover\";s:32:\"et_fb_pref_hide_disabled_modules\";s:5:\"false\";s:28:\"et_fb_pref_history_intervals\";i:1;s:27:\"et_fb_pref_modal_preference\";s:7:\"default\";s:30:\"et_fb_pref_modal_snap_location\";s:5:\"false\";s:21:\"et_fb_pref_modal_snap\";s:5:\"false\";s:27:\"et_fb_pref_modal_fullscreen\";s:5:\"false\";s:32:\"et_fb_pref_modal_dimension_width\";i:601;s:33:\"et_fb_pref_modal_dimension_height\";i:345;s:27:\"et_fb_pref_modal_position_x\";i:205;s:27:\"et_fb_pref_modal_position_y\";i:6;s:24:\"et_fb_pref_toolbar_click\";s:5:\"false\";s:26:\"et_fb_pref_toolbar_desktop\";s:4:\"true\";s:23:\"et_fb_pref_toolbar_grid\";s:5:\"false\";s:24:\"et_fb_pref_toolbar_hover\";s:5:\"false\";s:24:\"et_fb_pref_toolbar_phone\";s:4:\"true\";s:25:\"et_fb_pref_toolbar_tablet\";s:4:\"true\";s:28:\"et_fb_pref_toolbar_wireframe\";s:4:\"true\";s:23:\"et_fb_pref_toolbar_zoom\";s:4:\"true\";s:21:\"et_pb_layouts_updated\";b:1;s:30:\"library_removed_legacy_layouts\";b:1;s:31:\"divi_previous_installed_version\";s:5:\"4.6.5\";s:29:\"divi_latest_installed_version\";s:5:\"4.6.6\";s:39:\"et_fb_pref_builder_enable_dummy_content\";s:4:\"true\";s:29:\"et_fb_pref_page_creation_flow\";s:7:\"default\";s:23:\"secondary_nav_fullwidth\";b:0;s:16:\"secondary_nav_bg\";s:7:\"#000000\";s:25:\"secondary_nav_dropdown_bg\";s:7:\"#000000\";s:12:\"phone_number\";s:0:\"\";s:17:\"hide_primary_logo\";b:0;s:27:\"et_pb_post_type_integration\";a:3:{s:4:\"page\";s:2:\"on\";s:4:\"post\";s:2:\"on\";s:7:\"project\";s:2:\"on\";}s:30:\"3_0_flush_rewrite_rules_3.18.7\";s:4:\"done\";s:30:\"3_0_flush_rewrite_rules_3.19.9\";s:4:\"done\";s:31:\"3_0_flush_rewrite_rules_3.19.11\";s:4:\"done\";s:30:\"et_flush_rewrite_rules_library\";s:5:\"4.6.6\";s:27:\"et_pb_clear_templates_cache\";b:1;s:26:\"divi_bfb_optin_modal_shown\";s:2:\"no\";s:23:\"builder_custom_defaults\";O:8:\"stdClass\":0:{}s:33:\"customizer_settings_migrated_flag\";b:1;s:34:\"builder_custom_defaults_unmigrated\";b:0;s:28:\"et_fb_pref_limited_view_mode\";s:9:\"wireframe\";s:42:\"et_fb_pref_quick_actions_always_start_with\";s:7:\"nothing\";s:44:\"et_fb_pref_quick_actions_show_recent_queries\";s:3:\"off\";s:39:\"et_fb_pref_quick_actions_recent_queries\";s:0:\"\";s:40:\"et_fb_pref_quick_actions_recent_category\";s:0:\"\";s:35:\"et_fb_pref_limited_modal_preference\";s:7:\"default\";s:32:\"et_fb_pref_limited_toolbar_click\";s:5:\"false\";s:34:\"et_fb_pref_limited_toolbar_desktop\";s:4:\"true\";s:31:\"et_fb_pref_limited_toolbar_grid\";s:5:\"false\";s:32:\"et_fb_pref_limited_toolbar_hover\";s:5:\"false\";s:32:\"et_fb_pref_limited_toolbar_phone\";s:4:\"true\";s:33:\"et_fb_pref_limited_toolbar_tablet\";s:4:\"true\";s:36:\"et_fb_pref_limited_toolbar_wireframe\";s:4:\"true\";s:31:\"et_fb_pref_limited_toolbar_zoom\";s:4:\"true\";s:20:\"et_fb_pref_view_mode\";s:7:\"desktop\";s:36:\"et_fb_pref_lv_modal_dimension_height\";i:1;s:35:\"et_fb_pref_lv_modal_dimension_width\";i:1;s:30:\"et_fb_pref_lv_modal_position_x\";i:1;s:30:\"et_fb_pref_lv_modal_position_y\";i:1;s:22:\"builder_global_presets\";O:8:\"stdClass\":0:{}s:29:\"custom_defaults_migrated_flag\";b:1;}', 'yes'),
('166', 'widget_aboutmewidget', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
('167', 'widget_adsensewidget', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
('168', 'widget_advwidget', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
('169', 'shop_catalog_image_size', 'a:3:{s:5:\"width\";s:3:\"400\";s:6:\"height\";s:3:\"400\";s:4:\"crop\";i:1;}', 'yes'),
('170', 'shop_single_image_size', 'a:3:{s:5:\"width\";s:3:\"510\";s:6:\"height\";s:4:\"9999\";s:4:\"crop\";i:0;}', 'yes'),
('171', 'shop_thumbnail_image_size', 'a:3:{s:5:\"width\";s:3:\"157\";s:6:\"height\";s:3:\"157\";s:4:\"crop\";i:1;}', 'yes'),
('172', 'et_images_temp_folder', '/nas/content/live/jhdogtraining/wp-content/uploads/et_temp', 'yes'),
('173', 'et_schedule_clean_images_last_time', '1624830045', 'yes'),
('174', 'et_pb_builder_options', 'a:2:{i:0;b:0;s:35:\"email_provider_credentials_migrated\";b:1;}', 'yes'),
('220', 'et_account_status', 'active', 'yes'),
('222', 'widget_media_gallery', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
('244', 'et_google_api_settings', 'a:3:{s:7:\"api_key\";s:0:\"\";s:26:\"enqueue_google_maps_script\";s:2:\"on\";s:16:\"use_google_fonts\";s:2:\"on\";}', 'yes'),
('245', 'et_automatic_updates_options', 'a:2:{s:8:\"username\";s:7:\"jharlow\";s:7:\"api_key\";s:40:\"b6a4567be009e3700281de9662da4476ca97018b\";}', 'yes'),
('246', 'et_account_status_last_checked', '1587138302', 'no'),
('256', 'category_children', 'a:0:{}', 'yes'),
('261', 'nav_menu_options', 'a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}', 'yes'),
('584', 'settings_activecampaign', 'a:9:{s:7:\"api_url\";s:42:\"https://jennyharlowdogtraining.api-us1.com\";s:7:\"api_key\";s:72:\"75bff4b5f26993493d7714cb2c3c7c3dd7b0c12c4913652f34129df3d5042adb73b57903\";s:7:\"form_id\";a:2:{i:0;s:1:\"5\";i:1;s:2:\"13\";}s:4:\"syim\";a:4:{i:5;s:4:\"swim\";i:9;s:4:\"swim\";i:11;s:4:\"swim\";i:13;s:4:\"swim\";}s:3:\"css\";a:4:{i:5;s:1:\"1\";i:9;s:1:\"1\";i:11;s:1:\"1\";i:13;s:1:\"1\";}s:12:\"account_view\";a:14:{s:7:\"account\";s:39:\"jennyharlowdogtraining.activehosted.com\";s:5:\"email\";s:26:\"jenny@jhdogtraining.com.au\";s:5:\"fname\";s:5:\"Jenny\";s:5:\"lname\";s:19:\"Harlow Dog Training\";s:5:\"cname\";s:0:\"\";s:16:\"subscriber_limit\";s:4:\"1000\";s:16:\"subscriber_total\";s:2:\"60\";s:6:\"status\";s:6:\"nobody\";s:8:\"branding\";s:1:\"1\";s:11:\"result_code\";i:1;s:14:\"result_message\";s:30:\"Success: Something is returned\";s:13:\"result_output\";s:4:\"json\";s:9:\"http_code\";i:200;s:7:\"success\";i:1;}s:7:\"account\";s:39:\"jennyharlowdogtraining.activehosted.com\";s:14:\"tracking_actid\";i:999886888;s:5:\"forms\";a:4:{i:5;a:20:{s:2:\"id\";s:1:\"5\";s:4:\"name\";s:22:\"Subscribe from website\";s:6:\"layout\";s:11:\"inline-form\";s:6:\"target\";i:1;s:9:\"messageid\";s:1:\"5\";s:10:\"conflistid\";i:0;s:11:\"redirecturl\";s:65:\"https://jennyharlowdogtraining.api-us1.com/f/thankyou.php?id=5&s=\";s:11:\"facebookurl\";s:0:\"\";s:10:\"managetext\";i:0;s:5:\"theme\";s:0:\"\";s:9:\"sendoptin\";b:1;s:11:\"waitpreview\";i:0;s:7:\"widthpx\";s:3:\"400\";s:8:\"disabled\";i:0;s:9:\"analytics\";i:0;s:8:\"branding\";i:1;s:10:\"baseformid\";s:0:\"\";s:13:\"subscriptions\";i:5;s:5:\"lists\";a:1:{i:0;i:1;}s:7:\"version\";i:2;}i:9;a:20:{s:2:\"id\";s:1:\"9\";s:4:\"name\";s:15:\"Home Train FBAD\";s:6:\"layout\";s:11:\"inline-form\";s:6:\"target\";i:1;s:9:\"messageid\";s:1:\"7\";s:10:\"conflistid\";i:0;s:11:\"redirecturl\";s:65:\"https://jennyharlowdogtraining.api-us1.com/f/thankyou.php?id=9&s=\";s:11:\"facebookurl\";s:0:\"\";s:10:\"managetext\";i:0;s:5:\"theme\";s:0:\"\";s:9:\"sendoptin\";b:0;s:11:\"waitpreview\";i:0;s:7:\"widthpx\";i:500;s:8:\"disabled\";i:0;s:9:\"analytics\";i:0;s:8:\"branding\";i:1;s:10:\"baseformid\";s:0:\"\";s:13:\"subscriptions\";i:2;s:5:\"lists\";a:2:{i:0;i:2;i:1;i:3;}s:7:\"version\";i:2;}i:11;a:20:{s:2:\"id\";s:2:\"11\";s:4:\"name\";s:20:\"Thank you Game Page \";s:6:\"layout\";s:11:\"inline-form\";s:6:\"target\";i:1;s:9:\"messageid\";s:2:\"10\";s:10:\"conflistid\";i:0;s:11:\"redirecturl\";s:66:\"https://jennyharlowdogtraining.api-us1.com/f/thankyou.php?id=11&s=\";s:11:\"facebookurl\";s:0:\"\";s:10:\"managetext\";i:0;s:5:\"theme\";s:0:\"\";s:9:\"sendoptin\";b:1;s:11:\"waitpreview\";i:0;s:7:\"widthpx\";i:500;s:8:\"disabled\";i:0;s:9:\"analytics\";i:0;s:8:\"branding\";i:1;s:10:\"baseformid\";s:0:\"\";s:13:\"subscriptions\";i:0;s:5:\"lists\";a:1:{i:0;i:2;}s:7:\"version\";i:2;}i:13;a:20:{s:2:\"id\";s:2:\"13\";s:4:\"name\";s:13:\"Training Tips\";s:6:\"layout\";s:11:\"inline-form\";s:6:\"target\";i:1;s:9:\"messageid\";s:2:\"21\";s:10:\"conflistid\";i:0;s:11:\"redirecturl\";s:66:\"https://jennyharlowdogtraining.api-us1.com/f/thankyou.php?id=13&s=\";s:11:\"facebookurl\";s:0:\"\";s:10:\"managetext\";i:0;s:5:\"theme\";s:0:\"\";s:9:\"sendoptin\";b:1;s:11:\"waitpreview\";i:0;s:7:\"widthpx\";i:500;s:8:\"disabled\";i:0;s:9:\"analytics\";i:0;s:8:\"branding\";i:1;s:10:\"baseformid\";s:0:\"\";s:13:\"subscriptions\";i:1;s:5:\"lists\";a:1:{i:0;i:5;}s:7:\"version\";i:2;}}}', 'yes'),
('783', 'wpcf7', 'a:3:{s:7:\"version\";s:3:\"5.3\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1515447475;s:7:\"version\";s:5:\"4.9.2\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}s:9:\"recaptcha\";a:1:{s:40:\"6Le1CasUAAAAACfndMCv4-VfMq47nebQiytXvKOZ\";s:40:\"6Le1CasUAAAAAEoiS2mkIUetPJhsaS1li8JkT2fo\";}}', 'yes'),
('826', 'sendgrid_mc_widget_notice_dismissed', 'true', 'yes'),
('1141', 'theme_mods_Divi-child', 'a:9:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:12:\"primary-menu\";i:5;s:14:\"secondary-menu\";i:6;}s:18:\"custom_css_post_id\";i:204684;s:16:\"et_pb_css_synced\";s:3:\"yes\";s:21:\"et_pb_layouts_updated\";s:3:\"yes\";s:39:\"et_updated_layouts_built_for_post_types\";s:3:\"yes\";s:30:\"et_pb_predefined_layouts_added\";s:2:\"on\";s:34:\"et_pb_predefined_layouts_version_6\";s:2:\"on\";s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1518013236;s:4:\"data\";a:6:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:1:{i:0;s:8:\"search-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:13:\"custom_html-2\";i:1;s:6:\"text-3\";i:2;s:6:\"text-4\";}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";a:0:{}s:9:\"sidebar-5\";a:0:{}}}}', 'yes'),
('2360', 'manage-multiple-blogs', 'a:2:{s:5:\"blogs\";a:0:{}s:12:\"current_blog\";a:1:{s:4:\"type\";N;}}', 'yes'),
('2369', 'iwp_backup_table_version', '1.1.4', 'yes'),
('2370', 'iwp_client_replaced_old_hash_backup_files', '1', 'yes'),
('2420', 'iwp_file_list_table_version', '1.1', 'yes'),
('2421', 'iwp_client_multi_backup_temp_values', 'a:13:{s:15:\"file_block_size\";i:5;s:13:\"is_compressed\";b:0;s:20:\"file_loop_break_time\";i:9;s:13:\"del_host_file\";s:1:\"1\";s:9:\"task_name\";s:6:\"Weekly\";s:22:\"upload_loop_break_time\";i:9;s:22:\"upload_file_block_size\";i:5242881;s:18:\"db_loop_break_time\";i:9;s:15:\"dbFileHashValue\";a:1:{i:224791;a:0:{}}s:16:\"actual_file_size\";N;s:12:\"s3_upload_id\";a:1:{i:224791;s:108:\"szIT168qXNta92ChNU.dhHSpRDAvKN9fR0vsZbCFJaJKJvbstjqZAFVTCY0Ed3L0ATAfHN7ehg5kcsV9uFZ4XYKHYovDru2eqxQVvJ4fD4Q-\";}s:11:\"backup_file\";s:161:\"/nas/content/live/jhdogtraining/wp-content/infinitewp/backups/jhdogtraining.com.au_scheduleBackup_full_2020-10-28_26dc9488a0538a56a4956571d7177db5_iwp_part_1.zip\";s:16:\"s3_retrace_count\";a:1:{i:224791;i:0;}}', 'yes'),
('3632', 'iwp_client_backup_tasks', 'a:2:{s:15:\"backhack_status\";a:6:{s:14:\"adminHistoryID\";i:22426;s:7:\"db_dump\";a:2:{s:5:\"start\";d:1529968206.7412579059600830078125;s:3:\"end\";d:1529968206.7998878955841064453125;}s:6:\"db_zip\";a:2:{s:5:\"start\";d:1529968206.807940006256103515625;s:3:\"end\";d:1529968206.8196289539337158203125;}s:9:\"files_zip\";a:2:{s:5:\"start\";d:1529968207.471581935882568359375;s:3:\"end\";d:1529968234.4034519195556640625;}s:9:\"amazon_s3\";a:2:{s:5:\"start\";d:1529968234.54514598846435546875;s:3:\"end\";d:1529968251.29181194305419921875;}s:8:\"finished\";a:1:{s:3:\"end\";d:1529968251.3163259029388427734375;}}s:12:\"task_results\";a:1:{i:22426;a:6:{s:4:\"size\";s:7:\"71.4 MB\";s:11:\"backup_name\";s:7:\"updates\";s:9:\"mechanism\";s:10:\"singleCall\";s:4:\"time\";i:1529968234;s:14:\"adminHistoryID\";i:22426;s:8:\"amazons3\";s:80:\"jhdogtraining.com.au_backup_full_2018-06-25_4fa33e32fe7ed0d310bf2d85dd3ddc51.zip\";}}}', 'yes'),
('5819', 'WPLANG', '', 'yes'),
('5820', 'new_admin_email', 'jennyharlow@bigpond.com', 'yes'),
('5854', 'wpmdb_usage', 'a:2:{s:6:\"action\";s:12:\"find_replace\";s:4:\"time\";i:1536952572;}', 'no'),
('5857', 'blog_public', '1', 'yes'),
('5858', 'upload_path', '', 'yes'),
('5859', 'upload_url_path', '', 'yes'),
('5860', 'wpmdb_schema_version', '2', 'no'),
('5861', 'wpmdb_settings', 'a:13:{s:3:\"key\";s:40:\"oEZxriIDsDe8a+dqtO0eppeRQYqCvWuJ2JbAJj+a\";s:10:\"allow_pull\";b:0;s:10:\"allow_push\";b:0;s:8:\"profiles\";a:0:{}s:7:\"licence\";s:36:\"c0158c5e-5818-455e-b36c-6236a0d801b1\";s:10:\"verify_ssl\";b:0;s:17:\"whitelist_plugins\";a:0:{}s:11:\"max_request\";i:1048576;s:22:\"delay_between_requests\";i:0;s:18:\"prog_tables_hidden\";b:1;s:21:\"pause_before_finalize\";b:0;s:28:\"compatibility_plugin_version\";s:3:\"1.1\";s:14:\"allow_tracking\";N;}', 'no'),
('6068', 'cptui_new_install', 'false', 'yes'),
('6069', 'cptui_post_types', 'a:2:{s:6:\"videos\";a:28:{s:4:\"name\";s:6:\"videos\";s:5:\"label\";s:6:\"Videos\";s:14:\"singular_label\";s:6:\"videos\";s:11:\"description\";s:0:\"\";s:6:\"public\";s:4:\"true\";s:18:\"publicly_queryable\";s:4:\"true\";s:7:\"show_ui\";s:4:\"true\";s:17:\"show_in_nav_menus\";s:4:\"true\";s:12:\"show_in_rest\";s:5:\"false\";s:9:\"rest_base\";s:0:\"\";s:11:\"has_archive\";s:4:\"true\";s:18:\"has_archive_string\";s:0:\"\";s:19:\"exclude_from_search\";s:5:\"false\";s:15:\"capability_type\";s:4:\"post\";s:12:\"hierarchical\";s:5:\"false\";s:7:\"rewrite\";s:4:\"true\";s:12:\"rewrite_slug\";s:0:\"\";s:17:\"rewrite_withfront\";s:4:\"true\";s:9:\"query_var\";s:4:\"true\";s:14:\"query_var_slug\";s:0:\"\";s:13:\"menu_position\";s:0:\"\";s:12:\"show_in_menu\";s:4:\"true\";s:19:\"show_in_menu_string\";s:0:\"\";s:9:\"menu_icon\";s:0:\"\";s:8:\"supports\";a:3:{i:0;s:5:\"title\";i:1;s:6:\"editor\";i:2;s:9:\"thumbnail\";}s:10:\"taxonomies\";a:0:{}s:6:\"labels\";a:23:{s:9:\"menu_name\";s:0:\"\";s:9:\"all_items\";s:0:\"\";s:7:\"add_new\";s:0:\"\";s:12:\"add_new_item\";s:0:\"\";s:9:\"edit_item\";s:0:\"\";s:8:\"new_item\";s:0:\"\";s:9:\"view_item\";s:0:\"\";s:10:\"view_items\";s:0:\"\";s:12:\"search_items\";s:0:\"\";s:9:\"not_found\";s:0:\"\";s:18:\"not_found_in_trash\";s:0:\"\";s:17:\"parent_item_colon\";s:0:\"\";s:14:\"featured_image\";s:0:\"\";s:18:\"set_featured_image\";s:0:\"\";s:21:\"remove_featured_image\";s:0:\"\";s:18:\"use_featured_image\";s:0:\"\";s:8:\"archives\";s:0:\"\";s:16:\"insert_into_item\";s:0:\"\";s:21:\"uploaded_to_this_item\";s:0:\"\";s:17:\"filter_items_list\";s:0:\"\";s:21:\"items_list_navigation\";s:0:\"\";s:10:\"items_list\";s:0:\"\";s:10:\"attributes\";s:0:\"\";}s:15:\"custom_supports\";s:0:\"\";}s:9:\"pr_videos\";a:28:{s:4:\"name\";s:9:\"pr_videos\";s:5:\"label\";s:14:\"Private Videos\";s:14:\"singular_label\";s:13:\"Private Video\";s:11:\"description\";s:0:\"\";s:6:\"public\";s:4:\"true\";s:18:\"publicly_queryable\";s:4:\"true\";s:7:\"show_ui\";s:4:\"true\";s:17:\"show_in_nav_menus\";s:4:\"true\";s:12:\"show_in_rest\";s:5:\"false\";s:9:\"rest_base\";s:0:\"\";s:11:\"has_archive\";s:4:\"true\";s:18:\"has_archive_string\";s:0:\"\";s:19:\"exclude_from_search\";s:5:\"false\";s:15:\"capability_type\";s:4:\"post\";s:12:\"hierarchical\";s:5:\"false\";s:7:\"rewrite\";s:4:\"true\";s:12:\"rewrite_slug\";s:0:\"\";s:17:\"rewrite_withfront\";s:4:\"true\";s:9:\"query_var\";s:4:\"true\";s:14:\"query_var_slug\";s:0:\"\";s:13:\"menu_position\";s:0:\"\";s:12:\"show_in_menu\";s:4:\"true\";s:19:\"show_in_menu_string\";s:0:\"\";s:9:\"menu_icon\";s:0:\"\";s:8:\"supports\";a:3:{i:0;s:5:\"title\";i:1;s:6:\"editor\";i:2;s:9:\"thumbnail\";}s:10:\"taxonomies\";a:0:{}s:6:\"labels\";a:23:{s:9:\"menu_name\";s:0:\"\";s:9:\"all_items\";s:0:\"\";s:7:\"add_new\";s:0:\"\";s:12:\"add_new_item\";s:0:\"\";s:9:\"edit_item\";s:0:\"\";s:8:\"new_item\";s:0:\"\";s:9:\"view_item\";s:0:\"\";s:10:\"view_items\";s:0:\"\";s:12:\"search_items\";s:0:\"\";s:9:\"not_found\";s:0:\"\";s:18:\"not_found_in_trash\";s:0:\"\";s:17:\"parent_item_colon\";s:0:\"\";s:14:\"featured_image\";s:0:\"\";s:18:\"set_featured_image\";s:0:\"\";s:21:\"remove_featured_image\";s:0:\"\";s:18:\"use_featured_image\";s:0:\"\";s:8:\"archives\";s:0:\"\";s:16:\"insert_into_item\";s:0:\"\";s:21:\"uploaded_to_this_item\";s:0:\"\";s:17:\"filter_items_list\";s:0:\"\";s:21:\"items_list_navigation\";s:0:\"\";s:10:\"items_list\";s:0:\"\";s:10:\"attributes\";s:0:\"\";}s:15:\"custom_supports\";s:0:\"\";}}', 'yes'),
('6074', 'cptui_taxonomies', 'a:2:{s:11:\"video_types\";a:21:{s:4:\"name\";s:11:\"video_types\";s:5:\"label\";s:11:\"Video Types\";s:14:\"singular_label\";s:10:\"Video Type\";s:11:\"description\";s:0:\"\";s:6:\"public\";s:4:\"true\";s:12:\"hierarchical\";s:4:\"true\";s:7:\"show_ui\";s:4:\"true\";s:12:\"show_in_menu\";s:4:\"true\";s:17:\"show_in_nav_menus\";s:4:\"true\";s:9:\"query_var\";s:4:\"true\";s:14:\"query_var_slug\";s:0:\"\";s:7:\"rewrite\";s:4:\"true\";s:12:\"rewrite_slug\";s:0:\"\";s:17:\"rewrite_withfront\";s:1:\"1\";s:20:\"rewrite_hierarchical\";s:1:\"0\";s:17:\"show_admin_column\";s:4:\"true\";s:12:\"show_in_rest\";s:5:\"false\";s:18:\"show_in_quick_edit\";s:0:\"\";s:9:\"rest_base\";s:0:\"\";s:6:\"labels\";a:18:{s:9:\"menu_name\";s:0:\"\";s:9:\"all_items\";s:0:\"\";s:9:\"edit_item\";s:0:\"\";s:9:\"view_item\";s:0:\"\";s:11:\"update_item\";s:0:\"\";s:12:\"add_new_item\";s:0:\"\";s:13:\"new_item_name\";s:0:\"\";s:11:\"parent_item\";s:0:\"\";s:17:\"parent_item_c